<?php
class ApplicationController extends FrontEndController
{
	private $_response = array();

	public function filters()
	{
		return array_merge(parent::filters(), array(
			'ajaxOnly + short',
			'postOnly + short',
		));
	}

	public function actionIndex()
	{
		$limit = 10;
		$recent = Shortlink::getRecent($limit);
		$top = Shortlink::getTop($limit);
		$totalUrl = Shortlink::model()->cache(1000)->count();
		$totalHits =  Shortlink::model()->cache(1000)->totalHits();
		$today = Shortlink::model()->cache(1000)->getToday();

		$this->render('index', array(
			'top'=>$top,
			'recent'=>$recent,
			'totalUrls'=>$totalUrl,
			'totalHits'=>$totalHits,
			'today'=>$today,
		));
	}

	public function actionShort()
	{
        $url = Yii::app()->request->getPost('url');
        $validator = new UrlValidator;
		if(!$validator->validateValue($url)) {
			$this->_response(array('error'=>true));
		}
        if(Helper::sameHost($url)) {
            $this->_response(array('error'=>true));
        }

		$scheme = parse_url($url, PHP_URL_SCHEME);
		if(empty($scheme))
			$url = 'http://'.$url;
		
		$transaction = Yii::app()->db->beginTransaction();
		try {
			if(!$short = Shortlink::alreadyExists($url)) {
				$id = Shortlink::model()->insertLink($url);
				$shortLink = Yii::app()->shortlink->shortByID($id);
				Shortlink::model()->updateLinkByID($id, $shortLink);
				
			} else {
				$shortLink = $short["UrlShort"];
			}
			Shortlink::increaseStat();
			$transaction->commit();
		} catch(Exception $e) {
			$transaction->rollback();
			$this->_response(array('error'=>true));
		}
		
		$this->_response(array(
			'url'=>$url,
			'shortlink'=>$this->createAbsoluteUrl("/", array($shortLink=>null)),
		));
	}

	public function actionRedirect($shortid = null)
	{
		$seconds = Basic::model()->get('Redirect');
		$id = Yii::app()->shortlink->getID($shortid);
		if(!$url = Shortlink::model()->findByPk($id)) {
			throw new CHttpException(404,'The specified post cannot be found.');
		}
		$url->saveCounters(array('Hits'=>1));
		$this->title = sprintf(Lang::model()->get('Redirect_Title'), $url['Url']);
		if((int)$seconds > 0)
		{
			$this->layout = 'redirect_column';
			$this->render('redirect', array(
				'seconds'=>$seconds,
				'url'=>$url['Url'],
			));
		}
		else
		{
            //header("Content-type: text/html; charset=utf-8");
            //echo '<html><head><script type="text/javascript">document.location.href = "'. Helper::safeJs($url['Url']) .'"</script></head></html>';
			//exit(0);
            $this->redirect($url['Url']);
		}
	}

	public function actionError()
	{
		if(!$error=Yii::app()->errorHandler->error) {
			return true;
		}
		if(Yii::app()->request->isAjaxRequest) {
			echo $error['message'];
			exit(0);
		}
		
		$this->render('error', array(
			'title'=>$error['code'] == 404 ? Lang::model()->get('404_Title') : $error['code'],
			'description'=>$error['code'] == 404 ? Lang::model()->get('404_Description') : $error['message'],
		));
	}

	private function _response($response)
	{
		header('Content-type: application/json');
		echo json_encode($response);
		Yii::app()->end();
	}
}