<?php
class ApiController extends FrontEndController
{
	private $_response = array();
	private $_method;
	private $_url;
	private $_error = array();
	
	const RESPONSE_PREFIX = 'response';
	
	public function init()
	{
		$this->_url = Yii::app()->getRequest()->getQuery('url');
		$scheme = parse_url($this->_url, PHP_URL_SCHEME);
		if(empty($scheme))
			$this->_url = 'http://'.$this->_url;
		$method = isset($_GET['method']) ? self::RESPONSE_PREFIX.strtoupper($_GET['method']) : null;
		$this->_method = method_exists($this, $method) ? $method : "responseJSON";
	}
	
	public function actionIndex()
	{
		$validator = new UrlValidator;
		if(!$validator->validateValue($this->_url)) {
			$this->_error[] = 'Invalid URL';
			$this->_end(true);
		}
        if(Helper::sameHost($this->_url)) {
            $this->_error[] = 'Invalid URL';
            $this->_end(true);
        }

		$transaction = Yii::app()->db->beginTransaction();
		try {
			if(!$short = Shortlink::alreadyExists($this->_url)) {
				$id = Shortlink::model()->insertLink($this->_url);
				$shortLink = Yii::app()->shortlink->shortByID($id);
				Shortlink::model()->updateLinkByID($id, $shortLink);
			} else {
				$shortLink = $short["UrlShort"];
			}
			Shortlink::increaseStat();
			$transaction->commit();
		} catch (Exception $e) {
			$transaction->rollback();
			$this->_error[] = 'Error while inserting data';
			$this->_end(true);
		}
		$this->_response = array(
			'long'=>$this->_url,
			'short'=>$this->createAbsoluteUrl("/", array($shortLink=>null)),
		);
		$this->_end();
	}
	
	private function responseJSON(array $response)
	{
		header('Content-Type: application/json');
		echo json_encode($response);
	}
	
	private function responseXML(array $response)
	{
		header('Content-type: text/xml');
		echo "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<response>\n";
		foreach($response as $k=>$r) {
			if(is_numeric($k)) {
				echo "<error>".htmlspecialchars($r)."</error>\n";
			} else {
				echo "<{$k}>".htmlspecialchars($r)."</{$k}>\n";
			}
		}
		echo "</response>\n";
	}
	
	private function responseARRAY(array $response)
	{
		header('Content-type: text/html');
		echo serialize($response);
	}
	
	private function _end($error = false)
	{
		if($error)
			call_user_func_array(array($this, $this->_method), array($this->_error));
		else
			call_user_func_array(array($this, $this->_method), array($this->_response));
		exit(0);
	}
}