<?php
class SettingsController extends BackEndController
{
	public function actionBasic()
	{
		$model = Basic::model()->find();
		if(isset($_POST['Basic']))
		{
			$model->attributes = $_POST['Basic'];
			if($model->save())
				Yii::app()->user->setFlash("success", "Your changes has been successfully saved");
			$this->refresh();
		}

		$this->render("basic", array(
			'model'=>$model,
		));
	}

	public function actionShare()
	{
		$model = Share::model()->find();
		$like = Like::model()->findAll();

		if(isset($_POST['Share']))
		{
			$model->attributes = $_POST['Share'];

			if(empty($model->Image))
				$model->Image = CUploadedFile::getInstance($model, 'Image');

			if($model->save())
			{
				if(is_object($model->Image))
				{
					$name = $model->imagePath.$model->imageName.'.'.$model->Image->extensionName;
					$model->Image->saveAs($name);
					$model->Image = $name;
					$model->save();
				}
				Yii::app()->user->setFlash("success", "Your changes has been successfully saved");
				$this->refresh();
			}
		}

		$this->render("share", array(
			'share'=>$model,
			'likeModel'=>$like,
		));
	}

	public function actionLike()
	{
		if(isset($_POST['Like']))
		{
			if(!$model = Like::model()->findByPk($_POST['Like']['service']))
			{
				Yii::app()->user->setFlash("notice", "Undefined social button");
				$this->redirect(Yii::app()->request->getUrlReferrer());
			}
			$model->Locale = $_POST['Like']['Locale'];
			$model->save();
			Yii::app()->user->setFlash("success", "The changes have been saved");
			$this->redirect(Yii::app()->request->getUrlReferrer());
		}
	}

	public function actionLikeSwitch()
	{
		if(isset($_POST['Like']))
		{
			if(!$model = Like::model()->findByPk($_POST['Like']['service']))
			{
				Yii::app()->user->setFlash("notice", "Invalid like button");
				$this->redirect(Yii::app()->request->getUrlReferrer());
			}
			$message = $_POST['Like']['switch'] ? "enabled" : "disabled";
			$service = ucfirst($_POST['Like']['service']);
			$model->Enabled = $_POST['Like']['switch'];
			$model->save();
			Yii::app()->user->setFlash("success", "{$service} button have been {$message}");
			$this->redirect(Yii::app()->request->getUrlReferrer());
		}
	}

	public function actionDisableSocial()
	{
		$model = Share::model()->find();

		if(isset($_POST['switch']))
		{
			$message = $_POST['switch'] ? "enabled" : "disabled";
			$model->Enabled = $_POST['switch'];
			$model->save();
			Yii::app()->user->setFlash("success", "Og Meta Properties have been $message");
			$this->redirect(Yii::app()->request->getUrlReferrer());
		}
	}

	public function actionRemoveSocialImage()
	{
		$model = Share::model()->find();
		if(!empty($model->Image))
		{
			if(file_exists($model->Image))
				unlink($model->Image);
			$model->Image = null;
			$model->save();
		}
		Yii::app()->user->setFlash("success", "Image was successfully removed");
		$this->redirect(Yii::app()->request->getUrlReferrer());
	}

	public function actionLang()
	{
		$items = Lang::model()->findAll(array('index'=>'ID'));

		$update = array();
		if(isset($_POST['Lang']))
		{
			foreach($_POST['Lang'] as $i=>$item)
			{
				$data[$i] = $_POST['Lang'][$i]['Value'];
			}
			Lang::model()->updateLangs($data);
			Yii::app()->user->setFlash("success", "Your changes has been successfully saved");
			$this->refresh();
		}

		$this->render("lang", array(
			'items'=>$items,
		));
	}

	public function actionAdmin()
	{
		$admin = Admin::model()->find();
		if(isset($_POST['Admin']))
		{
			$admin->attributes = $_POST['Admin'];
			if($admin->save())
			{
				Yii::app()->user->setFlash("success", "Your changes has been successfully saved");
				Yii::app()->user->setFlash("notice", "You have to logout to apply changes");
				$this->refresh();
			}
		}

		$this->render("admin", array(
			'admin'=>$admin,
		));
	}
}
