<?php

// uncomment the following to define a path alias
// Yii::setPathOfAlias('local','path/to/local-folder');

// This is the main Web application configuration. Any writable
// CWebApplication properties can be configured here.
return array(
	'basePath'=>dirname(__FILE__).DIRECTORY_SEPARATOR.'..',
	'name'=>'Url Shortener',
	'defaultController'=>'Application',
	// preloading 'log' component
	'preload'=>array('log'),

	// autoloading model and component classes
	'import'=>array(
		'application.models.*',
		'application.components.*',
	),

	'behaviors'=>array(
		'runEnd'=>array(
			'class'=>'application.behaviors.WebApplicationEndBehavior'
		),
	),

	// application components
	'components'=>array(
		'user'=>array(
			// enable cookie-based authentication
			'allowAutoLogin'=>true,
			'loginUrl'=>array('auth/login'),
		),

		'shortlink'=>array(
			'class'=>'CShortlink',
		),

		'urlManager'=>array(
			'urlFormat'=>'path',
			'showScriptName'=>false,
            'routeVar'=>'ar',
			'rules'=>array(
				'short'=>'application/short',
				'api'=>'api/index',
				'statistics'=>'stat/index',
				'admin'=>'application/index',
				'admin/login'=>'application/login',
				'admin/social'=>'social/index',
				'admin/edit/<id:\d+>'=>'application/edit',
				'admin/delete/<id:\d+>'=>'application/delete',
				'admin/login'=>'auth/login',
				'admin/logout'=>'auth/logout',
				'admin/settings/basic'=>'settings/basic',
				'admin/settings/share'=>'settings/share',
				'admin/settings/like'=>'settings/like',
				'admin/settings/likeswitch'=>'settings/likeswitch',
				'admin/settings/disablesocial'=>'settings/disablesocial',
				'admin/settings/removesocialimage'=>'settings/removesocialimage',
				'admin/settings/lang'=>'settings/lang',
				'admin/settings/admin'=>'settings/admin',
				'<shortid:\w+>'=>'application/redirect',
			),
		),

		'db'=>include 'db.php',

		'cache'=>array(
			'class'=>'CFileCache',
		),

		'errorHandler'=>array(
			'errorAction'=>'application/error',
		),

		'log'=>array(
			'class'=>'CLogRouter',
			'routes'=>array(
				array(
					'class'=>'CFileLogRoute',
					'levels'=>'error, warning',
					'enabled'=>true,
				),
				/*array(
					'class'=>'CWebLogRoute',
				),*/
			),
		),
	),

	'params'=>array(
	),
);