<?php

class UserIdentity extends CUserIdentity
{
	private $_id;

	const ERROR_L_OR_P_INVALID = 3;

	public function authenticate()
	{
		$admin = Admin::model()->getAdmin($this->username, $this->password);
		
		if($admin == null)
		{
			$this->errorCode = self::ERROR_L_OR_P_INVALID;
		}
		else
		{
			$this->_id = $admin->login;
			$this->setState('name', $admin->name);
			$this->errorCode = self::ERROR_NONE;
		}

		return !$this->errorCode;
	}

	public function getId()
	{
		return $this->_id;
	}
}