<?php
class Helper {
    public static function safeJs($str) {
        $str = str_replace("\\", "\\\\", $str);
        $str = str_replace("'", "\\'", $str);
        $str = str_replace("\"", "\\\"", $str);
        $str = str_replace("<", "\\<", $str);
        $str = str_replace(">", "\\>", $str);
        return $str;
    }

    public static function sameHost($url) {
        $sUrl = Yii::app()->getBaseUrl(true);
        $parts = explode("?", $url);
        $xUrl = isset($parts[0]) ? self::removeProtocol($parts[0]) : self::removeProtocol($url);
        $sUrl = self::removeProtocol($sUrl);
        return stripos($xUrl."/", $sUrl."/") === 0;
    }

    public static function removeProtocol($url) {
        return preg_replace("#^[\w]+:\/\/#i", "", $url, 1);
    }
} 