<?php
class FrontEndController extends CController
{
	public $layout = 'main_column';
	public $breadcrumbs = array();
	public $menu = array();
	public $title;
	
	public function filters() {
		return array(
			array('application.components.ShortUrlAccessFilter'),
		);
	}
	
	public function init()
	{
		$this->title = Basic::model()->get('Title');
		Lang::model()->set('front');
		parent::init();
        $this->registerCookieDisclaimer();
	}

    protected function registerCookieDisclaimer() {
        $cookieLawConf = require_once Yii::getPathOfAlias("application.config.cookie_law").".php";

        if(Yii::app()->request->isAjaxRequest OR !$cookieLawConf['show']) {
            return true;
        }

        /**
         * @var $cs CClientScript
         */
        $cs = Yii::app()->clientScript;
        $cs->registerScriptFile(Yii::app()->request->getBaseUrl(true)."/js/cookieconsent.latest.min.js", CClientScript::POS_END);
        $cs->registerScript("cookieconsent", "
			window.cookieconsent_options = {
				learnMore: ".CJavaScript::encode($cookieLawConf['learnMore']).",
				dismiss: ". CJavaScript::encode($cookieLawConf['dismiss']).",
				message: ". CJavaScript::encode($cookieLawConf['message']).",
				theme:". CJavaScript::encode($cookieLawConf['theme']).",
				link: ". CJavaScript::encode($cookieLawConf['link']).",
				path: ". CJavaScript::encode($cookieLawConf['path']).",
				expiryDays: ". CJavaScript::encode($cookieLawConf['expiryDays'])."
			};
		", CClientScript::POS_HEAD);
        $cs->registerCss("hide_cookie_law_logo", "
            .cc_logo { display: none !important; }
        ");
        return true;
    }
}