<?php
class CShortlink extends CApplicationComponent
{
	private $_characters;
	private $_length;

  public function init()
  {
		$this->_characters = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789";
		$this->_length = strlen($this->_characters);
  }

  public function shortByID($id)
  {
		$digits = array();
		$string = '';
		while($id > 0)
		{
			$modulo = fmod($id, $this->_length);
			array_push($digits, $modulo);
			$id = floor($id / $this->_length);
		}
		$digits = array_reverse($digits);
		foreach($digits as $digit)
		{
			$string .= $this->_characters[(int)$digit];
		}
		return $string;
  }

  public function getID($short)
  {
		$id = 0;
		$len = strlen((string)$short);
		$power = $len - 1;
		for($i = 0; $i < $len; $i++)
		{
			$pos = strpos($this->_characters, $short[$i]);
			$id += $pos * pow($this->_length, $power);
			$power--;
		}
		return $id;
  }
}