$(function () {
    
    // Avatar upload form
    $('.avatar-form').ajaxForm({

        url: Ajaxrequest() + '?t=avatar&a=new', 
        beforeSend: function() {
            form = $('.avatar-form');
            avatar_btn = form.find('#avatar-btn');
            image_loader = $('.tumd-loader');
            uploadInput  = $('.avatar-upload-door');
            image_loader.show();
            avatar_btn.attr('disabled', true);
        },
        success: function(data) {
            image_loader.hide();
            $('.loading').remove();

            if (data.status == 200) {
                Toast.success(data.success_message);
                $('.tumd-avatar').attr('src', data.avatar_url);
                uploadInput.replaceWith(uploadInput.val('').clone(true));
            }
            else {
                Toast.error(data.error_message);
                uploadInput.replaceWith(uploadInput.val('').clone(true));
            }
            avatar_btn.attr('disabled', false);
        }
    });

    // Configuration setting form
    $('form.update-user-info').ajaxForm({
        url: Ajaxrequest()+'?t=user&a=info',
        success: function (data) {
            if (data.status == 200) {
                Toast.success(data.success_message);
            }
            else {
                Toast.error(data.error_message);
            }
        },
        error: function() {
            Toast.error('Error connecting to server...');
        }
    });

    // Theme setting form
    $(document).on('click', '#theme-check', function(){
        $('.theme_active').removeClass('theme_active');
        var __tCL = $(this);
        var __tCL_dt = $(__tCL).attr('data-theme-id');
        $('.theme-chk-'+__tCL_dt).addClass('theme_active');
    });

    $('form.theme-form').ajaxForm({
        url: Ajaxrequest()+'?t=user&a=update_theme',
        success: function (data) {
            if (data.status == 200) {
                Toast.success(data.success_message);
            }
        },
        error: function() {
            Toast.error('Error connecting to server...');
        }
    });

    // Change Password form
    $('form.update-user-password').ajaxForm({
        url: Ajaxrequest()+'?t=user&a=password',
        success: function (data) {
            if (data.status == 200) {
                Toast.success(data.success_message);
            }
            else {
                Toast.error(data.error_message);
            }
        },
        error: function() {
            Toast.error('Error connecting to server...');
        }
    });

    // View logs
    function log_viewmore(){
        var $loadingGif = $('#logs-loader');
        var $viewmore = $('#logs-viewmore');
        var init = $('#tumd-logs-content .log-card-container').length;

        $loadingGif.on('ajaxStart', function(){
           $(this).show();
           $viewmore.hide();
        });
   
        $loadingGif.on('ajaxStop', function(){
           $(this).hide();
        });

        $.ajax({
            url: Ajaxrequest() + '?t=user&a=logs',
            type: 'POST',
            data: 'init=' + init,
            dataType: "json",
            success: function(data){
                addLogs(data.logs_data);
                if( data.c_log_rest > 0){
                    $viewmore.show();
                }
            },
            error: function(){
                console.log('Failed connection');
            }
        });
    }

    function addLogs(log_Data){
        var $log_parent_container = $('#tumd-logs-content');

        for( var i = 0; i < log_Data.length; i++){
            var $logContainer = $('<div> </div>');
            var $logContent   = $('<div> </div>');
            var $logType  = $('<img class="log-data-icon">');
            var imgSrc = siteUrl+'/static/libs/images/' + log_Data[i].log_type + '.png';
            var $Log_Data = $('<div>');
            var $Log_Date = $('<div>');

            $logContainer.addClass('log-card-container');
            $logContent.addClass('log-data-content');
            $Log_Data.addClass('log-data-info');
            $Log_Date.addClass('log-data-date');
            $logType.attr('src', imgSrc);
            $Log_Data.text( log_Data[i].log_text );
            $Log_Date.text( log_Data[i].log_date );
            $logContent.append($logType);
            $logContent.append($Log_Data);
            $logContent.append($Log_Date);
            $logContainer.append($logContent);
            $log_parent_container.append($logContainer);
        }
    }

    $(document).ready(function(){
       log_viewmore();
       $('#logs-viewmore').on('click', function(e){
            e.preventDefault();
            log_viewmore();
       });
    });

    // Favorite
    $(document).ready(function(){
        $(document).on('click', '#fav-btn', function(){
            ajaxFav($(this).attr('data-game'));
        });

        function ajaxFav(game_id) {
            $.ajax({
                url: Ajaxrequest() + '?t=update_favourite',
                type: 'POST',
                data: "id=" + game_id,
                success: function(data) {
                    favorite_id = $('#fav-btn');
                    if (favorite_id.hasClass('fav-added')) {
                        favorite_id.removeClass('fav-added');
                    } else {
                        favorite_id.addClass('fav-added');
                        swal({
                            title: null,
                            text: data.success_message,
                            timer: 2300,
                            html: true
                        });
                    }
                }
            });
        }
    });

});