<?php
/**
* Tumder Project - A platform for the fun
* @copyright (c) 2016 Loois Sndr. All rights reserved.
*
* @author Loois Sndr
* @since 2016
*/
require_once( dirname(dirname( __FILE__ )) . '/td-load.php');
include_once( dirname(dirname( __FILE__ )) . '/install/install-process.php');

$o = '';

if (isset($_GET['o'])) {
    $o = secureEncode($_GET['o']);
}

$data = array('status' => 470);

if ($o == 'db_install') {
	if (isset($_POST['db_host']) && !empty($_POST['db_host']) && isset($_POST['db_name']) && !empty($_POST['db_name']) && isset($_POST['db_user']) && !empty($_POST['db_user']) && isset($_POST['db_password'])) {
		$DB_HOST = secureEncode($_POST['db_host']);
		$DB_NAME = secureEncode($_POST['db_name']);
		$DB_USER = secureEncode($_POST['db_user']);
		$DB_PASS = secureEncode($_POST['db_password']);
		$DB_Tumd = @new mysqli($DB_HOST, $DB_USER, $DB_PASS, $DB_NAME);

		if (!$DB_Tumd->connect_errno) {
			if ($step_process["step1"] == false) {
			/*
			* Installing database tables
			*/
			$DB_Tumd->query("CREATE TABLE IF NOT EXISTS `tumd_account` (
				`id` int(11) NOT NULL AUTO_INCREMENT,
				`name` text NOT NULL,
				`username` varchar(100) CHARACTER SET utf8 NOT NULL,
				`password` varchar(100) CHARACTER SET utf8 NOT NULL,
				`admin` enum('0','1') NOT NULL DEFAULT '0',
				`secret_sid` varchar(100) CHARACTER SET utf8 NOT NULL,
				`email` varchar(100) CHARACTER SET utf8 NOT NULL,
				`avatar_id` int(11) NOT NULL,
				`xp` int(11) NOT NULL,
				`language` varchar(30) CHARACTER SET utf8 NOT NULL,
				`profile_theme` varchar(30) CHARACTER SET utf8 NOT NULL DEFAULT 'style-1',
				`ip` varchar(50) CHARACTER SET utf8 NOT NULL,
				`registration_date` int(11) NOT NULL,
				`last_logged` int(11) NOT NULL,
				`last_update_info` int(11) NOT NULL,
				`active` enum('1','0') NOT NULL,
				PRIMARY KEY (`id`)
				) ENGINE=InnoDB DEFAULT CHARSET=latin1 AUTO_INCREMENT=2");
			$DB_Tumd->query("CREATE TABLE IF NOT EXISTS `tumd_ads` (
				`id` int(11) NOT NULL,
				`header` varchar(400) CHARACTER SET utf8 NOT NULL,
				`footer` varchar(400) CHARACTER SET utf8 NOT NULL,
				`column_one` varchar(400) CHARACTER SET utf8 NOT NULL,
				`gametop` varchar(400) CHARACTER SET utf8 NOT NULL,
				`gamebottom` varchar(400) CHARACTER SET utf8 NOT NULL,
				`gameinfo` varchar(400) CHARACTER SET utf8 NOT NULL,
				PRIMARY KEY (`id`)
				) ENGINE=InnoDB DEFAULT CHARSET=latin1");
			$DB_Tumd->query("CREATE TABLE IF NOT EXISTS `tumd_categories` (
				`id` int(11) NOT NULL AUTO_INCREMENT,
				`category_pilot` varchar(100) CHARACTER SET utf8 NOT NULL,
				`name` text NOT NULL,
				PRIMARY KEY (`id`)
				) ENGINE=InnoDB DEFAULT CHARSET=latin1 AUTO_INCREMENT=1");
			$DB_Tumd->query("CREATE TABLE IF NOT EXISTS `tumd_favourites` (
				`id` int(11) NOT NULL AUTO_INCREMENT,
				`user_id` int(11) NOT NULL,
				`game_id` int(11) NOT NULL,
				`date_added` int(11) NOT NULL,
				`type` enum('favorite','played') NOT NULL,
				PRIMARY KEY (`id`)
				) ENGINE=InnoDB DEFAULT CHARSET=latin1 AUTO_INCREMENT=1");
			$DB_Tumd->query("CREATE TABLE IF NOT EXISTS `tumd_feed_one` (
				`id` int(11) NOT NULL AUTO_INCREMENT,
				`gid` varchar(100) CHARACTER SET utf8 NOT NULL,
				`name` varchar(100) CHARACTER SET utf8 NOT NULL,
				`description` varchar(100) CHARACTER SET utf8 NOT NULL,
				`instruction` varchar(100) CHARACTER SET utf8 NOT NULL,
				`category` varchar(100) CHARACTER SET utf8 NOT NULL,
				`image` varchar(100) CHARACTER SET utf8 NOT NULL,
				`file` varchar(100) CHARACTER SET utf8 NOT NULL,
				`w` int(11) NOT NULL,
				`h` int(11) NOT NULL,
				`game_type` varchar(100) CHARACTER SET utf8 NOT NULL,
				`pilot` varchar(100) CHARACTER SET utf8 NOT NULL,
				PRIMARY KEY (`id`)
				) ENGINE=InnoDB DEFAULT CHARSET=latin1 AUTO_INCREMENT=1");
			$DB_Tumd->query("CREATE TABLE IF NOT EXISTS `tumd_games` (
				`game_id` int(11) NOT NULL AUTO_INCREMENT, 
				`catalog_id` varchar(100) CHARACTER SET utf8 NOT NULL,
				`name` varchar(100) NOT NULL,
				`image` varchar(500) NOT NULL,
				`import` enum('0','1') NOT NULL DEFAULT '0',
				`category` int(11) NOT NULL,
				`plays` int(11) NOT NULL,
				`rating` enum('0','0.5','1','1.5','2','2.5','3','3.5','4','4.5','5') NOT NULL DEFAULT '0',
				`description` varchar(600) NOT NULL,
				`instructions` varchar(600) NOT NULL,
				`file` varchar(100) CHARACTER SET utf8 NOT NULL,
				`game_type` varchar(20) CHARACTER SET utf8 NOT NULL,
				`w` int(10) NOT NULL,
				`h` int(10) NOT NULL,
				`date_added` int(11) NOT NULL,
				`published` enum('0','1') NOT NULL,
				`featured` enum('0','1') NOT NULL DEFAULT '0',
				PRIMARY KEY (`game_id`)
				) ENGINE=InnoDB DEFAULT CHARSET=latin1 AUTO_INCREMENT=1");
			$DB_Tumd->query("CREATE TABLE IF NOT EXISTS `tumd_media` (
				`id` int(255) NOT NULL AUTO_INCREMENT,
				`name` varchar(100) CHARACTER SET utf8 NOT NULL,
				`extension` varchar(4) COLLATE utf8_unicode_ci NOT NULL DEFAULT 'none',
				`type` varchar(255) COLLATE utf8_unicode_ci NOT NULL DEFAULT 'none',
				`url` varchar(100) COLLATE utf8_unicode_ci NOT NULL,
				PRIMARY KEY (`id`)
				) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=1");
			$DB_Tumd->query("CREATE TABLE IF NOT EXISTS `tumd_reports` (
				`report_id` int(11) NOT NULL AUTO_INCREMENT,
				`id_reported` int(11) NOT NULL,
				`user_id` int(11) NOT NULL,
				`report_info` varchar(100) CHARACTER SET utf8 NOT NULL,
				`report_date` int(11) NOT NULL,
				PRIMARY KEY (`report_id`)
				) ENGINE=InnoDB DEFAULT CHARSET=latin1 AUTO_INCREMENT=1");
			$DB_Tumd->query("CREATE TABLE IF NOT EXISTS `tumd_setting` (
				`id` int(11) NOT NULL AUTO_INCREMENT,
				`admin_pin` varchar(100) CHARACTER SET utf8 NOT NULL,
				`site_name` varchar(100) CHARACTER SET utf8 NOT NULL,
				`site_url` varchar(50) CHARACTER SET utf8 NOT NULL,
				`site_theme` varchar(100) CHARACTER SET utf8 NOT NULL,
				`site_maintenance` enum('0','1') NOT NULL DEFAULT '0',
				`maintenance_msg` varchar(100) CHARACTER SET utf8 NOT NULL DEFAULT 'We are under maintencance',
				`site_description` varchar(150) CHARACTER SET utf8 NOT NULL DEFAULT 'Tumder Platform - A platform for the fun',
				`site_keywords` varchar(150) CHARACTER SET utf8 NOT NULL DEFAULT 'games, puzzle, arcade',
				`ads_status` enum('0','1') NOT NULL DEFAULT '0',
				`ad_time` int(11) NOT NULL DEFAULT '10',
				`language` varchar(100) CHARACTER SET utf8 NOT NULL,
				`featured_game_limit` int(11) NOT NULL,
				`mp_game_limit` int(11) NOT NULL,
				`xp_play` int(11) NOT NULL,
				`xp_report` int(11) NOT NULL,
				`xp_register` int(11) NOT NULL,
				PRIMARY KEY (`id`)
				) ENGINE=InnoDB DEFAULT CHARSET=latin1 AUTO_INCREMENT=2");
			$DB_Tumd->query("CREATE TABLE IF NOT EXISTS `tumd_theme` (
				`theme_id` int(11) NOT NULL AUTO_INCREMENT,
				`theme_class` varchar(50) CHARACTER SET utf8 NOT NULL,
				PRIMARY KEY (`theme_id`),
  				UNIQUE KEY `theme_class` (`theme_class`),
  				UNIQUE KEY `theme_class_3` (`theme_class`),
  				KEY `theme_class_2` (`theme_class`)
				) ENGINE=InnoDB DEFAULT CHARSET=latin1 AUTO_INCREMENT=14");
			$DB_Tumd->query("CREATE TABLE IF NOT EXISTS `tumd_userlogs` (
				`log_id` int(11) NOT NULL AUTO_INCREMENT,
				`user_id` int(11) NOT NULL,
				`log_text` text NOT NULL,
				`log_type` enum('login','game','info','avatar','other') CHARACTER SET utf8 NOT NULL DEFAULT 'other',
				`log_date` text NOT NULL,
				`log_data` int(11) NOT NULL,
				PRIMARY KEY (`log_id`)
				) ENGINE=InnoDB DEFAULT CHARSET=latin1 AUTO_INCREMENT=1");
			$DB_Tumd->query("CREATE TABLE IF NOT EXISTS `tumd_users` (
				`user_id` int(11) NOT NULL,
				`gender` enum('1','2') NOT NULL DEFAULT '1',
				`about` text NOT NULL,
				UNIQUE KEY `user_id` (`user_id`)
				) ENGINE=InnoDB DEFAULT CHARSET=latin1");
			$DB_Tumd->query("INSERT INTO `tumd_theme` (`theme_id`, `theme_class`) VALUES
				(1, 'style-1'),
				(11, 'style-1-image'),
				(5, 'style-2'),
				(12, 'style-2-image'),
				(6, 'style-3'),
				(13, 'style-3-image'),
				(7, 'style-4'),
				(8, 'style-5'),
				(9, 'style-6'),
				(10, 'style-7')");
			$DB_Tumd->query("INSERT INTO `tumd_categories` (`id`, `category_pilot`, `name`) VALUES (1, 'default', 'Default')");
			$DB_Tumd->query("INSERT INTO `tumd_setting` (`id`, `admin_pin`, `site_name`, `site_url`, `site_theme`, `site_maintenance`, `maintenance_msg`, `site_description`, `site_keywords`, `ads_status`, `ad_time`, `language`, `featured_game_limit`, `mp_game_limit`, `xp_play`, `xp_report`, `xp_register`) VALUES (1, '1234', 'Tumder', '', 'tumder', '0', 'We are under maintencance!', 'Tumder - A platform for the fun', 'games, puzzle, arcade', '0', 10, 'english', 8, 8, 50, 100, 10)");
			$DB_Tumd->query("INSERT INTO `tumd_ads` (`id`, `header`, `footer`, `column_one`, `gametop`, `gamebottom`, `gameinfo`) VALUES
				(1, 'Ads 1', 'Ads 2', 'Ads 3', 'Ads 4', 'Ads 5', 'Ads 6')");
			
			/*
			* Writing connection data in config.php
			*/
			$db_config = '<?php
	/**
	* @global Parameters of database connection 
	*/

	// Host name
	$dbTumd[\'host\'] = "'.$DB_HOST.'";

	// Database name
	$dbTumd[\'name\'] = "'.$DB_NAME.'";

	// Host user name
	$dbTumd[\'user\'] = "'.$DB_USER.'";

	// Host password
	$dbTumd[\'pass\'] = "'.$DB_PASS.'";

	/* Password encrypter *NOT REMOVE* */
	$encryption = "vmbtrvw95105595885345**#3738s**A";';
			$db_config_file = fopen(dirname(dirname( __FILE__ )) . "/assets/includes/config.php", "w+");
			fwrite($db_config_file, $db_config);
			fclose($db_config_file);
			/*
			* 
			*/
			$pcs = '<?php
	$step_process = array();
	$step_process[\'step1\'] = true;
	$step_process[\'step2\'] = false;';
			$pcs_file = fopen(dirname(dirname( __FILE__ )) . "/install/install-process.php", "w+");
			fwrite($pcs_file, $pcs);
			fclose($pcs_file);

			$data['status'] = 200;
			} else { $data['message_error'] = 'You already installed the database'; }
		} else { $data['message_error'] = 'Database connection error'; }
	} else { $data['message_error'] = 'Some fields are empty'; }

	header("Content-type: application/json");
    echo json_encode($data);
    exit();
}

if ($o == 'db_account') {
	if (isset($_POST['user']) && isset($_POST['password']) && isset($_POST['site_name']) && isset($_POST['site_url']) && isset($_POST['pin']) && !empty($_POST['user']) && !empty($_POST['password']) && !empty($_POST['site_name']) && !empty($_POST['site_url'])) {
		$account = array();
		$account['user'] = secureEncode($_POST['user']);
		$account['password'] = secureEncode($_POST['password']);
		$account['key'] = sha1(str_rot13($account['password'] . $encryption));
		$account['site_name'] = secureEncode($_POST['site_name']);
		$account['site_url'] = secureEncode($_POST['site_url']);
		$account['pin'] = secureEncode($_POST['pin']);

		if ($step_process["step2"] == false) {

		$Tumdconnect->query("INSERT INTO `".ACCOUNTS."` (`id`, `name`, `username`, `password`, `admin`, `secret_sid`, `email`, `avatar_id`, `xp`, `language`, `profile_theme`, `ip`, `registration_date`, `last_logged`, `last_update_info`, `active`) VALUES
			(1, 'Administrator', '{$account['user']}', '{$account['key']}', '1', '', 'admin@admin.com', 0, 0, '::1', 'style-1', '', 1478417322, 0, 1478417413, '1')");
		$Tumdconnect->query("INSERT INTO `".USERS."` (`user_id`, `gender`, `about`) VALUES (1, '1', '')");
		$Tumdconnect->query("UPDATE ".SETTING." SET site_name='{$account['site_name']}', site_url='{$account['site_url']}', admin_pin='{$account['pin']}' WHERE id='1'");

		$install_config = '<?php 
	/* Check install */
	$install_status = true;';
		$install_config_file = fopen(dirname(dirname( __FILE__ )) . "/assets/includes/inc-install.php", "w+");
		fwrite($install_config_file, $install_config);
		fclose($install_config_file);

		/*
		* 
		*/
		$pcs = '<?php
$step_process = array();
$step_process[\'step1\'] = true;
$step_process[\'step2\'] = true;';
		$pcs_file = fopen(dirname(dirname( __FILE__ )) . "/install/install-process.php", "w+");
		fwrite($pcs_file, $pcs);
		fclose($pcs_file);

		$data['status'] = 200;
		} else { $data['message_error'] = 'You have already configured this info'; }
	} else { $data['message_error'] = 'Some fields are empty'; }
	header("Content-type: application/json");
    echo json_encode($data);
    $Tumdconnect->close();
    exit();
}