<?php
if (! isset ( $site )) {
	include 'inc/config.php';
}

// Clean All Possible User Inputs
foreach ( $_GET as $key => $value ) {
	$gets [$key] = filter ( $value );
}
foreach ( $_POST as $key => $value ) {
	$posts [$key] = filter ( $value );
}
foreach ( $_COOKIE as $key => $value ) {
	$cookies [$key] = filter ( $value );
}

// Handle Signup
if (isset ( $_POST ['email'] )) {
	
	if ($_POST ['password'] != $_POST ['password2']) {
		$passwordMismatch = true;
	} else {
		$passwordMismatch = false;
	}
	
	// Hash Password
	$salt = generate_salt ();
	$password = crypt ( $_POST ['password'], $salt );
	
	// Clean user inputs
	$email = mysqli_escape_string ( $mysqli, $posts ['email'] );
	
	// Check for email exists
	$checkForUser = $mysqli->query ( "SELECT id FROM `users` WHERE `email`='" . $email . "'" );
	$checkForUserRows = $checkForUser->num_rows;
	$ip = VisitorIP ();
	
	// Check IP against known addresses
	$checkForIP = $mysqli->query ( "SELECT id FROM `users` WHERE `ip`='" . $ip . "'" );
	$checkForIPRows = $checkForIP->num_rows;
	
	// Check email against banned emails
	if ($email != '') {
		$emex = explode ( "@", $email );
		$emcheck = '@' . $emex [1];
		$ebans = $mysqli->query ( "SELECT * FROM `ban_emails` WHERE `email`='" . $emcheck . "'" );
		$ebanexists = $ebans->num_rows;
	}
	
	// Error Handling
	if ($checkForUserRows != '0') {
		$error = 'This email has already been registered.';
	} else if ($checkForIPRows >= $site ['site_accounts_perip']) {
		$error = 'Your only permitted to have ' . $site ['site_accounts_perip'] . ' account per person.';
	} else if (! isEmail ( $email )) {
		$error = 'Enter a valid email address.';
	} else if ($passwordMismatch) {
		$error = 'Passwords do not match.';
	} else if ($ebanexists) {
		$error = 'This Email Provider is banned, please use an alternate address.';
	} else {
		$ref = '0';
		if (isset ( $_COOKIE ['ref'] )) {
			$ref = mysqli_escape_string ( $mysqli, $cookies ['ref'] );
		}
		
		$httpref = 'none';
		if (isset ( $_COOKIE ['httpref'] )) {
			$httpref = mysqli_escape_string ( $mysqli, $cookies ['httpref'] );
		}
		
		if ($site ['email_activate'] == '0') {
			// Create user activation code
			$activationCode = rand ( 000000000, 999999999 );
			// /START USER MAILER
			require_once ('inc/mailer/class.phpmailer.php');
			$mail = new PHPMailer ();
			$body = file_get_contents ( $site ['url'] . '/tpl/mail/activate.email.php?activate=' . $activationCode );
			$body = preg_replace ( "[\\\]", '', $body );
			// $mail->IsSMTP(); // telling the class to use SMTP
			// $mail->Host = "hostname"; // SMTP server
			// $mail->SMTPDebug = 0; // enables SMTP debug information (for testing)
			// $mail->SMTPAuth = true; // enable SMTP authentication
			// $mail->Port = 25; // set the SMTP port for the MAIL server
			// $mail->Username = "username"; // SMTP account username
			// $mail->Password = "password"; // SMTP account password
			
			$mail->SetFrom ( $site ['email'], $site ['name'] );
			$mail->AddReplyTo ( $site ['email'], $site ['name'] );
			$mail->Subject = "Welcome to " . $site ['name'];
			$mail->AltBody = "To view the message, please use an HTML compatible email viewer!"; // optional, comment out and test
			$mail->MsgHTML ( $body );
			$mail->AddAddress ( $email, $email );
			$mail->Send ();
		} else {
			$activationCode = '0';
		}
		
		// Prepare data to be inserted to DB
		$ip = VisitorIP ();
		$mysqli->query ( "INSERT INTO `users`(email,ip,pass,salt,ref,signup,activate,httpref) values('" . $email . "','" . $ip . "','" . $password . "','" . $salt . "','" . $ref . "',UTC_TIMESTAMP(),'" . $activationCode . "','" . $httpref . "')" );
		echo $mysqli->error . "\n";
		$lastsignupid = $mysqli->insert_id;
		$mysqli->query ( "UPDATE `today_stats` SET `user_new_signups`=`user_new_signups`+'1' WHERE `id`='1'" );
		
		// Display success message
		if ($site ['email_activate'] == '0') {
			$success = 'Please check your email and confirm the activation email to login.';
		} else {
			$success = 'Your account has been created, you may now login.';
		}
	}
}
?>
<!DOCTYPE html>
<!--[if lt IE 7]><html class="no-js lt-ie9 lt-ie8 lt-ie7"> <![endif]-->
<!--[if IE 7]><html class="no-js lt-ie9 lt-ie8"> <![endif]-->
<!--[if IE 8]><html class="no-js lt-ie9"> <![endif]-->
<!--[if gt IE 8]><!-->
<html class="no-js">
<!--<![endif]-->
<head>
<meta charset="utf-8">
<meta http-equiv="X-UA-Compatible" content="IE=edge,chrome=1">
<title><?=$site['name'];?> | Create account</title>
<meta name="description" content="<?=$site['description'];?>">
<meta name="keywords" content="<?=$site['name'];?> sign up">

<!-- Le styles -->
<link
	href='http://fonts.googleapis.com/css?family=Open+Sans:300italic,400italic,700italic,400,300,700'
	rel='stylesheet' type='text/css'>
<link href="tpl/css/core.min.css" rel="stylesheet">

<script src="tpl/js/libs/modernizr-2.6.1.min.js"></script>

<!-- HTML5 shim, for IE6-8 support of HTML5 elements -->
<!--[if lt IE 9]>
		  <script src="http://html5shim.googlecode.com/svn/trunk/html5.js"></script>
		<![endif]-->

<!-- icons -->
<link rel="shortcut icon" href="tpl/ico/favicon.ico">

<link rel="apple-touch-icon-precomposed" sizes="144x144"
	href="<?=$site['url'];?>/tpl/img/logo.png">
<link rel="apple-touch-icon-precomposed" sizes="114x114"
	href="<?=$site['url'];?>/tpl/img/logo.png">
<link rel="apple-touch-icon-precomposed" sizes="72x72"
	href="<?=$site['url'];?>/tpl/img/logo.png">
<link rel="apple-touch-icon-precomposed"
	href="<?=$site['url'];?>/tpl/img/logo.png">

<!-- Facebook Open Graph -->
<meta property="og:image"
	content="<?=$site['url'];?>/members/img/template_logo.png">
<meta property="og:title" content="<?=$site['index-title'];?>">
<meta property="og:url" content="<?=$site['url'];?>">
<meta property="og:site_name" content="<?=$site['name'];?>">
<meta property="og:type" content="Web Application">
<style>
.error {	
	background-color: #CC6666;
	padding: 1px;
	color: White;
	margin: 1px;
	text-align: center;
}

.success {
	background-color: #66CC00;
	padding: 1px;
	color: White;
	margin: 1px;
	border: 1px solid green;
	text-align: center;
}
</style>
</head>
<body class="sign-in-page">


	<section class="sign-in">
		<div class="container">
<?php if(isset($error)) { ?>
<div class="error"><?=$error;?></div>
<?php }if(isset($success)) { ?>
<div class="success"><?=$success;?></div>
<?php }?>
			<div class="module mod-sign-in" style="margin-top: -250px;">

				<div class="logo">
					<a href="/"><img src="/members/img/template_logo.png"
						alt="Home Icon"></a>
				</div>

				<form method="post">
					<font style="color: #bebebe;">If you already have an <?=$site['name'];?> account <a
						href="<?=$site['url'];?>/sign-in.php" style="color: #bebebe;"><u>click
								here</u></a> to sign in.
					</font><br>
					<br> <input name="email" type="email" id="inputEmail"
						placeholder="Email"> <input name="password" type="password"
						id="inputPassword" placeholder="Password"> <input name="password2"
						type="password" id="inputPassword2" placeholder="Confirm Password"><br>
					<br>
					<center>
						<button type="submit" class="btn btn-primary btn-large">
							<i class="icon-lock"></i> Sign up
						</button>
					</center>
				</form>
				<p>
					By signing up, you agree to our <a href="tos.php"
						style="text-decoration: none; color: #000;">Terms of Service</a>.
				</p>

			</div>

		</div>
	</section>

	<script
		src="//ajax.googleapis.com/ajax/libs/jquery/1.8.0/jquery.min.js"></script>
	<script>window.jQuery || document.write('<script src="tpl/js/libs/jquery-1.8.0.min.js"><\/script>')</script>

	<script src="tpl/js/libs/bootstrap.min.js"></script>
	<script src="tpl/js/libs/jquery.placeholder.min.js"></script>
	<script src="tpl/js/app.js"></script>
	
<?php
include ('common/analytics.php');
$mysqli->Close ();
?>
