<?php
include ('header.php');

// Clean form inputs
foreach ( $_POST as $key => $value ) {
	$posts [$key] = filter ( $value );
}
foreach ( $_GET as $key => $value ) {
	$gets [$key] = filter ( $value );
}

if (isset ( $_POST ['report_id'] )) {
	$stmt = $mysqli->prepare ( "INSERT INTO website_report (`id`, `user_id`, `timestamp`) VALUES (?, ?, UTC_TIMESTAMP())" );
	$stmt->bind_param ( 'ii', $_POST ['report_id'], $data ['id'] );
	if ($stmt->execute ()) {
		$success = "The web site has been reported to the administrators.";
	} else {
		$error = "The web site could not be reported at this time.  Please try again.";
	}
}

?>
<body>

	<!-- Full height wrapper -->
	<div id="wrapper">

		<!-- Main page header -->
		<header id="header" class="container">

			<h1>
				<!-- Main page logo -->
				<a href="dashboard.php" class="brand"><?=$site['name'];?></a>

				<!-- Main page headline -->
				<span>Free Website Traffic</span>
			</h1>

		<?php include('common/header_menu.php');?>


	</header>
		<!-- /Main page header -->

		<!-- Main page container -->
		<section class="container" role="main">

			<!-- Grid row -->
			<div class="row">

				<article class="span9 blue data-block">
					<header>
						<h2>
							<span class="icon-globe"></span>Report a Website
						</h2>

					</header>

					<!-- START ALERTS -->
				<?php if(isset($error)){?>
					<div class="alert alert-error fade in">
						<button class="close" data-dismiss="alert">&times;</button>
						<strong>ERROR:</strong> <?=$error;?>
					</div>
				<?php }ELSE if(isset($success)){?>
					<div class="alert alert-success fade in">
						<button class="close" data-dismiss="alert">&times;</button>
						<strong>SUCCESS:</strong> <?=$success;?>
					</div>
				<?php }?>
				<!-- END ALERTS -->

					<section class="tab-content">
						<table class="table table-striped table-hover">
							<thead>
								<tr>
									<th>Website url</th>
									<th>Time visited</th>
									<th>Action</th>
								</tr>
							</thead>
							<tbody>

						<?php
						$mydatadrop = $mysqli->query ( "SELECT * FROM `website_trafficed_view` WHERE `user_id`='" . $data ['id'] . "' LIMIT 10" );
						$mydatacountdrop = $mydatadrop->num_rows;
						for($j = 1; $list = $mydatadrop->fetch_assoc (); $j ++) {
							?>

						<tr>
									<td><a href="<?=$list['url'];?>" target="_blank"><?=$list['url'];?></a></td>
									<td><?= $list['timestamp'] ?></td>
									<td><form method="post">
											<input type="hidden" name="report_id"
												value="<?= $list['id'] ?>" />
											<button title="Report"
												class="btn btn-danger btn-primary btn-small">
												<span class="icon-remove">Report Site</span>
											</button>
										</form></td>
								</tr>

						<?php }?>

						</tbody>
						</table>
					<?php if($mydatacountdrop == '0'){?>
						<div class="alert alert-error fade in">
							<button class="close" data-dismiss="alert">&times;</button>
							<strong>You have not browsed any web sites yet.</strong>
						</div>
					<?php }?>

				</section>
				</article>
				<!-- /Data block -->

				<!-- Data block -->
				<article class="span3 green data-block">
					<header>
						<h2>
							<span class="icon-info-sign"></span> Account information
						</h2>
					</header>
					<div class="dark data-block">

					<?php include('common/account_info.php');?>


				</div>
				</article>
				<!-- /Data block -->

			</div>
			<!-- /Grid row -->
			<!-- END TABLE -->









		</section>
		<!-- /Main page container -->

		<!-- Sticky footer push -->
		<div id="push"></div>

	</div>
	<!-- /Full height wrapper -->




<?php
include('footer.php');
?>

