<?php
include ('header.php');
$bonuses = '1';

if (isset ( $posts ['redeem'] )) {
	// Get reward information
	$stmt = $mysqli->prepare ( 'SELECT id,point_cost,minutes,premium_hours FROM reward_packs WHERE id = ?' );
	$stmt->bind_param ( 'i', $posts ['redeem'] );
	$stmt->execute ();
	$stmt->bind_result ( $reward_id, $point_cost, $minutes, $premium_hours );
	$stmt->fetch ();
	$stmt->close ();
	
	if ($data ['bonus_points'] >= $point_cost) {
		$mysqli->autocommit ( false );
		$err = false;
		// Add Minutes
		if ($minutes) {
			$stmt = $mysqli->prepare ( 'UPDATE `users` SET `minutes` = `minutes` + ' . ( float ) $minutes . ' WHERE `id` = ?' );
			$stmt->bind_param ( 'i', $data ['id'] );
			if (! $stmt->execute ())
				$err = true;
		}
		// Add Premium Time
		if ($premium_hours) {
			if ($data ['premium'] == 1) {
				$stmt = $mysqli->prepare ( "UPDATE `users` SET `premium` = '1', `premiumtime` = `premiumtime` + INTERVAL ? HOUR, `max_sites` = '10' WHERE `id`= ?" );
			} else {
				$stmt = $mysqli->prepare ( "UPDATE `users` SET `premium` = '1', `premiumtime` = UTC_TIMESTAMP() + INTERVAL ? HOUR, `max_sites` = '10' WHERE `id`= ?" );
			}
			$stmt->bind_param ( 'ii', $premium_hours, $data ['id'] );
			if (! $stmt->execute ())
				$err = true;
		}
		// Deduct Points
		$stmt = $mysqli->prepare ( 'UPDATE `users` SET `bonus_points` = `bonus_points` - ? WHERE id = ?' );
		$stmt->bind_param ( 'ii', $point_cost, $data ['id'] );
		$data ['bonus_points'] -= $point_cost;
		if (! $stmt->execute ())
			$err = true;
			// Add History
		$stmt = $mysqli->prepare ( 'INSERT INTO reward_history (`user_id`, `point_cost`, `minutes`, `premium_hours`) VALUES (?, ?, ?, ?)' );
		$stmt->bind_param ( 'iidi', $data ['id'], $point_cost, $minutes, $premium_hours );
		if (! $stmt->execute ())
			$err = true;
		$bonus_points = $point_cost * - 1;
		$stmt = $mysqli->prepare ( 'INSERT INTO bonus_log (`user_id`, `bonus_points`, `minutes`, `description`, `timestamp`) VALUES (?, ?, ?, \'Reward Redemption\', UTC_TIMESTAMP())' );
		$stmt->bind_param ( 'iid', $data ['id'], $bonus_points, $minutes );
		if (! $stmt->execute ())
			$err = true;
		if ($err) {
			$mysqli->rollback ();
			$error = "There was an error processing your reward.  Please try again.";
		} else {
			$mysqli->commit ();
			$success = "You have redeemed " . $point_cost . " points for the selected reward.";
		}
		$mysqli->autocommit ( true );
	} else {
		$error = "You do not have enough available points for this reward.  Available: " . $data ['bonus_points'] . " Required: " . $point_cost . ".";
	}
}

?>
<style>
td {
	padding: 15px !important;
	font-size: 18px;
	font-weight: bold;
}
</style>
<body>

	<!-- Full height wrapper -->
	<div id="wrapper">

		<!-- Main page header -->
		<header id="header" class="container">

			<h1>
				<!-- Main page logo -->
				<a href="dashboard.php" class="brand">SwiftHits</a>

				<!-- Main page headline -->
				<span>Free Website Traffic</span>
			</h1>

		<?php include('common/header_menu.php');?>


	</header>
		<!-- /Main page header -->

		<!-- Main page container -->
		<section class="container" role="main">

			<!-- Grid row -->
			<div class="row">

				<article class="span12 data-block">
					<header>
						<h2>Redeem Points for Rewards</h2>
					</header>
					<section>

						<!-- START ALERTS -->
					<?php if(isset($error)){?>
						<div class="alert alert-error fade in">
							<button class="close" data-dismiss="alert">&times;</button>
							<strong>ERROR:</strong> <?=$error;?>
						</div>
					<?php }ELSE if(isset($success)){?>
						<div class="alert alert-success fade in">
							<button class="close" data-dismiss="alert">&times;</button>
							<strong>SUCCESS:</strong> <?=$success;?>
						</div>
					<?php }?>
					<!-- END ALERTS -->

						<p>
						
						
						<center>
							<h3 style="color: dodgerblue">
								You currently have <span style="color: black"><?= $data['bonus_points'] ?></span>
								points.</span>
							</h3>
						</center>
						</p>

					</section>
					<section class="tab-content">
						<table class="table table-striped table-hover">
							<thead>
								<tr>
									<th>Number of Points Used</th>
									<th>Reward Minutes</th>
									<th>Premium Time</th>
									<th>Action</th>
								</tr>
							</thead>
							<tbody>

							<?php
							$mydatadrop = $mysqli->query ( "SELECT * FROM `reward_packs` ORDER BY `point_cost` ASC" );
							$mydatacountdrop = $mydatadrop->num_rows;
							for($j = 1; $list = $mydatadrop->fetch_assoc (); $j ++) {
								?>
								<tr>
									<td><?=$list['point_cost'];?> points</td>
									<td><?=$list['minutes'] / .6;?></td>
									<td><center>
											<?php
								if (! $list ['premium_hours']) {
									echo 'N/A';
								} elseif ($list ['premium_hours'] > 24 and $list ['premium_hours'] % 24 === 0) {
									$days = $list ['premium_hours'] / 24;
									echo $days . " Days";
								} else {
									echo $list ['premium_hours'] . " Hours";
								}
								?>
										</center></td>
									<td>
										<form name="redeem<?=$j;?>" method="POST"
											style="display: inline;">
											<input type="hidden" name="redeem" value="<?=$list['id'];?>">
											<center>
												<button title="Redeem Reward"
													class="btn btn-default btn-primary">
													<span class="icon-check"> Redeem Reward</span>
												</button>
											</center>
										</form>
									</td>



								</tr>
							<?php }?>

							</tbody>
						</table>
						<?php if($mydatacountdrop == '0'){?>
							<div class="alert alert-error fade in">
							<button class="close" data-dismiss="alert">&times;</button>
							<strong>There are no rewards available.</strong>
						</div>
						<?php }?>
					</section>
				</article>
				<!-- /Data block -->

			</div>
			<!-- /Grid row -->

		</section>
	</div>