<?php
include ('header.php');
$upgrades = '1';

if (isset ( $posts ['coupon_code'] )) {
	$stmt = $mysqli->prepare ( "SELECT `minutes`, `description` FROM `coupon` WHERE `active` = 1 AND `code` = ? AND `expiration` >= CURDATE()" );
	$stmt->bind_param ( 's', $posts ['coupon_code'] );
	$stmt->execute ();
	$stmt->bind_result ( $minutes, $description );
	$stmt->fetch ();
	$stmt->close ();
	
	if (! $minutes) {
		$error = "Invalid Coupon Code: " . $posts ['coupon_code'];
	} else {
		$stmt = $mysqli->prepare ( "SELECT count(*) FROM `coupon_user` WHERE `user_id` = ? AND `code` = ?" );
		$stmt->bind_param ( 'is', $data ['id'], $posts ['coupon_code'] );
		$stmt->execute ();
		$stmt->bind_result ( $count );
		$stmt->fetch ();
		$stmt->close ();
		if (! $count) {
			// Add minutes to user
			$mysqli->autocommit ( false );
			$stmt = $mysqli->prepare ( 'UPDATE `users` SET `minutes` = `minutes` + ' . ( float ) $minutes . ' WHERE `id` = ?' );
			$stmt->bind_param ( 'i', $data ['id'] );
			if ($stmt->execute ()) {
				$stmt = $mysqli->prepare ( 'INSERT INTO `coupon_user` (`code`, `user_id`, `timestamp`) VALUES (?, ?, UTC_TIMESTAMP())' );
				$stmt->bind_param ( 'si', $posts ['coupon_code'], $data ['id'] );
				if ($stmt->execute ()) {
					$success = "Coupon has been redeemed.  " . ($minutes / .6) . " minutes have been added to your account.";
					$mysqli->commit ();
					$mysqli->autocommit ( true );
				} else {
					$error = "Database error. Could not redeem coupon [Error #2]";
					$mysqli->rollback ();
					$mysqli->autocommit ( true );
				}
			} else {
				$error = "Database error. Could not redeem coupon [Error #1]";
				$mysqli->rollback ();
				$mysqli->autocommit ( true );
			}
		} else {
			$error = "This coupon code has already been redeemed.";
		}
	}
}
?>


<body>

	<!-- Full height wrapper -->
	<div id="wrapper">

		<!-- Main page header -->
		<header id="header" class="container">

			<h1>
				<!-- Main page logo -->
				<a href="dashboard.php" class="brand">SwiftHits</a>

				<!-- Main page headline -->
				<span>Free Website Traffic</span>
			</h1>

		<?php include('common/header_menu.php');?>


	</header>
		<!-- /Main page header -->

		<!-- Main page container -->
		<section class="container" role="main">

			<!-- Grid row -->
			<div class="row">

				<article class="span12 data-block">
					<header>
						<h2>Account upgrades</h2>
					</header>
					<section>

						<!-- START ALERTS -->
					<?php if(isset($error)){?>
						<div class="alert alert-error fade in">
							<button class="close" data-dismiss="alert">&times;</button>
							<strong>ERROR:</strong> <?=$error;?>
						</div>
					<?php }ELSE if(isset($success)){?>
						<div class="alert alert-success fade in">
							<button class="close" data-dismiss="alert">&times;</button>
							<strong>SUCCESS:</strong> <?=$success;?>
						</div>
					<?php }?>
					<!-- END ALERTS -->

						<!-- START DESCRIPTION -->
					<?php if (isset($description)) { ?>
						<h3>Coupon Description</h3>
						<pre><?= $description ?></pre>
					<?php } ?>
					<!-- END DESCRIPTION -->

						<form class="form-horizontal" method="post"
							action="redeem-coupon.php">
							<fieldset>

								<h3>Redeem a Coupon</h3>

								<div class="control-group">
									<label class="control-label" for="input">Coupon Code:</label>
									<div class="controls">
										<input id="input" class="input-large" name="coupon_code"
											type="text" />
									</div>
								</div>


								<div class="form-actions">
									<button class="btn btn-alt btn-large btn-primary" type="submit">Redeem
										Coupon</button>
								</div>
							</fieldset>
						</form>

					</section>
				</article>

			</div>
		</section>
	</div>


<?php
include('footer.php');
?>
