<?php
include ('header.php');

$mywebsites = '1';

// Send user away if not an admin
if ($data ['toplevel'] != '1') {
	echo "<script>window.location='{$site['url']}/sign-out.php'</script>";
}

// Handle Ban button pressed
if (isset ( $posts ['banid'] )) {
	$stmt = $mysqli->prepare ( "UPDATE `website_traffic` SET `active` = '1', `banned` = '1' WHERE `id` = ?" );
	$stmt->bind_param ( 'i', $posts ['banid'] );
	if (! $stmt->execute ()) {
		$error = "Web site " . $posts ['banid'] . " could not be banned in the database.";
	} else {
		$stmt = $mysqli->prepare ( "UPDATE `website_report` SET `ignore` = '1'  WHERE `id` = ?" );
		$stmt->bind_param ( 'i', $posts ['banid'] );
		$stmt->execute ();
		$success = "Web site " . $posts ['banid'] . " has been banned.";
	}
}

if (isset ( $posts ['ignoreid'] )) {
	$stmt = $mysqli->prepare ( "UPDATE `website_report` SET `ignore` = '1'  WHERE `id` = ?" );
	$stmt->bind_param ( 'i', $posts ['ignoreid'] );
	if ($stmt->execute ()) {
		$success = "Current reports for web site " . $posts ['banid'] . " have been ignored.";
	}
}

?>

<body>

	<!-- Full height wrapper -->
	<div id="wrapper">

		<!-- Main page header -->
		<header id="header" class="container">

			<h1>
				<!-- Main page logo -->
				<a href="dashboard.php" class="brand"><?=$site['name'];?></a>

				<!-- Main page headline -->
				<span>Free Website Traffic</span>
			</h1>

		<?php include('admin-common/header_menu.php');?>


	</header>
		<!-- /Main page header -->

		<!-- Main page container -->
		<section class="container" role="main">




			<!-- Grid row -->
			<div class="row">

				<!-- Data block -->
				<article class="span12 dark data-block">
					<header>
						<h2>Reported Web Sites</h2>

					</header>
					<section>

						<!-- START ALERTS -->
					<?php if(isset($error)){?>
						<div class="alert alert-error fade in">
							<button class="close" data-dismiss="alert">&times;</button>
							<strong>ERROR:</strong> <?=$error;?>
						</div>
					<?php }ELSE if(isset($success)){?>
						<div class="alert alert-success fade in">
							<button class="close" data-dismiss="alert">&times;</button>
							<strong>SUCCESS:</strong> <?=$success;?>
						</div>
					<?php }?>
					<!-- END ALERTS -->

						<table
							class="datatable table table-striped table-bordered table-hover"
							id="example-2">
							<thead>
								<tr>
									<th>ID&nbsp;&nbsp;&nbsp;</th>
									<th>Website URL</th>
									<th>Total Reports</th>
									<th>Last Reporter</th>
									<th>Action</th>
								</tr>
							</thead>
							<tbody>


						<?php
						$websites = $mysqli->query ( "SELECT * FROM `website_reports_view` ORDER BY report_count DESC" );
						for($j = 1; $list = $websites->fetch_assoc (); $j ++) {
							?>
							<tr class="odd gradeX">
									<td><?=$list['id'];?></td>
									<td><center>
											<a href="<?=$site['url'];?>/r/?<?=$list['url'];?>"
												target="_blank"><?=$list['url'];?></a>
										</center></td>
									<td><center><?= $list['report_count'] ?></center></td>
									<td><center>
											<a href="admin-user-editor.php?uid=<?=$list['user'];?>"><?=$list['email'];?> at <?= $list['timestamp'] ?></a>
										</center></td>

									<td>
										<form name="ban<?=$j;?>" method="POST"
											style="display: inline; float: left;">
											<input type="hidden" name="banid" value="<?=$list['id'];?>">
											<a href="javascript: void(0);" style="margin-left: 20px;"
												onclick="document.ban<?=$j;?>.submit();"><button title="Ban"
													class="btn btn-danger btn-primary btn-small">Ban</button></a>
										</form>
										<form name="ignore<?=$j;?>" method="POST"
											style="display: inline; float: left;">
											<input type="hidden" name="ignoreid"
												value="<?=$list['id'];?>"> <a href="javascript: void(0);"
												style="margin-left: 20px;"
												onclick="document.unban<?=$j;?>.submit();"><button
													title="Ignore"
													class="btn btn-default btn-primary btn-small">Ignore</button></a>
										</form>
									</td>
								</tr>
						<?php }?>


						</tbody>
						</table>

					</section>

				</article>
				<!-- /Data block -->

			</div>
			<!-- /Grid row -->


		</section>
		<!-- /Main page container -->

		<!-- Sticky footer push -->
		<div id="push"></div>

	</div>
	<!-- /Full height wrapper -->



<?php
include('footer.php');
?>