<?php
include ('header.php');

$myusers = '1';

// Send user away if not an admin
if ($data ['toplevel'] != '1') {
	echo "<script>window.location='{$site['url']}/sign-out.php'</script>";
}

if (isset ( $posts ['user_id'] )) {
	if ($posts ['points'] == 0) {
		$error = "Invalid number of points.  No adjustment has been made.";
	} else {
		$stmt = $mysqli->prepare ( 'SELECT bonus_points FROM users WHERE id = ?' );
		$stmt->bind_param ( 'i', $posts ['user_id'] );
		$stmt->execute ();
		$stmt->bind_result ( $points );
		$stmt->fetch ();
		$stmt->close ();
		$points += ( int ) $posts ['points'];
		
		$stmt = $mysqli->prepare ( 'UPDATE users SET bonus_points = ? WHERE id = ?' );
		$stmt->bind_param ( 'ii', $points, $posts ['user_id'] );
		if ($stmt->execute ()) {
			$success = $posts ['points'] . " have been added to user ID " . $posts ['user_id'] . " for a new total of " . $points . ".";
			// Log entry
			$stmt = $mysqli->prepare ( 'INSERT INTO bonus_log (`user_id`, `bonus_points`, `description`, `timestamp`)
			VALUES (?, ?, ?, UTC_TIMESTAMP())' );
			$stmt->bind_param ( 'iis', $posts ['user_id'], $posts ['points'], $posts ['description'] );
			$stmt->execute ();
		} else {
			$error = "New points could not be added in the database.";
		}
	}
}

?>

<body>

	<!-- Full height wrapper -->
	<div id="wrapper">

		<!-- Main page header -->
		<header id="header" class="container">

			<h1>
				<!-- Main page logo -->
				<a href="dashboard.php" class="brand"><?=$site['name'];?></a>

				<!-- Main page headline -->
				<span>Free Website Traffic</span>
			</h1>

		<?php include('admin-common/header_menu.php');?>


	</header>
		<!-- /Main page header -->

		<!-- Main page container -->
		<section class="container" role="main">




			<!-- Grid row -->
			<div class="row">

				<!-- Data block -->
				<article class="span12 data-block">
					<header>
						<h2>Assign Bonus Points</h2>
					</header>
					<section>
						<!-- START ALERTS -->
					<?php if(isset($error)){?>
						<div class="alert alert-error fade in">
							<button class="close" data-dismiss="alert">&times;</button>
							<strong>ERROR:</strong> <?=$error;?>
						</div>
					<?php }ELSE if(isset($success)){?>
						<div class="alert alert-success fade in">
							<button class="close" data-dismiss="alert">&times;</button>
							<strong>SUCCESS:</strong> <?=$success;?>
						</div>
					<?php }?>
					<!-- END ALERTS -->
						<div class="row-fluid">
							<div class="span6">

								<form class="form-horizontal" method="post">
									<fieldset>

										<div class="control-group">
											<label class="control-label" for="input">User</label>
											<div class="controls">
												<select class="input-xlarge" name="user_id">
												<?php
												
$users = $mysqli->query ( "SELECT id,email FROM users ORDER BY `email`" );
												while ( $list = $users->fetch_assoc () ) {
													?>
												<option value="<?= $list['id'] ?>"><?=$list['email']?></option>
												<?php } ?>
											</select>
											</div>
										</div>

										<div class="control-group">
											<label class="control-label" for="input">Description</label>
											<div class="controls">
												<input type="text" id="input" class="input-xlarge"
													name="description" />
											</div>
										</div>

										<div class="control-group">
											<label class="control-label" for="input">Points</label>
											<div class="controls">
												<input id="input" class="input-xlarge" type="number"
													name="points" value="0">
											</div>
										</div>

										<div class="form-actions">
											<button class="btn btn-alt btn-large btn-primary"
												type="submit">Assign Points</button>
										</div>
									</fieldset>
								</form>
							</div>

						</div>
					</section>
				</article>
				<!-- /Data block -->

			</div>
			<!-- /Grid row -->

		</section>
		<!-- /Main page container -->

		<!-- Sticky footer push -->
		<div id="push"></div>

	</div>
	<!-- /Full height wrapper -->



<?php
include('footer.php');
?>