<?php
include ('header.php');

$sales = '1';

// Send user away if not an admin
if ($data ['toplevel'] != '1') {
	echo "<script>window.location='{$site['url']}/sign-out.php'</script>";
}

// Add coupon
if (isset ( $posts ['minutes'] )) {
	$minutes = $posts ['minutes'] * .6;
	$expiration = date ( 'Y-m-d', strtotime ( $posts ['expiration'] ) );
	$code = generate_code ();
	$stmt = $mysqli->prepare ( "INSERT INTO `coupon`(code,description,expiration,active,minutes) values(?, ?, ?, 1, ?)" );
	$stmt->bind_param ( 'sssi', $code, $posts ['description'], $expiration, $minutes );
	if ($stmt->execute ()) {
		$success = 'Coupon ' . $code . ' has been added.';
	} else {
		$error = 'Coupon could not be saved. Database error.';
	}
}

// Deactivate
if (isset ( $posts ['deactivate'] )) {
	$stmt = $mysqli->prepare ( "UPDATE `coupon` SET `active` = 0  WHERE `code` = ?" );
	$stmt->bind_param ( 's', $posts ['deactivate'] );
	$stmt->execute ();
	echo "<script>window.location='admin-coupons.php'</script>";
}

// Reactivate
if (isset ( $posts ['reactivate'] )) {
	$stmt = $mysqli->prepare ( "UPDATE `coupon` SET `active` = 1 WHERE `code` = ?" );
	$stmt->bind_param ( 's', $posts ['reactivate'] );
	$stmt->execute ();
	echo "<script>window.location='admin-coupons.php'</script>";
}

// Delete
if (isset ( $posts ['delete'] )) {
	$stmt = $mysqli->prepare ( "DELETE FROM `coupon` WHERE `code` = ?" );
	$stmt->bind_param ( 's', $posts ['delete'] );
	$stmt->execute ();
	echo "<script>window.location='admin-coupons.php'</script>";
}

?>
<body>

	<!-- Full height wrapper -->
	<div id="wrapper">

		<!-- Main page header -->
		<header id="header" class="container">

			<h1>
				<!-- Main page logo -->
				<a href="dashboard.php" class="brand"><?=$site['name'];?></a>

				<!-- Main page headline -->
				<span>Free Website Traffic</span>
			</h1>

<?php include('admin-common/header_menu.php');?>


</header>
		<!-- /Main page header -->

		<!-- Main page container -->
		<section class="container" role="main">




			<!-- Grid row -->
			<div class="row">

				<!-- Data block -->
				<article class="span12 data-block">
					<header>
						<h2>Add a coupon</h2>
					</header>
					<section>
						<!-- START ALERTS -->
				<?php if(isset($error)){?>
					<div class="alert alert-error fade in">
							<button class="close" data-dismiss="alert">&times;</button>
							<strong>ERROR:</strong> <?=$error;?>
					</div>
				<?php }ELSE if(isset($success)){?>
					<div class="alert alert-success fade in">
							<button class="close" data-dismiss="alert">&times;</button>
							<strong>SUCCESS:</strong> <?=$success;?>
					</div>
				<?php }?>
				<!-- END ALERTS -->
						<div class="row-fluid">
							<div class="span6">

								<form class="form-horizontal" method="post">
									<fieldset>

										<div class="control-group">
											<label class="control-label" for="input">Description</label>
											<div class="controls">
												<textarea id="textarea" class="input-xlarge"
													name="description"></textarea>
											</div>
										</div>

										<div class="control-group">
											<label class="control-label" for="input">Expiration Date</label>
											<div class="controls">
												<input id="input" class="input-xlarge" type="date"
													name="expiration" value="9999-12-31">
											</div>
										</div>

										<div class="control-group">
											<label class="control-label" for="input">Minutes</label>
											<div class="controls">
												<input id="input" class="input-xlarge" type="text"
													name="minutes" value="">
											</div>
										</div>



										<div class="form-actions">
											<button class="btn btn-alt btn-large btn-primary"
												type="submit">Add Coupon</button>
										</div>
									</fieldset>
								</form>
							</div>

						</div>
					</section>
				</article>
				<!-- /Data block -->

			</div>
			<!-- /Grid row -->



			<!-- START TABLE1 -->
			<!-- Grid row -->
			<div class="row">
				<article class="span12 data-block">
					<header>
						<h2>
							<span class="icon-tag"></span> Active Coupon Codes
						</h2>

					</header>
					<section class="tab-content">
						<table class="table table-striped table-hover">
							<thead>
								<tr>
									<th>Code</th>
									<th>Minutes</th>
									<th>Expiration</th>
									<th>Action</th>
								</tr>
							</thead>
							<tbody>

					<?php
					$mydatadrop = $mysqli->query ( "SELECT * FROM `coupon` WHERE `active` = 1 AND `expiration` >= CURDATE() ORDER BY `code` ASC" );
					$mydatacountdrop = $mydatadrop->num_rows;
					for($j = 1; $list = $mydatadrop->fetch_assoc (); $j ++) {
						?>
						<tr>
									<td><?=$list['code'];?></td>
									<td><?=$list['minutes'] / .6;?></td>
									<td><?=$list['expiration'];?></td>
									<td>
										<form name="deactivate<?=$j;?>" method="POST"
											style="display: inline;">
											<input type="hidden" name="deactivate"
												value="<?=$list['code'];?>">
											<center>
												<a href="javascript: void(0);"
													onclick="document.deactivate<?=$j;?>.submit();"><button
														title="Deactivate"
														class="btn btn-danger btn-primary btn-small">
														<span class="icon-remove"></span> Deactivate
													</button></a>
											</center>
										</form>
									</td>



								</tr>
					<?php }?>

					</tbody>
						</table>
				<?php if($mydatacountdrop == '0'){?>
					<div class="alert alert-error fade in">
							<button class="close" data-dismiss="alert">&times;</button>
							<strong>You have not added any coupons yet. 
						
						</div>
				<?php }?>
			</section>
				</article>
				<!-- /Data block -->

			</div>
			<!-- /Grid row -->
			<!-- END TABLE1 -->

			<!-- START TABLE2 -->
			<!-- Grid row -->
			<div class="row">
				<article class="span12 data-block">
					<header>
						<h2>
							<span class="icon-tag"></span> Deactivated Coupon Codes
						</h2>

					</header>
					<section class="tab-content">
						<table class="table table-striped table-hover">
							<thead>
								<tr>
									<th>Code</th>
									<th>Minutes</th>
									<th>Expiration</th>
									<th>Action</th>
								</tr>
							</thead>
							<tbody>

					<?php
					$mydatadrop = $mysqli->query ( "SELECT * FROM `coupon` WHERE `active` = 0 OR `expiration` < CURDATE() ORDER BY `code` ASC" );
					$mydatacountdrop = $mydatadrop->num_rows;
					for($j = 1; $list = $mydatadrop->fetch_assoc (); $j ++) {
						?>
						<tr>
									<td><?=$list['code'];?></td>
									<td><?=$list['minutes'] / .6;?></td>
									<td><?=$list['expiration'];?></td>
									<td><center>
											<form name="reactivate<?=$j;?>" method="POST"
												style="display: inline; float: left;">
												<input type="hidden" name="reactivate"
													value="<?=$list['code'];?>"> <a href="javascript: void(0);"
													onclick="document.reactivate<?=$j;?>.submit();"><button
														title="Reactivate"
														class="btn btn-success btn-primary btn-small">
														<span class="icon-refresh"></span> Reactivate
													</button></a>
											</form>
											<form name="delete<?=$j;?>" method="POST"
												style="display: inline; float: left;">
												<input type="hidden" name="delete"
													value="<?=$list['code'];?>"> <a href="javascript: void(0);"
													onclick="document.delete<?=$j;?>.submit();"><button
														title="Delete"
														class="btn btn-danger btn-primary btn-small">
														<span class="icon-remove"></span> Delete
													</button></a>
											</form>
										</center></td>




								</tr>
					<?php }?>

					</tbody>
						</table>
				<?php if($mydatacountdrop == '0'){?>
					<div class="alert alert-error fade in">
							<button class="close" data-dismiss="alert">&times;</button>
							<strong>There are no deactivated coupons yet. 
						
						</div>
				<?php }?>
			</section>
				</article>
				<!-- /Data block -->

			</div>
			<!-- /Grid row -->
			<!-- END TABLE2 -->

		</section>
		<!-- /Main page container -->

		<!-- Sticky footer push -->
		<div id="push"></div>

	</div>
	<!-- /Full height wrapper -->



<?php
include('footer.php');
?>