<?php
include ('header.php');

$sales = '1';

// Send user away if not an admin
if ($data ['toplevel'] != '1') {
	echo "<script>window.location='{$site['url']}/sign-out.php'</script>";
}

// Add bonus level
if (isset ( $posts ['point_cost'] )) {
	$minutes = $posts ['minutes'] * .6;
	$stmt = $mysqli->prepare ( "INSERT INTO `reward_packs`(point_cost, minutes, premium_hours) values(?, ?, ?)" );
	$stmt->bind_param ( 'iii', $posts ['point_cost'], $minutes, $posts ['premium_hours'] );
	if ($stmt->execute ()) {
		$success = 'Bonus reward has been added for ' . $posts ['point_cost'] . ' points.';
	} else {
		$error = 'Bonus reward could not be saved. Database error.';
	}
}

// Delete
if (isset ( $posts ['delete'] )) {
	$stmt = $mysqli->prepare ( "DELETE FROM `reward_packs` WHERE `id` = ?" );
	$stmt->bind_param ( 's', $posts ['delete'] );
	$stmt->execute ();
}

?>
<body>

	<!-- Full height wrapper -->
	<div id="wrapper">

		<!-- Main page header -->
		<header id="header" class="container">

			<h1>
				<!-- Main page logo -->
				<a href="dashboard.php" class="brand"><?=$site['name'];?></a>

				<!-- Main page headline -->
				<span>Free Website Traffic</span>
			</h1>

<?php include('admin-common/header_menu.php');?>


</header>
		<!-- /Main page header -->

		<!-- Main page container -->
		<section class="container" role="main">




			<!-- Grid row -->
			<div class="row">

				<!-- Data block -->
				<article class="span12 data-block">
					<header>
						<h2>Add a Bonus Points Reward</h2>
					</header>
					<section>
						<!-- START ALERTS -->
				<?php if(isset($error)){?>
					<div class="alert alert-error fade in">
							<button class="close" data-dismiss="alert">&times;</button>
							<strong>ERROR:</strong> <?=$error;?>
					</div>
				<?php }ELSE if(isset($success)){?>
					<div class="alert alert-success fade in">
							<button class="close" data-dismiss="alert">&times;</button>
							<strong>SUCCESS:</strong> <?=$success;?>
					</div>
				<?php }?>
				<!-- END ALERTS -->
						<div class="row-fluid">
							<div class="span6">

								<form class="form-horizontal" method="post">
									<fieldset>

										<div class="control-group">
											<label class="control-label" for="input">Point Cost</label>
											<div class="controls">
												<input id="input" class="input-xlarge" type="number"
													name="point_cost" value="0">
											</div>
										</div>


										<div class="control-group">
											<label class="control-label" for="input">Bonus Minutes</label>
											<div class="controls">
												<input id="input" class="input-xlarge" type="number"
													name="minutes" value="0">
											</div>
										</div>

										<div class="control-group">
											<label class="control-label" for="input">Premium Hours</label>
											<div class="controls">
												<input id="input" class="input-xlarge" type="number"
													name="premium_hours" value="0">
											</div>
										</div>

										<div class="form-actions">
											<button class="btn btn-alt btn-large btn-primary"
												type="submit">Add Reward</button>
										</div>
									</fieldset>
								</form>
							</div>

						</div>
					</section>
				</article>
				<!-- /Data block -->

			</div>
			<!-- /Grid row -->



			<!-- START TABLE1 -->
			<!-- Grid row -->
			<div class="row">
				<article class="span12 data-block">
					<header>
						<h2>
							<span class="icon-star"></span> Bonus Points Rewards
						</h2>

					</header>
					<section class="tab-content">
						<table class="table table-striped table-hover">
							<thead>
								<tr>
									<th>Point Cost</th>
									<th>Bonus Minutes</th>
									<th>Premium Hours</th>
									<th>Action</th>
								</tr>
							</thead>
							<tbody>

					<?php
					$mydatadrop = $mysqli->query ( "SELECT * FROM `reward_packs` ORDER BY `point_cost` ASC" );
					$mydatacountdrop = $mydatadrop->num_rows;
					for($j = 1; $list = $mydatadrop->fetch_assoc (); $j ++) {
						?>
						<tr>
									<td><?=$list['point_cost'];?></td>
									<td><?=$list['minutes'] / .6;?></td>
									<td><?=$list['premium_hours'];?></td>
									<td>
										<form name="delete<?=$j;?>" method="POST"
											style="display: inline;">
											<input type="hidden" name="delete" value="<?=$list['id'];?>" />
											<center>
												<button title="Delete"
													class="btn btn-danger btn-primary btn-small">
													<span class="icon-remove"></span> Delete
												</button>
										
										</form>
										</center>
										</form>
									</td>



								</tr>
					<?php }?>

					</tbody>
						</table>
				<?php if($mydatacountdrop == '0'){?>
					<div class="alert alert-error fade in">
							<button class="close" data-dismiss="alert">&times;</button>
							<strong>You have not added any daily bonuses yet. 
						
						</div>
				<?php }?>
			</section>
				</article>
				<!-- /Data block -->

			</div>
			<!-- /Grid row -->
			<!-- END TABLE1 -->


		</section>
		<!-- /Main page container -->

		<!-- Sticky footer push -->
		<div id="push"></div>

	</div>
	<!-- /Full height wrapper -->



<?php
include('footer.php');
?>