<?php ob_start(); ?>
<?php 
/**
* Simple Installer - The Complete installer wizard for developers
* Copyright (c) Black Innovations Africa. All Rights Reserved,
* Version: 1.0
* BuildId: 1
* Build Date: 13 October 2015
* 
* Email: support@appifystudio.com 
* Website: http://www.appifystudio.com
*
*
*/

?>
<!doctype html>
<html>
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Trafix Installer</title>
    <!-- Bootstrap -->
    <link href="scripts/assets/css/bootstrap.min.css" rel="stylesheet">
    <link href="scripts/assets/css/sticky-footer-navbar.css" rel="stylesheet">
    <link href="scripts/assets/css/costum.css" rel="stylesheet">
</head>

<body>

<div class="container">
<!-- row 1 -->
<heaer class="row">
        <a href="#"><img src="scripts/assets/img/simple-installer-logo.png" class="img-responsive" alt="Simple Installer."></a>

</heaer>

<!-- row 2 --><!-- navigation -->
<div class="row">
<div class="col-lg-3 col-md-5">
    <div class="list-group">
    <a id="step" href="#" class='list-group-item active'>
        INSTALLATION STEPS
          <span class="glyphicon glyphicon-chevron-right"></span>
        </a>
        <a id="step" href="#" class='list-group-item'>Step 1- LicenseAgreement
          <span class="glyphicon glyphicon-chevron-right"></span>
        </a>      
        <a href="#" class='list-group-item'>Step 2- Server Requirements
          <span class="glyphicon glyphicon-chevron-right"></span>
        </a>
        <a href="#" class="list-group-item">Step 3- Database Information
          <span class="glyphicon glyphicon-chevron-right"></span>
        </a>
        <a href="#" class="list-group-item">Step 4- Complete
          <span class="glyphicon glyphicon-chevron-right"></span>
        </a>

      </div>
</div>
<div class="col-lg-9 col-md-7 well well-lg">
<?php
/**
* Installation steps  setout using switch();
*
* @switch(), You can add more steps as your program requires
*
*/
$step = (isset($_GET['step']) && $_GET['step'] != '') ? $_GET['step'] : '';
switch($step){
  case '1':
  step_1();
  break;
  case '2':
  step_2();
  break;
  case '3':
  step_3();
  break;
  case '4':
  step_4();
  break;
  default:
  step_1();
}
?>
<body>



<?php
/**
* functions of all the steps
*
* @function step_1()
*
* Step requires accepting License Agreement.
*/
function step_1(){ 

   if($_SERVER['REQUEST_METHOD'] == 'POST' && isset($_POST['agree'])){
    header('Location: install.php?step=2');
    exit;
   }
   if($_SERVER['REQUEST_METHOD'] == 'POST' && !isset($_POST['agree'])){
    echo "<b class='text-danger'>You must agree to the license.</b>";
   }
?>


  <article>
    <h2>Step 1</h2>
        <h3 class="text-success"> Accept License Agreement</h3>
         
        <p> THIS SOFTWARE IS LICENSED UNDER THE CODECANYON LICENSE (http://codecanyon.net/licenses). IF YOU HAVE NOT PURCHASED THIS SOFTWARE FROM CODECANYON.NET, YOU ARE BREAKING THE LAW.</p>
  </article>
  <form class="form-group" action="install.php?step=1" method="post">
       <p><b class="text-success">I agree to the license</b>
        <input type="checkbox" name="agree" />
       </p>
        <input type="submit" class="btn btn-primary" value="Continue" />
  </form>
<?php 
}


/**
* @function step_2()
*
* Checks Server requirements.
*
*/
function step_2(){ 
  global $pre_error;
  if($_SERVER['REQUEST_METHOD'] == 'POST' && $_POST['pre_error'] ==''){
   header('Location: install.php?step=3');
   exit;
  }
  if($_SERVER['REQUEST_METHOD'] == 'POST' && $_POST['pre_error'] != '')
   echo $_POST['pre_error'];
      
  
  if (phpversion() < '5.0') {
   $pre_error = "<b class='text-danger'>You need to use PHP5 or above for our site!</b><br />";
  }
  if (!extension_loaded('mysql')) {
   $pre_error .= "<b class='text-danger'>MySQL extension needs to be loaded for our site to work!</b><br />";
  }
  if (!is_writable('inc/db.php')) {
   $pre_error .= "<b>inc/db.php needs to be writable for our site to be installed!</b>";
  }
  if (!extension_loaded('cURL')) {
   $pre_error .= "<b class='text-danger'>CURL extension needs to be loaded for our site to work!</b><br/>";
  }
  ?>


  <div class="page-header">
        <h2>Step 2</h2>
          <h3 class="text-success">Server Requirements</h3>

    </div>
    <table class="table table-bordered table-striped table-hover" >
        <thead>
            <tr>
              <th>Server Files</th>
              <th>Your Settings</th>
              <th>Recommended</th>
              <th>Result</th>
            </tr>
          </thead>
        <tr>
           <td><b>PHP Version:</b></td>
           <td><?php echo phpversion(); ?></td>
           <td>5.0+</td>
           <td><?php echo (phpversion() >= '5.0') ? '<b class="text-success">Ok</b>' : '<b class="text-warning">Not Ok</b>'; ?></td>
        </tr>
        <tr>
           <td><b>MySQL:</b></td>
           <td><?php echo extension_loaded('mysql') ? 'On' : 'Off'; ?></td>
           <td>On</td>
           <td><?php echo extension_loaded('mysql') ? '<b class="text-success">Ok</b>' : '<b class="text-danger">Not Ok</b>'; ?></td>
        </tr>
           <td><b>db.php</b></td>
           <td><?php echo is_writable('inc/db.php') ? 'Writable' : 'Unwritable'; ?></td>
           <td>Writable</td>
           <td><?php echo is_writable('inc/db.php') ? '<b class="text-success">Ok</b>' : '<b class="text-danger">Not Ok</b>'; ?></td>
        </tr>
        <tr>
           <td><b>CURL:</b></td>
           <td><?php echo extension_loaded('cURL') ? 'On' : 'Off'; ?></td>
           <td>On</td>
           <td><?php echo extension_loaded('cURL') ? '<b class="text-success">Ok</b>' : '<b class="text-danger">Not Ok</b>'; ?></td>
        </tr>
    </table>
    <form action="install.php?step=2" method="post">
         <input type="hidden" name="pre_error" id="pre_error" value="<?php echo $pre_error;?>" />
         <input type="submit" class="btn btn-primary" name="continue" value="Continue" />
    </form>
<?php
}



/**
* @function hasHeaderInj($str)
*
* to prevent Header injections.
*
*/

function hasHeaderInj($str) {
   return preg_match("/[\r\n]/", $str);

}

/**
* @function step_3()
*
* Creating and connecting to database.
*
*/
function step_3(){
  error_reporting(E_ALL ^ E_WARNING);

  if (isset($_POST['submit']) && $_POST['submit']=="Install!") {
   $database_host=isset($_POST['database_host'])?$_POST['database_host']:"";
   $database_name=isset($_POST['database_name'])?$_POST['database_name']:"";
   $database_username=isset($_POST['database_username'])?$_POST['database_username']:"";
   $database_password=isset($_POST['database_password'])?$_POST['database_password']:"";
   

   if (hasHeaderInj($database_host) || hasHeaderInj($database_name) || hasHeaderInj($database_username) || hasHeaderInj($database_password) ) {
     die();
   }
   
  //Check to confirm all fields are supplied with data.
  if (empty($database_host) || empty($database_username) || empty($database_name))
   {
   echo "<b class='text-danger'>All fields are required! Please re-enter.</b><br />";
  } 
  elseif(!mysqli_connect($database_host,$database_username,$database_password) )
  {
  echo "<b class='text-danger'>Access has been denied. Incorrect Database connection provided.</b><br />";
   }
  else {
   $connection =  mysqli_connect($database_host, $database_username, $database_password);
    if (!$connection) {
     die('QUERY FAILED' . mysqli_error($connection));
   }

   


/**
* @ $sql / Create Database
*
* @ $filename / restoring database from dump file / You can change this to the name of your SQL dump file
*
* Ensure that your dump file has .sql extension
*
*
* @ $f / write server details into the db.php file 
*
*/
  $sql = "CREATE DATABASE $database_name";
   if (mysqli_query($connection,$sql)) {
     echo "<b class='text-success'>Database Created Successfully</b>";
   } else {
    echo "Error Creating Database" . mysqli_error($connection);
   }



          // Name of the file
$filename = 'inc/data.sql'; 
        
// Connect to MySQL server
$connet = mysqli_connect($database_host, $database_username, $database_password) or die('Error connecting to MySQL server: ' . mysqli_error($connet));
// Select database
mysqli_select_db($connet,$database_name) or die('Error selecting MySQL database: ' . mysqli_error($connet));

// Temporary variable, used to store current query
$templine = '';
// Read in entire file
$lines = file($filename);
// Loop through each line
foreach ($lines as $line)
{
// Skip it if it's a comment
if (substr($line, 0, 2) == '--' || $line == '')
    continue;

// Add this line to the current segment
$templine .= $line;
// If it has a semicolon at the end, it's the end of the query
if (substr(trim($line), -1, 1) == ';')
{
    // Perform the query
    mysqli_query($connet,$templine) or print('Error performing query \'<strong>' . $templine . '\': ' . mysqli_error() . '<br /><br />');
    // Reset temp variable to empty
    $templine = '';
  }
}
 echo "<b class='text-success'>Tables imported successfully</b>";



$f=fopen("inc/db.php","w");
   $database_inf="<?php
     define('DATABASE_HOST', '".$database_host."');
     define('DATABASE_NAME', '".$database_name."');
     define('DATABASE_USERNAME', '".$database_username."');
     define('DATABASE_PASSWORD', '".$database_password."');
     ?>";
      

  if (fwrite($f,$database_inf)>0){
   fclose($f);
      }
  header("Location: install.php?step=4");
    }
  }
?>
<h2>Step 3</h2>
    <h3 class="text-success">Provide Connection to Your Database</h3>
    <h5 class="text-warning">Ensure that you have a valid Username and Password to access your MySql.<br>
    You can just specify a Database name and it will be created automatically</h5>
 <form  class="form-group" method="post" action="install.php?step=3">
      <p>
    <label for="database_host">Database Host</label>
       <input type="text" class="form-control" name="database_host" value="<?php if (isset($database_host)) {echo $database_host;} ?>" size="30">
     </p>
     <p>
    <label for="database_name">Database Name</label>
       <input type="text" class="form-control" name="database_name" size="30" value="<?php if (isset($database_name)) {echo $database_name;} ?>">
     </p>
     <p>
    <label for="database_username">Database Username</label>
       <input type="text" class="form-control" name="database_username" size="30" value="<?php if (isset($database_username)) {echo $database_username;} ?>">
     </p>
     <p>
    <label for="database_password">Database Password</label>
       <input type="text" class="form-control" name="database_password" size="30" value="<?php if (isset($database_password)) {echo $database_password;} ?>">
      </p>
      <br/>
     <p>
       <input class="btn btn-primary" type="submit" name="submit" value="Install!">
      </p>
 </form>
<?php
}

/**
* function step_4()
*
* The Success page after registration.
* 
*
*/
function step_4(){
?>
<h2>Step 4</h2>
<h1 class="text-success">Success!</h1>

<h3 class="text-danger">NEXT STEPS:</h3>
    <p>1. Visit your website here: <a href="<?php $url="http://".$_SERVER['HTTP_HOST']; echo $url;?>">(open in a new page)</a>.<br>
       2. Register an account on the website. This account will be your admin account. You don't need to confirm your mail.<br>
	   3. Once you have registered, open installer 2: <a href="<?php $url="http://".$_SERVER['HTTP_HOST']; echo $url;?>/install2.php">(open in a new page)</a>.<br>
	   4. Now sign in to your website: <a href="<?php $url="http://".$_SERVER['HTTP_HOST']; echo $url;?>/sign-in.php">(open in a new page)</a>.<br>
	   5. After you have signed in, you will be redirected to our webite (trafix.ga). Don't worry, this is normal.<br>
	   6. Visit this link to edit your "Website URL": <a href="<?php $url="http://".$_SERVER['HTTP_HOST']; echo $url;?>/members/admin-settings.php">Admin settings</a>.<br>
	   7. <b>DELETE install.php and install2.php from your server!!</b>
    </p>


<?php 
}
?>

</div>
</div>




<!-- row 4 -->
<footer class="footer">
      <div class="container">
         <p> All Rights Reserved. <a href="http://codecanyon.net/item/simple-installer/13290225" target="_blank">Installer powered by appify</a></p>
      </div>
    </footer>

</div><!--close of container-->
<!-- jQuery (necessary for Bootstrap's JavaScript plugins) -->
    <script src="scripts/assets/js/jquery-1.11.3.min.js"></script>
    <script src="scripts/assets/js/bootstrap.min.js"></script>
    <script src="scripts/assets/js/custom.js"></script>
    <script src="scripts/assets/js/respond.js"></script>
</body>
</html>