<?php
if (! isset ( $site )) {
	include 'inc/config.php';
}

// Generate confirmation key and send.
if (isset ( $_POST ['forgot-email'] )) {
	
	// Get email address and ID
	$stmt = $mysqli->prepare ( 'SELECT id, email FROM `users` WHERE `email` = ?' );
	$stmt->bind_param ( 's', $_POST ['forgot-email'] );
	$stmt->execute ();
	$stmt->bind_result ( $userid, $email );
	$stmt->fetch ();
	$stmt->close ();
	
	if ($userid) {
		
		// Insert new confirmation key
		$key = md5 ( uniqid () . mt_rand () );
		$stmt = $mysqli->prepare ( 'REPLACE INTO `forgot_password`
		(`user_id`, `confirmation_key`,`ip_address`)
		VALUES(?, ?, ?)' );
		$stmt->bind_param ( 'iss', $userid, $key, $_SERVER ['REMOTE_ADDR'] );
		$stmt->execute ();
		
		// Send email
		require_once ('inc/mailer/class.phpmailer.php');
		$mail = new PHPMailer ();
		$body = file_get_contents ( $site ['url'] . '/tpl/mail/lostpassword.email.php?key=' . $key );
		$body = preg_replace ( "[\\\]", '', $body );
		// $mail->IsSMTP(); // telling the class to use SMTP
		// $mail->Host = "hostname"; // SMTP server
		// $mail->SMTPDebug = 0; // enables SMTP debug information (for testing)
		// $mail->SMTPAuth = true; // enable SMTP authentication
		// $mail->Port = 25; // set the SMTP port for the MAIL server
		// $mail->Username = "username"; // SMTP account username
		// $mail->Password = "password"; // SMTP account password
		
		$mail->SetFrom ( $site ['email'], $site ['name'] );
		$mail->AddReplyTo ( $site ['email'], $site ['name'] );
		$mail->Subject = "Welcome to " . $site ['name'];
		$mail->AltBody = "To view the message, please use an HTML compatible email viewer!"; // optional, comment out and test
		$mail->MsgHTML ( $body );
		$mail->AddAddress ( $email, $email );
		$mail->Send ();
		$success = 'Please check your email and enter the confirmation key below.';
	}
	else{
		$error = 'The email you entered does not exist in our system';
	}
}

// Reset Password
if (isset ( $_POST ['confirmation-key'] )) {
	
	if ($_POST ['password'] == $_POST ['password2']) {
		
		// Check confirmation table
		$stmt = $mysqli->prepare ( 'SELECT `user_id` FROM `forgot_password` WHERE `active` = 1 AND `ip_address` = ? AND `confirmation_key` = ?' );
		$stmt->bind_param ( 'ss', $_SERVER ['REMOTE_ADDR'], $_POST ['confirmation-key'] );
		$stmt->execute ();
		$stmt->bind_result ( $userid );
		$stmt->fetch ();
		$stmt->close ();
		
		// Set confirmation key inactive
		$stmt = $mysqli->prepare ( 'UPDATE `forgot_password` SET `active` = 0 WHERE `user_id` = ?' );
		$stmt->bind_param ( 'i', $userid );
		$stmt->execute ();
		
		if ($userid) {
			// Generate new hash
			$salt = generate_salt ();
			$password = crypt ( $_POST ['password'], $salt );
			
			$stmt = $mysqli->prepare ( 'UPDATE `users` SET `pass` = ?, `salt` = ? WHERE `id` = ?' );
			$stmt->bind_param ( 'ssi', $password, $salt, $userid );
			if ($stmt->execute ()) {
				$success = "Your new password has been set.";
			} else {
				$error = "Database error.  The new password could not be set.";
			}
		} else {
			$error = "Confirmation key does not match.";
		}
	} else {
		$error = "Passwords do not match.";
	}
}

?>
<!DOCTYPE html>
<!--[if lt IE 7]><html class="no-js lt-ie9 lt-ie8 lt-ie7"> <![endif]-->
<!--[if IE 7]><html class="no-js lt-ie9 lt-ie8"> <![endif]-->
<!--[if IE 8]><html class="no-js lt-ie9"> <![endif]-->
<!--[if gt IE 8]><!-->
<html class="no-js">
<!--<![endif]-->
<head>
<meta charset="utf-8">
<meta http-equiv="X-UA-Compatible" content="IE=edge,chrome=1">
<title><?=$site['name'];?> | Sign In</title>
<meta name="description" content="<?=$site['description'];?>">
<meta name="keywords" content="<?=$site['name'];?> sign in">

<!-- Le styles -->
<link
	href='http://fonts.googleapis.com/css?family=Open+Sans:300italic,400italic,700italic,400,300,700'
	rel='stylesheet' type='text/css'>
<link href="tpl/css/core.min.css" rel="stylesheet">

<script src="tpl/js/libs/modernizr-2.6.1.min.js"></script>

<!-- HTML5 shim, for IE6-8 support of HTML5 elements -->
<!--[if lt IE 9]>
	<script src="http://html5shim.googlecode.com/svn/trunk/html5.js"></script>
	<![endif]-->

<!-- icons -->
<link rel="shortcut icon" href="tpl/ico/favicon.ico">

<link rel="apple-touch-icon-precomposed" sizes="144x144"
	href="<?=$site['url'];?>/tpl/img/logo.png">
<link rel="apple-touch-icon-precomposed" sizes="114x114"
	href="<?=$site['url'];?>/tpl/img/logo.png">
<link rel="apple-touch-icon-precomposed" sizes="72x72"
	href="<?=$site['url'];?>/tpl/img/logo.png">
<link rel="apple-touch-icon-precomposed"
	href="<?=$site['url'];?>/tpl/img/logo.png">

<!-- Facebook Open Graph -->
<meta property="og:image" content="<?=$site['url'];?>/tpl/img/logo.png">
<meta property="og:title" content="<?=$site['index-title'];?>">
<meta property="og:url" content="<?=$site['url'];?>">
<meta property="og:site_name" content="<?=$site['name'];?>">
<meta property="og:type" content="Web Application">
<style>
.error {	
	background-color: #CC6666;
	padding: 1px;
	color: White;
	margin: 1px;
	text-align: center;
}

.success {
	background-color: #66CC00;
	padding: 1px;
	color: White;
	margin: 1px;
	border: 1px solid green;
	text-align: center;
}
</style>
</head>
<body class="sign-in-page">

	<section class="sign-in">
		<div class="container">
<?php if(isset($error)) { ?>
	<div class="error"><?=$error;?></div>
<?php }if(isset($success)) { ?>
	<div class="success"><?=$success;?></div>
<?php }?>
		<center>
				<a href="sign-in.php">Return to Login Page</a>
			</center>
			<div class="module mod-sign-in" style="margin-top: -250px;">
				<div class="logo">
					<a href="/"><img src="/members/img/template_logo.png" alt="Home Icon"></a>
				</div>
				<form method="post">
					<h3 style="color: grey;">Forgot Password Confirmation</h3>
					<input name="confirmation-key" type="text" id="inputKey"
						placeholder="Confirmation Key"> <input name="password"
						type="password" id="inputPassword" placeholder="New Password"> <input
						name="password2" type="password" id="inputPassword2"
						placeholder="Confirm New Password">

					<button type="submit" class="btn btn-primary btn-large">
						<i class="icon-lock"></i> Reset Password
					</button>
			
			</div>

		</div>
	</section>

	<script
		src="//ajax.googleapis.com/ajax/libs/jquery/1.8.0/jquery.min.js"></script>
	<script>window.jQuery || document.write('<script src="tpl/js/libs/jquery-1.8.0.min.js"><\/script>')</script>

	<script src="tpl/js/libs/bootstrap.min.js"></script>
	<script src="tpl/js/libs/jquery.placeholder.min.js"></script>
	<script src="tpl/js/app.js"></script>

<?php
include ('common/analytics.php');
$mysqli->Close();
?>
