<?php
extract( shortcode_atts( array(
	'link' => '',
	'title' => __( 'Text on the button', 'tomjerry' ),
	'color' => '',
	'icon' => '',
	'size' => '',
	'style' => '',
	'el_class' => '',
	'align' => ''
), $atts ) );

$class = 'vc_btn';
//parse link
$link = ( $link == '||' ) ? '' : $link;
$link = vc_build_link( $link );
$a_href = $link['url'];
$a_title = $link['title'];
$a_target = $link['target'];

$class .= ( $color != '' ) ? ( ' vc_btn_' . $color . ' vc_btn-' . $color ) : '';
$class .= ( $size != '' ) ? ( ' vc_btn_' . $size . ' vc_btn-' . $size ) : '';
$class .= ( $style != '' ) ? ' vc_btn_' . $style : '';

$el_class = $this->getExtraClass( $el_class );
$css_class = apply_filters( VC_SHORTCODE_CUSTOM_CSS_FILTER_TAG, ' ' . $class . $el_class, $this->settings['base'], $atts );
?>
<a class="<?php esc_attr_e( trim( $css_class ) ); ?>" href="<?php esc_url_e( $a_href ) ?>"
	<?php if ( ! empty( $a_title ) ) printf( 'title="%s"', esc_attr( $a_title ) ) ?>
	<?php if ( ! empty( $a_target ) ) printf( 'target="%s"', esc_attr( $a_target ) ) ?>
>
	<?php esc_html_e( $title ) ?>
</a>
<?php echo $this->endBlockComment( 'vc_button' ) . "\n";