<?php
/**
 * WARNING: This file is part of the OptionsPlus library. DO NOT edit
 * this file under any circumstances.
 */
namespace OptionsPlus\Options\Control;

/**
 * Prevent direct access to this file
 */
defined( 'ABSPATH' ) or die();


/**
 * This class will be present an dimension control
 */
class Dimension extends \OptionsPlus\Options\Control
{
	/**
	 * The control type
	 * 
	 * @var  string
	 */
	public $type = 'dimension';

	public $fields = array();
	
	/**
	 * Render the control markup
	 * 
	 * @return  void
	 */
	public function render_content() {
		$name = '_options-dimension-' . $this->id;
		$values = $this->value();
		$fields = $this->fields;

		if ( ! is_array( $values ) )
			$values = explode( ',', $this->value() );

		$field_index = 0;
		?>
		<div class="options-control-inputs">
			<?php foreach ( $fields as $id => $title ): ?>
				<label for="<?php esc_attr_e( $name . '_' . $id ) ?>">
					<span><?php esc_html_e( $title ) ?></span>
					<input type="text" name="op-options[<?php esc_attr_e( $this->id ) ?>][]"
						   value="<?php esc_attr_e( $values[$field_index++] ) ?>"
						   id="<?php esc_attr_e( $name . '_' . $id ) ?>" />
				</label>
			<?php endforeach ?>
		</div>
		<?php
	}
}
