<?php
/**
 * WARNING: This file is part of the OptionsPlus library. DO NOT edit
 * this file under any circumstances.
 */
namespace OptionsPlus\Options\Control;

/**
 * Prevent direct access to this file
 */
defined( 'ABSPATH' ) or die();


/**
 * This class will be present an colorpicker control
 */
class ColorPicker extends \OptionsPlus\Options\Control
{
	/**
	 * The control type
	 * 
	 * @var  string
	 */
	public $type = 'color-picker';

	/**
	 * Enqueue assets for this control
	 * 
	 * @return  void
	 */
	public function enqueue() {
		wp_enqueue_style( 'op-colpick' );
		wp_enqueue_script( 'op-colpick' );
	}
	
	/**
	 * Render the control markup
	 * 
	 * @return  void
	 */
	public function render_content() {
		$name = '_options-control-color-picker-' . $this->id;
		$default = $this->default;
		?>
			<div class="options-control-inputs">
				<input type="text" id="<?php esc_attr_e( $name ) ?>" name="op-options[<?php esc_attr_e( $this->id ) ?>]" value="<?php esc_attr_e( $this->value() ); ?>" />
				<button type="button" class="options-control-preview" style="background-color: <?php esc_attr_e( $this->value() ) ?>;"></button>
				<div class="colorpicker-panel"></div>
			</div>
		<?php
	}
}
