<?php
/**
 * WARNING: This file is part of the Tom & Jerry theme. DO NOT edit
 * this file under any circumstances.
 */

/**
 * Prevent direct access to this file
 */
defined( 'ABSPATH' ) or die();

/**
 * @package     Padora
 * @subpackage  Widgets
 */
class TomJerry_Recent_Posts extends TomJerry_Widget
{
	public function __construct() {
		parent::__construct( 'tomjerry_recent_posts', __( 'Tom & Jerry: Recent Posts', 'tomjerry' ), array(
				'description' => __( 'Your site\'s most recent Posts.', 'tomjerry' )
			) );
	}

	/**
	 * Display widget to the frontend
	 * 
	 * @param   array  $args     Widget arguments
	 * @param   array $instance  Saved options from database
	 * 
	 * @return  void
	 */
	public function widget( $args, $instance ) {
		$params = array_merge( array(
			'class'        => '',
			'css'          => '',
			
			'title'        => __( 'Recent Posts', 'tomjerry' ),
			'category'     => '',
			'tag'          => '',
			'layout'       => 'grid', // grid, masonry, list
			'grid_columns' => 3,
			'hide_content' => '',
			'content_length'    => 40,

			'hide_readmore' => '',
			'readmore_text' => __( 'Continue &rarr;', 'tomjerry' ),
			
			'icon'         => 'post-thumbnail',
			'limit'        => 9,
			'offset'       => 0
		), $instance );

		if ( $params['hide_content'] === true )  $params['hide_content'] = 'yes';
		if ( $params['hide_readmore'] === true ) $params['hide_readmore'] = 'yes';

		echo $args['before_widget'];

		if ( ! empty( $instance['title'] ) ) {
			echo $args['before_title'];
			echo wp_kses_post( apply_filters( 'widget_title', $instance['title'] ) );
			echo $args['after_title'];
		}

		unset( $params['title'] );
		echo themekit_shortcode_posts( $params );
		echo $args['after_widget'];
	}

	/**
	 * Setup options for this widget
	 * 
	 * @return  void
	 */
	protected function setup() {
		$this->sections['all'] = array(
			'title' => __( 'All Options', 'tomjerry' )
		);
		
		$this->options = array(
			'title' => array(
				'type'    => 'text',
				'label'   => __( 'Widget Title', 'tomjerry' ),
				'default' => __( 'Recent Posts', 'tomjerry' ),
				'section' => 'all'
			),

			'category' => array(
				'type'    => 'checkboxes',
				'label'   => __( 'Filter By Categories', 'tomjerry' ),
				'default' => array(),
				'section' => 'all',
				'choices' => array( $this, 'get_categories' )
			),

			'tag' => array(
				'type'    => 'text',
				'label'   => __( 'Filter By Tags', 'tomjerry' ),
				'default' => '',
				'section' => 'all'
			),

			'layout' => array(
				'type'    => 'dropdown',
				'label'   => __( 'Layout', 'tomjerry' ),
				'default' => 'list',
				'section' => 'all',
				'choices' => array(
					'grid'     => __( 'Grid', 'tomjerry' ),
					'list'     => __( 'List', 'tomjerry' ),
					'carousel' => __( 'Carousel', 'tomjerry' )
				)
			),

			'grid_columns' => array(
				'type' => 'dropdown',
				'label' => __( 'Columns', 'tomjerry' ),
				'default' => 1,
				'section' => 'all',
				'choices' => array(
					1 => __( '1 Column', 'tomjerry' ),
					2 => __( '2 Columns', 'tomjerry' ),
					3 => __( '3 Columns', 'tomjerry' ),
					4 => __( '4 Columns', 'tomjerry' )
				)
			),

			'offset' => array(
				'type'    => 'text',
				'label'   => __( 'Posts Offset', 'tomjerry' ),
				'default' => 0,
				'section' => 'all'
			),

			'limit' => array(
				'type'    => 'text',
				'label'   => __( 'Limit', 'tomjerry' ),
				'default' => 9,
				'section' => 'all'
			),

			'icon' => array(
				'type'    => 'dropdown',
				'label'   => __( 'Icon For Posts', 'tomjerry' ),
				'default' => 1,
				'section' => 'all',
				'choices' => array(
					'post-thumbnail' => __( 'Post Thumbnail', 'tomjerry' ),
					'post-date'      => __( 'Post Date', 'tomjerry' ),
					'post-format'    => __( 'Post Format Icon', 'tomjerry' )
				)
			),

			'hide_content' => array(
				'type'    => 'switcher',
				'label'   => __( 'Hide Post Content', 'tomjerry' ),
				'default' => false,
				'section' => 'all'
			),

			'hide_readmore' => array(
				'type'    => 'switcher',
				'label'   => __( 'Hide Read More Link', 'tomjerry' ),
				'default' => false,
				'section' => 'all'
			),

			'readmore_text' => array(
				'type'    => 'text',
				'label'   => __( 'Read More Text', 'tomjerry' ),
				'default' => __( 'Continue &rarr;', 'tomjerry' ),
				'section' => 'all'
			),

			'class' => array(
				'type'    => 'text',
				'label'   => __( 'Extra Classes', 'tomjerry' ),
				'default' => '',
				'section' => 'all'
			),
		);
	}

	public function get_categories() {
		$categories     = array();
		$raw_categories = get_categories();

		foreach ( $raw_categories as $category ) {
			$categories[$category->slug] = $category->name;
		}

		return $categories;
	}
}
