<?php
/**
 * WARNING: This file is part of the Tom & Jerry theme. DO NOT edit
 * this file under any circumstances.
 */

/**
 * Prevent direct access to this file
 */
defined( 'ABSPATH' ) or die();

// Override theme options for team members page
add_filter( 'op/prepare_options', 'tomjerry_members_override_options' );

function tomjerry_members_override_options( $options ) {
	if ( is_admin() ) return $options;

	// Overriding options for archive page
	if ( is_post_type_archive( 'member' ) || is_tax( 'member-category' ) ) {
		$options['sidebar_layout']    = $options['members_archive_sidebar_layout'];
		$options['sidebar_default']   = $options['members_archive_sidebar'];

		$options['blog_archive_pagination_style'] = $options['members_archive_pagination_style'];
		$options['blog_posts_per_page']           = $options['members_posts_per_page'];
	}
	else if ( is_singular( 'member' ) ) {
		$options['sidebar_layout']    = $options['members_single_sidebar_layout'];
		$options['sidebar_default']   = $options['members_single_sidebar'];
	}

	return $options;
}



if ( ! function_exists( 'tomjerry_members_pagination_limit' ) ) {
	add_filter( 'option_posts_per_page', 'tomjerry_members_pagination_limit' );

	function tomjerry_members_pagination_limit( $value ) {
		if ( is_post_type_archive( 'member' ) || is_tax( 'member-category' ) )
			$value = op_option( 'members_posts_per_page', $value );

		return $value;
	}
}