<?php
/**
 * WARNING: This file is part of the Tom & Jerry theme. DO NOT edit
 * this file under any circumstances.
 */

/**
 * Prevent direct access to this file
 */
defined( 'ABSPATH' ) or die();

/**
 * Register filter for append custom class name
 * that generated from visual-composer
 */
add_filter( 'themekit/shortcode/testimonial_class', 'tomjerry_custom_shortcodes_class', 10, 2 );
add_action( 'vc_before_init', 'tomjerry_testimonial_shortcode_params' );

function tomjerry_testimonial_shortcode_params() {
	/**
	 * Map the single testimonial item
	 */
	vc_map( array(
		'base'        => 'testimonial',
		'name'        => __( 'Tom & Jerry: Testimonial', 'tomjerry' ),
		'icon'        => 'tomjerry-shortcode',
		'category'    => __( 'tomjerry', 'tomjerry' ),
		'params'      => array(
			array(
				'type'        => 'textfield',
				'heading'     => __( 'Name', 'tomjerry' ),
				'param_name'  => 'name'
			),

			array(
				'type'       => 'attach_image',
				'heading'    => __( 'Image', 'tomjerry' ),
				'param_name' => 'image'
			),

			array(
				'type'             => 'textfield',
				'heading'          => __( 'Subtitle', 'tomjerry' ),
				'param_name'       => 'subtitle',
			),

			array(
				'type'             => 'textfield',
				'heading'          => __( 'Company', 'tomjerry' ),
				'param_name'       => 'company',
			),

			array(
				'type'             => 'textfield',
				'heading'          => __( 'Link', 'tomjerry' ),
				'param_name'       => 'link'
			),

			array(
				'type'       => 'textarea',
				'heading'    => __( 'Content', 'tomjerry' ),
				'param_name' => 'content'
			),

			array(
				'type'       => 'textfield',
				'heading'    => __( 'Extra Class', 'tomjerry' ),
				'param_name' => 'class'
			),

			array(
				'type' => 'css_editor',
				'param_name' => 'css',
				'group' => __( 'Design Options', 'tomjerry' )
			)
		)
	) );
}
