<?php
/**
 * WARNING: This file is part of the Tom & Jerry theme. DO NOT edit
 * this file under any circumstances.
 */

/**
 * Prevent direct access to this file
 */
defined( 'ABSPATH' ) or die();

/**
 * Register filter for append custom class name
 * that generated from visual-composer
 */
add_filter( 'themekit/shortcode/posts_class', 'tomjerry_custom_shortcodes_class', 10, 3 );
add_action( 'vc_before_init', 'tomjerry_post_shortcode_params' );

function tomjerry_post_shortcode_params() {
	/**
	 * Map the testimonial slider shortcode
	 */
	vc_map( array(
		'name'                    => __( 'Tom & Jerry: Blog Posts', 'tomjerry' ),
		'base'                    => 'posts',
		'params'                  => array(
			array(
				'type'        => 'textfield',
				'heading'     => __( 'Widget Title', 'tomjerry' ),
				'param_name'  => 'title',
				'description' => __( 'Enter text which will be used as widget title. Leave blank if no title is needed.', 'tomjerry' )
			),
			array(
				'type'        => 'textfield',
				'heading'     => __( 'Category', 'tomjerry' ),
				'param_name'  => 'category',
				'description' => __( 'Enter the category\'s slug that will be used to filter posts', 'tomjerry' )
			),
			array(
				'type'        => 'textfield',
				'heading'     => __( 'Tag', 'tomjerry' ),
				'param_name'  => 'tag',
				'description' => __( 'Enter the tag\'s slug that will be used to filter posts', 'tomjerry' )
			),
			array(
				'type'       => 'dropdown',
				'heading'    => __( 'Layout', 'tomjerry' ),
				'param_name' => 'layout',
				'value'      => array(
					__( 'Grid', 'tomjerry' ) => 'grid',
					__( 'List', 'tomjerry' ) => 'list',
					__( 'Carousel', 'tomjerry' ) => 'carousel'
				)
			),
			array(
				'type'        => 'dropdown',
				'heading'     => __( 'Grid Columns', 'tomjerry' ),
				'param_name'  => 'grid_columns',
				'description' => __( 'The number of columns for grid and grid masonry layout', 'tomjerry' ),
				'value'       => array(
					__( '1 Column', 'tomjerry' ) => 1,
					__( '2 Columns', 'tomjerry' ) => 2,
					__( '3 Columns', 'tomjerry' ) => 3,
					__( '4 Columns', 'tomjerry' ) => 4
				)
			),
			array(
				'type'        => 'textfield',
				'heading'     => __( 'Limit', 'tomjerry' ),
				'param_name'  => 'limit',
				'description' => __( 'The number of posts will be shown', 'tomjerry' ),
				'value'       => 9
			),
			array(
				'type'        => 'textfield',
				'heading'     => __( 'Offset', 'tomjerry' ),
				'param_name'  => 'offset',
				'description' => __( 'The number of posts to pass over', 'tomjerry' ),
				'value'       => 0
			),
			array(
				'type'       => 'dropdown',
				'heading'    => __( 'Icon For Posts', 'tomjerry' ),
				'param_name' => 'icon',
				'value'      => array(
					__( 'Post Thumbnail', 'tomjerry' ) => 'post-thumbnail',
					__( 'Post Format Icon', 'tomjerry' ) => 'post-format',
					__( 'Post Date', 'tomjerry' ) => 'post-date'
				)
			),
			array(
				'type'       => 'checkbox',
				'heading'    => __( 'Hide Post Content', 'tomjerry' ),
				'param_name' => 'hide_content',
				'value'      => array(
					__( 'Yes, please', 'tomjerry' ) => 'yes'
				)
			),
			array(
				'type'       => 'textfield',
				'heading'    => __( 'Post Content Length', 'tomjerry' ),
				'param_name' => 'content_length',
				'value'      => 40
			),
			array(
				'type'       => 'checkbox',
				'heading'    => __( 'Hide Read More', 'tomjerry' ),
				'param_name' => 'hide_readmore',
				'value'      => array(
					__( 'Yes, please', 'tomjerry' ) => 'yes'
				)
			),
			array(
				'type'       => 'textfield',
				'heading'    => __( 'Read More Text', 'tomjerry' ),
				'param_name' => 'readmore_text',
				'value'      => __( 'Continue &rarr;', 'tomjerry' )
			),

			array(
				'type'        => 'textfield',
				'heading'     => __( 'Extra class name', 'tomjerry' ),
				'param_name'  => 'class',
				'description' => __( 'If you wish to style particular content element differently, then use this field to add a class name and then refer to it in your css file.', 'tomjerry' )
			),

			array(
				'type'       => 'css_editor',
				'param_name' => 'css',
				'group'      => __( 'Design Options', 'tomjerry' )
			)
		)
	) );
}
