<?php
/**
 * WARNING: This file is part of the Tom & Jerry theme. DO NOT edit
 * this file under any circumstances.
 */

/**
 * Prevent direct access to this file
 */
defined( 'ABSPATH' ) or die();

/**
 * Register filter for append custom class name
 * that generated from visual-composer
 */
add_filter( 'themekit/shortcode/openhours_class', 'tomjerry_custom_shortcodes_class', 10, 3 );

/**
 * Register shortcode into Visual Composer
 */
add_action( 'vc_before_init', 'tomjerry_openhours_shortcode_params' );

function tomjerry_openhours_shortcode_params() {
	vc_map( array(
		'base'        => 'openhours',
		'name'        => __( 'Tom & Jerry: Open Hours', 'tomjerry' ),
		'icon'        => 'tomjerry-shortcode',
		'category'    => __( 'tomjerry', 'tomjerry' ),
		'params'      => array(
			array(
				'type'        => 'textfield',
				'heading'     => __( 'Title', 'tomjerry' ),
				'param_name'  => 'title'
			),

			array(
				'type'        => 'textarea',
				'heading'     => __( 'Description', 'tomjerry' ),
				'param_name'  => 'description'
			),

			array(
				'type'        => 'textfield',
				'heading'     => __( 'Icon', 'tomjerry' ),
				'param_name'  => 'icon',
				'description' => sprintf( __( 'FontAwesome Icon name. <a href="%s" target="blank">Full list of icons</a>', 'tomjerry' ), 'http://fontawesome.io/icons/' )
			),

			array(
				'type'       => 'attach_image',
				'heading'    => __( 'Image', 'tomjerry' ),
				'param_name' => 'image',
				'description' => __( 'Select image to replace the icon', 'tomjerry' )
			),

			array(
				'type'        => 'textfield',
				'heading'     => __( 'Monday', 'tomjerry' ),
				'param_name'  => 'monday'
			),

			array(
				'type'        => 'textfield',
				'heading'     => __( 'Tuesday', 'tomjerry' ),
				'param_name'  => 'tuesday'
			),

			array(
				'type'        => 'textfield',
				'heading'     => __( 'Wednesday', 'tomjerry' ),
				'param_name'  => 'wednesday'
			),

			array(
				'type'        => 'textfield',
				'heading'     => __( 'Thursday', 'tomjerry' ),
				'param_name'  => 'thursday'
			),

			array(
				'type'        => 'textfield',
				'heading'     => __( 'Friday', 'tomjerry' ),
				'param_name'  => 'friday'
			),

			array(
				'type'        => 'textfield',
				'heading'     => __( 'Saturday', 'tomjerry' ),
				'param_name'  => 'saturday'
			),

			array(
				'type'        => 'textfield',
				'heading'     => __( 'Sunday', 'tomjerry' ),
				'param_name'  => 'sunday'
			),

			array(
				'type' => 'css_editor',
				'param_name' => 'css',
				'group' => __( 'Design Options', 'tomjerry' )
			),

			array(
				'type'       => 'textfield',
				'heading'    => __( 'Extra Class', 'tomjerry' ),
				'param_name' => 'class'
			)
		)
	) );
}
