<?php
/**
 * WARNING: This file is part of the Tom & Jerry theme. DO NOT edit
 * this file under any circumstances.
 */

/**
 * Prevent direct access to this file
 */
defined( 'ABSPATH' ) or die();

/**
 * Register filter for append custom class name
 * that generated from visual-composer
 */
add_filter( 'themekit/shortcode/imagebox_class', 'tomjerry_custom_shortcodes_class', 10, 3 );

/**
 * Register shortcode into Visual Composer
 */
add_action( 'vc_before_init', 'tomjerry_imagebox_shortcode_params' );

function tomjerry_imagebox_shortcode_params() {
	vc_map( array(
		'base'        => 'imagebox',
		'name'        => __( 'Tom & Jerry: Image Box', 'tomjerry' ),
		'icon'        => 'tomjerry-shortcode',
		'category'    => __( 'tomjerry', 'tomjerry' ),
		'params'      => array(
			// Title
			array(
				'type'             => 'textfield',
				'heading'          => __( 'Title', 'tomjerry' ),
				'param_name'       => 'title'
			),

			array(
				'type'             => 'textfield',
				'heading'          => __( 'Subtitle', 'tomjerry' ),
				'param_name'       => 'subtitle'
			),

			array(
				'type'       => 'dropdown',
				'heading'    => __( 'Title Tag', 'tomjerry' ),
				'param_name' => 'tag',
				'value'      => array(
					'h2' => 'h2',
					'h3' => 'h3',
					'h4' => 'h4',
					'h5' => 'h5',
					'h6' => 'h6'
				)
			),

			array(
				'type'       => 'attach_image',
				'heading'    => __( 'Image', 'tomjerry' ),
				'param_name' => 'image'
			),

			array(
				'type'       => 'textarea',
				'heading'    => __( 'Description', 'tomjerry' ),
				'param_name' => 'content'
			),

			array(
				'type'       => 'textfield',
				'heading'    => __( 'Link', 'tomjerry' ),
				'param_name' => 'link'
			),

			array(
				'type'       => 'dropdown',
				'heading'    => __( 'Link Target', 'tomjerry' ),
				'param_name' => 'target',
				'value'      => array(
					'_self'   => __( '_self', 'tomjerry' ),
					'_blank'  => __( '_blank', 'tomjerry' ),
					'_parent' => __( '_parent', 'tomjerry' ),
					'_top'    => __( '_top', 'tomjerry' )
				)
			),

			array(
				'type'       => 'textfield',
				'heading'    => __( 'Extra Class', 'tomjerry' ),
				'param_name' => 'class'
			),

			array(
				'type' => 'css_editor',
				'param_name' => 'css',
				'group' => __( 'Design Options', 'tomjerry' )
			)
		)
	) );
}
