<?php
/**
 * WARNING: This file is part of the Tom & Jerry theme. DO NOT edit
 * this file under any circumstances.
 */

/**
 * Prevent direct access to this file
 */
defined( 'ABSPATH' ) or die();

if ( class_exists( 'WPBakeryShortCodesContainer' ) ) {
	/**
	 * Extended class to integrate testimonial slider with
	 * visual composer
	 */
    class WPBakeryShortCode_IconList extends WPBakeryShortCodesContainer {
    }
}

/**
 * Register filter for append custom class name
 * that generated from visual-composer
 */
add_filter( 'themekit/shortcode/iconlist_class', 'tomjerry_custom_shortcodes_class', 10, 3 );
add_filter( 'themekit/shortcode/iconlist_item_class', 'tomjerry_custom_shortcodes_class', 10, 3 );

/**
 * Register shortcode into Visual Composer
 */
add_action( 'vc_before_init', 'tomjerry_iconlist_shortcode_params' );

function tomjerry_iconlist_shortcode_params() {
	/**
	 * Map the iconlist slider shortcode
	 */
	vc_map( array(
		'name'                    => __( 'Tom & Jerry: Icon List', 'tomjerry' ),
		'base'                    => 'iconlist',
		'as_parent'               => array( 'only' => 'iconlist_item' ), // Use only|except attributes to limit child shortcodes (separate multiple values with comma)
		'content_element'         => true,
		'show_settings_on_create' => false,
		'category'    => __( 'tomjerry', 'tomjerry' ),
		'params'                  => array(
			array(
				'type' => 'textfield',
				'heading' => __( 'List Icon', 'tomjerry' ),
				'param_name' => 'icon',
				'description' => __( 'Default icon for all items in the list', 'tomjerry' )
			),
			array(
				'type' => 'attach_image',
				'heading' => __( 'List Image', 'tomjerry' ),
				'param_name' => 'image',
				'description' => __( 'Default image for all items in the list', 'tomjerry' )
			),
			array(
				'type' => 'textfield',
				'heading' => __( 'Extra class name', 'tomjerry' ),
				'param_name' => 'class',
				'description' => __( 'If you wish to style particular content element differently, then use this field to add a class name and then refer to it in your css file.', 'tomjerry' )
			),

			array(
				'type' => 'css_editor',
				'param_name' => 'css',
				'group' => __( 'Design Options', 'tomjerry' )
			)
		),
		'js_view' => 'VcColumnView'
	) );

	/**
	 * Map the single iconlist_item item
	 */
	vc_map( array(
		'base'        => 'iconlist_item',
		'name'        => __( 'Tom & Jerry: Icon List Item', 'tomjerry' ),
		'icon'        => 'tomjerry-shortcode',
		'category'    => __( 'tomjerry', 'tomjerry' ),
		'as_child'    => array( 'only' => 'iconlist' ),
		'params'      => array(
			array(
				'type' => 'textfield',
				'heading' => __( 'List Icon', 'tomjerry' ),
				'param_name' => 'icon',
				'description' => __( 'Default icon for all items in the list', 'tomjerry' )
			),
			array(
				'type' => 'attach_image',
				'heading' => __( 'List Image', 'tomjerry' ),
				'param_name' => 'image',
				'description' => __( 'Default image for all items in the list', 'tomjerry' )
			),
			array(
				'type' => 'textarea',
				'heading' => __( 'Content', 'tomjerry' ),
				'param_name' => 'content'
			),
			array(
				'type' => 'checkbox',
				'heading' => __( 'Enable Icon Circle Style', 'tomjerry' ),
				'param_name' => 'circle_style',
				'value' => array(
					__( 'Yes, please', 'tomjerry' ) => 'yes'
				)
			),
			
			array(
				'type' => 'textfield',
				'heading' => __( 'Extra class name', 'tomjerry' ),
				'param_name' => 'class',
				'description' => __( 'If you wish to style particular content element differently, then use this field to add a class name and then refer to it in your css file.', 'tomjerry' )
			),

			array(
				'type' => 'css_editor',
				'param_name' => 'css',
				'group' => __( 'Design Options', 'tomjerry' )
			)
		)
	) );
}



add_filter( 'themekit/shortcode/iconlist_item_atts', 'tomjerry_iconlist_shortcode_atts' );

function tomjerry_iconlist_shortcode_atts( $atts ) {
	$atts['circle_style'] = '';

	return $atts;
}



add_filter( 'themekit/shortcode/iconlist_item_class', 'tomjerry_iconlist_shortcode_class', 10, 2 );

function tomjerry_iconlist_shortcode_class( $classes, $atts ) {
	if ( $atts['circle_style'] == 'yes' )
		$classes[] = 'circle';

	return $classes;
}
