<?php
/**
 * WARNING: This file is part of the Tom & Jerry theme. DO NOT edit
 * this file under any circumstances.
 */

/**
 * Prevent direct access to this file
 */
defined( 'ABSPATH' ) or die();

/**
 * Register filter for append custom class name
 * that generated from visual-composer
 */
add_filter( 'themekit/shortcode/iconbox_class', 'tomjerry_custom_shortcodes_class', 10, 3 );

/**
 * Register shortcode into Visual Composer
 */
add_action( 'vc_before_init', 'tomjerry_iconbox_shortcode_params' );

/**
 * Register parameters for iconbox shortcode
 * 
 * @return  void
 */
function tomjerry_iconbox_shortcode_params() {
	vc_map( array(
		'base'        => 'iconbox',
		'name'        => __( 'Tom & Jerry: Icon Box', 'tomjerry' ),
		'icon'        => 'tomjerry-shortcode',
		'category'    => __( 'tomjerry', 'tomjerry' ),
		'params'      => array(
			array(
				'type'        => 'textfield',
				'heading'     => __( 'Icon', 'tomjerry' ),
				'param_name'  => 'icon',
				'description' => sprintf( __( 'FontAwesome Icon name. <a href="%s" target="blank">Full list of icons</a>', 'tomjerry' ), 'http://fontawesome.io/icons/' )
			),

			// Title
			array(
				'type'             => 'textfield',
				'heading'          => __( 'Title', 'tomjerry' ),
				'param_name'       => 'title',
				'edit_field_class' => 'vc_col-md-6 vc_column'
			),

			array(
				'type'       => 'dropdown',
				'heading'    => __( 'Title Element Tag', 'tomjerry' ),
				'param_name' => 'tag',
				'value'      => array(
					'h2' => 'h2',
					'h3' => 'h3',
					'h4' => 'h4',
					'h5' => 'h5',
					'h6' => 'h6'
				)
			),

			array(
				'type'       => 'textarea',
				'heading'    => __( 'Content', 'tomjerry' ),
				'param_name' => 'content'
			),

			array(
				'type'       => 'attach_image',
				'heading'    => __( 'Image', 'tomjerry' ),
				'param_name' => 'image',
				'description' => __( 'Select image to replace the icon', 'tomjerry' )
			),

			array(
				'type' => 'textfield',
				'heading' => __( 'Read More Link', 'tomjerry' ),
				'param_name' => 'link',
				'description' => __( 'Enter custom url for read more button', 'tomjerry' )
			),

			array(
				'type' => 'textfield',
				'heading' => __( 'Read More Text', 'tomjerry' ),
				'param_name' => 'text',
				'description' => __( 'Enter custom text for read more button', 'tomjerry' ),
				'value' => __( 'more...', 'tomjerry' )
			),

			array(
				'type'       => 'dropdown',
				'heading'    => __( 'Icon Position', 'tomjerry' ),
				'param_name' => 'icon_position',
				'value' => array(
					__( 'Top', 'tomjerry' ) => 'top',
					__( 'Left', 'tomjerry' ) => 'left',
					__( 'Left Inline', 'tomjerry' ) => 'inline-left',
					__( 'Right', 'tomjerry' ) => 'right'
				)
			),

			array(
				'type'       => 'dropdown',
				'heading'    => __( 'Icon Style', 'tomjerry' ),
				'param_name' => 'icon_style',
				'value' => array(
					__( 'Default', 'tomjerry' )         => '',
					__( 'Circle', 'tomjerry' )          => 'circle',
					__( 'Circle Outline', 'tomjerry' )  => 'circle-outlined',
					__( 'Rounded', 'tomjerry' )         => 'rounded',
					__( 'Rounded Outline', 'tomjerry' ) => 'outlined',
					__( 'Square', 'tomjerry' )          => 'square',
					__( 'Square Outline', 'tomjerry' )  => 'square-outlined'
				)
			),

			array(
				'type'       => 'textfield',
				'heading'    => __( 'Extra Class', 'tomjerry' ),
				'param_name' => 'class'
			),

			array(
				'type' => 'css_editor',
				'param_name' => 'css',
				'group' => __( 'Design Options', 'tomjerry' )
			)
		)
	) );
}



add_filter( 'themekit/shortcode/iconbox_atts', 'tomjerry_iconbox_shortcode_atts' );

function tomjerry_iconbox_shortcode_atts( $atts ) {
	$atts['icon_position'] = '';
	$atts['icon_style']    = '';

	return $atts;
}



add_filter( 'themekit/shortcode/iconbox_class', 'tomjerry_iconbox_shortcode_class', 10, 3 );

function tomjerry_iconbox_shortcode_class( $classes, $atts, $tag = '' ) {
	$classes[] = $atts['icon_position'];
	$classes[] = $atts['icon_style'];

	return $classes;
}
