<?php
/**
 * WARNING: This file is part of the Tom & Jerry theme. DO NOT edit
 * this file under any circumstances.
 */

/**
 * Prevent direct access to this file
 */
defined( 'ABSPATH' ) or die();

/**
 * Register filter for append custom class name
 * that generated from visual-composer
 */
add_filter( 'themekit/shortcode/counter_class', 'tomjerry_custom_shortcodes_class', 10, 3 );

/**
 * Register shortcode into Visual Composer
 */
add_action( 'vc_before_init', 'tomjerry_counter_shortcode_params' );

/**
 * Register parameters for counter shortcode
 * 
 * @return  void
 */
function tomjerry_counter_shortcode_params() {
	vc_map( array(
		'base'        => 'counter',
		'name'        => __( 'Tom & Jerry: Counter', 'tomjerry' ),
		'icon'        => 'tomjerry-shortcode',
		'category'    => __( 'tomjerry', 'tomjerry' ),
		'params'      => array(
			array(
				'type'        => 'textfield',
				'heading'     => __( 'Icon', 'tomjerry' ),
				'param_name'  => 'icon',
				'description' => sprintf( __( 'FontAwesome Icon name. <a href="%s" target="blank">Full list of icons</a>', 'tomjerry' ), 'http://fontawesome.io/icons/' )
			),

			array(
				'type'       => 'attach_image',
				'heading'    => __( 'Image', 'tomjerry' ),
				'param_name' => 'image',
				'description' => __( 'Select image to replace the icon', 'tomjerry' )
			),

			array(
				'type'             => 'textfield',
				'heading'          => __( 'Title', 'tomjerry' ),
				'param_name'       => 'title'
			),

			array(
				'type'             => 'textfield',
				'heading'          => __( 'Value', 'tomjerry' ),
				'param_name'       => 'value',
				'value'            => 0
			),

			array(
				'type'             => 'textfield',
				'heading'          => __( 'Prefix', 'tomjerry' ),
				'param_name'       => 'prefix'
			),

			array(
				'type'             => 'textfield',
				'heading'          => __( 'Suffix', 'tomjerry' ),
				'param_name'       => 'suffix'
			),

			array(
				'type'             => 'textfield',
				'heading'          => __( 'Duration', 'tomjerry' ),
				'param_name'       => 'duration',
				'value'            => 1000
			),

			array(
				'type'       => 'textfield',
				'heading'    => __( 'Extra Class', 'tomjerry' ),
				'param_name' => 'class'
			),

			array(
				'type' => 'css_editor',
				'param_name' => 'css',
				'group' => __( 'Design Options', 'tomjerry' )
			)
		)
	) );
}
