<?php
/**
 * WARNING: This file is part of the Tom & Jerry theme. DO NOT edit
 * this file under any circumstances.
 */

/**
 * Prevent direct access to this file
 */
defined( 'ABSPATH' ) or die();

/**
 * Register filter for append custom class name
 * that generated from visual-composer
 */
add_filter( 'themekit/shortcode/countdown_class', 'tomjerry_custom_shortcodes_class', 10, 3 );

/**
 * Register shortcode into Visual Composer
 */
add_action( 'vc_before_init', 'tomjerry_countdown_shortcode_params' );

/**
 * Register parameters for countdown shortcode
 *  
 * @return  void
 */
function tomjerry_countdown_shortcode_params() {
	vc_map( array(
		'base'        => 'countdown',
		'name'        => __( 'Tom & Jerry: Countdown', 'tomjerry' ),
		'icon'        => 'tomjerry-shortcode',
		'category'    => __( 'tomjerry', 'tomjerry' ),
		'params'      => array(
			array(
				'type'        => 'textfield',
				'heading'     => __( 'End Time', 'tomjerry' ),
				'param_name'  => 'time',
				'description' => __( 'Enter time format following: YYYY/MM/DD hh:mm:ss', 'tomjerry' )
			),

			array(
				'type' => 'checkbox',
				'heading' => __( 'Hide Years', 'tomjerry' ),
				'param_name' => 'hide_years',
				'value' => array( __( 'Yes, please', 'tomjerry' ) => 'yes' )
			),

			array(
				'type' => 'checkbox',
				'heading' => __( 'Hide Months', 'tomjerry' ),
				'param_name' => 'hide_months',
				'value' => array( __( 'Yes, please', 'tomjerry' ) => 'yes' )
			),

			array(
				'type' => 'checkbox',
				'heading' => __( 'Hide Weeks', 'tomjerry' ),
				'param_name' => 'hide_weeks',
				'value' => array( __( 'Yes, please', 'tomjerry' ) => 'yes' )
			),

			array(
				'type' => 'checkbox',
				'heading' => __( 'Hide Days', 'tomjerry' ),
				'param_name' => 'hide_days',
				'value' => array( __( 'Yes, please', 'tomjerry' ) => 'yes' )
			),

			array(
				'type' => 'checkbox',
				'heading' => __( 'Hide Hours', 'tomjerry' ),
				'param_name' => 'hide_hours',
				'value' => array( __( 'Yes, please', 'tomjerry' ) => 'yes' )
			),

			array(
				'type' => 'checkbox',
				'heading' => __( 'Hide Minutes', 'tomjerry' ),
				'param_name' => 'hide_minutes',
				'value' => array( __( 'Yes, please', 'tomjerry' ) => 'yes' )
			),

			array(
				'type' => 'checkbox',
				'heading' => __( 'Hide Seconds', 'tomjerry' ),
				'param_name' => 'hide_seconds',
				'value' => array( __( 'Yes, please', 'tomjerry' ) => 'yes' )
			),

			array(
				'type' => 'css_editor',
				'param_name' => 'css',
				'group' => __( 'Design Options', 'tomjerry' )
			),

			array(
				'type'       => 'textfield',
				'heading'    => __( 'Extra Class', 'tomjerry' ),
				'param_name' => 'class'
			)
		)
	) );
}
