<?php
/**
 * WARNING: This file is part of the Tom & Jerry theme. DO NOT edit
 * this file under any circumstances.
 */

/**
 * Prevent direct access to this file
 */
defined( 'ABSPATH' ) or die();


// Register hook for initialize theme options
add_action( 'init', 'tomjerry_customize_options_init' );

// Action for remove default sections & controls in customizer
add_action( 'customize_register', 'tomjerry_remove_default_sections', 99 );

// Initialize post options
add_action( 'admin_init', 'tomjerry_post_options_init' );

// Initialize page options
add_action( 'admin_init', 'tomjerry_page_options_init' );

// Migrate theme options after switched theme
add_action( 'after_switch_theme', 'tomjerry_migrate_theme_options' );

// Override theme options for specific page
add_filter( 'op/prepare_options', 'tomjerry_override_theme_options' );


/**
 * Initialize options for this theme
 * 
 * @return  void
 */
function tomjerry_customize_options_init() {
	\OptionsPlus\Customize\Manager::init( array(
		'sections' => array(
			'general'            => array( 'title' => __( 'General', 'tomjerry' ) ),
			'header'             => array( 'title' => __( 'Header', 'tomjerry' ) ),
			'footer'             => array( 'title' => __( 'Footer', 'tomjerry' ) ),
			'layout'             => array( 'title' => __( 'Layout & Styles', 'tomjerry' ) ),
			'typography'         => array( 'title' => __( 'Typography', 'tomjerry' ) ),
			'blog'               => array( 'title' => __( 'Blog', 'tomjerry' ) ),
			'members'            => array( 'title' => __( 'Team Members', 'tomjerry' ) ),
			'under-construction' => array( 'title' => __( 'Under Construction', 'tomjerry' ) )
		),

		'controls' => tomjerry_customize_options_fields(),
		'scripts'  => array( 'tomjerry-customizer-controls' )
	) );
}



/**
 * Remove the built-in sections and controls
 * 
 * @param   WP_Customize_Manager  $customize  Customize manager object
 * @return  void
 */
function tomjerry_remove_default_sections( $customize ) {
	foreach ( array( 'title_tagline', 'static_front_page', 'nav' ) as $id ) {
		if ( $section = $customize->get_section( $id ) ) {
			foreach ( $section->controls as $control )
				$customize->remove_control( $control->id );

			$customize->remove_section( $id );
		}
	}
}



/**
 * Register options for the post
 * 
 * @return  void
 */
function tomjerry_post_options_init() {
	new \OptionsPlus\Metabox\Properties( 'post-options', array(
		'label'       => __( 'Post Options', 'tomjerry' ),
		'post_types'  => 'post',
		'context'     => 'normal',
		'priority'    => 'high',
		'storage_key' => '_post_options',
		
		'show_tabs'   => false,
		'sections'    => array(
			'all' => array( 'title' => __( 'Post Options', 'tomjerry' ) ) 
		),
		'options'     => tomjerry_post_options_fields()
	) );
}



/**
 * Register options for the post
 * 
 * @return  void
 */
function tomjerry_page_options_init() {
	new \OptionsPlus\Metabox\Properties( 'page-options', array(
		'label'       => __( 'Page Options', 'tomjerry' ),
		'post_types'  => 'page',
		'context'     => 'normal',
		'priority'    => 'high',
		'storage_key' => '_page_options',

		'show_tabs'   => false,
		'sections' => array(
			'all'   => array( 'title' => __( 'General', 'tomjerry' ) )
		),

		'options' => tomjerry_page_options_fields()
	) );
}



/**
 * Callback function to migrate theme options
 * 
 * @return  void
 */
function tomjerry_migrate_theme_options() {
	$default_options = tomjerry_customize_default_options();
	$options = get_theme_mods();
	
	foreach ( $default_options as $id => $value ) {
		if ( ! isset( $options[$id] ) )
			set_theme_mod( $id, $value );
	}
}



/**
 * This action will be used to override global theme
 * options as a specific options from page
 * 
 * @param   array  $options  Global options
 * @return  array
 */
function tomjerry_override_theme_options( $options ) {
	global $post;

	if ( is_admin() ) return $options;

	// Blog options
	if ( is_search() || ( current_post_type_is( 'post' ) && ( is_home() || is_archive() || is_single() ) ) ) {
		if ( is_single() ) {
			$options['sidebar_layout'] = $options['blog_single_sidebar_layout'];
			$options['sidebar_default'] = $options['blog_single_sidebar'];
		}
		else {
			$options['sidebar_layout'] = $options['blog_archive_sidebar_layout'];
			$options['sidebar_default'] = $options['blog_archive_sidebar'];
		}
	}

	// Page options
	elseif ( is_page() ) {
		$page_options_defaults = array(
			'sidebar_layout'            => 'default',
			'enable_custom_page_header' => false,
			'breadcrumb_enabled'        => 'default',
			'topbar_enabled'            => 'default'
		);
		$page_options = array_merge( $page_options_defaults, (array) get_post_meta( get_the_ID(), '_page_options', true ) );

		// Override layout option
		if ( $page_options['sidebar_layout'] !== 'default' ) {
			$options['sidebar_layout'] = $page_options['sidebar_layout'];
			$options['sidebar_default'] = $page_options['sidebar_default'];
		}

		// Override custom page title option
		if ( isset( $page_options['enable_custom_page_header'] ) && $page_options['enable_custom_page_header'] == true ) {
			$options['pagetitle_enabled'] = $page_options['pagetitle_enabled'];
			$options['pagetitle_background'] = $page_options['pagetitle_background'];
		}

		// Override breadcrumbs options
		if ( $page_options['breadcrumb_enabled'] != 'default' ) {
			$options['breadcrumb_enabled'] = $page_options['breadcrumb_enabled'] == 'enable';
		}

		// Override topbar options
		if ( $page_options['topbar_enabled'] != 'default' ) {
			$options['topbar_enabled'] = $page_options['topbar_enabled'] == 'enable';
		}
	}
	
	return $options;
}
