<?php
/**
 * WARNING: This file is part of the Tom & Jerry theme. DO NOT edit
 * this file under any circumstances.
 */

/**
 * Prevent direct access to this file
 */
defined( 'ABSPATH' ) or die();


/**
 * Return array of fields that will be used to register
 * customizer options
 * 
 * @return  array
 */
function tomjerry_customize_options_fields() {
	static $options;

	if ( ! empty( $options ) )
		return $options;

	$options = array();

	/**
	 * General controls
	 */
	$options['siteinfo_heading'] = array(
		'type'        => 'heading',
		'title'       => __( 'Site Information', 'tomjerry' ),
		'description' => __( 'This section have basic information of your site, just change it to match with you need.', 'tomjerry' ),
		'section'     => 'general',
		'class'       => 'no-border'
	);

	$options['site_name'] = array(
		'type'     => 'text',
		'label'    => __( 'Site Name', 'tomjerry' ),
		'section'  => 'general',
		'settings' => 'blogname'
	);

	$options['site_desc'] = array(
		'type'     => 'text',
		'label'    => __( 'Site Tagline', 'tomjerry' ),
		'section'  => 'general',
		'settings' => 'blogdescription'
	);

	$options['static_frontpage_heading'] = array(
		'type'        => 'heading',
		'section'     => 'general',
		'class'       => 'no-border',
		'title'       => __( 'Static Front Page', 'tomjerry' ),
		'description' => __( 'Switch this option to use static page or posts page on the home', 'tomjerry' )
	);

	$options['static_frontpage_enabled'] = array(
		'type'     => 'radio-buttons',
		'section'  => 'general',
		'settings' => 'show_on_front',
		'choices'  => array(
			'posts' => __( 'Posts', 'tomjerry' ),
			'page'  => __( 'Static Page', 'tomjerry' )
		)
	);

	$options['static_frontpage'] = array(
		'type'     => 'dropdown-pages',
		'section'  => 'general',
		'label'    => __( 'Front Page', 'tomjerry' ),
		'settings' => 'page_on_front'
	);

	$options['posts_page'] = array(
		'type'     => 'dropdown-pages',
		'section'  => 'general',
		'label'    => __( 'Posts Page', 'tomjerry' ),
		'settings' => 'page_for_posts'
	);

	$options['general_misc_heading'] = array(
		'type'        => 'heading',
		'section'     => 'general',
		'class'       => 'no-border',
		'title'       => __( 'Misc', 'tomjerry' ),
		'description' => __( 'This section have options that allow to adding bookmark icon, social icons, ...', 'tomjerry' )
	);

	$options['gotop_enabed'] = array(
		'type'    => 'switcher',
		'label'   => __( 'Enable Go Top Button', 'tomjerry' ),
		'section' => 'general',
		'default' => true
	);

	// Site Icons
	$options['bookmark_icon'] = array(
		'type'    => 'media-picker',
		'label'   => __( 'Custom Favicon', 'tomjerry' ),
		'section' => 'general',
		'default' => \get_template_directory_uri() . '/assets/img/favicon.ico'
	);

	$options['social_links'] = array(
		'type'    => 'social-icons',
		'label'   => __( 'Social Links', 'tomjerry' ),
		'section' => 'general',
		'default' => array(
			'facebook' => 'https://facebook.com/thelinethemes',
			'twitter'  => 'https://twitter.com/linethemes'
		)
	);

	/**
	 * Styles
	 */
	$options['body_font_heading'] = array(
		'type'        => 'heading',
		'class'       => 'no-border',
		'section'     => 'typography',
		'title'       => __( 'Body Font', 'tomjerry' ),
		'description' => __( 'You can modify the font family, size, color, ... for global content.', 'tomjerry' )
	);

	$options['body_font'] = array(
		'type'    => 'typography',
		'section' => 'typography',
		'default' => array(
			'family'      => 'Raleway',
			'size'        => 14,
			'style'       => 400,
			'color'       => '#333333'
		)
	);

	$options['heading_font_heading'] = array(
		'type'        => 'heading',
		'class'       => 'no-border',
		'section'     => 'typography',
		'title'       => __( 'Heading Font', 'tomjerry' ),
		'description' => __( 'You can modify the font options for your headings. h1, h2, h3, h4, ...', 'tomjerry' )
	);

	$options['heading_font'] = array(
		'type'    => 'typography',
		'section' => 'typography',
		'fields'  => array( 'family', 'style' ),
		'default' => array(
			'family'      => 'Montserrat',
			'style'       => 400,
			'color'       => '#333333'
		)
	);

	$options['heading_fontsize'] = array(
		'type'    => 'dimension',
		'section' => 'typography',
		'class'   => 'no-label',
		'fields' => array(
			'h1' => __( 'H1 Font Size (px)', 'tomjerry' ),
			'h2' => __( 'H2 Font Size (px)', 'tomjerry' ),
			'h3' => __( 'H3 Font Size (px)', 'tomjerry' ),
			'h4' => __( 'H4 Font Size (px)', 'tomjerry' ),
			'h5' => __( 'H5 Font Size (px)', 'tomjerry' ),
			'h6' => __( 'H6 Font Size (px)', 'tomjerry' ),
		),
		'default' => array(
			0, 0, 0, 0, 0, 0
		)
	);

	$options['menu_font_heading'] = array(
		'type'        => 'heading',
		'class'       => 'no-border',
		'section'     => 'typography',
		'title'       => __( 'Menu Font', 'tomjerry' ),
		'description' => __( 'Select your custom font options for your main navigation menu.', 'tomjerry' )
	);

	$options['menu_font'] = array(
		'type'    => 'typography',
		'section' => 'typography',
		'default' => array(
			'family' => 'Montserrat',
			'size'   => 14,
			'style'  => 400,
			'color'  => '#333333'
		)
	);

	$options['font_subsets_heading'] = array(
		'type'        => 'heading',
		'class'       => 'no-border',
		'section'     => 'typography',
		'title'       => __( 'Font Subsets', 'tomjerry' ),
		'description' => __( 'Sometime you need to load extra font subsets for another languages, this options will allow to do it.', 'tomjerry' )
	);

	$options['cyrillic_subsets_enabled'] = array(
		'type'    => 'switcher',
		'section' => 'typography',
		'label'   => __( 'Cyrillic', 'tomjerry' ),
		'default' => false
	);

	$options['cyrillic_ext_subsets_enabled'] = array(
		'type'    => 'switcher',
		'section' => 'typography',
		'label'   => __( 'Cyrillic Extended', 'tomjerry' ),
		'default' => false
	);

	$options['greek_subsets_enabled'] = array(
		'type'    => 'switcher',
		'section' => 'typography',
		'label'   => __( 'Greek', 'tomjerry' ),
		'default' => false
	);
	$options['greek_ext_subsets_enabled'] = array(
		'type'    => 'switcher',
		'section' => 'typography',
		'label'   => __( 'Greek Extended', 'tomjerry' ),
		'default' => false
	);

	$options['vietnamese_subsets_enabled'] = array(
		'type'    => 'switcher',
		'section' => 'typography',
		'label'   => __( 'Vietnamese', 'tomjerry' ),
		'default' => false
	);

	$options['latin_ext_subsets_enabled'] = array(
		'type'    => 'switcher',
		'section' => 'typography',
		'label'   => __( 'Latin Extended', 'tomjerry' ),
		'default' => false
	);

	$options['devanagari_subsets_enabled'] = array(
		'type'    => 'switcher',
		'section' => 'typography',
		'label'   => __( 'Devanagari', 'tomjerry' ),
		'default' => false
	);

	/**
	 * Layout controls
	 */
	$options['scheme_color_heading'] = array(
		'type'        => 'heading',
		'class'       => 'no-border',
		'section'     => 'layout',
		'title'       => __( 'Scheme Color', 'tomjerry' ),
		'description' => __( 'Select the color that will be used for theme color.', 'tomjerry' )
	);

	$options['scheme_color'] = array(
		'type'    => 'color-picker',
		'label'   => __( 'Scheme Color', 'tomjerry' ),
		'section' => 'layout',
		'default' => '#a0ce4e'
	);

	$options['layout_heading'] = array(
		'type'        => 'heading',
		'class'       => 'no-border',
		'section'     => 'layout',
		'title'       => __( 'Layout', 'tomjerry' ),
		'description' => __( 'Choose between a full or a boxed layout to set how your website\'s layout will look like.', 'tomjerry' )
	);

	$options['layout_mode'] = array(
		'type'    => 'radio-images',
		'label'   => __( 'Display Style', 'tomjerry' ),
		'section' => 'layout',
		'choices' => array(
			'layout-wide'  => array(
				'src'     => \op_directory_uri() . '/assets/img/layout-wide.png',
				'tooltip' => __( 'Wide', 'tomjerry' )
			),

			'layout-boxed'  => array(
				'src'     => \op_directory_uri() . '/assets/img/layout-boxed.png',
				'tooltip' => __( 'Boxed', 'tomjerry' )
			),
		),
		'default' => 'layout-wide'
	);

	$options['boxed_background'] = array(
		'type'     => 'background',
		'label'    => __( 'Boxed Background', 'tomjerry' ),
		'section'  => 'layout',
		'patterns' => predefined_background_patterns(),
		'default'  => array(
			'type'     => 'none',
			'pattern'  => 'none',
			'color'    => '#fff',
			'image'    => '',
			'repeat'   => 'repeat',
			'position' => 'top-left',
			'style'    => 'scroll'
		)
	);

	$options['content_width'] = array(
		'type'    => 'text',
		'label'   => __( 'Content Width', 'tomjerry' ),
		'section' => 'layout',
		'default' => '1110px'
	);

	$options['sidebar_heading'] = array(
		'type'        => 'heading',
		'class'       => 'no-border',
		'section'     => 'layout',
		'title'       => __( 'Sidebar', 'tomjerry' ),
		'description' => __( 'Select the position of sidebar that you wish to display.', 'tomjerry' )
	);
	$options['sidebar_layout'] = array(
		'type'    => 'radio-images',
		'label'   => __( 'Sidebar Position', 'tomjerry' ),
		'section' => 'layout',
		'choices' => array(
			'no-sidebar' => array(
				'src' => \op_directory_uri() . '/assets/img/no-sidebar.png',
				'tooltip' => __( 'No Sidebar', 'tomjerry' )
			),
			'sidebar-left' => array(
				'src' => \op_directory_uri() . '/assets/img/sidebar-left.png',
				'tooltip' => __( 'Sidebar Left', 'tomjerry' )
			),
			'sidebar-right' => array(
				'src' => \op_directory_uri() . '/assets/img/sidebar-right.png',
				'tooltip' => __( 'Sidebar Right', 'tomjerry' )
			)
		),
		'default' => 'no-sidebar'
	);

	$options['sidebar_default'] = array(
		'type'    => 'dropdown-sidebars',
		'label'   => __( 'Default Sidebar', 'tomjerry' ),
		'section' => 'layout',
		'default' => 'sidebar-primary'
	);
	// End layout
		
	$options['pagetitle_heading'] = array(
		'type'        => 'heading',
		'class'       => 'no-border',
		'section'     => 'layout',
		'title'       => __( 'Page Title', 'tomjerry' ),
		'description' => __( 'In this section you can turn on/off or modify style for the Page Title.', 'tomjerry' )
	);
	$options['pagetitle_enabled'] = array(
		'type'    => 'switcher',
		'label'   => __( 'Enable Page Title', 'tomjerry' ),
		'section' => 'layout',
		'default' => true
	);

	$options['pagetitle_background'] = array(
		'type'     => 'background',
		'section'  => 'layout',
		'label'    => __( 'Background', 'tomjerry' ),
		'patterns' => predefined_background_patterns(),
		'default'  => array(
			'type'     => 'none',
			'pattern'  => 'none',
			'color'    => '#f2f2f2',
			'image'    => '',
			'repeat'   => 'repeat',
			'position' => 'top-left',
			'style'    => 'scroll'
		)
	);

	$options['pagetitle_parallax'] = array(
		'type'    => 'switcher',
		'label'   => __( 'Enable Parallax Effect', 'tomjerry' ),
		'section' => 'layout',
		'default' => false
	);

	$options['pagetitle_textcolor'] = array(
		'type'    => 'color-picker',
		'section' => 'layout',
		'label'   => __( 'Text Color', 'tomjerry' ),
		'default' => '#333333'
	);

	$options['breadcrumb_heading'] = array(
		'type'        => 'heading',
		'class'       => 'no-border',
		'section'     => 'layout',
		'title'       => __( 'Breadcrumb', 'tomjerry' ),
		'description' => __( 'Change settings for the breadcrumb.', 'tomjerry' )
	);
	$options['breadcrumb_enabled'] = array(
		'type'    => 'switcher',
		'label'   => __( 'Enable Breadcrumbs', 'tomjerry' ),
		'section' => 'layout',
		'default' => true
	);

	$options['breadcrumb_prefix'] = array(
		'type'    => 'text',
		'label'   => __( 'Breadcrumb Prefix', 'tomjerry' ),
		'section' => 'layout',
		'default' => __( 'You are here:', 'tomjerry' )
	);

	$options['breadcrumb_separator'] = array(
		'type'    => 'text',
		'label'   => __( 'Breadcrumb Separator', 'tomjerry' ),
		'section' => 'layout',
		'default' => '/'
	);

	/**
	 * Header
	 */
	$options['logo_heading'] = array(
		'type'        => 'heading',
		'class'       => 'no-border',
		'section'     => 'header',
		'title'       => __( 'Custom Logo', 'tomjerry' ),
		'description' => __( 'In this section You can upload your own custom logo, change the way your logo can be displayed', 'tomjerry' )
	);

	// Logo options
	$options['logo_image'] = array(
		'type'    => 'switcher',
		'label'   => __( 'Use Logo Image', 'tomjerry' ),
		'section' => 'header',
		'default' => true
	);

	$options['show_tagline'] = array(
		'type'    => 'switcher',
		'label'   => __( 'Display Site Tagline', 'tomjerry' ),
		'section' => 'header',
		'default' => false
	);

	$options['logo_src'] = array(
		'type'    => 'media-picker',
		'label'   => __( 'Logo', 'tomjerry' ),
		'section' => 'header',
		'default' => \get_template_directory_uri() . '/assets/img/logo.png'
	);

	$options['logo_size'] = array(
		'type'    => 'dimension',
		'label'   => __( 'Logo Size', 'tomjerry' ),
		'section' => 'header',
		'fields'  => array(
			'width'  => __( 'Width (px)', 'tomjerry' ),
			'height' => __( 'Height (px)', 'tomjerry' )
		),
		'default' => array( 178, 50 )
	);

	$options['logo_margin'] = array(
		'type'    => 'dimension',
		'label'   => __( 'Logo Margin', 'tomjerry' ),
		'section' => 'header',
		'fields'  => array(
			'top'    => __( 'Top (px)', 'tomjerry' ),
			'bottom' => __( 'Bottom (px)', 'tomjerry' )
		),
		'default' => array( 25, 25 )
	);

	$options['navigator_heading'] = array(
		'type'        => 'heading',
		'class'       => 'no-border',
		'section'     => 'header',
		'title'       => __( 'Navigator', 'tomjerry' ),
		'description' => __( 'Just select your menu that you wish assign it to the location on the theme', 'tomjerry' )
	);

	// Navigator
	$menus     = wp_get_nav_menus();
	$locations = get_registered_nav_menus();

	$choices = array( 0 => __( '- Select -', 'tomjerry' ) );

	if ( $menus ) {
		foreach ( $menus as $menu ) {
			$choices[ $menu->term_id ] = wp_html_excerpt( $menu->name, 40, '&hellip;' );
		}
	}

	foreach ( $locations as $location => $description ) {
		$menu_setting_id = "nav_menu_locations[{$location}]";

		$options["menu_location_{$location}"] = array(
			'label'    => $description,
			'section'  => 'header',
			'type'     => 'dropdown',
			'choices'  => $choices,
			'settings' => $menu_setting_id
		);
	}

	$options['header_heading'] = array(
		'type'        => 'heading',
		'class'       => 'no-border',
		'section'     => 'header',
		'title'       => __( 'Header Options', 'tomjerry' ),
		'description' => __( 'Toggle sticky header feature and turn on/off extra menu icons', 'tomjerry' )
	);

	$options['header_sticky'] = array(
		'type'    => 'switcher',
		'section' => 'header',
		'label'   => __( 'Enable Sticky Header', 'tomjerry' )
	);

	$options['header_searchbox'] = array(
		'type'    => 'switcher',
		'section' => 'header',
		'label'   => __( 'Show Search Menu', 'tomjerry' ),
		'default' => true
	);

	$options['topbar_heading'] = array(
		'type'        => 'heading',
		'class'       => 'no-border',
		'section'     => 'header',
		'title'       => __( 'Top Bar', 'tomjerry' ),
		'description' => __( 'Turn on/off the top bar and change it styles', 'tomjerry' )
	);
	$options['topbar_enabled'] = array(
		'type'    => 'switcher',
		'label'   => __( 'Enable Topbar', 'tomjerry' ),
		'section' => 'header',
		'default' => true
	);

	$options['topbar_content'] = array(
		'type'    => 'textarea',
		'label'   => __( 'Content', 'tomjerry' ),
		'section' => 'header',
		'default' => __( '<i class="fa fa-phone"></i> Call Us Today! 1.555.555.555 <span class="spacer"></span> <i class="fa fa-envelope-o"></i> support@linethemes.com', 'tomjerry' )
	);

	$options['topbar_social_links_enabled'] = array(
		'type'    => 'switcher',
		'label'   => __( 'Enable Social Links', 'tomjerry' ),
		'section' => 'header',
		'default' => true
	);
	
	/**
	 * Footer
	 */
	$options['footer_widgets_heading'] = array(
		'type'        => 'heading',
		'class'       => 'no-border',
		'section'     => 'footer',
		'title'       => __( 'Footer Widgets', 'tomjerry' ),
		'description' => __( 'This section allow to change the layout and styles of footer widgets to match as you need.', 'tomjerry' )
	);
	$options['footer_widgets_enabled'] = array(
		'type'    => 'switcher',
		'label'   => __( 'Enable Footer Widgets', 'tomjerry' ),
		'section' => 'footer',
		'default' => true
	);

	$options['footer_widgets_layout'] = array(
		'type'    => 'widgets-layout',
		'label'   => __( 'Widgets Layout', 'tomjerry' ),
		'max'     => 4,
		'section' => 'footer',
		'default' => array(
			'active' => 3,
			'layout' => array(
				array( 12 ),
				array( 6, 6 ),
				array( 4, 4, 4 ),
				array( 3, 3, 3, 3 )
			)
		)
	);

	$options['footer_widgets_background'] = array(
		'type'     => 'background',
		'section'  => 'footer',
		'label'    => __( 'Widgets Background', 'tomjerry' ),
		'patterns' => predefined_background_patterns(),
		'default'  => array(
			'type'     => 'none',
			'pattern'  => 'none',
			'color'    => '#1a1a1a',
			'image'    => '',
			'repeat'   => 'repeat',
			'position' => 'top-left',
			'style'    => 'scroll'
		)
	);

	$options['footer_widgets_textcolor'] = array(
		'type'    => 'color-picker',
		'section' => 'footer',
		'label'   => __( 'Text Color', 'tomjerry' ),
		'default' => '#666666'
	);

	$options['footer_heading'] = array(
		'type'        => 'heading',
		'class'       => 'no-border',
		'section'     => 'footer',
		'title'       => __( 'Custom Footer', 'tomjerry' ),
		'description' => __( 'You can change the copyright text, show/hide the social icons on the footer.', 'tomjerry' )
	);

	$options['footer_social_links_enabled'] = array(
		'type'    => 'switcher',
		'label'   => __( 'Enable Social Links', 'tomjerry' ),
		'section' => 'footer',
		'default' => true
	);

	$options['footer_copyright'] = array(
		'type'    => 'textarea',
		'label'   => __( 'Copyright', 'tomjerry' ),
		'section' => 'footer'
	);

	/**
	 * Blog
	 */
	$options['blog_list_heading'] = array(
		'type'        => 'heading',
		'class'       => 'no-border',
		'section'     => 'blog',
		'title'       => __( 'Blog List', 'tomjerry' ),
		'description' => __( 'All options in this section will be used to make style for blog page.', 'tomjerry' )
	);

	$options['blog_archive_sidebar_layout'] = array(
		'type'    => 'radio-images',
		'label'   => __( 'List Sidebar Position', 'tomjerry' ),
		'section' => 'blog',
		'choices' => array(
			'no-sidebar' => array(
				'src' => op_directory_uri() . '/assets/img/no-sidebar.png',
				'tooltip' => __( 'No Sidebar', 'tomjerry' )
			),
			'sidebar-left' => array(
				'src' => op_directory_uri() . '/assets/img/sidebar-left.png',
				'tooltip' => __( 'Sidebar Left', 'tomjerry' )
			),
			'sidebar-right' => array(
				'src' => op_directory_uri() . '/assets/img/sidebar-right.png',
				'tooltip' => __( 'Sidebar Right', 'tomjerry' )
			)
		),
		'default' => 'sidebar-right'
	);

	$options['blog_archive_sidebar'] = array(
		'type'    => 'dropdown-sidebars',
		'section' => 'blog',
		'label'   => __( 'Blog List Sidebar', 'tomjerry' ),
		'default' => 'sidebar-primary'
	);

	$options['blog_archive_post_excepts'] = array(
		'type'    => 'switcher',
		'label'   => __( 'Auto Post Excepts', 'tomjerry' ),
		'section' => 'blog',
		'default' => false
	);

	$options['blog_archive_post_excepts_length'] = array(
		'type'    => 'text',
		'label'   => __( 'Post Excepts Length', 'tomjerry' ),
		'section' => 'blog',
		'default' => 40
	);

	$options['blog_archive_show_post_meta'] = array(
		'type'    => 'switcher',
		'label'   => __( 'Show Post Meta', 'tomjerry' ),
		'section' => 'blog',
		'default' => true
	);

	$options['blog_archive_readmore'] = array(
		'type'    => 'switcher',
		'label'   => __( 'Show Read More', 'tomjerry' ),
		'section' => 'blog',
		'default' => true
	);

	$options['blog_archive_readmore_text'] = array(
		'type'    => 'text',
		'label'   => __( 'Read More Text', 'tomjerry' ),
		'section' => 'blog',
		'default' => __( 'Continue Read &rarr;', 'tomjerry' )
	);

	$options['blog_archive_pagination_style'] = array(
		'type'    => 'radio-images',
		'label'   => __( 'Pagination Style', 'tomjerry' ),
		'section' => 'blog',
		'default' => 'numeric',
		'choices' => array(
			'pager' => array(
				'src' => op_directory_uri() . '/assets/img/paging-pager.png',
				'tooltip' => __( 'Pager', 'tomjerry' )
			),
			'numeric' => array(
				'src' => op_directory_uri() . '/assets/img/paging-numeric.png',
				'tooltip' => __( 'Numeric', 'tomjerry' )
			),
			'pager-numeric' => array(
				'src' => op_directory_uri() . '/assets/img/paging-pager-numeric.png',
				'tooltip' => __( 'Pager & Numeric', 'tomjerry' )
			),
			'loadmore' => array(
				'src' => op_directory_uri() . '/assets/img/paging-loadmore.png',
				'tooltip' => __( 'Load More', 'tomjerry' )
			)
		)
	);

	$options['blog_posts_per_page'] = array(
		'type'     => 'spinner',
		'section'  => 'blog',
		'label'    => __( 'Posts Per Page', 'tomjerry' )
	);

	$options['blog_single_heading'] = array(
		'type'        => 'heading',
		'class'       => 'no-border',
		'section'     => 'blog',
		'title'       => __( 'Blog Single', 'tomjerry' ),
		'description' => __( 'Also, you can change the style for blog single to make your site unique.', 'tomjerry' )
	);
	
	$options['blog_single_sidebar_layout'] = array(
		'type'    => 'radio-images',
		'label'   => __( 'Single Sidebar Position', 'tomjerry' ),
		'section' => 'blog',
		'choices' => array(
			'no-sidebar' => array(
				'src' => op_directory_uri() . '/assets/img/no-sidebar.png',
				'tooltip' => __( 'No Sidebar', 'tomjerry' )
			),
			'sidebar-left' => array(
				'src' => op_directory_uri() . '/assets/img/sidebar-left.png',
				'tooltip' => __( 'Sidebar Left', 'tomjerry' )
			),
			'sidebar-right' => array(
				'src' => op_directory_uri() . '/assets/img/sidebar-right.png',
				'tooltip' => __( 'Sidebar Right', 'tomjerry' )
			)
		),
		'default' => 'sidebar-right'
	);

	$options['blog_single_sidebar'] = array(
		'type'    => 'dropdown-sidebars',
		'section' => 'blog',
		'label'   => __( 'Blog Single Sidebar', 'tomjerry' ),
		'default' => 'sidebar-primary'
	);

	$options['blog_post_navigator_enabled'] = array(
		'type'    => 'switcher',
		'label'   => __( 'Show Post Navigator', 'tomjerry' ),
		'section' => 'blog',
		'default' => true
	);

	$options['blog_author_box_enabled'] = array(
		'type'    => 'switcher',
		'label'   => __( 'Show Author Box', 'tomjerry' ),
		'section' => 'blog',
		'default' => true
	);

	$options['blog_related_box_enabled'] = array(
		'type'    => 'switcher',
		'label'   => __( 'Show Related Posts', 'tomjerry' ),
		'section' => 'blog',
		'default' => true
	);

	$options['blog_related_posts_style'] = array(
		'type'    => 'radio-images',
		'label'   => __( 'Related Posts Style', 'tomjerry' ),
		'section' => 'blog',
		'choices' => array(
			'list' => array(
				'src' => op_directory_uri() . '/assets/img/related-list.png',
				'tooltip' => __( 'Simple List', 'tomjerry' )
			),
			'grid' => array(
				'src' => op_directory_uri() . '/assets/img/blog-grid.png',
				'tooltip' => __( 'Grid', 'tomjerry' )
			),
			'masonry' => array(
				'src' => op_directory_uri() . '/assets/img/blog-masonry.png',
				'tooltip' => __( 'Masonry Grid', 'tomjerry' )
			),
			'carousel' => array(
				'src' => op_directory_uri() . '/assets/img/related-slider.png',
				'tooltip' => __( 'Carousel', 'tomjerry' )
			)
		),
		'default' => 'carousel'
	);

	$options['blog_related_posts_columns'] = array(
		'type'    => 'dropdown',
		'section' => 'blog',
		'label'   => __( 'Columns Of Related Posts', 'tomjerry' ),
		'default' => 3,
		'choices' => array(
			2 => __( '2 Columns', 'tomjerry' ),
			3 => __( '3 Columns', 'tomjerry' ),
			4 => __( '4 Columns', 'tomjerry' )
		)
	);

	$options['blog_related_posts_count'] = array(
		'type'    => 'spinner',
		'section' => 'blog',
		'label'   => __( 'Number Of Related Posts', 'tomjerry' ),
		'min'     => 1,
		'default' => 4
	);

	/**
	 * Member
	 */
	$options['members_list_heading'] = array(
		'type'        => 'heading',
		'class'       => 'no-border',
		'section'     => 'members',
		'title'       => __( 'Member List', 'tomjerry' ),
		'description' => __( 'Change options in this section to custom style for portfolio listing page.', 'tomjerry' )
	);

	$options['members_archive_sidebar_layout'] = array(
		'type'    => 'radio-images',
		'label'   => __( 'List Sidebar Position', 'tomjerry' ),
		'section' => 'members',
		'choices' => array(
			'no-sidebar' => array(
				'src' => op_directory_uri() . '/assets/img/no-sidebar.png',
				'tooltip' => __( 'No Sidebar', 'tomjerry' )
			),
			'sidebar-left' => array(
				'src' => op_directory_uri() . '/assets/img/sidebar-left.png',
				'tooltip' => __( 'Sidebar Left', 'tomjerry' )
			),
			'sidebar-right' => array(
				'src' => op_directory_uri() . '/assets/img/sidebar-right.png',
				'tooltip' => __( 'Sidebar Right', 'tomjerry' )
			)
		),
		'default' => 'sidebar-right'
	);

	$options['members_archive_sidebar'] = array(
		'type'    => 'dropdown-sidebars',
		'section' => 'members',
		'label'   => __( 'Member List Sidebar', 'tomjerry' ),
		'default' => 'sidebar-primary'
	);

	$options['members_archive_pagination_style'] = array(
		'type'    => 'radio-images',
		'label'   => __( 'Pagination Style', 'tomjerry' ),
		'section' => 'members',
		'default' => 'numeric',
		'choices' => array(
			'pager' => array(
				'src'     => op_directory_uri() . '/assets/img/paging-pager.png',
				'tooltip' => __( 'Pager', 'tomjerry' )
			),
			'numeric' => array(
				'src'     => op_directory_uri() . '/assets/img/paging-numeric.png',
				'tooltip' => __( 'Numeric', 'tomjerry' )
			),
			'pager-numeric' => array(
				'src'     => op_directory_uri() . '/assets/img/paging-pager-numeric.png',
				'tooltip' => __( 'Pager & Numeric', 'tomjerry' )
			),
			'loadmore' => array(
				'src'     => op_directory_uri() . '/assets/img/paging-loadmore.png',
				'tooltip' => __( 'Load More', 'tomjerry' )
			)
		)
	);

	$options['members_posts_per_page'] = array(
		'type'     => 'spinner',
		'section'  => 'members',
		'label'    => __( 'Posts Per Page', 'tomjerry' )
	);

	$options['members_single_heading'] = array(
		'type'        => 'heading',
		'class'       => 'no-border',
		'section'     => 'members',
		'title'       => __( 'Single Member', 'tomjerry' ),
		'description' => __( 'Change the layout, sidebar, navigator, ... for the single portfolio page.', 'tomjerry' )
	);
	
	$options['members_single_sidebar_layout'] = array(
		'type'    => 'radio-images',
		'label'   => __( 'Single Sidebar Position', 'tomjerry' ),
		'section' => 'members',
		'choices' => array(
			'no-sidebar' => array(
				'src'     => op_directory_uri() . '/assets/img/no-sidebar.png',
				'tooltip' => __( 'No Sidebar', 'tomjerry' )
			),
			'sidebar-left' => array(
				'src'     => op_directory_uri() . '/assets/img/sidebar-left.png',
				'tooltip' => __( 'Sidebar Left', 'tomjerry' )
			),
			'sidebar-right' => array(
				'src'     => op_directory_uri() . '/assets/img/sidebar-right.png',
				'tooltip' => __( 'Sidebar Right', 'tomjerry' )
			)
		),
		'default' => 'sidebar-right'
	);

	$options['members_single_sidebar'] = array(
		'type'    => 'dropdown-sidebars',
		'section' => 'members',
		'label'   => __( 'Single Member Sidebar', 'tomjerry' ),
		'default' => 'sidebar-primary'
	);

	/**
	 * Under Construction
	 */
	$options['under_construction_enabled'] = array(
		'type'    => 'switcher',
		'label'   => __( 'Enable Under Construction', 'tomjerry' ),
		'section' => 'under-construction',
		'default' => false
	);

	$options['under_construction_page_id'] = array(
		'type'     => 'dropdown-pages',
		'section'  => 'under-construction',
		'label'    => __( 'Under Construction Page', 'tomjerry' )
	);

	$options['under_construction_allowed'] = array(
		'type'    => 'checkboxes',
		'section' => 'under-construction',
		'label'   => __( 'Role-based Access Permission', 'tomjerry' ),
		'choices' => function() {
			$choices = array();

			foreach ( get_editable_roles() as $id => $params )
				$choices[$id] = $params['name'];
			
			return $choices;
		},

		'default' => array( 'administrator', 'editor' )
	);

	return $options;
}



/**
 * Return the default options of the theme
 * 
 * @return  void
 */
function tomjerry_customize_default_options() {
	return array (
		'gotop_enabed'  => true,
		'bookmark_icon' => trailingslashit( get_template_directory_uri() ) . '/assets/img/favicon.ico',
		'social_links'  => array (
			'twitter'     => 'https://twitter.com/linethemes',
			'facebook'    => 'https://facebook.com/thelinethemes',
			'google-plus' => '#',
			'pinterest'   => '#',
			'behance'     => '#'
		),
		'body_font' => array (
			'family' => 'Lato',
			'size'   => 15,
			'style'  => 400,
			'color'  => '#888'
		),
		'heading_font' => array (
			'family' => 'Raleway',
			'style'  => 600,
		),
		'heading_fontsize' => array ( 40, 36, 30, 24, 18, 14 ),
		'menu_font'        => array (
			'family' => 'Raleway',
			'size'   => 14,
			'style'  => 600,
			'color'  => '#333333',
		),
		'cyrillic_subsets_enabled'     => false,
		'cyrillic_ext_subsets_enabled' => false,
		'greek_subsets_enabled'        => false,
		'greek_ext_subsets_enabled'    => false,
		'vietnamese_subsets_enabled'   => false,
		'latin_ext_subsets_enabled'    => false,
		'devanagari_subsets_enabled'   => false,
		'scheme_color'                 => '#cba860',
		'layout_mode'                  => 'layout-wide',
		'boxed_background'             => array (
			'type'     => 'none',
			'pattern'  => 'none',
			'color'    => '#fff',
			'image'    => '',
			'repeat'   => 'repeat',
			'position' => 'top-left',
			'style'    => 'scroll'
		),
		'sidebar_layout'       => 'no-sidebar',
		'sidebar_default'      => 'sidebar-primary',
		'pagetitle_enabled'    => true,
		'pagetitle_background' => array (
			'color'    => '#83662b',
			'type'     => 'none',
			'pattern'  => 'none',
			'image'    => '',
			'repeat'   => 'no-repeat',
			'position' => 'top-center',
			'style'    => 'scroll'
		),
		'pagetitle_textcolor'         => '#fff',
		'breadcrumb_prefix'           => 'You are here:',
		'breadcrumb_separator'        => '→',
		'logo_image'                  => true,
		'show_tagline'                => false,
		'logo_src'                    => trailingslashit( get_template_directory_uri() ) . '/assets/img/logo.png',
		'logo_size'                   => array ( 266, 48 ),
		'logo_margin'                 => array ( 30, 30 ),
		'header_sticky'               => true,
		'header_searchbox'            => true,
		'topbar_enabled'              => true,
		'topbar_content'              => '<i class="fa fa-map-marker"></i> 66 Nicholson St Buffalo New York US<span class="spacer"></span><i class="fa fa-clock-o"></i> Monday - Saturday: 8:00 Am - 18:00 Pm',
		'topbar_social_links_enabled' => true,
		'footer_widgets_enabled'      => true,
		'footer_widgets_layout'       => array (
			'active' => 3,
			'layout' => array (
				array ( 12 ),
				array ( 6, 6 ),
				array ( 4, 4, 4),
				array ( 3, 3, 3, 3 ),
			),
		),
		'footer_widgets_background' => array (
			'color'    => '#222',
			'type'     => 'none',
			'pattern'  => 'none',
			'image'    => '',
			'repeat'   => 'no-repeat',
			'position' => 'center-center',
			'style'    => 'scroll'
		),
		'footer_widgets_textcolor'         => '#888',
		'footer_social_links_enabled'      => true,
		'footer_copyright'                 => 'Copyright &copy; 2015 Tom & Jerry Theme Demo. Theme by <a href="http://linethemes.com" target="_blank">Linethemes.</a>',
		'blog_archive_sidebar_layout'      => 'sidebar-right',
		'blog_archive_sidebar'             => 'sidebar-primary',
		'blog_archive_post_excepts'        => true,
		'blog_archive_post_excepts_length' => 150,
		'blog_archive_show_post_meta'      => true,
		'blog_archive_readmore'            => true,
		'blog_archive_readmore_text'       => 'Continue Read',
		'blog_archive_pagination_style'    => 'numeric',
		'blog_posts_per_page'              => 10,
		'blog_single_sidebar_layout'       => 'sidebar-right',
		'blog_single_sidebar'              => 'sidebar-primary',
		'blog_post_navigator_enabled'      => true,
		'blog_author_box_enabled'          => true,
		'blog_related_box_enabled'         => true,
		'blog_related_posts_style'         => 'grid',
		'blog_related_posts_count'         => 3,
		'blog_related_posts_columns'       => 3,
		'under_construction_enabled'       => false,
		'under_construction_page_id'       => 0,
		'under_construction_allowed'       => array ( 'administrator' ),
		'content_width'                    => '1110px',
		'pagetitle_parallax'               => true,
		'members_archive_sidebar_layout'   => 'no-sidebar',
		'members_archive_sidebar'          => 0,
		'members_single_sidebar'           => 'sidebar-1',
		'members_posts_per_page'           => 10,
		'members_single_sidebar_layout'    => 'sidebar-right',
		'members_archive_pagination_style' => 'numeric',
		'nav_menu_locations'               => array ()
	);
}



/**
 * Return array of fields that will be used to register
 * options for the post
 * 
 * @return  array
 */
function tomjerry_post_options_fields() {
	$options = array();
	$options['images_heading'] = array(
		'type'        => 'heading',
		'title'       => __( 'Gallery Images', 'tomjerry' ),
		'description' => __( 'Add images to create a slider for this post, post format "Gallery" must be checked.', 'tomjerry' ),
		'section'     => 'all'
	);

	$options['post_images'] = array(
		'type'        => 'media-list',
		'section'     => 'all',
		'media_types' => array( 'image' ),
		'default'     => array()
	);

	$options['video_heading'] = array(
		'type'        => 'heading',
		'section'     => 'all',
		'title'       => __( 'Video URL', 'tomjerry' ),
		'description' => __( 'Add an URL that linked to a video, it can be Youtube, Vimeo, ... The added video will be displayed on top of the page.', 'tomjerry' )
	);

	$options['post_video'] = array(
		'type'    => 'media-input',
		'section' => 'all',
		'library' => 'video',
		'default' => ''
	);

	$options['audio_heading'] = array(
		'type'        => 'heading',
		'section'     => 'all',
		'title'       => __( 'Audio URL', 'tomjerry' ),
		'description' => __( 'This field will be applied when post format "Audio" is checked. A audio player will be displayed on top of the post.', 'tomjerry' )
	);

	$options['post_audio'] = array(
		'type'    => 'media-input',
		'section' => 'all',
		'library' => 'audio',
		'default' => ''
	);

	$options['link_heading'] = array(
		'type'        => 'heading',
		'section'     => 'all',
		'title'       => __( 'External Link', 'tomjerry' ),
		'description' => __( 'When post format "Link" is selected you need provide a link to this field.', 'tomjerry' )
	);

	$options['post_link'] = array(
		'type'    => 'text',
		'section' => 'all',
		'default' => 'http://'
	);

	return $options;
}



/**
 * Return an array that used to declare options
 * for the page
 * 
 * @return  array
 */
function tomjerry_page_options_fields() {
	global $wp_registered_sidebars;

	$patterns = predefined_background_patterns();
	$options  = array();
	$sidebars = array();

	// Retrieve all registered sidebars
	foreach( $wp_registered_sidebars as $params )
		$sidebars[$params['id']] = $params['name'];

	/**
	 * General
	 */
	$options['layout_heading'] = array(
		'type' => 'heading',
		'section' => 'all',
		'title' => __( 'Sidebar Position', 'tomjerry' ),
		'description' => __( 'Select the position of sidebar that you wish to display.', 'tomjerry' )
	);

	$options['sidebar_layout'] = array(
		'type' => 'dropdown',
		'section' => 'all',
		'default' => 'default',
		'choices' => array(
			'default' => __( 'Default Option', 'tomjerry' ),
			'no-sidebar'   => __( 'No Sidebar', 'tomjerry' ),
			'sidebar-left'  => __( 'Left Sidebar', 'tomjerry' ),
			'sidebar-right'  => __( 'Right Sidebar', 'tomjerry' ),
		)
	);

	$options['sidebar_default'] = array(
		'type'    => 'dropdown-sidebars',
		'label'   => __( 'Custom Sidebar', 'tomjerry' ),
		'section' => 'all',
		'default' => op_option( 'sidebar_default' )
	);
	
	/**
	 * Page Title
	 */
	$options['pagetitle_heading'] = array(
		'type'        => 'heading',
		'section'     => 'all',
		'title'       => __( 'Page Title', 'tomjerry' ),
		'description' => __( 'In this section you can turn on/off or modify style for the Page Title.', 'tomjerry' )
	);

	$options['enable_custom_page_header'] = array(
		'type'    => 'switcher',
		'label'   => __( 'Enable Custom Page Title', 'tomjerry' ),
		'section' => 'all',
		'default' => false
	);

	$options['pagetitle_enabled'] = array(
		'type'    => 'switcher',
		'label'   => __( 'Display Title Bar On This Page', 'tomjerry' ),
		'section' => 'all',
		'default' => op_option( 'pagetitle_enabled' )
	);

	$options['pagetitle_background'] = array(
		'type'     => 'background',
		'label'    => __( 'Page Header Background', 'tomjerry' ),
		'section'  => 'all',
		'patterns' => $patterns,
		'default'  => op_option( 'pagetitle_background' )
	);

	/**
	 * Breadcrumbs
	 */
	$options['breadcrumb_heading'] = array(
		'type'        => 'heading',
		'section'     => 'all',
		'title'       => __( 'Breadcrumbs', 'tomjerry' ),
		'description' => __( 'In this section you can turn on/off or modify style for the Breadcrumbs.', 'tomjerry' )
	);

	$options['breadcrumb_enabled'] = array(
		'type' => 'dropdown',
		'section' => 'all',
		'default' => 'default',
		'choices' => array(
			'default' => __( 'Default Option', 'tomjerry' ),
			'enable'   => __( 'Enabled', 'tomjerry' ),
			'disable'  => __( 'Disabled', 'tomjerry' ),
		)
	);

	/**
	 * Header
	 */
	$options['topbar_heading'] = array(
		'type' => 'heading',
		'section' => 'all',
		'title' => __( 'Top Bar', 'tomjerry' ),
		'description' => __( 'Turn on/off the top bar and change it styles.', 'tomjerry' )
	);

	$options['topbar_enabled'] = array(
		'type' => 'dropdown',
		'section' => 'all',
		'default' => 'default',
		'choices' => array(
			'default' => __( 'Default Option', 'tomjerry' ),
			'enable'   => __( 'Enabled', 'tomjerry' ),
			'disable'  => __( 'Disabled', 'tomjerry' ),
		)
	);

	$options['navigator_heading'] = array(
		'type'        => 'heading',
		'section'     => 'all',
		'title'       => __( 'Navigator', 'tomjerry' ),
		'description' => __( 'Just select your menu that you wish assign it to the location on the theme.', 'tomjerry' )
	);

	// Navigator
	$menus     = wp_get_nav_menus();
	$locations = get_registered_nav_menus();

	if ( $menus ) {
		$choices = array( 'default' => __( 'Default Option', 'tomjerry' ) );
		foreach ( $menus as $menu ) {
			$choices[ $menu->term_id ] = wp_html_excerpt( $menu->name, 40, '&hellip;' );
		}

		$asigned_locations = op_option( 'nav_menu_locations' );

		foreach ( $locations as $location => $description ) {
			$menu_setting_id = "nav_menu_locations[{$location}]";

			$options["menu_location_{$location}"] = array(
				'label'   => $description,
				'section' => 'all',
				'type'    => 'dropdown',
				'choices' => $choices,
				'default' => 'default'
			);
		}
	}

	$options['onepage_nav_script'] = array(
		'type'    => 'switcher',
		'label'   => __( 'Load One Page Navigator Script', 'tomjerry' ),
		'section' => 'all',
		'default' => false
	);
	
	return $options;
}
