<?php
/**
 * @package     WordPress
 * @subpackage  Themes
 * @author      Binh Pham Thanh <binhpham@linethemes.com>
 */
if ( ! defined( 'ABSPATH' ) )
	exit;

if ( ! class_exists( 'Vc_Manager' ) )
	return;

vc_set_shortcodes_templates_dir( get_template_directory() . '/templates/vc' );

if ( ! function_exists( 'tomjerry_vs_params' ) ) {
	add_action( 'admin_init', 'tomjerry_vs_params' );

	/**
	 * This action will register custom parameter for visual composer
	 * shortcodes
	 * 
	 * @return  void
	 */
	function tomjerry_vs_params() {
		/**
		 * Row params
		 */
		vc_add_param( 'vc_row', array(
			'type'             => 'colorpicker',
			'heading'          => __( 'Font Color', 'tomjerry' ),
			'param_name'       => 'font_color',
			'description'      => __( 'Select font color', 'tomjerry' ),
			'edit_field_class' => 'vc_col-md-6 vc_column'
		) );

		vc_add_param( 'vc_row', array(
			'type'        => 'textfield',
			'heading'     => __( 'Row ID', 'tomjerry' ),
			'param_name'  => 'el_id',
			'description' => __( 'Enter custom ID for this row', 'tomjerry' ),
		) );

		vc_add_param( 'vc_row', array(
			'type'        => 'checkbox',
			'heading'     => __( 'Enable Content Width 100%', 'tomjerry' ),
			'param_name'  => 'width_100',
			'value'       => array(
				__( 'Yes, please', 'tomjerry' ) => 'yes'
			)
		) );

		vc_add_param( 'vc_row', array(
			'type'        => 'checkbox',
			'heading'     => __( 'Enable Background Parallax Effect', 'tomjerry' ),
			'param_name'  => 'parallax_effect',
			'group'       => __( 'Parallax', 'tomjerry' ),
			'value'       => array(
				__( 'Yes, please', 'tomjerry' ) => 'yes'
			)
		) );

		vc_add_param( 'vc_row', array(
			'type'        => 'textfield',
			'heading'     => __( 'Parallax Position Ratio', 'tomjerry' ),
			'param_name'  => 'parallax_speed',
			'group'       => __( 'Parallax', 'tomjerry' ),
			'value'       => 5
		) );

		vc_add_param( 'vc_row', array(
			'type'        => 'textfield',
			'heading'     => __( 'Parallax X Offset', 'tomjerry' ),
			'param_name'  => 'parallax_x',
			'group'       => __( 'Parallax', 'tomjerry' ),
			'value'       => 0
		) );

		vc_add_param( 'vc_row', array(
			'type'        => 'textfield',
			'heading'     => __( 'Parallax Y Offset', 'tomjerry' ),
			'param_name'  => 'parallax_y',
			'group'       => __( 'Parallax', 'tomjerry' ),
			'value'       => 0
		) );

		/**
		 * Single Image
		 */
		vc_add_param( 'vc_single_image', array(
			'type'        => 'checkbox',
			'heading'     => __( 'Enable Lightbox For This Image', 'tomjerry' ),
			'param_name'  => 'lightbox',
			'value'       => array(
				__( 'Yes, please', 'tomjerry' ) => 'yes'
			)
		) );
	}
}



if ( ! function_exists( 'tomjerry_vc_scripts' ) ) {
	add_action( 'wp_enqueue_scripts', 'tomjerry_vc_scripts', 999 );

	/**
	 * Unregister visual composer styles and scripts
	 * 
	 * @return  void
	 */
	function tomjerry_vc_scripts() {
		wp_deregister_script( 'prettyphoto' );
		wp_deregister_style( 'prettyphoto' );
		wp_deregister_style( 'isotope' );
		wp_deregister_style( 'flexslider' );
		wp_deregister_style( 'waypoints' );
	}
}
