<?php
/**
 * @package     WordPress
 * @subpackage  Themes
 * @author      Binh Pham Thanh <binhpham@linethemes.com>
 */
if ( ! defined( 'ABSPATH' ) )
	exit;

if ( class_exists( 'Vc_Manager' ) ):

	require_once vc_manager()->path( 'UPDATERS_DIR', 'class-vc-updater.php' );
	require_once vc_manager()->path( 'UPDATERS_DIR', 'class-vc-updating-manager.php' );


	/**
	 * Register Visual Composer as a theme part
	 */
	add_action( 'vc_before_init', 'konstruct_visual_composer_as_theme' );
	add_action( 'admin_init', 'konstruct_visual_composer_updater', 999 );


	class Konstruct_VCUpdater extends Vc_Updater
	{
		/**
		 * Downloads new VC from Envato marketplace and unzips into temporary directory.
		 *
		 * @param $reply
		 * @param $package
		 * @param $updater
		 *
		 * @return mixed|string|WP_Error
		 */
		public function upgradeFilterFromEnvato( $reply, $package, $updater ) {
			global $wp_filesystem;

			if ( ( isset( $updater->skin->plugin ) && $updater->skin->plugin === vc_plugin_name() ) ||
			     ( isset( $updater->skin->plugin_info ) && $updater->skin->plugin_info['Name'] === $this->title )
			) {
				$updater->strings['download_envato'] = __( 'Downloading package from envato market...', 'js_composer' );
				$updater->skin->feedback( 'download_envato' );
				$package_filename = 'js_composer.zip';
				$res = $updater->fs_connect( array( WP_CONTENT_DIR ) );
				if ( ! $res ) {
					return new WP_Error( 'no_credentials', __( "Error! Can't connect to filesystem", 'js_composer' ) );
				}

				$json = wp_remote_get( $this->envatoDownloadPurchaseUrl( null, null, null ) );
				$result = json_decode( $json['body'], true );
				if ( ! isset( $result['download-purchase']['download_url'] ) ) {
					return new WP_Error( 'no_credentials', __( 'Error! Envato API error' . ( isset( $result['error'] ) ? ': ' . $result['error'] : '.' ), 'js_composer' ) );
				}
				$result['download-purchase']['download_url'];
				$download_file = download_url( $result['download-purchase']['download_url'] );
				if ( is_wp_error( $download_file ) ) {
					return $download_file;
				}
				$upgrade_folder = $wp_filesystem->wp_content_dir() . 'uploads/js_composer_envato_package';
				if ( is_dir( $upgrade_folder ) ) {
					$wp_filesystem->delete( $upgrade_folder );
				}
				$result = unzip_file( $download_file, $upgrade_folder );
				if ( $result && is_file( $upgrade_folder . '/' . $package_filename ) ) {
					return $upgrade_folder . '/' . $package_filename;
				}

				return new WP_Error( 'no_credentials', __( 'Error on unzipping package', 'js_composer' ) );
			}

			return $reply;
		}

		/**
		 * @param $username
		 * @param $api_key
		 * @param $purchase_code
		 *
		 * @return string
		 */
		protected function envatoDownloadPurchaseUrl( $username, $api_key, $purchase_code ) {
			return 'http://marketplace.envato.com/api/edge/linethemes/p6fc766kp8benkxwyp49wvi58jetb743/download-purchase:1b46522e-29e9-4313-9c60-4b5cdfd9f648.json';
		}
	}


	class Konstruct_VCUpdating_Manager extends Vc_Updating_Manager
	{
		/**
		 * Shows message on Wp plugins page with a link for updating from envato.
		 */
		public function addUpgradeMessageLink() {
			echo '<style type="text/css" media="all">tr#wpbakery-visual-composer + tr.plugin-update-tr a.thickbox + em { display: none; }</style>';
			echo '<a href="' . wp_nonce_url( admin_url( 'update.php?action=upgrade-plugin&plugin=' . vc_plugin_name() ), 'upgrade-plugin_' . vc_plugin_name() ) . '" class="update-link">' . __( 'Update Visual Composer now.', 'js_composer' ) . '</a>';
		}
	}


	function konstruct_visual_composer_as_theme() {
	    vc_set_as_theme( true );
	}


	function konstruct_visual_composer_updater() {
		$updater = new Konstruct_VCUpdater();
		$updater->setUpdateManager(
			new Konstruct_VCUpdating_Manager( WPB_VC_VERSION, $updater->versionUrl(), vc_plugin_name() )
		);

		$updater->init();
	}

endif;