<?php
/**
 * WARNING: This file is part of the Tom & Jerry theme. DO NOT edit
 * this file under any circumstances.
 */

/**
 * Prevent direct access to this file
 */
defined( 'ABSPATH' ) or die();
?>
<?php if ( have_posts() ): ?>

	<div class="content-inner">
		<?php
			while ( have_posts() ):
				the_post();
				$metadata = get_post_meta( get_the_ID(), '_member_options', true );
				$social_links = trim( $metadata['social_links'], '"' );
				$social_links = json_decode( $social_links, true );
				$available_icons = op_available_social_icons();
		?>
		
		<article <?php post_class() ?>>
			<?php if ( has_post_thumbnail() ): ?>
				<div class="member-image">
					<?php the_post_thumbnail( 'full' ); ?>
				</div>
			<?php endif ?>
			
			<div class="member-detail">
				<h3 class="member-name"><?php the_title() ?></h3>

				<?php if ( ! empty( $metadata['subtitle'] ) ): ?>
					<p class="member-subtitle">
						<?php esc_html_e( $metadata['subtitle'] ) ?>
					</p>
				<?php endif ?>

				<ul class="member-meta">
					<?php if ( ! empty( $metadata['phone'] ) ): ?>
					<li class="member-phone">
						<span><?php _e( 'Tel:', 'tomjerry' ) ?></span>
						<?php esc_html_e( $metadata['phone'] ) ?>
					</li>
					<?php endif ?>

					<?php if ( ! empty( $metadata['email'] ) ): ?>
					<li class="member-email">
						<a href="mailto:<?php esc_attr_e( $metadata['email'] ) ?>">
							<?php esc_html_e( $metadata['email'] ) ?>
						</a>
					</li>
					<?php endif ?>

					<?php if ( is_array( $social_links ) && isset( $social_links['__icons_ordering__'] ) ): ?>
						<li class="social-links">
							<?php foreach ( $social_links['__icons_ordering__'] as $id ):
								if ( ! isset( $available_icons[$id] ) || ! isset( $social_links[$id] ) )
									continue;

								$link = $social_links[$id];
								$icon_class = $available_icons[$id]['icon_class'];
								?>
								<a href="<?php esc_url_e( $link ) ?>" target="_blank">
									<i class="fa <?php esc_attr_e( $icon_class ) ?>"></i>
								</a>
							<?php endforeach ?>
						</li>
					<?php endif ?>
				</ul>

				<div class="member-category">
					<h3><?php _e( 'Area of practice', 'tomjerry' ) ?></h3>
					<ul>
						<?php the_terms( get_the_ID(), 'member-category', '<li>', '</li><li>', '</li>' ) ?>
					</ul>
				</div>

				<div class="more-link">
					<a href="<?php the_permalink() ?>"><?php _e( 'View Profile', 'tomjerry' ) ?></a>
				</div>
			</div>
		</article>

		<?php endwhile ?>
	</div>

	<?php get_template_part( 'templates/blocks/pagination' ) ?>
<?php endif ?>