<?php
require_once "conf/config.php";
require_once "conf/protocols.php";

$sites = load_sites();
$history = load_history();

if (is_array($sites[0]))
{
	foreach ($sites as $site)
	{
		if (!valid_domain($site[1]) AND !valid_ip($site[1]))
		{
			return;
		}
		/* Check if the service is running */
		$check = @fsockopen($site[1], $site[2], $errno, $errmsg, $config['timeout']);
		/* Index for checking the history */
		$index = $site[1].":".$site[2];
		/* Check if this site has any history, if not then popualte the arrays */
		if (empty($history[$index]) && $config['show_history'])
		{
			$history[$index] = Array(
				'recorded_since' => time(),
				'last_downtime' => 0,
				'down_count' => 0,
				'up_count' => 0,
				);
		}
		if ($check)
		{
			/* Load the success message from the config */
			$message = $config['message_if_avail'];
			$img = "up.jpg";
			
			/* Update the history */
			if ($config['show_history'])
			{
				$history[$index]['up_count']++;
			}
		}
		else
		{
			/* Load the failure message from the config */
			$message = $config['message_if_down'];
			$img = "down.jpg";

			/* Replace the variables with real data */
			$message = str_replace("%error_number%", $errno, $message);	
			$message = str_replace("%error_message%", $errmsg, $message);	
						
			/* Do we want to send an email? */
			if ($config['send_email'])
			{
				if ($config['show_history'] && ((time() - $history[$index]['last_downtime']) <= $config['email_limit']))
				{
					// Do nothing, because the difference between the time and last_downtime isnt great enough
				}
				else
				{
					send_email($site,$config);
				}
			}
			
			/* Update the history */
			if ($config['show_history'])
			{
				$history[$index]['down_count']++;
				$history[$index]['last_downtime'] = time();
			}
		}
	
		/* If this port has been defined in protocols.php */
		if (isset($port[$site[2]]))
		{
			/* Then load its messages */
			$service = $port[$site[2]]['title'];
			$usage = $port[$site[2]]['usage'];
		}
		else
		{
			/* If it hasn't been defined then load generic messages */
			$service = "service running on port ".$site[2];
			$usage = "use this service";
		}
		/* Replace some more variables with real data */
		$message = str_replace("%service%",$service,$message);
		$message = str_replace("%do_something%",$usage,$message);
		$message = str_replace("%port%",$site[2],$message);
		$message = str_replace("%server_ip%",$site[1],$message);
	
		/* Finally output the message */
		/* Print the server name */
		echo "<li><img src=\"img/".$img."\" class=\"icon\" alt=\"".$img."\"/><h2>".$site[0];
		if ($config['show_protocol_in_title'] && !empty($port[$site[2]]['title']))
			echo " (".$port[$site[2]]['title'].")";
		echo "</h2>";
		/* If we want to display the IP _OR_ the history, then start a new paragraph */
		if ($config['show_ip'] || $config['show_history'])
		{
			echo "<p class=\"ip\">";
			if ($config['show_ip'])
				echo $site[1];
			if ($config['show_ip'] && $config['show_history'])
				echo " &mdash; ";
			if ($config['show_history'])
			{
				$total = $history[$index]['up_count'] + $history[$index]['down_count'];			
				if ($total > 0)
					$uptime = round(($history[$index]['up_count']/$total) * 100,$config['percentage_precision']);
				else
					$uptime = 0;

				$last_downtime = ($history[$index]['last_downtime'] != 0) ? date($config['timestamp'], $history[$index]['last_downtime']) : 'never';

				echo "Uptime: ".$uptime."&percnt;, Last recorded downtime: ".$last_downtime;
			}
			echo "</p>";
		}
		echo "<p>".$message."</p>";
		echo "</li>";
	}
	/* Write the history back to the data file */
	if ($config['show_history'])
		write_history($history);
}
else
{
	echo "<li><h2>No sites found</h2></li>";
}

?>