<?php
/* 
	CONFIGURATION SETTINGS
	----------------------
	
	Copyright 2009 Andrew Richards
*/

$config['show_protocol_in_title'] = true;		// Shows the protocol name in the title: e.g. Google.com (Web Server)
$config['show_ip'] = true;						// Shows the IP address of the relevant server under its name
$config['timeout'] = 1;							// Timeout for each request (in seconds)
$config['page_title'] = "System Status";		// Page title (<title>)
$config['heading'] = "System Status";			// Heading for the page (<h1>)
$config['site_name'] = "Your Site";				// For the copyright notice in the footer
$config['show_history'] = true;					// Enables the showing (and recording) of status requests
$config['timestamp'] = "F j, Y, g:i a";			// The format in which the last recorded downtime is displayed
$config['refresh_period'] = "60000";			// How often the AJAX refreshes the server status (in ms) (default: 60000 - 1minute)
$config['percentage_precision'] = 1;			// To how many decimal places you want the uptime percentage dislplayed in (default: 1)
$config['send_email'] = false;					// Whether or not to send email if a service is found to be down
$config['email_address'] = "email@you.com";		// Email address to send downtime notification to
$config['email_limit'] = 600;					// Only allow emails to be sent one every number of seconds set here. Stops spam
 												// E.g. default is 600 (10 minutes)

/* 
	Set your messages
	-----------------
	
	The message templates can use the following variables:
 			%server_ip%			IP address of the server (e.g. 127.0.0.1)
 			%port%				Port number of the service (e.g. 80)
			%service%			The name of the protocol (defined in protocols.php)
 			%do_something%		What the users won't be able to do while this service is down (defined in protocols.php)
 			
 	The following varaibles are only available when the server is down
 			%error_message%		Error message (e.g. Connection timed out)
 			%error_number%		Error number (e.g. 110)

*/
// 	Message if the service is down
$config['message_if_down'] = "Sorry, the %service% is currently unavailable. You will be unable to %do_something% while we work on this. These messages are fully customisable!";

// 	Message if the service is available
$config['message_if_avail'] = "%service% is running and available! (Port %port%)";


// DO NOT EDIT BELOW THIS LINE

function load_sites()
{
	/* Open the file */
	$handle = @fopen("conf/sites.php", "r");
	$data = Array();
	/* If the file is open */
	if ($handle) 
	{
		/* Loop over each line */
    	while (!feof($handle)) 
    	{
			/* Get the CSV */
			$data[] = fgetcsv($handle, 4096);
	    }
		/* Closed the file */
	    fclose($handle);
    }
	/* Return the data */
    return $data;
}

function valid_ip($ip)
{
	$segments = explode('.', $ip);

	if (count($segments) != 4)
		return FALSE;

	if ($segments[0][0] == '0')
		return FALSE;

	foreach ($segments as $seg)
	{
		if ($seg == '' || preg_match("/[^0-9]/", $seg) || $seg > 255 || strlen($seg) > 3)
			return FALSE;
	}

	return TRUE;
}


function valid_domain($domain)
{
	// regex found from http://www.shauninman.com/archive/2006/05/08/validating_domain_names
	if (preg_match ("/^([a-z0-9]([-a-z0-9]*[a-z0-9])?\\.)+((a[cdefgilmnoqrstuwxz]|aero|arpa)|(b[abdefghijmnorstvwyz]|biz)|(c[acdfghiklmnorsuvxyz]|cat|com|coop)|d[ejkmoz]|(e[ceghrstu]|edu)|f[ijkmor]|(g[abdefghilmnpqrstuwy]|gov)|h[kmnrtu]|(i[delmnoqrst]|info|int)|(j[emop]|jobs)|k[eghimnprwyz]|l[abcikrstuvy]|(m[acdghklmnopqrstuvwxyz]|mil|mobi|museum)|(n[acefgilopruz]|name|net)|(om|org)|(p[aefghklmnrstwy]|pro)|qa|r[eouw]|s[abcdeghijklmnortvyz]|(t[cdfghjklmnoprtvwz]|travel)|u[agkmsyz]|v[aceginu]|w[fs]|y[etu]|z[amw])$/i", $domain))
		return true;
	else
		return false;
}

function load_history()
{
	/* Open the file */
	$handle = @fopen("conf/history.txt", "r");
	/* If it exists */
	if ($handle) 
	{
		/* Loop over the entire file */
    	while (!feof($handle)) 
    	{
			/* Pull the CSV data out */
	        $data = fgetcsv($handle, 4096);
			if ($data != null)
			{/* Assign it */
				$history[$data[0]] = Array(
					'recorded_since' => $data[1],
					'last_downtime' => $data[2],
					'down_count' => $data[3],
					'up_count' => $data[4],
					);
			}
	    }
		/* Close it */
	    fclose($handle);
    }
	/* Return the history array */
    return $history;
}

function write_history($sites)
{
	/* Start creating the content */
	$content = "";
	/* Loop over each site */
	foreach ($sites as $ip => $site)
	{
		/* If the IP isn't blank (if the entry exists) */
		if ($ip != "")
			$content .= $ip.",".$site['recorded_since'].",".$site['last_downtime'].",".$site['down_count'].",".$site['up_count']."\n";
			/* Create the CSV data */
	}
	/* Open the history file for writing */
	$handle = fopen ("conf/history.txt", "w");  
	/* Write the content then close the file */
	fwrite ($handle,$content);
	fclose ($handle);
}

function send_email($site,$config)
{	
	$message = "The service \"" . $site[0] . "\" was found to be down on " . date($config['timestamp']) . "\n";
	$message .= "Host: " . $site[1] . "\n";
	$message .= "Port: " . $site[2] . "\n";
	
	$to = $config['email_address'];
	$subject = "Service down: " . $site[1].":".$site[2];
	$message = wordwrap($message,70,"\n",true);
	
	mail($to, $subject, $message);
}

?>