
"use strict"; // Minimize mutable state :)

//alert(super_create_form_i18n.rtl);
//alert(super_create_form_i18n.locale);


// Element.matches() polyfill - shim to add better support for .matches()
// Many browsers implemented .matches() with proprietary prefixes. 
// Others didn’t implement it but support querySelectorAll.
// In both cases, a lightweight polyfill bolts in .matches() support.
if (!Element.prototype.matches) {
    Element.prototype.matches = 
        Element.prototype.matchesSelector || 
        Element.prototype.mozMatchesSelector ||
        Element.prototype.msMatchesSelector || 
        Element.prototype.oMatchesSelector || 
        Element.prototype.webkitMatchesSelector ||
        function(s) {
            var matches = (this.document || this.ownerDocument).querySelectorAll(s),
                i = matches.length;
            while (--i >= 0 && matches.item(i) !== this) {}
            return i > -1;            
        };
}
// Polyfill for closest()
if (!Element.prototype.closest) {
    Element.prototype.closest = function(s) {
        var el = this;
        if (!document.documentElement.contains(el)) return null;
        do {
            if (el.matches(s)) return el;
            el = el.parentElement || el.parentNode;
        } while (el !== null && el.nodeType === 1); 
        return null;
    };
}


// Define our application
const app = {};

app.panel = {
    this : document.querySelector('.super-edit-element-panel'),
};

app.func = {
    merge_objects : function(obj1, obj2){
      for (var p in obj2) {
        try {
          // Property in destination object set; update its value.
          if ( obj2[p].constructor==Object ) {
            obj1[p] = app.func.merge_objects(obj1[p], obj2[p]);
          } else {
            obj1[p] = obj2[p];
          }
        } catch(e) {
          // Property in destination object not set; create it and set its value.
          obj1[p] = obj2[p];
        }
      }
      return obj1;
    }
};

// Equivalent for jQuery's .on() function
app.delegate = function(element, event, elements, callback) {
    element.addEventListener(event, function(event) {
        var target = event.target;
        while (target && target !== this) {
            if (target.matches(elements)) {
                callback(event, target);
                return false;
            }
            target = target.parentNode;
        }
    });
};

// Define Font object
app.fonts = {
    loaded : [], // By default no fonts are loaded
    enqueue : function(name, type, callback){ // Load the font and css from google api, and add it to our loaded object
        // name = the font name e.g: Roboto
        // type = the font type e.g: 'googlefonts' or 'earlyaccess'
        
        // Skip if font was already loaded previously
        if(this.loaded.indexOf(name)==-1){
            // Define subsets for special languages
            let subsets = {
                'bg_BG': 'cyrillic',
                'el': 'greek',
                'he_IL': 'hebrew',
                'ru_RU': 'cyrillic',
                'uk': 'cyrillic',
                'vi': 'vietnamese'
            };
            
            let url = '';
            if(type=='googlefonts'){
                url = 'https://fonts.googleapis.com/css?family=' + name + ':100,100italic,200,200italic,300,300italic,400,400italic,500,500italic,600,600italic,700,700italic,800,800italic,900,900italic';
                if (subsets[super_create_form_i18n.locale]) {
                    url += '&subset=' + subsets[super_create_form_i18n.locale];
                }        
            }
            if(type=='earlyaccess'){
                url = 'https://fonts.googleapis.com/earlyaccess/' + name.replace(/\s+/g, '').toLowerCase() + '.css';
            }

            // Add the stylesheet to the builder page
            if(url!=''){
                let link  = document.createElement('link');
                link.rel  = 'stylesheet';
                link.type = 'text/css';
                link.href = url;
                app.canvas.this.appendChild(link);
            }

            // Add the font to the loaded fonts object
            this.loaded.push(name);
        }
        callback();
    },
    list : {
        system : {
            name : 'System',
            fonts : [
                'Arial','Tahoma','Verdana','Helvetica','Times New Roman','Trebuchet MS','Georgia'
            ],
        },
        googlefonts : {
            name : 'Google',
            fonts : [
                'ABeeZee','Abel','Abhaya Libre','Abril Fatface','Aclonica','Acme','Actor','Adamina','Advent Pro','Aguafina Script','Akronim','Aladin','Aldrich','Alef','Alegreya','Alegreya SC','Alegreya Sans','Alegreya Sans SC','Alex Brush','Alfa Slab One','Alice','Alike','Alike Angular','Allan','Allerta','Allerta Stencil','Allura','Almendra','Almendra Display','Almendra SC','Amarante','Amaranth','Amatic SC','Amethysta','Amiko','Amiri','Amita','Anaheim','Andada','Andika','Angkor','Annie Use Your Telescope','Anonymous Pro','Antic','Antic Didone','Antic Slab','Anton','Arapey','Arbutus','Arbutus Slab','Architects Daughter','Archivo','Archivo Black','Archivo Narrow','Aref Ruqaa','Arima Madurai','Arimo','Arizonia','Armata','Arsenal','Artifika','Arvo','Arya','Asap','Asap Condensed','Asar','Asset','Assistant','Astloch','Asul','Athiti','Atma','Atomic Age','Aubrey','Audiowide','Autour One','Average','Average Sans','Averia Gruesa Libre','Averia Libre','Averia Sans Libre','Averia Serif Libre','Bad Script','Bahiana','Baloo','Baloo Bhai','Baloo Bhaijaan','Baloo Bhaina','Baloo Chettan','Baloo Da','Baloo Paaji','Baloo Tamma','Baloo Tammudu','Baloo Thambi','Balthazar','Bangers','Barlow','Barlow Condensed','Barlow Semi Condensed','Barrio','Basic','Battambang','Baumans','Bayon','Belgrano','Bellefair','Belleza','BenchNine','Bentham','Berkshire Swash','Bevan','Bigelow Rules','Bigshot One','Bilbo','Bilbo Swash Caps','BioRhyme','BioRhyme Expanded','Biryani','Bitter','Black And White Picture','Black Han Sans','Black Ops One','Bokor','Bonbon','Boogaloo','Bowlby One','Bowlby One SC','Brawler','Bree Serif','Bubblegum Sans','Bubbler One','Buda','Buenard','Bungee','Bungee Hairline','Bungee Inline','Bungee Outline','Bungee Shade','Butcherman','Butterfly Kids','Cabin','Cabin Condensed','Cabin Sketch','Caesar Dressing','Cagliostro','Cairo','Calligraffitti','Cambay','Cambo','Candal','Cantarell','Cantata One','Cantora One','Capriola','Cardo','Carme','Carrois Gothic','Carrois Gothic SC','Carter One','Catamaran','Caudex','Caveat','Caveat Brush','Cedarville Cursive','Ceviche One','Changa','Changa One','Chango','Chathura','Chau Philomene One','Chela One','Chelsea Market','Chenla','Cherry Cream Soda','Cherry Swash','Chewy','Chicle','Chivo','Chonburi','Cinzel','Cinzel Decorative','Clicker Script','Coda','Coda Caption','Codystar','Coiny','Combo','Comfortaa','Coming Soon','Concert One','Condiment','Content','Contrail One','Convergence','Cookie','Copse','Corben','Cormorant','Cormorant Garamond','Cormorant Infant','Cormorant SC','Cormorant Unicase','Cormorant Upright','Courgette','Cousine','Coustard','Covered By Your Grace','Crafty Girls','Creepster','Crete Round','Crimson Text','Croissant One','Crushed','Cuprum','Cute Font','Cutive','Cutive Mono','Damion','Dancing Script','Dangrek','David Libre','Dawning of a New Day','Days One','Dekko','Delius','Delius Swash Caps','Delius Unicase','Della Respira','Denk One','Devonshire','Dhurjati','Didact Gothic','Diplomata','Diplomata SC','Do Hyeon','Dokdo','Domine','Donegal One','Doppio One','Dorsa','Dosis','Dr Sugiyama','Duru Sans','Dynalight','EB Garamond','Eagle Lake','East Sea Dokdo','Eater','Economica','Eczar','El Messiri','Electrolize','Elsie','Elsie Swash Caps','Emblema One','Emilys Candy','Encode Sans','Encode Sans Condensed','Encode Sans Expanded','Encode Sans Semi Condensed','Encode Sans Semi Expanded','Engagement','Englebert','Enriqueta','Erica One','Esteban','Euphoria Script','Ewert','Exo','Exo 2','Expletus Sans','Fanwood Text','Farsan','Fascinate','Fascinate Inline','Faster One','Fasthand','Fauna One','Faustina','Federant','Federo','Felipa','Fenix','Finger Paint','Fira Mono','Fira Sans','Fira Sans Condensed','Fira Sans Extra Condensed','Fjalla One','Fjord One','Flamenco','Flavors','Fondamento','Fontdiner Swanky','Forum','Francois One','Frank Ruhl Libre','Freckle Face','Fredericka the Great','Fredoka One','Freehand','Fresca','Frijole','Fruktur','Fugaz One','GFS Didot','GFS Neohellenic','Gabriela','Gaegu','Gafata','Galada','Galdeano','Galindo','Gamja Flower','Gentium Basic','Gentium Book Basic','Geo','Geostar','Geostar Fill','Germania One','Gidugu','Gilda Display','Give You Glory','Glass Antiqua','Glegoo','Gloria Hallelujah','Goblin One','Gochi Hand','Gorditas','Gothic A1','Goudy Bookletter 1911','Graduate','Grand Hotel','Gravitas One','Great Vibes','Griffy','Gruppo','Gudea','Gugi','Gurajada','Habibi','Halant','Hammersmith One','Hanalei','Hanalei Fill','Handlee','Hanuman','Happy Monkey','Harmattan','Headland One','Heebo','Henny Penny','Herr Von Muellerhoff','Hi Melody','Hind','Hind Guntur','Hind Madurai','Hind Siliguri','Hind Vadodara','Holtwood One SC','Homemade Apple','Homenaje','IBM Plex Mono','IBM Plex Sans','IBM Plex Sans Condensed','IBM Plex Serif','IM Fell DW Pica','IM Fell DW Pica SC','IM Fell Double Pica','IM Fell Double Pica SC','IM Fell English','IM Fell English SC','IM Fell French Canon','IM Fell French Canon SC','IM Fell Great Primer','IM Fell Great Primer SC','Iceberg','Iceland','Imprima','Inconsolata','Inder','Indie Flower','Inika','Inknut Antiqua','Irish Grover','Istok Web','Italiana','Italianno','Itim','Jacques Francois','Jacques Francois Shadow','Jaldi','Jim Nightshade','Jockey One','Jolly Lodger','Jomhuria','Josefin Sans','Josefin Slab','Joti One','Jua','Judson','Julee','Julius Sans One','Junge','Jura','Just Another Hand','Just Me Again Down Here','Kadwa','Kalam','Kameron','Kanit','Kantumruy','Karla','Karma','Katibeh','Kaushan Script','Kavivanar','Kavoon','Kdam Thmor','Keania One','Kelly Slab','Kenia','Khand','Khmer','Khula','Kirang Haerang','Kite One','Knewave','Kotta One','Koulen','Kranky','Kreon','Kristi','Krona One','Kumar One','Kumar One Outline','Kurale','La Belle Aurore','Laila','Lakki Reddy','Lalezar','Lancelot','Lateef','Lato','League Script','Leckerli One','Ledger','Lekton','Lemon','Lemonada','Libre Barcode 128','Libre Barcode 128 Text','Libre Barcode 39','Libre Barcode 39 Extended','Libre Barcode 39 Extended Text','Libre Barcode 39 Text','Libre Baskerville','Libre Franklin','Life Savers','Lilita One','Lily Script One','Limelight','Linden Hill','Lobster','Lobster Two','Londrina Outline','Londrina Shadow','Londrina Sketch','Londrina Solid','Lora','Love Ya Like A Sister','Loved by the King','Lovers Quarrel','Luckiest Guy','Lusitana','Lustria','Macondo','Macondo Swash Caps','Mada','Magra','Maiden Orange','Maitree','Mako','Mallanna','Mandali','Manuale','Marcellus','Marcellus SC','Marck Script','Margarine','Marko One','Marmelad','Martel','Martel Sans','Marvel','Mate','Mate SC','Maven Pro','McLaren','Meddon','MedievalSharp','Medula One','Meera Inimai','Megrim','Meie Script','Merienda','Merienda One','Merriweather','Merriweather Sans','Metal','Metal Mania','Metamorphous','Metrophobic','Michroma','Milonga','Miltonian','Miltonian Tattoo','Mina','Miniver','Miriam Libre','Mirza','Miss Fajardose','Mitr','Modak','Modern Antiqua','Mogra','Molengo','Molle','Monda','Monofett','Monoton','Monsieur La Doulaise','Montaga','Montez','Montserrat','Montserrat Alternates','Montserrat Subrayada','Moul','Moulpali','Mountains of Christmas','Mouse Memoirs','Mr Bedfort','Mr Dafoe','Mr De Haviland','Mrs Saint Delafield','Mrs Sheppards','Mukta','Mukta Mahee','Mukta Malar','Mukta Vaani','Muli','Mystery Quest','NTR','Nanum Brush Script','Nanum Gothic','Nanum Gothic Coding','Nanum Myeongjo','Nanum Pen Script','Neucha','Neuton','New Rocker','News Cycle','Niconne','Nixie One','Nobile','Nokora','Norican','Nosifer','Nothing You Could Do','Noticia Text','Noto Sans','Noto Serif','Nova Cut','Nova Flat','Nova Mono','Nova Oval','Nova Round','Nova Script','Nova Slim','Nova Square','Numans','Nunito','Nunito Sans','Odor Mean Chey','Offside','Old Standard TT','Oldenburg','Oleo Script','Oleo Script Swash Caps','Open Sans','Open Sans Condensed','Oranienbaum','Orbitron','Oregano','Orienta','Original Surfer','Oswald','Over the Rainbow','Overlock','Overlock SC','Overpass','Overpass Mono','Ovo','Oxygen','Oxygen Mono','PT Mono','PT Sans','PT Sans Caption','PT Sans Narrow','PT Serif','PT Serif Caption','Pacifico','Padauk','Palanquin','Palanquin Dark','Pangolin','Paprika','Parisienne','Passero One','Passion One','Pathway Gothic One','Patrick Hand','Patrick Hand SC','Pattaya','Patua One','Pavanam','Paytone One','Peddana','Peralta','Permanent Marker','Petit Formal Script','Petrona','Philosopher','Piedra','Pinyon Script','Pirata One','Plaster','Play','Playball','Playfair Display','Playfair Display SC','Podkova','Poiret One','Poller One','Poly','Pompiere','Pontano Sans','Poor Story','Poppins','Port Lligat Sans','Port Lligat Slab','Pragati Narrow','Prata','Preahvihear','Press Start 2P','Pridi','Princess Sofia','Prociono','Prompt','Prosto One','Proza Libre','Puritan','Purple Purse','Quando','Quantico','Quattrocento','Quattrocento Sans','Questrial','Quicksand','Quintessential','Qwigley','Racing Sans One','Radley','Rajdhani','Rakkas','Raleway','Raleway Dots','Ramabhadra','Ramaraja','Rambla','Rammetto One','Ranchers','Rancho','Ranga','Rasa','Rationale','Ravi Prakash','Redressed','Reem Kufi','Reenie Beanie','Revalia','Rhodium Libre','Ribeye','Ribeye Marrow','Righteous','Risque','Roboto','Roboto Condensed','Roboto Mono','Roboto Slab','Rochester','Rock Salt','Rokkitt','Romanesco','Ropa Sans','Rosario','Rosarivo','Rouge Script','Rozha One','Rubik','Rubik Mono One','Ruda','Rufina','Ruge Boogie','Ruluko','Rum Raisin','Ruslan Display','Russo One','Ruthie','Rye','Sacramento','Sahitya','Sail','Saira','Saira Condensed','Saira Extra Condensed','Saira Semi Condensed','Salsa','Sanchez','Sancreek','Sansita','Sarala','Sarina','Sarpanch','Satisfy','Scada','Scheherazade','Schoolbell','Scope One','Seaweed Script','Secular One','Sedgwick Ave','Sedgwick Ave Display','Sevillana','Seymour One','Shadows Into Light','Shadows Into Light Two','Shanti','Share','Share Tech','Share Tech Mono','Shojumaru','Short Stack','Shrikhand','Siemreap','Sigmar One','Signika','Signika Negative','Simonetta','Sintony','Sirin Stencil','Six Caps','Skranji','Slabo 13px','Slabo 27px','Slackey','Smokum','Smythe','Sniglet','Snippet','Snowburst One','Sofadi One','Sofia','Song Myung','Sonsie One','Sorts Mill Goudy','Source Code Pro','Source Sans Pro','Source Serif Pro','Space Mono','Special Elite','Spectral','Spectral SC','Spicy Rice','Spinnaker','Spirax','Squada One','Sree Krushnadevaraya','Sriracha','Stalemate','Stalinist One','Stardos Stencil','Stint Ultra Condensed','Stint Ultra Expanded','Stoke','Strait','Stylish','Sue Ellen Francisco','Suez One','Sumana','Sunflower','Sunshiney','Supermercado One','Sura','Suranna','Suravaram','Suwannaphum','Swanky and Moo Moo','Syncopate','Tajawal','Tangerine','Taprom','Tauri','Taviraj','Teko','Telex','Tenali Ramakrishna','Tenor Sans','Text Me One','The Girl Next Door','Tienne','Tillana','Timmana','Tinos','Titan One','Titillium Web','Trade Winds','Trirong','Trocchi','Trochut','Trykker','Tulpen One','Ubuntu','Ubuntu Condensed','Ubuntu Mono','Ultra','Uncial Antiqua','Underdog','Unica One','UnifrakturCook','UnifrakturMaguntia','Unkempt','Unlock','Unna','VT323','Vampiro One','Varela','Varela Round','Vast Shadow','Vesper Libre','Vibur','Vidaloka','Viga','Voces','Volkhov','Vollkorn','Vollkorn SC','Voltaire','Waiting for the Sunrise','Wallpoet','Walter Turncoat','Warnes','Wellfleet','Wendy One','Wire One','Work Sans','Yanone Kaffeesatz','Yantramanav','Yatra One','Yellowtail','Yeon Sung','Yeseva One','Yesteryear','Yrsa','Zeyada','Zilla Slab','Zilla Slab Highlight'
            ],
        },
        earlyaccess : {
            name : 'Early Access',
            fonts : [
                'Alef Hebrew','Droid Arabic Kufi','Droid Arabic Naskh','Noto Kufi Arabic','Noto Naskh Arabic','Noto Sans Hebrew','Open Sans Hebrew','Open Sans Hebrew Condensed'
            ],
        }
    }
};

app.init = {

    // Initialize color pickers
    color_pickers : function(){
        [].forEach.call(app.panel.this.querySelectorAll('.super-color-picker'), function(el) {
            const input = el.querySelector('.super-picker-value');
            const box = el.querySelector('.super-picker-box');
            const alpha = el.querySelector('.super-picker-alpha');
            const code = el.querySelector('.super-color-code');
            const picker = new CP(box);
            picker.set(code.value);
            function copy_code_to_value(){
                input.value = code.value;
                if(code.value.indexOf('rgb')!=-1){
                    picker.fire('change', [code.value, true]);
                }else{
                    picker.fire('change', [code.value.slice(1), true]);
                }
            }
            code.onkeyup = copy_code_to_value;
            code.onchange = copy_code_to_value;
            code.oninput = copy_code_to_value;
            box.addEventListener('click', function(e) {
                if(this.classList.contains('active')){
                    if(picker.visible){
                        picker['exit']();
                    }
                }
                this.classList.toggle('active');
            }, false);

            function update_element_style(el, v){
                // Get the selected option value
                const value = v;
                const parent = el.source.closest('.field');
                // Get option merge json
                let json = parent.querySelector('.super-option-merge').value;
                // Replace the value tag with the selected value
                json = json.replace('{value}', value);
                // Convert json string to object
                json = JSON.parse(json);
                // Retrieve current editing element
                const editing = app.get.editing();
                // Find the element we have to update styles for corresponding to the option that was changed
                const element = editing.querySelector(json.query_selector);
                if(element){
                    // Now update the style of the element
                    element.style[json.style_update] = value;
                }
                // Update the element data
                let data = app.get.element.editing.data();
                // Merge the 2 objects
                data = app.func.merge_objects(data, json.object);
                app.element.update.data(editing, data, function(){
                    app.form.update();
                });
            }
            picker.on('change', function(color, copy=false) {
                var v = CP.HEX2RGB(color);
                v = alpha.value == 1 ? '#'+color : 'rgba(' + v.join(', ') + ', ' + alpha.value.replace(/^0\./, '.') + ')';
                this.source.value = v;
                this.source.querySelector('.super-picker-color').style.backgroundColor = v;
                input.value = v;
                if(copy!==true){
                    code.value = v;
                }
                if(copy===true){
                    picker.set(v);
                }
                update_element_style(this, v);
            });
            function alpha_change() {
                var v = CP._HSV2RGB(picker.set());
                v = this.value == 1 ? '#'+CP.RGB2HEX(v) : 'rgba(' + v.join(', ') + ', ' + this.value.replace(/^0\./, '.') + ')';
                picker.source.value = v;
                picker.source.querySelector('.super-picker-color').style.backgroundColor = v;
                code.value = v;
                input.value = v;
                update_element_style(picker, v);
            }
            alpha.onchange = alpha_change;
            alpha.oninput = alpha_change;
            picker.source.onclick = function(e) {
                e.preventDefault();
            };
            picker.on('enter', function() {
                picker.self.firstChild.appendChild(code);
                picker.self.firstChild.appendChild(input);
                picker.self.firstChild.appendChild(alpha);
            });
            picker.on('exit', function() {
                box.classList.toggle('active');
                box.parentNode.appendChild(code);
                box.parentNode.appendChild(input);
                box.parentNode.appendChild(alpha);
            });
        });
    },

    // @TODO - not used currently, delete?
    // Initialize elements so they can be sortable
    drag_and_drop : function(){
        var $container = $('.super-preview-elements');
        /*
        // For now disabled, maybe we will use it in the future?
        $('.super-preview-elements').find('.super-column').resizable({
            resize: function(event, ui) {
                if(ui.originalElement.parent().hasClass('super-preview-elements')){
                    var $width = $(this).parents('.super-preview-elements').width();
                    if( ui.size.width>$width ) {
                        ui.size.width = $width;
                    }
                }else{
                    var $width = $(this).parents('.super-element-inner').width();
                    var $margin = 25; 
                    if( (ui.size.width+$margin)>$width ) {
                        ui.size.width = $width;
                    }else{
                        ui.size.width = ui.size.width+$margin;
                    }
                }
            },
            stop: function (event, ui) {
                app.init.drag_and_drop();
            }
        });
        */


        // @since 4.2.0 - new drag and drop method
        /*
        Sortable.create(document.querySelector('.super-preview-elements'), {
            draggable: '.super-element, .super-column',
            group: {
                name: 'elements'
            },
            animation: 0,
            chosenClass: "super-chosen",
            forceFallback: true,
            onStart: function () {
                $('.super-preview-elements').addClass('dragging');
            },
            onEnd: function () {
                $('.super-preview-elements').removeClass('dragging');
            }
        });
        [].forEach.call(document.querySelector('.super-preview-elements').getElementsByClassName('super-element-inner'), function (el){
            Sortable.create(el, {
                draggable: '.super-element, .super-column',
                group: {
                    name: 'elements',
                },
                animation: 0,
                chosenClass: "super-chosen",
                forceFallback: true,
                onStart: function () {
                    $('.super-preview-elements').addClass('dragging');
                },
                onEnd: function () {
                    $('.super-preview-elements').removeClass('dragging');
                }
            });
        });
        */
    },

    find_inner_columns : function($this, $row_width, $counter){
        $this.find('.super-element-inner > .super-column').each(function(){
            var $result = app.init.add_first_column_class($(this), $row_width, $counter);
            $row_width = $result.row_width;
            $counter = $result.counter;
        });
    },

    add_first_column_class : function($this, $row_width, $counter){
        if($counter==0) {
            $this.addClass('first-column');
            $counter++;
        }else{
            $this.removeClass('first-column');
        }
        var $parent = $this.parent();
        var $column_width = $this.outerWidth(true);
        var $parent_width = $parent.outerWidth(true);
        $row_width = $row_width + $column_width;
        if( $row_width > $parent_width ) {
            $this.addClass('first-column');
            $row_width = $this.outerWidth(true);
        }
        app.init.find_inner_columns($this, 0, 0);
        return {row_width: $row_width, counter: $counter};
    },

    // Generate first-column class for columns so we can set the correct paddings so each column has the correct width
    generate_first_column_classes : function($row_width, $counter){
        $(document).find('.super-preview-elements > .super-column, .super-preview-elements > .super-element.multipart > .super-element-inner > .super-column').each(function(){
            var $result = app.init.add_first_column_class($(this), $row_width, $counter);
            $row_width = $result.row_width;
            $counter = $result.counter;
        });
        // After done with loop show elements
        $('.super-preview-elements').addClass('rendered');
    },

    resize_element_labels : function(){
        $('.super-create-form .super-element-header .super-element-label > input').each(function(){
            var $span = $(this).parent().children('span');
            var $width = $span.outerWidth(true);
            $(this).parent().css('width', $width+'px').css('margin-left', '-'+($width/2)+'px');
        });   
    },

    drop_here_placeholder : function(){
        $('.super-preview-elements').addClass('drop-here-placeholder');
        app.init.drag_and_drop();
    },

    // Scroll function when dropable or sortable element is activated
    handle_near : function(){
        var $scrolled = $(window).scrollTop();
        var $buffer = 20;
        var $docHeight = $(document).outerHeight(true);
        var $windowHeight = $(window).outerHeight(true);
        var $near_top = $scrolled - this.ev.y >= $buffer;  
        var $near_bottom = $scrolled + $windowHeight - this.ev.y <= $buffer;  
        if($near_top){
            window.scrollTo(0, $scrolled - $buffer);
        }
        if(($near_bottom) && ((this.ev.y+$buffer) < $docHeight)){
            window.scrollTo(0, this.ev.y + $buffer - $windowHeight);
        }
    },

    dragable_elements : function(){
        $('.draggable-element').pep({
            activeClass: 'active',
            droppableActiveClass: 'dropping-allowed',
            droppableParentActiveClass: 'dropping-allowed-active',
            droppable: '.super-dropable',
            start: function(ev, obj){
                app.init.drop_here_placeholder();
                obj.noCenter = true;
                var top = obj.$el.css('top').replace('px','');
                var left = obj.$el.css('left').replace('px','');
                if(typeof obj.$el.attr('data-start-position-top') === 'undefined'){
                    obj.$el.attr('data-start-position-top', top)
                    obj.$el.attr('data-start-position-left', left)
                }            
            },
            drag:function(e) {
                app.init.handle_near.apply(this);
            },
            stop: function(ev, obj){
                if(this.activeDropRegions.length>0){
                    let target = document.querySelector('.super-preview.dropping-allowed-active .dropping-allowed');
                    let html = obj.$el[0].querySelector('.builder-html').innerHTML;
                    let node = document.createElement('div');
                    node.innerHTML = html.trim();
                    target.appendChild(node.firstChild);

                    /*
                    let target = document.querySelector('.super-preview.dropping-allowed-active .dropping-allowed');
                    let node = document.createElement('div');
                    console.log(obj);
                    console.log(obj.$el);
                    console.log(obj.$el.dataset);
                    console.log(obj.$el.dataset.shortcode);
                    node.innerHTML = app.element.drop[obj.$el.dataset.shortcode]();
                    target.appendChild(node);

                    /*
                    function(tag){

                        var target = document.querySelector('.super-preview.dropping-allowed-active .dropping-allowed');
                        //var $target = $('.dropping-allowed:not(:has(.dropping-allowed))');

                    },





                    /*
                    var $tag = obj.$el.data('shortcode');
                    var $target = $('.dropping-allowed:not(:has(.dropping-allowed))');
                    var $multipart_found = $target.closest('[data-shortcode-tag="multipart"]').length;
                    if( ( ($multipart_found>0) && ($tag==='multipart_pre') ) ) {
                        alert(super_create_form_i18n.alert_multipart_error);
                        return false;
                    }

                    var $column_found = $target.closest('[data-shortcode-tag="column"]').length;
                    if( ( ($column_found>0) && ($tag==='multipart_pre') ) ) {
                        alert(super_create_form_i18n.alert_column_error);
                        return false;
                    }

                    var $predefined = '';
                    if( typeof obj.$el.find('.predefined').val() !== 'undefined' ) {
                        $predefined = JSON.parse(obj.$el.find('.predefined').val());
                    }
                    $.ajax({
                        type: 'post',
                        url: ajaxurl,
                        data: {
                            action: 'super_get_element_builder_html',
                            tag: obj.$el.data('shortcode'),
                            group: obj.$el.data('group'),
                            predefined: $predefined,
                            form_id: $('input[name="form_id"]').val()
                        },
                        success: function (data) {
                            var $element = $(data).appendTo($target);
                            app.init.resize_element_labels();
                            SUPER.check_for_unique_field_name($element);
                            app.form.update();
                            app.init.generate_first_column_classes(0, 0);
                            SUPER.init_skype();
                            SUPER.init_tooltips();
                            SUPER.init_datepicker();
                            SUPER.init_masked_input();
                            SUPER.init_currency_input();
                            SUPER.init_colorpicker();
                            SUPER.init_slider_field();
                            SUPER.init_button_colors();
                            app.init.drop_here_placeholder();
                        }
                    });
                    */
                }else{
                    obj.cssX = 0
                    obj.cssY = 0
                    obj.translation = "matrix(1, 0, 0, 1, 0, 0)"
                    obj.transform(obj.translation)
                    obj.$el.css('top', '0').css('left', '0');
                }
            },
            revert: true,
            cssEaseDuration: 0,
        });
    }
};

// Define methods such as getting the "current editing" element
app.get = {
    element : {
        editing : {
            data : function(){
                return JSON.parse(app.get.editing().querySelector('textarea[name="element-data"]').value);
            }
        },
        parents : function (element, selector) {
            var parents = [];
            // Push each parent element to the array
            for ( ; element && element !== document; element = element.parentNode ) {
                if (selector) {
                    if (element.matches(selector)) {
                        parents.push(element);
                    }
                    continue;
                }
                parents.push(element);
            }
            // Return our parent array
            return parents;
        },
        data : function(target){
            // Loop through all elements for the given target
            const elements = [];
            [].forEach.call(target.querySelectorAll('.super-element'), function(el) {
                var tag = el.dataset.shortcodeTag;
                var group = el.dataset.group;
                var data = JSON.parse(el.querySelector('textarea[name="element-data"]').value);
                if(data==null) data = {};
                if( typeof el.dataset.minimized !== 'undefined' ) {
                    if(el.dataset.minimized=='no'){
                        if( typeof data.minimized !== 'undefined' ) {
                            delete data.minimized;
                        }
                    }else{
                        data.minimized = el.dataset.minimized;
                    }
                }
                if(tag=='column'){
                    const size = el.dataset.size;
                    if( size!='1/1' ) {
                        data.size = size;
                    }else{
                        if( typeof data.size !== 'undefined' ) {
                            delete data.size;
                        }
                    }
                }
                const push = {};
                push['tag'] = tag;
                push['group'] = group;
                if( (tag=='column') || (tag=='multipart') ) {
                    const inner = app.get.element.inner_data(el);
                    push['inner'] = inner;
                }
                
                // Delete empty values
                Object.keys(data).forEach(function(key) {
                    if(data[key] == null) {
                        delete data[key]
                    }
                });
                if(Object.keys(data).length !== 0 && data.constructor === Object){
                    push['data'] = data;
                }
                //Object.keys(data).forEach((key) => (data[key] == null) && delete data[key]);
                //if(Object.keys(data).length !== 0 && data.constructor === Object){
                //    push['data'] = data;
                //}

                elements.push(push);
            });
            return elements;
        },
        inner_data : function(target){
            // Used only for columns and multi-parts
            SUPER.regenerate_element_inner_children = function($target){
                var $target = $target.children('.super-element-inner');
                if($target.children('.super-element').length){
                    console.log('get.element.inner_data');
                    return get.element.data($target);
                }else{
                    return '';
                }
            }
        },
    },
    editing : function(){
        return document.querySelector('.super-preview-elements .super-element.editing');
    },
    nodes : function(element){
        return { 
            this : element,
            parent : element.parentElement,
            element : this.editing().querySelector('.super-shortcode'),
            field : element.parentElement.parentElement.closest('.field')
        };
    },
    // Return the element data with all the correct Field Label data
    label : {
        data : function(){
            // Get element data
            const data = app.get.element.editing.data();
            // Backward compatibility with older super forms versions
            if(typeof data.label !== 'object'){
                data.label = {
                    value : data.label
                };
            }
            data.label.position = (typeof data.label.position === 'undefined' ? 'top' : data.label.position); 
            data.label.alignment = (typeof data.label.alignment === 'undefined' ? 'left' : data.label.alignment); 
            data.label.width = (typeof data.label.width === 'undefined' ? 'auto' : data.label.width); // auto, flex, fixed
            data.label.flex_size = (typeof data.label.flex_size === 'undefined' ? '1/2' : data.label.flex_size); // 1/2, 3/5 etc.
            data.label.size = (typeof data.label.size === 'undefined' ? '50' : data.label.size); // 50, 33 etc.
            data.label.unit = (typeof data.label.unit === 'undefined' ? '%' : data.label.unit); // %, px etc.
            return data;
        }
    },
    label_position_values : function(element, values){
        if(typeof element !== 'undefined'){
            const field = element.closest('.field').querySelector('input[type="hidden"]');
            const value = field.value;
            var values = value.split(':');
        }
        if(typeof values[0] === 'undefined') values[0] = 'top';
        if(typeof values[1] === 'undefined') values[1] = 'left';
        if(typeof values[2] === 'undefined') values[2] = 'auto';
        if(typeof values[3] === 'undefined') values[3] = '';
        if(typeof values[4] === 'undefined') values[4] = 'px';
        if(typeof values[5] === 'undefined') values[5] = '1/2';
        return values;
    },
    column_sizes : {
        '1/1':'super_one_full',
        '4/5':'super_four_fifth',
        '3/4':'super_three_fourth',
        '2/3':'super_two_third',
        '3/5':'super_three_fifth',
        '1/2':'super_one_half',
        '2/5':'super_two_fifth',
        '1/3':'super_one_third',
        '1/4':'super_one_fourth',
        '1/5':'super_one_fifth'
    }
},

// Define context menu (right click menu)
app.context_menu = {
        open : function(){
            //alert("You've tried to open context menu");
        }
};

// Define canvas
app.canvas = {
    this : document.querySelector('.super-preview-elements')
};

// Define element edit panel events
app.panel.settings = function(parent){
    return app.panel.generate(parent);
    //    parent.querySelector('textarea[name="element-options"]').value, 
    //    parent.querySelector('textarea[name="element-data"]').value
    //);
};

app.panel.generate = function(parent){
    const tag = parent.dataset.shortcodeTag;
    const group = parent.dataset.group;
    const options = JSON.parse(parent.querySelector('textarea[name="element-options"]').value);
    const data = JSON.parse(parent.querySelector('textarea[name="element-data"]').value);
    //let html = 'test1';
    //if(tag=='radio'){
    //    html += app.panel.options.text('name', data);
    //}
    //return html;

    
    //options = JSON.parse(options);
    //data = JSON.parse(data);

    let html = '';

    // Tabs
    html += '<div class="super-element-settings-tabs">';
        html += '<select>';
            let i = 0;
            Object.keys(options).forEach(function(index) {
                const value = options[index];
                html += '<option';
                if(i==0){
                    html += ' selected="selected"';
                }
                html += ' value="' + i + '">' + value.name + '</option>';
                i++;
            });
        html += '</select>';
    html += '</div>';

    // Close button
    html += '<div class="close">Close</div>';

    i = 0;
    Object.keys(options).forEach(function(index) {
        const value = options[index];
        html += '<div class="tab-content';
        if(i==0) html += ' active';
        html += '">';
            if(typeof value.fields !== 'undefined'){
                Object.keys(value.fields).forEach(function(index) {
                    const v = value.fields[index];
                    let filter = '';
                    let parent = '';
                    let filtervalue = '';
                    if( v.filter==true ) {
                        filter = ' filter';
                        if( v.parent ) parent = ' data-parent="' + v.parent + '"';
                        if( v.filter_value ) filtervalue = ' data-filtervalue="' + v.filter_value + '"';
                    }
                    let hidden = '';
                    if( v.hidden==true ) {
                        hidden = ' hidden';
                    }
                    let $class = '';
                    if(typeof v.type !== 'undefined'){
                        $class += ' field-type-'+v.type;
                    }
                    if( (v.type=='radio_items') || (v.type=='autosuggest_items') || (v.type=='checkbox_items') || (v.type=='conditions') )  {
                        $class += ' multi-items';
                    }
                    if( v.type=='padding_margin_dimension' ) {
                        $class += ' padding-margin';
                    }

                    html += '<div data-name="'+index+'" class="field super-'+index+filter + hidden + $class + '"' + parent + '' + filtervalue + '>';
                        if( v.name ) html += '<div class="field-name">' + v.name + '</div>';
                        if( v.desc ) html += '<i class="info super-tooltip" title="' + v.desc + '"></i>';
                        if( v.label ) html += '<div class="field-label">' + v.label + '</div>';
                        html += '<div class="field-input"';
                        if( v.allow_empty!='' ) {
                            html += ' data-allow-empty="true"';
                        }
                        if(v.default!==''){
                            html += ' data-default="' + v.default + '"';
                        }
                        html += '>';
                            if( !v.type ) v.type = 'text';
                            if( data[index] ) {
                                v.default = data[index];
                            }
                            html += app.panel.options[v.type](index, v, data);
                            //html += app.panel.options.image(v.type, index, v, data)
                            //html += SUPER.elements_options_field(v.type, index, v, data);
                        html += '</div>';

                        // Error positioning
                        console.log('#TEST#@');
                        console.log(index);
                        if(index=='error'){

                            // Backward compatibility with older super forms versions
                            if(typeof data.error !== 'object'){
                                data.error = {
                                    value : data.error
                                };
                            }
                            // Define error font data
                            if(typeof data.error.font === 'undefined'){
                                data.error.font = {};
                            }
                            data.error.font = (typeof data.error.font === 'undefined' ? {} : data.error.font);
                            let font_styles = app.panel.options.font_styles(index, data.error.font);
                            let position = app.panel.options.error_position(v, data);
                            html += position.toggles+font_styles.toggles;
                            html += font_styles.html+position.html;
                            //html += app.panel.options[v.type](index, v, data);
                            //html += app.panel.options.image(v.type, index, v, data)
                            //html += SUPER.elements_options_field('position', 'label_position', v, data);
                        }

                        // Field Label Layout & Font style options
                        if(index=='label'){

                            // Backward compatibility with older super forms versions
                            if(typeof data.label !== 'object'){
                                data.label = {
                                    value : data.label
                                };
                            }
                            // Define label font data
                            if(typeof data.label.font === 'undefined'){
                                data.label.font = {};
                            }
                            data.label.font = (typeof data.label.font === 'undefined' ? {} : data.label.font);
                            let font_styles = app.panel.options.font_styles(index, data.label.font);
                            let position = app.panel.options.position(v, data);
                            html += position.toggles+font_styles.toggles;
                            html += font_styles.html+position.html;
                            //html += app.panel.options[v.type](index, v, data);
                            //html += app.panel.options.image(v.type, index, v, data)
                            //html += SUPER.elements_options_field('position', 'label_position', v, data);
                        }

                        // Field Description Font style options
                        if(index=='description'){
                            // Backward compatibility with older super forms versions
                            if(typeof data.description !== 'object'){
                                data.description = {
                                    value : data.description
                                };
                            }
                            // Define description font data
                            if(typeof data.description.font === 'undefined'){
                                data.description.font = {};
                            }
                            data.description.font = (typeof data.description.font === 'undefined' ? {} : data.description.font); 
                            let font_styles = app.panel.options.font_styles(index, data.description.font);
                            html += font_styles.toggles+font_styles.html;
                        }

                    html += '</div>';
                });
            }
        html += '</div>';
        i = 1;
    });
    return html;
};

app.panel.open = function(target, callback){
    const panel = app.panel.this;
    let editing = app.get.editing();
    app.canvas.this.classList.add('editing-element');
    const parent = target.classList.contains('super-element') === true ? target : target.closest('.super-element');
    if(parent.classList.contains('editing')){
        panel.classList.add('super-active');
        return false;
    }
    if(editing) editing.classList.remove('editing');
    parent.classList.add('editing');
    editing = parent;
    app.panel.reposition();
    panel.innerHTML = app.panel.settings(parent);

    // Get element data
    const data = app.get.element.editing.data();
    
    // Backward compatibility with older super forms versions
    let label = '';
    if(typeof data.label === 'object'){
        label = data.label.value;
    }else{
        if(data.label){
            label = data.label;
        }
    }
    // Hide label position, alignment, width options
    if(label==''){
        app.panel.toggle.label.all(panel);
    }

    app.init.color_pickers();

    SUPER.init_previously_created_fields();
    SUPER.init_slider_field();
    SUPER.init_tooltips();
    SUPER.init_image_browser();
    SUPER.init_color_pickers();
    SUPER.init_field_filter_visibility();
    callback();
};

// Hide options when Field Label is empty
app.panel.toggle = {
    label : {
        all : function(panel, display='none'){
            console.log(display);
            console.log('test1');
            app.panel.toggle.label.position(panel, display);
            app.panel.toggle.label.alignment(panel, display);
            app.panel.toggle.label.width(panel, display);
            app.panel.toggle.label.flex_size(panel, display);
            //app.panel.toggle.label.font_styles(panel, display);
        },
        position : function(panel, display='none'){
            panel.querySelector('.field.super-label .super-position').style.display = display;
        },
        alignment : function(panel, display='none'){
            // Only show when Label position is 'top' or 'bottom'
            const data = app.get.element.editing.data();
            let position;
            if(typeof data.label === 'object'){
                position = (typeof data.label.position === 'undefined' ? 'top' : data.label.position);
            }else{
                position = 'top';
            }
            if(position!='top' && position!='bottom' && data.label.width=='auto') display = 'none';
            panel.querySelector('.field.super-label .super-alignment').style.display = display;
        },
        width : function(panel, display='none'){
            // Only show when Label position is 'left' or 'right'
            const data = app.get.element.editing.data();
            let position;
            if(typeof data.label === 'object'){
                position = (typeof data.label.position === 'undefined' ? 'top' : data.label.position);
            }else{
                position = 'top';
            }
            if(position!='left' && position!='right') display = 'none';
            panel.querySelector('.field.super-label .super-width').style.display = display;
        },
        flex_size : function(panel, display='none'){
            // Only show when Label width is set to be 'flex'
            const data = app.get.element.editing.data();
            let position;
            let width;
            if(typeof data.label === 'object'){
                position = (typeof data.label.position === 'undefined' ? 'top' : data.label.position);
                width = (typeof data.label.width === 'undefined' ? 'auto' : data.label.width);
            }else{
                position = 'top';
                width = 'auto';
            }
            if(position!='left' && position!='right') display = 'none';
            if(width!='flex') display = 'none';
            panel.querySelector('.field.super-label .super-flex-size').style.display = display;
        },
        //font_styles : function(panel, display='none'){
        //    panel.querySelector('.field.super-label .super-font-styles').style.display = display;
        //}
    }
};

// Reposition Edit Element Panel
app.panel.reposition = function(){
    const editing = app.get.editing(),
    canvas = app.canvas.this,
    edit_panel = app.panel.this,
    margins = getComputedStyle(canvas),
    width = canvas.offsetWidth + parseInt(margins.marginLeft) + parseInt(margins.marginRight),
    notice = document.querySelector('.super-marketplace-notice');
    let notice_height = 0;
    if(notice) notice_height = notice.offsetHeight + 10;
    edit_panel.style.left = null;
    edit_panel.style.right = width-editing.offsetLeft-canvas.offsetLeft+editing.offsetWidth+'px';
    edit_panel.style.top = (editing.offsetTop-canvas.offsetTop+35 + editing.offsetHeight + notice_height)+'px';
};

app.panel.events = {
    click : [
        '.super-edit-element-panel .super-width > label',
        '.super-edit-element-panel .super-position > label',
        '.super-edit-element-panel .super-alignment > label',
        '.super-edit-element-panel .super-margins > label',
        '.super-edit-element-panel .super-paddings > label',
        '.super-edit-element-panel .super-flex-size > li',
        '.super-edit-element-panel .super-link-padding',
        '.super-edit-element-panel .super-padding-unit > li',
        '.super-edit-element-panel .super-font-toggle',
        '.super-edit-element-panel .super-layout-toggle',
        '.super-edit-element-panel .super-dropdown-search li.placeholder',
        '.super-edit-element-panel .super-dropdown-search .item > li',
        '.super-edit-element-panel .super-range-slider span'

    ],
    keyup : [
        '.super-edit-element-panel .element-field',
        '.super-edit-element-panel .super-width-custom > input',
        '.super-edit-element-panel .super-custom-width input',
        '.super-edit-element-panel .super-custom-height input',
        '.super-edit-element-panel .super-margins input',
        '.super-edit-element-panel .super-paddings input',
        '.super-edit-element-panel .super-padding input',
        '.super-edit-element-panel .super-label .element-field',
        '.super-edit-element-panel .super-dropdown-search .search input'
    ],
    input : [
        '.super-edit-element-panel .super-padding input',
        '.super-edit-element-panel .super-range-slider input'
    ],
    blur : [
        '.super-edit-element-panel .element-field',
        '.super-edit-element-panel .super-width-custom > input',
        '.super-edit-element-panel .super-custom-width input',
        '.super-edit-element-panel .super-custom-height input',
        '.super-edit-element-panel .super-margins input',
        '.super-edit-element-panel .super-paddings input'
    ]
};

app.panel.options = {
    image : function(key, field, data){
        var $html = '<div class="image-field browse-images">';
        $html += '<span class="button super-insert-image"><i class="fa fa-plus"></i>Browse images</span>';
        $html += '<ul class="image-preview">';
        var $image = '';
        if($v.default!=''){
            // Retrieve image URL from styles
            var $editing = app.get.editing();
            var $image = $editing.css('background-image');
            if(typeof $image !== 'undefined'){
                $image = $image.replace('url(','').replace(')','').replace(/\"/gi, "");
            }
        }
        if($image!='' ){
            $html += '<li data-file="' + $v.default + '">';
            $html += '<div class="image"><img src="' + $image + '"></div>';
            $html += '<a href="#" class="delete">Delete</a>';
            $html += '</li>';
        }
        $html += '</ul>';

        // Background size
        var $size = $data.bg_size;
        var $options = {
            'cover':'Cover (default)', 
            'auto':'Auto', 
            'contain':'Contain', 
            'inherit':'Inherit', 
            'initial':'Initial', 
            'unset':'Unset', 
            'custom':'Custom'
        };
        $html += '<select name="bg_size" class="element-field">';
        $html += '<option value="">- background size -</option>';
        $.each($options, function(k, v){
            $html += '<option value="' + k +'"' + ($size==k ? ' selected="selected"' : '') + '>' + v + '</option>';
        });
        $html += '</select>';
        $html += '<input class="element-field" type="text" name="bg_size_custom" value="' + ($size=='custom' ? $data.bg_size_custom : '') + '" placeholder="Background size e.g 235px"' + ($size!='custom' ? ' style="display:none;"' : '') + ' />';

        // Background repeat
        var $repeat = $data.bg_repeat;
        var $options = {
            'no-repeat':'No repeat (default)', 
            'inherit':'Inherit', 
            'initial':'Initial', 
            'repeat':'Repeat', 
            'repeat-x':'Repeat X axis', 
            'repeat-y':'Repeat Y axis', 
            'round':'Round',
            'space':'Space',
            'unset':'Unset'
        };
        $html += '<select name="bg_repeat" class="element-field">';
        $html += '<option value="">- background repeat -</option>';
        $.each($options, function(k, v){
            $html += '<option value="' + k +'"' + ($repeat==k ? ' selected="selected"' : '') + '>' + v + '</option>';
        });
        $html += '</select>';

        // Background position
        var $position = $data.bg_position;
        var $options = {
            'center':'Center (default)',
            'bottom':'Bottom',
            'inherit':'Inherit',
            'initial':'Initial',
            'left':'Left',
            'right':'Right',
            'top':'Top',
            'unset':'Unset'
        };
        $html += '<select name="bg_position" class="element-field">';
        $html += '<option value="">- background position -</option>';
        $.each($options, function(k, v){
            $html += '<option value="' + k +'"' + ($position==k ? ' selected="selected"' : '') + '>' + v + '</option>';
        });
        $html += '</select>';

        $html += '<input type="hidden" name="' + $k + '" value="' + $v.default + '" id="field-' + $k + '" class="element-field" />';
        $html += '</div>';
        return $html;
    },
    text : function(name, v){
        let value;
        if(typeof v.default === 'object'){
            value = (typeof v.default.value === 'string' ? v.default.value : '');
        }else{
            value = (typeof v.default === 'string' ? v.default : '');
        }
        let html = '<div class="input">';
            html += '<input type="text"';
            if( v.placeholder ) {
                html += ( v.placeholder!='' ? 'placeholder="' + v.placeholder + '"' : '' );
            }
            if( v.required ) {
                html += ( v.required==true ? 'required="true"' : '');
            }
            if( v.maxlength ) {
                html += ( v.maxlength > 0 ? 'maxlength="' + v.maxlength + '"' : '' );
            }
            html += 'name="' + name + '" class="element-field" value="' + value + '" />';
        html += '</div>';
        return html;
    },
    conditions : function(name, v, data){
        const options = {
            'contains':'?? Contains',
            'equal':'== Equal',
            'not_equal':'!= Not equal',
            'greater_than':'> Greater than',
            'less_than':'<  Less than',
            'greater_than_or_equal':'>= Greater than or equal to',
            'less_than_or_equal':'<= Less than or equal'
        };
        let html = '';
        if(typeof data[name] !== 'undefined'){
            Object.keys(data[name]).forEach(function(index) {
                const value = data[name][index];
                if(typeof value.value === 'undefined') value.value = '';
                if(typeof value.field === 'undefined') value.field = '';
                if(typeof value.logic === 'undefined') value.logic = '';
                if(typeof value.and_method === 'undefined') value.and_method = '';
                if(typeof value.field_and === 'undefined') value.field_and = '';
                if(typeof value.logic_and === 'undefined') value.logic_and = '';
                if(typeof value.value_and === 'undefined') value.value_and = '';
                html += '<div class="super-multi-items super-conditional-item">';
                    html += '<select class="super-previously-created" name="conditional_field" data-value="' + value.field + '"></select>';
                    html += '<select name="conditional_logic">';
                        html += '<option selected="selected" value="">---</option>';
                        Object.keys(options).forEach(function(index) {
                            const value = options[index];
                            html += '<option' + (index==value.logic ? ' selected="selected"' : '') + ' value="' + index + '">' + value + '</option>';
                        });
                    html += '</select>';
                    html += '<input type="text" placeholder="Value" value="' + value.value + '" name="conditional_value">';
                    html += '<select name="conditional_and_method">';
                        html += '<option selected="selected" value="">- select -</option>';
                        html += '<option' + ('and'==value.and_method ? ' selected="selected"' : '') + '  value="and">AND</option>';
                        html += '<option' + ('or'==value.and_method ? ' selected="selected"' : '') + '  value="or">OR</option>';
                    html += '</select>';
                    html += '<select class="super-previously-created" name="conditional_field_and" data-value="' + value.field_and + '"></select>';
                    html += '<select name="conditional_logic_and">';
                        html += '<option selected="selected" value="">---</option>';
                        Object.keys(options).forEach(function(index) {
                            const value = options[index];
                            html += '<option' + (index==value.logic_and ? ' selected="selected"' : '') + ' value="' + index + '">' + value + '</option>';
                        });
                    html += '</select>';
                    html += '<input type="text" placeholder="Value" value="' + value.value_and + '" name="conditional_value_and">';
                    html += '<i class="super-add-item fa fa-plus"></i>';
                    html += '<i class="delete fa fa-trash-o" style="visibility: hidden;"></i>';
                    html += '<span class="line-break"></span>';
                html += '</div>';
            });
        }else{
            html += '<div class="super-multi-items super-conditional-item">';
                html += '<select class="super-previously-created" name="conditional_field" data-value=""></select>';
                html += '<select name="conditional_logic">';
                    html += '<option selected="selected" value="">---</option>';
                    Object.keys(options).forEach(function(index) {
                        html += '<option value="' + index + '">' + options[index] + '</option>';
                    });
                html += '</select>';
                html += '<input type="text" placeholder="Value" value="" name="conditional_value">';
                html += '<select name="conditional_and_method">';
                    html += '<option selected="selected" value="">- select -</option>';
                    html += '<option value="and">AND</option>';
                    html += '<option value="or">OR</option>';
                html += '</select>';
                html += '<select class="super-previously-created" name="conditional_field_and" data-value=""></select>';
                html += '<select name="conditional_logic_and">';
                    html += '<option selected="selected" value="">---</option>';
                    Object.keys(options).forEach(function(index) {
                        html += '<option value="' + index + '">' + options[index] + '</option>';
                    });
                html += '</select>';
                html += '<input type="text" placeholder="Value" value="" name="conditional_value_and">';
                html += '<i class="super-add-item fa fa-plus"></i>';
                html += '<i class="delete fa fa-trash-o" style="visibility: hidden;"></i>';
                html += '<span class="line-break"></span>';
            html += '</div>';
        }
        return html;
    },
    color : function(){
        var $html = '<div class="super-color-picker-container">';
            $html += '<div class="super-color-picker">';
                $html += '<input type="text" id="field-' + $k + '" name="' + $k + '" class="element-field" value="' + $v.default + '" />';
            $html += '</div>';
        $html += '</div>';
        return $html;
    },
    padding_margin_dimension : function(){
        if(typeof $data.radius === 'undefined') $data.radius = '';
        if(typeof $data.margin === 'undefined') $data.margin = '';
        if(typeof $data.padding === 'undefined') $data.padding = '';
        if(typeof $data.height === 'undefined') $data.height = '';
        if(typeof $data.width === 'undefined') $data.width = '';
        if(typeof $data.width_unit === 'undefined') $data.width_unit = 'px';
        if( ($data.width_unit!='px') && ($data.width_unit!='%') && ($data.width_unit!='em') && ($data.width_unit!='rem') ) {
            $data.width_unit = 'px';
        }

        var $radius = $data.radius.split(' ');
        var $margins = $data.margin.split(' ');
        var $paddings = $data.padding.split(' ');

        if( ($data.width!='') && ($data.width!=0) ) {
            $data.size = 'custom';
        }
        var $html = '<div class="super-padding-margin">';
            $html += '<div class="super-margins' + ($data.margin.length ? ' active' : '') + '">';
                $html += '<input class="super-tooltip" title="Set a border radius (or leave blank)" type="text" name="top_left_radius" value="' + (typeof $radius[0]!=='undefined' && $radius[0]!='' ? $radius[0] : '0') + '" />';
                $html += '<input class="super-tooltip" title="Set a border radius (or leave blank)" type="text" name="top_right_radius" value="' + (typeof $radius[1]!=='undefined' && $radius[1]!='' ? $radius[1] : '0') + '" />';
                $html += '<input class="super-tooltip" title="Set a border radius (or leave blank)" type="text" name="bottom_right_radius" value="' + (typeof $radius[2]!=='undefined' && $radius[2]!='' ? $radius[2] : '0') + '" />';
                $html += '<input class="super-tooltip" title="Set a border radius (or leave blank)" type="text" name="bottom_left_radius" value="' + (typeof $radius[3]!=='undefined' && $radius[3]!='' ? $radius[3] : '0') + '" />';
                $html += '<label><span class="checkbox"></span><span>enable custom margin</span></label>';
                $html += '<input class="super-tooltip" title="Top margin" type="text" name="top_margin" value="' + (typeof $margins[0]!=='undefined' && $margins[0]!='' ? $margins[0] : '0') + '" />';
                $html += '<input class="super-tooltip" title="Right margin" type="text" name="right_margin" value="' + (typeof $margins[1]!=='undefined' && $margins[1]!='' ? $margins[1] : '0') + '" />';
                $html += '<input class="super-tooltip" title="Bottom margin" type="text" name="bottom_margin" value="' + (typeof $margins[2]!=='undefined' && $margins[2]!='' ? $margins[2] : '0') + '" />';
                $html += '<input class="super-tooltip" title="Left margin" type="text" name="left_margin" value="' + (typeof $margins[3]!=='undefined' && $margins[3]!='' ? $margins[3] : '0') + '" />';
            $html += '</div>';
            $html += '<div class="super-paddings' + ($data.padding.length ? ' active' : '') + '">';
                $html += '<label><span class="checkbox"></span><span>enable custom padding</span></label>';
                $html += '<input class="super-tooltip" title="Top padding" type="text" name="top_padding" value="' + (typeof $paddings[0]!=='undefined' && $paddings[0]!='' ? $paddings[0] : '0') + '" />';
                $html += '<input class="super-tooltip" title="Right padding" type="text" name="right_padding" value="' + (typeof $paddings[1]!=='undefined' && $paddings[1]!='' ? $paddings[1] : '0') + '" />';
                $html += '<input class="super-tooltip" title="Bottom padding" type="text" name="bottom_padding" value="' + (typeof $paddings[2]!=='undefined' && $paddings[2]!='' ? $paddings[2] : '0') + '" />';
                $html += '<input class="super-tooltip" title="Left padding" type="text" name="left_padding" value="' + (typeof $paddings[3]!=='undefined' && $paddings[3]!='' ? $paddings[3] : '0') + '" />';
            $html += '</div>';


            $html += '<div class="super-custom-width">';
                $html += '<input type="text" name="width" value="' + $data.width + '" class="element-field super-tooltip" title="Set a custom width (or leave blank)" />';
                $html += '<input type="text" name="width_unit" value="' + $data.width_unit + '" class="element-field super-tooltip" title="Set the width unit e.g px or %" />';
                $html += '<ul class="super-size">';
                    $html += '<li' + ($data.size=='1/5' ? ' class="active"' : '') + '>1/5</li>';
                    $html += '<li' + ($data.size=='1/4' ? ' class="active"' : '') + '>1/4</li>';
                    $html += '<li' + ($data.size=='1/3' ? ' class="active"' : '') + '>1/3</li>';
                    $html += '<li' + ($data.size=='2/5' ? ' class="active"' : '') + '>2/5</li>';
                    $html += '<li' + ($data.size=='1/2' ? ' class="active"' : '') + '>1/2</li>';
                    $html += '<li' + ($data.size=='3/5' ? ' class="active"' : '') + '>3/5</li>';
                    $html += '<li' + ($data.size=='2/3' ? ' class="active"' : '') + '>2/3</li>';
                    $html += '<li' + ($data.size=='3/4' ? ' class="active"' : '') + '>3/4</li>';
                    $html += '<li' + ($data.size=='4/5' ? ' class="active"' : '') + '>4/5</li>';
                    $html += '<li' + ($data.size=='1/1' ? ' class="active"' : '') + '>1/1</li>';
                $html += '</ul>';
            $html += '</div>';

            $html += '<div class="super-custom-height">';
                $html += '<input type="text" name="height" value="' + $data.height + '" class="element-field super-tooltip" title="Set a custom height (or leave blank)" />';
            $html += '</div>';

            $html += '<span class="super-column-content">Column contents</span>';
            $html += '<input type="hidden" name="margin" value="' + $data.margin + '" class="element-field" />';
            $html += '<input type="hidden" name="padding" value="' + $data.padding + '" class="element-field" />';
            $html += '<input type="hidden" name="radius" value="' + $data.radius + '" class="element-field" />';
            $html += '<input type="hidden" name="size" value="' + $data.size + '" class="element-field" />';
        $html += '</div>';
        return $html;
    },
    slider : function(name, v){
        let html = '<div class="slider-field">';
        html += '<input type="text" name="' + name + '" value="' + v.default + '" data-steps="' + v.steps + '" data-min="' + v.min + '" data-max="' + v.max + '" class="element-field" />';
        html += '</div>';
        return html;
    },
    checkbox : function(name, v){
        let html = '<div class="super-checkbox">';
        Object.keys(v.values).forEach(function(index) {
            const value = v.values[index];
            let checked = '';
            if( (v.multiple) && (v.default!='') ) {
                if(index.indexOf(v.default) == -1){
                    checked = ' checked="checked"';
                }
            }else{
                if( v.default==index ) {
                    checked = ' checked="checked"';
                }
            }
            html += '<label><input type="checkbox" value="' + index + '"' + checked + '>' + value +'</label>';
        });
        html += '<input type="hidden" name="' + name + '" value="' + v.default + '" class="element-field" />';
        html += '</div>';
        return html;
    },
    dropdown : function(name, v){
        let html = '<div class="input">';
            html += '<select name="' + name + '" class="element-field">';
            Object.keys(v.values).forEach(function(index) {
                const value = v.values[index];
                let selected = '';
                if( (v.multiple) && (v.default!='') ) {
                    if(index.indexOf(v.default) == -1){
                        selected = ' selected="selected"';
                    }
                }else{
                    if( v.default==index ) {
                        selected = ' selected="selected"';
                    }
                }
                html += '<option value="' + index + '"' + selected + '>' + value +'</option>';
            });
            html += '</select>';
            if(v.info) html += '<p>' + v.info + '</p>';
        html += '</div>';
        return html;
    },
    select : function(name, v){
        return app.panel.options.dropdown(name, v);
    },
    file : function(name, v){
        return 'File upload field element...';
    },
    icon : function(name, v){
        return 'Icon field element...';
    },
    font_styles : function(option_name, font_data){

        let toggles = '<span class="super-font-toggle">Font</span>';

        // Font settings
        let html = '<div class="super-font">';

            // Font color
            html += '<div class="super-font-color">';
                html += '<div class="super-color-picker">';
                    html += '<span>Color</span>';
                    html += '<div class="super-picker-box">';
                        html += '<span class="super-picker-color"></span>';
                    html += '</div>';
                    html += '<input class="super-picker-value" type="text" value="'+(typeof font_data.color !== 'undefined' ? font_data.color : '#000000')+'" disabled="disabled" />';
                    html += '<input class="super-picker-alpha" type="range" min="0" max="1" step=".01" value="1" />';
                    html += '<input class="super-color-code" type="text" value="'+(typeof font_data.color !== 'undefined' ? font_data.color : '#000000')+'" />';
                html += '</div>';
                html += '<textarea class="super-option-merge">{"object":{"'+option_name+'":{"font":{"color":"{value}"}}},"query_selector":".super-label-description > .super-'+option_name+'","style_update":"color"}</textarea>';
            html += '</div>';

            // Font family
            html += '<div class="super-dropdown-search super-font-family">';
                html += '<span>Family</span>';
                html += '<ul>';
                    font_data.family = (typeof font_data.family !== 'undefined' ? font_data.family : 'Default');
                    html += '<li class="placeholder">'+font_data.family+'</li>';
                    html += '<li class="search"><input type="text" /></li>';
                    html += '<li class="items">';
                        html += '<ul>';
                            Object.keys(app.fonts.list).forEach(function(key){
                                const value = app.fonts.list[key];
                                html += '<li class="group" data-type="'+key+'">';
                                    if(key=='system'){
                                        html += '<ul class="item">';
                                            html += '<li data-value="Default"'+(font_data.family=='Default' ? ' class="active"' : '')+'>Default</li>';
                                        html += '</ul>';
                                    }
                                    html += '<strong>'+value.name+'</strong>';
                                    html += '<ul class="item">';
                                        for( const font of value.fonts ){
                                            html += '<li data-value="'+font+'"'+(font_data.family==font ? ' class="active"' : '')+'>'+font+'</li>';
                                        }
                                    html += '</ul>';
                                html += '</li>';
                            });
                        html += '</ul>';
                    html += '</li>';
                html += '</ul>';
                html += '<textarea class="super-option-merge">{"object":{"'+option_name+'":{"font":{"family":"{value}"}}},"query_selector":".super-label-description > .super-'+option_name+'","style_update":"fontFamily"}</textarea>';
            html += '</div>';

            // Font size
            html += '<div class="super-font-size">';
                html += '<span>Size</span>';
                html += '<div class="super-range-slider">';
                    let max = 50, min = 1, step = 1;
                    if(font_data.unit!='px' && typeof font_data.unit!=='undefined' ){
                        max = 10, min = 0, step = 0.1;
                    }
                    html += '<input type="range" min="'+min+'" max="'+max+'" step="'+step+'" value="'+(typeof font_data.size !== 'undefined' ? font_data.size : '12')+'">';
                    html += '<input type="number" min="'+min+'" max="'+max+'" step="'+step+'" value="'+(typeof font_data.size !== 'undefined' ? font_data.size : '12')+'" />';
                    html += '<span'+(font_data.unit=='px' || typeof font_data.unit==='undefined' ? ' class="active"' : '')+'>PX</span>';
                    html += '<span'+(font_data.unit=='em' ? ' class="active"' : '')+'>EM</span>';
                    html += '<span'+(font_data.unit=='rem' ? ' class="active"' : '')+'>REM</span>'
                html += '</div>';
                html += '<textarea class="super-option-merge">{"object":{"'+option_name+'":{"font":{"size":"{value}","unit":"{unit}"}}},"query_selector":".super-label-description > .super-'+option_name+'","style_update":"fontSize"}</textarea>';
            html += '</div>';

            // Font weight
            html += '<div class="super-dropdown-search super-font-weight">';
                html += '<span>Weight</span>';
                html += '<ul>';
                    html += '<li class="placeholder">'+(font_data.weight == '' || typeof font_data.weight === 'undefined' ? 'Default' : font_data.weight)+'</li>';
                    html += '<li class="search"><input type="text" /></li>';
                    html += '<li class="items">';
                        html += '<ul>';
                            html += '<li class="group">';
                                html += '<ul class="item">';

                                    const weights = ['100', '200', '300', '400', '500', '600', '700', '800', '900', 'Default', 'Normal', 'Bold'];
                                    for( const weight of weights ){
                                        const weight_lower = weight.toLowerCase();
                                        html += '<li data-value="'+weight_lower+'"'+(font_data.weight==weight_lower || ( (font_data.weight=='' || typeof font_data.weight==='undefined') && weight_lower=='default') ? ' class="active"' : '')+'>'+weight+'</li>';
                                    }
                                html += '</ul>';
                            html += '</li>';
                        html += '</ul>';
                    html += '</li>';
                html += '</ul>';
                html += '<textarea class="super-option-merge">{"object":{"'+option_name+'":{"font":{"weight":"{value}"}}},"query_selector":".super-label-description > .super-'+option_name+'","style_update":"fontWeight"}</textarea>';
            html += '</div>';

            // Font transform
            html += '<div class="super-dropdown-search super-font-transform">';
                html += '<span>Transform</span>';
                html += '<ul>';
                    html += '<li class="placeholder">'+(font_data.transform == '' || typeof font_data.transform === 'undefined' ? 'Default' : font_data.transform)+'</li>';
                    html += '<li class="search"><input type="text" /></li>';
                    html += '<li class="items">';
                        html += '<ul>';
                            html += '<li class="group">';
                                html += '<ul class="item">';
                                    const transforms = ['Default', 'Uppercase', 'Lowercase', 'Capitalize', 'Normal'];
                                    for( const transform of transforms ){
                                        const transform_lower = transform.toLowerCase();
                                        let value = transform_lower;
                                        if(transform_lower=='normal'){
                                            value = 'none';
                                        }
                                        html += '<li data-value="'+value+'"'+(font_data.transform==transform_lower || ( (font_data.transform=='' || typeof font_data.transform==='undefined') && transform_lower=='default') ? ' class="active"' : '')+'>'+transform+'</li>';
                                    }
                                html += '</ul>';
                            html += '</li>';
                        html += '</ul>';
                    html += '</li>';
                html += '</ul>';
                html += '<textarea class="super-option-merge">{"object":{"'+option_name+'":{"font":{"transform":"{value}"}}},"query_selector":".super-label-description > .super-'+option_name+'","style_update":"textTransform"}</textarea>';
            html += '</div>';

            // Font style
            html += '<div class="super-dropdown-search super-font-style">';
                html += '<span>Style</span>';
                html += '<ul>';
                    html += '<li class="placeholder">'+(font_data.style == '' || typeof font_data.style === 'undefined' ? 'Default' : font_data.style)+'</li>';
                    html += '<li class="search"><input type="text" /></li>';
                    html += '<li class="items">';
                        html += '<ul>';
                            html += '<li class="group">';
                                html += '<ul class="item">';
                                    const styles = ['Default', 'Normal', 'Italic', 'Oblique'];
                                    for( const style of styles ){
                                        const style_lower = style.toLowerCase();
                                        html += '<li data-value="'+style_lower+'"'+(font_data.style==style_lower || ( (font_data.style=='' || typeof font_data.style==='undefined') && style_lower=='default') ? ' class="active"' : '')+'>'+style+'</li>';
                                    }
                                html += '</ul>';
                            html += '</li>';
                        html += '</ul>';
                    html += '</li>';
                html += '</ul>';
                html += '<textarea class="super-option-merge">{"object":{"'+option_name+'":{"font":{"style":"{value}"}}},"query_selector":".super-label-description > .super-'+option_name+'","style_update":"fontStyle"}</textarea>';
            html += '</div>';

            // Font decoration
            html += '<div class="super-dropdown-search super-font-decoration">';
                html += '<span>Decoration</span>';
                html += '<ul>';
                    html += '<li class="placeholder">'+(font_data.decoration == '' || typeof font_data.decoration === 'undefined' ? 'Default' : font_data.decoration)+'</li>';
                    html += '<li class="search"><input type="text" /></li>';
                    html += '<li class="items">';
                        html += '<ul>';
                            html += '<li class="group">';
                                html += '<ul class="item">';
                                    const decorations = ['Default', 'Underline', 'Overline', 'Line Through', 'None'];
                                    for( const decoration of decorations ){
                                        const decoration_lower = decoration.toLowerCase();
                                        html += '<li data-value="'+decoration_lower+'"'+(font_data.decoration==decoration_lower || ( (font_data.decoration=='' || typeof font_data.decoration==='undefined') && decoration_lower=='default') ? ' class="active"' : '')+'>'+decoration+'</li>';
                                    }
                                html += '</ul>';
                            html += '</li>';
                        html += '</ul>';
                    html += '</li>';
                html += '</ul>';
                html += '<textarea class="super-option-merge">{"object":{"'+option_name+'":{"font":{"decoration":"{value}"}}},"query_selector":".super-label-description > .super-'+option_name+'","style_update":"textDecoration"}</textarea>';
            html += '</div>';

            // Font line-height
            html += '<div class="super-font-line-height">';
                html += '<span>Line-height</span>';
                html += '<div class="super-range-slider">';
                    max = 50, min = 1, step = 1;
                    if(font_data.lunit!='px' && typeof font_data.lunit!=='undefined' ){
                        max = 10, min = 0, step = 0.1;
                    }
                    html += '<input type="range" min="'+min+'" max="'+max+'" step="'+step+'" value="'+(typeof font_data.line_height !== 'undefined' ? font_data.line_height : '')+'">';
                    html += '<input type="number" min="'+min+'" max="'+max+'" step="'+step+'" value="'+(typeof font_data.line_height !== 'undefined' ? font_data.line_height : '')+'" />';
                    html += '<span'+(font_data.lunit=='px' || typeof font_data.lunit==='undefined' ? ' class="active"' : '')+'>PX</span>';
                    html += '<span'+(font_data.lunit=='em' ? ' class="active"' : '')+'>EM</span>';
                    html += '<span'+(font_data.lunit=='rem' ? ' class="active"' : '')+'>REM</span>'
                html += '</div>';
                html += '<textarea class="super-option-merge">{"object":{"'+option_name+'":{"font":{"line_height":"{value}","lunit":"{lunit}"}}},"query_selector":".super-label-description > .super-'+option_name+'","style_update":"lineHeight"}</textarea>';
            html += '</div>';

            // Font letter-spacing
            html += '<div class="super-font-letter-spacing">';
                html += '<span>letter spacing</span>';
                html += '<div class="super-range-slider">';
                    max = 10, min = '-5', step = 0.1;
                    html += '<input type="range" min="'+min+'" max="'+max+'" step="'+step+'" value="'+(typeof font_data.spacing !== 'undefined' ? font_data.spacing : '')+'">';
                    html += '<input type="number" min="'+min+'" max="'+max+'" step="'+step+'" value="'+(typeof font_data.spacing !== 'undefined' ? font_data.spacing : '')+'" />';
                    html += '<span'+(font_data.lsunit=='px' || typeof font_data.lsunit==='undefined' ? ' class="active"' : '')+'>PX</span>';
                    html += '<span'+(font_data.lsunit=='em' ? ' class="active"' : '')+'>EM</span>';
                    html += '<span'+(font_data.lsunit=='rem' ? ' class="active"' : '')+'>REM</span>'
                html += '</div>';
                html += '<textarea class="super-option-merge">{"object":{"'+option_name+'":{"font":{"spacing":"{value}","lsunit":"{lsunit}"}}},"query_selector":".super-label-description > .super-'+option_name+'","style_update":"letterSpacing"}</textarea>';
            html += '</div>';

        html += '</div>';
        return {
            toggles: toggles,
            html: html,
        };
    },

    error_position : function(v, data){

        // Backward compatibility with older super forms versions
        if(typeof data.error !== 'object'){
            data.error = {
                value : data.error
            };
        }

        // Define label position data
        data.error.position = (typeof data.error.position === 'undefined' ? 'top' : data.error.position); 
        data.error.alignment = (typeof data.error.alignment === 'undefined' ? 'left' : data.error.alignment); 
        data.error.width = (typeof data.error.width === 'undefined' ? 'auto' : data.error.width); // auto, flex, fixed
        data.error.flex_size = (typeof data.error.flex_size === 'undefined' ? '1/2' : data.error.flex_size); // 1/2, 3/5 etc.
        data.error.size = (typeof data.error.size === 'undefined' ? '50' : data.error.size); // 50, 33 etc.
        data.error.unit = (typeof data.error.unit === 'undefined' ? '%' : data.error.unit); // %, px etc.
        data.error.padding = (typeof data.error.padding === 'undefined' ? {} : data.error.padding);
        data.error.padding.unit = (typeof data.error.padding.unit === 'undefined' ? 'px' : data.error.padding.unit);

        let toggles = '<span class="super-layout-toggle">Layout</span>';

        // Layout settings
        let html = '<div class="super-layout">';
            // Label Positioning
            html += '<div class="super-position">';
                // Top
                html += (data.error.position=='top') ? '<label class="active ' : '<label class="';
                html += 'top super-tooltip" title="Label above field"></label>';
                // Left
                html += (data.error.position=='left') ? '<label class="active ' : '<label class="';
                html += 'left super-tooltip" title="Label left from field"></label>';
                // Bottom
                html += (data.error.position=='bottom') ? '<label class="active ' : '<label class="';
                html += 'bottom super-tooltip" title="Label below field"></label>';
                // Right
                html += (data.error.position=='right') ? '<label class="active ' : '<label class="';
                html += 'right super-tooltip" title="Label right from field"></label>';
            html += '</div>';

            // Label Alignment
            html += '<div class="super-alignment">';
                // Left
                html += (data.error.alignment=='left') ? '<label class="active ' : '<label class="';
                html += 'left super-tooltip" title="Align left"></label>';
                // Center
                html += (data.error.alignment=='center') ? '<label class="active ' : '<label class="';
                html += 'center super-tooltip" title="Align center"></label>';
                // Right
                html += (data.error.alignment=='right') ? '<label class="active ' : '<label class="';
                html += 'right super-tooltip" title="Align right"></label>';
                // Justified
                html += (data.error.alignment=='justify') ? '<label class="active ' : '<label class="';
                html += 'justify super-tooltip" title="Align justified"></label>';
            html += '</div>';

            // Label Width
            html += '<div class="super-width" '+( (data.error.position=='top' || data.error.position=='bottom') ? 'style="display:none;"' : "")+'>';
                // Auto
                html += (data.error.width=='auto') ? '<label class="active ' : '<label class="';
                html += 'auto super-tooltip" title="Automatic width">Auto</label>';
                // Flex
                html += (data.error.width=='flex') ? '<label class="active ' : '<label class="';
                html += 'flex super-tooltip" title="Flex width">Flex</label>';
                // Fixed
                html += (data.error.width=='fixed') ? '<label class="active ' : '<label class="';
                html += 'fixed super-tooltip" title="Fixed width">Fixed</label>';

                // Label custom width inputs
                let style = 'none;';
                if( data.error.width=='fixed') {
                    style = 'block;';
                }
                html += '<div class="super-width-custom" style="display:'+style+';">';
                    html += '<input type="text" name="width" value="' + data.error.size + '" class="element-field super-tooltip" title="Set a custom width (or leave blank)" />';
                    html += '<input type="text" name="width_unit" value="' + data.error.unit + '" class="element-field super-tooltip" title="Set the width unit e.g px or %" />';
                html += '</div>';
            html += '</div>';

            style = 'none;';
            if( data.error.width=='flex') {
                style = 'block;';
            }                    
            html += '<ul class="super-flex-size super-tooltip" title="Choose a size for your Flex width" style="display:'+style+';">';
                html += '<li' + (data.error.flex_size=='1/5' ? ' class="active"' : '') + '>1/5</li>';
                html += '<li' + (data.error.flex_size=='1/4' ? ' class="active"' : '') + '>1/4</li>';
                html += '<li' + (data.error.flex_size=='1/3' ? ' class="active"' : '') + '>1/3</li>';
                html += '<li' + (data.error.flex_size=='2/5' ? ' class="active"' : '') + '>2/5</li>';
                html += '<li' + (data.error.flex_size=='1/2' ? ' class="active"' : '') + '>1/2</li>';
                html += '<li' + (data.error.flex_size=='3/5' ? ' class="active"' : '') + '>3/5</li>';
                html += '<li' + (data.error.flex_size=='2/3' ? ' class="active"' : '') + '>2/3</li>';
                html += '<li' + (data.error.flex_size=='3/4' ? ' class="active"' : '') + '>3/4</li>';
                html += '<li' + (data.error.flex_size=='4/5' ? ' class="active"' : '') + '>4/5</li>';
            html += '</ul>';

            // Error paddings
            html += '<div class="super-padding-wrapper">';
                html += '<ul class="super-padding">';
                    html += '<li class="super-tooltip" title="Error padding top"><input type="number" name="top" value="' + data.error.padding.top + '" /><span>top</span></li>';
                    html += '<li class="super-tooltip" title="Error padding right"><input type="number" name="right" value="' + data.error.padding.right + '" /><span>right</span></li>';
                    html += '<li class="super-tooltip" title="Error padding bottom"><input type="number" name="bottom" value="' + data.error.padding.bottom + '" /><span>bottom</span></li>';
                    html += '<li class="super-tooltip" title="Error padding left"><input type="number" name="left" value="' + data.error.padding.left + '" /><span>left</span></li>';
                    html += '<li class="super-tooltip" title="Link values together"><span class="super-link-padding"></span></li>';
                html += '</ul>';
                html += '<ul class="super-padding-unit super-tooltip" title="Padding unit">';
                    html += '<li' + (data.error.padding.unit=='px' ? ' class="active"' : '') + '>PX</li>';
                    html += '<li' + (data.error.padding.unit=='em' ? ' class="active"' : '') + '>EM</li>';
                    html += '<li' + (data.error.padding.unit=='rem' ? ' class="active"' : '') + '>REM</li>';
                html += '</ul>';
            html += '</div>';
        html += '</div>';

        return {
            toggles: toggles,
            html: html,
        };


        /*
        // Error Positioning
        html = '<div class="super-dropdown-search super-error-positioning">';
            html += '<span>Positioning</span>';
            html += '<ul>';
                html += '<li class="placeholder">'+(error_data.positioning == '' || typeof error_data.positioning === 'undefined' ? 'Default' : error_data.positioning)+'</li>';
                html += '<li class="search"><input type="text" /></li>';
                html += '<li class="items">';
                    html += '<ul>';
                        html += '<li class="group">';
                            html += '<ul class="item">';
                                const positionings = ['Default', 'Above Wrapper', 'Above Field', 'Below Wrapper', 'Below Field'];
                                for( const positioning of positionings ){
                                    const positioning_lower = positioning.toLowerCase();
                                    html += '<li data-value="'+positioning_lower+'"'+(error_data.positioning==positioning_lower || ( (error_data.positioning=='' || typeof error_data.positioning==='undefined') && positioning_lower=='default') ? ' class="active"' : '')+'>'+positioning+'</li>';
                                }
                            html += '</ul>';
                        html += '</li>';
                    html += '</ul>';
                html += '</li>';
            html += '</ul>';
            html += '<textarea class="super-option-merge">{"object":{"'+option_name+'":{"positioning":"{value}"}},"query_selector":".super-error"}</textarea>';
        html += '</div>';

        return {
            toggles: toggles,
            html: html,
        };
        */

    },


    position : function(v, data){

        // Backward compatibility with older super forms versions
        if(typeof data.label !== 'object'){
            data.label = {
                value : data.label
            };
        }

        // Define label position data
        data.label.position = (typeof data.label.position === 'undefined' ? 'top' : data.label.position); 
        data.label.alignment = (typeof data.label.alignment === 'undefined' ? 'left' : data.label.alignment); 
        data.label.width = (typeof data.label.width === 'undefined' ? 'auto' : data.label.width); // auto, flex, fixed
        data.label.flex_size = (typeof data.label.flex_size === 'undefined' ? '1/2' : data.label.flex_size); // 1/2, 3/5 etc.
        data.label.size = (typeof data.label.size === 'undefined' ? '50' : data.label.size); // 50, 33 etc.
        data.label.unit = (typeof data.label.unit === 'undefined' ? '%' : data.label.unit); // %, px etc.
        data.label.padding = (typeof data.label.padding === 'undefined' ? {} : data.label.padding);
        data.label.padding.unit = (typeof data.label.padding.unit === 'undefined' ? 'px' : data.label.padding.unit);

        let toggles = '<span class="super-layout-toggle">Layout</span>';

        // Layout settings
        let html = '<div class="super-layout">';
            // Label Positioning
            html += '<div class="super-position">';
                // Top
                html += (data.label.position=='top') ? '<label class="active ' : '<label class="';
                html += 'top super-tooltip" title="Label above field"></label>';
                // Left
                html += (data.label.position=='left') ? '<label class="active ' : '<label class="';
                html += 'left super-tooltip" title="Label left from field"></label>';
                // Bottom
                html += (data.label.position=='bottom') ? '<label class="active ' : '<label class="';
                html += 'bottom super-tooltip" title="Label below field"></label>';
                // Right
                html += (data.label.position=='right') ? '<label class="active ' : '<label class="';
                html += 'right super-tooltip" title="Label right from field"></label>';
            html += '</div>';

            // Label Alignment
            html += '<div class="super-alignment">';
                // Left
                html += (data.label.alignment=='left') ? '<label class="active ' : '<label class="';
                html += 'left super-tooltip" title="Align left"></label>';
                // Center
                html += (data.label.alignment=='center') ? '<label class="active ' : '<label class="';
                html += 'center super-tooltip" title="Align center"></label>';
                // Right
                html += (data.label.alignment=='right') ? '<label class="active ' : '<label class="';
                html += 'right super-tooltip" title="Align right"></label>';
                // Justified
                html += (data.label.alignment=='justify') ? '<label class="active ' : '<label class="';
                html += 'justify super-tooltip" title="Align justified"></label>';
            html += '</div>';

            // Label Width
            html += '<div class="super-width" '+( (data.label.position=='top' || data.label.position=='bottom') ? 'style="display:none;"' : "")+'>';
                // Auto
                html += (data.label.width=='auto') ? '<label class="active ' : '<label class="';
                html += 'auto super-tooltip" title="Automatic width">Auto</label>';
                // Flex
                html += (data.label.width=='flex') ? '<label class="active ' : '<label class="';
                html += 'flex super-tooltip" title="Flex width">Flex</label>';
                // Fixed
                html += (data.label.width=='fixed') ? '<label class="active ' : '<label class="';
                html += 'fixed super-tooltip" title="Fixed width">Fixed</label>';

                // Label custom width inputs
                let style = 'none;';
                if( data.label.width=='fixed') {
                    style = 'block;';
                }
                html += '<div class="super-width-custom" style="display:'+style+';">';
                    html += '<input type="text" name="width" value="' + data.label.size + '" class="element-field super-tooltip" title="Set a custom width (or leave blank)" />';
                    html += '<input type="text" name="width_unit" value="' + data.label.unit + '" class="element-field super-tooltip" title="Set the width unit e.g px or %" />';
                html += '</div>';
            html += '</div>';

            style = 'none;';
            if( data.label.width=='flex') {
                style = 'block;';
            }                    
            html += '<ul class="super-flex-size super-tooltip" title="Choose a size for your Flex width" style="display:'+style+';">';
                html += '<li' + (data.label.flex_size=='1/5' ? ' class="active"' : '') + '>1/5</li>';
                html += '<li' + (data.label.flex_size=='1/4' ? ' class="active"' : '') + '>1/4</li>';
                html += '<li' + (data.label.flex_size=='1/3' ? ' class="active"' : '') + '>1/3</li>';
                html += '<li' + (data.label.flex_size=='2/5' ? ' class="active"' : '') + '>2/5</li>';
                html += '<li' + (data.label.flex_size=='1/2' ? ' class="active"' : '') + '>1/2</li>';
                html += '<li' + (data.label.flex_size=='3/5' ? ' class="active"' : '') + '>3/5</li>';
                html += '<li' + (data.label.flex_size=='2/3' ? ' class="active"' : '') + '>2/3</li>';
                html += '<li' + (data.label.flex_size=='3/4' ? ' class="active"' : '') + '>3/4</li>';
                html += '<li' + (data.label.flex_size=='4/5' ? ' class="active"' : '') + '>4/5</li>';
            html += '</ul>';

            // Label paddings
            html += '<div class="super-padding-wrapper">';
                html += '<ul class="super-padding">';
                    html += '<li class="super-tooltip" title="Label padding top"><input type="number" name="top" value="' + data.label.padding.top + '" /><span>top</span></li>';
                    html += '<li class="super-tooltip" title="Label padding right"><input type="number" name="right" value="' + data.label.padding.right + '" /><span>right</span></li>';
                    html += '<li class="super-tooltip" title="Label padding bottom"><input type="number" name="bottom" value="' + data.label.padding.bottom + '" /><span>bottom</span></li>';
                    html += '<li class="super-tooltip" title="Label padding left"><input type="number" name="left" value="' + data.label.padding.left + '" /><span>left</span></li>';
                    html += '<li class="super-tooltip" title="Link values together"><span class="super-link-padding"></span></li>';
                html += '</ul>';
                html += '<ul class="super-padding-unit super-tooltip" title="Padding unit">';
                    html += '<li' + (data.label.padding.unit=='px' ? ' class="active"' : '') + '>PX</li>';
                    html += '<li' + (data.label.padding.unit=='em' ? ' class="active"' : '') + '>EM</li>';
                    html += '<li' + (data.label.padding.unit=='rem' ? ' class="active"' : '') + '>REM</li>';
                html += '</ul>';
            html += '</div>';
        html += '</div>';

        return {
            toggles: toggles,
            html: html,
        };
    },
    checkbox_items : function(name, v){
        let html = '<div class="field-info-message"></div>';
        Object.keys(v.default).forEach(function(index) {
            const value = v.default[index];
            html += '<div class="super-multi-items super-dropdown-item">';
                if( typeof value.checked === 'undefined' ) value.checked = 'false';
                html += '<input data-prev="' + value.checked + '" ' + (v.type=='radio_items' || v.type=='autosuggest_items' ? 'type="radio"' : 'type="checkbox"') + ( value.checked==true ? ' checked="checked"' : '' ) + '>';
                html += '<div class="sorting">';
                    html += '<span class="up"><i class="fa fa-arrow-up"></i></span>';
                    html += '<span class="down"><i class="fa fa-arrow-down"></i></span>';
                html += '</div>';
                html += '<input type="text" placeholder="' + 'Label' + '" value="' + value.label + '" name="label">';
                html += '<input type="text" placeholder="' + 'Value' + '" value="' + value.value + '" name="value">';

                // @since v1.2.3
                if( (v.type=='checkbox_items') || (v.type=='radio_items') ) {
                    if(!value.image)  value.image = '';
                    html += '<div class="image-field browse-images">';
                    html += '<span class="button super-insert-image"><i class="fa fa-picture-o"></i></span>';
                    html += '<ul class="image-preview">';
                    let image = '';
                    if(value.image!=''){
                        // Retrieve image URL from styles
                        const item = app.get.editing().querySelector('.super-field-wrapper > label:eq('+index+')')
                        image = item.querySelector('.image').style.backgroundImage
                        if(typeof image !== 'undefined'){
                            image = image.replace('url(','').replace(')','').replace(/\"/gi, "");
                        }
                    }
                    if(image!='' ){
                        html += '<li data-file="' + value.image + '">';
                            html += '<div class="image"><img src="' + image + '"></div>';
                            html += '<input type="number" placeholder="' + 'width' + '" value="' + value.width + '" name="width">';
                            html += '<span>px</span>';
                            html += '<input type="number" placeholder="' + 'height' + '" value="' + value.height + '" name="height">';
                            html += '<span>px</span>';
                            html += '<a href="#" class="delete">Delete</a>';

                            // Background size
                            const size = value.bg_size;
                            let options = {
                                'cover':'Cover (default)', 
                                'auto':'Auto', 
                                'contain':'Contain', 
                                'inherit':'Inherit', 
                                'initial':'Initial', 
                                'unset':'Unset', 
                                'custom':'Custom'
                            };
                            html += '<select name="bg_size">';
                            html += '<option value="">- background size -</option>';

                            Object.keys(options).forEach(function(index) {
                                const value = options[index];
                                html += '<option value="' + index +'"' + (size==index ? ' selected="selected"' : '') + '>' + value + '</option>';
                            });
                            html += '</select>';
                            html += '<input type="text" name="bg_size_custom" value="' + (size=='custom' ? value.bg_size_custom : '') + '" placeholder="Background size e.g 235px"' + (size!='custom' ? ' style="display:none;"' : '') + ' />';

                            // Background repeat
                            const repeat = value.bg_repeat;
                            options = {
                                'no-repeat':'No repeat (default)', 
                                'inherit':'Inherit', 
                                'initial':'Initial', 
                                'repeat':'Repeat', 
                                'repeat-x':'Repeat X axis', 
                                'repeat-y':'Repeat Y axis', 
                                'round':'Round',
                                'space':'Space',
                                'unset':'Unset'
                            };
                            html += '<select name="bg_repeat">';
                            html += '<option value="">- background repeat -</option>';
                            Object.keys(options).forEach(function(index) {
                                const value = options[index];
                                html += '<option value="' + index +'"' + (repeat==index ? ' selected="selected"' : '') + '>' + value + '</option>';
                            });
                            html += '</select>';

                            // Background position
                            const position = value.bg_position;
                            options = {
                                'center':'Center (default)',
                                'bottom':'Bottom',
                                'inherit':'Inherit',
                                'initial':'Initial',
                                'left':'Left',
                                'right':'Right',
                                'top':'Top',
                                'unset':'Unset'
                            };
                            html += '<select name="bg_position">';
                            html += '<option value="">- background position -</option>';
                            Object.keys(options).forEach(function(index) {
                                const value = options[index];
                                html += '<option value="' + index +'"' + (position==index ? ' selected="selected"' : '') + '>' + value + '</option>';
                            });
                            html += '</select>';

                        html += '</li>';
                    }
                    html += '</ul>';
                    html += '<input type="hidden" name="image" value="' + value.image + '" />';
                    html += '</div>';
                }

                html += '<i class="super-add-item fa fa-plus"></i>';
                html += '<i class="delete fa fa-trash-o"></i>';
            html += '</div>';
        });
        html += '<textarea name="' + v.type + '" class="element-field multi-items-json">' + JSON.stringify(v.default) + '</textarea>';
        return html;
    },
    radio_items : function(name, v){
        return app.panel.options.checkbox_items(name, v);
    },
    autosuggest_items : function(){
        return app.panel.options.checkbox_items(name, v);
    }
};

app.form = {
    save : function(target, method) {
        SUPER.save_form(target, method);
    },
    redo_undo : function(){
        SUPER.trigger_redo_undo();
    },
    update : function(target){
        if(typeof target === 'undefined'){
            var target = app.canvas.this;
        }
        const _super_elements = document.querySelector('textarea[name="_super_elements"].active');
        if(target==2){
            var elements = _super_elements.value;
        }else{
            console.log('form.update');
            var elements = app.get.element.data(target);
            elements = JSON.stringify(elements);
        }
        _super_elements.value = elements;
        if(target==2){
            app.form.save(document.querySelector('.super-actions .save'), 2);
        }else{
            app.form.redo_undo();
        }

        // Reposition Edit Element Panel when height of editing element is changed
        app.panel.reposition();
    }
};

// Define elements methods such as updating it's json data
app.elements = {
    radio : {
        name : 'Radio buttons',
        icon : 'dot-circle-o',
        tabs : ['general','advanced','icon','conditions'],
        settings : {
            group_1 : {
                name : {},
                email : {}
            },
            group_2 : {
                label : {},
                description : {},
                tooltip : {}
            },
            group_3 : {
                validation : {},
                error : {}
            },
            group_4 : {
                retrieve_method : {
                    children : {
                        csv : {
                            name : 'Upload CSV file',
                            type : 'file',
                            file_type : 'text/csv',
                            filter : {
                                show : {
                                    value : 'csv'
                                }
                            }
                        },
                        delimiter : {},
                        enclosure : {},
                        taxonomy : {},
                        post : {},
                        exclude_taxonomy : {}
                    }
                }
            }
            // @TODO...
        },
    }
};

app.element = {

    drop : {
        radio : function(){
            return 'radio_button_HTML';
        }
    },
    update : {
        data : function(editing, data, callback){
            if(typeof editing === 'undefined'){
                const editing = this.get.editing();
            }
            editing.querySelector('textarea[name="element-data"]').value = JSON.stringify(data);
            
            // Toggle Label options based on label data
            app.panel.toggle.label.all(app.panel.this, 'block');

            callback();
        },
        error : {
            text : function(nodes, callback){
                let value = nodes.this.value;
                // Get element data
                const data = app.get.element.editing.data();
                // Backward compatibility with older super forms versions
                if(typeof data.error === 'object'){
                    data.error.value = value;
                }else{
                    data.error = {
                        value : value
                    };
                }
                callback(data);
            }
        },
        label : {
            text : function(nodes, callback){
                // Get element data
                const data = app.get.element.editing.data();

                let value = nodes.this.value;
                const element = nodes.element.querySelector('.super-label');
                const panel = app.panel.this;
                if(value==''){
                    if(element){
                        element.remove();
                    }
                    app.panel.toggle.label.all(panel);
                }else{
                    app.panel.toggle.label.all(panel, 'block');
                    // Allow to enter an empty space to add the label to give some spacing if the user wants to
                    if(value===' '){
                        value = '&nbsp;';
                    }
                    // If the label already exists, just add the value as it's HTML
                    if(element){
                        element.innerHTML = value;
                    }else{
                        // If it doesn't exist yet add the wrapper HTML also
                        const node = document.createElement('div');
                        if(nodes.element.querySelector('.super-label-description')){
                            node.classList.add('super-label');
                            node.innerHTML = value;
                            nodes.element.querySelector('.super-label-description').prepend(node);
                        }else{
                            node.classList.add('super-label-description');
                            node.innerHTML = '<div class="super-label">'+value+'</div>';
                            nodes.element.insertBefore(node, nodes.element.childNodes[0]);
                        }
                        // Make sure the right styles are set after adding the new element
                        app.element.update.label.font.color(data.label.font.color, node);
                        app.element.update.label.font.family(data.label.font.family, node);
                    }
                }
                
                // Backward compatibility with older super forms versions
                if(typeof data.label === 'object'){
                    data.label.value = value;
                }else{
                    data.label = {
                        value : value
                    };
                }
                
                callback(data);
            },
            position : function(nodes, callback){
                const data = app.get.label.data();
                const label = nodes.element.querySelector('.super-label-description');
                const wrapper = nodes.element.querySelector('.super-field-wrapper-container');
                [].forEach.call(nodes.parent.querySelectorAll('label'), function(el) {
                    el.classList.remove('active');
                });
                nodes.this.classList.add('active');
                const classes = nodes.this.className.split(/\s+/);
                data.label.position = classes[0];
                const list = Array.prototype.slice.call(label.parentElement.children);
                const label_index = list.indexOf(label);
                const wrapper_index = list.indexOf(wrapper);
                const flex_size = nodes.field.querySelector('.super-flex-size > li.active').textContent;
                // Check if we need to change the Label position in the HTML
                if( (data.label.position=='top') || (data.label.position=='left') ) {
                    // Make sure the element is above the field, if not append it before the field wrapper
                    if(label_index > wrapper_index){
                        label.parentElement.appendChild(wrapper);
                    }
                }
                if( (data.label.position=='bottom') || (data.label.position=='right') ) {
                    // Make sure the element is below the field, if not append it after the field wrapper
                    if(label_index < wrapper_index){
                        label.parentElement.appendChild(label);
                    }
                }
                if(data.label.position=='left' || data.label.position=='right'){
                    if(data.label.width=='flex'){
                        nodes.element.classList.add(app.get.column_sizes[flex_size]);
                        nodes.field.querySelector('.super-flex-size').style.display = 'block';
                    }
                    if(data.label.width=='auto'){
                        label.style.width = '';
                    }
                    if(data.label.width=='fixed'){
                        app.element.update.label.set_width(label, nodes.field);
                    }
                    nodes.field.querySelector('.super-width').style.display = 'block';
                }else{
                    nodes.element.classList.remove(app.get.column_sizes[flex_size]);
                    label.style.width = '';
                    nodes.field.querySelector('.super-width').style.display = 'none';
                    nodes.field.querySelector('.super-flex-size').style.display = 'none';
                }

                // Remove all label position classes and assign the new one
                nodes.element.className = nodes.element.className.replace( /(^|\s)super-position-\S+/g , '' );
                nodes.element.classList.add('super-position-'+data.label.position);
            
                // Remove all alignment classes, and assign the new one
                nodes.element.className = nodes.element.className.replace( /(^|\s)super-align-\S+/g , '' );
                nodes.element.classList.add('super-align-'+data.label.alignment);

                // Backward compatibility with older super forms versions
                if(typeof data.label === 'object'){
                    data.label.position = data.label.position;
                }else{
                    data.label = {
                        value : data.label,
                        position : data.label.position,
                        alignment : data.alignment
                    };
                }
                // Hide/Show alignment options when position is either 'left' or 'right'
                if(data.label.position=='left' || data.label.position=='right'){
                    app.panel.toggle.label.alignment(app.panel.this, 'none');
                }else{
                    app.panel.toggle.label.alignment(app.panel.this, 'block');
                }
                callback(data);
            },
            alignment : function(nodes, callback){
                const data = app.get.label.data();
                [].forEach.call(nodes.parent.querySelectorAll('label'), function(el) {
                    el.classList.remove('active');
                });
                nodes.this.classList.add('active');
                const classes = nodes.this.className.split(/\s+/);
                data.label.alignment = classes[0];

                // Remove all label position classes and assign the new one
                nodes.element.className = nodes.element.className.replace( /(^|\s)super-position-\S+/g , '' );
                nodes.element.classList.add('super-position-'+data.label.position);
            
                // Remove all alignment classes, and assign the new one
                nodes.element.className = nodes.element.className.replace( /(^|\s)super-align-\S+/g , '' );
                nodes.element.classList.add('super-align-'+data.label.alignment);

                callback(data);
            },
            width : function(nodes, callback){
                [].forEach.call(nodes.parent.querySelectorAll('label'), function(el) {
                    el.classList.remove('active');
                });
                nodes.this.classList.add('active');
                const classes = nodes.this.className.split(/\s+/);
                const class_name = classes[0];
                const label = nodes.element.querySelector('.super-label-description');
                const flex_size = nodes.field.querySelector('.super-flex-size > li.active').textContent;
                if(class_name=='auto'){
                    label.style.width = '';
                }
                if(class_name=='fixed'){
                    app.element.update.label.set_width(label, nodes.parent);
                    nodes.parent.querySelector('.super-width-custom').style.display = 'block';
                }else{
                    nodes.parent.querySelector('.super-width-custom').style.display = 'none';
                }
                if(class_name=='flex'){
                    label.style.width = '';
                    nodes.element.classList.add(app.get.column_sizes[flex_size]);
                    nodes.field.querySelector('.super-flex-size').style.display = 'block';
                }else{
                    nodes.element.classList.remove(app.get.column_sizes[flex_size]);
                    nodes.field.querySelector('.super-flex-size').style.display = 'none';
                }
                // Get element data
                const data = app.get.element.editing.data();
                // Backward compatibility with older super forms versions
                if(typeof data.label === 'object'){
                    data.label.width = class_name;
                }else{
                    data.label = {
                        value : data.label,
                        width : class_name
                    };
                }
                callback(data);
            },
            set_width : function(label, parent){
                const width = parent.querySelector('input[name="width"]').value;
                const width_unit = parent.querySelector('input[name="width_unit"]').value;
                if(typeof width_unit === 'undefined') width_unit = 'px';
                if( (width_unit!='px') && (width_unit!='%') && (width_unit!='em') && (width_unit!='rem') ) {
                    width_unit = 'px';
                }
                if( (width!='') && (width!=0) ) {
                    label.style.width = width+width_unit;
                }else{
                    label.style.width = '';
                }
            },
            flex_size : function(nodes, callback){
                const prev_size = nodes.parent.querySelector('.active').textContent;
                [].forEach.call(nodes.parent.querySelectorAll('li'), function(el) {
                    el.classList.remove('active');
                });
                nodes.this.classList.add('active');
                const size = nodes.this.textContent;
                nodes.element.classList.remove(app.get.column_sizes[prev_size]);
                nodes.element.classList.add(app.get.column_sizes[size]);

                // Get element data
                const data = app.get.element.editing.data();

                // Backward compatibility with older super forms versions
                if(typeof data.label === 'object'){
                    data.label.flex_size = size;
                }else{
                    data.label = {
                        value : data.label,
                        flex_size : size
                    };
                }
                callback(data);
            },
            fixed_size : function(nodes, callback){
                const editing = app.get.editing();
                const label = editing.querySelector('.super-label-description');
                const size = nodes.parent.querySelector('input[name="width"]').value;
                const unit = nodes.parent.querySelector('input[name="width_unit"]').value;

                // Get element data
                const data = app.get.element.editing.data();

                // Backward compatibility with older super forms versions
                if(typeof data.label === 'object'){
                    data.label.size = size;
                    data.label.unit = unit;
                }else{
                    data.label = {
                        value : data.label,
                        size: size,
                        unit: unit
                    };
                }
                app.element.update.label.set_width(label, nodes.parent);
                callback(data);
            },
            padding : function(nodes, callback){
                // Get element data
                const data = app.get.element.editing.data();
                // Backward compatibility with older super forms versions
                if(typeof data.label === 'object'){
                    if(typeof data.label.padding !== 'object'){
                        data.label.padding = {};
                    }

                    if(typeof data.label.padding.unit === 'undefined'){
                        data.label.padding.unit = 'px';
                    }
                    if(nodes.parent.parentNode.classList.contains('super-padding-unlinked')){
                        data.label.padding[nodes.this.name] = nodes.this.value;
                    }else{
                        // Update the input values
                        [].forEach.call(nodes.parent.parentNode.querySelectorAll('input'), function(el) {
                            el.value = nodes.this.value;
                        });

                        // Update the label data
                        data.label.padding = {
                            top : nodes.this.value,
                            right : nodes.this.value,
                            bottom : nodes.this.value,
                            left : nodes.this.value,
                            unit : data.label.padding.unit
                        }
                    }
                }else{
                    data.label = {
                        value : data.label
                    }
                    if(nodes.parent.parentNode.classList.contains('super-padding-unlinked')){
                        if(typeof data.label.padding !== 'object'){
                            data.label.padding = {};
                        }

                        data.label.padding.top = nodes.this.value;
                    }else{
                        // Update the input values
                        [].forEach.call(nodes.parent.parentNode.querySelectorAll('input'), function(el) {
                            el.value = nodes.this.value;
                        });

                        // Update the label data
                        data.label.padding = {
                            top : nodes.this.value,
                            right : nodes.this.value,
                            bottom : nodes.this.value,
                            left : nodes.this.value,
                            unit : 'px'
                        }
                    }
                }

                // If all the paddings are empty we delete the padding key from the object
                if(data.label.padding.top=='' && data.label.padding.right=='' && data.label.padding.bottom=='' && data.label.padding.left==''){
                    delete data.label.padding;
                }

                app.element.update.label.set_padding(app.get.editing().querySelector('.super-label-description'), data.label.padding);
                callback(data);
            },
            padding_unit : function(nodes, callback){
                [].forEach.call(nodes.parent.querySelectorAll('li'), function(el) {
                    el.classList.remove('active');
                });
                nodes.this.classList.add('active');

                console.log('test1');
                // Get element data
                const data = app.get.element.editing.data();
                // Backward compatibility with older super forms versions
                if(typeof data.label === 'object'){
                    console.log('test2');
                    if(typeof data.label.padding !== 'object'){
                        console.log('test3');
                        data.label.padding = {
                            unit : nodes.this.innerText.toLowerCase()
                        };
                    }else{
                        console.log('test4');
                        data.label.padding.unit = nodes.this.innerText.toLowerCase();
                    }
                }else{
                    console.log('test3');
                    data.label = {
                        value : data.label,
                        padding : {
                            unit : nodes.this.innerText.toLowerCase()
                        }
                    }
                }
                console.log(data);
                app.element.update.label.set_padding(app.get.editing().querySelector('.super-label-description'), data.label.padding);
                callback(data);
            },
            set_padding : function(wrapper, padding){
                // If all the paddings are empty we remove the padding style
                if(!padding){
                    wrapper.style.padding = null;
                }else{
                    if(typeof padding.unit === 'undefined'){
                        padding.unit = 'px';
                    }
                    const unit = padding.unit;
                    wrapper.style.padding = padding.top+unit+' '+padding.right+unit+' '+padding.bottom+unit+' '+padding.left+unit;
                }
            }, 
            font : {
                color : function(color, element){
                    if(element) element.style.color = color;
                },
                family : function(name, type){
                    if(typeof name !== 'undefined'){
                        const editing = app.get.editing();
                        const element = editing.querySelector('.super-label-description > .super-label');
                        if(element){
                            element.style.fontFamily = name;
                        }
                        const object = {
                            label : {
                                font : {
                                    family : name
                                }
                            }
                        };
                        let data = app.get.element.editing.data();
                        data = app.func.merge_objects(data, object);
                        app.element.update.data(editing, data, function(){
                            app.form.update();
                        });
                    }
                },
                size : function(nodes, callback){
                    const editing = app.get.editing();
                    const element = editing.querySelector('.super-label-description > .super-label');
                    // Only update if Field Label exists
                    if(element){
                        // Update both slider or number value accordingly
                        const slider = nodes.parent.querySelector('input[type="range"]');
                        const number = nodes.parent.querySelector('input[type="number"]');
                        if(slider==nodes.this){
                            number.value = nodes.this.value;
                        }
                        if(number==nodes.this){
                            slider.value = nodes.this.value;
                        }

                        if(nodes.this.tagName=='SPAN'){
                            const prev_unit = nodes.parent.querySelector('span.active').innerText.toLowerCase();
                            nodes.parent.querySelector('span.active').classList.remove('active');
                            nodes.this.classList.add('active');

                            // If switch to EM or REM change step of slider, and minimum and maximum possible values
                            if(nodes.this.innerText.toLowerCase()=='px'){
                                slider.max = 50;
                                number.max = 50;
                                slider.min = 1;
                                number.min = 1;
                                slider.step = 1;
                                number.step = 1;
                                // Multiply the slider value by 16 to get an accurate PX representation for EM / REM values
                                if(prev_unit!='px'){
                                    number.value = (slider.value*16).toFixed(0);
                                    slider.value = number.value;
                                }
                            }else{
                                slider.min = 0.1;
                                number.min = 0.1;
                                slider.step = 0.1;
                                number.step = 0.1;     
                                // Devide the slider value by 5 to get an accurate EM / REM representation for PX values
                                if(prev_unit=='px'){
                                    number.value = (slider.value/16).toFixed(1);
                                    slider.value = number.value;
                                }
                                slider.max = 10;
                                number.max = 10;
                            }
                        }
                        // Get the font size and unit
                        const size = slider.value; 
                        const unit = nodes.parent.querySelector('span.active').innerText.toLowerCase();

                        // Update font size
                        element.style.fontSize = size+unit;
                        const object = {
                            label : {
                                font : {
                                    size : size,
                                    unit : unit
                                }
                            }
                        };
                        let data = app.get.element.editing.data();
                        data = app.func.merge_objects(data, object);
                        app.element.update.data(editing, data, function(){
                            app.form.update();
                        });
                        callback(data);
                    }
                }
            }
        },
        description : {
            text : function(nodes, callback){
                // Get element data
                const data = app.get.element.editing.data();

                let value = nodes.this.value;
                const element = nodes.element.querySelector('.super-description');
                if(value==''){
                    element.remove();
                    data.description = null;
                }else{
                    // Allow to enter an empty space to add the label to give some spacing if the user wants to
                    if(value===' '){
                        value = '&nbsp;';
                    }
                    // If the label already exists, just add the value as it's HTML
                    if(element){
                        element.innerHTML = value;
                    }else{
                        // If it doesn't exist yet add the wrapper HTML also
                        const node = document.createElement('div');
                        if(nodes.element.querySelector('.super-label-description')){                               
                            node.classList.add('super-description');
                            node.innerHTML = value;
                            nodes.element.querySelector('.super-label-description').appendChild(node);
                        }else{
                            node.classList.add('super-label-description');
                            node.innerHTML = '<div class="super-description">'+value+'</div>';
                            nodes.element.insertBefore(node, nodes.element.childNodes[0]);
                        }
                        // Make sure the right styles are set after adding the new element
                        app.element.update.description.font.color(data.description.font.color, node);
                        app.element.update.description.font.family(data.description.font.family, node);
                    }

                    // Backward compatibility with older super forms versions
                    if(typeof data.description === 'object'){
                        data.description.value = value;
                    }else{
                        data.description = {
                            value : value
                        };
                    }
                }
                callback(data);
            },
            font : {
                color : function(color, element){
                    if(element) element.style.color = color;
                },
                family : function(name, type){
                    if(typeof name !== 'undefined'){
                        const editing = app.get.editing();
                        const element = editing.querySelector('.super-label-description > .super-description');
                        if(element){
                            element.style.fontFamily = name;
                        }
                        const object = {
                            description : {
                                font : {
                                    family : name
                                }
                            }
                        };
                        let data = app.get.element.editing.data();
                        data = app.func.merge_objects(data, object);
                        app.element.update.data(editing, data, function(){
                            app.form.update();
                        });
                    }
                }
            }
        },
    }
};

// Close active dropdowns
document.addEventListener('click', (evt) => {
    // Only if there is a dropdown currently opened
    const dropdown = document.querySelector('.super-dropdown-search.active');
    if(dropdown){
        const inside = evt.target.closest('.super-dropdown-search > ul');
        if(!inside){
            // This is a click outside.
            dropdown.classList.remove('active');
            // Reset search value
            dropdown.querySelector('.search input').value = '';
            // Show all fonts
            const fonts = dropdown.querySelectorAll('.item > li');
            [].forEach.call(fonts, function(el) {
                el.style.display = 'block';
            }); 
        }
    }
});

// Iterate over all events, and listen to any event being triggered
Object.keys(app.panel.events).forEach(function(event) {
    const elements = app.panel.events[event].join(", ");
    app.delegate(document, event, elements, function(e, target){
        
        const nodes = app.get.nodes(target);

        console.log(nodes);

        // If dropdown searching on 'keyup'
        if(event=='keyup' && nodes.this.closest('.super-dropdown-search') && nodes.parent.classList.contains('search')){
            const fonts = nodes.this.closest('.super-dropdown-search').querySelectorAll('.item > li');
            const search = nodes.this.value;
            if(search!=''){
                const fonts_to_show = [];
                const fonts_to_hide = [];
                // Filter fonts based on search input and hide those that do not match the string
                [].forEach.call(fonts, function(el) {
                    if(el.innerText.toLowerCase().indexOf(search.toLowerCase())!=-1){
                        fonts_to_show.push(el);
                    }else{
                        fonts_to_hide.push(el);
                    }
                });
                [].forEach.call(fonts_to_show, function(el) {
                    el.style.display = 'block';
                });
                [].forEach.call(fonts_to_hide, function(el) {
                    el.style.display = 'none';
                });
            }else{
                // Show all fonts
                [].forEach.call(fonts, function(el) {
                    el.style.display = 'block';
                });
            }
            return false;
        }

        // Open dropdown search element
        if(nodes.parent.parentNode.classList.contains('super-dropdown-search')){
            // First close any other active dropdowns
            [].forEach.call(app.panel.this.querySelectorAll('.super-dropdown-search.active'), function(el) {
                el.classList.remove('active');
            });
            nodes.parent.parentNode.classList.toggle('active');
            const list = nodes.parent.parentNode.querySelector('.items');
            const targetLi = nodes.parent.parentNode.querySelector('.item .active');
            if(targetLi) {
                list.scrollTop = (targetLi.offsetTop - 44);
            }
            // Focus search field
            nodes.parent.parentNode.querySelector('.search > input').focus();
            return false;
        }

        // Once clicked on a dropdown search item
        if(nodes.this.closest('.super-dropdown-search')){

            // Get the selected option value
            const value = nodes.this.dataset.value;
            const dropdown = nodes.this.closest('.super-dropdown-search');
         
            // Make sure google fonts are enqueued
            if(dropdown.classList.contains('super-font-family')){
                const type = nodes.this.closest('.group').dataset.type;
                // Load the font stylesheet from google API
                app.fonts.enqueue(value, type, function(){
                    // Update the label font family
                    if(nodes.field.classList.contains('super-label')){
                        app.element.update.label.font.family(value, type);
                    }
                    // Update the description font family
                    if(nodes.field.classList.contains('super-description')){
                        app.element.update.description.font.family(value, type);
                    }
                });
            }

            // Update the placeholder text
            const placeholder = dropdown.querySelector('.placeholder');
            placeholder.innerText = nodes.this.innerText;
            // Remove classes of other items
            [].forEach.call(dropdown.querySelectorAll('.item > li'), function(el) {
                el.classList.remove('active');
            });
            // Make selected item active
            nodes.this.classList.add('active');
            // Close the dropdown by removing active class
            dropdown.classList.remove('active');

            // Get option merge json
            let json = dropdown.querySelector('.super-option-merge').value;
            // Replace the value tag with the selected value
            json = json.replace('{value}', value);
            // Convert json string to object
            json = JSON.parse(json);

            // Retrieve current editing element
            const editing = app.get.editing();
            
            // Find the element we have to update styles for corresponding to the option that was changed
            const element = editing.querySelector(json.query_selector);
            if(element){
                // Check if value was 'Default', if so perhaps we wish to unset the style completely
                if(value.toLowerCase()=='default'){
                    // Now update the style of the element
                    if(json.style_update=='fontFamily' || json.style_update=='textTransform' || json.style_update=='fontStyle' || json.style_update=='textDecoration' ){
                        // If selected Default option, remove the style
                        element.style[json.style_update] = null;
                    }
                }else{
                    // Otherwise add the style
                    element.style[json.style_update] = value;
                }
            }

            // Update the element data
            let data = app.get.element.editing.data();
            // Merge the 2 objects
            data = app.func.merge_objects(data, json.object);
            app.element.update.data(editing, data, function(){
                app.form.update();
            });

            // Reset search value
            dropdown.querySelector('.search input').value = '';
            // Show all items
            const items = dropdown.querySelectorAll('.item > li');
            [].forEach.call(items, function(el) {
                el.style.display = 'block';
            });
            return false;

        }

        // Toggle Font settings
        if(nodes.this.classList.contains('super-font-toggle')){
            nodes.this.classList.toggle('active');
            nodes.parent.querySelector('.super-font').classList.toggle('active');
            nodes.parent.querySelector('.super-layout-toggle').classList.remove('active');
            nodes.parent.querySelector('.super-layout').classList.remove('active');
            return false;
        }
        // Toggle Layout settings
        if(nodes.this.classList.contains('super-layout-toggle')){
            nodes.this.classList.toggle('active');
            nodes.parent.querySelector('.super-layout').classList.toggle('active');
            nodes.parent.querySelector('.super-font-toggle').classList.remove('active');
            nodes.parent.querySelector('.super-font').classList.remove('active');
            return false;
        }

        // Toggle padding linking
        if(nodes.this.classList.contains('super-link-padding')){
            nodes.parent.parentNode.classList.toggle('super-padding-unlinked');
            return false;
        }

        // Update label padding
        if(nodes.parent.parentNode.classList.contains('super-padding')){
            app.element.update.label.padding(nodes, function(data){
                // Update element data
                app.element.update.data(app.get.editing(), data, function(){
                    // Update form json
                    app.form.update();
                });
            });
            return false;
        }

        // Update label position, alignment, width
        const className = nodes.parent.className;
        console.log(className);
        if( className=='super-position' ||
            className=='super-alignment' ||
            className=='super-width'){
            app.element.update.label[className.replace('super-', '')](nodes, function(data){
                // Update element data
                app.element.update.data(app.get.editing(), data, function(){
                    // Update form json
                    app.form.update();
                });
            });
            return false;
        }

        // Update label font size
        if(className.indexOf('super-range-slider') != -1){
            // Get option merge json
            let json = nodes.parent.parentNode.querySelector('.super-option-merge').value;
            // Convert json string to object
            json = JSON.parse(json);
            // Retrieve current editing element
            const editing = app.get.editing();
            // Find the element we have to update styles for corresponding to the option that was changed
            const element = editing.querySelector(json.query_selector);
            // Only update if Field Label exists
            if(element){
                // Update both slider or number value accordingly
                const slider = nodes.parent.querySelector('input[type="range"]');
                const number = nodes.parent.querySelector('input[type="number"]');
                if(slider==nodes.this){
                    number.value = nodes.this.value;
                }
                if(number==nodes.this){
                    slider.value = nodes.this.value;
                }

                if(nodes.this.tagName=='SPAN'){
                    const prev_unit = nodes.parent.querySelector('span.active').innerText.toLowerCase();
                    nodes.parent.querySelector('span.active').classList.remove('active');
                    nodes.this.classList.add('active');
                    let px_min = 1,
                        px_max = 50,
                        px_step = 1,
                        min = 0.1,
                        max = 10,
                        step = 0.1;
                    if(nodes.parent.parentNode.classList.contains('super-font-line-height')){
                        px_min = 1;
                        px_max = 100;
                        px_step = 1;
                        min = 0.1;
                        max = 10;
                        step = 0.1;
                    }
                    if(nodes.parent.parentNode.classList.contains('super-font-letter-spacing')){
                        px_min = -50;
                        px_max = 50;
                        px_step = 1;
                        min = -5;
                        max = 10;
                        step = 0.1;
                    }
                    // If switch to EM or REM change step of slider, and minimum and maximum possible values
                    if(nodes.this.innerText.toLowerCase()=='px'){
                        slider.max = px_max;
                        number.max = px_max;
                        slider.min = px_min;
                        number.min = px_min;
                        slider.step = px_step;
                        number.step = px_step;
                        // Multiply the slider value by 16 to get an accurate PX representation for EM / REM values
                        if(prev_unit!='px'){
                            number.value = (slider.value*16).toFixed(0);
                            slider.value = number.value;
                        }
                    }else{
                        slider.min = min;
                        number.min = min;
                        slider.step = step;
                        number.step = step;     
                        // Devide the slider value by 5 to get an accurate EM / REM representation for PX values
                        if(prev_unit=='px'){
                            number.value = (slider.value/16).toFixed(1);
                            slider.value = number.value;
                        }
                        slider.max = max;
                        number.max = max;
                    }
                }
                // Get the font size and unit
                const size = slider.value; 
                const unit = nodes.parent.querySelector('span.active').innerText.toLowerCase();
                // Convert json back to string
                json = JSON.stringify(json);
                // Replace the value tag with the selected value
                json = json.replace('{value}', size).replace('{unit}', unit).replace('{lunit}', unit).replace('{lsunit}', unit);
                // Convert json string to object
                json = JSON.parse(json);
                // Now update the style of the element
                element.style[json.style_update] = size+unit;
                // Update the element data
                let data = app.get.element.editing.data();
                // Merge the 2 objects
                data = app.func.merge_objects(data, json.object);
                app.element.update.data(editing, data, function(){
                    app.form.update();
                });
            }
            return false;
        }

        // Update label padding unit 
        if(className.indexOf('super-padding-unit') != -1){
            app.element.update.label.padding_unit(nodes, function(data){
                // Update element data
                app.element.update.data(app.get.editing(), data, function(){
                    // Update form json
                    app.form.update();
                });
            });
            return false;
        }

        // Update flex size
        if(className.indexOf('super-flex-size') != -1){
            app.element.update.label.flex_size(nodes, function(data){
                // Update element data
                app.element.update.data(app.get.editing(), data, function(){
                    // Update form json
                    app.form.update();
                });
            });
            return false;
        }

        // Update fixed size
        if(className.indexOf('super-width-custom') != -1){
            app.element.update.label.fixed_size(nodes, function(data){
                // Update element data
                app.element.update.data(app.get.editing(), data, function(){
                    // Update form json
                    app.form.update();
                });
            });
            return false;
        }

        // Update field label for currently editing element
        if(nodes.field.classList.contains('super-label')){
            app.element.update.label.text(nodes, function(data){
                // Update element data
                app.element.update.data(app.get.editing(), data, function(){
                    // Update form json
                    app.form.update();
                });
            });
            return false;
        }
        // Update field description for currently editing element
        if(nodes.field.classList.contains('super-description')){
            app.element.update.description.text(nodes, function(data){
                // Update element data
                app.element.update.data(app.get.editing(), data, function(){
                    // Update form json
                    app.form.update();
                });
            });
            return false;
        }
        // Update field error message for currently editing element
        if(nodes.field.classList.contains('super-error')){
            app.element.update.error.text(nodes, function(data){
                // Update element data
                app.element.update.data(app.get.editing(), data, function(){
                    // Update form json
                    app.form.update();
                });
            });
            return false;
        }

    });

});

// Open up context menu
/*
if (document.addEventListener) {
    document.addEventListener('contextmenu', function(e) {
        app.context_menu.open(); //here you draw your own menu
        e.preventDefault();
    }, false);
} else {
    document.attachEvent('oncontextmenu', function() {
        app.context_menu.open();
        window.event.returnValue = false;
    });
}
*/

// Open up edit panel when element is clicked or edit icon is clicked
app.delegate(document, 'click', '.super-highlighted, .super-element-actions .edit', function(event, target){
    app.panel.open(target, function(){
        app.panel.this.classList.add('super-active');
    });
});


// Iterate over all elements, and append them to the "Form Elements" panel
/*
let html = '';
console.log(html);
Object.keys(app.elements).forEach(function(element) {
    const value = app.elements[element];
    console.log(element, value.name);
    html += '<div class="super-element draggable-element super-shortcode-'+element+'" data-elementtitle="'+value.name+'" data-shortcode="'+element+'" data-droppingallowed="0">';
    html += '<i class="fa fa-'+value.icon+'"></i>';
    html += value.name;
    html += '</div>';
});
console.log(html);
document.querySelector('.super-elements .super-element.super-form-elements .super-elements-container').innerHTML = html;
//<div class="super-element super-shortcode-email" data-elementtitle="Email Address" data-shortcode="email" data-group="form_elements"><i class="fa fa-envelope-o"></i>Email Address</div>
//document.querySelector('.super-elements .super-element.super-form-elements .super-elements-container').innerHTML = 'test1';
*/




/*
// Update json for element after On updating label font color
function 
{
    "name": "option",
    "label": "test",
    "width_unit": "px",
    "label_position": "left:center:flex::px:1\/4",

    "styles" : [{
        "label" : [{
            "font" : [{
                "color" : "",
                "size" : "",
                "weight" : "",
                "transform" : "",
                "style" : "",
                "decoration" : "",
                "family" : "",
                "line-height" : "",
                "letter-spacing" : "",
            }]
        }]
    }],

    "label_styles" : [{
        "font" : [{

        }]
    }],
    "email": "Option:",
    "tooltip": "123",
    "radio_items": [{
        "checked": "",
        "image": "",
        "label": "First choice1",
        "value": "first_choice"
    }, {
        "checked": "",
        "image": "",
        "label": "Second choice2",
        "value": "second_choice"
    }],
    "display": "horizontal"
}
*/

(function($) { // Hide scope, no $ conflict

    $(document).ready(function(){

        const $doc = $(document);

        $doc.on('click, mousedown', '.super-preview-elements .super-element:not(.super-column) > .super-element-inner', function(e){
            e.preventDefault();
            e.stopPropagation();
        });



        app.init.generate_first_column_classes(0, 0);

        $doc.on('click', '.super-preview-elements .super-element-actions .move', function(){
            // only move if there are at least 2 elements
            if($('.super-preview-elements > .super-element').length>1){
                var $moving_element = $(this).parents('.super-element:eq(0)');
                if(!$moving_element.hasClass('super-moving')){
                    $('.super-preview-elements .super-moving').removeClass('super-moving');
                    $moving_element.addClass('super-moving');
                    $('.super-preview-elements').addClass('super-moving-elements');
                }else{
                    $('.super-preview-elements .super-moving').removeClass('super-moving');
                    $('.super-preview-elements').removeClass('super-moving-elements');
                }
            }
        });
        $doc.on('click', '.super-preview-elements .super-drop-before, .super-preview-elements .super-drop-inside, .super-preview-elements .super-drop-after', function(){
            var $element = $(this).parent('.super-element:eq(0)');
            var $moving = $('.super-preview-elements .super-element.super-moving');
            if($(this).hasClass('super-drop-before')){
                $element.before($moving);
            }
            if($(this).hasClass('super-drop-inside')){
                $element.children('.super-element-inner').append($moving);
            }
            if($(this).hasClass('super-drop-after')){
                $element.after($moving);
            }
            $moving.removeClass('super-moving');
            $('.super-preview-elements').removeClass('super-moving-elements');
            $('.super-preview-elements .super-drag-drop-here').removeClass('super-drag-drop-here');
            $('.super-preview-elements').find('.super-drop-before, .super-drop-inside, .super-drop-after').remove();
        });

        $doc.on('click','.super-element > .super-element-header > .resize > span',function(){
            var $editing = $(this).parents('.super-element:eq(0)');
            var $data = $editing.children('textarea[name="element-data"]').val();
            var $data = JSON.parse($data);
            var $size = $data.size;
            if( typeof $editing.attr('data-size') !== 'undefined' ){
                var $size = $editing.attr('data-size');
            }
            var $sizes = {
                '1/1':'super_one_full',
                '4/5':'super_four_fifth',
                '3/4':'super_three_fourth',
                '2/3':'super_two_third',
                '3/5':'super_three_fifth',
                '1/2':'super_one_half',
                '2/5':'super_two_fifth',
                '1/3':'super_one_third',
                '1/4':'super_one_fourth',
                '1/5':'super_one_fifth'};
            var $keys = ['1/1','4/5','3/4','2/3','3/5','1/2','2/5','1/3','1/4','1/5'];
            var $start = $size;
            var $next = $keys[($.inArray($start, $keys) + 1) % $keys.length];
            var $prev = $keys[($.inArray($start, $keys) - 1 + $keys.length) % $keys.length];
            $editing.css('width','');
            delete $data.width;
            $editing.attr('data-width','');
            if($(this).hasClass('smaller')){
                if($size=='1/5'){
                    return false;
                }
                $editing.attr('data-size',$next);
                $editing.removeClass($sizes[$start]).addClass($sizes[$next]);
                $editing.children('.super-element-header').find('.resize > .current').html($next);
                $data.size = $next;
            }
            if($(this).hasClass('bigger')){
                if($size=='1/1'){
                    return false;
                }
                $editing.attr('data-size',$prev);
                $editing.removeClass($sizes[$start]).addClass($sizes[$prev]);
                $editing.children('.super-element-header').find('.resize > .current').html($prev);
                $data.size = $prev;
            }
            $editing.children('textarea[name="element-data"]').val(JSON.stringify($data));
            app.init.drag_and_drop();

            app.form.update(target);
            app.form.update();
            app.init.generate_first_column_classes(0, 0);
        });

        $doc.on('click', '.super-custom-width .super-size > li', function(){
            var $this = $(this);
            var $parent = $this.parent();
            var $prev_size = $parent.children('.active').text();
            $parent.children().removeClass('active');
            $this.addClass('active');
            var $editing = app.get.editing();
            $this.parents('.super-custom-width:eq(0)').find('input[name="width"]').val('');
            var $size = $this.text();
            var $sizes = {
                '1/1':'super_one_full',
                '4/5':'super_four_fifth',
                '3/4':'super_three_fourth',
                '2/3':'super_two_third',
                '3/5':'super_three_fifth',
                '1/2':'super_one_half',
                '2/5':'super_two_fifth',
                '1/3':'super_one_third',
                '1/4':'super_one_fourth',
                '1/5':'super_one_fifth'};
            $editing.attr('data-size', $size);

            $editing.removeClass($sizes[$prev_size]).addClass($sizes[$size]).css('width','');
            $editing.children('.super-element-header').find('.resize > .current').html($size);

            $editing.children('textarea[name="element-data"]').val(SUPER.get_current_editing_fields());
            app.form.update();

            // Reposition Edit Element Panel when height of editing element is changed
            app.panel.reposition();

        });

        $doc.on('change click keydown keyup blur', '.super-custom-width input, .super-custom-height input, .super-margins input, .super-paddings input, .super-margins > label, .super-paddings > label', function(){
            var $editing = app.get.editing();
            var $inner = $editing.children('.super-element-inner');
            var $tag = $editing.attr('data-shortcode-tag');
            var $parent = $(this).parent();
            var $parents = $(this).parents('.super-padding-margin:eq(0)');

            var $order = ['top', 'right', 'bottom', 'left'];
            var $margins = []
            var $margins_css = [];
            var $paddings_css = [];
            var $paddings = [];
            var $radius = [];
            var $radius_css = [];
            $.each($order, function($k, $v){
                var $value = $parents.find('input[name="'+$v+'_margin"]').val()
                if($value=='') $value = '0';
                if( ($value.toLowerCase().indexOf('px') != -1) && ($value.indexOf('%') != -1) ) {
                    $margins[$k] = $value.replace('px','').trim();
                    $margins_css[$k] = $margins[$k]+'px';
                }else{
                    if( $value.indexOf('%') != -1 ) {
                        $margins[$k] = $value.replace('%','').trim()+'%';
                        $margins_css[$k] = $margins[$k];
                    }else{
                        $margins[$k] = $value.trim();
                        $margins_css[$k] = $margins[$k]+'px';
                    }
                }

                var $value = $parents.find('input[name="'+$v+'_padding"]').val()
                if($value=='') $value = '0';
                if( ($value.toLowerCase().indexOf('px') != -1) && ($value.indexOf('%') != -1) ) {
                    $paddings[$k] = $value.replace('px','').trim();
                    $paddings_css[$k] = $paddings[$k]+'px';
                }else{
                    if( $value.indexOf('%') != -1 ) {
                        $paddings[$k] = $value.replace('%','').trim()+'%';
                        $paddings_css[$k] = $paddings[$k];
                    }else{
                        $paddings[$k] = $value.trim();
                        $paddings_css[$k] = $paddings[$k]+'px';
                    }
                }

                if($v=='top'){
                    var $name = 'top_left';
                }else if($v=='right'){
                    var $name = 'top_right';
                }else if($v=='bottom'){
                    var $name = 'bottom_right';
                }else if($v=='left'){
                    var $name = 'bottom_left';
                }
                var $value = $parents.find('input[name="'+$name+'_radius"]').val()
                if($value=='') $value = '0';
                if( ($value.toLowerCase().indexOf('px') != -1) && ($value.indexOf('%') != -1) ) {
                    $radius[$k] = $value.replace('px','').trim();
                    $radius_css[$k] = $radius[$k]+'px';
                }else{
                    if( $value.indexOf('%') != -1 ) {
                        $radius[$k] = $value.replace('%','').trim()+'%';;
                        $radius_css[$k] = $radius[$k];
                    }else{
                        $radius[$k] = $value.trim();
                        $radius_css[$k] = $radius[$k]+'px';
                    }
                }

            });

            var $final_radius_css = '';
            var $identical = !!$radius_css.reduce(function(a, b){ 
                return (a === b) ? a : NaN; 
            });
            if($identical){
                if($radius_css[0]!=0){
                    $final_radius_css += '-webkit-border-radius: '+$radius_css[0]+';';
                    $final_radius_css += '-moz-border-radius: '+$radius_css[0]+';';
                    $final_radius_css += 'border-radius: '+$radius_css[0]+';';
                }
            }else{
                $final_radius_css += '-webkit-border-top-left-radius: '+$radius_css[0]+';';
                $final_radius_css += '-moz-border-radius-topleft: '+$radius_css[0]+';';
                $final_radius_css += 'border-top-left-radius: '+$radius_css[0]+';';

                $final_radius_css += '-webkit-border-top-right-radius: '+$radius_css[1]+';';
                $final_radius_css += '-moz-border-radius-topright: '+$radius_css[1]+';';
                $final_radius_css += 'border-top-right-radius: '+$radius_css[1]+';';
                
                $final_radius_css += '-webkit-border-bottom-right-radius: '+$radius_css[2]+';';
                $final_radius_css += '-moz-border-radius-bottomright: '+$radius_css[2]+';';
                $final_radius_css += 'border-bottom-right-radius: '+$radius_css[2]+';';

                $final_radius_css += '-webkit-border-bottom-left-radius: '+$radius_css[3]+';';
                $final_radius_css += '-moz-border-radius-bottomleft: '+$radius_css[3]+';';
                $final_radius_css += 'border-bottom-left-radius: '+$radius_css[3]+';';
            }
            var $margins = $margins.join(" ");
            var $margins_css = $margins_css.join(" ");
            var $paddings = $paddings.join(" ");
            var $paddings_css = $paddings_css.join(" ");
            var $radius = $radius.join(" ");
            var $height = $parents.find('input[name="height"]').val();
            var $width = $parents.find('input[name="width"]').val();
            var $width_unit = $parents.find('input[name="width_unit"]').val();
            if( $(this).prop("tagName")=='LABEL' ) {
                if( $parent.hasClass('active') ) {
                    // Disable custom margin
                    if( $parent.hasClass('super-margins') ) {
                        if( $tag=='column' ) {
                            $editing.removeClass('super-custom-margin');
                            $editing.attr('data-custom-margin', '');
                            $editing.css('margin', '');
                            $parents.find('input[name="margin"]').val('');
                        }
                    }
                    // Disable custom padding
                    if( $parent.hasClass('super-paddings') ) {
                        if( $tag=='column' ) {
                            $editing.removeClass('super-custom-padding');
                            $editing.attr('data-custom-padding', '');
                            $inner.css('padding', '');
                            $parents.find('input[name="padding"]').val('');
                        }
                    }
                }else{
                    // Enable custom margin
                    if( $parent.hasClass('super-margins') ) {
                        if( $tag=='column' ) {
                            $editing.addClass('super-custom-margin');
                            $editing.attr('data-custom-margin', $margins);
                            $editing.css('margin', $margins_css);
                            $parents.find('input[name="margin"]').val($margins);
                        }
                    }
                    // Enable custom padding
                    if( $parent.hasClass('super-paddings') ) {
                        if( $tag=='column' ) {
                            $editing.addClass('super-custom-padding');
                            $editing.attr('data-custom-padding', $paddings);
                            $inner.css('padding', $paddings_css);
                            $parents.find('input[name="padding"]').val($paddings);
                        }
                    }
                    
                }
                $parent.toggleClass('active');
            }else{
                if( $tag=='column' ) {
                    // Enable custom margin
                    if( $parent.hasClass('super-margins') ) {
                        $editing.addClass('super-custom-margin');
                        $editing.attr('data-custom-margin', $margins);
                        $editing.css('margin', $margins_css);
                        $parents.find('input[name="margin"]').val($margins);
                    }
                    // Enable custom padding
                    if( $parent.hasClass('super-paddings') ) {
                        $editing.addClass('super-custom-padding');
                        $editing.attr('data-custom-padding', $paddings);
                        $inner.css('padding', $paddings_css);
                        $parents.find('input[name="padding"]').val($paddings);
                    }
                    // Add border radius if not empty or zero
                    if($final_radius_css!=''){
                        var $radius_css = $final_radius_css.split(';');
                        $.each($radius_css, function($k, $v){
                            if($v!=''){
                                var $css = $v.split(':');
                                $editing.css($css[0], $css[1]);
                            }
                        });
                        $parents.find('input[name="radius"]').val($radius);
                    }
                }

                if( ($width!='') && ($width!=0) ) {
                    if( $tag=='column' ) {
                        $editing.css('width', $width+$width_unit);
                    }
                }else{
                    if( $tag=='column' ) {
                        $editing.css('width', '');
                    }           
                }
                if( ($height!='') && ($height!=0) ) {
                    if( $tag=='column' ) {
                        $editing.css('height', $height);
                    }
                }else{
                    if( $tag=='column' ) {
                        $editing.css('height', '');
                    }
                }
            }

            if( ($parent.hasClass('super-margins')) || ($parent.hasClass('super-paddings')) || ($parent.hasClass('super-custom-width')) || ($parent.hasClass('super-custom-height')) ) {
                if(!$parents.children('.super-margins').hasClass('active')) $margins = '';
                if(!$parents.children('.super-paddings').hasClass('active')) $paddings = '';
            }

            $editing.children('textarea[name="element-data"]').val(SUPER.get_current_editing_fields());
            app.form.update();

            // Reposition Edit Element Panel when height of editing element is changed
            app.panel.reposition();

        });

        /*$doc.on('change keydown keyup blur click', '.super-edit-element-panel .element-field, .super-edit-element-panel input, .super-edit-element-panel select', function(e){
            if( !$('.super-edit-element-panel.super-active').hasClass('super-active') ) {
                e.preventDefault();
                e.stopPropagation();
                return false;
            }
            var $this = $(this);
            var $name = $this.attr('name');
            var $parent = $this.parent();
            var $value = $this.val();
            var $editing = app.get.editing();
            var $tag = $editing.attr('data-shortcode-tag');
            
            if($this.hasClass('element-field')){

                if( ($tag=='checkbox') || ($tag=='radio') ) {
                    if($name=='display'){
                        if($value=='vertical'){
                            $editing.find('.super-shortcode').removeClass('display-horizontal').addClass('display-vertical');
                        }else{
                            $editing.find('.super-shortcode').removeClass('display-vertical').addClass('display-horizontal');
                        }
                    }
                }
                
                // Update background styles
                if($tag=='column'){
                    if($name=='bg_size'){
                        if($value=='custom'){
                            $this.next().show();
                            $value = $this.next().val();
                        }else{
                            $this.next().hide();
                        }
                        $editing.css('background-size', $value);
                    }
                    if($name=='bg_size_custom'){
                        if( ($value.toLowerCase().indexOf('px') != -1) && ($value.indexOf('%') != -1) ) {
                            $value = $value.replace('px','').trim()+'px';
                        }else{
                            if( $value.indexOf('%') != -1 ) {
                                $value = $value.replace('%','').trim()+'%';
                            }else{
                                $value = $value.replace('px','').trim()+'px';
                            }
                        }
                        $editing.css('background-size', $value);
                    }
                    if($name=='bg_repeat'){
                        $editing.css('background-repeat', $value);
                    }
                    if($name=='bg_position'){
                        $editing.css('background-position', $value);
                    }
                }

                // Add, update or delete field label
                if($name=='label'){
                    var $element = $editing.find('.super-label');
                    if($value==''){
                        $element.remove();
                    }else{
                        // Allow to enter an empty space to add the label to give some spacing if the user wants to
                        if($value===' '){
                            $value = '&nbsp;';
                        }
                        // If the label already exists, just add the value as it's HTML
                        if($element.length){
                            $element.html($value);
                        }else{
                            // If it doesn't exist yet add the wrapper HTML also
                            if($editing.find('.super-label-description').length){
                                $('<div class="super-label">'+$value+'</div>').prependTo($editing.find('.super-label-description'));
                            }else{
                                $('<div class="super-label-description"><div class="super-label">'+$value+'</div></div>').insertBefore($editing.find('.super-field-wrapper'));
                            }
                        }
                    }
                }

                // Add, update or delete field placeholder
                if($name=='placeholder'){
                    $editing.find('.super-shortcode-field').attr('placeholder', $value);
                }

                // Add, update or delete field description
                if($name=='description'){
                    var $element = $editing.find('.super-description');
                    if($value==''){
                        $element.remove();
                    }else{
                        if($value===' '){
                            $value = '&nbsp;';
                        }
                        if($element.length){
                            $element.html($value);
                        }else{
                            // If it doesn't exist yet, add the wrapper HTML also
                            if($editing.find('.super-label-description').length){
                                $('<div class="super-description">'+$value+'</div>').appendTo($editing.find('.super-label-description'));
                            }else{
                                $('<div class="super-label-description"><div class="super-description">'+$value+'</div></div>').insertBefore($editing.find('.super-field-wrapper'));
                            }
                        }
                    }
                }

                // Add, update or delete tooltip and
                if($name=='tooltip'){
                    // Only if tooltip was already intitialized
                    var $element = $editing.find('.super-shortcode.tooltipstered');
                    if($value==''){
                        $element.tooltipster('disable');
                    }else{
                        $element.tooltipster('content', $value);
                        $element.tooltipster('enable');
                    }
                }

            }else{
                if( ($tag=='checkbox') || ($tag=='radio') ) {
                    var $index = $this.parents('.super-multi-items:eq(0)').index()-1;
                    var $item = $editing.find('.super-field-wrapper').children('label:eq('+($index)+')');
                    var $image = $item.children('.image');

                    if($name=='bg_size'){
                        if($value=='custom'){
                            $this.next().show();
                            $value = $this.next().val();
                        }else{
                            $this.next().hide();
                        }
                        $image.css('background-size', $value);
                    }
                    if($name=='bg_size_custom'){
                        if( ($value.toLowerCase().indexOf('px') != -1) && ($value.indexOf('%') != -1) ) {
                            $value = $value.replace('px','').trim()+'px';
                        }else{
                            if( $value.indexOf('%') != -1 ) {
                                $value = $value.replace('%','').trim()+'%';
                            }else{
                                $value = $value.replace('px','').trim()+'px';
                            }
                        }
                        $image.css('background-size', $value);
                    }
                    if($name=='bg_repeat'){
                        $image.css('background-repeat', $value);
                    }
                    if($name=='bg_position'){
                        $image.css('background-position', $value);
                    }
                    if( ($name=='width') || ($name=='height') ) {
                        if($name=='width'){
                            if($value==''){
                                $item.find('img').css('width', '');
                            }else{
                                $item.find('img').css('width', $value.trim()+'px');
                            }
                        }
                        if($name=='height'){
                            if($value==''){
                                $item.find('img').css('height', '');
                            }else{
                                $item.find('img').css('height', $value.trim()+'px');
                            }
                        }
                    }
                }

            }


            // Prepare multi-items options
            $this.parents('.super-edit-element-panel:eq(0)').find('.multi-items').each(function(){
                SUPER.update_multi_items($(this));
            });

            $editing.children('textarea[name="element-data"]').val(SUPER.get_current_editing_fields());
            app.form.update();

            // Multi item field
            if($parent.hasClass('super-multi-items')){
                var $index = $parent.index()-1;
                var $item = $editing.find('.super-field-wrapper').children('label:eq('+($index)+')');
                
                if( ($tag=='checkbox') || ($tag=='radio') ) {
                    var $image = $item.children('.image');

                    if($name='label'){

                        var $data = $editing.children('textarea[name="element-data"]').val();
                        $data = JSON.parse($data);
                        if($this.parent().hasClass('super-multi-items')){
                            if($tag=='checkbox'){
                                $data = $data.checkbox_items[$this.parent().index()-1];
                            }
                            if($tag=='radio'){
                                $data = $data.radio_items[$this.parent().index()-1];
                            }
                        }

                        var $image_url = $image.css('background-image');
                        var $item_html = '';
                        if(typeof $image_url !== 'undefined'){
                            $image_url = $image_url.replace('url(','').replace(')','').replace(/\"/gi, "");
                            $item_html += '<div class="image" style="background-image:url('+$image_url+');" >';
                            $item_html += '<img src="'+$image_url+'"';
                            var $item_styles = '';
                            if( typeof $data.width !== 'undefined' ) {
                                if( ($data.width.toLowerCase().indexOf('px') != -1) && ($data.width.indexOf('%') != -1) ) {
                                    $data.width = $data.width.replace('px','').trim()+'px';
                                }else{
                                    if( $data.width.indexOf('%') != -1 ) {
                                        $data.width = $data.width.replace('%','').trim()+'%';
                                    }else{
                                        $data.width = $data.width.replace('px','').trim()+'px';
                                    }
                                }
                                $item_styles += 'width:'+$data.width+';';
                            }
                            if( typeof $data.height !== 'undefined' ) {
                                if( ($data.height.toLowerCase().indexOf('px') != -1) && ($data.height.indexOf('%') != -1) ) {
                                    $data.height = $data.height.replace('px','').trim()+'px';
                                }else{
                                    if( $data.height.indexOf('%') != -1 ) {
                                        $data.height = $data.height.replace('%','').trim()+'%';
                                    }else{
                                        $data.height = $data.height.replace('px','').trim()+'px';
                                    }
                                }
                                $item_styles += 'height:'+$data.height+';';
                            }
                            if($item_styles!=''){
                                $item_html += ' style="'+$item_styles+'"';
                            }
                            $item_html += '>';
                            $item_html += '</div>';
                        }
                        if( $tag=='checkbox') {
                            $item_html += '<input type="checkbox" value="'+$data.value+'">';
                        }
                        if( $tag=='radio') {
                            $item_html += '<input type="radio" value="'+$data.value+'">';
                        }
                        $item_html += '<span class="super-item-label">'+$data.label+'</span>';
                        $item.html($item_html);
                    }
                    if($name=='bg_size'){
                        if($value=='custom'){
                            $this.next().show();
                            $value = $this.next().val();
                        }else{
                            $this.next().hide();
                        }
                        $image.css('background-size', $value);
                    }
                    if($name=='bg_size_custom'){
                        if( ($value.toLowerCase().indexOf('px') != -1) && ($value.indexOf('%') != -1) ) {
                            $value = $value.replace('px','').trim()+'px';
                        }else{
                            if( $value.indexOf('%') != -1 ) {
                                $value = $value.replace('%','').trim()+'%';
                            }else{
                                $value = $value.replace('px','').trim()+'px';
                            }
                        }
                        $image.css('background-size', $value);
                    }
                    if($name=='bg_repeat'){
                        $image.css('background-repeat', $value);
                    }
                    if($name=='bg_position'){
                        $image.css('background-position', $value);
                    }
                    if( ($name=='width') || ($name=='height') ) {
                        if($name=='width'){
                            if($value==''){
                                $item.find('img').css('width', '');
                            }else{
                                $item.find('img').css('width', $value.trim()+'px');
                            }
                        }
                        if($name=='height'){
                            if($value==''){
                                $item.find('img').css('height', '');
                            }else{
                                $item.find('img').css('height', $value.trim()+'px');
                            }
                        }
                    }
                }

                /*
                if($this.attr('type')=='radio'){
                    if($tag=='checkbox'){
                        if($(this).attr('data-prev')=='false'){
                            $item.removeClass('super-selected');
                        }else{
                            $item.addClass('super-selected');
                        }
                    }
                    if($tag=='radio'){
                        var $wrapper = $editing.find('.super-field-wrapper');
                        if($(this).attr('data-prev')=='false'){
                            $wrapper.children('label').removeClass('super-selected');
                        }else{
                            $wrapper.children('label').removeClass('super-selected');
                            $item.addClass('super-selected');
                        }
                    }
                }else{
                    //var $label = $parent.children('input[name="label"]').val();
                    //var $value = $parent.children('input[name="value"]').val();
                    //$item.html('<input type="radio" value="'+$value+'">'+$label);
                }
                */
            //}

            // Reposition Edit Element Panel when height of editing element is changed
            //app.panel.reposition();

        //});


        $doc.on('click','.super-edit-element-panel .super-width > label, .super-edit-element-panel .super-position > label, .super-edit-element-panel .super-alignment > label, .super-edit-element-panel .super-width > label',function(){
            /*
            var $this = $(this);
            var $parent = $(this).parent();
            var $editing = app.get.editing();
            var $element = $editing.find('.super-shortcode');
            var $label = $element.children('.super-label-description');
            var $field = $this.parents('.field:eq(0)');

            $parent.children('label').removeClass('active');
            var $classes = $(this)[0].className.split(/\s+/);
            var $class = $classes[0];
            $this.addClass('active');
            $values = app.get.label_position_values($this);
            var $flex_size = $('.super-flex-size > li.active').text();
            var $sizes = {
                '1/1':'super_one_full',
                '4/5':'super_four_fifth',
                '3/4':'super_three_fourth',
                '2/3':'super_two_third',
                '3/5':'super_three_fifth',
                '1/2':'super_one_half',
                '2/5':'super_two_fifth',
                '1/3':'super_one_third',
                '1/4':'super_one_fourth',
                '1/5':'super_one_fifth'};

            if($parent.hasClass('super-position')){
                $values[0] = $class;

                // Check if we need to change the Label position in the HTML
                if( ($class=='top') || ($class=='left') ) {
                    // Make sure the element is above the field, if not append it before the field wrapper
                    if($label.index() > $element.children('.super-field-wrapper').index()){
                        $element.children('.super-field-wrapper').before($label);
                    }
                }
                if( ($class=='bottom') || ($class=='right') ) {
                    // Make sure the element is below the field, if not append it after the field wrapper
                    if($label.index() < $element.children('.super-field-wrapper').index()){
                        $element.children('.super-field-wrapper').after($label);
                    }
                }
                if($class=='left' || $class=='right'){
                    if($values[2]=='flex'){
                        $element.addClass($sizes[$flex_size]);
                        $field.children('.super-flex-size').css('display','block');
                    }
                    if($values[2]=='auto'){
                        $label.css('width','');
                    }
                    if($values[2]=='fixed'){
                        super_set_label_width($label, $field.find('.super-width .super-width-custom'));
                    }
                    $('.super-edit-element-panel .super-width').css('display','block');
                }else{
                    $element.removeClass($sizes[$flex_size]);
                    $label.css('width','');
                    $('.super-edit-element-panel .super-width').css('display','none');
                    $field.children('.super-flex-size').css('display','none');
                }
            }
            if($parent.hasClass('super-alignment')){
                $values[1] = $class;
            }
            if($parent.hasClass('super-width')){
                $values[2] = $class;
                if($class=='auto'){
                    $label.css('width','');
                }
                if($class=='fixed'){
                    super_set_label_width($label, $parent);
                    $parent.children('.super-width-custom').css('display','block');
                }else{
                    $parent.children('.super-width-custom').css('display','none');
                }
                if($class=='flex'){
                    $label.css('width','');
                    $element.addClass($sizes[$flex_size]);
                    $field.children('.super-flex-size').css('display','block');
                }else{
                    $element.removeClass($sizes[$flex_size]);
                    $field.children('.super-flex-size').css('display','none');
                }
            }
            $element.removeClass(function (index, className){
                return (className.match(/(^|\s)super-label-\S+/g) || []).join(' ');
            });
            $element.addClass('super-label-'+$values[0]+'-'+$values[1]);

            // Reposition Edit Element Panel when height of editing element is changed
            app.panel.reposition(undefined, $element);

            // Update the setting value
            var $field = $field.children('input[type="hidden"]');
            $field.val($values.join(':'));
            
            // Update element data
            $editing.children('textarea[name="element-data"]').val(SUPER.get_current_editing_fields());

            // Update form code
            app.form.update();
            */
        });

        
        $doc.on('change click keydown keyup blur', '.super-width-custom input', function(){
            var $this = $(this);
            var $editing = app.get.editing();
            var $inner = $editing.children('.super-element-inner');
            var $parents = $this.parents('.super-width-custom:eq(0)');
            var $label = $editing.find('.super-label-description');
            var $width = $parents.find('input[name="width"]').val();
            var $width_unit = $parents.find('input[name="width_unit"]').val();
            super_set_label_width($label, $parents);

            $editing.children('textarea[name="element-data"]').val(SUPER.get_current_editing_fields());
            app.form.update();

            // Reposition Edit Element Panel when height of editing element is changed
            app.panel.reposition();

            // Update the setting value
            $values = app.get.label_position_values($this);
            $values[3] = $width;
            $values[4] = $width_unit;
            var $field = $this.parents('.field:eq(0)').children('input[type="hidden"]');
            $field.val($values.join(':'));
        });



        $doc.on('click', '.super-edit-element-panel .super-multi-items .super-add-item', function(){
            var $this = $(this);
            var $parent = $this.parents('.super-multi-items:eq(0)');
            var $label = app.get.editing().find('.super-field-wrapper').children('label:eq('+($parent.index()-1)+')');
            var $new_label = $label.clone();

            var $fields = {};
            $parent.find('select').each(function(){
                $fields[$(this).attr('name')] = $(this).val();
            });

            var $item = $parent.clone();
            $item.find('select').each(function(){
                $(this).val($fields[$(this).attr('name')]);
            });
            
            $new_label.insertAfter($label);
            var $item = $item.insertAfter($parent);

            $item.find('.initialized').removeClass('initialized');
            $item.find('input[type="radio"]').prop('checked', false);

            var $absolute_parent = $parent.parents('.multi-items:eq(0)');
            if($absolute_parent.find('.super-multi-items').length > 1){
                $absolute_parent.find('.delete').css('visibility','');
            }else{
                $absolute_parent.find('.delete').css('visibility','hidden');
            }
            if(!$parent.hasClass('super-conditional-item')){
                SUPER.init_image_browser();
            }
            app.panel.reposition();

        });
        $doc.on('click','.super-multi-items .delete',function(){
            var $this = $(this);
            var $parent = $this.parents('.field-input:eq(0)');
            if($parent.find('.super-multi-items').length <= 2){
                $parent.find('.delete').css('visibility','hidden');
            }else{
                $parent.find('.delete').css('visibility','');
            }
            app.get.editing().find('.super-field-wrapper').children('label:eq('+($this.parent().index()-1)+')').remove();
            $(this).parent().remove();
            app.panel.reposition();
        });
        $doc.on('change click blur keyup keydown focus', '.super-multi-items *',function(){
            SUPER.update_multi_items($(this).parents('.multi-items:eq(0)'));
        });
        $doc.on('click','.super-multi-items .sorting span.up i',function(){
            var $parent = $(this).parents('.field-input:eq(0)');
            var $count = $parent.find('.super-multi-items').length;
            if($count>1){
                var $this = $(this).parents('.super-multi-items:eq(0)');
                var $prev = $this.prev();
                var $index = $this.index();
                var $editing = app.get.editing();
                if($index>0){
                    var $current = $editing.find('.super-field-wrapper > label:eq('+($index-1)+')');
                    var $editing_prev = $current.prev();
                    $current.insertBefore($editing_prev);
                    $this.insertBefore($prev);
                }else{
                    var $current = $editing.find('.super-field-wrapper > label:eq(0)');
                    $current.insertAfter( $editing.find('.super-field-wrapper > label').last());
                    $this.insertAfter($parent.find('.super-multi-items').last());
                }
            }

            // Prepare multi-items options
            $(this).parents('.super-edit-element-panel:eq(0)').find('.multi-items').each(function(){
                SUPER.update_multi_items($(this));
            });
            
            $editing.children('textarea[name="element-data"]').val(SUPER.get_current_editing_fields());
            app.form.update();

        });
        $doc.on('click','.super-multi-items .sorting span.down i',function(){
            var $parent = $(this).parents('.field-input:eq(0)');
            var $count = $parent.find('.super-multi-items').length;
            if($count>1){
                var $this = $(this).parents('.super-multi-items:eq(0)');
                var $next = $this.next();
                var $index = $this.index();
                var $editing = app.get.editing();
                if($index == $count){
                    var $current = $editing.find('.super-field-wrapper > label:eq('+($index-1)+')');
                    $current.insertBefore($editing.find('.super-field-wrapper > label').first());
                    $this.insertBefore($parent.find('.super-multi-items').first());
                }else{
                    var $current = $editing.find('.super-field-wrapper > label:eq('+($index-1)+')');
                    $current.insertAfter($current.next());
                    $this.insertAfter($next);
                }
            }

            // Prepare multi-items options
            $(this).parents('.super-edit-element-panel:eq(0)').find('.multi-items').each(function(){
                SUPER.update_multi_items($(this));
            });

            var $editing = app.get.editing();
            $editing.children('textarea[name="element-data"]').val(SUPER.get_current_editing_fields());
            app.form.update();

        });
        $doc.on('click','.super-multi-items input[type="checkbox"]',function(){
            var $prev = $(this).attr('data-prev');
            var $index = $(this).parent().index()-1;
            var $editing = app.get.editing();
            var $current = $editing.find('.super-field-wrapper > label:eq('+($index)+')');
            if($prev=='true'){
                $current.removeClass('super-selected');
                $(this).prop('checked', false).attr('data-prev','false');
            }else{
                $current.addClass('super-selected');
                $(this).prop('checked', true).attr('data-prev','true');
            }

            // Prepare multi-items options
            $(this).parents('.super-edit-element-panel:eq(0)').find('.multi-items').each(function(){
                SUPER.update_multi_items($(this));
            });

            var $editing = app.get.editing();
            $editing.children('textarea[name="element-data"]').val(SUPER.get_current_editing_fields());
            app.form.update();

        });
        $doc.on('click','.super-multi-items input[type="radio"]',function(){
            var $prev = $(this).attr('data-prev');
            var $index = $(this).parent().index()-1;
            var $editing = app.get.editing();
            var $current = $editing.find('.super-field-wrapper > label:eq('+($index)+')');
            $editing.find('.super-field-wrapper > label').removeClass('super-selected');
            $(this).parents('.field-input:eq(0)').find('input[type="radio"]').prop('checked',false).attr('data-prev','false');
            if($prev=='true'){
                $(this).prop('checked', false).attr('data-prev','false');
            }else{
                $current.addClass('super-selected');
                $(this).prop('checked', true).attr('data-prev','true');
            }

            // Prepare multi-items options
            $(this).parents('.super-edit-element-panel:eq(0)').find('.multi-items').each(function(){
                SUPER.update_multi_items($(this));
            });

            var $editing = app.get.editing();
            $editing.children('textarea[name="element-data"]').val(SUPER.get_current_editing_fields());
            app.form.update();

        });
        $doc.on('click', '.super-edit-element-panel > .close', function(){

            // First check for empty required fields
            var $error = false;
            $('.super-edit-element-panel .element-field[required="true"]').each(function(){
                var $this = $(this);
                if( $this.val()=='' ) {
                    var $hidden = false;
                    $this.parents('.field.filter').each(function(){
                        if($(this).css('display')=='none'){
                            $hidden = true;
                        }
                    });
                    if($hidden==false){
                        $error = true;
                        $this.addClass('super-error');
                    }
                }else{
                    $this.removeClass('super-error');
                }
            });
            if( $error==true) {
                var $first_error = $('.super-element-settings .super-error:eq(0)').parents('.field:eq(0)');
                var $parent = $first_error.parents('.tab-content:eq(0)');
                var $position = $first_error.position().top + $parent.scrollTop() - $first_error.outerHeight();
                $parent.animate({
                    scrollTop: $position
                }, 500);
                return false;
            }else{
                app.get.editing().classList.remove('editing');
                app.panel.this.classList.remove('super-active');
                app.canvas.this.classList.remove('editing-element');
            }
        });

    });

    // Convert HEX color code to RGB
    SUPER.hex2rgb = function($hex, $opacity){
        if(typeof $opacity === 'undefined') var $opacity = 1;
        var $c;
        if(/^#([A-Fa-f0-9]{3}){1,2}$/.test($hex)){
            $c= $hex.substring(1).split('');
            if($c.length== 3){
                $c = [$c[0], $c[0], $c[1], $c[1], $c[2], $c[2]];
            }
            $c = '0x'+$c.join('');
            return 'rgba('+[($c>>16)&255, ($c>>8)&255, $c&255].join(',')+','+$opacity+')';
        }
        return '';
    }

    // Loading States
    SUPER.loading_states = function(button, status){
        status = status || 'loading';
        if(status=='loading'){
            var old_html = button.html();
            button.data('old-html',old_html);
            button.parents('.super-form-button:eq(0)').addClass('super-loading');
            button.html('<i class="fa fa-refresh fa-spin"></i>');
        }else{
            button.parents('.super-form-button:eq(0)').removeClass('super-loading')
            button.html(button.data('old-html'));
        }
    }

    // Check if the added field has an unique field name
    SUPER.check_for_unique_field_name = function($element){
        var $field = $element.find('.super-shortcode-field');
        // @since v1.2.3 check if we are not importing predefined element
        if($field.length==1){
            if( typeof $field !== 'undefined' ) {
                if( typeof $field.attr('name') !== 'undefined' ) {
                    var $name = $field.attr('name').replace('[','').replace(']','');
                    var $exists = $('.super-preview-elements .super-shortcode-field[name="'+$name+'"]');
                    if($exists.length==0){
                        var $field = $element.find('.super-selected-files');
                        var $name = $field.attr('name').replace('[','').replace(']','');
                        var $exists = $('.super-preview-elements .super-selected-files[name="'+$name+'"]');
                    }
                    if($exists.length>0){
                        var $unique_name = SUPER.generate_unique_field_name($field, $name, $name, 0);
                        $field.attr('name',$unique_name);
                        var $data = $.parseJSON($element.children('textarea[name="element-data"]').val());
                        $data.name = $unique_name;

                        // @since 3.7.0 - change unique field name on the fly
                        $element.find('.super-title > input').val($unique_name);
                        
                        var $data = JSON.stringify($data);
                        $element.children('textarea[name="element-data"]').val($data);
                    }
                }
            }
        }
    }

    // Generate unique field name for a given element
    SUPER.generate_unique_field_name = function($field, $name, $new_name, $counter){
        var $exists = $('.super-preview-elements .super-shortcode-field[name="'+$new_name+'"]');
        if( $exists.length==0 ) {
            var $exists = $('.super-preview-elements .super-selected-files[name="'+$new_name+'"]');
        }
        if( $exists.length>1 ) {
            $counter++;
            $new_name = $name+'_'+$counter;
            $field.attr('name',$new_name);
            return SUPER.generate_unique_field_name($field, $name, $new_name, $counter);
        }else{
            return $new_name;
        }
    }

    // Regenerate Element Final Output (inner)
    SUPER.regenerate_element_inner = function(target){
        console.log('@TODO: remove this function');
        /*if(target==2){
            const elements = $('textarea[name="_super_elements"].active').val();
        }else{
            //var $elements = SUPER.regenerate_element_inner.get_elements($target);
            console.log('SUPER.regenerate_element_inner');
            const elements = app.get.element.data(target);
            elements = JSON.stringify(elements);
        }
        $('textarea[name="_super_elements"].active').val($elements);
        if(target==2){
            SUPER.save_form($('.super-actions .save'), 2);
        }else{
            SUPER.trigger_redo_undo();
        }
        */
    }

    SUPER.init_previously_created_fields = function(){
        
        var $options = {};
        $('.super-preview-elements .super-element').each(function(){
            var $data = $(this).children('textarea[name="element-data"]').val();
            var $data = JSON.parse($data);
            // Skip element if data is null
            if( $data!=null ) {
                var $name = $data.name;
                var $email = $data.email;
                if( typeof $name !== 'undefined' ) {
                    if( typeof $email === 'undefined' ) {
                        $email = $name;
                    }
                    $options[$name] = {
                        selected: '<option selected="selected" value="'+$name+'">'+$name+': '+$email+'</option>',
                        default: '<option value="'+$name+'">'+$name+': '+$email+'</option>'
                    };
                }
            }
        });

        $('.super-multi-items .super-previously-created, .previously-created-fields').each(function(){
            var $this = $(this);
            var $value = $this.data('value');
            if( $this.parent().hasClass('address-auto-popuplate-item') ) {
                var $options_html = '<option value="">- select a field -</option>';  
            }else{
                var $options_html = '';
            }
            $.each($options, function(key, value){
                if( $value==key ) {
                    $options_html += value.selected;
                }else{
                    $options_html += value.default;
                }
            });
            $this.html($options_html);
        });
        $('.super-element-settings .super-elements-container select[name="connected_min"]').each(function(){
            var $this = $(this);
            var $current = app.get.editing().find('.super-shortcode-field');
            var $value = $current.attr('data-connected_min');
            var $options_html = '';
            $.each($options, function(key, value){
                var $found = $this.find('option[value="'+key+'"]').length;
                if( $found==0 ) {
                    if( $value==key ) {
                        $options_html += value.selected;
                    }else{
                        $options_html += value.default;
                    }
                }
            });
            $options_html = '<option value="">- Not connected -</option>'+$options_html;
            $this.html($options_html);
        });
        $('.super-element-settings .super-elements-container select[name="connected_max"]').each(function(){
            var $this = $(this);
            var $current = app.get.editing().find('.super-shortcode-field');
            var $value = $current.attr('data-connected_max');
            var $options_html = '';
            $.each($options, function(key, value){
                var $found = $this.find('option[value="'+key+'"]').length;
                if( $found==0 ) {
                    if( $value==key ) {
                        $options_html += value.selected;
                    }else{
                        $options_html += value.default;
                    }
                }
            });
            $options_html = '<option value="">- Not connected -</option>'+$options_html;
            $this.html($options_html);
        });
    }

    SUPER.update_multi_items = function($this){
        var $parent = $this.children('.field-input');
        var $items = [];
        $parent.find('.super-multi-items').each(function(){
            var $this = $(this);
            if($this.hasClass('super-conditional-item')){
                $items.push({ 
                    field: $this.children('select[name="conditional_field"]').val(),
                    logic: $this.children('select[name="conditional_logic"]').val(),
                    value: $this.children('input[name="conditional_value"]').val(),
                    and_method: $this.children('select[name="conditional_and_method"]').val(),
                    field_and: $this.children('select[name="conditional_field_and"]').val(),
                    logic_and: $this.children('select[name="conditional_logic_and"]').val(),
                    value_and: $this.children('input[name="conditional_value_and"]').val(),
                    new_value: $this.children('textarea[name="conditional_new_value"]').val()
                });
            }else if($this.hasClass('address-auto-popuplate-item')){
                $items.push({ 
                    key: $this.children('input[name="key"]').val(),
                    field: $this.children('select[name="field"]').val(),
                    type: $this.children('select[name="type"]').val()
                });
            }else{
                if($this.children('input[type="checkbox"]').length){
                    var $checked = $this.children('input[type="checkbox"]').is(':checked');
                }
                if($this.children('input[type="radio"]').length){
                    var $checked = $this.children('input[type="radio"]').is(':checked');
                }
                $items.push({ 
                    checked: $checked,
                    image: $this.find('input[name="image"]').val(),
                    width: $this.find('input[name="width"]').val(),
                    height: $this.find('input[name="height"]').val(),
                    bg_size: $this.find('select[name="bg_size"]').val(),
                    bg_size_custom: $this.find('input[name="bg_size_custom"]').val(),
                    bg_repeat: $this.find('select[name="bg_repeat"]').val(),
                    bg_position: $this.find('select[name="bg_position"]').val(),
                    label: $this.children('input[name="label"]').val(),
                    value: $this.children('input[name="value"]').val()
                });
            }
        });
        var $items = JSON.stringify($items);
        $parent.children('textarea').val($items);
    }

    // $preview - if set to "1" show preview, if set to "2" also do a page reload (required for loading example forms)
    // $change_builder_mode - only set when button was clicked to change the builder mode
    SUPER.save_form = function( $this, $preview, $change_builder_mode ) {
        if(typeof $change_builder_mode === 'undefined') var $change_builder_mode = '';

        var $fields = $('.super-preview-elements .super-shortcode-field, .super-preview-elements .super-selected-files');
        var $error = false;
        
        // First reste all classes
        $('.super-preview-elements .super-element.error').removeClass('error');

        // @since 4.0.0 - see if we need to skip this validation when user choose to disable validation check on unique field names
        var $allow = $('input[name="allow_duplicate_names"]').is(':checked');
        if( !$allow ) {
            $fields.each(function(){
                var $origin_field = $(this);
                if($origin_field.parents('.super-file:eq(0)').length) {
                    var $duplicate_fields = $('.super-preview-elements .super-selected-files[name="'+$(this).attr('name')+'"]');
                }else{
                    var $duplicate_fields = $('.super-preview-elements .super-shortcode-field[name="'+$(this).attr('name')+'"]');
                }
                if($duplicate_fields.length > 1){
                    $duplicate_fields.parents('.super-element').addClass('error');
                    $error = true;
                }
            });
            if($error == true) {
                alert(super_create_form_i18n.alert_duplicate_field_names);
                return false;
            } 
        }
        
        $this.html('<i class="fa fa-save"></i>Saving...');

        var $settings = {};
        $('.super-create-form .super-form-settings .element-field').each(function(){
            var $this = $(this);
            var $name = $this.attr('name');
            var $value = $this.val();
            $settings[$name] = $value;
        });

        $.ajax({
            type: 'post',
            url: ajaxurl,
            data: {
                action: 'super_save_form',
                id: $('.super-create-form input[name="form_id"]').val(),
                title: $('.super-create-form input[name="title"]').val(),
                shortcode: $('textarea[name="_super_elements"].active').val(),
                settings: $settings,
                change_builder_mode: $change_builder_mode // empty by default, only set when changing builder type via button
            },
            success: function (data) {
                $('.super-create-form .super-get-form-shortcodes').val('[super_form id="'+data+'"]');
                $('.super-create-form input[name="form_id"]').val(data);
                $('.super-create-form .super-actions .save').html('<i class="fa fa-save"></i>Save');
                if($preview==1){
                    var $this = $('.super-create-form .super-actions .preview:eq(3)');
                    SUPER.preview_form($this);
                }else{
                    var href = window.location.href;
                    var page = href.substr(href.lastIndexOf('/') + 1);
                    var str2 = "admin.php?page=super_create_form&id";
                    if(page.indexOf(str2) == -1){
                        window.location.href = "admin.php?page=super_create_form&id="+data;
                    }else{
                        if($preview==2){
                            location.reload();
                        }                    
                    }
                }
            }
        });
    }
    SUPER.preview_form = function( $this ) {  
        if($('input[name="form_id"]').val()==''){
            alert(super_create_form_i18n.alert_save);
            return false;
        }
        if(!$this.hasClass('active')){
            $this.html('Loading...');
            $('.super-live-preview').html('');
            $('.super-preview-elements').css('display','none');
            $('.super-live-preview').addClass('loading').css('display','block');
            var $form_id = $('.super-create-form input[name="form_id"]').val();
            $.ajax({
                type: 'post',
                url: ajaxurl,
                data: {
                    action: 'super_load_preview',
                    id: $form_id,
                },
                success: function (data) {
                    $('.super-live-preview').removeClass('loading');
                    $('.super-live-preview').html(data);
                    $this.html('Builder');
                },
                complete: function () {
                    SUPER.handle_columns();
                    SUPER.init_button_colors();
                    SUPER.init_super_responsive_form_fields();
                    SUPER.init_super_form_frontend();
                    SUPER.after_preview_loaded_hook($form_id);
                }
            });
        }else{
            $('.super-live-preview').css('display','none');
            $('.super-preview-elements').css('display','block');
            $this.html('Preview');
        }
        $this.toggleClass('active');
    }

    // @since 2.9.0 - form setup wizard
    SUPER.update_wizard_preview = function($theme, $size, $icon, $save) {
        if($theme==null) $theme = $('.super-theme-style-wizard li.super-active').attr('data-value');
        if($size==null) $size = $('.super-field-size-wizard li.super-active').attr('data-value');
        if($icon==null) $icon = $('.super-theme-hide-icons-wizard li.super-active').attr('data-value');
        if($theme=='squared') $theme_setting = '';
        if($theme=='rounded') $theme_setting = 'super-default-rounded';
        if($theme=='full-rounded') $theme_setting = 'super-full-rounded';
        if($theme=='minimal') $theme_setting = 'super-style-one';
        if($icon=='no') $icon_setting = 'yes';
        if($icon=='yes') $icon_setting = 'no';
        if($save==true){
            $('.super-create-form select[name="theme_style"]').val($theme_setting);
            $('.super-create-form select[name="theme_field_size"]').val($size);
            $('.super-create-form select[name="theme_hide_icons"]').val($icon_setting);
            $('.super-create-form input[name="title"]').val($('.super-create-form input[name="wizard_title"]').val());
            
            $('.super-create-form input[name="header_to"]').val($('.super-create-form input[name="wizard_header_to"]').val());
            $('.super-create-form select[name="header_from_type"]').val('custom');
            $('.super-create-form input[name="header_from"]').val($('.super-create-form input[name="wizard_header_from"]').val());
            $('.super-create-form input[name="header_from_name"]').val($('.super-create-form input[name="wizard_header_from_name"]').val());
            $('.super-create-form input[name="header_subject"]').val($('.super-create-form input[name="wizard_header_subject"]').val());
            $('.super-create-form textarea[name="email_body_open"]').val($('.super-create-form textarea[name="wizard_email_body_open"]').val());

            $('.super-create-form input[name="confirm_to"]').val($('.super-create-form input[name="wizard_confirm_to"]').val());
            $('.super-create-form select[name="confirm_from_type"]').val('custom');
            $('.super-create-form input[name="confirm_from"]').val($('.super-create-form input[name="wizard_confirm_from"]').val());
            $('.super-create-form input[name="confirm_from_name"]').val($('.super-create-form input[name="wizard_confirm_from_name"]').val());
            $('.super-create-form input[name="confirm_subject"]').val($('.super-create-form input[name="wizard_confirm_subject"]').val());
            $('.super-create-form textarea[name="confirm_body_open"]').val($('.super-create-form textarea[name="wizard_confirm_body_open"]').val());

            $('.super-create-form input[name="form_thanks_title"]').val($('.super-create-form input[name="wizard_form_thanks_title"]').val());
            $('.super-create-form textarea[name="form_thanks_description"]').val($('.super-create-form textarea[name="wizard_form_thanks_description"]').val());

        }
        var $img_preview = $theme+'-'+$size;
        if($icon=='yes') $img_preview = $img_preview+'-icon';
        var $img_preview_url = $('.super-wizard-preview img').attr('data-preview-url')+'assets/images/wizard-preview/'+$img_preview+'.png';
        $('.super-wizard-preview img').attr('src', $img_preview_url);
    }

    // @since 3.1.0 - trigger undo/redo after _super_elements was changed
    SUPER.insertAfter = function(referenceNode, newNode) {
        referenceNode.parentNode.insertBefore(newNode, referenceNode.nextSibling);
    }
    SUPER.trigger_redo_undo = function() {

        // Add code to textarea
        var code = document.querySelector('textarea[name="_super_elements"].active');
        var el = document.createElement("textarea");
        el.value = code.value;
        el.name = '_super_elements';
        el.className = 'active';
        code.className = '';
        code.parentNode.insertBefore(el, code.nextSibling);

        // Disable/Enable redo/undo buttons
        var $code = $('textarea[name="_super_elements"].active');
        if($code.parent().children('textarea').length>1){
            if($('textarea[name="_super_elements"].active').index()==0){
                $('.super-form-builder-actions .super-undo').addClass('super-disabled');
            }else{
                $('.super-form-builder-actions .super-undo').removeClass('super-disabled');
            }
            if($('textarea[name="_super_elements"].active').index()==($('.super-debug textarea[name="_super_elements"]').length-1)){
                $('.super-form-builder-actions .super-redo').addClass('super-disabled');
            }else{
                $('.super-form-builder-actions .super-redo').removeClass('super-disabled');
            }
        }
    }

    // @since 3.7.0 - function for random name generation when duplicate action button is clicked
    SUPER.generate_new_field_name = function() {
        var $field_name = "";
        var possible = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz";
        for (var i = 0; i < 5; i++) {
            $field_name += possible.charAt(Math.floor(Math.random() * possible.length));
        }
        // First check if this fieldname already exists inside builder
        if($('.super-preview-elements .super-shortcode-field[name="'+$field_name+'"]').length){
            var $field_name = SUPER.generate_new_field_name();   
        }
        return 'field_'+$field_name;
    }


    jQuery(document).ready(function ($) {
        
        var $doc = $(document);

        // Highlight element that we want to edit
        $doc.on('mouseenter', '.super-preview-elements .super-element:not(.super-highlighted)', function(e){
            $('.super-preview-elements').find('.super-drop-before, .super-drop-inside, .super-drop-after').remove();
            var $target = $(e.target);
            if(!$target.hasClass('super-element')){
                $target = $target.parents('.super-element:eq(0)');
            }
            if($('.super-preview-elements').hasClass('super-moving-elements')){
                $target.parents('.super-element').removeClass('super-highlighted').removeClass('super-drag-drop-here');
                $target.addClass('super-drag-drop-here');
                
                $('<div class="super-drop-before"><span>Before</span></div>').appendTo($target);
                $('<div class="super-drop-inside"><span>Inside</span></div>').appendTo($target);
                $('<div class="super-drop-after"><span>After</span></div>').appendTo($target);
            }else{
                $target.parents('.super-element').removeClass('super-highlighted');
                $target.addClass('super-highlighted');
            }
        });
        $doc.on('mouseleave', '.super-preview-elements .super-element', function(e){
            $('.super-preview-elements').find('.super-drop-before, .super-drop-inside, .super-drop-after').remove();
            $(e.currentTarget).find('.super-highlighted').removeClass('super-highlighted');
            $(e.currentTarget).removeClass('super-highlighted');
            var $target = $(e.currentTarget).parents('.super-element:eq(0)');
            if( $target.length ) {
                if($('.super-preview-elements').hasClass('super-moving-elements')){
                    $target.parents('.super-element').removeClass('super-highlighted').removeClass('super-drag-drop-here');
                    $('<div class="super-drop-before"><span>Before</span></div>').appendTo($target);
                    $('<div class="super-drop-inside"><span>Inside</span></div>').appendTo($target);
                    $('<div class="super-drop-after"><span>After</span></div>').appendTo($target);
                }else{
                    $target.addClass('super-highlighted');
                }
            }     
        });

        // @since 4.0.0 - hints/introduction
        var $skip = $('input[name="super_skip_tutorial"]').val();
        var $elements_found = $('.super-preview-elements .super-element').length;
        var $skip = 'false';
        if( ($skip!='true') && (!$elements_found) ) {
            var $git = 'https://renstillmann.github.io/super-forms/#/';
            var $timeout = 0;
            var $margin = 0;
            var $timeout_s = 400;
            var $event = 'next';
            var $showSkip = false;
            var $showNext = true;
            var $tags_allowed = '<span class="super-tip">You are allowed to use {tags} for this setting,<br />for more information about tags refer to the documentation section:<br /><a target="blank" href="'+$git+'tags-system">Tags system</a></span>';


            // Check if field `wizard_title` exists
            if($('input[name="wizard_title"]').length){
                var $super_hints = new SUPER.EnjoyHint({});
                var $super_hints_steps = [
                    {
                        selector: '.enjoyhint_close_btn',
                        shape: 'circle',
                        radius: 50,
                        nextButton : {text: "Start"},
                        description: '<h1>Hello! This is a short tutorial to get you up and running with Super Forms. Please click "Start" to begin the tutorial :)</h1><span class="super-tip">If you wish to skip the tutorial, you can skip it by clicking the close button</span><span class="super-tip">We strongly suggest you complete this step by step guide. It will help you get started nicely and quickly without any issues.</span><label class="tutorial-do-not-show-again"><input type="checkbox" name="tutorial_do_not_show_again" />Do not show me this tuturial again.</label>',
                    },
                    {
                        onBeforeStart: function() {
                            $('input[name="wizard_title"]').keydown(function(e) {
                                if( (e.keyCode == 13) && ($(this).val() !== '') ) {
                                    $super_hints.trigger('next');
                                }
                            });
                        },
                        selector: 'input[name="wizard_title"]',
                        event: 'form_title_entered',
                        event_type: 'custom',
                        description: '<h1>Enter your form title and press Enter.</h1>',
                    },
                    {
                        selector: '.super-theme-style-wizard',
                        event: 'click',
                        description: '<h1>Choose a form theme.</h1>',
                    },
                    {
                        selector: '.super-field-size-wizard',
                        event: 'click',
                        description: '<h1>Now choose a field size for your form elements.</h1>',
                    },
                    {
                        selector: '.super-theme-hide-icons-wizard',
                        event: 'click',
                        description: '<h1>Select wether or not to display icons for fields</h1><span class="super-tip">Don\'t worry, you can change all these settings at a later time</span>',
                    },
                    {
                        selector: '.super-wizard-preview',
                        description: '<h1>Here you can preview your form and see how it will look on the front-end of your website</h1><span class="super-tip">Note that this is an example only, and the elements are just for demonstration purpose only. You will soon build your very own form with your own elements.</span>',
                    },
                    {
                        selector: '.super-wizard-settings .super-tabs > li:eq(1)',
                        event: 'click',
                        showNext: false,
                        description: '<h1>Click on the "Admin email" TAB to change how your admin emails are send</h1><span class="super-tip">By default this email will be send to the wordpress admin email address, but you can change this to any email address.</span>',
                    },
                    {
                        selector: 'input[name="wizard_header_to"]',
                        description: '<h1>Enter the email address where admin emails should be send to</h1>' + $tags_allowed,
                    },

                    {
                        selector: 'input[name="wizard_header_from"]',
                        description: '<h1>Enter the email address where the email was send from</h1>' + $tags_allowed,
                    },

                    {
                        selector: 'input[name="wizard_header_from_name"]',
                        description: '<h1>Enter the name of your company or website</h1>' + $tags_allowed,
                    },

                    {
                        selector: 'input[name="wizard_header_subject"]',
                        description: '<h1>Enter the email subject that relates to this form</h1>' + $tags_allowed,
                    },
                    {
                        selector: 'textarea[name="wizard_email_body_open"]',
                        description: '<h1>Here you can enter a short description that will be placed at the top of your admin email</h1><span class="super-tip">The email body itself can be changed under the "Form Settings" panel on the builder page, which we will be covering at a later time in this tutorial.</span><span class="super-tip">The email body itself will by default simply loop all the user input that was submitted by the user. You can of course write your custom email body if you require to do so.</span>' + $tags_allowed,
                    },
                    {
                        selector: '.super-wizard-settings .super-tabs > li:eq(2)',
                        event: 'click',
                        showNext: false,
                        description: '<h1>Click on the "Confirmation email" TAB to change how confirmation emails are send</h1><span class="super-tip">By default this email will be send to the user who submitted the form if an email address was provided</span>',
                    },
                    {
                        selector: 'input[name="wizard_confirm_to"]',
                        description: '<h1>The email address where the confirmation email should be send to.</h1><span class="super-tip">By default this is set to {email} which is a <a target="_blank" href="'+$git+'tags-system">tag</a> that will automatically retrieve the email address that the user entered in the form.</span><span class="super-tip">You can seperate emails with comma\'s to send to multiple addresses</span>' + $tags_allowed,
                    },
                    {
                        selector: 'input[name="wizard_confirm_from"]',
                        description: '<h1>Enter the email address where the email was send from</h1>' + $tags_allowed,
                    },
                    {
                        selector: 'input[name="wizard_confirm_from_name"]',
                        description: '<h1>Enter the name of your company or website</h1>' + $tags_allowed,
                    },
                    {
                        selector: 'input[name="wizard_confirm_subject"]',
                        description: '<h1>Enter the confirmation email subject that relates to this form</h1>' + $tags_allowed,
                    },
                    {
                        selector: 'textarea[name="wizard_confirm_body_open"]',
                        description: '<h1>Here you can enter a short description that will be placed at the top of your confirmation email</h1><span class="super-tip">The email body itself can be changed under the "Form Settings" panel on the builder page, which we will be covering at a later time in this tutorial.</span><span class="super-tip">The email body itself will by default simply loop all the user input that was submitted by the user. You can of course write your custom email body if you require to do so.</span>' + $tags_allowed,
                    },
                    {
                        selector: '.super-wizard-settings .super-tabs > li:eq(3)',
                        event: 'click',
                        showNext: false,
                        description: '<h1>Click on the "Thank you message" TAB to change the Success message</h1><span class="super-tip">This message will by default be displayed to the user after they successfully submitted the form.</span>' + $tags_allowed,
                    },
                    {
                        selector: 'input[name="wizard_form_thanks_title"]',
                        description: '<h1>The Title for your thank you message</h1>' + $tags_allowed,
                    },
                    {
                        selector: 'textarea[name="wizard_form_thanks_description"]',
                        description: '<h1>The Description for your thank you message</h1><span class="super-tip">This can be used to provide some additional information that is important to the user after they successfully submitted the form.</span>' + $tags_allowed,
                    },
                    {
                        selector: '.super-button.save-wizard',
                        event: 'click',
                        showNext: false,
                        description: '<h1>Click this button to save the configuration and to start building your form</h1>',
                    },
                ];
                $.each($super_hints_steps, function(key, value){
                    if( typeof value.event === 'undefined')
                        $super_hints_steps[key]['event'] = $event;
                    if( typeof value.showSkip === 'undefined')
                        $super_hints_steps[key]['showSkip'] = $showSkip;
                    if( typeof value.showNext === 'undefined')
                        $super_hints_steps[key]['showNext'] = $showNext;
                    if( typeof value.timeout === 'undefined')
                        $super_hints_steps[key]['timeout'] = $timeout;
                    if( typeof value.margin === 'undefined')
                        $super_hints_steps[key]['margin'] = $margin;
                });
                $super_hints.set($super_hints_steps);
                $super_hints.run();
            }else{
                var $super_hints = new SUPER.EnjoyHint({});
                var $super_hints_steps = [
                    {
                        selector: '.super-preview-elements',
                        description: '<h1>This is your "Canvas" where you will be dropping all your "Elements"</h1><span class="super-tip">"Elements" can be fields, but also HTML elements and columns. Basically anything that can be dragged and dropped onto the canvas is a so called element.</span><label class="tutorial-do-not-show-again"><input type="checkbox" name="tutorial_do_not_show_again" />Do not show me this tuturial again.</label>',
                    },
                    {
                        selector: '.super-element.super-form-elements',
                        event: 'click',
                        description: '<h1>Let\'s open up the "Form Elements" panel by clicking on it</h1>',
                    },
                    {
                        selector: '.super-element.super-form-elements .super-elements-container',
                        description: '<h1>Here you can find all "Form Elements"</h1><span class="super-tip">Form elements are elements that a user can enter data into (also referred to as "user input"). As you can see there is a variety of form elements to choose from to create any type of form you want.</span>',
                        timeout: $timeout_s
                    },
                    {
                        onBeforeStart: function() {
                            $doc.find('.super-element.draggable-element.super-shortcode-email').on('mouseleave',function(e){
                                if( $(this).hasClass('pep-start') ) {
                                    $super_hints.trigger('next');
                                }
                            });
                        },
                        showNext: false,
                        selector: '.super-element.super-form-elements .super-elements-container .super-shortcode-email',
                        description: '<h1>Let\'s drag the "Email Address" field on to your "Canvas"</h1>',
                    },
                    {
                        onBeforeStart: function() {
                            // Keep searching for element until we found it, then automatically go to next step
                            var loop = setInterval(function() {
                                if($('.super-element .super-field-wrapper input[name="email"]').length){
                                    $super_hints.trigger('next');
                                    clearInterval(loop);
                                }
                            }, 100);
                        },
                        selector: '.super-preview-elements',
                        showNext: false,
                        description: '<h1>Drop the element on to your "Canvas"</h1>',
                    },
                    {
                        selector: '.super-element-title .super-title > input',
                        description: '<h1>Here you can quickly change the "Unique field name" of your field</h1><span class="super-tip">The unique field name relates to the user input. The {email} <a target="_blank" href="'+$git+'tags-system">tag</a> in this case would retrieve the entered email address of the user which you can then use within your custom emails, HTML elements and <a target="_blank" href="'+$git+'variable-fields">Variable fields</a> or inside your email subjects or other settings that support the use of {tags}.</span>',
                    },
                    {
                        onBeforeStart: function() {
                            $('.super-element-actions .minimize').css( 'pointer-events', 'none' );
                            $('.super-element-actions .delete').css( 'pointer-events', 'none' );
                        },
                        selector: '.super-element-actions .minimize',
                        radius: 10,
                        shape: 'circle',
                        description: '<h1>Here you can minimize your element</h1><span class="super-tip">This comes in handy especially when working with large forms. To benefit from this feature make sure you use columns to group your elements. With columns you can minimize a set of elements at once to make building forms even easier, faster and better manageable.</span>',
                    },
                    {
                        onBeforeStart: function() {
                            $('.super-element-actions .minimize').css( 'pointer-events', '' );
                            $('.super-element-actions .delete').css( 'pointer-events', '' );
                        },
                        selector: '.super-element-actions .delete',
                        radius: 10,
                        event: 'click',
                        shape: 'circle',
                        description: '<h1>Click on the delete icon and delete this element</h1><span class="super-tip">Removing a "Layout Element" (<a target="_blank" href="'+$git+'columns">Column</a> or <a target="_blank" href="'+$git+'multi-parts">Multi-part</a>) will also delete all it\'s inner elements along with it.</span><span class="super-tip">Don\'t worry, we will cover Columns and Multi-part elements very soon!</span>',
                    },
                    {
                        selector: '.super-form-builder-actions .super-undo',
                        event: 'click',
                        shape: 'circle',
                        description: '<h1>Undo previous change, click and undo your previous change to get back our element</h1><span class="super-tip">If you accidently deleted an element and want to get it back or when you moved an element where you did not want it to be moved to by accident, then you can undo your latest change with this button.</span><span class="super-tip">You can undo/redo any changes you made to your form that affected elements.</span><span class="super-tip">Please understand that the Undo/Redo buttons act like scrolling through micro back-ups of your form (which aren\'t really saved), so after a page refresh you can no longer undo any previously made changes).</span>',
                    },
                    {
                        onBeforeStart: function() {
                            $('.super-form-builder-actions .super-redo').css( 'pointer-events', 'none' );
                        },
                        selector: '.super-form-builder-actions .super-redo',
                        shape: 'circle',
                        description: '<h1>Redo previous change</h1><span class="super-tip">Does the same thing as undo but opposite.</span>',
                    },
                    {
                        onBeforeStart: function() {
                            $('.super-form-builder-actions .super-backups').css( 'pointer-events', 'none' );
                            $('.super-form-builder-actions .super-redo').css( 'pointer-events', '' );
                        },
                        selector: '.super-form-builder-actions .super-backups',
                        shape: 'circle',
                        description: '<h1>Load or restore to previous backups</h1><span class="super-tip">Backups are automatically made when saving your form, so whenever you want to go back in history you can restore directly to a previous backup that was automatically made for you.</span>',
                    },
                    {
                        onBeforeStart: function() {
                            $('.super-form-builder-actions .super-backups').css( 'pointer-events', '' );
                        },
                        selector: '.super-form-builder-actions .super-minimize-toggle',
                        event: 'click',
                        shape: 'circle',
                        description: '<h1>Let\'s minimize all our elements, we only have 1 element but for the demonstration purpose this doesn\'t matter right now ;)</h1><span class="super-tip">This comes in handy especially when working with large forms. To benefit from this feature make sure you use columns to group your elements. With columns you can minimize a set of elements at once to make building forms even easier, faster and better manageable.</span></span>',
                    },
                    {
                        selector: '.super-form-builder-actions .super-maximize-toggle',
                        event: 'click',
                        shape: 'circle',
                        description: '<h1>Maximizing all elements</h1><span class="super-tip">Whenever you working with large forms and used the minimize button, you can maximize all of your elements at once to quickly find the element that you need to edit.</span>',
                    },
                    {
                        selector: '.super-element-actions .move',
                        radius: 10,
                        shape: 'circle',
                        description: '<h1>Moving your element can be done via this button</h1><span class="super-tip">Drag & Drop your element into a different location or inside a different layout element with ease.</span>',
                    },
                    {
                        selector: '.super-element-actions .duplicate',
                        event: 'click',
                        radius: 10,
                        shape: 'circle',
                        description: '<h1>Duplicate this element</h1><span class="super-tip">Duplicating elements that you already created will speed up your building process! When duplicating Columns or Multi-parts all inner elements will be duplicated along with them, making life even easier :)</span>',
                    },
                    {
                        selector: '.super-element-actions .edit',
                        radius: 10,
                        event: 'click',
                        shape: 'circle',
                        description: '<h1>Click on the pencil icon to edit this element</h1><span class="super-tip">All elements can be edited, and each element will have it\'s very own settings and features. </span>',
                    },
                    {
                        selector: '.super-element.super-element-settings',
                        description: '<h1>Here you can find all the settings for the element you are editing</h1><span class="super-tip">By default the General TAB is opened where you will find the most commonly used settings that you will often be changing.</span>',
                        timeout: $timeout_s
                    },
                    {
                        selector: '.super-element.super-element-settings .super-element-settings-tabs > select',
                        event: 'change',
                        showNext: false,
                        description: '<h1>We have devided all element settings into sections which you can choose from via this dropdown, Open the dropdown and switch to a different section to find out about all the other features and settings for the element you are editing.</h1><span class="super-tip">Remember that all elements have different settings and features, so make sure to explore them all!</span><span class="super-tip">Note that the Email Address element that we added to our form, is a <a target="_blank" href="'+$git+'text">Text field</a>. It is a predefined element that basically has the <a target="_blank" href="'+$git+'special-validation?id=email-address">Email address validation</a> enabled by default. There are several other predefined elements for you just to make building even easier for you.',
                    },
                    {
                        selector: '.super-element.super-element-settings',
                        description: '<h1>Perfect! Now you know how to edit elements and how to find all settings and features available for each element you edit.</h1>',
                    },
                    {
                        selector: '.super-element-settings .tab-content.active .super-tooltip',
                        shape: 'circle',
                        radius: 20,
                        description: '<h1>Not sure what a field is used for, just hover over the question icon to find out more information about it.</h1>',
                    },
                    {
                        selector: '.super-element.super-layout-elements',
                        event: 'click',
                        description: '<h1>Let\'s explore the rest of Super Forms shall we? Open up the "Layout Elements" panel by clicking on it</h1>',
                    },
                    {
                        selector: '.super-element.super-layout-elements .super-elements-container',
                        description: '<h1>These are your "Layout Elements"</h1><span class="super-tip">The <a target="_blank" href="'+$git+'columns">Columns (Grid Element)</a> can be used to create the layout of your form.</span><span class="super-tip">You can use columns to put fields next to eachother and to do <a target="_blank" href="'+$git+'conditional-logic">Conditional Logic</a>.</span><span class="super-tip">A column can also be used to create <a target="_blank" href="'+$git+'columns?id=dynamic-add-more">Dynamic fields</a> that can be duplicated by users. This way a set of fields can be dynamically added by clicking on a "+" icon.</span><span class="super-tip">Columns can be nested inside of each other as many times as you wish, they can also be inserted into a <a target="_blank" href="'+$git+'multi-parts">Multi-part</a> element.</span><span class="super-tip">The <a target="_blank" href="'+$git+'multi-parts">Multi-part</a> element can be used to split a form into multiple parts (also called steps). For each step you will have to add a new Multi-part element with inside the elements that belong to this particular step.</span>',
                        timeout: $timeout_s
                    },
                    {
                        selector: '.super-element.super-html-elements',
                        event: 'click',
                        description: '<h1>Now open the "HTML Elements" panel</h1>',
                    },
                    {
                        selector: '.super-element.super-html-elements .super-elements-container',
                        description: '<h1>Here you can find all HTML elements</h1><span class="super-tip">HTML elements are elements that users can not change or alter (they are fixed html items that do not require user input). However you can make some elements dynamically change with the use of <a target="_blank" href="'+$git+'conditional-logic">Conditional Logic</a> and the use of <a target="_blank" href="'+$git+'variable-fields">Variable fields</a> and the <a target="_blank" href="'+$git+'tags-system">{tags} system</a>. These elements can help you to change the aesthetics of your form.</span>',
                        timeout: $timeout_s
                    },
                    {
                        selector: '.super-element.super-form-settings',
                        event: 'click',
                        description: '<h1>Open the "Form Settings" panel to edit form settings</h1>',
                    },
                    {
                        selector: '.super-element.super-form-settings .super-elements-container',
                        description: '<h1>Here you can change all the "Form Settings" which will only apply to this specific form</h1><span class="super-tip">Under [Super Forms > Settings] (WordPress menu) you will find all your global settings that will be applied to all of your forms when creating a new form. After creating a form you can change each of these form settings over here. If both the global setting and form setting are the same the setting will not be saved for the form and instead the global setting will be used now and in the future until they differ from eachother.</span><span class="super-tip"><strong>Important to understand:</strong> If both the global setting and form setting are the same the setting will basically not be saved, but instead the global setting will be used by default now and in the future until they differ from eachother. This means that when you change a global setting at a later time it will affect all previously created forms that where initially setup with this exact same setting. This way you can control all of your forms if required from a global point of view.</span>',
                        timeout: $timeout_s
                    },
                    {
                        selector: '.super-form-settings-tabs > select',
                        event: 'change',
                        showNext: false,
                        description: '<h1>We have devided all form settings into sections which you can choose from via this dropdown, Open the dropdown and switch to a different section to find out about all the other settings that you can change with Super Forms</h1>',
                    },
                    {
                        selector: '.super-element.super-form-settings .super-elements-container',
                        description: '<h1>Great, now you know how to change all the settings related to a specific form!</h1><span class="super-tip">Please note that in some cases you have to change settings under [Super Forms > Settings] (WordPress menu). For instance if you require to setup SMTP you can do it only via the global settings and not individually per form. The same goes for reCAPTCHA API key and secret. For some Add-ons you will also only find the settings under [Super Forms > Settings] and not under the "Form Settings" panel on the builder page.</span>',
                        timeout: $timeout_s
                    },
                    {
                        selector: '.form-name',
                        description: '<h1>Here you can change the name of your form</h1><span class="super-tip">Always choose a name that relates to the purpose of the form itself.</span><span class="super-tip">The "Form name" is for your own reference only, and is not visible to anyone other than you and other WordPress admins.</span>',
                    },
                    {
                        selector: '.super-switch-forms',
                        description: '<h1>Here you can easily switch to a different form that you previously created</h1><span class="super-tip">A list will open with previously created forms to quickly switch to.</span>',
                    },
                    {
                        onBeforeStart: function() {
                            $('.super-switch-forms').removeClass('active');
                        },
                        selector: '.super-get-form-shortcodes',
                        description: '<h1>This is the [shortcode] of your form. You can display your form by copy pasting the shortcode to any of your posts/pages.</h1><span class="super-tip">You can add your shortcode in posts, pages and widgets (e.g: sidebars or in your footer). Anywhere within your site where your theme supports shortcodes you can basically display your fomr. In case you want to read more about how to build and publish your first form you can read the <a target="_blank" href="'+$git+'build">Documentation</a></span>',
                    },
                    {
                        selector: '.super-actions .save',
                        description: '<h1>You can save your form simply by clicking the "Save" button</h1>',
                    },
                    {
                        selector: '.super-actions .clear',
                        description: '<h1>If you want to start with a blank form you can use the "Clear" button</h1><span class="super-tip">Please note that this will erase your current work in progress and will delete all the elements that are currently on the canvas.</span>',
                    },
                    {
                        selector: '.super-actions .delete',
                        onBeforeStart: function() {
                            $('.super-actions .delete').css( 'pointer-events', 'none' );
                        },
                        description: '<h1>Here you can delete your form</h1><span class="super-tip">This will delete the form itself allong with it\'s Elements, Settings and all it\'s backups. It will not delete the associated Contact Entries that where created by the form.</span>',
                    },
                    {
                        onBeforeStart: function() {
                            $('.super-actions .delete').css( 'pointer-events', '' );
                            $('.enjoyhint_close_btn').css('display','none');
                        },
                        selector: '.super-actions .preview.switch',
                        description: '<h1>To see how your form will look on the front-end you can click the "Preview" button</h1><span class="super-tip">You can also preview the form on mobile and tablet devices to test it\'s responsiveness.</span>',
                    },
                    {
                        selector: '.super-actions > label:last',
                        description: '<h1>(For Developers Only) Enable this whenever you require to be able to save a form that has duplicate field names</h1><span class="super-tip">Whenever you are a developer and require the need to save a form that consists of duplicate field names, then you have to enable this setting. By default Super Forms prevents saving a form that contains duplicate field names.</span>',
                    },
                    {
                        selector: '.wp-submenu a[href*="page=super_marketplace"]',
                        description: '<h1>You finished the tutorial! Now you know how to navigate around Super Forms page and create awesome forms with it.<br /><br />Please check out the Marketplace with awesome one click install forms that can get you up and running in no time!</h1><span class="super-tip">We hope you will enjoy the plugin, if you have future questions do not hesitate to contact support!</span><span class="super-tip">Don\'t forget to checkout the <a target="_blank" href="'+$git+'">Documentation</a> whenever you need more information about the plugin and all of it\'s features :)</i></span>',
                        nextButton : {
                            text: "Finish"
                        },
                    },
                ];
                $.each($super_hints_steps, function(key, value){
                    if( typeof value.event === 'undefined')
                        $super_hints_steps[key]['event'] = $event;
                    if( typeof value.showSkip === 'undefined')
                        $super_hints_steps[key]['showSkip'] = $showSkip;
                    if( typeof value.showNext === 'undefined')
                        if($super_hints_steps[key]['event']=='click'){
                            $super_hints_steps[key]['showNext'] = false;
                        }else{
                            $super_hints_steps[key]['showNext'] = $showNext;
                        }
                    if( typeof value.timeout === 'undefined')
                        $super_hints_steps[key]['timeout'] = $timeout;
                    if( typeof value.margin === 'undefined')
                        $super_hints_steps[key]['margin'] = $margin;
                });
                $super_hints.set($super_hints_steps);
                $super_hints.run();
            }
        }

        // @since 4.0.0 - update conditional checks values
        $doc.on('change keydown keyup blur','.super-conditional-check input[type="text"], .super-conditional-check select',function(){
            var $parent = $(this).parents('.super-conditional-check:eq(0)');
            var $value = '';
            $parent.children('input[type="text"], select').each(function(){
                if($(this).index()==0){
                    $value += $(this).val();
                }else{
                    $value += ',' + $(this).val();
                }
            });
            if($value==',') $value = '';
            $parent.children('input[type="hidden"]').val($value);
        });

        // @since 4.0.0 - skip tutorial if checkbox is checked.
        $doc.on('click', '.tutorial-do-not-show-again', function(){
            var $status = $(this).children('input').is(':checked');
            $.ajax({
                type: 'post',
                url: ajaxurl,
                data: {
                    action: 'super_tutorial_do_not_show_again',
                    status: $status
                }
            });
        });
        
        // @since 4.1.0 - switch to a different builder type
        $doc.on('click', '.super-form-builder-actions .super-builder-tabs > span', function(){
            var $button = $(this);
            if($button.hasClass('super-active')) return false;
            $button.addClass('super-loading');
            var $type = $button.attr('data-type');
            SUPER.save_form( $('.super-actions .save'), 2, $type );
        });

        // @since 3.1.0 - backup history
        $doc.on('click', '.super-form-builder-actions .super-backups', function(){
            $('.super-backup-history, .super-first-time-setup-bg').addClass('super-active')
            $('.super-backup-history').addClass('super-loading');
            $.ajax({
                type: 'post',
                url: ajaxurl,
                data: {
                    action: 'super_restore_backup',
                    form_id: $('.super-create-form input[name="form_id"]').val()
                },
                success: function (data) {
                    $('.super-wizard-backup-history > ul').remove();
                    $('.super-wizard-backup-history').find('i').remove();
                    $(data).appendTo($('.super-wizard-backup-history'));
                },
                complete: function(){
                    $('.super-backup-history').removeClass('super-loading');
                }
            });
        });
        $doc.on('click', '.super-wizard-backup-history > ul > li > span', function(){
            $(this).html('Restoring...').addClass('loading');
            $.ajax({
                type: 'post',
                url: ajaxurl,
                data: {
                    action: 'super_restore_backup',
                    form_id: $('.super-create-form input[name="form_id"]').val(),
                    backup_id: $(this).parent('li').attr('data-id')
                },
                success: function (data) {
                    location.reload();
                }
            });
        });
        $doc.on('click', '.super-wizard-backup-history > ul > li > i', function(){
            var $parent = $(this).parents('ul:eq(0)');
            var $delete = confirm(super_create_form_i18n.confirm_deletion);
            if($delete == true) {
                var $backup = $(this).parent();
                $backup.html(super_create_form_i18n.deleting);
                $.ajax({
                    type: 'post',
                    url: ajaxurl,
                    data: {
                        action: 'super_delete_backups',
                        backup_id: $backup.data('id')
                    },
                    success: function (data) {
                        $backup.slideUp("normal", function(){
                            $(this).remove();
                            if($parent.children('li').length==0){
                                $('.super-wizard-backup-history > ul').remove();
                                $('<i>'+super_create_form_i18n.no_backups_found+'</i>').appendTo($('.super-wizard-backup-history'));
                            }
                        });
                    }
                });
            }

        });
        $doc.on('click', '.delete-backups', function(){
            var $old_html = $(this).html();
            var $button = $(this);
            $button.html(super_create_form_i18n.deleting).addClass('loading');
            $.ajax({
                type: 'post',
                url: ajaxurl,
                data: {
                    action: 'super_delete_backups',
                    form_id: $('.super-create-form input[name="form_id"]').val()
                },
                success: function (data) {
                    $('.super-wizard-backup-history > ul').remove();
                    $('<i>'+super_create_form_i18n.no_backups_found+'</i>').appendTo($('.super-wizard-backup-history'));
                    $button.html($old_html).removeClass('loading');
                }
            });
        });

        // @since 4.0.0 - minimize toggle button to toggle all elements minimized or maximize
        $doc.on('click', '.super-form-builder-actions .super-minimize-toggle, .super-form-builder-actions .super-maximize-toggle', function(){
            var $minimize = 'yes';
            if( $(this).hasClass('super-maximize-toggle') ) {
                $minimize = 'no';
            }
            $('.super-preview-elements .super-element').each(function(){
                if( $minimize=='yes' ) {
                    $(this).attr('data-minimized', 'yes').addClass('super-minimized');
                }else{
                    $(this).attr('data-minimized', 'no').removeClass('super-minimized');
                }
            });
            app.init.resize_element_labels();
            app.init.drag_and_drop();
            app.form.update();
        });

        // @since 3.1.0 - undo/redo buttons
        $doc.on('click', '.super-form-builder-actions .super-redo:not(.super-disabled)', function(){
            var $elements = $('textarea[name="_super_elements"].active').next();
            if($elements.index()<0){
                $('.super-form-builder-actions .super-redo').addClass('super-disabled');
                return false;
            }
            $('textarea[name="_super_elements"]').removeClass('active');
            $elements.addClass('active');

            var $button = $(this);
            $button.addClass('super-loading');
            $.ajax({
                type: 'post',
                url: ajaxurl,
                data: {
                    action: 'super_undo_redo',
                    form_id: $('.super-create-form input[name="form_id"]').val(),
                    elements: $elements.val()
                },
                success: function (result) {
                    $('.super-preview .super-preview-elements').html(result);
                    $('.super-form-builder-actions .super-undo').removeClass('super-disabled');
                    if($('textarea[name="_super_elements"].active').index()==($('.super-debug textarea[name="_super_elements"]').length-1)){
                        $('.super-form-builder-actions .super-redo').addClass('super-disabled');
                    }
                    app.init.resize_element_labels();
                },
                complete: function(){
                    $button.removeClass('super-loading');
                }
            });
        });
        $doc.on('click', '.super-form-builder-actions .super-undo:not(.super-disabled)', function(){
            
            var $current = $('textarea[name="_super_elements"].active');
            var $elements = $current.prev();

            // First get index of last element
            var  $last = $('textarea[name="_super_elements"]:last-child').index();

            // If last element index is active, and undo is pressed, skip the previous element
            if( $last==$current.index() ) {
                var $elements = $current.prev().prev();
            }

            if($elements.index()<0){
                $('.super-form-builder-actions .super-undo').addClass('super-disabled');
                return false;
            }
            $('textarea[name="_super_elements"]').removeClass('active');
            $elements.addClass('active');

            var $button = $(this);
            $button.addClass('super-loading');
            $.ajax({
                type: 'post',
                url: ajaxurl,
                data: {
                    action: 'super_undo_redo',
                    form_id: $('.super-create-form input[name="form_id"]').val(),
                    elements: $elements.val()
                },
                success: function (result) {
                    $('.super-preview .super-preview-elements').html(result);
                    $('.super-form-builder-actions .super-redo').removeClass('super-disabled');
                    if($('textarea[name="_super_elements"].active').index()==0){
                        $('.super-form-builder-actions .super-undo').addClass('super-disabled');
                    }
                    app.init.resize_element_labels();
                },
                complete: function(){
                    $button.removeClass('super-loading');
                }
            });
        });


        app.init.drop_here_placeholder();
        app.init.dragable_elements();
        SUPER.init_image_browser();

        $('.super-layout-elements .super-elements-container').css('display','block');

        app.init.resize_element_labels();

        // @since 2.9.0 - Form setup wizard
        $doc.on('click', '.super-theme-style-wizard > li, .super-field-size-wizard > li, .super-theme-hide-icons-wizard > li', function(){
            var $this = $(this);
            var $parent = $this.parent();
            $parent.children('li').removeClass('super-active');
            $this.addClass('super-active');
            var $value = $this.attr('data-value');
            if($parent.hasClass('super-theme-style-wizard')) SUPER.update_wizard_preview($value, null, null, false);
            if($parent.hasClass('super-field-size-wizard')) SUPER.update_wizard_preview(null, $value, null, false);
            if($parent.hasClass('super-theme-hide-icons-wizard')) SUPER.update_wizard_preview(null, null, $value, false);
        });

        $doc.on('click', '.skip-wizard, .super-first-time-setup-bg', function(){
            $('.super-first-time-setup, .super-first-time-setup-bg').removeClass('super-active');
        }); 

        $doc.on('click', '.save-wizard', function(){
            $(this).addClass('loading').html('Saving settings...');
            SUPER.update_wizard_preview(null, null, null, true);
            $('.super-actions .save').trigger('click');
        });
        $doc.on('click', '.super-wizard-settings .super-tabs > li', function(){
            var $index = $(this).index();
            $(this).parent().children('li').removeClass('super-active');
            $(this).addClass('super-active');
            $('.super-wizard-settings .super-tab-content > li').removeClass('super-active');
            $('.super-wizard-settings .super-tab-content > li:eq('+$index+')').addClass('super-active');
        });


        // @since 1.5
        $doc.on('change keyup blur','.super-element.super-element-settings input[name="name"]',function(){
            var $editing = app.get.editing();
            var $tag = $editing.data('shortcode-tag');
            if( $tag!='button' ) {
                var $value = $(this).val().replace(/\s+/gi,'_');
                var $value = $value.replace(/ /g,"_");
                var $value = $value.replace(/\//g,"");
                var $value = $value.replace(/[^a-zA-Z0-9-_\.]+/g,"");
                var $value = $value.replace(/\.+/g, "_");
                var $value = $value.replace(/[--]+/g, "-");
                var $value = $value.replace(/[__]+/g, "_");
                $(this).val($value);

                // @since 3.7.0 - change unique field name on the fly
                $('.super-element.editing .super-title > input').val($value);
            }
        });

        $doc.on('change','.super-create-form .super-element-header .super-element-label > input',function(){
            var $this = $(this);
            var $value = $this.val();
            var $span = $this.parent().children('span');
            $span.html($value);
            $this.attr('value',$value);
            var $width = $span.outerWidth(true);
            $this.parent().css('width', $width+'px').css('margin-left', '-'+($width/2)+'px');
            var $parent = $this.parents('.super-element:eq(0)');
            var $data = $parent.children('textarea[name="element-data"]').val();
            var $tag = $parent.data('shortcode-tag');
            var $data = JSON.parse($data);
            if( ($tag=='column') || ($tag=='multipart') ) {
                $data.label = $value;
            }
            var $data = JSON.stringify($data);
            $parent.children('textarea[name="element-data"]').val($data);
            app.form.update();
        });

        $doc.on('click','.super-element-actions .duplicate',function(){
            var $parent = $(this).parents('.super-element:eq(0)');
            $parent.find('.tooltip').remove();
            var $new = $parent.clone();
            $new.removeClass('super-highlighted');

            // @since 3.7.0 - bug fix remove editing class when duplicating column with active editing element inside
            $new.find('.super-element.editing').removeClass('editing');

            // @since 3.7.0 - automatically rename duplicated fields for more user-friendly work flow
            $new.find('.super-shortcode-field').each(function(){
                var $old_name = $(this).attr('name');
                var $new_field_name = SUPER.generate_new_field_name();
                $(this).attr('name', $new_field_name);
                var $parent = $(this).parents('.super-element:eq(0)');
                $parent.find('.super-title > input').val($new_field_name);
                var $element_data_field = $parent.children('textarea[name="element-data"]');
                var $element_data = $element_data_field.val();
                var $element_data = $element_data.replace('"name":"'+$old_name+'"', '"name":"'+$new_field_name+'"');
                $element_data_field.val($element_data);
            });
            $new.removeClass('editing');
            $new.insertAfter($parent);
            $new.slideUp(0);
            $new.slideDown(300);
            app.init.drag_and_drop();
            app.form.update();
            app.init.generate_first_column_classes(0, 0);
        });

        // @since 3.7.0 - change unique field name on the fly
        var super_title_timeout = null;
        $doc.on('change', '.super-element-title .super-title > input', function(){
            var $this = $(this);
            var $parent = $this.parents('.super-element:eq(0)');
            var $old_name = $parent.find('.super-shortcode-field').attr('name');
            var $new_field_name = $this.val();
            var $new_field_name = $this.val().replace(/\s+/gi,'_');
            var $new_field_name = $new_field_name.replace(/ /g,"_");
            var $new_field_name = $new_field_name.replace(/\//g,"");
            var $new_field_name = $new_field_name.replace(/[^a-zA-Z0-9-_\.]+/g,"");
            var $new_field_name = $new_field_name.replace(/\.+/g, "_");
            var $new_field_name = $new_field_name.replace(/[--]+/g, "-");
            var $new_field_name = $new_field_name.replace(/[__]+/g, "_");
            $this.val($new_field_name);
            $parent.find('.super-shortcode-field').attr('name', $new_field_name);
            var $element_data_field = $parent.children('textarea[name="element-data"]');
            var $element_data = $element_data_field.val();
            var $element_data = $element_data.replace('"name":"'+$old_name+'"', '"name":"'+$new_field_name+'"');
            $element_data_field.val($element_data);
            if($parent.hasClass('editing')){
                $('.super-elements-container .field .element-field[name="name"]').val($new_field_name);
            }
            app.form.update();
        });

        $doc.on('click', '.super-element-actions .minimize', function(){
            var $this = $(this).parents('.super-element:eq(0)');
            var $minimized = $this.attr('data-minimized');
            if( $minimized === 'undefined' ) $minimized = 'no';
            if($minimized=='yes'){
                $this.attr('data-minimized', 'no').removeClass('super-minimized');
            }else{
                $this.attr('data-minimized', 'yes').addClass('super-minimized');
            }
            app.init.resize_element_labels();
            app.init.drag_and_drop();
            app.form.update();
        });
        $doc.on('click', '.super-element-actions .delete', function(){
            $(this).parents('.super-element:eq(0)').next('.super-element').addClass('super-highlighted');
            $(this).parents('.super-element:eq(0)').remove();
            app.init.drag_and_drop();
            app.form.update();
            app.init.generate_first_column_classes(0, 0);
            cancel_update();
        });

        $doc.on('click','.super-switch-forms',function(){
            var $this = $(this);
            if($this.hasClass('active')){
                $this.children('.fa').removeClass('fa-chevron-up').addClass('fa-chevron-down');
                $this.removeClass('active');
                $this.children('ul').slideUp(300);
            }else{
                $this.children('.fa').removeClass('fa-chevron-down').addClass('fa-chevron-up');
                $this.addClass('active');
                $this.children('ul').slideDown(300);
            }
        });
        $doc.on('mouseleave','.super-switch-forms ul',function(){
            var $this = $(this).parent();
            $this.children('.fa').removeClass('fa-chevron-up').addClass('fa-chevron-down');
            $this.removeClass('active');
            $this.children('ul').slideUp(300);
        });

        $doc.on('change','.super-form-settings-tabs > select, .super-element-settings-tabs > select',function(){
            var $parent = $(this).parents('.super-elements-container:eq(0)');
            $parent.children('.tab-content').removeClass('active');
            $parent.children('.tab-content:eq('+($(this).val())+')').addClass('active');

            var $parent = $(this).parents('.super-edit-element-panel:eq(0)');
            $parent.children('.tab-content').removeClass('active');
            $parent.children('.tab-content:eq('+($(this).val())+')').addClass('active');
        });
        
        function cancel_update(){
            $('.super-preview-elements .super-element').removeClass('editing');
            $('.super-element.super-element-settings .super-elements-container').html('<p>'+super_create_form_i18n.not_editing_an_element+'</p>');
        }

        $doc.on('click','.super-element-settings .cancel-update',function(){
            cancel_update();
        });

        $doc.on('click', '.super-checkbox input[type="checkbox"]',function(){
            var $this = $(this);
            var $parent = $this.parents('.super-checkbox:eq(0)');
            var $field = $parent.find('.element-field');
            var $selected = '';
            var $counter = 0;
            $parent.find('input[type="checkbox"]').each(function(){
                if($(this).prop('checked')==true){
                    if($counter==0){
                        $selected += $(this).val();
                    }else{
                        $selected += ','+$(this).val();
                    }
                    $counter++;
                }
            });
            $field.val($selected.toString());
            // Just to fix anoying safari and internet explorer browser issues
            SUPER.init_field_filter_visibility($this.parents('.field:eq(0)'));
        });

        $doc.on('click','.super-elements .super-element h3',function(){
            $(this).parent().children('.super-elements-container').slideToggle();
            $(this).parent().siblings().children().next('.super-elements-container').slideUp();
            return false;
        });
        
        $doc.on('click','.super-create-form .super-actions .clear',function(){
            var $clear = confirm(super_create_form_i18n.confirm_clear_form);
            if($clear == true) {
                $('.super-debug textarea[name="_super_elements"]').val('');
                $('.super-edit-element-panel').removeClass('super-active');
                $('.super-preview-elements > *:not(.super-edit-element-panel)').remove();
                $('.super-element.super-element-settings .super-elements-container').html('<p>'+super_create_form_i18n.not_editing_an_element+'</p>');
            }
        });

        $doc.on('click','.super-create-form .super-actions .delete',function(){
            var $delete = confirm(super_create_form_i18n.confirm_deletion);
            if($delete == true) {
                var $this = $(this);
                $this.html('<i class="fa fa-trash-o"></i>'+super_create_form_i18n.deleting);
                $.ajax({
                    type: 'post',
                    url: ajaxurl,
                    data: {
                        action: 'super_delete_form',
                        id: $('.super-create-form input[name="form_id"]').val(),
                    },
                    success: function (data) {
                        $this.html('<i class="fa fa-check"></i>Deleted!');
                        window.location.href = "edit.php?post_type=super_form";
                    }
                }); 
            }
        });

        $doc.on('click','.super-load-form .load-form',function(){
            var $confirm = confirm(super_create_form_i18n.confirm_load_form);
            if($confirm == true) {
                var $parent = $(this).parent();
                var $value = $('select[name="super-forms"]').val();
                if($value==''){
                    alert(super_create_form_i18n.alert_select_form);
                }else{
                    if(($value%1)===0) {
                        $.ajax({
                            type: 'post',
                            url: ajaxurl,
                            data: {
                                action: 'super_load_form',
                                id: $('select[name="super-forms"]').val(),
                            },
                            success: function (data) {
                                $('textarea[name="_super_elements"]').val(data);
                                app.form.update(2);
                            }
                        });
                    }else{
                        $html = $parent.find('textarea[name="'+$value+'"]').val();
                        $('.super-debug textarea[name="_super_elements"]').html($html);
                        app.form.update(2);
                    }
                }
            }
            return false;
        });    
        




        /*
        $doc.on('click','.super-element-actions .edit',function(){
            var $parent = $(this).parents('.super-element:eq(0)');
            if($parent.hasClass('editing')){
                // But make sure that we open up the edit panel
                $('.super-element.super-element-settings .super-elements-container').show();
                return false;
            }
            var $data = $parent.children('textarea[name="element-data"]').val();
            var $tag = $parent.data('shortcode-tag');
            var $group = $parent.data('group');
            var $data = JSON.parse($data);
            if($tag=='column'){
                $data.size = $parent.attr('data-size');
            }
            var $target = $('.super-element-settings > .super-elements-container');
            $target.html('');
            $('.super-preview-elements .super-element').removeClass('editing');
            $parent.addClass('editing');

            $('.super-element .super-elements-container').hide();
            $('.super-element.super-element-settings .super-elements-container').show().addClass('super-loading');
            $.ajax({
                type: 'post',
                url: ajaxurl,
                data: {
                    action: 'super_load_element_settings',
                    tag: $tag,
                    group: $group,
                    data: $data,
                },
                success: function (data) {
                    $target.html(data);
                    init_form_settings_container_heights();
                },
                complete: function () {
                    SUPER.init_previously_created_fields();
                    SUPER.init_slider_field();
                    SUPER.init_tooltips();
                    SUPER.init_image_browser();
                    SUPER.init_color_pickers();
                    SUPER.init_field_filter_visibility();
                    $('.super-element.super-element-settings .super-elements-container').removeClass('super-loading');
                }
            });
            return false;
        });
        */
        
        $doc.on('click','.super-create-form .super-actions .save',function(){
            var $this = $(this);
            SUPER.save_form($this);
        });

        $doc.on('click','.super-create-form .super-actions .preview',function(){
            var $this = $('.super-create-form .super-actions .preview:eq(3)');
            if($(this).hasClass('mobile')){
                $('.super-live-preview').removeClass('tablet');
                $('.super-create-form .super-actions .preview.tablet').removeClass('active');
                $('.super-create-form .super-actions .preview.desktop').removeClass('active');    
                $(this).addClass('active');
                $('.super-live-preview').addClass('mobile');
                if(!$this.hasClass('active')){
                    $this.html('Loading...');
                    SUPER.save_form($('.super-actions .save'), 1);
                }
                SUPER.init_super_responsive_form_fields();
                return false;
            }
            if($(this).hasClass('tablet')){
                $('.super-live-preview').removeClass('mobile');
                $('.super-create-form .super-actions .preview.mobile').removeClass('active');
                $('.super-create-form .super-actions .preview.desktop').removeClass('active');
                $(this).addClass('active');
                $('.super-live-preview').addClass('tablet');
                if(!$this.hasClass('active')){
                    $this.html('Loading...');
                    SUPER.save_form($('.super-actions .save'), 1);
                }
                SUPER.init_super_responsive_form_fields();
                return false;
            }
            if($(this).hasClass('desktop')){
                $('.super-live-preview').removeClass('tablet');
                $('.super-live-preview').removeClass('mobile');
                $('.super-create-form .super-actions .preview.mobile').removeClass('active');
                $('.super-create-form .super-actions .preview.tablet').removeClass('active');
                $(this).addClass('active');
                if(!$this.hasClass('active')){
                    $this.html('Loading...');
                    SUPER.save_form($('.super-actions .save'), 1);
                }
                SUPER.init_super_responsive_form_fields();
                return false;
            } 
            if(!$this.hasClass('active')){
                $this.html('Loading...');
                SUPER.save_form($('.super-actions .save'), 1);
            }else{
                $('.super-live-preview').css('display','none');
                $('.super-preview-elements').css('display','block');
                $this.html('Preview').removeClass('active');
            }
        });


        // @since 3.8.0 - reset user submission counter
        $doc.on('click','.reset-user-submission-counter', function(){
            var $reset = confirm(super_create_form_i18n.confirm_reset_submission_counter);
            if($reset == true) {
                var $button = $(this);
                $button.addClass('loading');
                $.ajax({
                    type: 'post',
                    url: ajaxurl,
                    data: {
                        action: 'super_reset_user_submission_counter',
                        id: $('.super-create-form input[name="form_id"]').val()
                    },
                    complete: function(){
                        $button.removeClass('loading');
                    }
                });
            }
        });

        // @since 3.4.0 - reset submission counter
        $doc.on('click','.reset-submission-counter', function(){
            var $reset = confirm(super_create_form_i18n.confirm_reset_submission_counter);
            if($reset == true) {
                var $button = $(this);
                $button.addClass('loading');
                $.ajax({
                    type: 'post',
                    url: ajaxurl,
                    data: {
                        action: 'super_reset_submission_counter',
                        counter: $('.super-create-form input[name="form_locker_submission_reset"]').val(),
                        id: $('.super-create-form input[name="form_id"]').val()
                    },
                    complete: function(){
                        $button.removeClass('loading');
                    }
                });
            }
        });
        

        // @since   1.0.6
        $doc.on('focus','.super-get-form-shortcodes',function(){
            var $this = $(this);
            $this.select();
            // Work around Chrome's little problem
            $this.mouseup(function() {
                // Prevent further mouseup intervention
                $this.unbind("mouseup");
                return false;
            });
        });

        // @since 4.0.0 - export single form settings and elements
        $doc.on('click','.super-export-import-single-form .super-export',function(){
            var $button = $(this);
            $button.addClass('loading');

            var $settings = {};
            $('.super-create-form .super-form-settings .element-field').each(function(){
                var $this = $(this);
                var $hidden = false;

                // select parent based on .filter class
                var $parent = $this.parents('.field.filter');
                $parent.each(function(){
                    if($(this).css('display')=='none'){
                        $hidden = true;
                    }
                });

                // now select based on only .field class
                var $parent = $this.parents('.field');
                if($hidden==false){
                    var $name = $this.attr('name');
                    var $value = $this.val();
                    $settings[$name] = $value;
                }
            });
            var $settings = JSON.stringify($settings);

            $.ajax({
                type: 'post',
                url: ajaxurl,
                data: {
                    action: 'super_export_single_form',
                    form_id: $('.super-create-form input[name="form_id"]').val(),
                    elements: $('.super-create-form textarea[name="_super_elements"].active').val(),
                    settings: $settings
                },
                success: function (data) {
                    window.location.href = data;
                },
                error: function(){
                    alert(super_create_form_i18n.export_form_error);
                },
                complete: function(){
                    $button.removeClass('loading');
                }
            });
        });

        // @since 4.0.0 - import single form settings and elements
        $doc.on('click','.super-export-import-single-form .super-import',function(){
            var $confirm = confirm(super_create_form_i18n.confirm_import);
            if($confirm == true) {
                var $button = $(this);
                var $parent = $button.parents('.field:eq(0)');
                var $form_id = $('.super-create-form input[name="form_id"]').val();

                var $file_id = $parent.find('.file-preview > li').attr('data-file');
                if(typeof $file_id === 'undefined'){
                    alert(super_create_form_i18n.import_form_choose_file);
                    return false;
                }

                var $settings = $parent.find('input[name="import-settings"]').is(':checked');
                var $elements = $parent.find('input[name="import-elements"]').is(':checked');
                if($settings == false && $elements == false){
                    alert(super_create_form_i18n.import_form_select_option);
                    return false;
                }

                $button.addClass('loading');
                $.ajax({
                    type: 'post',
                    url: ajaxurl,
                    data: {
                        action: 'super_import_single_form',
                        form_id: $form_id,
                        file_id: $file_id,
                        settings: $settings,
                        elements: $elements
                    },
                    success: function (data) {
                        var data = $.parseJSON(data);
                        if( data.error ) {
                            alert(data.error);
                        }else{
                            if( $form_id==0 ) {
                                window.location.href = "admin.php?page=super_create_form&id="+data;
                            }else{
                                location.reload();
                            }
                        }
                    },
                    error: function(){
                        alert(super_create_form_i18n.import_form_error);
                    }
                });
            }
        });
        
        // @since 4.0.0 - reset single form settings
        $doc.on('click','.super-export-import-single-form .super-reset-global-settings',function(){
            var $confirm = confirm(super_create_form_i18n.confirm_reset);
            if($confirm == true) {
                var $button = $(this);
                $button.addClass('loading');
                $.ajax({
                    type: 'post',
                    url: ajaxurl,
                    data: {
                        action: 'super_reset_form_settings',
                        form_id: $('.super-create-form input[name="form_id"]').val(),
                    },
                    success: function(data){
                        var href = window.location.href;
                        var page = href.substr(href.lastIndexOf('/') + 1);
                        var str2 = "admin.php?page=super_create_form&id";
                        if(page.indexOf(str2) == -1){
                            window.location.href = "admin.php?page=super_create_form&id="+data;
                        }else{
                            location.reload();
                        }
                    },
                    complete: function(){
                        $button.removeClass('loading');
                    }
                });
            }
        });

        // @since   1.0.6
        var $window = $(window).outerHeight(true);
        var $header = $('.super-header').outerHeight(true);
        var $viewport = $window-$header;    
        var $offset = $('.super-create-form .super-elements').offset().top;
        var $elements = $('.super-create-form .super-elements');
        var timer;
        $(window).on('load scroll resize', function() {
            var $width = $elements.outerWidth(true);
            init_form_settings_container_heights();
            var $window_width = $(window).outerWidth(true);
            if($window_width >= 983){ 
                var $scroll = $(window).scrollTop(); 
                if($scroll > 40){
                    $('.super-create-form .super-elements').css('max-width', $width+'px');
                    $('.super-create-form').addClass('sticky');
                }else{
                    $('.super-create-form .super-elements').css('max-width','');
                    $('.super-create-form').removeClass('sticky');
                }
            }else{
                $('.super-create-form .super-elements').css('max-width','');
                $('.super-create-form').removeClass('sticky');
            }
        });
        function init_form_settings_container_heights(){
            var $window_height = $(window).outerHeight(true);
            var $wp_admin_bar = $('#wpadminbar').outerHeight(true) + 55;
            var $offset_top = $('.super-create-form').offset().top;
            var $tabs_height = 0;
            var $container_padding = 50;
            var $settings_tab = 20;
            $('.super-create-form .super-elements > .super-element h3').each(function(){
                $tabs_height = $(this).outerHeight(true) + $tabs_height;  
            });
            var $max_height = $window_height - $tabs_height - $wp_admin_bar - $offset_top;
            $('.super-element-settings > .super-elements-container > .tab-content').css('max-height',$max_height-$settings_tab-$container_padding);
            $('.super-form-settings > .super-elements-container > .tab-content').css('max-height',$max_height-$settings_tab-$container_padding);
            $('.super-form-elements > .super-elements-container').css('max-height',$max_height); 
            $('.super-shortcode-fields .tabs_content').css('max-height',($window_height/2));  
        }
    });
})(jQuery);


