<?php

/*
 * Plugin Name: SUMO Reward Points
 * Plugin URI:
 * Description: SUMO Reward Points is a WooCommerce Loyalty Reward System using which you can Reward your Customers using Reward Points for Purchasing Products, Writing Reviews, Sign up on your site etc
 * Version:21.9
 * Author: اسکریپت دات کام
 * Author URI:http://www.اسکریپت.com
 * WC requires at least: 3.0.0
 * WC tested up to: 3.5.1
 */

if ( ! defined( 'ABSPATH' ) ) {
    exit ; // Exit if accessed directly.
}
if ( ! class_exists( 'FPRewardSystem' ) ) {

    class FPRewardSystem {
        /*
         * SUMO Reward System Version
         *  @var $string 
         */

        public $version = '21.9' ;

        /*
         * @var FPRewardSystem
         */
        protected static $_instance = null ;

        /*
         * Variable to get from email
         */
        public static $rs_from_email_address ;

        /*
         * Variable to get from name
         */
        public static $rs_from_name ;

        /*
         * Load Reward System Class in Single Instance
         */

        public static function instance() {
            if ( is_null( self::$_instance ) ) {
                self::$_instance = new self() ;
            }
            return self::$_instance ;
        }

        /* Cloning has been forbidden */

        public function __clone() {
            _doing_it_wrong( __FUNCTION__ , __( 'You are not allowed to perform this action!!!' , 'rewardsystem' ) , $this->version ) ;
        }

        /*
         * Unserialize the class data has been forbidden
         */

        public function __wakeup() {
            _doing_it_wrong( __FUNCTION__ , __( 'You are not allowed to perform this action!!!' , 'rewardsystem' ) , $this->version ) ;
        }

        /*
         * Reward System Constructor
         */

        public function __construct() {
            /* Include once will help to avoid fatal error by load the files when you call init hook */
            include_once( ABSPATH . 'wp-admin/includes/plugin.php' ) ;
            $this->header_already_sent_problem() ;
            /* Display warning if woocommerce is not active */
            add_action( 'init' , array( $this , 'woocommerce_dependency_warning_message' ) ) ;
            if ( ! $this->if_woocommerce_is_active() )
                return ;

            $this->rs_translate_file() ;
            $this->list_of_constants() ;
            include_once('includes/class-rs-install.php') ;
            include_once('woocommerce-log/class-fp-woocommerce-log.php') ;
            include_once('backgroundprocess/rs-main-file-for-background-process.php') ;
            //Compatability for GDPR Compliance
            include_once('includes/gdpr/class-srp-privacy.php') ;
            add_action( 'init' , array( $this , 'include_files' ) ) ;
            include('includes/frontend/class-rs_menu_query.php') ;
            add_action( 'wp_enqueue_scripts' , array( $this , 'wp_enqueue_script' ) ) ;
            add_action( 'admin_enqueue_scripts' , array( $this , 'admin_enqueue_script' ) ) ;
            $this->init_hooks() ;
            /* Load WooCommerce Enqueue Script to Load the Script and Styles by filtering the WooCommerce Screen IDS */
            if ( isset( $_GET[ 'page' ] ) ) {
                if ( ($_GET[ 'page' ] == 'rewardsystem_callback' ) ) {
                    add_filter( 'woocommerce_screen_ids' , array( $this , 'reward_system_load_default_enqueues' ) , 9 , 1 ) ;
                }
            }
            $this->rewardgateway() ;
        }

        /*
         * Function to Prevent Header Error that says You have already sent the header.
         */

        public function header_already_sent_problem() {
            ob_start() ;
        }

        /*
         * Function to check wheather Woocommerce is active or not
         */

        public function if_woocommerce_is_active() {

            if ( is_multisite() && ! is_plugin_active_for_network( 'woocommerce/woocommerce.php' ) && ! is_plugin_active( 'woocommerce/woocommerce.php' ) ) {
                return false ;
            } else if ( ! is_plugin_active( 'woocommerce/woocommerce.php' ) ) {
                return false ;
            }
            return true ;
        }

        /** Call this function in the 'init' hook.* */
        public function woocommerce_dependency_warning_message() {

            if ( ! $this->if_woocommerce_is_active() && is_admin() ) {
                $error = "<div class='error'><p> SUMO Reward Points requires WooCommerce Plugin should be Active !!! </p></div>" ;
                echo $error ;
            }
            return ;
        }

        /*
         * @var $list_of_constants in a array
         */

        public function list_of_constants() {
            $verison       = '1' ;
            $plugin_folder = get_plugins( '/' . 'rewardsystem' ) ;
            $plugin_file   = 'rewardsystem.php' ;
            if ( isset( $plugin_folder[ $plugin_file ][ 'Version' ] ) ) {
                $verison = $plugin_folder[ $plugin_file ][ 'Version' ] ;
            }
            $list_of_constants = apply_filters( 'fprewardsystem_constants' , array(
                'SRP_VERSION'                  => $verison ,
                'REWARDSYSTEM_PLUGIN_BASENAME' => plugin_basename( __FILE__ ) ,
                'REWARDSYSTEM_PLUGIN_FILE'     => __FILE__ ,
                'REWARDSYSTEM_PLUGIN_DIR_URL'  => plugin_dir_url( __FILE__ ) ,
                'REWARDSYSTEM_ADMIN_AJAX_URL'  => admin_url( 'admin-ajax.php' ) ,
                    ) ) ;
            if ( is_array( $list_of_constants ) && ! empty( $list_of_constants ) ) {
                foreach ( $list_of_constants as $constantname => $value ) {
                    $this->define_constant( $constantname , $value ) ;
                }
            }
        }

        /*
         * Include Files 
         */

        public function include_files() {
            //welcome page include file
            include_once 'admin/welcome.php' ;
            //WP_List Table Files
            include_once('admin/wpliststable/class_wp_list_table_for_newgift_voucher.php') ;
            include_once('admin/wpliststable/class_wp_list_table_view_gift_voucher.php') ;
            include_once('admin/wpliststable/class_wp_list_table_for_nominee_user_list.php') ;
            include_once('admin/wpliststable/class_wp_list_table_for_users.php') ;
            include_once('admin/wpliststable/class_wp_list_table_master_log.php') ;
            include_once('admin/wpliststable/class_wp_list_table_referral_table.php') ;
            include_once('admin/wpliststable/class_wp_list_table_view_log_user.php') ;
            include_once('admin/wpliststable/class_wp_list_table_view_referral_table.php') ;
            include_once('includes/frontend/compatibility/rewardpoints_wc2point6.php') ;
            include_once('includes/class_wpml_support.php') ;
            include_once('includes/rewardsystem-core-functions.php') ;
            if ( is_admin() ) {
                $this->include_admin_files() ;
            }
            $allow_earn_points = allow_reward_points_for_user( get_current_user_id() ) ;
            if ( ( ! is_admin() || defined( 'DOING_AJAX' )) && ($allow_earn_points) ) {
                $this->include_frontend_files() ;
            }
            include('includes/frontend/rs_referral_log_count.php') ;
            include('includes/frontend/rs_function_for_member_level.php') ;
            include('includes/frontend/rs_function_to_apply_coupon.php') ;
            include('includes/frontend/rs_function_for_order_tab.php') ;
            include('includes/frontend/rs_function_for_sms_tab.php') ;
            include_once('includes/frontend/rs_function_for_saving_meta_values.php') ;
            include_once('includes/frontend/rs_jquery.php') ;
            include_once('includes/class-reward-points-orders.php') ;
            include_once('includes/main_functions_for_point_expiry.php') ;
            include('includes/frontend/rs_function_for_coupon_reward_point_tab.php') ;
            include('includes/frontend/rs_free_product_main_function.php') ;
        }

        /*
         * Include Admin Files
         */

        public function include_admin_files() {
            if ( isset( $_GET[ 'page' ] ) && ($_GET[ 'page' ] == 'rewardsystem_callback') ) {
                include_once('admin/css/rewardsystem-settings-styles.php') ;
            }
            include_once('admin/js/rs_section_expand.php') ;
            include_once('admin/class-reward-system-tab-management.php') ;
            include_once('admin/tabs/class-general-setting.php') ;
            include_once('admin/tabs/class-modules-tab.php') ;
            include_once('admin/tabs/class-add-remove-points-tab.php') ;
            include_once('admin/tabs/class-message-setting.php') ;
            include_once('admin/tabs/class-localization-setting.php') ;
            include_once('admin/tabs/class-user-reward-points-tab.php') ;
            include_once('admin/tabs/class-masterlog-tab.php') ;
            include_once('admin/tabs/class-shortcode-tab.php') ;
            include_once('admin/tabs/class-advanced-setting.php') ;
            include_once('admin/tabs/class-support-tab.php') ;
            /* Modules for Reward Points - Start */
            include_once('admin/tabs/class-product-purchase-tab.php') ;
            include_once('admin/tabs/class-referral-system-tab.php') ;
            include_once('admin/tabs/class-social-rewards-setting.php') ;
            include_once('admin/tabs/class-reward-points-for-action-setting.php') ;
            include_once('admin/tabs/class-point-expiry-module-tab.php') ;
            include_once('admin/tabs/class-redeeming-module-tab.php') ;
            include_once('admin/tabs/class-point-price-module-tab.php') ;
            include_once('admin/tabs/class-email-expired-points-tab.php') ;
            include_once('admin/tabs/class-email-tab.php') ;
            include_once('admin/tabs/class-gift-voucher-tab.php') ;
            include_once('admin/tabs/class-sms-setting.php') ;
            include_once('admin/tabs/class-cashback-module-tab.php') ;
            include_once('admin/tabs/class-nominee-setting.php') ;
            include_once('admin/tabs/class-point-url-setting.php') ;
            include_once('admin/tabs/class-rewardpoints-gateway-tab.php') ;
            include_once('admin/tabs/class-send-points-tab.php') ;
            include_once('admin/tabs/class-import-export-tab.php') ;
            include_once('admin/tabs/class-reports-in-csv-tab.php') ;
            include_once('admin/tabs/class-reset-setting.php') ;
            //product/product category settings
            include_once('admin/settings/class-simple-product-settings.php') ;
            include_once('admin/settings/class-variable-product-settings.php') ;
            include_once('admin/settings/class-category-product-settings.php') ;
            include_once('admin/settings/class-buying-reward-points.php') ;
            //admin related js files
            include_once('admin/class-admin-enqueues.php') ;
            include('admin/wc_class_encashing_wplist.php') ;
            include('admin/wc_class_send_point_wplist.php') ;

            //Include show/hide earned redeemed message
            if ( class_exists( 'WooCommerce_PDF_Invoices' ) )
                include('includes/woocommerce-pdf-invoices-packing-slips.php') ;
        }

        /*
         * Include Admin Files
         */

        public function include_frontend_files() {
            include('includes/frontend/rs_function_for_general_tab.php') ;
            include('includes/frontend/rs_function_for_shoppage_tab.php') ;
            include('includes/frontend/rs_function_for_singleproductpage_tab.php') ;
            include('includes/frontend/rs_function_for_cart_tab.php') ;
            include('includes/frontend/rs_function_for_checkout.php') ;
            include('includes/frontend/rs_function_for_myaccount_tab.php') ;
            include('includes/frontend/rs_function_for_message_tab.php') ;
            include('includes/frontend/rs_function_for_advanced_tab.php') ;
            include('includes/frontend/rs_function_for_referral_system_tab.php') ;
            include('includes/frontend/rs_function_for_refer_a_friend.php') ;
            include('includes/frontend/rs_function_for_social_reward_tab.php') ;
            include('includes/frontend/rs_function_for_email_template.php') ;
            include('includes/frontend/rs_function_for_mail_tab.php') ;
            include('includes/frontend/rs_function_for_gift_voucher_tab.php') ;
            include('includes/frontend/rs_function_for_new_gift_voucher.php') ;
            include('includes/frontend/rs_function_for_form_for_cash_back.php') ;
            include('includes/frontend/rs_function_for_manual_referral_link_tab.php') ;
            include('includes/frontend/rs_function_for_send_points.php') ;
            include('includes/frontend/rs_function_for_nominee.php') ;
            include('includes/frontend/rs_function_for_pointurl_tab.php') ;
            include('includes/frontend/rs_wc_booking_compatabilty.php') ;
            include('includes/frontend/rs_price_rule_checker_for_variant.php') ;
            include('includes/frontend/rs_function_to_add_registration_points.php') ;
            include('includes/class-simple-product.php') ;
            include('includes/class-variable-product.php') ;
            if ( class_exists( 'BuddyPress' ) ) {
                include('includes/frontend/rs_buddypress_compatibility.php') ;
            }
        }

        public function rewardgateway() {
            if ( get_option( 'rs_gateway_activated' ) == 'yes' ) {
                include('admin/class_rewardgateway.php') ;
                add_action( 'plugins_loaded' , 'init_reward_gateway_class' ) ;
            }
        }

        public function init_hooks() {
            global $wpdb ;
            $redirect   = true ;
            $table_name = $wpdb->prefix . 'rspointexpiry' ;

            if ( (get_option( 'rs_upgrade_success' ) != 'yes' ) && ( ! RSInstall::rs_check_table_exists( $table_name )) && (get_option( 'rs_new_update_user' ) != true) && RS_Main_Function_for_Background_Process::fp_rs_upgrade_file_exists() ) {
                register_activation_hook( __FILE__ , array( 'RS_Main_Function_for_Background_Process' , 'rs_initiate_to_background_process' ) ) ;
                $redirect = false ;
            }

            register_activation_hook( __FILE__ , array( 'RSInstall' , 'install' ) ) ;

            if ( $redirect )
                register_activation_hook( __FILE__ , array( 'FPRewardSystem' , 'sumo_reward_points_welcome_screen_activate' ) ) ;
        }

        // welcome page function
        public static function sumo_reward_points_welcome_screen_activate() {
            set_transient( '_welcome_screen_activation_redirect_reward_points' , true , 30 ) ;
        }

        /*
         * Translate File
         * 
         */

        public function rs_translate_file() {
            load_plugin_textdomain( 'rewardsystem' , false , dirname( plugin_basename( __FILE__ ) ) . '/languages' ) ;
        }

        /*
         * Define Constant
         * @param string $name
         * @param string|bool $value
         */

        protected function define_constant( $name , $value ) {
            if ( ! defined( $name ) ) {
                define( $name , $value ) ;
            }
        }

        /*
         * Load the Default JAVASCRIPT and CSS
         */

        public function reward_system_load_default_enqueues() {
            global $my_admin_page ;
            $newscreenids = get_current_screen() ;
            if ( isset( $_GET[ 'page' ] ) ) {
                if ( ($_GET[ 'page' ] == 'rewardsystem_callback' ) ) {
                    $array[] = $newscreenids->id ;
                    return $array ;
                } else {
                    $array[] = '' ;
                    return $array ;
                }
            }
        }

        public static function check_banning_type( $UserId ) {
            $BannedUserForEarning   = self::ban_user_from_earning( $UserId ) ;
            $BannedUserForRedeeming = self::ban_user_from_redeeming( $UserId ) ;
            if ( ! $BannedUserForEarning && ! $BannedUserForRedeeming )
                return "no_banning" ;

            if ( ! $BannedUserForEarning && $BannedUserForRedeeming )
                return 'redeemingonly' ;

            if ( $BannedUserForEarning && ! $BannedUserForRedeeming )
                return 'earningonly' ;

            if ( $BannedUserForEarning && $BannedUserForRedeeming )
                return 'both' ;
        }

        public static function ban_user_from_earning( $UserId ) {
            $BanEarning = get_option( 'rs_enable_banning_users_earning_points' ) ;
            if ( $BanEarning == 'no' )
                return false ;

            $BannedUserListForEarning = get_option( 'rs_banned_users_list_for_earning' ) ;
            $BannedUserRoleForEarning = get_option( 'rs_banning_user_role_for_earning' ) ;
            if ( ! is_array( $BannedUserListForEarning ) )
                $BannedUserListForEarning = ($BannedUserListForEarning != '') ? explode( ',' , $BannedUserListForEarning ) : array() ;

            if ( empty( $BannedUserListForEarning ) && empty( $BannedUserRoleForEarning ) )
                return false ;

            if ( in_array( $UserId , $BannedUserListForEarning ) ) {
                return true ;
            } else {
                $UserData   = get_userdata( $UserId ) ;
                $RoleofUser = is_object( $UserData ) ? $UserData->roles[ 0 ] : 'guest' ;
                if ( in_array( $RoleofUser , ( array ) $BannedUserRoleForEarning ) )
                    return true ;
            }

            return false ;
        }

        public static function ban_user_from_redeeming( $UserId ) {
            $BanRedeeming = get_option( 'rs_enable_banning_users_redeeming_points' ) ;
            if ( $BanRedeeming == 'no' )
                return false ;

            $BannedUserListForRedeeming = get_option( 'rs_banned_users_list_for_redeeming' ) ;
            $BannedUserRoleForRedeeming = get_option( 'rs_banning_user_role_for_redeeming' ) ;
            if ( ! is_array( $BannedUserListForRedeeming ) )
                $BannedUserListForRedeeming = ($BannedUserListForRedeeming != '') ? explode( ',' , $BannedUserListForRedeeming ) : array() ;

            if ( empty( $BannedUserListForRedeeming ) && empty( $BannedUserRoleForRedeeming ) )
                return false ;

            if ( in_array( $UserId , $BannedUserListForRedeeming ) ) {
                return true ;
            } else {
                $UserData   = get_userdata( $UserId ) ;
                $RoleofUser = is_object( $UserData ) ? $UserData->roles[ 0 ] : 'guest' ;
                if ( in_array( $RoleofUser , ( array ) $BannedUserRoleForRedeeming ) )
                    return true ;
            }

            return false ;
        }

        // welcome page register css file
        public function admin_enqueue_script() {
            global $post ;
            if ( isset( $_GET[ 'page' ] ) && $_GET[ 'page' ] == 'sumo-reward-points-welcome-page' ) {
                wp_register_style( 'wp_reward_welcome_page' , REWARDSYSTEM_PLUGIN_DIR_URL . "admin/css/rewardpoints_welcome_page_style.css" ) ;
                wp_enqueue_style( 'wp_reward_welcome_page' ) ;
            }
            if ( isset( $_GET[ 'page' ] ) && ($_GET[ 'page' ] == 'rewardsystem_callback') ) {
                wp_register_script( 'admin_settings_js' , REWARDSYSTEM_PLUGIN_DIR_URL . "admin/js/sumo-admin-settings-design.js" ) ;
                wp_enqueue_script( 'admin_settings_js' ) ;
            }

            if ( class_exists( 'BuddyPress' ) && isset( $_GET[ 'section' ] ) && ($_GET[ 'section' ] == 'rewardsystem_reward_points_for_action') ) {
                wp_register_script( 'rs_buddypress_settings_js' , REWARDSYSTEM_PLUGIN_DIR_URL . "admin/js/fp-srp-actions-tab.js" ) ;
                wp_enqueue_script( 'rs_buddypress_settings_js' ) ;
            }
            $sumo_bookings_check = false ;
            if ( isset( $post->ID ) && isset( $post->post_type ) ) {
                if ( $post->post_type == 'product' ) {
                    $sumo_bookings_check = rs_sumo_bookings_active( $post->ID ) ;
                }
            }
            $localize_script = array(
                'ajaxurl'                      => REWARDSYSTEM_ADMIN_AJAX_URL ,
                'rs_rule_for_cus_reg_fields'   => wp_create_nonce( 'rule-for-cus-reg-fields' ) ,
                'point_price_bulk_update'      => wp_create_nonce( 'points-price-bulk-update' ) ,
                'product_purchase_bulk_update' => wp_create_nonce( 'product-purchase-bulk-update' ) ,
                'rs_unsubscribe_email'         => wp_create_nonce( 'unsubscribe-mail' ) ,
                'rs_reset_tab'                 => wp_create_nonce( 'rs-reset-tab' ) ,
                'rs_reset_previous_order_meta' => wp_create_nonce( 'reset-previous-order-meta' ) ,
                'rs_reset_data_for_user'       => wp_create_nonce( 'reset-data-for-user' ) ,
                'buying_reward_bulk_update'    => wp_create_nonce( 'buying-reward-bulk-update' ) ,
                'social_reward_bulk_update'    => wp_create_nonce( 'social-reward-bulk-update' ) ,
                'reset_confirm_msg'            => __( 'Are you sure want to Reset?' , 'rewardsystem' ) ,
                'field_ids'                    => '#_rewardsystem_assign_buying_points[type=text],#_rewardsystempoints[type=text],#_rewardsystempercent[type=text],'
                . '#_referralrewardsystempoints[type=text],#_referralrewardsystempercent[type=text],#_socialrewardsystempoints_facebook[type=text],'
                . '#_socialrewardsystempercent_facebook[type=text],#_socialrewardsystempoints_twitter[type=text],'
                . '#_socialrewardsystempercent_twitter[type=text],#_socialrewardsystempoints_google[type=text],#_socialrewardsystempercent_google[type=text],'
                . '#_socialrewardsystempoints_vk[type=text],#_socialrewardsystempercent_vk[type=text],#rs_max_earning_points_for_user[type=text],'
                . '#rs_earn_point[type=text],#rs_earn_point_value[type=text],#rs_redeem_point[type=text],#rs_redeem_point_value[type=text],'
                . '#rs_fixed_max_redeem_discount[type=text],#rs_global_reward_points[type=text],#rs_global_referral_reward_point[type=text],'
                . '#rs_global_reward_percent[type=text],#rs_global_referral_reward_percent[type=text],#rs_referral_cookies_expiry_in_days[type=text],'
                . '#rs_referral_link_limit[type=text],'
                . '#rs_referral_cookies_expiry_in_min[type=text],#rs_referral_cookies_expiry_in_hours[type=text],'
                . '#_rs_select_referral_points_referee_time_content[type=text],#rs_percent_max_redeem_discount[type=text],#rs_point_to_be_expire[type=number],'
                . '#rs_fixed_max_earn_points[type=text],#rs_percent_max_earn_points[type=text],#rs_reward_signup[type=text],'
                . '#rs_reward_product_review[type=text],#rs_referral_reward_signup[type=text],#rs_reward_points_for_login[type=text],'
                . '#rs_reward_user_role_administrator[type=text],#rs_reward_user_role_editor[type=text],#rs_reward_user_role_author[type=text],'
                . '#rs_reward_user_role_contributor[type=text],#rs_reward_user_role_subscriber[type=text],#rs_reward_user_role_customer[type=text],'
                . '#rs_reward_user_role_shop_manager[type=text],#rs_reward_addremove_points[type=text],#rs_percentage_cart_total_redeem[type=text],'
                . '#rs_first_time_minimum_user_points[type=text],#rs_minimum_user_points_to_redeem[type=text],#rs_minimum_redeeming_points[type=text],'
                . '#rs_maximum_redeeming_points[type=text],#rs_minimum_cart_total_points[type=text],#rs_percentage_cart_total_redeem_checkout[type=text],'
                . '#rs_local_reward_points[type=text],#rs_local_reward_percent[type=text],#rs_local_referral_reward_point[type=text],'
                . '#rs_local_referral_reward_percent[type=text],#rs_local_reward_points_facebook[type=text],#rs_local_reward_percent_facebook[type=text],'
                . '#rs_local_reward_points_twitter[type=text],#rs_local_reward_percent_twitter[type=text],#rs_local_reward_points_google[type=text],'
                . '#rs_local_reward_percent_google[type=text],#rs_local_reward_points_vk[type=text],#rs_local_reward_percent_vk[type=text],'
                . '#rs_global_social_facebook_reward_points[type=text],#rs_global_social_facebook_reward_percent[type=text],'
                . '#rs_global_social_twitter_reward_points[type=text],#rs_global_social_twitter_reward_percent[type=text],'
                . '#rs_global_social_google_reward_points[type=text],#rs_global_social_google_reward_percent[type=text],'
                . '#rs_global_social_vk_reward_points[type=text],#rs_global_social_vk_reward_percent[type=text],'
                . '#rs_global_social_facebook_reward_points_individual[type=text],#rs_global_social_facebook_reward_percent_individual[type=text],'
                . '#rs_global_social_twitter_reward_points_individual[type=text],#rs_global_social_twitter_reward_percent_individual[type=text],'
                . '#rs_global_social_google_reward_points_individual[type=text],#rs_global_social_google_reward_percent_individual[type=text],'
                . '#rs_global_social_vk_reward_points_individual[type=text],#rs_global_social_vk_reward_percent_individual[type=text],'
                . '#earningpoints[type=text],#rs_minimum_edit_userpoints[type=text],#rs_minimum_userpoints[type=text],#redeemingpoints[type=text],'
                . '#rs_mail_cron_time[type=text],#rs_point_voucher_reward_points[type=text],#rs_point_bulk_voucher_points[type=text],'
                . '#rs_minimum_points_encashing_request[type=text],#rs_maximum_points_encashing_request[type=text],#_reward_points[type=text],'
                . '#_reward_percent[type=text],#_referral_reward_points[type=text],#_referral_reward_percent[type=text],#rs_category_points[type=text],'
                . '#rs_category_percent[type=text],#referral_rs_category_points[type=text],#referral_rs_category_percent[type=text],'
                . '#social_facebook_rs_category_points[type=text],#social_facebook_rs_category_percent[type=text],'
                . '#social_twitter_rs_category_points[type=text],#social_twitter_rs_category_percent[type=text],#social_google_rs_category_points[type=text],'
                . '#social_google_rs_category_percent[type=text],#social_vk_rs_category_points[type=text],#social_vk_rs_category_percent[type=text]' ,
                'sumo_booking'                 => $sumo_bookings_check ,
                    ) ;
            $deps            = array() ;
            $verison         = '1' ;
            $plugin_folder   = get_plugins( '/' . 'rewardsystem' ) ;
            $plugin_file     = 'rewardsystem.php' ;
            if ( isset( $plugin_folder[ $plugin_file ][ 'Version' ] ) ) {
                $verison = $plugin_folder[ $plugin_file ][ 'Version' ] ;
            }
            wp_enqueue_script( 'adminscripts' , REWARDSYSTEM_PLUGIN_DIR_URL . "admin/js/adminscripts.js" , $deps , $verison ) ;
            wp_localize_script( 'adminscripts' , 'adminscripts_params' , $localize_script ) ;
        }

        public function wp_enqueue_script() {
            wp_register_script( 'wp_reward_footable' , REWARDSYSTEM_PLUGIN_DIR_URL . "admin/js/footable.js" ) ;
            wp_register_script( 'wp_reward_footable_sort' , REWARDSYSTEM_PLUGIN_DIR_URL . "admin/js/footable.sort.js" ) ;
            wp_register_script( 'wp_reward_footable_paging' , REWARDSYSTEM_PLUGIN_DIR_URL . "admin/js/footable.paginate.js" ) ;
            wp_register_script( 'wp_reward_footable_filter' , REWARDSYSTEM_PLUGIN_DIR_URL . "admin/js/footable.filter.js" ) ;
            wp_register_style( 'wp_reward_footable_css' , REWARDSYSTEM_PLUGIN_DIR_URL . "admin/css/footable.core.css" ) ;
            wp_register_style( 'wp_reward_bootstrap_css' , REWARDSYSTEM_PLUGIN_DIR_URL . "admin/css/bootstrap.css" ) ;
            wp_register_style( 'wp_reward_facebook' , REWARDSYSTEM_PLUGIN_DIR_URL . "admin/css/style.css" ) ;
            wp_enqueue_script( 'jquery' ) ;
            wp_enqueue_script( 'wp_reward_facebook' ) ;
            wp_enqueue_script( 'wp_reward_footable' ) ;
            wp_enqueue_script( 'wp_reward_footable_sort' ) ;
            wp_enqueue_script( 'wp_reward_footable_paging' ) ;
            wp_enqueue_script( 'wp_reward_footable_filter' ) ;
            wp_enqueue_style( 'wp_reward_footable_css' ) ;
            wp_enqueue_style( 'wp_reward_bootstrap_css' ) ;
            $suffix      = defined( 'SCRIPT_DEBUG' ) && SCRIPT_DEBUG ? '' : '.min' ;
            wp_register_script( 'wc-enhanced-select' , WC()->plugin_url() . '/assets/js/admin/wc-enhanced-select' . $suffix . '.js' , array( 'jquery' , 'select2' ) , WC_VERSION ) ;
            wp_localize_script( 'wc-enhanced-select' , 'wc_enhanced_select_params' , array(
                'ajax_url'               => admin_url( 'admin-ajax.php' ) ,
                'search_customers_nonce' => wp_create_nonce( 'search-customers' )
            ) ) ;
            wp_enqueue_script( 'wc-enhanced-select' ) ;
            wp_enqueue_script( 'select2' ) ;
            $assets_path = str_replace( array( 'http:' , 'https:' ) , '' , WC()->plugin_url() ) . '/assets/' ;
            wp_enqueue_style( 'select2' , $assets_path . 'css/select2.css' ) ;
            wp_enqueue_script( 'fp_frontend_scripts' , REWARDSYSTEM_PLUGIN_DIR_URL . "admin/js/fp-srp-frontend.js" ) ;
        }

    }

    FPRewardSystem::instance() ;
}