<?php
if ( ! defined( 'ABSPATH' ) ) {
    exit ; // Exit if accessed directly.
}

function display_custom_message_in_point_can_earned( $OrderTotal , $points_info , $message , $reward_value , $eq_price_enable , $custom_msg_enable , $custom_msg , $payment_plan_pts ) {
    $Setup               = get_option( 'rs_enable_product_category_level_for_product_purchase' ) ;
    $RewardPointsBasedOn = get_option( 'rs_award_points_for_cart_or_product_total' ) ;
    if ( $Setup == 'no' && $RewardPointsBasedOn == '2' ) {
        $EnableCartTotalBasedRewardPoints = get_option( 'rs_enable_cart_total_reward_points' ) ;
        if ( $EnableCartTotalBasedRewardPoints == '1' )
            $message                          .= $OrderTotal ;
    } else {
        if ( is_array( $points_info ) ) {
            $message .= round_off_type( array_sum( $points_info ) ) . '&nbsp;' ;
        } else {
            $message .= round_off_type( $points_info ) . '&nbsp;' ;
        }
    }
    $message = ( float ) $message - ( float ) $payment_plan_pts ;
    $message = round_off_type( $message ) ;
    if ( get_option( "$custom_msg_enable" ) == '1' ) {
        $get_cart_page_msg = get_option( "$custom_msg" ) ;
        $message           .= ' ' . $get_cart_page_msg ;
    }
    if ( get_option( "$eq_price_enable" ) == '1' ) {
        $message .= '&nbsp;(' . $reward_value . ')' ;
    }
    if ( get_option( "$eq_price_enable" ) == '2' && get_option( "$custom_msg_enable" ) == '2' ) {
        $message = $message ;
    }

    echo $message ;
}

/* @return list of user roles */

function fp_rs_get_user_roles() {
    global $wp_roles ;
    foreach ( $wp_roles->roles as $values => $key ) {
        $userroleslug[] = $values ;
        $userrolename[] = $key[ 'name' ] ;
    }
    $user_roles = array_combine( ( array ) $userroleslug , ( array ) $userrolename ) ;
    return $user_roles ;
}

/*
 * @return list of product categories
 */

function fp_rs_get_product_category() {
    $categorylist       = array () ;
    $categoryname       = array () ;
    $categoryid         = array () ;
    $particularcategory = get_terms( 'product_cat' ) ;
    if ( ! is_wp_error( $particularcategory ) ) {
        if ( ! empty( $particularcategory ) ) {
            if ( is_array( $particularcategory ) ) {
                foreach ( $particularcategory as $category ) {
                    $categoryname[] = $category->name ;
                    $categoryid[]   = $category->term_id ;
                }
            }
            $categorylist = array_combine( ( array ) $categoryid , ( array ) $categoryname ) ;
        }
    }
    return $categorylist ;
}

/*
 * Common Function For Shortcode for decimal seperator
 */

function rs_getshortcodetotal_rewards() {
    global $totalrewardpointsnew ;
    global $buying_pointsnew ;
    global $totalrewardpoints_payment_plan ;
    global $buying_pts_payment_plan ;
    $total_points        = 0 ;
    $earn_points         = 0 ;
    $pdt_plan_pts        = 0 ;
    $buying_pdt_plan_pts = 0 ;
    if ( is_array( $totalrewardpoints_payment_plan ) ) {
        $pdt_plan_pts = ( array_sum( $totalrewardpoints_payment_plan ) ) ;
    }
    if ( is_array( $buying_pts_payment_plan ) ) {
        $buying_pdt_plan_pts = ( array_sum( $buying_pts_payment_plan ) ) ;
    }
    if ( is_array( $totalrewardpointsnew ) ) {
        $roundofftype = get_option( 'rs_round_off_type' ) == '1' ? '2' : '0' ;
        $earn_points  = ( array_sum( $totalrewardpointsnew ) ) ;

        $total_points = $earn_points - $pdt_plan_pts ;
    }
    if ( is_array( $buying_pointsnew ) ) {
        $buying_points = array_sum( $buying_pointsnew ) ;
        $total_points  = $total_points + $buying_points - $buying_pdt_plan_pts ;
    }
    if ( $total_points != '' ) {
        return $total_points ;
    }
    return $total_points ;
}

function rs_function_for_rewardpoints_of_simple() {
    global $post ;
    if ( is_object( $post ) ) {
        $restrictpoints = rs_function_to_restrict_points_for_product_which_has_saleprice( $post->ID , $variationid    = '' ) ;
        if ( $restrictpoints == 'no' ) {
            $checkproducttype = rs_get_product_object( $post->ID ) ;
            if ( is_shop() || is_product() || is_page() || is_product_category() ) {
                if ( is_object( $checkproducttype ) && ($checkproducttype->is_type( 'simple' ) || ($checkproducttype->is_type( 'subscription' )) || $checkproducttype->is_type( 'bundle' )) ) {
                    $item             = array ( 'qty' => '1' ) ;
                    $checklevel       = 'no' ;
                    $reward_points    = check_level_of_enable_reward_point( $post->ID , $variationid      = '0' , $item , $checklevel , $referred_user    = '' , $getting_referrer = 'no' , $socialreward     = 'no' , $rewardfor        = '' , $payment_price    = 0 ) ;
                    if ( get_current_user_id() > 0 ) {
                        $reward_points = RSMemberFunction::user_role_based_reward_points( get_current_user_id() , $reward_points ) ;
                    }
                    return $reward_points ;
                }
            }
        }
    }
}

function rs_function_for_rewardpoints_of_simple_referral() {
    global $post ;
    if ( is_object( $post ) ) {
        $restrictpoints = rs_function_to_restrict_points_for_product_which_has_saleprice( $post->ID , $variationid    = '' ) ;
        if ( $restrictpoints == 'no' ) {
            $checkproducttype = rs_get_product_object( $post->ID ) ;
            if ( is_shop() || is_product() || is_page() || is_product_category() ) {
                if ( is_object( $checkproducttype ) && ($checkproducttype->is_type( 'simple' ) || ($checkproducttype->is_type( 'subscription' ))) ) {
                    $item             = array ( 'qty' => '1' ) ;
                    $checklevel       = 'no' ;
                    $reward_points    = check_level_of_enable_reward_point( $post->ID , $variationid      = '0' , $item , $checklevel , $referred_user    = 'yes' , $getting_referrer = 'no' , $socialreward     = 'no' , $rewardfor        = '' , $payment_price    = 0 ) ;
                    $roundofftype     = get_option( 'rs_round_off_type' ) == '1' ? '2' : '0' ;
                    $user_id          = isset( $_COOKIE[ 'rsreferredusername' ] ) ? $_COOKIE[ 'rsreferredusername' ] : 0 ;
                    $user_info        = get_user_by( 'login' , $user_id ) ;
                    if ( $user_info != false ) {
                        $currentuserid = $user_info->ID ;
                    } else {
                        $currentuserid = $user_id ;
                    }
                    if ( $currentuserid > 0 ) {
                        $reward_points = RSMemberFunction::user_role_based_reward_points( $currentuserid , $reward_points ) ;
                    }
                    return $reward_points ;
                }
            }
        }
    }
}

/*
 * Common Function For Sending Mail after reaching the minimum Threshold Points
 */

function rs_mail_function_minimum_threshold_points() {
    if ( get_option( 'rs_email_activated' ) == 'yes' ) {
        $userid               = get_current_user_id() ;
        $rs_earned_points     = RSPointExpiry::total_available_points_in_site( $userid ) ;
        $threshold_mail_check = get_option( 'rs_mail_enable_threshold_points' ) ;
        $threshold_points     = get_option( 'rs_mail_threshold_points' ) ;

        if ( $threshold_mail_check == 'yes' ) {
            if ( $threshold_points < $rs_earned_points ) {
                update_user_meta( $userid , 'rs_mail_minimum_threshold_points' , 'yes' ) ;
            }
            if ( $rs_earned_points <= $threshold_points && get_user_meta( $userid , 'rs_mail_minimum_threshold_points' , true ) != 'no' ) {
                $email        = get_user_by( 'id' , '1' ) ;
                $to           = $email->user_email ;
                $display_name = get_user_by( 'id' , $userid )->display_name ;
                $subject      = get_option( 'rs_email_subject_threshold_points' ) ;
                $msg          = get_option( 'rs_email_message_threshold_points' ) ;
                $message      = str_replace( '[Username]' , $display_name , str_replace( '[TotalPoint]' , $rs_earned_points , $msg ) ) ;
                if ( $subject != '' || $message != '' ) {
                    ob_start() ;
                    wc_get_template( 'emails/email-header.php' , array ( 'email_heading' => $subject ) ) ;
                    echo $message ;
                    wc_get_template( 'emails/email-footer.php' ) ;
                    $woo_temp_msg = ob_get_clean() ;
                    $headers      = "MIME-Version: 1.0\r\n" ;
                    $headers      .= "Content-Type: text/html; charset=UTF-8\r\n" ;
                    if ( '2' == get_option( 'rs_select_mail_function' ) ) {
                        $mailer = WC()->mailer() ;
                        if ( $mailer->send( $to , $subject , $woo_temp_msg , $headers ) ) {
                            update_user_meta( $userid , 'rs_mail_minimum_threshold_points' , 'no' ) ;
                        }
                    } elseif ( '1' == get_option( 'rs_select_mail_function' ) ) {
                        if ( mail( $to , $subject , $woo_temp_msg , $headers ) ) {
                            update_user_meta( $userid , 'rs_mail_minimum_threshold_points' , 'no' ) ;
                        }
                    }
                }
            }
        }
    }
}

/*
 * Common Function For Payment Plans
 */

function rs_condition_for_payment_plan() {
    if ( class_exists( 'SUMOPaymentPlans' ) ) {
        return true ;
    }
    return false ;
}

function rs_check_parent_id( $order_id ) {
    if ( class_exists( 'SUMOPaymentPlans' ) ) {
        $parent_id = wp_get_post_parent_id( $order_id ) ;
        if ( $parent_id > 0 ) {
            $referreduser = RSFunctionForSavingMetaValues::rewardsystem_get_post_meta( $parent_id , '_referrer_name' ) ;
            if ( $referreduser != '' ) {
                RSFunctionForSavingMetaValues::rewardsystem_update_post_meta( $order_id , '_referrer_name' , $referreduser ) ;
                $referreduser = RSFunctionForSavingMetaValues::rewardsystem_get_post_meta( $order_id , '_referrer_name' ) ;
            }
            return $referreduser ;
        }
    }
    return '' ;
}

function check_is_payment_product( $order_id , $product_id ) {

    if ( class_exists( 'SUMOPaymentPlans' ) && function_exists( '_sumo_pp_is_balance_payment_order' ) ) {
        if ( _sumo_pp_is_balance_payment_order( $order_id ) && 'yes' === get_post_meta( $order_id , 'is_sumo_pp_order' , 'yes' ) ) {
            $payment_id = get_post_meta( $order_id , '_payment_id' , true ) ;
            $pdt_id     = get_post_meta( $payment_id , '_product_id' , true ) ;

            return $pdt_id == $product_id ;
        }
    }
    return false ;
}

function get_payment_product_price( $order_id , $check_in_initial_order = false ) {

    if ( class_exists( 'SUMOPaymentPlans' ) ) {
        if ( $check_in_initial_order && function_exists( '_sumo_pp_is_initial_payment_order' ) && function_exists( '_sumo_pp_get_posts' ) ) {

            if ( ! _sumo_pp_is_initial_payment_order( $order_id ) ) {
                return 0 ;
            }
            $order          = wc_get_order( $order_id ) ;
            $get_items      = $order->get_items() ;
            $initial_amount = 0 ;

            foreach ( $get_items as $item ) {
                if ( ! isset( $item[ 'product_id' ] ) ) {
                    continue ;
                }
                $itemid = $item[ 'variation_id' ] > 0 ? $item[ 'variation_id' ] : $item[ 'product_id' ] ;

                $payments = _sumo_pp_get_posts( array (
                    'post_type'   => 'sumo_pp_payments' ,
                    'post_status' => array_keys( _sumo_pp_get_payment_statuses() ) ,
                    'meta_query'  => array (
                        'relation' => 'AND' ,
                        array (
                            'key'   => '_initial_payment_order_id' ,
                            'value' => $order_id ,
                        ) ,
                        array (
                            'key'   => '_product_id' ,
                            'value' => $itemid ,
                        ) ,
                    ) ,
                        ) ) ;


                foreach ( $payments as $payment_id ) {
                    $payment_type  = get_post_meta( $payment_id , '_payment_type' , true ) ;
                    $product_qty   = absint( get_post_meta( $payment_id , '_product_qty' , true ) ) ;
                    $product_price = floatval( get_post_meta( $payment_id , '_product_price' , true ) ) ;

                    if ( 'payment-plans' === $payment_type ) {
                        $initial_payment = floatval( get_post_meta( $payment_id , '_initial_payment' , true ) ) ;
                        $product_amount  = $product_price * $product_qty ;
                        $initial_amount  += ($initial_payment * $product_amount) / 100 ;
                    }
                    if ( 'pay-in-deposit' === $payment_type ) {
                        $deposited_amt  = floatval( get_post_meta( $payment_id , '_deposited_amount' , true ) ) ;
                        $initial_amount += $deposited_amt * $product_qty ;
                    }
                }
            }


            return $initial_amount ;
        } elseif ( function_exists( '_sumo_pp_is_balance_payment_order' ) ) {
            if ( _sumo_pp_is_balance_payment_order( $order_id ) && 'yes' === get_post_meta( $order_id , 'is_sumo_pp_order' , 'yes' ) ) {
                $payment_id    = absint( get_post_meta( $order_id , '_payment_id' , true ) ) ;
                $product_price = get_post_meta( $payment_id , '_product_price' , true ) ;
                return floatval( $product_price ) ;
            }
        }
    }
    return 0 ;
}

function is_final_payment( $order_id ) {

    if ( class_exists( 'SUMOPaymentPlans' ) && function_exists( '_sumo_pp_is_balance_payment_order' ) ) {
        if ( _sumo_pp_is_balance_payment_order( $order_id ) && 'yes' === get_post_meta( $order_id , 'is_sumo_pp_order' , 'yes' ) ) {
            $payment_id             = absint( get_post_meta( $order_id , '_payment_id' , true ) ) ;
            $remaining_installments = absint( get_post_meta( $payment_id , '_remaining_installments' , true ) ) ;

            $order_status = '' ;
            if ( $order        = wc_get_order( $order_id ) ) {
                if ( defined( 'WC_VERSION' ) && version_compare( WC_VERSION , '3.0' , '<' ) ) {
                    $order_status = $order->status ;
                } else {
                    $order_status = $order->get_status() ;
                }
            }
            return $payment_id > 0 && ((1 === $remaining_installments) || (0 === $remaining_installments && in_array( $order_status , array ( 'processing' , 'completed' ) ))) ;
        }
    }
    return false ;
}

function check_initial_payment_pdt( $product_id , $order_user_id = 0 ) {
    if ( class_exists( 'SUMOPaymentPlans' ) && function_exists( '_sumo_pp_is_payment_product' ) ) {
        $initial_check = _sumo_pp_is_payment_product( $product_id , $order_user_id ) ;
        return $initial_check ;
    }
}

function get_payment_data_for_payment_plan( $product_id ) {
    if ( class_exists( 'SUMOPaymentPlans' ) && function_exists( '_sumo_pp_get_payment_data' ) ) {
        $payment_data = _sumo_pp_get_payment_data( $product_id ) ;
        return $payment_data[ 'product_price' ] ;
    }
}

/*
 * Common Function For Sending Email For Actions
 */

function rs_send_mail_for_actions( $to , $event_slug , $earned_point , $total_earned_point ) {
    $subject            = '' ;
    $message            = '' ;
    $total_earned_point = round_off_type( $total_earned_point ) ;
    $earned_point       = round_off_type( $earned_point ) ;
    // Product Review
    if ( get_option( 'rs_send_mail_product_review' ) == 'yes' ) {
        if ( $event_slug == 'RPPR' ) {
            $subject = get_option( 'rs_email_subject_product_review' ) ;
            $msg     = get_option( 'rs_email_message_product_review' ) ;
            $message = str_replace( '[rs_earned_points]' , $earned_point , str_replace( '[rs_available_points]' , $total_earned_point , $msg ) ) ;
        }
    }
    // Account Signup
    if ( get_option( 'rs_send_mail_account_signup' ) == 'yes' ) {
        if ( $event_slug == 'RRP' || $event_slug == 'SLRRP' ) {
            $subject = get_option( 'rs_email_subject_account_signup' ) ;
            $msg     = get_option( 'rs_email_message_account_signup' ) ;
            $message = str_replace( '[rs_earned_points]' , $earned_point , str_replace( '[rs_available_points]' , $total_earned_point , $msg ) ) ;
        }
    }
    // Blog Post Create
    if ( get_option( 'rs_send_mail_blog_post_create' ) == 'yes' ) {
        if ( $event_slug == 'RPFP' ) {
            $subject = get_option( 'rs_email_subject_blog_post_create' ) ;
            $msg     = get_option( 'rs_email_message_blog_post_create' ) ;
            $message = str_replace( '[rs_earned_points]' , $earned_point , str_replace( '[rs_available_points]' , $total_earned_point , $msg ) ) ;
        }
    }
    // Blog Post Comment
    if ( get_option( 'rs_send_mail_blog_post_comment' ) == 'yes' ) {
        if ( $event_slug == 'RPCPAR' ) {
            $subject = get_option( 'rs_email_subject_blog_post_comment' ) ;
            $msg     = get_option( 'rs_email_message_blog_post_comment' ) ;
            $message = str_replace( '[rs_earned_points]' , $earned_point , str_replace( '[rs_available_points]' , $total_earned_point , $msg ) ) ;
        }
    }
    if ( get_option( 'rs_send_mail_blog_post_comment' ) == 'yes' ) {
        if ( $event_slug == 'RPFPOC' ) {
            $subject = get_option( 'rs_email_subject_blog_post_comment' ) ;
            $msg     = get_option( 'rs_email_message_blog_post_comment' ) ;
            $message = str_replace( '[rs_earned_points]' , $earned_point , str_replace( '[rs_available_points]' , $total_earned_point , $msg ) ) ;
        }
    }
    // Page Comment
    if ( get_option( 'rs_send_mail_page_comment' ) == 'yes' ) {
        if ( $event_slug == 'RPCPR' ) {
            $subject = get_option( 'rs_email_subject_page_comment' ) ;
            $msg     = get_option( 'rs_email_message_page_comment' ) ;
            $message = str_replace( '[rs_earned_points]' , $earned_point , str_replace( '[rs_available_points]' , $total_earned_point , $msg ) ) ;
        }
    }
    if ( get_option( 'rs_send_mail_page_comment' ) == 'yes' ) {
        if ( $event_slug == 'RPFPAC' ) {
            $subject = get_option( 'rs_email_subject_page_comment' ) ;
            $msg     = get_option( 'rs_email_message_page_comment' ) ;
            $message = str_replace( '[rs_earned_points]' , $earned_point , str_replace( '[rs_available_points]' , $total_earned_point , $msg ) ) ;
        }
    }
    // Product Creation
    if ( get_option( 'rs_send_mail_product_create' ) == 'yes' ) {
        if ( $event_slug == 'RPCPRO' ) {
            $subject = get_option( 'rs_email_subject_product_create' ) ;
            $msg     = get_option( 'rs_email_message_product_create' ) ;
            $message = str_replace( '[rs_earned_points]' , $earned_point , str_replace( '[rs_available_points]' , $total_earned_point , $msg ) ) ;
        }
    }
    // Login
    if ( get_option( 'rs_send_mail_login' ) == 'yes' ) {
        if ( $event_slug == 'LRP' || $event_slug == 'SLRP' ) {
            $subject = get_option( 'rs_email_subject_login' ) ;
            $msg     = get_option( 'rs_email_message_login' ) ;
            $message = str_replace( '[rs_earned_points]' , $earned_point , str_replace( '[rs_available_points]' , $total_earned_point , $msg ) ) ;
        }
    }

    //Social Linking
    if ( get_option( 'rs_send_mail_for_social_account_linking' ) == 'yes' ) {
        if ( $event_slug == 'SLLRP' ) {
            $subject = get_option( 'rs_email_subject_for_social_account_linking' ) ;
            $msg     = get_option( 'rs_email_message_for_social_account_linking' ) ;
            $message = str_replace( '[rs_earned_points]' , $earned_point , str_replace( '[rs_available_points]' , $total_earned_point , $msg ) ) ;
        }
    }

    //Social Linking
    if ( get_option( 'rs_send_mail_cus_field_reg' ) == 'yes' ) {
        if ( $event_slug == 'CRFRP' || $event_slug == 'CRPFDP' ) {
            $subject = get_option( 'rs_email_subject_cus_field_reg' ) ;
            $msg     = get_option( 'rs_email_message_cus_field_reg' ) ;
            $message = str_replace( '[rs_earned_points]' , $earned_point , str_replace( '[rs_available_points]' , $total_earned_point , $msg ) ) ;
        }
    }

    // Reward Gateway
    if ( get_option( 'rs_send_mail_payment_gateway' ) == 'yes' ) {
        if ( $event_slug == 'RPG' ) {
            $subject = get_option( 'rs_email_subject_payment_gateway' ) ;
            $msg     = get_option( 'rs_email_message_payment_gateway' ) ;
            $message = str_replace( '[rs_earned_points]' , $earned_point , str_replace( '[rs_available_points]' , $total_earned_point , $msg ) ) ;
        }
    }

    // Coupon Points
    if ( get_option( 'rs_send_mail_coupon_reward' ) == 'yes' ) {
        if ( $event_slug == 'RPC' ) {
            $subject = get_option( 'rs_email_subject_coupon_reward' ) ;
            $msg     = get_option( 'rs_email_message_coupon_reward' ) ;
            $message = str_replace( '[rs_earned_points]' , $earned_point , str_replace( '[rs_available_points]' , $total_earned_point , $msg ) ) ;
        }
    }
    //Facebook Like
    if ( get_option( 'rs_send_mail_Facebook_like' ) == 'yes' ) {
        if ( $event_slug == 'RPFL' ) {
            $subject = get_option( 'rs_email_subject_facebook_like' ) ;
            $msg     = get_option( 'rs_email_message_facebook_like' ) ;
            $message = str_replace( '[rs_earned_points]' , $earned_point , str_replace( '[rs_available_points]' , $total_earned_point , $msg ) ) ;
        }
    }
    // Instagram
    if ( get_option( 'rs_send_mail_instagram' ) == 'yes' ) {
        if ( $event_slug == 'RPIF' ) {
            $subject = get_option( 'rs_email_subject_instagram' ) ;
            $msg     = get_option( 'rs_email_message_instagram' ) ;
            $message = str_replace( '[rs_earned_points]' , $earned_point , str_replace( '[rs_available_points]' , $total_earned_point , $msg ) ) ;
        }
    }
    // OK
    if ( get_option( 'rs_send_mail_ok' ) == 'yes' ) {
        if ( $event_slug == 'RPOK' ) {
            $subject = get_option( 'rs_email_subject_ok' ) ;
            $msg     = get_option( 'rs_email_message_ok' ) ;
            $message = str_replace( '[rs_earned_points]' , $earned_point , str_replace( '[rs_available_points]' , $total_earned_point , $msg ) ) ;
        }
    }
    // FacebookSare
    if ( get_option( 'rs_send_mail_facebook_share' ) == 'yes' ) {
        if ( $event_slug == 'RPFS' ) {
            $subject = get_option( 'rs_email_subject_facebook_share' ) ;
            $msg     = get_option( 'rs_email_message_facebook_share' ) ;
            $message = str_replace( '[rs_earned_points]' , $earned_point , str_replace( '[rs_available_points]' , $total_earned_point , $msg ) ) ;
        }
    }
    // Twitter Tweet
    if ( get_option( 'rs_send_mail_tewitter_tweet' ) == 'yes' ) {
        if ( $event_slug == 'RPTT' ) {
            $subject = get_option( 'rs_email_subject_twitter_tweet' ) ;
            $msg     = get_option( 'rs_email_message_twitter_tweet' ) ;
            $message = str_replace( '[rs_earned_points]' , $earned_point , str_replace( '[rs_available_points]' , $total_earned_point , $msg ) ) ;
        }
    }
    // Twitter Follow
    if ( get_option( 'rs_send_mail_twitter_follow' ) == 'yes' ) {
        if ( $event_slug == 'RPTF' ) {
            $subject = get_option( 'rs_email_subject_twitter_follow' ) ;
            $msg     = get_option( 'rs_email_message_twitter_follow' ) ;
            $message = str_replace( '[rs_earned_points]' , $earned_point , str_replace( '[rs_available_points]' , $total_earned_point , $msg ) ) ;
        }
    }
    // Google Share
    if ( get_option( 'rs_send_mail_google' ) == 'yes' ) {
        if ( $event_slug == 'RPGPOS' ) {
            $subject = get_option( 'rs_email_subject_google' ) ;
            $msg     = get_option( 'rs_email_message_google' ) ;
            $message = str_replace( '[rs_earned_points]' , $earned_point , str_replace( '[rs_available_points]' , $total_earned_point , $msg ) ) ;
        }
    }
    // VK
    if ( get_option( 'rs_send_mail_vk' ) ) {
        if ( $event_slug == 'RPVL' ) {
            $subject = get_option( 'rs_email_subject_vk' ) ;
            $msg     = get_option( 'rs_email_message_vk' ) ;
            $message = str_replace( '[rs_earned_points]' , $earned_point , str_replace( '[rs_available_points]' , $total_earned_point , $msg ) ) ;
        }
    }
    if ( get_option( 'rs_send_mail_post' ) == 'yes' ) {
        // OK Post
        if ( $event_slug == 'RPOKP' ) {
            $sub         = get_option( 'rs_email_subject_post' ) ;
            $replace_msg = 'OK.ru Post' ;
            $subject     = str_replace( '[rs_post_action]' , $replace_msg , $sub ) ;
            $msg         = get_option( 'rs_email_message_post' ) ;
            $message     = str_replace( '[rs_earned_points]' , $earned_point , str_replace( '[rs_available_points]' , $total_earned_point , $msg ) ) ;
        }
        // Instagarm Post
        if ( $event_slug == 'RPIFP' ) {
            $subject = get_option( 'rs_email_subject_post' ) ;
            $msg     = get_option( 'rs_email_message_post' ) ;
            $message = str_replace( '[rs_earned_points]' , $earned_point , str_replace( '[rs_available_points]' , $total_earned_point , $msg ) ) ;
        }
        // VK Like Post
        if ( $event_slug == 'RPVLP' ) {
            $sub         = get_option( 'rs_email_subject_post' ) ;
            $replace_msg = 'VK Like Post' ;
            $subject     = str_replace( '[rs_post_action]' , $replace_msg , $sub ) ;
            $msg         = get_option( 'rs_email_message_post' ) ;
            $message     = str_replace( '[rs_earned_points]' , $earned_point , str_replace( '[rs_available_points]' , $total_earned_point , $msg ) ) ;
        }
        // Google Share Post
        if ( $event_slug == 'RPGPOSP' ) {
            $sub         = get_option( 'rs_email_subject_post' ) ;
            $replace_msg = 'Google+1 Share Post' ;
            $subject     = str_replace( '[rs_post_action]' , $replace_msg , $sub ) ;
            $msg         = get_option( 'rs_email_message_post' ) ;
            $message     = str_replace( '[rs_earned_points]' , $earned_point , str_replace( '[rs_available_points]' , $total_earned_point , $msg ) ) ;
        }
        // Twitter Share Post
        if ( $event_slug == 'RPTFP' ) {
            $sub         = get_option( 'rs_email_subject_post' ) ;
            $replace_msg = 'Twitter Share Post' ;
            $subject     = str_replace( '[rs_post_action]' , $replace_msg , $sub ) ;
            $msg         = get_option( 'rs_email_message_post' ) ;
            $message     = str_replace( '[rs_earned_points]' , $earned_point , str_replace( '[rs_available_points]' , $total_earned_point , $msg ) ) ;
        }
        // Twitter Tweet Post
        if ( $event_slug == 'RPTTP' ) {
            $sub         = get_option( 'rs_email_subject_post' ) ;
            $replace_msg = 'Twitter Tweet Post' ;
            $subject     = str_replace( '[rs_post_action]' , $replace_msg , $sub ) ;
            $msg         = get_option( 'rs_email_message_post' ) ;
            $message     = str_replace( '[rs_earned_points]' , $earned_point , str_replace( '[rs_available_points]' , $total_earned_point , $msg ) ) ;
        }
        // Facebook Share Post
        if ( $event_slug == 'RPFSP' ) {
            $sub         = get_option( 'rs_email_subject_post' ) ;
            $replace_msg = 'Facebook Share Post' ;
            $subject     = str_replace( '[rs_post_action]' , $replace_msg , $sub ) ;
            $msg         = get_option( 'rs_email_message_post' ) ;
            $message     = str_replace( '[rs_earned_points]' , $earned_point , str_replace( '[rs_available_points]' , $total_earned_point , $msg ) ) ;
        }
        // Facebook Like Post
        if ( $event_slug == 'RPFLP' ) {
            $sub         = get_option( 'rs_email_subject_post' ) ;
            $replace_msg = 'Facebook Like Post' ;
            $subject     = str_replace( '[rs_post_action]' , $replace_msg , $sub ) ;
            $msg         = get_option( 'rs_email_message_post' ) ;
            $message     = str_replace( '[rs_earned_points]' , $earned_point , str_replace( '[rs_available_points]' , $total_earned_point , $msg ) ) ;
        }
    }

    //Gift Voucher
    if ( get_option( 'rs_send_mail_gift_voucher' ) == 'yes' ) {
        if ( $event_slug == 'RPGV' ) {
            $subject = get_option( 'rs_email_subject_gift_voucher' ) ;
            $msg     = get_option( 'rs_email_message_gift_voucher' ) ;
            $message = str_replace( '[rs_earned_points]' , $earned_point , str_replace( '[rs_available_points]' , $total_earned_point , $msg ) ) ;
        }
    }
    //Point URL
    if ( get_option( 'rs_send_mail_point_url' ) == 'yes' ) {
        if ( $event_slug == 'RPFURL' ) {
            $subject = get_option( 'rs_email_subject_point_url' ) ;
            $msg     = get_option( 'rs_email_message_point_url' ) ;
            $message = str_replace( '[rs_earned_points]' , $earned_point , str_replace( '[rs_available_points]' , $total_earned_point , $msg ) ) ;
        }
    }

    //Referral Registration Points for Referral
    if ( get_option( 'rs_send_mail_referral_signup' ) == 'yes' ) {
        if ( $event_slug == 'RRRP' ) {
            $subject = get_option( 'rs_email_subject_referral_signup' ) ;
            $msg     = get_option( 'rs_email_message_referral_signup' ) ;
            $message = str_replace( '[rs_earned_points]' , $earned_point , str_replace( '[rs_available_points]' , $total_earned_point , $msg ) ) ;
        }
    }
    //  Referral Reward Points Getting Referred
    if ( get_option( 'rs_send_mail_getting_referred' ) == 'yes' ) {
        if ( $event_slug == 'RRPGR' ) {
            $subject = get_option( 'rs_email_subject_getting_referred' ) ;
            $msg     = get_option( 'rs_email_message_getting_referred' ) ;
            $message = str_replace( '[rs_earned_points]' , $earned_point , str_replace( '[rs_available_points]' , $total_earned_point , $msg ) ) ;
        }
    }
    //  Product Purchase for Referral
    if ( get_option( 'rs_send_mail_pdt_purchase_referral' ) == 'yes' ) {
        if ( $event_slug == 'PPRRP' ) {
            $subject = get_option( 'rs_email_subject_pdt_purchase_referral' ) ;
            $msg     = get_option( 'rs_email_message_pdt_purchase_referral' ) ;
            $message = str_replace( '[rs_earned_points]' , $earned_point , str_replace( '[rs_available_points]' , $total_earned_point , $msg ) ) ;
        }
    }

    // Product Purchase For Getting Referred
    if ( get_option( 'rs_send_mail_pdt_purchase_referrer' ) == 'yes' ) {
        if ( $event_slug == 'PPRRPG' ) {
            $subject = get_option( 'rs_email_subject_pdt_purchase_referrer' ) ;
            $msg     = get_option( 'rs_email_message_pdt_purchase_referrer' ) ;
            $message = str_replace( '[rs_earned_points]' , $earned_point , str_replace( '[rs_available_points]' , $total_earned_point , $msg ) ) ;
        }
    }

    // Waiting List Subscribing
    if ( get_option( 'rs_send_mail_for_waitlist_subscribing' ) == 'yes' ) {
        if ( $event_slug == 'RPFWLS' ) {
            $subject = get_option( 'rs_email_subject_for_waitlist_subscribing' ) ;
            $msg     = get_option( 'rs_email_message_for_waitlist_subscribing' ) ;
            $message = str_replace( '[rs_earned_points]' , $earned_point , str_replace( '[rs_available_points]' , $total_earned_point , $msg ) ) ;
        }
    }

    // Waiting List Sale Conversion
    if ( get_option( 'rs_send_mail_for_waitlist_sale_conversion' ) == 'yes' ) {
        if ( $event_slug == 'RPFWLSC' ) {
            $subject = get_option( 'rs_email_subject_for_waitlist_sale_conversion' ) ;
            $msg     = get_option( 'rs_email_message_for_waitlist_sale_conversion' ) ;
            $message = str_replace( '[rs_earned_points]' , $earned_point , str_replace( '[rs_available_points]' , $total_earned_point , $msg ) ) ;
        }
    }

    if ( $subject != '' || $message != '' ) {
//    $message = do_shortcode($message); //shortcode feature
        ob_start() ;
        wc_get_template( 'emails/email-header.php' , array ( 'email_heading' => $subject ) ) ;
        echo $message ;
        wc_get_template( 'emails/email-footer.php' ) ;
        $woo_temp_msg = ob_get_clean() ;
        $headers      = "MIME-Version: 1.0\r\n" ;
        $headers      .= "Content-Type: text/html; charset=UTF-8\r\n" ;
        if ( '2' == get_option( 'rs_enable_email_function_actions' ) ) {
            $mailer = WC()->mailer() ;
            if ( $mailer->send( $to , $subject , $woo_temp_msg , $headers ) ) {
                
            }
        } elseif ( '1' == get_option( 'rs_enable_email_function_actions' ) ) {
            if ( mail( $to , $subject , $woo_temp_msg , $headers ) ) {
                
            }
        }
    }
}

/*
 * Get all Order Statuses
 */

function fp_rs_get_all_order_status() {
    $order_statuses = '' ;
    if ( function_exists( 'wc_get_order_statuses' ) ) {
        $orderstatus    = str_replace( 'wc-' , '' , array_keys( wc_get_order_statuses() ) ) ;
        $orderslugs     = array_values( wc_get_order_statuses() ) ;
        $order_statuses = array_combine( ( array ) $orderstatus , ( array ) $orderslugs ) ;
    } else {
        $taxonomy    = 'shop_order_status' ;
        $orderstatus = '' ;
        $orderslugs  = '' ;

        $term_args = array (
            'hide_empty' => false ,
            'orderby'    => 'date' ,
                ) ;
        $tax_terms = get_terms( $taxonomy , $term_args ) ;
        if ( is_array( $tax_terms ) && ! empty( $tax_terms ) ) {
            foreach ( $tax_terms as $getterms ) {
                if ( is_object( $getterms ) ) {
                    $orderstatus[] = $getterms->name ;
                    $orderslugs[]  = $getterms->slug ;
                }
            }
        }
        $order_statuses = array_combine( ( array ) $orderslugs , ( array ) $orderstatus ) ;
    }
    return $order_statuses ;
}

/*
 * @return nonce value for security purpose of ajax
 */

function rs_function_to_create_security() {
    $secure = wp_create_nonce( 'sumo-reward-points' ) ;
    return $secure ;
}

/*
 * @return bool Value if Nonce is verified
 */

function rs_function_to_verify_secure( $secure ) {
    if ( wp_verify_nonce( $secure , 'sumo-reward-points' ) ) {
        return true ;
    } else {
        return false ;
    }
}

function earn_point_conversion() {
    return wc_format_decimal( get_option( 'rs_earn_point' ) ) ;
}

function earn_point_conversion_value() {
    return wc_format_decimal( get_option( 'rs_earn_point_value' ) ) ;
}

function multi_dimensional_descending_sort_coupon_points( $arr , $index ) {
    $b = array () ;
    $c = array () ;
    if ( is_array( $arr ) ) {
        foreach ( $arr as $key => $value ) {
            $b[ $key ] = $value[ $index ] ;
        }
        arsort( $b ) ;
        foreach ( $b as $key => $value ) {
            $c[] = $arr[ $key ] ;
        }

        return $c ;
    }
}

function rs_get_referer_id_linking_rule( $linkarray , $field , $value ) {
    if ( is_array( $linkarray ) ) {
        foreach ( $linkarray as $key => $eachreferer ) {
            if ( $eachreferer[ $field ] == $value )
                return $eachreferer[ 'referer' ] ;
        }
    }
    return FALSE ;
}

function rs_perform_manual_link_referer( $buyer_id ) {
    $data = get_option( 'rewards_dynamic_rule_manual' ) ;
    return rs_get_referer_id_linking_rule( $data , "refferal" , $buyer_id ) ;
}

function apply_coupon_code_reward_points_user( $order_id ) {
    $order                   = new WC_order( $order_id ) ;
    $order_user_id           = rs_get_order_obj( $order ) ;
    $order_user_id           = $order_user_id[ 'order_userid' ] ;
    $coupons_applied_in_cart = array () ;
    if ( get_option( 'rs_choose_priority_level_selection_coupon_points' ) == '1' ) {
        $coupons_for_points_rule_list = multi_dimensional_descending_sort_coupon_points( get_option( 'rewards_dynamic_rule_couponpoints' ) , 'reward_points' ) ;
    } else {
        $coupons_for_points_rule_list = RSMemberFunction::multi_dimensional_sort( get_option( 'rewards_dynamic_rule_couponpoints' ) , 'reward_points' ) ;
    }
    $getthedatas = array () ;
    if ( is_array( $coupons_for_points_rule_list ) ) {
        if ( ! empty( $coupons_for_points_rule_list ) ) {
            foreach ( $coupons_for_points_rule_list as $key => $value ) {
                if ( ! in_array( $value[ 'coupon_codes' ] , $getthedatas ) ) {
                    $getthedatas[ $key ] = $value[ 'coupon_codes' ] ;
                }
            }
        }
    }
    $c = array () ;
    foreach ( $getthedatas as $key => $mainvalue ) {
        $c[] = $coupons_for_points_rule_list[ $key ] ;
    }

    $rewardpointscoupons = $order->get_items( array ( 'coupon' ) ) ;
    foreach ( $rewardpointscoupons as $applied_coupons ) {
        $coupons_applied_in_cart[] = $applied_coupons[ 'name' ] ;
    }
    foreach ( $c as $coupons_for_points_each_rule ) {
        global $woocommerce ;
        $rule_created_coupons_list        = $coupons_for_points_each_rule[ "coupon_codes" ] ;
        $rule_created_coupons_points_list = $coupons_for_points_each_rule[ "reward_points" ] ;
        foreach ( $rule_created_coupons_list as $separate_rule_coupons ) {
            $coupon_name_shortcode_to_find    = "[coupon_name]" ;
            $coupon_name_shortcode_to_replace = $separate_rule_coupons ;
            $coupon_reward_points_to_update   = $rule_created_coupons_points_list ;
            $newfunctionchecker               = RSFunctionForCouponRewardPoints::find_coupon_values( $separate_rule_coupons , $coupons_applied_in_cart ) ;
            $new_obj                          = new RewardPointsOrder( $order_id , $apply_previous_order_points      = 'no' ) ;
            if ( ( int ) $newfunctionchecker == 1 ) {
                $restrictuserpoints     = get_option( 'rs_max_earning_points_for_user' ) ;
                $enabledisablemaxpoints = get_option( 'rs_enable_disable_max_earning_points_for_user' ) ;
                if ( $enabledisablemaxpoints == 'yes' ) {
                    $new_obj->check_point_restriction( $restrictuserpoints , $coupon_reward_points_to_update , $pointsredeemed = 0 , $event_slug     = 'RPC' , $order_user_id , $nomineeid      = '' , $referrer_id    = '' , $product_id     = '' , $variationid    = '' , $reasonindetail = '' ) ;
                } else {
                    $equearnamt     = RSPointExpiry::earning_conversion_settings( $coupon_reward_points_to_update ) ;
                    $valuestoinsert = array ( 'pointstoinsert' => $coupon_reward_points_to_update , 'pointsredeemed' => 0 , 'event_slug' => 'RPC' , 'equalearnamnt' => $equearnamt , 'equalredeemamnt' => 0 , 'user_id' => $order_user_id , 'referred_id' => '' , 'product_id' => '' , 'variation_id' => '' , 'reasonindetail' => '' , 'nominee_id' => '' , 'nominee_points' => '' , 'totalearnedpoints' => $coupon_reward_points_to_update , 'totalredeempoints' => 0 ) ;
                    $new_obj->total_points_management( $valuestoinsert ) ;
                }
            }
        }
    }
    do_action( 'fp_reward_point_for_using_coupons' ) ;
}

function rsmail_sending_on_custom_rule( $user_id , $order_id ) {
    global $wpdb ;
    global $woocommerce ;
    $emailtemplate_table_name = $wpdb->prefix . 'rs_templates_email' ;
    $email_templates          = $wpdb->get_results( "SELECT * FROM $emailtemplate_table_name" ) ; //all email templates
    if ( is_array( $email_templates ) ) {
        foreach ( $email_templates as $emails ) {
            if ( $emails->rs_status == "ACTIVE" ) {
                if ( $emails->mailsendingoptions == '1' ) {
                    if ( $emails->rsmailsendingoptions == '1' ) {
                        if ( get_option( 'rsearningtemplates' . $emails->id ) != '1' ) {
                            if ( $emails->sendmail_options == '1' ) {
                                include'frontend/rsmailsendingearning.php' ;
                            } else {
                                include'frontend/rsmailsendingearning2.php' ;
                            }
                            update_option( 'rsearningtemplates' . $emails->id , '1' ) ;
                        }
                    }

                    if ( $emails->rsmailsendingoptions == '2' ) {
                        if ( get_option( 'rsredeemingtemplates' . $emails->id ) != '1' ) {
                            if ( $emails->sendmail_options == '1' ) {
                                include'frontend/rsmailsendingredeeming.php' ;
                            } else {
                                include'frontend/rsmailsendingredeeming2.php' ;
                            }
                            update_option( 'rsredeemingtemplates' . $emails->id , '1' ) ;
                        }
                    }
                } else {
                    if ( $emails->rsmailsendingoptions == '1' ) {
                        if ( $emails->sendmail_options == '1' ) {
                            include'frontend/rsmailsendingearning.php' ;
                        } else {
                            include'frontend/rsmailsendingearning2.php' ;
                        }
                    }
                    if ( $emails->rsmailsendingoptions == '2' ) {
                        if ( $emails->sendmail_options == '1' ) {
                            include 'frontend/rsmailsendingredeeming.php' ;
                        } else {
                            include 'frontend/rsmailsendingredeeming2.php' ;
                        }
                    }
                }
            }
        }
    }
}

function display_total_currency_value( $getcurrentuserid ) {
    $getoldpoints           = RSPointExpiry::total_available_points_in_site( $getcurrentuserid ) ;
    $point_control          = wc_format_decimal( get_option( 'rs_redeem_point' ) ) ;
    $point_amount           = RSMemberFunction::user_role_based_redeem_points( $getcurrentuserid ) ;
    $point_control_price    = $point_amount ;
    $revised_amount         = $getoldpoints * $point_control_price ;
    $coupon_value_in_points = $revised_amount / $point_control ;
    return round_off_type( $getoldpoints ) . '(' . get_woocommerce_formatted_price( round_off_type_for_currency( $coupon_value_in_points ) ) . ')' ;
}

function calculate_point_price_for_products( $product_id ) {
    $data[ $product_id ] = '' ;
    if ( get_option( 'rs_point_price_activated' ) != 'yes' )
        return $data ;

    if ( get_option( 'rs_enable_disable_point_priceing' ) == '2' )
        return $data ;

    //Simple Product Data
    $EnablePointPriceForSimple        = RSFunctionForSavingMetaValues::rewardsystem_get_post_meta( $product_id , '_rewardsystem_enable_point_price' ) ;
    $ProductLevelPointsForSimple      = RSFunctionForSavingMetaValues::rewardsystem_get_post_meta( $product_id , '_rewardsystem__points' ) ;
    $PointsTypeForSimple              = RSFunctionForSavingMetaValues::rewardsystem_get_post_meta( $product_id , '_rewardsystem_point_price_type' ) ;
    $PointsBasedOnConversionForSimple = RSFunctionForSavingMetaValues::rewardsystem_get_post_meta( $product_id , '_rewardsystem__points_based_on_conversion' ) ;
    $PointPriceTypeForSimple          = RSFunctionForSavingMetaValues::rewardsystem_get_post_meta( $product_id , '_rewardsystem_enable_point_price_type' ) ;

    //Variable Product Data
    $EnablePointPriceForVariation       = RSFunctionForSavingMetaValues::rewardsystem_get_post_meta( $product_id , '_enable_reward_points_price' ) ;
    $ProductLevelPointsForVariation     = RSFunctionForSavingMetaValues::rewardsystem_get_post_meta( $product_id , 'price_points' ) ;
    $PointsTypeForVariable              = RSFunctionForSavingMetaValues::rewardsystem_get_post_meta( $product_id , '_enable_reward_points_price_type' ) ;
    $PointsBasedOnConversionForVariable = RSFunctionForSavingMetaValues::rewardsystem_get_post_meta( $product_id , '_price_points_based_on_conversion' ) ;
    $PointPriceTypeForVariable          = RSFunctionForSavingMetaValues::rewardsystem_get_post_meta( $product_id , '_enable_reward_points_pricing_type' , true ) ;

    $GlobalPointPriceType = get_option( 'rs_global_point_price_type' ) ;
    $ProductObj           = rs_get_product_object( $product_id ) ;
    if ( get_option( 'rs_enable_product_category_level_for_points_price' ) == 'no' ) {
        $options_to_check = array (
            'applicable_for'      => get_option( 'rs_point_pricing_global_level_applicable_for' ) ,
            'included_products'   => get_option( 'rs_include_products_for_point_pricing' ) ,
            'excluded_products'   => get_option( 'rs_exclude_products_for_point_pricing' ) ,
            'included_categories' => get_option( 'rs_include_particular_categories_for_point_pricing' ) ,
            'excluded_categories' => get_option( 'rs_exclude_particular_categories_for_point_pricing' )
                ) ;
        $product_filter   = rs_function_to_get_filtered_product( $product_id , $product_id , $options_to_check ) ;
    } elseif ( get_option( 'rs_enable_product_category_level_for_points_price' ) == 'yes' ) {
        $product_filter = '1' ;
    }
    if ( is_object( $ProductObj ) && ($ProductObj->is_type( 'simple' ) || ($ProductObj->is_type( 'subscription' )) || ($ProductObj->is_type( 'lottery' ))) ) {
        if ( $product_filter == '1' ) {
            if ( $EnablePointPriceForSimple == 'yes' )
                $data[ $product_id ] = rs_function_to_get_product_value_for_point_pricing( $PointsTypeForSimple , $PointPriceTypeForSimple , $ProductLevelPointsForSimple , $product_id ) ;
        } elseif ( $product_filter == '2' ) {
            $data[ $product_id ] = rs_function_to_get_global_value_for_point_pricing( $product_id ) ;
        } else {
            $data[ $product_id ] = '' ;
        }
    } else {
        if ( wp_get_post_parent_id( $product_id ) != '0' ) {
            $ProductObjForVariable = new WC_Product_Variation( $product_id ) ;
            $ProductIdForVariable  = rs_get_parent_id( $ProductObjForVariable ) ;
        } else {
            $ProductIdForVariable = $product_id ;
        }
        if ( $product_filter == '1' ) {
            if ( $EnablePointPriceForVariation == '1' ) {
                if ( $PointPriceTypeForVariable == '2' ) {
                    $data[ $product_id ] = $ProductLevelPointsForVariation ;
                } else {
                    if ( $PointsTypeForVariable == 1 ) {
                        if ( $ProductLevelPointsForVariation == '' ) {
                            $data[ $product_id ] = rs_function_to_get_category_value_for_point_pricing( $ProductIdForVariable ) ;
                        } else {
                            $data[ $product_id ] = $ProductLevelPointsForVariation ;
                        }
                    } else {
                        $data[ $product_id ] = get_sale_and_regular_price( $product_id ) ;
                    }
                }
            }
        } elseif ( $product_filter == '2' ) {
            $data[ $product_id ] = rs_function_to_get_global_value_for_point_pricing( $product_id ) ;
        } else {
            $data[ $product_id ] = '' ;
        }
    }
    if ( is_object( $ProductObj ) && ($ProductObj->is_type( 'booking' )) ) {
        $booking_points      = RSFunctionForSavingMetaValues::rewardsystem_get_post_meta( $product_id , 'booking_points' ) ;
        $data[ $product_id ] = $booking_points ;
    }
    return $data ;
}

function rs_function_to_get_product_value_for_point_pricing( $PointsTypeForSimple , $PointPriceTypeForSimple , $ProductLevelPointsForSimple , $product_id ) {
    if ( $PointPriceTypeForSimple == '2' ) {
        if ( $ProductLevelPointsForSimple == '' ) {
            $data = rs_function_to_get_category_value_for_point_pricing( $product_id ) ;
        } else {
            $data = $ProductLevelPointsForSimple ;
        }
    } else {
        if ( $PointsTypeForSimple == 1 ) {
            if ( $ProductLevelPointsForSimple == '' ) {
                $data = rs_function_to_get_category_value_for_point_pricing( $product_id ) ;
            } else {
                $data = $ProductLevelPointsForSimple ;
            }
        } else {
            $data = get_sale_and_regular_price( $product_id ) ;
        }
    }
    return $data ;
}

function rs_function_to_get_category_value_for_point_pricing( $product_id ) {
    $term = get_the_terms( $product_id , 'product_cat' ) ;
    if ( is_array( $term ) ) {
        foreach ( $term as $term ) {
            $EnablePointPriceInCategory = get_woocommerce_term_meta( $term->term_id , 'enable_point_price_category' , true ) ;
            if ( ($EnablePointPriceInCategory == 'yes' ) ) {
                $PointsPriceType = get_woocommerce_term_meta( $term->term_id , 'pricing_category_types' , true ) ;
                $PointsType      = get_woocommerce_term_meta( $term->term_id , 'point_price_category_type' , true ) ;
                if ( $PointsPriceType == '2' ) {
                    $OnlyPointPriceValue = get_woocommerce_term_meta( $term->term_id , 'rs_category_points_price' , true ) ;
                    if ( $OnlyPointPriceValue == '' ) {
                        $data = rs_function_to_get_global_value_for_point_pricing( $product_id ) ;
                    } else {
                        $data = $OnlyPointPriceValue ;
                    }
                } else {
                    if ( $PointsType == '1' ) {
                        $CategoryLevelPoints = get_woocommerce_term_meta( $term->term_id , 'rs_category_points_price' , true ) ;
                        if ( $CategoryLevelPoints == '' ) {
                            $data = rs_function_to_get_global_value_for_point_pricing( $product_id ) ;
                        } else {
                            $data = $CategoryLevelPoints ;
                        }
                    } else {
                        $data = get_sale_and_regular_price( $product_id ) ;
                    }
                }
            } else {
                $data = rs_function_to_get_global_value_for_point_pricing( $product_id ) ;
            }
        }
    } else {
        $data = rs_function_to_get_global_value_for_point_pricing( $product_id ) ;
    }
    return $data ;
}

function rs_function_to_get_global_value_for_point_pricing( $product_id ) {
    $data                     = '' ;
    $EnablePointPriceInGlobal = get_option( 'rs_local_enable_disable_point_price_for_product' ) ;
    $PointPricingType         = get_option( 'rs_pricing_type_global_level' ) ;
    $PointsType               = get_option( 'rs_global_point_price_type' ) ;
    if ( $EnablePointPriceInGlobal == '1' ) {
        if ( $PointPricingType == '2' ) {
            $data = get_option( 'rs_local_price_points_for_product' ) ;
        } else {
            if ( $PointsType == '1' ) {
                if ( get_option( 'rs_local_price_points_for_product' ) != '' ) {
                    $data = get_option( 'rs_local_price_points_for_product' ) ;
                }
            } else {
                $data = get_sale_and_regular_price( $product_id ) ;
            }
        }
    }
    return $data ;
}

function get_sale_and_regular_price( $product_id ) {
    $product       = rs_get_product_object( $product_id ) ;
    $product_price = rs_get_sale_or_regular_price( $product ) ;
    $point_amount  = RSMemberFunction::user_role_based_redeem_points( get_current_user_id() ) ;
    $newvalue      = ( float ) $product_price / $point_amount ;
    $updatedvalue  = $newvalue * wc_format_decimal( get_option( 'rs_redeem_point' ) ) ;
    return $updatedvalue ;
}

function check_display_price_type( $product_id ) {
    if ( get_option( 'rs_point_price_activated' ) != 'yes' )
        return ;

    if ( get_option( 'rs_enable_disable_point_priceing' ) == '2' )
        return ;

    if ( get_option( 'rs_enable_product_category_level_for_points_price' ) == 'no' ) {  //Quick Setup
        $ProductFilters            = array (
            'applicable_for'      => get_option( 'rs_point_pricing_global_level_applicable_for' ) ,
            'included_products'   => get_option( 'rs_include_products_for_point_pricing' ) ,
            'excluded_products'   => get_option( 'rs_exclude_products_for_point_pricing' ) ,
            'included_categories' => get_option( 'rs_include_particular_categories_for_point_pricing' ) ,
            'excluded_categories' => get_option( 'rs_exclude_particular_categories_for_point_pricing' )
                ) ;
        $ProductsToApplyPointPrice = rs_function_to_get_filtered_product( $product_id , $product_id , $ProductFilters ) ;
        $EnablePointPrice          = get_option( 'rs_local_enable_disable_point_price_for_product' ) ;
        $PointPriceType            = get_option( 'rs_pricing_type_global_level' ) ;
        $PointPriceValue           = get_option( 'rs_local_price_points_for_product' ) ;
        if ( $EnablePointPrice == '2' )
            return ;

        if ( $ProductsToApplyPointPrice == '2' ) {
            if ( $PointPriceType == '1' ) {
                if ( $PointPriceValue != '' ) {
                    return '1' ;
                }
            } else {
                if ( $PointPriceValue != '' ) {
                    return '2' ;
                }
            }
        }
    } else {
        //Product Level
        $PointPriceinProductLevel = RSFunctionForSavingMetaValues::rewardsystem_get_post_meta( $product_id , '_rewardsystem_enable_point_price' ) != '' ? RSFunctionForSavingMetaValues::rewardsystem_get_post_meta( $product_id , '_rewardsystem_enable_point_price' ) : RSFunctionForSavingMetaValues::rewardsystem_get_post_meta( $product_id , '_enable_reward_points_price' ) ;
        $PointPriceType           = RSFunctionForSavingMetaValues::rewardsystem_get_post_meta( $product_id , '_rewardsystem_enable_point_price_type' ) != '' ? RSFunctionForSavingMetaValues::rewardsystem_get_post_meta( $product_id , '_rewardsystem_enable_point_price_type' ) : RSFunctionForSavingMetaValues::rewardsystem_get_post_meta( $product_id , '_enable_reward_points_pricing_type' ) ;
        $PointPriceValue          = RSFunctionForSavingMetaValues::rewardsystem_get_post_meta( $product_id , '_rewardsystem__points' ) != '' ? RSFunctionForSavingMetaValues::rewardsystem_get_post_meta( $product_id , '_rewardsystem__points' ) : RSFunctionForSavingMetaValues::rewardsystem_get_post_meta( $product_id , 'price_points' ) ;
        if ( $PointPriceinProductLevel == 'yes' || $PointPriceinProductLevel == '1' ) {
            if ( $PointPriceType == '1' ) {
                if ( $PointPriceValue != '' ) {
                    return '1' ;
                } else {
                    return rs_category_level_display_type( $product_id ) ;
                }
            } else {
                if ( $PointPriceValue != '' ) {
                    return '2' ;
                } else {
                    return rs_category_level_display_type( $product_id ) ;
                }
            }
        }
    }
}

function rs_category_level_display_type( $product_id ) {
    $term = get_the_terms( $product_id , 'product_cat' ) ;
    if ( is_array( $term ) ) {
        foreach ( $term as $term ) {
            $EnablePointPriceInCategory = get_woocommerce_term_meta( $term->term_id , 'enable_point_price_category' , true ) ;
            if ( ($EnablePointPriceInCategory == 'yes' ) ) {
                $PointsPriceType = get_woocommerce_term_meta( $term->term_id , 'pricing_category_types' , true ) ;
                $PointPriceValue = get_woocommerce_term_meta( $term->term_id , 'rs_category_points_price' , true ) ;
                if ( $PointsPriceType == '1' ) {
                    if ( $PointPriceValue != '' ) {
                        return '1' ;
                    } else {
                        return rs_global_level_display_type() ;
                    }
                } else {
                    if ( $PointPriceValue != '' ) {
                        return '2' ;
                    } else {
                        return rs_global_level_display_type() ;
                    }
                }
            } else {
                return rs_global_level_display_type() ;
            }
        }
    } else {
        return rs_global_level_display_type() ;
    }
}

function rs_global_level_display_type() {
    $EnablePointPriceInGlobal = get_option( 'rs_local_enable_disable_point_price_for_product' ) ;
    $PointPricingType         = get_option( 'rs_pricing_type_global_level' ) ;
    $PointsValue              = get_option( 'rs_local_price_points_for_product' ) ;
    if ( $EnablePointPriceInGlobal == '1' ) {
        if ( $PointPricingType == '1' ) {
            if ( $PointsValue != '' ) {
                return '1' ;
            }
        } else {
            if ( $PointsValue != '' ) {
                return '2' ;
            }
        }
    }
}

function get_discount_price( $product_id ) {
    $product = rs_get_product_object( $product_id ) ;
    return $product->get_price() ;
}

function rs_common_function_to_get_earned_points_for_order( $orderid ) {
    global $wpdb ;
    $table_name            = $wpdb->prefix . 'rsrecordpoints' ;
    $order_obj             = new WC_Order( $orderid ) ;
    $overall_earned_totals = array () ;
    $revised_earned_totals = array () ;
    $order_status          = rs_get_order_obj( $order_obj ) ;
    $order_status          = $order_status[ 'order_status' ] ;
    $order_status          = str_replace( 'wc-' , '' , $order_status ) ;
    $getoverallearnpoints  = $wpdb->get_results( "SELECT earnedpoints FROM $table_name WHERE orderid=$orderid and checkpoints != 'RVPFRP'" , ARRAY_A ) ;
    foreach ( $getoverallearnpoints as $getoverallearnpointss ) {
        $overall_earned_totals[] = $getoverallearnpointss[ 'earnedpoints' ] ;
    }
    $getoverallredeempoints = $wpdb->get_results( "SELECT redeempoints FROM $table_name WHERE orderid=$orderid and checkpoints != 'RVPFPPRP'" , ARRAY_A ) ;
    foreach ( $getoverallredeempoints as $getoverallredeempointss ) {
        $overall_redeem_totals[] = $getoverallredeempointss[ 'redeempoints' ] ;
    }
    $gettotalearnpoints = $wpdb->get_results( "SELECT earnedpoints FROM $table_name WHERE checkpoints = 'PPRP' and orderid=$orderid" , ARRAY_A ) ;
    foreach ( $gettotalearnpoints as $gettotalearnpointss ) {
        $earned_totals[] = $gettotalearnpointss[ 'earnedpoints' ] ;
    }
    $getrevisedearnedpoint = $wpdb->get_results( "SELECT redeempoints FROM $table_name WHERE checkpoints = 'RVPFPPRP' and orderid=$orderid" , ARRAY_A ) ;
    foreach ( $getrevisedearnedpoint as $getrevisedearnedpoints ) {
        $revised_earned_totals[] = $getrevisedearnedpoints[ 'redeempoints' ] ;
    }
    $gettotalredeempoints = $wpdb->get_results( "SELECT redeempoints FROM $table_name WHERE checkpoints = 'RP' and orderid=$orderid" , ARRAY_A ) ;
    foreach ( $gettotalredeempoints as $gettotalredeempointss ) {
        $redeem_totals[] = $gettotalredeempointss[ 'redeempoints' ] ;
    }
    $getrevisedredeempoints = $wpdb->get_results( "SELECT earnedpoints FROM $table_name WHERE checkpoints = 'RVPFRP' and orderid=$orderid" , ARRAY_A ) ;
    foreach ( $getrevisedredeempoints as $getrevisedredeempointss ) {
        $revised_redeem_totals[] = $getrevisedredeempointss[ 'earnedpoints' ] ;
    }
    $totalearnedvalue = array_sum( $overall_earned_totals ) - array_sum( $revised_earned_totals ) ;
    return $totalearnedvalue ;
}

function rs_common_function_to_get_redeem_points_for_order( $orderid ) {
    global $wpdb ;
    $table_name            = $wpdb->prefix . 'rsrecordpoints' ;
    $order_obj             = new WC_Order( $orderid ) ;
    $order_status          = rs_get_order_obj( $order_obj ) ;
    $order_status          = $order_status[ 'order_status' ] ;
    $order_status          = str_replace( 'wc-' , '' , $order_status ) ;
    $overall_redeem_totals = array ( 0 ) ;
    $revised_redeem_totals = array ( 0 ) ;
    $getoverallearnpoints  = $wpdb->get_results( "SELECT earnedpoints FROM $table_name WHERE orderid=$orderid and checkpoints != 'RVPFRP'" , ARRAY_A ) ;
    foreach ( $getoverallearnpoints as $getoverallearnpointss ) {
        $overall_earned_totals[] = $getoverallearnpointss[ 'earnedpoints' ] ;
    }
    $getoverallredeempoints = $wpdb->get_results( "SELECT redeempoints FROM $table_name WHERE orderid=$orderid and checkpoints != 'RVPFPPRP'" , ARRAY_A ) ;
    foreach ( $getoverallredeempoints as $getoverallredeempointss ) {
        $overall_redeem_totals[] = $getoverallredeempointss[ 'redeempoints' ] ;
    }
    $gettotalearnpoints = $wpdb->get_results( "SELECT earnedpoints FROM $table_name WHERE checkpoints = 'PPRP' and orderid=$orderid" , ARRAY_A ) ;
    foreach ( $gettotalearnpoints as $gettotalearnpointss ) {
        $earned_totals[] = $gettotalearnpointss[ 'earnedpoints' ] ;
    }
    $getrevisedearnedpoint = $wpdb->get_results( "SELECT redeempoints FROM $table_name WHERE checkpoints = 'RVPFPPRP' and orderid=$orderid" , ARRAY_A ) ;
    foreach ( $getrevisedearnedpoint as $getrevisedearnedpoints ) {
        $revised_earned_totals[] = $getrevisedearnedpoints[ 'redeempoints' ] ;
    }
    $gettotalredeempoints = $wpdb->get_results( "SELECT redeempoints FROM $table_name WHERE checkpoints = 'RP' and orderid=$orderid" , ARRAY_A ) ;
    foreach ( $gettotalredeempoints as $gettotalredeempointss ) {
        $redeem_totals[] = $gettotalredeempointss[ 'redeempoints' ] ;
    }
    $getrevisedredeempoints = $wpdb->get_results( "SELECT earnedpoints FROM $table_name WHERE checkpoints = 'RVPFRP' and orderid=$orderid" , ARRAY_A ) ;
    foreach ( $getrevisedredeempoints as $getrevisedredeempointss ) {
        $revised_redeem_totals[] = $getrevisedredeempointss[ 'earnedpoints' ] ;
    }
    $totalredeemvalue = array_sum( $overall_redeem_totals ) - array_sum( $revised_redeem_totals ) ;
    return $totalredeemvalue ;
}

function footer_link() {
    global $unsublink2 ;

    return $unsublink2 ;
}

/* Function to return Payment Gateway Reward Points */

function rs_function_to_get_gateway_point( $order_id , $userid , $gatewayid ) {
    if ( get_option( 'rs_reward_type_for_payment_gateways_' . $gatewayid ) == '1' ) {
        $gatewaypoints = get_option( 'rs_reward_payment_gateways_' . $gatewayid ) ;
    } else {
        $percentpoints           = get_option( 'rs_reward_points_for_payment_gateways_in_percent_' . $gatewayid ) ;
        $pointforconversion      = earn_point_conversion() ;
        $pointforconversionvalue = earn_point_conversion_value() ;
        $cart_subtotal           = get_post_meta( $order_id , 'rs_cart_subtotal' , true ) == '' ? rs_function_to_get_cart_subtotal_excluding_discount() : get_post_meta( $order_id , 'rs_cart_subtotal' , true ) ;
        $reward_percent          = ( float ) $percentpoints / 100 ;
        $cart_average_value      = $reward_percent * $cart_subtotal ;
        $point_coversion         = $cart_average_value * $pointforconversion ;
        $gatewaypoints           = $point_coversion / $pointforconversionvalue ;
    }
    $gatewaypointss = round_off_type( $gatewaypoints ) ;
    $getthevalue    = RSMemberFunction::user_role_based_reward_points( $userid , $gatewaypointss ) ;
    return $getthevalue ;
}

function rs_function_to_get_cart_subtotal_excluding_discount() {
    if ( is_cart() || is_checkout() ) {
        global $woocommerce ;
        $discount = 0 ;
        if ( get_option( 'woocommerce_prices_include_tax' ) == 'yes' && get_option( 'woocommerce_tax_display_cart' ) == 'incl' ) {
            $cart_subtotal = $woocommerce->cart->subtotal ;
        } elseif ( get_option( 'woocommerce_prices_include_tax' ) == 'yes' && get_option( 'woocommerce_tax_display_cart' ) == 'excl' ) {
            $cart_subtotal = $woocommerce->cart->subtotal_ex_tax ;
        } elseif ( get_option( 'woocommerce_prices_include_tax' ) == 'no' && get_option( 'woocommerce_tax_display_cart' ) == 'incl' ) {
            $cart_subtotal = $woocommerce->cart->subtotal ;
        } else {
            $cart_subtotal = $woocommerce->cart->subtotal_ex_tax ;
        }
        if ( ( float ) $woocommerce->version >= ( float ) '3.2.0' ) {
            $discount = $woocommerce->cart->get_discount_tax() + $woocommerce->cart->get_discount_total() ;
        } else {
//            $discount = $woocommerce->cart->discount_tax + $woocommerce->cart->discount_total ;
            $discount = $woocommerce->cart->discount_cart + $woocommerce->cart->discount_cart_tax ;
        }
        $cart_subtotal_excluding_discount = $cart_subtotal - $discount ;
        return $cart_subtotal_excluding_discount ;
    }
}

/* Function to return Cart Subtotal */

function rs_function_to_get_cart_subtotal() {
    global $woocommerce ;
    if ( get_option( 'woocommerce_prices_include_tax' ) == 'yes' && get_option( 'woocommerce_tax_display_cart' ) == 'incl' ) {
        $cart_subtotal = $woocommerce->cart->subtotal ;
    } elseif ( get_option( 'woocommerce_prices_include_tax' ) == 'yes' && get_option( 'woocommerce_tax_display_cart' ) == 'excl' ) {
        $cart_subtotal = $woocommerce->cart->subtotal_ex_tax ;
    } elseif ( get_option( 'woocommerce_prices_include_tax' ) == 'no' && get_option( 'woocommerce_tax_display_cart' ) == 'incl' ) {
        $cart_subtotal = $woocommerce->cart->subtotal ;
    } else {
        $cart_subtotal = $woocommerce->cart->subtotal_ex_tax ;
    }
    return $cart_subtotal ;
}

/* Function to return whether to award Product Purchase Reward Points for Renewal Orders */

function rs_function_to_provide_points_for_renewal_order( $order_id ) {
    if ( get_option( 'rs_award_point_for_renewal_order' ) == 'yes' && get_post_meta( $order_id , 'sumo_renewal_order_date' , true ) != '' ) {
        return false ;
    } else {
        return true ;
    }
}

/* Function to return whether to award Referral Product Purchase Reward Points for Renewal Orders */

function rs_function_to_provide_referral_points_for_renewal_order( $order_id ) {
    if ( get_option( 'rs_award_referral_point_for_renewal_order' ) == 'yes' && get_post_meta( $order_id , 'sumo_renewal_order_date' , true ) != '' ) {
        return false ;
    } else {
        return true ;
    }
}

function rs_function_to_get_level( $productid , $variationid , $referred_user , $getting_referrer , $socialreward ) {
    if ( $socialreward == 'yes' ) {
        if ( get_option( 'rs_enable_product_category_level_for_social_reward' ) == 'no' ) {
            $options_to_check = array (
                'applicable_for'      => get_option( 'rs_social_reward_global_level_applicable_for' ) ,
                'included_products'   => get_option( 'rs_include_products_for_social_reward' ) ,
                'excluded_products'   => get_option( 'rs_exclude_products_for_social_reward' ) ,
                'included_categories' => get_option( 'rs_include_particular_categories_for_social_reward' ) ,
                'excluded_categories' => get_option( 'rs_exclude_particular_categories_for_social_reward' )
                    ) ;
            if ( get_option( 'rs_global_social_enable_disable_reward' ) === '1' ) {
                $product_filter = rs_function_to_get_filtered_product( $productid , $variationid , $options_to_check ) ;
                return $product_filter ;
            } else {
                return false ;
            }
        } elseif ( get_option( 'rs_enable_product_category_level_for_social_reward' ) == 'yes' ) {
            return '1' ;
        }
    } elseif ( $referred_user != '' || $getting_referrer == 'yes' ) {
        if ( get_option( 'rs_enable_product_category_level_for_referral_product_purchase' ) == 'no' ) {
            $options_to_check = array (
                'applicable_for'      => get_option( 'rs_referral_product_purchase_global_level_applicable_for' ) ,
                'included_products'   => get_option( 'rs_include_products_for_referral_product_purchase' ) ,
                'excluded_products'   => get_option( 'rs_exclude_products_for_referral_product_purchase' ) ,
                'included_categories' => get_option( 'rs_include_particular_categories_for_referral_product_purchase' ) ,
                'excluded_categories' => get_option( 'rs_exclude_particular_categories_for_referral_product_purchase' )
                    ) ;
            $product_filter   = rs_function_to_get_filtered_product( $productid , $variationid , $options_to_check ) ;
            return $product_filter ;
        } elseif ( get_option( 'rs_enable_product_category_level_for_referral_product_purchase' ) == 'yes' ) {
            return '1' ;
        }
    } else {
        if ( get_option( 'rs_enable_product_category_level_for_product_purchase' ) == 'no' ) {
            $options_to_check = array (
                'applicable_for'      => get_option( 'rs_product_purchase_global_level_applicable_for' ) ,
                'included_products'   => get_option( 'rs_include_products_for_product_purchase' ) ,
                'excluded_products'   => get_option( 'rs_exclude_products_for_product_purchase' ) ,
                'included_categories' => get_option( 'rs_include_particular_categories_for_product_purchase' ) ,
                'excluded_categories' => get_option( 'rs_exclude_particular_categories_for_product_purchase' )
                    ) ;
            $product_filter   = rs_function_to_get_filtered_product( $productid , $variationid , $options_to_check ) ;
            return $product_filter ;
        } elseif ( get_option( 'rs_enable_product_category_level_for_product_purchase' ) == 'yes' ) {
            return '1' ;
        }
    }
}

function rs_function_to_get_filtered_product( $productid , $variationid , $options_to_check ) {
    $product_id = $variationid != ('' || 0) ? $variationid : $productid ;
    if ( $options_to_check[ 'applicable_for' ] == '1' ) {
        return '2' ;
    } elseif ( $options_to_check[ 'applicable_for' ] == '2' ) {
        $includedproduct  = $options_to_check[ 'included_products' ] ;
        $included_product = is_array( $includedproduct ) ? $includedproduct : explode( ',' , $includedproduct ) ;
        if ( in_array( $product_id , $included_product ) ) {
            return '2' ;
        }
    } elseif ( $options_to_check[ 'applicable_for' ] == '3' ) {
        $excludedproduct  = $options_to_check[ 'excluded_products' ] ;
        $excluded_product = is_array( $excludedproduct ) ? $excludedproduct : explode( ',' , $excludedproduct ) ;
        $var_pdt_id       = implode( " " , $excluded_product ) ;
        $checkproducts    = rs_get_product_object( $var_pdt_id ) ;
        if ( is_object( $checkproducts ) && (rs_check_variable_product_type( $checkproducts )) ) {
            if ( is_array( $checkproducts->get_available_variations() ) ) {
                foreach ( $checkproducts->get_available_variations() as $getvariation ) {
                    $excluded_product[] = $getvariation[ 'variation_id' ] ;
                }
            }
        }
        if ( ! in_array( $product_id , $excluded_product ) ) {
            return '2' ;
        }
    } elseif ( $options_to_check[ 'applicable_for' ] == '4' ) {
        $term = get_the_terms( $productid , 'product_cat' ) ;
        if ( is_array( $term ) && ! empty( $term ) ) {
            return '2' ;
        }
    } elseif ( $options_to_check[ 'applicable_for' ] == '5' ) {
        $includedcat  = $options_to_check[ 'included_categories' ] ;
        $included_cat = is_array( $includedcat ) ? $includedcat : explode( ',' , $includedcat ) ;
        if ( ! empty( $included_cat ) ) {
            foreach ( $included_cat as $eachcat ) {
                $term = get_the_terms( $productid , 'product_cat' ) ;
                if ( is_array( $term ) ) {
                    foreach ( $term as $termidlist ) {
                        if ( $eachcat == $termidlist->term_id ) {
                            return '2' ;
                        }
                    }
                }
            }
        }
    } else {
        $excluded_cat = $options_to_check[ 'excluded_categories' ] ;
        if ( ! is_array( $excluded_cat ) ) {
            $excluded_cat = ( array ) $options_to_check[ 'excluded_categories' ] ;
        }
        $count = 0 ;
        if ( ! empty( $excluded_cat ) ) {
            $term = get_the_terms( $productid , 'product_cat' ) ;
            if ( is_array( $term ) ) {
                foreach ( $term as $termidlist ) {
                    if ( in_array( $termidlist->term_id , $excluded_cat ) ) {
                        $count ++ ;
                    }
                }
                if ( $count == 0 ) {
                    return '2' ;
                }
            }
        }
    }
}

/* Function For Checking in Which level Reward points is Awarded */

function check_level_of_enable_reward_point( $productid , $variationid , $item , $checklevel , $referred_user , $getting_referrer , $socialreward , $rewardfor , $payment_price = 0 ) {
    global $woocommerce ;
    $memebershiprestrict = 'no' ;
    $arr                 = array () ;
    if ( get_option( 'rs_enable_restrict_reward_points' ) == 'yes' && function_exists( 'sumo_get_membership_levels' ) ) {
        $memebershiprestrict = 'yes' ;
        $arr                 = sumo_get_membership_levels() ;
        if ( ! empty( $arr ) ) {
            $memebershiprestrict = 'no' ;
        }
    }
    $itemquantity = isset( $item[ 'qty' ] ) ? $item[ 'qty' ] : $item[ 'quantity' ] ;
    if ( $memebershiprestrict == 'no' ) {
        $product_category_level = rs_function_to_get_level( $productid , $variationid , $referred_user , $getting_referrer , $socialreward ) ;
        if ( $product_category_level == '1' ) {
            return is_product_level( $productid , $variationid , $item , $checklevel , $referred_user , $getting_referrer , $socialreward , $rewardfor , $payment_price , $itemquantity ) ;
        } elseif ( $product_category_level == '2' ) {
            return is_global_level( $productid , $variationid , $item , $checklevel , $referred_user , $getting_referrer , $socialreward , $rewardfor , $payment_price , $itemquantity ) ;
        }
    }
}

function is_product_level( $productid , $variationid , $item , $checklevel , $referred_user , $getting_referrer , $socialreward , $rewardfor , $payment_price , $itemquantity ) {
    //Product Level
    if ( $referred_user != '' ) {
        $productlevel              = $variationid == '0' || '' ? RSFunctionForSavingMetaValues::rewardsystem_get_post_meta( $productid , '_rewardsystemreferralcheckboxvalue' ) : RSFunctionForSavingMetaValues::rewardsystem_get_post_meta( $variationid , '_enable_reward_points' ) ;
        $productlevelrewardtype    = $variationid == '0' || '' ? RSFunctionForSavingMetaValues::rewardsystem_get_post_meta( $productid , '_referral_rewardsystem_options' ) : RSFunctionForSavingMetaValues::rewardsystem_get_post_meta( $variationid , '_select_referral_reward_rule' ) ;
        $productlevelrewardpoints  = $variationid == '0' || '' ? RSFunctionForSavingMetaValues::rewardsystem_get_post_meta( $productid , '_referralrewardsystempoints' ) : RSFunctionForSavingMetaValues::rewardsystem_get_post_meta( $variationid , '_referral_reward_points' ) ;
        $productlevelrewardpercent = $variationid == '0' || '' ? RSFunctionForSavingMetaValues::rewardsystem_get_post_meta( $productid , '_referralrewardsystempercent' ) : RSFunctionForSavingMetaValues::rewardsystem_get_post_meta( $variationid , '_referral_reward_percent' ) ;
        if ( $getting_referrer == 'yes' ) {
            $productlevel              = $variationid == '0' || '' ? RSFunctionForSavingMetaValues::rewardsystem_get_post_meta( $productid , '_rewardsystemreferralcheckboxvalue' ) : RSFunctionForSavingMetaValues::rewardsystem_get_post_meta( $variationid , '_enable_reward_points' ) ;
            $productlevelrewardtype    = $variationid == '0' || '' ? RSFunctionForSavingMetaValues::rewardsystem_get_post_meta( $productid , '_referral_rewardsystem_options_getrefer' ) : RSFunctionForSavingMetaValues::rewardsystem_get_post_meta( $variationid , '_select_referral_reward_rule_getrefer' ) ;
            $productlevelrewardpoints  = $variationid == '0' || '' ? RSFunctionForSavingMetaValues::rewardsystem_get_post_meta( $productid , '_referralrewardsystempoints_for_getting_referred' ) : RSFunctionForSavingMetaValues::rewardsystem_get_post_meta( $variationid , '_referral_reward_points_getting_refer' ) ;
            $productlevelrewardpercent = $variationid == '0' || '' ? RSFunctionForSavingMetaValues::rewardsystem_get_post_meta( $productid , '_referralrewardsystempercent_for_getting_referred' ) : RSFunctionForSavingMetaValues::rewardsystem_get_post_meta( $variationid , '_referral_reward_percent_getting_refer' ) ;
        }
        $regularprice    = rs_function_to_get_regular_price( $productid , $variationid , $item , $itemquantity , $payment_price ) ;
        $convertedpoints = rs_convert_reward_percent_value( $productlevelrewardpercent , $regularprice ) ;
        if ( (get_option( 'rs_restrict_referral_reward' ) == 'yes' ) ) {
            $convertedpoints = $convertedpoints / $itemquantity ;
            $itemquantity    = 1 ;
        }
    } elseif ( $getting_referrer == 'yes' ) {
        $productlevel              = $variationid == '0' || '' ? RSFunctionForSavingMetaValues::rewardsystem_get_post_meta( $productid , '_rewardsystemreferralcheckboxvalue' ) : RSFunctionForSavingMetaValues::rewardsystem_get_post_meta( $variationid , '_enable_reward_points' ) ;
        $productlevelrewardtype    = $variationid == '0' || '' ? RSFunctionForSavingMetaValues::rewardsystem_get_post_meta( $productid , '_referral_rewardsystem_options_getrefer' ) : RSFunctionForSavingMetaValues::rewardsystem_get_post_meta( $variationid , '_select_referral_reward_rule_getrefer' ) ;
        $productlevelrewardpoints  = $variationid == '0' || '' ? RSFunctionForSavingMetaValues::rewardsystem_get_post_meta( $productid , '_referralrewardsystempoints_for_getting_referred' ) : RSFunctionForSavingMetaValues::rewardsystem_get_post_meta( $variationid , '_referral_reward_points_getting_refer' ) ;
        $productlevelrewardpercent = $variationid == '0' || '' ? RSFunctionForSavingMetaValues::rewardsystem_get_post_meta( $productid , '_referralrewardsystempercent_for_getting_referred' ) : RSFunctionForSavingMetaValues::rewardsystem_get_post_meta( $variationid , '_referral_reward_percent_getting_refer' ) ;
        $regularprice              = rs_function_to_get_regular_price( $productid , $variationid , $item , $itemquantity , $payment_price ) ;
        $convertedpoints           = rs_convert_reward_percent_value( $productlevelrewardpercent , $regularprice ) ;
    } elseif ( $socialreward == 'yes' ) {
        $newarray                  = rs_function_to_get_social_rewardspoints( $productid , $rewardfor , $level                     = '1' , $termid                    = '' ) ;
        $productlevel              = $newarray[ 'enable_level' ] ;
        $productlevelrewardtype    = $newarray[ 'rewardtype' ] ;
        $productlevelrewardpoints  = $newarray[ 'rewardpoints' ] ;
        $productlevelrewardpercent = $newarray[ 'rewardpercent' ] ;
        $regularprice              = rs_function_to_get_regular_price( $productid , $variationid , $item , $itemquantity , $payment_price ) ;
        $convertedpoints           = rs_convert_reward_percent_value( $productlevelrewardpercent , $regularprice ) ;
    } else {
        $productlevel              = $variationid == '0' || '' ? RSFunctionForSavingMetaValues::rewardsystem_get_post_meta( $productid , '_rewardsystemcheckboxvalue' ) : RSFunctionForSavingMetaValues::rewardsystem_get_post_meta( $variationid , '_enable_reward_points' ) ;
        $productlevelrewardtype    = $variationid == '0' || '' ? RSFunctionForSavingMetaValues::rewardsystem_get_post_meta( $productid , '_rewardsystem_options' ) : RSFunctionForSavingMetaValues::rewardsystem_get_post_meta( $variationid , '_select_reward_rule' ) ;
        $productlevelrewardpoints  = $variationid == '0' || '' ? RSFunctionForSavingMetaValues::rewardsystem_get_post_meta( $productid , '_rewardsystempoints' ) : RSFunctionForSavingMetaValues::rewardsystem_get_post_meta( $variationid , '_reward_points' ) ;
        $productlevelrewardpercent = $variationid == '0' || '' ? RSFunctionForSavingMetaValues::rewardsystem_get_post_meta( $productid , '_rewardsystempercent' ) : RSFunctionForSavingMetaValues::rewardsystem_get_post_meta( $variationid , '_reward_percent' ) ;
        $regularprice              = rs_function_to_get_regular_price( $productid , $variationid , $item , $itemquantity , $payment_price ) ;
        $convertedpoints           = rs_convert_reward_percent_value( $productlevelrewardpercent , $regularprice ) ;
        if ( get_option( 'rs_restrict_reward' ) == 'yes' ) {
            $convertedpoints = $convertedpoints / $itemquantity ;
            $itemquantity    = 1 ;
        }
    }
    if ( ($productlevel == 'yes') || ($productlevel == '1') ) {
        if ( $productlevelrewardtype == '1' && $productlevelrewardpoints != '' ) {
            if ( $checklevel == 'yes' ) {
                return '1' ;
            } else {
                return $productlevelrewardpoints * $itemquantity ;
            }
        } elseif ( $productlevelrewardtype == '2' && $productlevelrewardpercent != '' ) {
            if ( $checklevel == 'yes' ) {
                return '1' ;
            } else {
                return $convertedpoints ;
            }
        }
        return is_category_level( $productid , $variationid , $item , $checklevel , $referred_user , $getting_referrer , $socialreward , $rewardfor , $payment_price , $itemquantity ) ;
    }
}

function is_category_level( $productid , $variationid , $item , $checklevel , $referred_user , $getting_referrer , $socialreward , $rewardfor , $payment_price , $itemquantity ) {
    //Category Level
    $categorylist      = wp_get_post_terms( $productid , 'product_cat' ) ;
    $getcount          = count( $categorylist ) ;
    $term              = get_the_terms( $productid , 'product_cat' ) ;
    $cat_level_enabled = array () ;
    $cat_level_point   = array () ;
    $cat_level_percent = array () ;
    if ( is_array( $term ) ) {
        foreach ( $term as $terms ) {
            $termid = $terms->term_id ;
            if ( $referred_user != '' ) {
                $categorylevel              = RSFunctionForSavingMetaValues::rewardsystem_get_woocommerce_term_meta( $termid , 'enable_referral_reward_system_category' ) ;
                $categorylevelrewardtype    = RSFunctionForSavingMetaValues::rewardsystem_get_woocommerce_term_meta( $termid , 'referral_enable_rs_rule' ) ;
                $categorylevelrewardpoints  = RSFunctionForSavingMetaValues::rewardsystem_get_woocommerce_term_meta( $termid , 'referral_rs_category_points' ) ;
                $categorylevelrewardpercent = RSFunctionForSavingMetaValues::rewardsystem_get_woocommerce_term_meta( $termid , 'referral_rs_category_percent' ) ;
                if ( $getting_referrer == 'yes' ) {
                    $categorylevel              = RSFunctionForSavingMetaValues::rewardsystem_get_woocommerce_term_meta( $termid , 'enable_referral_reward_system_category' ) ;
                    $categorylevelrewardtype    = RSFunctionForSavingMetaValues::rewardsystem_get_woocommerce_term_meta( $termid , 'referral_enable_rs_rule_refer' ) ;
                    $categorylevelrewardpoints  = RSFunctionForSavingMetaValues::rewardsystem_get_woocommerce_term_meta( $termid , 'referral_rs_category_points_get_refered' ) ;
                    $categorylevelrewardpercent = RSFunctionForSavingMetaValues::rewardsystem_get_woocommerce_term_meta( $termid , 'referral_rs_category_percent_get_refer' ) ;
                }
                $regularprice    = rs_function_to_get_regular_price( $productid , $variationid , $item , $itemquantity , $payment_price ) ;
                $convertedpoints = rs_convert_reward_percent_value( $categorylevelrewardpercent , $regularprice ) ;
                if ( (get_option( 'rs_restrict_referral_reward' ) == 'yes' ) ) {
                    $convertedpoints = $convertedpoints / $itemquantity ;
                    $itemquantity    = 1 ;
                }
            } elseif ( $getting_referrer == 'yes' ) {
                $categorylevel              = RSFunctionForSavingMetaValues::rewardsystem_get_woocommerce_term_meta( $termid , 'enable_referral_reward_system_category' ) ;
                $categorylevelrewardtype    = RSFunctionForSavingMetaValues::rewardsystem_get_woocommerce_term_meta( $termid , 'referral_enable_rs_rule_refer' ) ;
                $categorylevelrewardpoints  = RSFunctionForSavingMetaValues::rewardsystem_get_woocommerce_term_meta( $termid , 'referral_rs_category_points_get_refered' ) ;
                $categorylevelrewardpercent = RSFunctionForSavingMetaValues::rewardsystem_get_woocommerce_term_meta( $termid , 'referral_rs_category_percent_get_refer' ) ;
                $regularprice               = rs_function_to_get_regular_price( $productid , $variationid , $item , $itemquantity , $payment_price ) ;
                $convertedpoints            = rs_convert_reward_percent_value( $categorylevelrewardpercent , $regularprice ) ;
            } elseif ( $socialreward == 'yes' ) {
                $newarray                   = rs_function_to_get_social_rewardspoints( $productid , $rewardfor , $level                      = '2' , $termid ) ;
                $categorylevel              = $newarray[ 'enable_level' ] ;
                $categorylevelrewardtype    = $newarray[ 'rewardtype' ] ;
                $categorylevelrewardpoints  = $newarray[ 'rewardpoints' ] ;
                $categorylevelrewardpercent = $newarray[ 'rewardpercent' ] ;
                $regularprice               = rs_function_to_get_regular_price( $productid , $variationid , $item , $itemquantity , $payment_price ) ;
                $convertedpoints            = rs_convert_reward_percent_value( $categorylevelrewardpercent , $regularprice ) ;
            } else {
                $categorylevel              = RSFunctionForSavingMetaValues::rewardsystem_get_woocommerce_term_meta( $termid , 'enable_reward_system_category' ) ;
                $categorylevelrewardtype    = RSFunctionForSavingMetaValues::rewardsystem_get_woocommerce_term_meta( $termid , 'enable_rs_rule' ) ;
                $categorylevelrewardpoints  = RSFunctionForSavingMetaValues::rewardsystem_get_woocommerce_term_meta( $termid , 'rs_category_points' ) ;
                $categorylevelrewardpercent = RSFunctionForSavingMetaValues::rewardsystem_get_woocommerce_term_meta( $termid , 'rs_category_percent' ) ;
                $regularprice               = rs_function_to_get_regular_price( $productid , $variationid , $item , $itemquantity , $payment_price ) ;
                $convertedpoints            = rs_convert_reward_percent_value( $categorylevelrewardpercent , $regularprice ) ;
                if ( get_option( 'rs_restrict_reward' ) == 'yes' ) {
                    $convertedpoints = $convertedpoints / $itemquantity ;
                    $itemquantity    = 1 ;
                }
            }
            if ( $getcount >= 1 ) {
                if ( ($categorylevel == 'yes' ) ) {
                    if ( ($categorylevelrewardtype == '1') && $categorylevelrewardpoints != '' ) {
                        if ( $checklevel == 'yes' ) {
                            $cat_level_enabled[] = '2' ;
                        } else {
                            $quantity          = get_option( 'rs_restrict_reward' ) == 'yes' ? 1 : $itemquantity ;
                            $cat_level_point[] = $categorylevelrewardpoints * $quantity ;
                        }
                    } else if ( ($categorylevelrewardtype == '2') && $categorylevelrewardpercent != '' ) {
                        if ( $checklevel == 'yes' ) {
                            $cat_level_enabled[] = '2' ;
                        } else {
                            $cat_level_point[] = $convertedpoints ;
                        }
                    }
                }
            }
        }
        if ( ! empty( $cat_level_point ) ) {
            $category_points = max( $cat_level_point ) ;
            return $category_points ;
        } elseif ( ! empty( $cat_level_enabled ) ) {
            return '2' ;
        }
    }
    if ( empty( $cat_level_point ) || empty( $cat_level_enabled ) ) {
        return is_global_level( $productid , $variationid , $item , $checklevel , $referred_user , $getting_referrer , $socialreward , $rewardfor , $payment_price , $itemquantity ) ;
    }
}

function is_global_level( $productid , $variationid , $item , $checklevel , $referred_user , $getting_referrer , $socialreward , $rewardfor , $payment_price , $itemquantity ) {
    //Global Level
    if ( $referred_user != '' ) {
        $global_enable        = get_option( 'rs_global_enable_disable_sumo_referral_reward' ) ;
        $global_reward_type   = get_option( 'rs_global_referral_reward_type' ) ;
        $global_rewardpoints  = get_option( 'rs_global_referral_reward_point' ) ;
        $global_rewardpercent = get_option( 'rs_global_referral_reward_percent' ) ;
        if ( $getting_referrer == 'yes' ) {
            $global_enable        = get_option( 'rs_global_enable_disable_sumo_referral_reward' ) ;
            $global_reward_type   = get_option( 'rs_global_referral_reward_type_refer' ) ;
            $global_rewardpoints  = get_option( 'rs_global_referral_reward_point_get_refer' ) ;
            $global_rewardpercent = get_option( 'rs_global_referral_reward_percent_get_refer' ) ;
        }
        $regularprice    = rs_function_to_get_regular_price( $productid , $variationid , $item , $itemquantity , $payment_price ) ;
        $convertedpoints = rs_convert_reward_percent_value( $global_rewardpercent , $regularprice ) ;
        if ( (get_option( 'rs_restrict_referral_reward' ) == 'yes' ) ) {
            $convertedpoints = $convertedpoints / $itemquantity ;
            $itemquantity    = 1 ;
        }
    } elseif ( $getting_referrer == 'yes' ) {
        $global_enable        = get_option( 'rs_global_enable_disable_sumo_referral_reward' ) ;
        $global_reward_type   = get_option( 'rs_global_referral_reward_type_refer' ) ;
        $global_rewardpoints  = get_option( 'rs_global_referral_reward_point_get_refer' ) ;
        $global_rewardpercent = get_option( 'rs_global_referral_reward_percent_get_refer' ) ;
        $regularprice         = rs_function_to_get_regular_price( $productid , $variationid , $item , $itemquantity , $payment_price ) ;
        $convertedpoints      = rs_convert_reward_percent_value( $global_rewardpercent , $regularprice ) ;
    } elseif ( $socialreward == 'yes' ) {
        $newarray             = rs_function_to_get_social_rewardspoints( $productid , $rewardfor , $level                = '3' , $termid               = '' ) ;
        $global_enable        = $newarray[ 'enable_level' ] ;
        $global_reward_type   = $newarray[ 'rewardtype' ] ;
        $global_rewardpoints  = $newarray[ 'rewardpoints' ] ;
        $global_rewardpercent = $newarray[ 'rewardpercent' ] ;
        $regularprice         = rs_function_to_get_regular_price( $productid , $variationid , $item , $itemquantity , $payment_price ) ;
        $convertedpoints      = rs_convert_reward_percent_value( $global_rewardpercent , $regularprice ) ;
    } else {
        $global_enable        = get_option( 'rs_global_enable_disable_sumo_reward' ) ;
        $global_reward_type   = get_option( 'rs_global_reward_type' ) ;
        $global_rewardpoints  = get_option( 'rs_global_reward_points' ) ;
        $global_rewardpercent = get_option( 'rs_global_reward_percent' ) ;
        $regularprice         = rs_function_to_get_regular_price( $productid , $variationid , $item , $itemquantity , $payment_price ) ;
        $convertedpoints      = rs_convert_reward_percent_value( $global_rewardpercent , $regularprice ) ;
        if ( get_option( 'rs_restrict_reward' ) == 'yes' ) {
            $convertedpoints = $convertedpoints / $itemquantity ;
            $itemquantity    = 1 ;
        }
    }

    if ( $global_enable == '1' ) {
        if ( $global_reward_type == '1' ) {
            if ( $global_rewardpoints != '' ) {
                if ( $checklevel == 'yes' ) {
                    return '3' ;
                } else {
                    $quantity = get_option( 'rs_restrict_reward' ) == 'yes' ? 1 : $itemquantity ;
                    return $global_rewardpoints * $quantity ;
                }
            }
        } else {
            if ( $global_rewardpercent != '' ) {
                if ( $checklevel == 'yes' ) {
                    return '3' ;
                } else {
                    return $convertedpoints ;
                }
            }
        }
    } else {
        return '0' ;
    }
}

/* Function to Convert Reward Percent into Points */

function rs_convert_reward_percent_value( $rewardpercent , $regularprice ) {
    $pointforconversion      = earn_point_conversion() ;
    $pointforconversionvalue = earn_point_conversion_value() ;
    $get_rewardpercent       = ( float ) $rewardpercent / 100 ;
    $getaveragepoints        = $get_rewardpercent * $regularprice ;
    $pointswithvalue         = $getaveragepoints * $pointforconversion ;
    $rewardpoints            = $pointswithvalue / $pointforconversionvalue ;
    return $rewardpoints ;
}

function rs_function_to_get_regular_price( $productid , $variationid , $item , $itemquantity , $payment_price ) {
    $productid              = ($variationid == '' || $variationid == 0) ? $productid : $variationid ;
    $mainproductdatabooking = rs_get_product_object( $productid ) ;
    $getregularprice        = '' ;
    if ( $mainproductdatabooking && $mainproductdatabooking->is_type( 'variation' ) ) {
        $initial_payment_chk    = check_initial_payment_pdt( $variationid ) ;
        $payment_price_frontend = get_payment_data_for_payment_plan( $variationid ) ;
    } else {
        $initial_payment_chk    = check_initial_payment_pdt( $productid ) ;
        $payment_price_frontend = get_payment_data_for_payment_plan( $productid ) ;
    }

    if ( ! is_shop() && ! is_product() && ! is_cart() && ! is_product_category() ) {
        if ( (is_object( $item )) || (is_array( $item )) && ! empty( $item ) ) {
            $line_subtotal     = isset( $item[ 'line_subtotal' ] ) ? $item[ 'line_subtotal' ] : 0 ;
            $line_subtotal_tax = isset( $item[ 'line_subtotal_tax' ] ) ? $item[ 'line_subtotal_tax' ] : 0 ;
            if ( isset( $item[ 'qty' ] ) && ! $line_subtotal ) {
                if ( $variationid != '' && $variationid != 0 ) {
                    $variable_product = new WC_Product_Variation( $variationid ) ;
                    if ( get_option( 'woocommerce_tax_display_shop' ) == 'incl' && get_option( 'woocommerce_prices_include_tax' ) == 'no' ) {
                        $getregularprice = rs_get_price_including_tax( $variable_product ) ;
                    } elseif ( get_option( 'woocommerce_tax_display_shop' ) == 'incl' && get_option( 'woocommerce_prices_include_tax' ) == 'yes' ) {
                        $getregularprice = rs_get_price_including_tax( $variable_product ) ;
                    } elseif ( get_option( 'woocommerce_tax_display_shop' ) == 'excl' && get_option( 'woocommerce_prices_include_tax' ) == 'yes' ) {
                        $getregularprice = rs_get_price_excluding_tax( $variable_product ) ;
                    } else {
                        $getregularprice = is_object( $variable_product ) ? ( float ) $variable_product->get_price() * $itemquantity : 0 ;
                    }
                } else {
                    $getregularprice = is_object( $mainproductdatabooking ) ? ( float ) $mainproductdatabooking->get_price() * $itemquantity : 0 ;
                }
            } else {
                if ( get_option( 'woocommerce_tax_display_cart' ) == 'incl' && get_option( 'woocommerce_prices_include_tax' ) == 'no' ) {
                    if ( $payment_price == 0 ) {
                        $getregularprice = $line_subtotal + $line_subtotal_tax ;
                    } else {
                        $getregularprice = $payment_price + $line_subtotal_tax ;
                    }
                } elseif ( get_option( 'woocommerce_tax_display_cart' ) == 'incl' && get_option( 'woocommerce_prices_include_tax' ) == 'yes' ) {
                    if ( $payment_price == 0 ) {
                        $getregularprice = $line_subtotal + $line_subtotal_tax ;
                    } else {
                        $getregularprice = $payment_price + $line_subtotal_tax ;
                    }
                } elseif ( get_option( 'woocommerce_tax_display_cart' ) == 'excl' && get_option( 'woocommerce_prices_include_tax' ) == 'yes' ) {
                    if ( $payment_price == 0 ) {
                        $getregularprice = $line_subtotal ;
                    } else {
                        $getregularprice = $payment_price ;
                    }
                } else {
                    if ( $payment_price == 0 ) {
                        $getregularprice = $line_subtotal ;
                    } else {
                        $getregularprice = $payment_price ;
                    }
                }
            }
        } else {
            $getregularprice = is_object( $mainproductdatabooking ) ? ( float ) $mainproductdatabooking->get_price() * $itemquantity : 0 ;
        }
    } elseif ( is_cart() || is_checkout() ) {
        $line_subtotal     = isset( $item[ 'line_subtotal' ] ) ? $item[ 'line_subtotal' ] : 0 ;
        $line_subtotal_tax = isset( $item[ 'line_subtotal_tax' ] ) ? $item[ 'line_subtotal_tax' ] : 0 ;
        if ( get_option( 'woocommerce_tax_display_cart' ) == 'incl' && get_option( 'woocommerce_prices_include_tax' ) == 'no' ) {
            if ( $initial_payment_chk == false ) {
                $getregularprice = $line_subtotal + $line_subtotal_tax ;
            } else {
                $getregularprice = $payment_price_frontend + $line_subtotal_tax ;
            }
        } elseif ( get_option( 'woocommerce_tax_display_cart' ) == 'incl' && get_option( 'woocommerce_prices_include_tax' ) == 'yes' ) {
            if ( $initial_payment_chk == false ) {
                $getregularprice = $line_subtotal + $line_subtotal_tax ;
            } else {
                $getregularprice = $payment_price_frontend + $line_subtotal_tax ;
            }
        } elseif ( get_option( 'woocommerce_tax_display_cart' ) == 'excl' && get_option( 'woocommerce_prices_include_tax' ) == 'yes' ) {
            if ( $initial_payment_chk == false ) {
                $getregularprice = $line_subtotal ;
            } else {
                $getregularprice = $payment_price_frontend ;
            }
        } else {
            if ( $payment_price == 0 ) {
                $getregularprice = $line_subtotal ;
            } else {
                $getregularprice = $payment_price ;
            }
        }
        global $woocommerce ;
        $variation_parent_id        = '' ;
        $simple_productid           = '' ;
        $overallvariation_id        = '' ;
        $related_cross_sell_product = array () ;
        $cart_item_product_id       = array () ;
        $cart_item_variation_id     = array () ;

        if ( ! empty( $woocommerce->cart->cart_contents ) ) {
            foreach ( $woocommerce->cart->cart_contents as $cart_item ) {
                $cart_item_product_id[]   = $cart_item[ 'product_id' ] ;
                $cart_item_variation_id[] = $cart_item[ 'variation_id' ] ;
                $object_data              = isset( $cart_item[ 'data' ] ) ? $cart_item[ 'data' ] : '' ;
                if ( is_object( $object_data ) && ( ! empty( $object_data )) ) {
                    $related_cross_sell_product[] = ( array ) $object_data->get_cross_sell_ids() ;
                }
            }
        }

        $related_product  = false ;
        $simple_product   = false ;
        $variable_product = false ;
        global $woocommerce_loop ;
        if ( ( float ) $woocommerce->version >= ( float ) '3.3.0' ) {
            if ( (isset( $woocommerce_loop[ 'name' ] ) && $woocommerce_loop[ 'name' ] == 'cross-sells' ) )
                $related_product = true ;
        }

        if ( $mainproductdatabooking->is_type( 'variation' ) ) {
            $variation_parent_id = wp_get_post_parent_id( $variationid ) ;
            if ( is_array( $cart_item_variation_id ) && ! empty( $cart_item_variation_id ) ) {
                if ( ! in_array( $variation_parent_id , $cart_item_variation_id ) ) {
                    $overallvariation_id = $variation_parent_id ;
                }
            }
        } else {
            if ( is_array( $cart_item_product_id ) && ! empty( $cart_item_product_id ) ) {
                if ( ! in_array( $productid , $cart_item_product_id ) ) {
                    $simple_productid = $productid ;
                }
            }
        }
        foreach ( $related_cross_sell_product as $related_cross_sell_products ) {
            if ( is_array( $related_cross_sell_products ) && ! empty( $related_cross_sell_products ) ) {

                if ( in_array( $simple_productid , $related_cross_sell_products ) )
                    $simple_product = true ;

                if ( in_array( $overallvariation_id , $related_cross_sell_products ) )
                    $variable_product = true ;
            }
        }

        if ( $related_product == true && ($simple_product == true || $variable_product == true) ) {
            if ( $mainproductdatabooking->is_type( 'variation' ) ) {
                $variable_product = new WC_Product_Variation( $variationid ) ;
                if ( get_option( 'woocommerce_tax_display_shop' ) == 'incl' && get_option( 'woocommerce_prices_include_tax' ) == 'no' ) {
                    $getregularprice = rs_get_price_including_tax( $variable_product ) ;
                } elseif ( get_option( 'woocommerce_tax_display_shop' ) == 'incl' && get_option( 'woocommerce_prices_include_tax' ) == 'yes' ) {
                    $getregularprice = rs_get_price_including_tax( $variable_product ) ;
                } elseif ( get_option( 'woocommerce_tax_display_shop' ) == 'excl' && get_option( 'woocommerce_prices_include_tax' ) == 'yes' ) {
                    $getregularprice = rs_get_price_excluding_tax( $variable_product ) ;
                } else {
                    $getregularprice = is_object( $variable_product ) ? ( float ) $variable_product->get_price() * $itemquantity : 0 ;
                }
            } else {
                $getregularprice = is_object( $mainproductdatabooking ) ? ( float ) $mainproductdatabooking->get_price() * $itemquantity : 0 ;
                if ( get_option( 'woocommerce_tax_display_shop' ) == 'incl' && get_option( 'woocommerce_prices_include_tax' ) == 'no' ) {
                    $getregularprice = rs_get_price_including_tax( $mainproductdatabooking ) ;
                } elseif ( get_option( 'woocommerce_tax_display_shop' ) == 'incl' && get_option( 'woocommerce_prices_include_tax' ) == 'yes' ) {
                    $getregularprice = rs_get_price_including_tax( $mainproductdatabooking ) ;
                } elseif ( get_option( 'woocommerce_tax_display_shop' ) == 'excl' && get_option( 'woocommerce_prices_include_tax' ) == 'yes' ) {
                    $getregularprice = rs_get_price_excluding_tax( $mainproductdatabooking ) ;
                }
            }
        }
    } elseif ( is_shop() || is_product() || is_product_category() ) {
        if ( $mainproductdatabooking->is_type( 'variation' ) ) {
            $variable_product = new WC_Product_Variation( $variationid ) ;
            if ( get_option( 'woocommerce_tax_display_shop' ) == 'incl' && get_option( 'woocommerce_prices_include_tax' ) == 'no' ) {
                $getregularprice = rs_get_price_including_tax( $variable_product ) ;
            } elseif ( get_option( 'woocommerce_tax_display_shop' ) == 'incl' && get_option( 'woocommerce_prices_include_tax' ) == 'yes' ) {
                $getregularprice = rs_get_price_including_tax( $variable_product ) ;
            } elseif ( get_option( 'woocommerce_tax_display_shop' ) == 'excl' && get_option( 'woocommerce_prices_include_tax' ) == 'yes' ) {
                $getregularprice = rs_get_price_excluding_tax( $variable_product ) ;
            } else {
                $getregularprice = is_object( $variable_product ) ? ( float ) $variable_product->get_price() * $itemquantity : 0 ;
            }
        } else {
            $getregularprice = is_object( $mainproductdatabooking ) ? ( float ) $mainproductdatabooking->get_price() * $itemquantity : 0 ;
            if ( get_option( 'woocommerce_tax_display_shop' ) == 'incl' && get_option( 'woocommerce_prices_include_tax' ) == 'no' ) {
                $getregularprice = rs_get_price_including_tax( $mainproductdatabooking ) ;
            } elseif ( get_option( 'woocommerce_tax_display_shop' ) == 'incl' && get_option( 'woocommerce_prices_include_tax' ) == 'yes' ) {
                $getregularprice = rs_get_price_including_tax( $mainproductdatabooking ) ;
            } elseif ( get_option( 'woocommerce_tax_display_shop' ) == 'excl' && get_option( 'woocommerce_prices_include_tax' ) == 'yes' ) {
                $getregularprice = rs_get_price_excluding_tax( $mainproductdatabooking ) ;
            }
        }
    }
    if ( get_option( 'rs_calculate_point_based_on_reg_or_sale' ) == '1' ) {
        if ( WC_VERSION >= 3.0 ) {
            $getregularprice = ( float ) $mainproductdatabooking->get_regular_price() * $itemquantity ;
        } else {
            $getregularprice = ( float ) $mainproductdatabooking->regular_price * $itemquantity ;
        }
    }
    return floatval( $getregularprice ) ;
}

function rs_function_to_get_social_rewardspoints( $productid , $rewardfor , $level , $termid ) {
    $productlevel  = RSFunctionForSavingMetaValues::rewardsystem_get_post_meta( $productid , '_socialrewardsystemcheckboxvalue' ) ;
    $categorylevel = RSFunctionForSavingMetaValues::rewardsystem_get_woocommerce_term_meta( $termid , 'enable_social_reward_system_category' ) ;
    $global_enable = get_option( 'rs_global_social_enable_disable_reward' ) ;
    if ( $rewardfor == 'instagram' ) {
        if ( $level == '1' ) {
            $productlevelrewardtype    = RSFunctionForSavingMetaValues::rewardsystem_get_post_meta( $productid , '_social_rewardsystem_options_instagram' ) ;
            $productlevelrewardpoints  = RSFunctionForSavingMetaValues::rewardsystem_get_post_meta( $productid , '_socialrewardsystempoints_instagram' ) ;
            $productlevelrewardpercent = RSFunctionForSavingMetaValues::rewardsystem_get_post_meta( $productid , '_socialrewardsystempercent_instagram' ) ;
            $array                     = array ( 'enable_level' => $productlevel , 'rewardtype' => $productlevelrewardtype , 'rewardpoints' => $productlevelrewardpoints , 'rewardpercent' => $productlevelrewardpercent ) ;
            return $array ;
        } elseif ( $level == '2' ) {
            $categorylevelrewardtype     = RSFunctionForSavingMetaValues::rewardsystem_get_woocommerce_term_meta( $termid , 'social_instagram_enable_rs_rule' ) ;
            $categorylevelrewardpoints   = RSFunctionForSavingMetaValues::rewardsystem_get_woocommerce_term_meta( $termid , 'social_instagram_rs_category_points' ) ;
            $categorylevelrewardpercents = RSFunctionForSavingMetaValues::rewardsystem_get_woocommerce_term_meta( $termid , 'social_instagram_rs_category_percent' ) ;
            $array                       = array ( 'enable_level' => $categorylevel , 'rewardtype' => $categorylevelrewardtype , 'rewardpoints' => $categorylevelrewardpoints , 'rewardpercent' => $categorylevelrewardpercents ) ;
            return $array ;
        } else {
            $global_reward_type    = get_option( 'rs_global_social_reward_type_instagram' ) ;
            $global_reward_points  = get_option( 'rs_global_social_instagram_reward_points' ) ;
            $global_reward_percent = get_option( 'rs_global_social_instagram_reward_percent' ) ;
            $array                 = array ( 'enable_level' => $global_enable , 'rewardtype' => $global_reward_type , 'rewardpoints' => $global_reward_points , 'rewardpercent' => $global_reward_percent ) ;
            return $array ;
        }
    } elseif ( $rewardfor == 'twitter_follow' ) {
        if ( $level == '1' ) {
            $gettype    = RSFunctionForSavingMetaValues::rewardsystem_get_post_meta( $productid , '_social_rewardsystem_options_twitter_follow' ) ;
            $getpoints  = RSFunctionForSavingMetaValues::rewardsystem_get_post_meta( $productid , '_socialrewardsystempoints_twitter_follow' ) ;
            $getpercent = RSFunctionForSavingMetaValues::rewardsystem_get_post_meta( $productid , '_socialrewardsystempercent_twitter_follow' ) ;
            $array      = array ( 'enable_level' => $productlevel , 'rewardtype' => $gettype , 'rewardpoints' => $getpoints , 'rewardpercent' => $getpercent ) ;
            return $array ;
        } elseif ( $level == '2' ) {
            $categorylevelrewardtype     = RSFunctionForSavingMetaValues::rewardsystem_get_woocommerce_term_meta( $termid , 'social_twitter_follow_enable_rs_rule' ) ;
            $categorylevelrewardpoints   = RSFunctionForSavingMetaValues::rewardsystem_get_woocommerce_term_meta( $termid , 'social_twitter_follow_rs_category_points' ) ;
            $categorylevelrewardpercents = RSFunctionForSavingMetaValues::rewardsystem_get_woocommerce_term_meta( $termid , 'social_twitter_follow_rs_category_percent' ) ;
            $array                       = array ( 'enable_level' => $categorylevel , 'rewardtype' => $categorylevelrewardtype , 'rewardpoints' => $categorylevelrewardpoints , 'rewardpercent' => $categorylevelrewardpercents ) ;
            return $array ;
        } else {
            $global_reward_type    = get_option( 'rs_global_social_reward_type_twitter_follow' ) ;
            $global_reward_points  = get_option( 'rs_global_social_twitter_follow_reward_points' ) ;
            $global_reward_percent = get_option( 'rs_global_social_twitter_follow_reward_percent' ) ;
            $array                 = array ( 'enable_level' => $global_enable , 'rewardtype' => $global_reward_type , 'rewardpoints' => $global_reward_points , 'rewardpercent' => $global_reward_percent ) ;
            return $array ;
        }
    } elseif ( $rewardfor == 'fb_like' ) {
        if ( $level == '1' ) {
            $gettype    = RSFunctionForSavingMetaValues::rewardsystem_get_post_meta( $productid , '_social_rewardsystem_options_facebook' ) ;
            $getpoints  = RSFunctionForSavingMetaValues::rewardsystem_get_post_meta( $productid , '_socialrewardsystempoints_facebook' ) ;
            $getpercent = RSFunctionForSavingMetaValues::rewardsystem_get_post_meta( $productid , '_socialrewardsystempercent_facebook' ) ;
            $array      = array ( 'enable_level' => $productlevel , 'rewardtype' => $gettype , 'rewardpoints' => $getpoints , 'rewardpercent' => $getpercent ) ;
            return $array ;
        } elseif ( $level == '2' ) {
            $categorylevelrewardtype     = RSFunctionForSavingMetaValues::rewardsystem_get_woocommerce_term_meta( $termid , 'social_facebook_enable_rs_rule' ) ;
            $categorylevelrewardpoints   = RSFunctionForSavingMetaValues::rewardsystem_get_woocommerce_term_meta( $termid , 'social_facebook_rs_category_points' ) ;
            $categorylevelrewardpercents = RSFunctionForSavingMetaValues::rewardsystem_get_woocommerce_term_meta( $termid , 'social_facebook_rs_category_percent' ) ;
            $array                       = array ( 'enable_level' => $categorylevel , 'rewardtype' => $categorylevelrewardtype , 'rewardpoints' => $categorylevelrewardpoints , 'rewardpercent' => $categorylevelrewardpercents ) ;
            return $array ;
        } else {
            $global_reward_type    = get_option( 'rs_global_social_reward_type_facebook' ) ;
            $global_reward_points  = get_option( 'rs_global_social_facebook_reward_points' ) ;
            $global_reward_percent = get_option( 'rs_global_social_facebook_reward_percent' ) ;
            $array                 = array ( 'enable_level' => $global_enable , 'rewardtype' => $global_reward_type , 'rewardpoints' => $global_reward_points , 'rewardpercent' => $global_reward_percent ) ;
            return $array ;
        }
    } elseif ( $rewardfor == 'fb_share' ) {
        if ( $level == '1' ) {
            $gettype    = RSFunctionForSavingMetaValues::rewardsystem_get_post_meta( $productid , '_social_rewardsystem_options_facebook_share' ) ;
            $getpoints  = RSFunctionForSavingMetaValues::rewardsystem_get_post_meta( $productid , '_socialrewardsystempoints_facebook_share' ) ;
            $getpercent = RSFunctionForSavingMetaValues::rewardsystem_get_post_meta( $productid , '_socialrewardsystempercent_facebook_share' ) ;
            $array      = array ( 'enable_level' => $productlevel , 'rewardtype' => $gettype , 'rewardpoints' => $getpoints , 'rewardpercent' => $getpercent ) ;
            return $array ;
        } elseif ( $level == '2' ) {
            $categorylevelrewardtype     = RSFunctionForSavingMetaValues::rewardsystem_get_woocommerce_term_meta( $termid , 'social_facebook_share_enable_rs_rule' ) ;
            $categorylevelrewardpoints   = RSFunctionForSavingMetaValues::rewardsystem_get_woocommerce_term_meta( $termid , 'social_facebook_share_rs_category_points' ) ;
            $categorylevelrewardpercents = RSFunctionForSavingMetaValues::rewardsystem_get_woocommerce_term_meta( $termid , 'social_facebook_share_rs_category_percent' ) ;
            $array                       = array ( 'enable_level' => $categorylevel , 'rewardtype' => $categorylevelrewardtype , 'rewardpoints' => $categorylevelrewardpoints , 'rewardpercent' => $categorylevelrewardpercents ) ;
            return $array ;
        } else {
            $global_reward_type    = get_option( 'rs_global_social_reward_type_facebook_share' ) ;
            $global_reward_points  = get_option( 'rs_global_social_facebook_share_reward_points' ) ;
            $global_reward_percent = get_option( 'rs_global_social_facebook_share_reward_percent' ) ;
            $array                 = array ( 'enable_level' => $global_enable , 'rewardtype' => $global_reward_type , 'rewardpoints' => $global_reward_points , 'rewardpercent' => $global_reward_percent ) ;
            return $array ;
        }
    } elseif ( $rewardfor == 'twitter_tweet' ) {
        if ( $level == '1' ) {
            $gettype    = RSFunctionForSavingMetaValues::rewardsystem_get_post_meta( $productid , '_social_rewardsystem_options_twitter' ) ;
            $getpoints  = RSFunctionForSavingMetaValues::rewardsystem_get_post_meta( $productid , '_socialrewardsystempoints_twitter' ) ;
            $getpercent = RSFunctionForSavingMetaValues::rewardsystem_get_post_meta( $productid , '_socialrewardsystempercent_twitter' ) ;
            $array      = array ( 'enable_level' => $productlevel , 'rewardtype' => $gettype , 'rewardpoints' => $getpoints , 'rewardpercent' => $getpercent ) ;
            return $array ;
        } elseif ( $level == '2' ) {
            $categorylevelrewardtype     = RSFunctionForSavingMetaValues::rewardsystem_get_woocommerce_term_meta( $termid , 'social_twitter_enable_rs_rule' ) ;
            $categorylevelrewardpoints   = RSFunctionForSavingMetaValues::rewardsystem_get_woocommerce_term_meta( $termid , 'social_twitter_rs_category_points' ) ;
            $categorylevelrewardpercents = RSFunctionForSavingMetaValues::rewardsystem_get_woocommerce_term_meta( $termid , 'social_twitter_rs_category_percent' ) ;
            $array                       = array ( 'enable_level' => $categorylevel , 'rewardtype' => $categorylevelrewardtype , 'rewardpoints' => $categorylevelrewardpoints , 'rewardpercent' => $categorylevelrewardpercents ) ;
            return $array ;
        } else {
            $global_reward_type    = get_option( 'rs_global_social_reward_type_twitter' ) ;
            $global_reward_points  = get_option( 'rs_global_social_twitter_reward_points' ) ;
            $global_reward_percent = get_option( 'rs_global_social_twitter_reward_percent' ) ;
            $array                 = array ( 'enable_level' => $global_enable , 'rewardtype' => $global_reward_type , 'rewardpoints' => $global_reward_points , 'rewardpercent' => $global_reward_percent ) ;
            return $array ;
        }
    } elseif ( $rewardfor == 'g_plus' ) {
        if ( $level == '1' ) {
            $gettype    = RSFunctionForSavingMetaValues::rewardsystem_get_post_meta( $productid , '_social_rewardsystem_options_google' ) ;
            $getpoints  = RSFunctionForSavingMetaValues::rewardsystem_get_post_meta( $productid , '_socialrewardsystempoints_google' ) ;
            $getpercent = RSFunctionForSavingMetaValues::rewardsystem_get_post_meta( $productid , '_socialrewardsystempercent_google' ) ;
            $array      = array ( 'enable_level' => $productlevel , 'rewardtype' => $gettype , 'rewardpoints' => $getpoints , 'rewardpercent' => $getpercent ) ;
            return $array ;
        } elseif ( $level == '2' ) {
            $categorylevelrewardtype     = RSFunctionForSavingMetaValues::rewardsystem_get_woocommerce_term_meta( $termid , 'social_google_enable_rs_rule' ) ;
            $categorylevelrewardpoints   = RSFunctionForSavingMetaValues::rewardsystem_get_woocommerce_term_meta( $termid , 'social_google_rs_category_points' ) ;
            $categorylevelrewardpercents = RSFunctionForSavingMetaValues::rewardsystem_get_woocommerce_term_meta( $termid , 'social_google_rs_category_percent' ) ;
            $array                       = array ( 'enable_level' => $categorylevel , 'rewardtype' => $categorylevelrewardtype , 'rewardpoints' => $categorylevelrewardpoints , 'rewardpercent' => $categorylevelrewardpercents ) ;
            return $array ;
        } else {
            $global_reward_type    = get_option( 'rs_global_social_reward_type_google' ) ;
            $global_reward_points  = get_option( 'rs_global_social_google_reward_points' ) ;
            $global_reward_percent = get_option( 'rs_global_social_google_reward_percent' ) ;
            $array                 = array ( 'enable_level' => $global_enable , 'rewardtype' => $global_reward_type , 'rewardpoints' => $global_reward_points , 'rewardpercent' => $global_reward_percent ) ;
            return $array ;
        }
    } elseif ( $rewardfor == 'vk_like' ) {
        if ( $level == '1' ) {
            $gettype    = RSFunctionForSavingMetaValues::rewardsystem_get_post_meta( $productid , '_social_rewardsystem_options_vk' ) ;
            $getpoints  = RSFunctionForSavingMetaValues::rewardsystem_get_post_meta( $productid , '_socialrewardsystempoints_vk' ) ;
            $getpercent = RSFunctionForSavingMetaValues::rewardsystem_get_post_meta( $productid , '_socialrewardsystempercent_vk' ) ;
            $array      = array ( 'enable_level' => $productlevel , 'rewardtype' => $gettype , 'rewardpoints' => $getpoints , 'rewardpercent' => $getpercent ) ;
            return $array ;
        } elseif ( $level == '2' ) {
            $categorylevelrewardtype     = RSFunctionForSavingMetaValues::rewardsystem_get_woocommerce_term_meta( $termid , 'social_vk_enable_rs_rule' ) ;
            $categorylevelrewardpoints   = RSFunctionForSavingMetaValues::rewardsystem_get_woocommerce_term_meta( $termid , 'social_vk_rs_category_points' ) ;
            $categorylevelrewardpercents = RSFunctionForSavingMetaValues::rewardsystem_get_woocommerce_term_meta( $termid , 'social_vk_rs_category_percent' ) ;
            $array                       = array ( 'enable_level' => $categorylevel , 'rewardtype' => $categorylevelrewardtype , 'rewardpoints' => $categorylevelrewardpoints , 'rewardpercent' => $categorylevelrewardpercents ) ;
            return $array ;
        } else {
            $global_reward_type    = get_option( 'rs_global_social_reward_type_vk' ) ;
            $global_reward_points  = get_option( 'rs_global_social_vk_reward_points' ) ;
            $global_reward_percent = get_option( 'rs_global_social_vk_reward_percent' ) ;
            $array                 = array ( 'enable_level' => $global_enable , 'rewardtype' => $global_reward_type , 'rewardpoints' => $global_reward_points , 'rewardpercent' => $global_reward_percent ) ;
            return $array ;
        }
    } elseif ( $rewardfor == 'ok_follow' ) {
        if ( $level == '1' ) {
            $gettype    = RSFunctionForSavingMetaValues::rewardsystem_get_post_meta( $productid , '_social_rewardsystem_options_ok_follow' ) ;
            $getpoints  = RSFunctionForSavingMetaValues::rewardsystem_get_post_meta( $productid , '_socialrewardsystempoints_ok_follow' ) ;
            $getpercent = RSFunctionForSavingMetaValues::rewardsystem_get_post_meta( $productid , '_socialrewardsystempercent_ok_follow' ) ;
            $array      = array ( 'enable_level' => $productlevel , 'rewardtype' => $gettype , 'rewardpoints' => $getpoints , 'rewardpercent' => $getpercent ) ;
            return $array ;
        } elseif ( $level == '2' ) {
            $categorylevelrewardtype     = RSFunctionForSavingMetaValues::rewardsystem_get_woocommerce_term_meta( $termid , 'social_ok_follow_enable_rs_rule' ) ;
            $categorylevelrewardpoints   = RSFunctionForSavingMetaValues::rewardsystem_get_woocommerce_term_meta( $termid , 'social_ok_follow_rs_category_points' ) ;
            $categorylevelrewardpercents = RSFunctionForSavingMetaValues::rewardsystem_get_woocommerce_term_meta( $termid , 'social_ok_follow_rs_category_percent' ) ;
            $array                       = array ( 'enable_level' => $categorylevel , 'rewardtype' => $categorylevelrewardtype , 'rewardpoints' => $categorylevelrewardpoints , 'rewardpercent' => $categorylevelrewardpercents ) ;
            return $array ;
        } else {
            $global_reward_type    = get_option( 'rs_global_social_reward_type_ok_follow' ) ;
            $global_reward_points  = get_option( 'rs_global_social_ok_follow_reward_points' ) ;
            $global_reward_percent = get_option( 'rs_global_social_ok_follow_reward_percent' ) ;
            $array                 = array ( 'enable_level' => $global_enable , 'rewardtype' => $global_reward_type , 'rewardpoints' => $global_reward_points , 'rewardpercent' => $global_reward_percent ) ;
            return $array ;
        }
    }
}

function get_woocommerce_formatted_price( $price ) {
    if ( function_exists( 'wc_price' ) ) {
        return wc_price( $price ) ;
    } else {
        return woocommerce_price( $price ) ;
    }
}

function rs_function_to_restrict_points_for_product_which_has_saleprice( $product_id , $variation_id ) {
    if ( get_option( 'rs_pointx_not_award_when_sale_price' ) == 'yes' ) {
        if ( $variation_id != '' && $variation_id != '0' ) {
            if ( wp_get_post_parent_id( $variation_id ) != '0' ) {
                $variable_product1 = new WC_Product_Variation( $variation_id ) ;
            } else {
                $variable_product1 = rs_get_product_object( $variation_id ) ;
            }
            global $woocommerce ;
            if ( ( float ) $woocommerce->version >= ( float ) '3.0' ) {
                $getsaleprice = $variable_product1->get_sale_price() ;
            } else {
                $getsaleprice = $variable_product1->sale_price ;
            }
            if ( $getsaleprice != '' ) {
                return 'yes' ;
            }
        } else {
            $getsaleprice = RSFunctionForSavingMetaValues::rewardsystem_get_post_meta( $product_id , '_sale_price' ) ;
            if ( $getsaleprice != '' ) {
                return 'yes' ;
            }
        }
    }
    return 'no' ;
}

function rs_function_to_check_the_restriction_for_referral( $get_user_type ) {
    $userids = array () ;
    if ( is_user_logged_in() ) {
        $current_user_id   = get_current_user_id() ;
        $current_user_role = wp_get_current_user() ;
        $user_role         = $current_user_role->roles[ 0 ] ;
    } elseif ( isset( $_GET[ 'ref' ] ) ) {
        $user = get_user_by( 'login' , $_GET[ 'ref' ] ) ;
        if ( $user != false ) {
            $current_user_id = is_object( $user ) ? $user->ID : 0 ;
        } else {
            $current_user_id = $_GET[ 'ref' ] ;
        }
        $user_info = get_userdata( $current_user_id ) ;
        $user_role = is_object( $user_info ) ? $user_info->roles[ 0 ] : 'Guest' ;
    } else {
        $current_user_id = '' ;
        $user_role       = '' ;
    }
    if ( $get_user_type == '1' ) {
        return true ;
    } elseif ( $get_user_type == '2' ) {
        $getuser = get_option( 'rs_select_include_users_for_show_referral_link' ) ;
        if ( $getuser != "" ) {
            if ( ! is_array( $getuser ) ) {
                $userids = array_filter( array_map( 'absint' , ( array ) explode( ',' , $getuser ) ) ) ;
            } else {
                $userids = $getuser ;
            }
            if ( in_array( $current_user_id , $userids ) ) {
                return true ;
            }
        } else {
            return true ;
        }
    } elseif ( $get_user_type == '3' ) {
        $getuser = get_option( 'rs_select_exclude_users_list_for_show_referral_link' ) ;
        if ( $getuser != "" ) {
            if ( ! is_array( $getuser ) ) {
                $userids = array_filter( array_map( 'absint' , ( array ) explode( ',' , $getuser ) ) ) ;
            } else {
                $userids = $getuser ;
            }
            if ( ! in_array( $current_user_id , $userids ) ) {
                return true ;
            }
        } else {
            return true ;
        }
    } elseif ( $get_user_type == '4' ) {
        $getuser = get_option( 'rs_select_users_role_for_show_referral_link' ) ;
        if ( is_array( $getuser ) && ! empty( $getuser ) ) {
            if ( in_array( $user_role , $getuser ) ) {
                return true ;
            }
        } else {
            return true ;
        }
    } else {
        $getuser = get_option( 'rs_select_exclude_users_role_for_show_referral_link' ) ;
        if ( is_array( $getuser ) && ! empty( $getuser ) ) {
            if ( ! in_array( $user_role , $getuser ) ) {
                return true ;
            }
        } else {
            return true ;
        }
    }
    return false ;
}

function rs_function_to_get_expiry_date_in_unixtimestamp() {
    if ( get_option( 'rs_point_expiry_activated' ) == 'yes' ) {
        $noofdays = get_option( 'rs_point_to_be_expire' ) ;
        $date     = (($noofdays != 0) && ($noofdays != '')) ? time() + ($noofdays * 24 * 60 * 60) : '999999999999' ;
    } else {
        $date = '999999999999' ;
    }
    return $date ;
}

function rs_get_product_object( $product_id ) {
    if ( function_exists( 'wc_get_product' ) ) {
        $product_object = wc_get_product( $product_id ) ;
    } else {
        $product_object = get_product( $product_id ) ;
    }
    return $product_object ;
}

function rs_get_price_excluding_tax( $product_object ) {
    if ( function_exists( 'wc_get_price_excluding_tax' ) ) {
        $get_excluded_tax = wc_get_price_excluding_tax( $product_object ) ;
    } else {
        $get_excluded_tax = $product_object->get_price_excluding_tax() ;
    }
    return $get_excluded_tax ;
}

function rs_get_price_including_tax( $product_object ) {
    if ( function_exists( 'wc_get_price_including_tax' ) ) {
        $get_included_tax = wc_get_price_including_tax( $product_object ) ;
    } else {
        $get_included_tax = $product_object->get_price_including_tax() ;
    }
    return $get_included_tax ;
}

function rs_get_id( $product ) {
    global $woocommerce ;
    if ( ( float ) $woocommerce->version >= ( float ) '3.0' ) {
        $id = $product->get_id() ;
    } else {
        if ( $product->is_type( 'variation' ) ) {
            $id = $product->variation_id ;
        } else {
            $id = $product->id ;
        }
    }
    return $id ;
}

function rs_get_parent_id( $variable_product_obj ) {
    global $woocommerce ;
    if ( ( float ) $woocommerce->version >= ( float ) '3.0' ) {
        $id = $variable_product_obj->get_parent_id() ;
    } else {
        $id = $variable_product_obj->parent->id ;
    }
    return $id ;
}

function rs_get_price( $object ) {
    global $woocommerce ;
    if ( ( float ) $woocommerce->version >= ( float ) '3.0' ) {
        $price = $object->get_price() ;
    } else {
        $price = $object->price ;
    }
    return $price ;
}

function rs_get_product_type( $object ) {
    global $woocommerce ;
    if ( ( float ) $woocommerce->version >= ( float ) '3.0' ) {
        $product_type = $object->get_type() ;
    } else {
        $product_type = $object->product_type ;
    }
    return $product_type ;
}

function rs_get_order_obj( $order ) {
    if ( is_object( $order ) && ! empty( $order ) ) {
        global $woocommerce ;
        if ( ( float ) $woocommerce->version >= ( float ) '3.0' ) {
            $order_id      = $order->get_id() ;
            $post_status   = $order->get_status() ;
            $order_user_id = $order->get_user_id() ;
            if ( $order->get_parent_id() === 0 ) {
                $payment_method       = $order->get_payment_method() ;
                $payment_method_title = $order->get_payment_method_title() ;
            } else {
                $payment_method       = '' ;
                $payment_method_title = '' ;
            }
        } else {
            $order_id      = $order->id ;
            $post_status   = $order->post_status ;
            $order_user_id = $order->user_id ;
            if ( $order->parent_id === 0 ) {
                $payment_method       = $order->payment_method ;
                $payment_method_title = $order->payment_method_title ;
            } else {
                $payment_method       = '' ;
                $payment_method_title = '' ;
            }
        }
        $first_name = get_post_meta( $order_id , '_billing_first_name' , true ) ;
        $new_array  = array (
            'order_id'             => $order_id ,
            'order_status'         => $post_status ,
            'order_userid'         => $order_user_id ,
            'payment_method'       => $payment_method ,
            'payment_method_title' => $payment_method_title ,
            'first_name'           => $first_name
                ) ;
        return $new_array ;
    }
}

function rs_get_coupon_obj( $object ) {
    if ( is_object( $object ) && ! empty( $object ) ) {
        global $woocommerce ;
        if ( ( float ) $woocommerce->version >= ( float ) '3.0' ) {
            $coupon_id          = $object->get_id() ;
            $coupon_code        = $object->get_code() ;
            $coupon_amnt        = $object->get_amount() ;
            $coupon_product_ids = $object->get_product_ids() ;
            $discount_type      = $object->get_discount_type() ;
            $product_cat        = $object->get_product_categories() ;
        } else {
            $coupon_id          = $object->id ;
            $coupon_code        = $object->code ;
            $coupon_amnt        = $object->coupon_amount ;
            $coupon_product_ids = $object->product_ids ;
            $discount_type      = $object->discount_type ;
            $product_cat        = $object->product_categories ;
        }
        $new_array = array (
            'coupon_id'          => $coupon_id ,
            'coupon_code'        => $coupon_code ,
            'coupon_amount'      => $coupon_amnt ,
            'product_ids'        => $coupon_product_ids ,
            'discount_type'      => $discount_type ,
            'product_categories' => $product_cat
                ) ;
        return $new_array ;
    }
}

function rs_get_post_parent( $object ) {
    global $woocommerce ;
    if ( ( float ) $woocommerce->version >= ( float ) '3.0' ) {
        $parent_id = $object->get_parent_id() ;
    } else {
        $parent_id = $object->post->post_parent ;
    }
    return $parent_id ;
}

function rs_get_sale_or_regular_price( $product ) {
    global $woocommerce ;
    if ( ( float ) $woocommerce->version >= ( float ) '3.0' ) {
        $price = $product->get_sale_price() != '' ? $product->get_sale_price() : $product->get_regular_price() ;
    } else {
        $price = $product->sale_price != '' ? $product->sale_price : $product->regular_price ;
    }
    return $price ;
}

function rs_check_variable_product_type( $object ) {
    if ( is_object( $object ) && ($object->is_type( 'variation' ) || $object->is_type( 'variable' )) ) {
        return true ;
    }
    return false ;
}

function round_off_type( $points , $args = array () ) {
    $roundofftype = get_option( 'rs_round_off_type' ) ;
    if ( $roundofftype == '1' ) {
        if ( get_option( 'rs_decimal_seperator_check' ) == '1' ) {
            return round( $points , 2 ) ;
        } else {
            extract( wp_parse_args( $args , array (
                'decimal_separator'  => wc_get_price_decimal_separator() ,
                'thousand_separator' => wc_get_price_thousand_separator() ,
                'decimals'           => wc_get_price_decimals() ,
            ) ) ) ;
            return round( $points , $decimals ) ;
        }
    } else {
        if ( get_option( 'rs_round_up_down' ) == '1' ) {
            return floor( $points ) ;
        } else {
            return ceil( $points ) ;
        }
    }
}

function round_off_type_for_currency( $currency , $args = array () ) {
    $roundofftype         = get_option( 'rs_round_off_type' ) ;
    $RoundoffTForCurrency = get_option( 'rs_roundoff_type_for_currency' ) ;
    if ( $roundofftype == '1' ) {
        return round_off_type( $currency ) ;
    } else {
        if ( $RoundoffTForCurrency == '1' ) {
            if ( get_option( 'rs_decimal_seperator_check_for_currency' ) == '1' ) {
                return round( $currency , 2 ) ;
            } else {
                extract( wp_parse_args( $args , array (
                    'decimal_separator'  => wc_get_price_decimal_separator() ,
                    'thousand_separator' => wc_get_price_thousand_separator() ,
                    'decimals'           => wc_get_price_decimals() ,
                ) ) ) ;
                return round( $currency , $decimals ) ;
            }
        } else {
            if ( get_option( 'rs_round_up_down' ) == '1' ) {
                return floor( $currency ) ;
            } else {
                return ceil( $currency ) ;
            }
        }
    }
}

function rs_function_date_display( $values ) {
    if ( get_option( 'rs_dispaly_time_format' ) == '1' ) {
        $dateformat        = "d-m-Y h:i:s A" ;
        $update_start_date = is_numeric( $values[ 'earneddate' ] ) ? date_i18n( $dateformat , $values[ 'earneddate' ] ) : $values[ 'earneddate' ] ;
    } else {
        $timeformat        = get_option( 'time_format' ) ;
        $dateformat        = get_option( 'date_format' ) . ' ' . $timeformat ;
        $update_start_date = is_numeric( $values[ 'earneddate' ] ) ? date_i18n( $dateformat , $values[ 'earneddate' ] ) : $values[ 'earneddate' ] ;
        $update_start_date = strftime( $update_start_date ) ;
    }
    return $update_start_date ;
}

/** Remove Sumo Reward points coupon when it satisfies the reward restriction */
function rs_check_sumo_points_remove( $cart_object ) {
    $current_user_id = get_current_user_id() ;
    foreach ( $cart_object->get_coupon_discount_totals() as $coupon => $key ) {
        if ( strpos( $coupon , 'sumo_' ) !== false ) {
            $getcouponid = RSFunctionForSavingMetaValues::rewardsystem_get_user_meta( $current_user_id , 'redeemcouponids' ) ;
            if ( $getcouponid != '' ) {
                wp_trash_post( $getcouponid ) ;
            }
        } else if ( strpos( $coupon , 'auto_redeem_' ) !== false ) {
            $getcouponid = RSFunctionForSavingMetaValues::rewardsystem_get_user_meta( $current_user_id , 'auto_redeemcoupon_ids' ) ;
            if ( $getcouponid != '' ) {
                wp_trash_post( $getcouponid ) ;
            }
        }
    }
}

function check_whether_hoicker_is_active() {
    if ( class_exists( 'HR_Wallet' ) && get_option( 'hr_wallet_module' ) == 'yes' ) {
        return true ;
    }
    return false ;
}

/*
 *  Function For SUMO Bookings Only Point Price
 */

function rs_sumo_bookings_active( $pdt_id ) {

    if ( class_exists( 'SUMO_Bookings' ) ) {

        if ( function_exists( 'is_sumo_bookings_product' ) && (is_sumo_bookings_product( $pdt_id )) ) {
            return true ;
        }
        return false ;
    }
    return false ;
}

add_filter( 'sumo_bookings_calculated_format_price' , 'rs_function_for_only_point_booking_product' , 10 , 3 ) ;

function rs_function_for_only_point_booking_product( $format_price , $booking_price , $product_id ) {

    $booking_product      = rs_sumo_bookings_active( $product_id ) ;
    $product_level_enable = RSFunctionForSavingMetaValues::rewardsystem_get_post_meta( $product_id , '_rewardsystem_enable_point_price' ) ;
    $advanced_setup       = get_option( 'rs_enable_product_category_level_for_points_price' ) ;
    $price_display_type   = RSFunctionForSavingMetaValues::rewardsystem_get_post_meta( $product_id , '_rewardsystem_enable_point_price_type' ) ;
    $point_price_label    = get_option( 'rs_label_for_point_value' ) ;
    $labelposition        = get_option( 'rs_sufix_prefix_point_price_label' ) ;
    $pxel                 = get_option( 'rs_pixel_val' ) ;
    if ( $booking_product ) {
        if ( get_option( 'rs_point_price_activated' ) == 'yes' && $product_level_enable == 'yes' && $advanced_setup == 'yes' ) {
            if ( $price_display_type == 2 ) {
                $price = calculate_point_price_for_products( $product_id ) ;
                return $price[ $product_id ] . $point_price_label ;
            } else {
                $price = calculate_point_price_for_products( $product_id ) ;

                if ( $labelposition == 2 ) {
                    return $format_price . '/' . "{$price[ $product_id ]}<span style='margin-left:{$pxel}px;'>{$point_price_label}</span>" ;
                } else {
                    return $format_price . '/' . "{$point_price_label}<span style='margin-left:{$pxel}px;'>{$price[ $product_id ]}</span>" ;
                }
            }
        }
        return $format_price ;
    }
    return $format_price ;
}

function rs_alter_from_email_of_woocommerce( $email , $obj ) {
    $get_from_email = FPRewardSystem::$rs_from_email_address ;
    if ( $get_from_email )
        return '<' . $get_from_email . '>' ;

    return $email ;
}

function rs_alter_from_name_of_woocommerce( $name , $obj ) {
    $get_from_name = FPRewardSystem::$rs_from_name ;
    if ( $get_from_name )
        return $get_from_name ;

    return $name ;
}

if ( ! function_exists( 'rs_get_no_of_days_from_email_expire_module' ) ) {

    function rs_get_no_of_days_from_email_expire_module() {
        $days                     = 0 ;
        global $wpdb ;
        $selected_template        = get_option( 'rs_select_template' ) ;
        $emailtemplate_table_name = $wpdb->prefix . 'rs_expiredpoints_email' ;
        $email_templates          = $wpdb->get_results( "SELECT noofdays FROM $emailtemplate_table_name WHERE template_name='$selected_template' AND rs_status='ACTIVE'" , ARRAY_A ) ;
        if ( ! empty( $email_templates ) )
            $days                     = $email_templates[ 0 ][ 'noofdays' ] ;

        return ( int ) $days ;
    }

}

/* free product set initial price as zero  */

function rs_set_intial_price_for_free_product() {
    if ( get_option( 'rs_enable_earned_level_based_reward_points' ) == 'yes' ) {
        global $woocommerce ;
        $order_user_id            = get_current_user_id() ;
        $total_earned_points      = get_option( 'rs_select_earn_points_based_on' ) == '1' ? RSPointExpiry::total_points_earned_in_site( $order_user_id ) : RSPointExpiry::total_available_points_in_site( $order_user_id ) ;
        $getsessiondata           = FPRewardSystem_Free_Product::fp_get_free_product_level_id( $total_earned_points ) ;
        $getcorrespondingproducts = FPRewardSystem_Free_Product::fp_get_corresponding_product( $getsessiondata ) ;
        foreach ( $woocommerce->cart->cart_contents as $key => $value ) {
            $productid = $value[ 'variation_id' ] != '' ? $value[ 'variation_id' ] : $value[ 'product_id' ] ;
            if ( in_array( $productid , ( array ) $getcorrespondingproducts ) ) {
                $order_user_id        = get_current_user_id() ;
                $get_product_for_user = get_post_meta( $order_user_id , 'product_id_for_free_prduct' , true ) ;
                if ( ! in_array( $productid , ( array ) $get_product_for_user ) ) {
                    $value[ 'data' ]->set_price( 0 ) ;
                }
            }
        }
    }
}

if ( ! function_exists( 'rs_custom_search_fields' ) ) {

    function rs_custom_search_fields( $args ) {
        $args = wp_parse_args( $args , array (
            'class'              => '' ,
            'id'                 => '' ,
            'name'               => '' ,
            'type'               => '' ,
            'action'             => '' ,
            'title'              => '' ,
            'placeholder'        => '' ,
            'css'                => '' ,
            'multiple'           => true ,
            'allow_clear'        => true ,
            'selected'           => true ,
            'options'            => array () ,
            'translation_string' => ''
                ) ) ;
        ob_start() ;
        if ( ( float ) WC_VERSION <= ( float ) ('2.2') ) {
            ?><select <?php echo $args[ 'multiple' ] ? 'multiple="multiple"' : '' ?> name="<?php
            echo esc_attr( '' !== $args[ 'name' ] ? $args[ 'name' ] : $args[ 'id' ]  ) ;
            if ( $args[ 'multiple' ] ) {
                ?>[]<?php } ?>" id="<?php echo esc_attr( $args[ 'id' ] ) ; ?>" class="<?php echo esc_attr( $args[ 'id' ] ) ; ?>" data-placeholder="<?php _e( esc_attr( $args[ 'placeholder' ] ) , $args[ 'translation_string' ] ) ; ?>" style="<?php echo esc_attr( $args[ 'css' ] ) ; ?>"><?php
                                                                                       if ( is_array( $args[ 'options' ] ) ) {
                                                                                           foreach ( $args[ 'options' ] as $id ) {
                                                                                               $option_value = '' ;
                                                                                               switch ( $args[ 'type' ] ) {
                                                                                                   case 'product':
                                                                                                       if ( $product = wc_get_product( $id ) ) {
                                                                                                           $option_value = wp_kses_post( $product->get_formatted_name() ) ;
                                                                                                       }
                                                                                                       break ;
                                                                                                   case 'customer':
                                                                                                       if ( $user = get_user_by( 'id' , $id ) ) {
                                                                                                           $option_value = esc_html( esc_html( $user->display_name ) . '(#' . absint( $user->ID ) . ' &ndash; ' . esc_html( $user->user_email ) . ')' ) ;
                                                                                                       }
                                                                                                       break ;
                                                                                                   case 'customfields':
                                                                                                       $option_value = esc_html( get_the_title( $id ) ) ;
                                                                                                       break ;
                                                                                               }
                                                                                               if ( $option_value ) {
                                                                                                   ?>
                            <option value="<?php echo esc_attr( $id ) ; ?>" <?php echo $args[ 'selected' ] ? 'selected="selected"' : '' ?>><?php echo $option_value ; ?></option>
                            <?php
                        }
                    }
                }
                ?></select><?php } else if ( ( float ) WC_VERSION < ( float ) ('3.0') ) {
                ?>
            <input type="hidden" name="<?php echo esc_attr( '' !== $args[ 'name' ] ? $args[ 'name' ] : $args[ 'id' ]  ) ; ?>" id="<?php echo esc_attr( $args[ 'id' ] ) ; ?>" class="<?php echo esc_attr( $args[ 'class' ] ) ; ?>" data-action="<?php echo esc_attr( $args[ 'action' ] ) ; ?>" data-placeholder="<?php _e( esc_attr( $args[ 'placeholder' ] ) , $args[ 'translation_string' ] ) ; ?>" <?php echo $args[ 'multiple' ] ? 'data-multiple="true"' : '' ?> <?php echo $args[ 'allow_clear' ] ? 'data-allow_clear="true"' : '' ?> style="<?php echo esc_attr( $args[ 'css' ] ) ; ?>" <?php if ( $args[ 'selected' ] ) { ?> data-selected="<?php
                $json_ids = array () ;

                if ( is_array( $args[ 'options' ] ) ) {
                    foreach ( $args[ 'options' ] as $id ) {
                        switch ( $args[ 'type' ] ) {
                            case 'product':
                                if ( $product = wc_get_product( $id ) ) {
                                    $json_ids[ $id ] = wp_kses_post( $product->get_formatted_name() ) ;
                                }
                                break ;
                            case 'customer':
                                if ( $user = get_user_by( 'id' , $id ) ) {
                                    $json_ids[ $id ] = esc_html( $user->display_name ) . ' (#' . absint( $user->ID ) . ' &ndash; ' . esc_html( $user->user_email ) . ')' ;
                                }
                                break ;
                            case 'customfields':
                                $json_ids[ $id ] = esc_html( get_the_title( $id ) ) ;
                                break ;
                        }
                    }
                }
                echo esc_attr( json_encode( $json_ids ) ) ;
                ?>" value="<?php
                       echo implode( ',' , array_keys( $json_ids ) ) ;
                   }
                   ?>"/><?php } else {
                   ?>
            <select <?php echo $args[ 'multiple' ] ? 'multiple="multiple"' : '' ?> name="<?php
            echo esc_attr( '' !== $args[ 'name' ] ? $args[ 'name' ] : $args[ 'id' ]  ) ;
            if ( $args[ 'multiple' ] ) {
                ?>[]<?php } ?>" id="<?php echo esc_attr( $args[ 'id' ] ) ; ?>" class="<?php echo esc_attr( $args[ 'class' ] ) ; ?>" data-action="<?php echo esc_attr( $args[ 'action' ] ) ; ?>" data-placeholder="<?php _e( esc_attr( $args[ 'placeholder' ] ) , $args[ 'translation_string' ] ) ; ?>" style="<?php echo esc_attr( $args[ 'css' ] ) ; ?>"><?php
                                                                                       if ( is_array( $args[ 'options' ] ) ) {
                                                                                           foreach ( $args[ 'options' ] as $id ) {
                                                                                               $option_value = '' ;
                                                                                               switch ( $args[ 'type' ] ) {
                                                                                                   case 'product':
                                                                                                       if ( $product = wc_get_product( $id ) ) {
                                                                                                           $option_value = wp_kses_post( $product->get_formatted_name() ) ;
                                                                                                       }
                                                                                                       break ;
                                                                                                   case 'customer':
                                                                                                       if ( $user = get_user_by( 'id' , $id ) ) {
                                                                                                           $option_value = esc_html( esc_html( $user->display_name ) . '(#' . absint( $user->ID ) . ' &ndash; ' . esc_html( $user->user_email ) . ')' ) ;
                                                                                                       }
                                                                                                       break ;
                                                                                                   case 'customfields':
                                                                                                       $option_value = esc_html( get_the_title( $id ) ) ;
                                                                                                       break ;
                                                                                               }
                                                                                               if ( $option_value ) {
                                                                                                   ?><option value="<?php echo esc_attr( $id ) ; ?>" <?php echo $args[ 'selected' ] ? 'selected="selected"' : '' ?>><?php echo $option_value ; ?></option><?php
                        }
                    }
                }
                ?></select><?php
        }
        echo ob_get_clean() ;
    }

}

/*
 * Get all Reward Points Menus
 */

function rs_get_the_menus() {
    $rs_menu = array ( 'rewardsystem_general'            => 'General' ,
        'rewardsystem_modules'            => 'Modules' ,
        'rewardsystem_add_remove_points'  => 'Add/Remove Reward Points' ,
        'rewardsystem_message'            => 'Messages' ,
        'rewardsystem_localization'       => 'Localization' ,
        'rewardsystem_user_reward_points' => 'User Reward Points' ,
        'rewardsystem_masterlog'          => 'Master Log' ,
        'rewardsystem_shortcode'          => 'Shortcode' ,
        'rewardsystem_advanced'           => 'Advanced' ,
        'rewardsystem_support'            => 'Support'
            ) ;
    return $rs_menu ;
}

/* Menu Restriction Based on User Role  */

function menu_restriction_based_on_user_role() {
    global $wp_roles ;
    foreach ( $wp_roles->role_names as $value => $key ) {
        $user_id = get_current_user_id() ;
        $user    = new WP_User( $user_id ) ;
        if ( ! empty( $user->roles ) && is_array( $user->roles ) ) {
            foreach ( $user->roles as $role )
                $current_user_role = $role ;
        }
        if ( $current_user_role == $value ) {
            $remove_menus = (get_option( 'rewardpoints_userrole_menu_restriction' . $value )) ;
        }
    }
    $tabtoshow = array ( 'rewardsystem_general' , 'rewardsystem_modules' , 'rewardsystem_add_remove_points' , 'rewardsystem_message' , 'rewardsystem_localization' , 'rewardsystem_user_reward_points' , 'rewardsystem_masterlog' , 'rewardsystem_support' , 'rewardsystem_advanced' , 'rewardsystem_shortcode' ) ;
    if ( is_array( $remove_menus ) && ! empty( $remove_menus ) ) {
        foreach ( $remove_menus as $remove_menu ) {
            if ( ($key = array_search( $remove_menu , $tabtoshow )) !== false ) {
                unset( $tabtoshow[ $key ] ) ;
            }
        }
    }
    return $tabtoshow ;
}

function rs_get_next_menu() {
    if ( get_option( 'rs_menu_restriction_based_on_user_role' ) == 'yes' ) {
        $tabtoshow = menu_restriction_based_on_user_role() ;
        $tab       = reset( $tabtoshow ) ;
        return $tab ;
    }
}

function rs_get_current_user_role() {
    global $wp_roles ;
    $current_user_role = array () ;
    foreach ( $wp_roles->role_names as $value => $key ) {
        $user_id           = get_current_user_id() ;
        $user              = new WP_User( $user_id ) ;
        if ( ! empty( $user->roles ) && is_array( $user->roles ) )
            $current_user_role = $user->roles ;
    }
    return $current_user_role ;
}

/* To Award points for Product Purchase  */

function rs_reward_points_product_purchase( $order_id ) {
    $order         = new WC_Order( $order_id ) ;
    $orderid       = rs_get_order_obj( $order ) ;
    $orderstatus   = $orderid[ 'order_status' ] ;
    $replacestatus = str_replace( 'wc-' , '' , $orderstatus ) ;
    $status        = get_option( 'rs_order_status_control' ) ;
    if ( in_array( $replacestatus , $status ) ) {
        $new_obj                     = new RewardPointsOrder( $order_id , $apply_previous_order_points = 'no' ) ;
        $new_obj->update_earning_points_for_user() ;
    }
}

if ( ! function_exists( 'allow_reward_points_for_user' ) ) {

    function allow_reward_points_for_user( $userid ) {
        $bool_value         = true ;
        $allow_earn_points  = get_user_meta( $userid , 'allow_user_to_earn_reward_points' , true ) ;
        $enable_reward_prgm = get_option( 'rs_enable_reward_program' ) ;
        if ( $enable_reward_prgm != 'yes' )
            return $bool_value ;

        if ( ! ($allow_earn_points == 'yes') && ! ($allow_earn_points == '') )
            $bool_value = false ;

        return $bool_value ;
    }

}

if ( ! function_exists( 'check_referral_count_if_exist' ) ) {

    function check_referral_count_if_exist( $userid ) {
        $enable_referral_limit = get_option( 'rs_enable_referral_link_limit' ) ;
        if ( $enable_referral_limit != 'yes' )
            return true ;

        if ( get_option( 'rs_referral_link_limit' ) == '' )
            return true ;

        if ( get_user_meta( $userid , 'referral_link_count_value' , true ) == '' )
            return true ;

        $count_limit   = ( int ) get_option( 'rs_referral_link_limit' ) ;
        $default_value = ( int ) get_user_meta( $userid , 'referral_link_count_value' , true ) ;
        if ( $default_value >= $count_limit )
            return false ;

        return true ;
    }

}
if ( ! function_exists( 'update_order_meta_if_points_awarded' ) ) {

    function update_order_meta_if_points_awarded( $orderid , $userid ) {
        update_user_meta( $userid , 'rsfirsttime_redeemed' , 1 ) ;
        add_post_meta( $orderid , 'reward_points_awarded' , 'yes' ) ;
        add_post_meta( $orderid , 'earning_point_once' , 1 ) ;
        update_post_meta( $orderid , 'rs_revised_points_once' , 2 ) ;
        update_user_meta( $userid , 'rs_restrict_points_when_when_first_purchase' , '2' ) ;
        $oldorderid = get_user_meta( $userid , 'rs_no_of_purchase_for_user' , true ) ;
        $getorderid = ( array ) $orderid ;
        if ( $oldorderid == '' ) {
            update_user_meta( $userid , 'rs_no_of_purchase_for_user' , $getorderid ) ;
        } else {
            $mergearray = array_merge( $oldorderid , ( array ) $getorderid ) ;
            update_user_meta( $userid , 'rs_no_of_purchase_for_user' , $mergearray ) ;
        }
    }

}

if ( ! function_exists( 'check_if_free_product_already_exists_in_cart' ) ) {

    function check_if_free_product_already_exists_in_cart( $UserId ) {
        $cart_content            = WC()->cart->cart_contents ;
        $ListofFreeProductInCart = array () ;
        foreach ( $cart_content as $key => $values ) {
            $ProductInCart                             = $values[ 'variation_id' ] != '' ? $values[ 'variation_id' ] : $values[ 'product_id' ] ;
            $AllowedProductList                        = check_if_product_exists_in_free_product_list( $ProductInCart , $UserId ) ;
            if ( $AllowedProductList )
                $ListofFreeProductInCart[ $ProductInCart ] = $AllowedProductList ;
        }
        return $ListofFreeProductInCart ;
    }

}

if ( ! function_exists( 'check_if_product_exists_in_free_product_list' ) ) {

    function check_if_product_exists_in_free_product_list( $ProductId , $UserId ) {
        if ( get_option( 'rs_enable_earned_level_based_reward_points' ) != 'yes' )
            return false ;

        $TotalEarnedPoints = get_option( 'rs_select_earn_points_based_on' ) == '1' ? RSPointExpiry::total_points_earned_in_site( $UserId ) : RSPointExpiry::total_available_points_in_site( $UserId ) ;
        $LevelofUser       = FPRewardSystem_Free_Product::fp_get_free_product_level_id( $TotalEarnedPoints ) ;
        $ListofFreeProduct = FPRewardSystem_Free_Product::fp_get_corresponding_product( $LevelofUser ) ;
        if ( in_array( $ProductId , $ListofFreeProduct ) )
            return true ;

        return false ;
    }

}

if ( ! function_exists( 'update_product_count_for_social_action' ) ) {

    function update_product_count_for_social_action( $UserId , $MetaKey , $PostId ) {
        $ProductId[] = $PostId ;
        $OldData     = ( array ) get_user_meta( $UserId , $MetaKey , true ) ;
        if ( is_array( $OldData ) && ! empty( $OldData ) ) {
            $ArrayFilter = array_filter( $OldData ) ;
            if ( isset( $ArrayFilter[ date( 'd/m/Y' ) ] ) ) {
                $DataToMerge                     = $ArrayFilter[ date( 'd/m/Y' ) ] ;
                $MergedData                      = array_merge( $DataToMerge , $ProductId ) ;
                $DataToUpdate[ date( 'd/m/Y' ) ] = $MergedData ;
                update_user_meta( $UserId , $MetaKey , $DataToUpdate ) ;
            } else {
                $DataToUpdate[ date( 'd/m/Y' ) ] = $ProductId ;
                update_user_meta( $UserId , $MetaKey , $DataToUpdate ) ;
            }
        } else {
            $DataToUpdate[ date( 'd/m/Y' ) ] = $ProductId ;
            update_user_meta( $UserId , $MetaKey , $DataToUpdate ) ;
        }
    }

}
if ( ! function_exists( 'check_wheather_to_awarded_points_for_social_action' ) ) {

    function check_wheather_to_awarded_points_for_social_action( $UserId , $MetaKey , $EnableAction , $Count ) {
        if ( $EnableAction == 'no' )
            return true ;

        if ( $Count == '' )
            return true ;

        $TotalCount = ( array ) get_user_meta( $UserId , $MetaKey , true ) ;
        if ( empty( $TotalCount ) )
            return true ;

        if ( ! isset( $TotalCount[ date( 'd/m/Y' ) ] ) )
            return true ;

        $ProductCount = count( $TotalCount[ date( 'd/m/Y' ) ] ) ;
        if ( $ProductCount >= $Count )
            return false ;

        return true ;
    }

}
if ( ! function_exists( 'get_reward_points_based_on_cart_total' ) ) {

    function get_reward_points_based_on_cart_total( $OrderTotal ) {
        if ( get_option( 'rs_enable_cart_total_reward_points' ) == '2' )
            return 0 ;

        $RewardTypeForCartTotal = get_option( 'rs_reward_type_for_cart_total' ) ;
        if ( $RewardTypeForCartTotal == '1' ) {
            $FixedPointsForCartTotal = get_option( 'rs_reward_points_for_cart_total_in_fixed' ) ;
            $PointsToAward           = $FixedPointsForCartTotal == '' ? 0 : $FixedPointsForCartTotal ;
        } else {
            $PercentPointsForCartTotal = get_option( 'rs_reward_points_for_cart_total_in_percent' ) ;
            $PointsToAward             = $PercentPointsForCartTotal == '' ? 0 : rs_convert_reward_percent_value( $PercentPointsForCartTotal , $OrderTotal ) ;
        }
        return $PointsToAward ;
    }

}