<?php

if ( ! defined( 'ABSPATH' ) ) {
    exit ; // Exit if accessed directly.
}
if ( ! class_exists( 'RSRegistrationPoints' ) ) {

    class RSRegistrationPoints {

        public static function init() {
            add_action( 'user_register' , array( __CLASS__ , 'rs_account_signup_type' ) , 10 , 1 ) ;

            add_action( 'wp_head' , array( __CLASS__ , 'reward_points_for_login' ) ) ;

            add_action( 'fpsl_loggedin_successfully' , array( __CLASS__ , 'award_points_for_social_login' ) , 10 , 3 ) ;

            add_action( 'fpsl_linked_successfully' , array( __CLASS__ , 'award_points_for_social_link' ) , 10 , 2 ) ;

            add_action( 'fpcf_cus_fields_after_save' , array( __CLASS__ , 'award_points_for_cus_fields' ) , 10 , 2 ) ;

            add_action( 'rs_award_points_for_datepicker_in_cusfields' , array( __CLASS__ , 'award_points_for_datepicker_in_cus_fields_repeatedly' ) , 10 , 4 ) ;
        }

        public static function rs_account_signup_type( $user_id ) {
            if ( get_option( 'rs_enable_reward_program' ) == 'yes' ) {
                if ( isset( $_POST[ 'rs_enable_earn_points_for_user_in_reg_form' ] ) || isset( $_POST[ 'enable_reward_prgm' ] ) ) {
                    update_user_meta( $user_id , 'allow_user_to_earn_reward_points' , 'yes' ) ;
                    update_user_meta( $user_id , 'unsub_value' , 'no' ) ;
                } else {
                    update_user_meta( $user_id , 'allow_user_to_earn_reward_points' , 'no' ) ;
                }
            }
            $account_signup_type = get_option( 'rs_select_account_signup_points_award' ) ;
            if ( $account_signup_type == '1' ) {
                self::rs_add_registration_rewards_points( $user_id ) ;
            } else {
                if ( isset( $_COOKIE[ 'rsreferredusername' ] ) ) {
                    self::rs_add_registration_rewards_points( $user_id ) ;
                }
            }

            if ( isset( $_COOKIE[ 'rsreferredusername' ] ) && allow_reward_points_for_user( $user_id ) ) {
                $referreduser = get_user_by( 'login' , $_COOKIE[ 'rsreferredusername' ] ) ;
                $referredid   = ($referreduser) ? $referreduser->ID : $_COOKIE[ 'rsreferredusername' ] ;
                if ( $user_id != $referredid ) {
                    $default_value = ( int ) get_user_meta( $referredid , 'referral_link_count_value' , true ) ;
                    update_user_meta( $referredid , 'referral_link_count_value' , $default_value + 1 ) ;
                }
            }
        }

        public static function rs_add_registration_rewards_points( $user_id ) {
            $get_registed_user = get_post_meta( $user_id , 'rs_registered_user' , true ) ;
            if ( $get_registed_user != '' )
                return ;

            $option             = get_option( 'rs_select_referral_points_award' ) ;
            $enableoptforreg    = get_option( 'rs_reward_signup_after_first_purchase' ) ;
            $enableoptforrefreg = get_option( 'rs_referral_reward_signup_after_first_purchase' ) ;
            $enablegetrefer     = get_option( 'rs_referral_reward_signup_getting_refer' ) ;
            $enablefirstpurchse = get_option( 'rs_referral_reward_getting_refer_after_first_purchase' ) ;
            if ( $enablegetrefer == '1' ) {
                if ( $enablefirstpurchse == 'yes' ) {
                    self::referal_reward_points_for_get_refer_after_first_purchase( $user_id ) ;
                } else {
                    self::referal_reward_points_for_get_refer_instantly( $user_id ) ;
                }
            }
            if ( ($enableoptforreg == 'yes' ) ) {
                // After First Purchase Registration Points
                self::rs_add_regpoints_to_user_after_first_purchase( $user_id ) ;
                self::rs_add_regpoints_to_refuser_only_after_first_purchase( $user_id ) ;
                if ( $enableoptforrefreg != 'yes' ) {
                    // Instant Referral Registration Points
                    if ( $option == '1' ) {
                        self::rs_add_regpoints_to_refuser_instantly( $user_id ) ;
                    }
                }
            } else {
                // Instant Registration Points
                self::rs_add_regpoints_to_user_instantly( $user_id ) ;
                self::rs_add_regpoints_to_refuser_only_after_first_purchase( $user_id ) ;
                if ( $enableoptforrefreg != 'yes' ) {
                    // Instant Referral Registration Points
                    if ( $option == '1' ) {
                        self::rs_add_regpoints_to_refuser_instantly( $user_id ) ;
                    }
                }
            }
            do_action( 'fp_reward_point_for_registration' ) ;
            update_post_meta( $user_id , 'rs_registered_user' , 1 ) ;
        }

        public static function referal_reward_points_for_get_refer_after_first_purchase( $user_id ) {
            if ( get_option( 'rs_referral_activated' ) != 'yes' )
                return ;

            $EnableReferralSignUp = get_option( '_rs_referral_enable_signups' ) ;
            if ( $EnableReferralSignUp != 'yes' )
                return ;

            if ( ! isset( $_COOKIE[ 'rsreferredusername' ] ) )
                return ;
            // Update the Referred Person Registration Count           
            $user_info                = new WP_User( $user_id ) ;
            $registered_date          = $user_info->user_registered ;
            $limitation               = false ;
            $modified_registered_date = date( 'Y-m-d h:i:sa' , strtotime( $registered_date ) ) ;
            $delay_days               = get_option( '_rs_select_referral_points_referee_time_content' ) ;
            $checking_date            = date( 'Y-m-d h:i:sa' , strtotime( $modified_registered_date . ' + ' . $delay_days . ' days ' ) ) ;
            $modified_checking_date   = strtotime( $checking_date ) ;
            $current_date             = date( 'Y-m-d h:i:sa' ) ;
            $modified_current_date    = strtotime( $current_date ) ;
            //Is for Immediatly
            if ( get_option( '_rs_select_referral_points_referee_time' ) == '1' ) {
                $limitation = true ;
            } else {
                // Is for Limited Time with Number of Days
                if ( $modified_current_date > $modified_checking_date ) {
                    $limitation = true ;
                } else {
                    $limitation = false ;
                }
            }
            if ( $limitation == false )
                return ;

            $referreduser = get_user_by( 'login' , $_COOKIE[ 'rsreferredusername' ] ) ;
            if ( $referreduser != false ) {
                $refuserid = $referreduser->ID ;
            } else {
                $refuserid = $_COOKIE[ 'rsreferredusername' ] ;
            }

            $banning_type = FPRewardSystem::check_banning_type( $refuserid ) ;
            if ( $banning_type == 'earningonly' && $banning_type == 'both' )
                return ;

            $referral_get_refer_point = get_option( 'rs_referral_reward_getting_refer' ) ;
            $referral_get_refer_point = RSMemberFunction::user_role_based_reward_points( $refuserid , $referral_get_refer_point ) ;
            $mainpoints               = array() ;
            $mainpoints[ $user_id ]   = array( 'userid' => $user_id , 'refpoints' => $referral_get_refer_point ) ;
            RSFunctionForSavingMetaValues::rewardsystem_update_user_meta( $user_id , 'rs_get_data_for_reward_points_get_refer' , $mainpoints ) ;
        }

        public static function referal_reward_points_for_get_refer_instantly( $user_id ) {
            if ( get_option( 'rs_referral_activated' ) != 'yes' )
                return ;

            $EnableReferralSignUp = get_option( '_rs_referral_enable_signups' ) ;
            if ( $EnableReferralSignUp != 'yes' )
                return ;

            if ( ! isset( $_COOKIE[ 'rsreferredusername' ] ) )
                return ;

            global $wpdb ;
            $registration_points       = RSMemberFunction::user_role_based_reward_points( $user_id , get_option( 'rs_referral_reward_getting_refer' ) ) ;
            $restrictuserpoints        = get_option( 'rs_max_earning_points_for_user' ) ;
            $enabledisablepoints       = get_option( 'rs_enable_disable_max_earning_points_for_user' ) ;
            $currentregistrationpoints = $registration_points ;
            if ( $enabledisablepoints == 'yes' ) {
                if ( ($currentregistrationpoints <= $restrictuserpoints) || ($restrictuserpoints == '') ) {
                    $currentregistrationpoints = $currentregistrationpoints ;
                } else {
                    $currentregistrationpoints = $restrictuserpoints ;
                }
            }
            $date        = rs_function_to_get_expiry_date_in_unixtimestamp() ;
            RSPointExpiry::insert_earning_points( $user_id , $registration_points , '0' , $date , 'RRPGR' , '' , '' , '' , '' ) ;
            $equearnamt  = RSPointExpiry::earning_conversion_settings( $registration_points ) ;
            $totalpoints = RSPointExpiry::total_available_points_in_site( $user_id ) ;
            RSPointExpiry::record_the_points( $user_id , $registration_points , '0' , $date , 'RRPGR' , $equearnamt , '0' , '0' , '0' , '0' , '0' , '' , $totalpoints , '' , '0' ) ;
            add_user_meta( $user_id , '_points_awarded_get_refer' , '1' ) ;
        }

        /* After First Purchase Referral Registration Points */

        public static function rs_add_regpoints_to_refuser_only_after_first_purchase( $user_id ) {
            if ( get_option( 'rs_referral_activated' ) != 'yes' )
                return ;

            $EnableReferralSignUp = get_option( '_rs_referral_enable_signups' ) ;
            if ( $EnableReferralSignUp != 'yes' )
                return ;

            if ( ! isset( $_COOKIE[ 'rsreferredusername' ] ) )
                return ;

            $ReferralRegPoints        = get_option( 'rs_referral_reward_signup' ) ;
            $RegPoints                = get_option( 'rs_reward_signup' ) ;
            $user_info                = new WP_User( $user_id ) ;
            $registered_date          = $user_info->user_registered ;
            $limitation               = false ;
            $modified_registered_date = date( 'Y-m-d h:i:sa' , strtotime( $registered_date ) ) ;
            $delay_days               = get_option( '_rs_select_referral_points_referee_time_content' ) ;
            $checking_date            = date( 'Y-m-d h:i:sa' , strtotime( $modified_registered_date . ' + ' . $delay_days . ' days ' ) ) ;
            $modified_checking_date   = strtotime( $checking_date ) ;
            $current_date             = date( 'Y-m-d h:i:sa' ) ;
            $modified_current_date    = strtotime( $current_date ) ;
            //Is for Immediatly
            if ( get_option( '_rs_select_referral_points_referee_time' ) == '1' ) {
                $limitation = true ;
            } else {
                // Is for Limited Time with Number of Days
                if ( $modified_current_date > $modified_checking_date ) {
                    $limitation = true ;
                } else {
                    $limitation = false ;
                }
            }
            if ( $limitation == false )
                return ;

            $referreduser = get_user_by( 'login' , $_COOKIE[ 'rsreferredusername' ] ) ;
            if ( $referreduser != false ) {
                $refuserid = $referreduser->ID ;
            } else {
                $refuserid = $_COOKIE[ 'rsreferredusername' ] ;
            }
            $banning_type = FPRewardSystem::check_banning_type( $refuserid ) ;
            if ( $banning_type == 'earningonly' && $banning_type == 'both' )
                return ;

            $ReferralRegPoints      = RSMemberFunction::user_role_based_reward_points( $refuserid , $ReferralRegPoints ) ;
            $RegPoints              = RSMemberFunction::user_role_based_reward_points( $user_id , $RegPoints ) ;
            $mainpoints             = array() ;
            $mainpoints[ $user_id ] = array( 'userid' => $user_id , 'points' => $RegPoints , 'refuserid' => $refuserid , 'refpoints' => $ReferralRegPoints ) ;
            RSFunctionForSavingMetaValues::rewardsystem_update_user_meta( $user_id , 'rs_get_data_for_reward_points' , $mainpoints ) ;
            $previouslog            = get_option( 'rs_referral_log' ) ;
        }

        /* Instant Registration Points */

        public static function rs_add_regpoints_to_user_instantly( $user_id ) {
            if ( get_option( 'rs_reward_action_activated' ) != 'yes' )
                return ;

            $EnableSignUp = get_option( '_rs_enable_signup' ) ;
            if ( $EnableSignUp != 'yes' )
                return ;

            $pointstoinsert = get_option( 'rs_reward_signup' ) ;
            if ( $pointstoinsert == '' )
                return ;

            self::award_reg_points_instantly( $pointstoinsert , $user_id , $event_slug = 'RRP' , $Network    = '' ) ;
        }

        /* After First Purchase Registration Points */

        public static function rs_add_regpoints_to_user_after_first_purchase( $user_id ) {
            if ( get_option( 'rs_reward_action_activated' ) != 'yes' )
                return ;

            $EnableSignUp = get_option( '_rs_enable_signup' ) ;
            if ( $EnableSignUp != 'yes' )
                return ;

            $pointstoaward = get_option( 'rs_reward_signup' ) ;
            if ( $pointstoaward == '' )
                return ;

            self::award_reg_points_after_first_purchase( $pointstoaward , $user_id , $event_slug = 'RRP' , $Network    = '' ) ;
        }

        /* Instant Referral Registration Points */

        public static function rs_add_regpoints_to_refuser_instantly( $user_id ) {
            if ( get_option( 'rs_referral_activated' ) != 'yes' )
                return ;

            $EnableReferralSignUp = get_option( '_rs_referral_enable_signups' ) ;
            if ( $EnableReferralSignUp != 'yes' )
                return ;

            if ( ! isset( $_COOKIE[ 'rsreferredusername' ] ) )
                return ;

            $user_info                = new WP_User( $user_id ) ;
            $registered_date          = $user_info->user_registered ;
            $limitation               = false ;
            $modified_registered_date = date( 'Y-m-d h:i:sa' , strtotime( $registered_date ) ) ;
            $delay_days               = get_option( '_rs_select_referral_points_referee_time_content' ) ;
            $checking_date            = date( 'Y-m-d h:i:sa' , strtotime( $modified_registered_date . ' + ' . $delay_days . ' days ' ) ) ;
            $modified_checking_date   = strtotime( $checking_date ) ;
            $current_date             = date( 'Y-m-d h:i:sa' ) ;
            $modified_current_date    = strtotime( $current_date ) ;
            $restrictuserpoints       = get_option( 'rs_max_earning_points_for_user' ) ;
            $enabledisablemaxpoints   = get_option( 'rs_enable_disable_max_earning_points_for_user' ) ;
            //Is for Immediatly
            if ( get_option( '_rs_select_referral_points_referee_time' ) == '1' ) {
                $limitation = true ;
            } else {
                // Is for Limited Time with Number of Days
                if ( $modified_current_date > $modified_checking_date ) {
                    $limitation = true ;
                } else {
                    $limitation = false ;
                }
            }
            if ( $limitation == false )
                return ;

            $referreduser = get_user_by( 'login' , $_COOKIE[ 'rsreferredusername' ] ) ;
            if ( $referreduser != false ) {
                $refuserid = $referreduser->ID ;
            } else {
                $refuserid = $_COOKIE[ 'rsreferredusername' ] ;
            }
            $banning_type = FPRewardSystem::check_banning_type( $refuserid ) ;
            if ( $banning_type == 'earningonly' && $banning_type == 'both' )
                return ;

            if ( RSFunctionForSavingMetaValues::rewardsystem_get_user_meta( $user_id , 'rs_referrer_regpoints_awarded' ) == '1' )
                return ;

            $referral_registration_points = get_option( 'rs_referral_reward_signup' ) ;
            $new_obj                      = new RewardPointsOrder( $order_id                     = 0 , $apply_previous_order_points  = 'no' ) ;
            if ( $enabledisablemaxpoints == 'yes' ) {
                $new_obj->check_point_restriction( $restrictuserpoints , $referral_registration_points , $pointsredeemed = 0 , $event_slug     = 'RRRP' , $refuserid , $nomineeid      = '' , $user_id , $productid      = '' , $variationid    = '' , $reasonindetail = '' ) ;
            } else {
                $equearnamt     = RSPointExpiry::earning_conversion_settings( $referral_registration_points ) ;
                $valuestoinsert = array( 'pointstoinsert' => $referral_registration_points , 'pointsredeemed' => 0 , 'event_slug' => 'RRRP' , 'equalearnamnt' => $equearnamt , 'equalredeemamnt' => 0 , 'user_id' => $refuserid , 'referred_id' => $user_id , 'product_id' => '' , 'variation_id' => '' , 'reasonindetail' => '' , 'nominee_id' => '' , 'nominee_points' => '' , 'totalearnedpoints' => $referral_registration_points , 'totalredeempoints' => 0 ) ;
                $new_obj->total_points_management( $valuestoinsert ) ;
                $previouslog    = get_option( 'rs_referral_log' ) ;
                RS_Referral_Log::main_referral_log_function( $refuserid , $user_id , $referral_registration_points , array_filter( ( array ) $previouslog ) ) ;
                update_user_meta( $user_id , '_rs_i_referred_by' , $refuserid ) ;
            }
            add_user_meta( $user_id , 'rs_referrer_regpoints_awarded' , '1' ) ;
        }

        public static function reward_points_for_login() {
            $pointsforlogin = get_option( 'rs_reward_points_for_login' ) ;
            self::insert_points_for_login( $pointsforlogin , $event_slug     = 'LRP' , get_current_user_id() , $Network        = '' ) ;
            do_action( 'fp_reward_point_for_login' ) ;
        }

        /* Award Reward Points for Social Login - Compatability with Social Login Plugin */

        public static function award_points_for_social_login( $UserId , $Network , $Type ) {
            $network_name = fpsl_get_plugin_networks() ;
            $Network      = $network_name[ $Network ] ;
            if ( $Type == '2' || $Type == '3' ) {
                $pointsforsociallogin = get_option( 'rs_reward_for_social_network_login' ) ;
                self::insert_points_for_login( $pointsforsociallogin , $event_slug           = 'SLRP' , $UserId , $Network ) ;
            }
            if ( $Type == '1' ) {
                $pointsforsocialsignup = get_option( 'rs_reward_for_social_network_signup' ) ;
                self::award_points_for_signup( $pointsforsocialsignup , $UserId , $Network ) ;
            }
        }

        /* Insert Points for Login */

        public static function insert_points_for_login( $pointsforlogin , $event_slug , $userid , $Network = '' ) {
            if ( ! allow_reward_points_for_user( $userid ) )
                return ;

            $strtotime = array() ;
            if ( ! is_user_logged_in() )
                return ;

            if ( get_option( 'rs_reward_action_activated' ) != 'yes' )
                return ;

            if ( get_option( 'rs_enable_reward_points_for_login' ) != 'yes' )
                return ;

            $date        = date( 'y-m-d' ) ;
            $strtotime   = strtotime( $date ) ;
            $getusermeta = ( array ) RSFunctionForSavingMetaValues::rewardsystem_get_user_meta( $userid , 'rs_login_date' ) ;
            if ( in_array( $strtotime , $getusermeta ) )
                return ;

            if ( $pointsforlogin == '' )
                return ;

            $restrictuserpoints          = get_option( 'rs_max_earning_points_for_user' ) ;
            $enabledisablemaxpoints      = get_option( 'rs_enable_disable_max_earning_points_for_user' ) ;
            $new_obj                     = new RewardPointsOrder( $order_id                    = 0 , $apply_previous_order_points = 'no' ) ;
            if ( $enabledisablemaxpoints == 'yes' ) {
                $new_obj->check_point_restriction( $restrictuserpoints , $pointsforlogin , $pointsredeemed = 0 , $event_slug , $userid , $nomineeid      = '' , $referrer_id    = '' , $productid      = '' , $variationid    = '' , $reasonindetail = $Network ) ;
            } else {
                $equearnamt     = RSPointExpiry::earning_conversion_settings( $pointsforlogin ) ;
                $valuestoinsert = array( 'pointstoinsert' => $pointsforlogin , 'pointsredeemed' => 0 , 'event_slug' => $event_slug , 'equalearnamnt' => $equearnamt , 'equalredeemamnt' => 0 , 'user_id' => $userid , 'referred_id' => '' , 'product_id' => '' , 'variation_id' => '' , 'reasonindetail' => $Network , 'nominee_id' => '' , 'nominee_points' => '' , 'totalearnedpoints' => $pointsforlogin , 'totalredeempoints' => 0 ) ;
                $new_obj->total_points_management( $valuestoinsert ) ;
            }

            $oldlogindata = ( array ) RSFunctionForSavingMetaValues::rewardsystem_get_user_meta( $userid , 'rs_login_date' ) ;
            $newdata      = ( array ) $strtotime ;
            $mergedata    = array_merge( $oldlogindata , $newdata ) ;
            RSFunctionForSavingMetaValues::rewardsystem_update_user_meta( $userid , 'rs_login_date' , $mergedata ) ;
        }

        /* Award Points for Social Signup - Compatability with Social Login Plugin */

        public static function award_points_for_signup( $pointsforsocialsignup , $UserId , $Network ) {
            if ( ! allow_reward_points_for_user( $UserId ) )
                return ;

            if ( get_option( 'rs_reward_action_activated' ) != 'yes' )
                return ;

            if ( $pointsforsocialsignup == '' )
                return ;

            $account_signup_type = get_option( 'rs_select_account_signup_points_award' ) ;
            if ( $account_signup_type == '1' ) {
                self::insert_point_for_social_signup( $UserId , $pointsforsocialsignup , $Network ) ;
            } else {
                if ( isset( $_COOKIE[ 'rsreferredusername' ] ) ) {
                    self::insert_point_for_social_signup( $UserId , $pointsforsocialsignup , $Network ) ;
                }
            }
        }

        /* Insert Points for Social Signup */

        public static function insert_point_for_social_signup( $user_id , $pointsforsocialsignup , $Network ) {
            $CheckAlreadyRegistedUser = get_post_meta( $user_id , 'rs_check_already_reg_user_through_social_login' , true ) ;
            if ( $CheckAlreadyRegistedUser != '' )
                return ;

            $AwardAfterFirstPurchase = get_option( 'rs_reward_signup_after_first_purchase' ) ;
            if ( ($AwardAfterFirstPurchase == 'yes' ) ) {
                // After First Purchase Registration Points for Social Signup
                self::award_reg_points_after_first_purchase( $pointsforsocialsignup , $user_id , $event_slug = 'SLRRP' , $Network ) ;
            } else {
                // Instant Registration Points for Social Signup
                self::award_reg_points_instantly( $pointsforsocialsignup , $user_id , $event_slug = 'SLRRP' , $Network ) ;
            }

            update_post_meta( $user_id , 'rs_check_already_reg_user_through_social_login' , 1 ) ;
        }

        public static function award_reg_points_instantly( $pointstoaward , $user_id , $event_slug , $Network ) {
            if ( ! allow_reward_points_for_user( $user_id ) )
                return ;

            $registration_points = RSMemberFunction::user_role_based_reward_points( $user_id , $pointstoaward ) ;
            $restrictuserpoints  = get_option( 'rs_max_earning_points_for_user' ) ;
            $enabledisablepoints = get_option( 'rs_enable_disable_max_earning_points_for_user' ) ;
            if ( $enabledisablepoints == 'yes' ) {
                if ( ($registration_points <= $restrictuserpoints) || ($restrictuserpoints == '') ) {
                    $currentregistrationpoints = $registration_points ;
                } else {
                    $currentregistrationpoints = $restrictuserpoints ;
                }
            } else {
                $currentregistrationpoints = $registration_points ;
            }
            $date        = rs_function_to_get_expiry_date_in_unixtimestamp() ;
            RSPointExpiry::insert_earning_points( $user_id , $currentregistrationpoints , '0' , $date , $event_slug , '' , '' , '' , $Network ) ;
            $equearnamt  = RSPointExpiry::earning_conversion_settings( $currentregistrationpoints ) ;
            $totalpoints = RSPointExpiry::total_available_points_in_site( $user_id ) ;
            RSPointExpiry::record_the_points( $user_id , $currentregistrationpoints , '0' , $date , $event_slug , $equearnamt , '0' , '0' , '0' , '0' , '0' , $Network , $totalpoints , '' , '0' ) ;
            add_user_meta( $user_id , '_points_awarded' , '1' ) ;
        }

        public static function award_reg_points_after_first_purchase( $pointstoaward , $user_id , $event_slug , $Network ) {
            global $wpdb ;
            $table_name   = $wpdb->prefix . 'rspointexpiry' ;
            $banning_type = FPRewardSystem::check_banning_type( $user_id ) ;
            if ( $banning_type != 'earningonly' && $banning_type != 'both' ) {
                $registration_points       = RSMemberFunction::user_role_based_reward_points( $user_id , $pointstoaward ) ;
                $restrictuserpoints        = get_option( 'rs_max_earning_points_for_user' ) ;
                $enabledisablepoints       = get_option( 'rs_enable_disable_max_earning_points_for_user' ) ;
                $oldpoints                 = $wpdb->get_results( "SELECT SUM((earnedpoints-usedpoints)) as availablepoints FROM $table_name WHERE earnedpoints-usedpoints NOT IN(0) and expiredpoints IN(0) and userid=$user_id" , ARRAY_A ) ;
                $totaloldpoints            = $oldpoints[ 0 ][ 'availablepoints' ] ;
                $currentregistrationpoints = $totaloldpoints + $registration_points ;
                if ( $enabledisablepoints == 'yes' ) {
                    if ( ($currentregistrationpoints <= $restrictuserpoints) || ($restrictuserpoints == '') ) {
                        $currentregistrationpoints = $currentregistrationpoints ;
                    } else {
                        $currentregistrationpoints = $restrictuserpoints ;
                    }
                }
                $mainpoints             = array() ;
                $mainpoints[ $user_id ] = array( 'userid' => $user_id , 'points' => $registration_points , 'refuserid' => '' , 'refpoints' => '' , 'event_slug' => $event_slug , 'reaseonidetail' => $Network ) ;
                RSFunctionForSavingMetaValues::rewardsystem_update_user_meta( $user_id , 'rs_get_data_for_reward_points' , $mainpoints ) ;
                if ( get_option( 'rs_signup_points_with_purchase_points' ) == 'yes' ) {
                    RSFunctionForSavingMetaValues::rewardsystem_update_user_meta( $user_id , 'rs_restrict_points_when_when_first_purchase' , '1' ) ;
                }
            }
        }

        /* Award Reward Points for Social Linking - Compatability with Social Login Plugin */

        public static function award_points_for_social_link( $userid , $Network ) {
            if ( ! allow_reward_points_for_user( $userid ) )
                return ;

            $network_name = fpsl_get_plugin_networks() ;
            $Network      = $network_name[ $Network ] ;
            if ( ! is_user_logged_in() )
                return ;

            if ( get_option( 'rs_reward_action_activated' ) != 'yes' )
                return ;

            if ( get_option( 'rs_enable_for_social_account_linking' ) != 'yes' )
                return ;

            if ( get_option( 'rs_reward_for_social_account_linking' ) == '' )
                return ;

            $getusermeta = ( array ) RSFunctionForSavingMetaValues::rewardsystem_get_user_meta( $userid , 'rs_restrict_points_for_social_linking' ) ;
            if ( in_array( $Network , $getusermeta ) )
                return ;

            $pointstoinsert              = get_option( 'rs_reward_for_social_account_linking' ) ;
            $restrictuserpoints          = get_option( 'rs_max_earning_points_for_user' ) ;
            $enabledisablemaxpoints      = get_option( 'rs_enable_disable_max_earning_points_for_user' ) ;
            $new_obj                     = new RewardPointsOrder( $order_id                    = 0 , $apply_previous_order_points = 'no' ) ;
            if ( $enabledisablemaxpoints == 'yes' ) {
                $new_obj->check_point_restriction( $restrictuserpoints , $pointstoinsert , $pointsredeemed = 0 , $event_slug     = 'SLLRP' , $UserId , $nomineeid      = '' , $referrer_id    = '' , $productid      = '' , $variationid    = '' , $reasonindetail = $Network ) ;
            } else {
                $equearnamt     = RSPointExpiry::earning_conversion_settings( $pointstoinsert ) ;
                $valuestoinsert = array( 'pointstoinsert' => $pointstoinsert , 'pointsredeemed' => 0 , 'event_slug' => 'SLLRP' , 'equalearnamnt' => $equearnamt , 'equalredeemamnt' => 0 , 'user_id' => $userid , 'referred_id' => '' , 'product_id' => '' , 'variation_id' => '' , 'reasonindetail' => $Network , 'nominee_id' => '' , 'nominee_points' => '' , 'totalearnedpoints' => $pointstoinsert , 'totalredeempoints' => 0 ) ;
                $new_obj->total_points_management( $valuestoinsert ) ;
            }

            $oldlogindata = ( array ) RSFunctionForSavingMetaValues::rewardsystem_get_user_meta( $userid , 'rs_restrict_points_for_social_linking' ) ;
            $newdata      = ( array ) $Network ;
            $mergedata    = array_merge( $oldlogindata , $newdata ) ;
            RSFunctionForSavingMetaValues::rewardsystem_update_user_meta( $userid , 'rs_restrict_points_for_social_linking' , array_filter( $mergedata ) ) ;
        }

        public static function award_points_for_cus_fields( $userid , $custom_fields ) {
            if ( ! allow_reward_points_for_user( $userid ) )
                return ;

            if ( get_option( 'rs_reward_action_activated' ) != 'yes' )
                return ;

            if ( get_option( 'rs_enable_points_for_cus_field_reg' ) != 'yes' )
                return ;

            $rules_for_custom_reg_field = get_option( 'rs_rule_for_custom_reg_field' ) ;
            if ( ! (is_array( $rules_for_custom_reg_field ) && ! empty( $rules_for_custom_reg_field )) )
                return ;

            foreach ( $rules_for_custom_reg_field as $individual_rule ) {
                $field_id                            = $individual_rule[ 'custom_fields' ] ;
                $pointstoinsert                      = $individual_rule[ 'reward_points' ] ;
                $repeat_points                       = isset( $individual_rule[ 'repeat_points' ] ) ? $individual_rule[ 'repeat_points' ] : 'no' ;
                $allow_points_for_filling_datepicker = isset( $individual_rule[ 'award_points_for_filling' ] ) ? $individual_rule[ 'award_points_for_filling' ] : 'no' ;

                if ( $pointstoinsert == '' || $field_id == '' )
                    continue ;

                $field_data = fpcf_get_custom_fields( $field_id ) ;
                if ( ! $field_data )
                    continue ;

                $getusermeta = ( array ) RSFunctionForSavingMetaValues::rewardsystem_get_user_meta( $userid , 'rs_points_awarded_for_' . $field_data->field_type ) ;
                if ( in_array( $field_id , $getusermeta ) )
                    continue ;

                if ( ! in_array( $field_id , $custom_fields ) )
                    continue ;

                $field_value = fpcf_get_user_meta( $userid , $field_data->field_name ) ;
                if ( $field_value == '' )
                    continue ;

                if ( $field_data->field_type == 'datepicker' ) {
                    if ( $repeat_points == 'yes' ) {
                        $current_date = strtotime( date( 'd-m-Y' ) ) ;
                        $bday_date    = strtotime( $field_value ) ;
                        if ( $current_date == $bday_date )
                            self::insert_points_for_custom_fields( $pointstoinsert , $event_slug   = 'CRPFDP' , $userid , $field_data ) ;

                        $TimeStampForNextSchedule = strtotime( '+1 year' , $bday_date ) ;
                        wp_schedule_single_event( $TimeStampForNextSchedule , 'rs_award_points_for_datepicker_in_cusfields' , array( $TimeStampForNextSchedule , $field_data , $pointstoinsert , $userid ) ) ;
                    }

                    if ( $allow_points_for_filling_datepicker == 'no' )
                        continue ;
                }

                self::insert_points_for_custom_fields( $pointstoinsert , $event_slug   = 'CRFRP' , $userid , $field_data ) ;
                $oldlogindata = ( array ) RSFunctionForSavingMetaValues::rewardsystem_get_user_meta( $userid , 'rs_points_awarded_for_' . $field_data->field_type ) ;
                $newdata      = ( array ) $field_id ;
                $mergedata    = array_merge( $oldlogindata , $newdata ) ;
                RSFunctionForSavingMetaValues::rewardsystem_update_user_meta( $userid , 'rs_points_awarded_for_' . $field_data->field_type , array_filter( $mergedata ) ) ;
            }
        }

        public static function award_points_for_datepicker_in_cus_fields_repeatedly( $timestamp , $field_data , $pointstoinsert , $userid ) {
            if ( ! allow_reward_points_for_user( $userid ) )
                return ;

            if ( get_option( 'rs_reward_action_activated' ) != 'yes' )
                return ;

            if ( get_option( 'rs_enable_points_for_cus_field_reg' ) != 'yes' )
                return ;

            $rules_for_custom_reg_field = get_option( 'rs_rule_for_custom_reg_field' ) ;
            if ( ! (is_array( $rules_for_custom_reg_field ) && ! empty( $rules_for_custom_reg_field )) )
                return ;

            foreach ( $rules_for_custom_reg_field as $individual_rule ) {
                $field_id       = $individual_rule[ 'custom_fields' ] ;
                $pointstoinsert = $individual_rule[ 'reward_points' ] ;
                $repeat_points  = isset( $individual_rule[ 'repeat_points' ] ) ? $individual_rule[ 'repeat_points' ] : 'no' ;

                if ( $pointstoinsert == '' || $field_id == '' )
                    continue ;

                $field_data = fpcf_get_custom_fields( $field_id ) ;
                if ( ! $field_data )
                    continue ;

                if ( $field_data->field_type == 'datepicker' && $repeat_points == 'yes' ) {
                    self::insert_points_for_custom_fields( $pointstoinsert , $event_slug               = 'CRPFDP' , $userid , $field_data ) ;
                    $TimeStampForNextSchedule = strtotime( '+1 year' , $timestamp ) ;
                    wp_schedule_single_event( $TimeStampForNextSchedule , 'rs_award_points_for_datepicker_in_cusfields' , array( $TimeStampForNextSchedule , $field_data , $pointstoinsert , $userid ) ) ;
                }
            }
        }

        public static function insert_points_for_custom_fields( $pointstoinsert , $event_slug , $userid , $field_data ) {
            $restrictuserpoints          = get_option( 'rs_max_earning_points_for_user' ) ;
            $enabledisablemaxpoints      = get_option( 'rs_enable_disable_max_earning_points_for_user' ) ;
            $new_obj                     = new RewardPointsOrder( $order_id                    = 0 , $apply_previous_order_points = 'no' ) ;
            if ( $enabledisablemaxpoints == 'yes' ) {
                $new_obj->check_point_restriction( $restrictuserpoints , $pointstoinsert , $pointsredeemed = 0 , $event_slug , $userid , $nomineeid      = '' , $referrer_id    = '' , $productid      = '' , $variationid    = '' , $reasonindetail = $field_data->field_label ) ;
            } else {
                $equearnamt     = RSPointExpiry::earning_conversion_settings( $pointstoinsert ) ;
                $valuestoinsert = array( 'pointstoinsert' => $pointstoinsert , 'pointsredeemed' => 0 , 'event_slug' => $event_slug , 'equalearnamnt' => $equearnamt , 'equalredeemamnt' => 0 , 'user_id' => $userid , 'referred_id' => '' , 'product_id' => '' , 'variation_id' => '' , 'reasonindetail' => $field_data->field_label , 'nominee_id' => '' , 'nominee_points' => '' , 'totalearnedpoints' => $pointstoinsert , 'totalredeempoints' => 0 ) ;
                $new_obj->total_points_management( $valuestoinsert ) ;
            }
        }

    }

    RSRegistrationPoints::init() ;
}