<?php

if ( ! defined( 'ABSPATH' ) ) {
    exit ; // Exit if accessed directly.
}
if ( ! class_exists( 'RSFunctionForSms' ) ) {

    class RSFunctionForSms {

        public static function send_sms_twilio_api( $OrderId , $MsgFor , $RedeemedPoints ) {
            require_once "SMS/Twilio.php" ;
            $OrderObj    = new WC_Order( $OrderId ) ;
            $OrderObj    = rs_get_order_obj( $OrderObj ) ;
            $UserId      = $OrderObj[ 'order_userid' ] ;
            $UserData    = get_user_by( 'id' , $UserId ) ;
            $UserName    = is_object( $UserData ) ? $UserData->user_login : 'Guest' ;
            $PhoneNumber = get_user_meta( $UserId , 'billing_phone' , true ) ;
            if ( strpos( $PhoneNumber , '+' ) == false )
                return ;

            $BanningType = FPRewardSystem::check_banning_type( $UserId ) ;
            if ( $BanningType != 'earningonly' && $BanningType != 'both' ) {
                $AccountSid    = get_option( 'rs_twilio_secret_account_id' ) ;
                $AuthToken     = get_option( 'rs_twilio_auth_token_id' ) ;
                $client        = new Services_Twilio( $AccountSid , $AuthToken ) ;
                $MessageToSend = self::common_function_for_message( $OrderId , $UserId , $UserName , $MsgFor , $RedeemedPoints ) ;
                $Response      = $client->account->messages->sendMessage(
                        get_option( 'rs_twilio_from_number' ) ,
                        // the number we are sending to - Any phone number
                                    $PhoneNumber ,
                        // the sms body
                                    $MessageToSend
                        ) ;
            }
        }

        public static function send_sms_nexmo_api( $OrderId , $MsgFor ) {
            include_once ( "SMS/NexmoMessage.php" ) ;
            $OrderObj    = new WC_Order( $OrderId ) ;
            $OrderObj    = rs_get_order_obj( $OrderObj ) ;
            $UserId      = $OrderObj[ 'order_userid' ] ;
            $UserData    = get_user_by( 'id' , $UserId ) ;
            $UserName    = is_object( $UserData ) ? $UserData->user_login : 'Guest' ;
            $PhoneNumber = get_user_meta( $UserId , 'billing_phone' , true ) ;
            if ( strpos( $PhoneNumber , '+' ) == false )
                return ;

            $BanningType = FPRewardSystem::check_banning_type( $UserId ) ;
            if ( $BanningType != 'earningonly' && $BanningType != 'both' ) {
                $NexmoObj      = new NexmoMessage( get_option( 'rs_nexmo_key' ) , get_option( 'rs_nexmo_secret' ) ) ;
                $MessageToSend = self::common_function_for_message( $OrderId , $UserId , $UserName , $MsgFor , $RedeemedPoints ) ;
                $Response      = $NexmoObj->sendText( $PhoneNumber , 'SUMO Rewards' , $MessageToSend ) ;
            }
        }

        public static function common_function_for_message( $OrderId , $UserId , $UserName , $MsgFor , $RedeemedPoints ) {
            $AvailabelPoints = RSPointExpiry::total_available_points_in_site( $UserId ) ;
            if ( $MsgFor == 'earning' ) {
                $Message             = get_option( 'rs_points_sms_content_for_earning' ) ;
                $RewardPointsBasedOn = get_option( 'rs_award_points_for_cart_or_product_total' ) ;
                if ( $RewardPointsBasedOn == '1' ) {
                    $PointsToReplace = get_post_meta( $OrderId , 'rs_points_for_current_order_as_value' , true ) ;
                } else {
                    $PointsToReplace = get_post_meta( $OrderId , 'points_for_current_order_based_on_cart_total' , true ) ;
                }
            } else {
                $Message         = get_option( 'rs_points_sms_content_for_redeeming' ) ;
                $PointsToReplace = $RedeemedPoints ;
            }
            $PointsReplacedMsg            = str_replace( "{points}" , $PointsToReplace , $Message ) ;
            $UserNameReplacedInMsg        = str_replace( "{username}" , $UserName , $PointsReplacedMsg ) ;
            $AvailabelPointsReplacedInMsg = str_replace( "{rewardpoints}" , round_off_type( $AvailabelPoints ) , $UserNameReplacedInMsg ) ;
            $SiteUrlReplacedInMsg         = str_replace( "{sitelink}" , site_url() , $AvailabelPointsReplacedInMsg ) ;
            $FinalMsg                     = str_replace( "{orderid}" , '#' . $OrderId , $SiteUrlReplacedInMsg ) ;
            return $FinalMsg ;
        }

    }

}