<?php
if ( ! defined( 'ABSPATH' ) ) {
    exit ; // Exit if accessed directly.
}
if ( ! class_exists( 'RSfunctionformforSendPoints' ) ) {

    class RSfunctionformforSendPoints {

        public static function init() {

            if ( get_option( 'rs_send_points_activated' ) == 'yes' ) {

                add_action( 'wp_ajax_rs_send_form_value' , array( __CLASS__ , 'save_selected_user' ) ) ;

                add_action( 'wp_ajax_nopriv_rs_send_form_value' , array( __CLASS__ , 'save_selected_user' ) ) ;

                add_shortcode( 'rssendpoints' , array( __CLASS__ , 'frontendformforsendpoints' ) ) ;

                add_action( 'wp_ajax_rs_send_form_value' , array( __CLASS__ , 'process_send_points_to_users' ) ) ;

                add_action( 'wp_ajax_rs_sumo_search_users' , array( __CLASS__ , 'rs_sumo_search_wp_users' ) ) ;
            }
        }

        public static function rs_sumo_search_wp_users() {
            $json_ids        = array() ;
            $customers_query = new WP_User_Query( array(
                'fields'         => 'all' ,
                'orderby'        => 'display_name' ,
                'search'         => '*' . $_REQUEST[ 'term' ] . '*' ,
                'search_columns' => array( 'ID' , 'user_login' , 'user_email' , 'user_nicename' )
                    ) ) ;
            $customers       = $customers_query->get_results() ;
            $current_user_id = get_current_user_id() ;
            if ( get_option( 'rs_select_send_points_user_type' ) == '1' ) {
                if ( ! empty( $customers ) ) {
                    foreach ( $customers as $customer ) {
                        if ( $current_user_id != $customer->ID ) {
                            $display_user[ $customer->ID ] = $customer->display_name . ' (#' . $customer->ID . ' - ' . sanitize_email( $customer->user_email ) . ')' ;
                        }
                    }
                }
            }
            if ( get_option( 'rs_select_send_points_user_type' ) == '2' ) {
                $getusers = get_option( 'rs_select_users_list_for_send_point' ) ;
                if ( $getusers != '' ) {
                    if ( ! is_array( $getusers ) ) {
                        $userids      = array_filter( array_map( 'absint' , ( array ) explode( ',' , $getusers ) ) ) ;
                        $display_user = self::rs_function_to_display_select_field( $userids , $customers , $current_user_id ) ;
                    } else {
                        $userids      = $getusers ;
                        $display_user = self::rs_function_to_display_select_field( $userids , $customers , $current_user_id ) ;
                    }
                }
            }
            wp_send_json( $display_user ) ;
            exit() ;
        }

        public static function rs_function_to_display_select_field( $userids , $customers , $current_user_id ) {
            foreach ( $userids as $userid ) {
                if ( ! empty( $customers ) ) {
                    foreach ( $customers as $customer ) {
                        if ( $current_user_id != $customer->ID ) {
                            if ( in_array( $customer->ID , $userids ) ) {
                                $found_customers[ $customer->ID ] = $customer->display_name . ' (#' . $customer->ID . ' - ' . sanitize_email( $customer->user_email ) . ')' ;
                            }
                        }
                    }
                }
            }
            return $found_customers ;
        }

        public static function frontendformforsendpoints() {
            if ( is_user_logged_in() ) {
                wp_enqueue_script( 'formforsendpoints' , false , array() , '' , true ) ;
                global $woocommerce ;
                global $wp_roles ;
                if ( get_option( 'rs_enable_msg_for_send_point' ) == '1' ) {
                    if ( is_user_logged_in() ) {
                        $user_ID           = get_current_user_id() ;
                        $currentuserpoints = RSPointExpiry::total_available_points_in_site( $user_ID ) ;
                        if ( $currentuserpoints > 0 ) {
                            ob_start() ;
                            $getusers     = get_option( 'rs_select_users_list_for_send_point' ) ;
                            ?>
                            <form id="sendpoint_form" method="post" enctype="multipart/form-data">
                                <table>
                                    <tr>
                                        <th>
                                            <label><?php echo get_option( "rs_total_send_points_request" ) ; ?></label>
                                        </th>
                                        <td style="border:none;padding: 6px 10px 6px 10px;">
                                            <input style="min-width:250px !important;height:30px !important;" type = "text" id = "rs_total_send_points_request" name = "rs_total_send_points_request" readonly="readonly" value="<?php echo $currentuserpoints ; ?>">
                                            <div class = "points_more_than_current_points"></div>
                                        </td>
                                    </tr>
                                    <tr>
                                        <th>
                                            <label><?php echo addslashes( get_option( "rs_select_user_label" ) ) ; ?></label>
                                        </th>
                                        <td style="border:none;padding: 6px 10px 6px 10px;">
                                            <?php
                                            global $woocommerce ;
                                            $place_holder = get_option( 'rs_select_user_placeholder' ) ;
                                            if ( ( float ) $woocommerce->version < ( float ) '3.0' ) {
                                                ?>
                                                <input id="select_user_ids" type="text" placeholder="<?php _e( $place_holder , 'rewardsystem' ) ?>" style="font-size:14px;min-width:250px !important;height:30px !important;"/>
                                                <script type="text/javascript">
                                                    jQuery( document ).ready( function () {
                                                        jQuery( "#select_user_ids" ).select2( {
                                                            allowClear : true ,
                                                            enable : false ,
                                                            readonly : false ,
                                                            multiple : false ,
                                                            initSelection : function ( data , callback ) {
                                                                var data_show = {
                                                                    id : data.val() ,
                                                                    text : data.attr( 'data-selected' )
                                                                } ;
                                                                if ( data.val() > 0 ) {
                                                                    return callback( data_show ) ;
                                                                }
                                                            } ,
                                                            minimumInputLength : 3 ,
                                                            ajax : {
                                                                url : '<?php echo admin_url( 'admin-ajax.php' ) ; ?>' ,
                                                                dataType : 'json' ,
                                                                type : "GET" ,
                                                                quietMillis : 250 ,
                                                                data : function ( term ) {
                                                                    return {
                                                                        term : term ,
                                                                        action : "rs_sumo_search_users"
                                                                    } ;
                                                                } ,
                                                                results : function ( data ) {
                                                                    var terms = [ ] ;
                                                                    if ( data ) {
                                                                        jQuery.each( data , function ( id , text ) {
                                                                            terms.push( {
                                                                                id : id ,
                                                                                text : text
                                                                            } ) ;
                                                                        } ) ;
                                                                    }
                                                                    return { results : terms } ;
                                                                }
                                                            }

                                                        } ) ;

                                                    } ) ;
                                                </script> 
                                            <?php } else { ?>
                                                <select id="select_user_ids" name="select_user_ids"  data-placeholder="<?php _e( $place_holder , 'rewardsystem' ) ?>" style="min-width:250px !important;height:30px !important;" data-allow_clear="true" ></select>
                                                <script type="text/javascript">
                                                    jQuery( document ).ready( function () {
                                                        jQuery( "#select_user_ids" ).select2( {
                                                            allowClear : true ,
                                                            minimumInputLength : 3 ,
                                                            escapeMarkup : function ( m ) {
                                                                return m ;
                                                            } ,
                                                            ajax : {
                                                                url : '<?php echo admin_url( 'admin-ajax.php' ) ; ?>' ,
                                                                dataType : 'json' ,
                                                                quietMillis : 250 ,
                                                                data : function ( params ) {
                                                                    return {
                                                                        term : params.term ,
                                                                        action : 'rs_sumo_search_users'
                                                                    } ;
                                                                } ,
                                                                processResults : function ( data ) {
                                                                    var terms = [ ] ;
                                                                    if ( data ) {
                                                                        jQuery.each( data , function ( id , text ) {
                                                                            terms.push( {
                                                                                id : id ,
                                                                                text : text
                                                                            } ) ;
                                                                        } ) ;
                                                                    }
                                                                    return {
                                                                        results : terms
                                                                    } ;
                                                                } ,
                                                                cache : true
                                                            }
                                                        } ) ;
                                                    } ) ;
                                                </script>
                                            <?php } ?>
                                            <div class = "error_empty_user" ></div>
                                        </td>
                                    </tr>
                                    <tr>
                                        <th>
                                            <label><?php echo get_option( "rs_points_to_send_request" ) ; ?></label>
                                        </th>
                                        <td style="border:none;padding: 6px 10px 6px 10px;">
                                            <input style="min-width:250px !important;height:30px !important;" type = "text" id = "rs_total_reward_value_send" name = "rs_total_reward_value_send" value=""/>
                                            <div class = "error_points_not_number" ></div>
                                            <div class = "error_greater_than_limit"> </div>
                                            <div class = "error_point_empty"></div>
                                            <div class = "points_less_than_current_points"> </div>
                                        </td>
                                    </tr>
                                    <tr>
                                        <th>
                                            <label><?php echo get_option( "rs_reason_for_send_points" ) ; ?></label>
                                        </th>
                                        <td style="border:none;padding: 6px 10px 6px 10px;">
                                            <input style="min-width:250px !important;height:30px !important;" type = "text" id = "rs_reason_for_send_points" name = "rs_reason_for_send_points" placeholder="<?php echo addslashes( get_option( 'rs_reason_for_send_points' ) ) ; ?>"  value=""/>
                                            <div class = "rs_reason_for_send_points"> </div>
                                        </td>
                                    </tr>
                                    <tr>
                                        <td colspan="2" style="border:none;padding: 6px 10px 6px 10px;">
                                            <div class = "success_info"></div>
                                        </td>
                                    </tr>
                                    <tr>
                                        <td  style="border:none;padding: 6px 10px 6px 10px;">
                                            <input type = "submit" name= "rs_send_points_submit_button" value="<?php echo addslashes( get_option( "rs_select_points_submit_label" ) ) ; ?>" id="rs_send_points_submit_button"/>
                                        </td>
                                    </tr>
                                </table>                                                                                                                                                                                               
                            </form>
                            <?php
                            $getcontent = ob_get_clean() ;
                            return $getcontent ;
                        } else {
                            $msg = get_option( 'rs_msg_when_user_have_no_points' ) ;
                            echo $msg ;
                        }
                    }
                }
            } else {
                $myaccountlink  = get_permalink( get_option( 'woocommerce_myaccount_page_id' ) ) ;
                $myaccounttitle = get_the_title( get_option( 'woocommerce_myaccount_page_id' ) ) ;
                $linkforlogin   = add_query_arg( 'redirect_to' , get_permalink() , $myaccountlink ) ;
                $message        = get_option( 'rs_message_shortcode_guest_display' ) ;
                $login          = get_option( 'rs_message_shortcode_login_name' ) ;
                echo '<br>' . $message . ' <a href=' . $linkforlogin . '> ' . $login . '</a>' ;
            }
        }

        public static function save_selected_user() {
            $getpostvalue  = $_POST[ 'selecteduserforsend' ] ;
            $currentuserid = get_current_user_id() ;
            update_user_meta( $currentuserid , 'rs_selected_user' , $getpostvalue ) ;
        }

        public static function process_send_points_to_users() {
            global $wpdb ;
            global $woocommerce ;
            if ( isset( $_POST[ 'points_to_send' ] ) && isset( $_POST[ 'selecteduserforsend' ] ) && ($_POST[ 'selecteduserforsend' ] != '') ) {
                $sender_userid                  = $_POST[ 'userid_of_send_request' ] ;
                $user_info                      = get_userdata( $sender_userid ) ;
                $sender_email                   = is_object( $user_info ) ? $user_info->user_email : '' ;
                $sender_username                = $_POST[ 'username_of_send_request' ] ;
                $points_to_be_send              = $_POST[ 'points_to_send' ] ;
                $current_points_for_user        = $_POST[ 'sender_current_points' ] ;
                $selected_user                  = $_POST[ 'selecteduserforsend' ] ;
                $user_info                      = get_userdata( $selected_user ) ;
                $receiver_user_name             = $user_info->user_login ;
                $table_name                     = $wpdb->prefix . "sumo_reward_send_point_submitted_data" ;
                $user_id                        = get_current_user_id() ;
                $reason                         = $_POST[ 'send_points_reason' ] ;
                $reason_to_send                 = update_option( 'rs_reason_for_send_points_mail' , $reason ) ;
                $receiver_email                 = is_object( $user_info ) ? $user_info->user_email : '' ;
                $date                           = rs_function_to_get_expiry_date_in_unixtimestamp() ;
                $default_status_of_send_request = $_POST[ 'send_default_status' ] ;
                $admin_name                     = '' ;
                $admin_email                    = '' ;
                $approval_type                  = get_option( 'rs_request_approval_type' ) ;
                $Email_subject                  = get_option( 'rs_email_subject_for_send_points_notification_admin' ) ;
                $Email_message                  = get_option( 'rs_email_message_for_send_points_notification_admin' ) ;
                $message                        = str_replace( '[sender]' , $sender_username , str_replace( '[receiver]' , $receiver_user_name , str_replace( '[points]' , $points_to_be_send , $Email_message ) ) ) ;
                $request_status                 = '' ;
                $headers                        = '' ;
                if ( get_option( 'rs_mail_for_send_points_notification_admin' ) == 'yes' ) {
                    if ( get_option( 'rs_mail_sender_for_admin' ) == 'woocommerce' ) {
                        $admin_email = get_option( 'admin_email' ) ;
                        $admin_name  = get_bloginfo( 'name' , 'display' ) ;
                    } else {
                        $admin_email = get_option( 'rs_from_email_for_sendpoints_for_admin' ) ;
                        $admin_name  = get_option( 'rs_from_name_for_sendpoints_for_admin' ) ;
                    }
                    $headers .= "MIME-Version: 1.0\r\n" ;
                    $headers .= "Content-Type: text/html; charset=UTF-8\r\n" ;
                    $headers .= "Reply-To: " . $admin_name . " <" . $admin_email . ">\r\n" ;

                    if ( $approval_type == '1' ) {
                        $request_status          = 'Still Waiting' ;
                        $request_type            = 'Manual Approval' ;
                        $Email_message_for_Admin = str_replace( '[Type]' , $request_type , str_replace( '[request_status]' , $request_status , $message ) ) ;
                    } else {
                        $request_status          = 'Accepted' ;
                        $request_type            = 'Auto Approval' ;
                        $Email_message_for_Admin = str_replace( '[Type]' , $request_type , str_replace( '[request_status]' , $request_status , $message ) ) ;
                    }
                    if ( $admin_name != '' && $admin_email != '' ) {
                        $Email_message_for_Admin = do_shortcode( $Email_message_for_Admin ) ;
                        ob_start() ;
                        wc_get_template( 'emails/email-header.php' , array( 'email_heading' => $Email_subject ) ) ;
                        echo $Email_message_for_Admin ;
                        wc_get_template( 'emails/email-footer.php' ) ;
                        $woo_temp_msg            = ob_get_clean() ;
                        if ( ( float ) $woocommerce->version <= ( float ) ('2.2.0') ) {
                            if ( wp_mail( $admin_email , $Email_subject , $Email_message_for_Admin , $headers ) ) {
                                
                            }
                        } else {
                            $mailer = WC()->mailer() ;
                            $mailer->send( $admin_email , $Email_subject , $woo_temp_msg , $headers ) ;
                        }
                    }
                }
            }
            update_user_meta( $user_id , 'rs_request_approval_type' , $approval_type ) ;
            if ( $approval_type == '2' ) {
                $status = 'Accepted' ;
                if ( get_option( 'rs_mail_for_send_points_for_user' ) == 'yes' ) {
                    if ( $sender_username != '' && $receiver_user_name != '' && $points_to_be_send != '' && $sender_email != '' && $receiver_email != '' ) {

                        $email_subject   = get_option( 'rs_email_subject_for_send_points' ) ;
                        $email_message   = get_option( 'rs_email_message_for_send_points' ) ;
                        $message         = str_replace( '[_rs_sendpoints]' , $points_to_be_send , str_replace( '[specific_user]' , $sender_username , str_replace( '[user_name]' , $receiver_user_name , $email_message ) ) ) ;
                        $Email_message   = str_replace( '[status]' , $status , str_replace( '[reason_message]' , $reason , $message ) ) ;
                        $Email_message   = do_shortcode( $Email_message ) ;
                        add_filter( 'woocommerce_email_footer_text' , 'footer_link' ) ;
                        ob_start() ;
                        wc_get_template( 'emails/email-header.php' , array( 'email_heading' => $email_subject ) ) ;
                        echo $Email_message ;
                        wc_get_template( 'emails/email-footer.php' ) ;
                        $woo_temp_msg    = ob_get_clean() ;
                        $message_headers = "MIME-Version: 1.0\r\n" ;
                        $message_headers .= "From: \"{$sender_username}\" <{$sender_email}>\n" . "Content-Type: text/html; charset=\"" . get_option( 'blog_charset' ) . "\"\n" ;
                        $message_headers .= "Reply-To: " . $receiver_user_name . " <" . $receiver_email . ">\r\n" ;
                        FPRewardSystem::$rs_from_name = $sender_username ;
                        add_filter( 'woocommerce_email_from_name' , 'rs_alter_from_name_of_woocommerce' , 10 , 2 ) ;
                        if ( ( float ) $woocommerce->version <= ( float ) ('2.2.0') ) {
                            if ( wp_mail( $receiver_email , $email_subject , $Email_message , $message_headers ) ) {
                                
                            }
                        } else {
                            $mailer                = WC()->mailer() ;
                            $mailer->send( $receiver_email , $email_subject , $woo_temp_msg , $message_headers ) ;
                        }
                        remove_filter( 'woocommerce_email_from_name' , 'rs_alter_from_name_of_woocommerce' , 10 , 1 ) ;
                    }
                }
                if ( get_option( 'rs_mail_for_send_points_confirmation_mail_for_user' ) == 'yes' ) {
                    if ( $sender_username != '' && $receiver_user_name != '' && $points_to_be_send != '' && $sender_email != '' ) {

                        $email_subject = get_option( 'rs_email_subject_for_send_points_confirmation' ) ;
                        $email_message = get_option( 'rs_email_message_for_send_points_confirmation' ) ;
                        $message       = str_replace( '[user_name]' , $sender_username , str_replace( '[request]' , 'Accepted' , str_replace( '[points]' , $points_to_be_send , str_replace( '[receiver_name]' , $receiver_user_name , $email_message ) ) ) ) ;
                        $Email_message = str_replace( '[status]' , $status , str_replace( '[reason_message]' , $reason , $message ) ) ;
                        $Email_message = do_shortcode( $Email_message ) ;
                        $admin_email   = get_option( 'admin_email' ) ;
                        $admin_name    = get_bloginfo( 'name' , 'display' ) ;
                        add_filter( 'woocommerce_email_footer_text' , 'footer_link' ) ;
                        ob_start() ;
                        wc_get_template( 'emails/email-header.php' , array( 'email_heading' => $email_subject ) ) ;
                        echo $Email_message ;
                        wc_get_template( 'emails/email-footer.php' ) ;
                        $woo_temp_msg  = ob_get_clean() ;
                        if ( $admin_name != '' && $admin_email != '' ) {
                            $message_headers              = "MIME-Version: 1.0\r\n" ;
                            $message_headers              .= "From: \"{$admin_name}\" <{$admin_email}>\n" . "Content-Type: text/html; charset=\"" . get_option( 'blog_charset' ) . "\"\n" ;
                            $message_headers              .= "Reply-To: " . $sender_username . " <" . $sender_email . ">\r\n" ;
                            FPRewardSystem::$rs_from_name = $admin_name ;
                            add_filter( 'woocommerce_email_from_name' , 'rs_alter_from_name_of_woocommerce' , 10 , 2 ) ;
                            if ( ( float ) $woocommerce->version <= ( float ) ('2.2.0') ) {
                                if ( wp_mail( $sender_email , $email_subject , $Email_message , $message_headers ) ) {
                                    
                                }
                            } else {
                                $mailer = WC()->mailer() ;
                                $mailer->send( $sender_email , $email_subject , $woo_temp_msg , $message_headers ) ;
                            }
                            remove_filter( 'woocommerce_email_from_name' , 'rs_alter_from_name_of_woocommerce' , 10 , 1 ) ;
                        }
                    }
                }
                $default_status_of_send_request = 'Paid' ;
                $equearnamt                     = RSPointExpiry::earning_conversion_settings( $points_to_be_send ) ;
                RSPointExpiry::insert_earning_points( $selected_user , $points_to_be_send , '0' , $date , 'SP' , '0' , $points_to_be_send , '0' , '' ) ;
                $totalpoints                    = RSPointExpiry::total_available_points_in_site( $selected_user ) ;
                RSPointExpiry::record_the_points( $selected_user , $points_to_be_send , '0' , $date , 'SP' , '0' , '0' , $equearnamt , '0' , '0' , '0' , '' , $totalpoints , $sender_userid , '0' ) ;
            }
            $wpdb->insert( $table_name , array( 'userid' => $sender_userid , 'userloginname' => $sender_username , 'pointstosend' => $points_to_be_send , 'sendercurrentpoints' => $current_points_for_user , 'status' => $default_status_of_send_request , 'selecteduser' => $selected_user , 'date' => date_i18n( 'Y-m-d H:i:s' ) ) ) ;
            $redeempoints = RSPointExpiry::perform_calculation_with_expiry( $points_to_be_send , $user_id ) ;
            $totalpoints  = RSPointExpiry::total_available_points_in_site( $user_id ) ;
            $equredeemamt = RSPointExpiry::redeeming_conversion_settings( $points_to_be_send ) ;
            if ( $approval_type == '1' ) {
                RSPointExpiry::record_the_points( $user_id , '0' , $points_to_be_send , $date , 'SPB' , '0' , $equredeemamt , '0' , '0' , '0' , '0' , '' , $totalpoints , $selected_user , '0' ) ;
            } else {
                RSPointExpiry::record_the_points( $user_id , '0' , $points_to_be_send , $date , 'SENPM' , '0' , $equredeemamt , '0' , '0' , '0' , '0' , '' , $totalpoints , $selected_user , '0' ) ;
            }
            exit() ;
        }

    }

    RSfunctionformforSendPoints::init() ;
}