<?php
if ( ! defined( 'ABSPATH' ) ) {
    exit ; // Exit if accessed directly.
}

if ( ! class_exists( 'RSFunctionForMyAccount' ) ) {

    class RSFunctionForMyAccount {

        public static function init() {

            add_shortcode( 'rs_user_total_redeemed_points' , array( __CLASS__ , 'add_shortcode_to_display_total_redeem_points' ) ) ;

            add_shortcode( 'rs_user_total_earned_points' , array( __CLASS__ , 'add_shortcode_to_display_total_earned_points' ) ) ;

            add_shortcode( 'rs_user_total_expired_points' , array( __CLASS__ , 'add_shortcode_to_display_total_expired_points' ) ) ;

            add_shortcode( 'rs_referred_user_name' , array( __CLASS__ , 'addshort_code_username' ) ) ;

            add_shortcode( 'rs_user_total_points_in_value' , array( __CLASS__ , 'add_shortcode_to_display_user_total_points_in_value' ) ) ;

            add_shortcode( 'rs_rank_based_total_earned_points' , array( __CLASS__ , 'view_total_user_points' ) ) ;

            add_shortcode( 'rs_rank_based_current_reward_points' , array( __CLASS__ , 'view_total_current_user_points' ) ) ;

            if ( get_option( 'rs_reward_content_menu_page' ) == 'yes' ) {
                $url_title = get_option( 'rs_my_reward_url_title' ) != '' ? get_option( 'rs_my_reward_url_title' ) : 'sumo-rewardpoints' ;
                add_filter( 'woocommerce_account_menu_items' , array( __CLASS__ , 'set_my_account_menu_items' ) ) ;
                add_action( 'woocommerce_account_' . $url_title . '_endpoint' , array( __CLASS__ , 'rs_account_my_reward_content' ) ) ;
            }
        }

        public static function view_total_current_user_points() {
            if ( is_user_logged_in() ) {
                $with_pagination = get_option( 'rs_select_pagination_for_available_points' ) ;
                global $wpdb ;
                $table_name      = $wpdb->prefix . 'rspointexpiry' ;
                $table_name2     = $wpdb->prefix . 'rsrecordpoints' ;
                echo '<p><b><big> Available Points </big></b></p>' ;
                if ( $with_pagination == '1' ) {
                    $outputtablefields = '<p> ' ;
                    $outputtablefields .= __( 'Page Size:' , 'rewardsystem' ) . '<select id="change-page-sizesss"><option value="5">5</option><option value="10">10</option><option value="50">50</option>
                    <option value="100">100</option>
                </select>' ;
                    $outputtablefields .= '</p>' ;
                    echo $outputtablefields ;
                    ?>
                    <table class = "totaluser_current demo shop_table my_account_orders table-bordered" data-page-size="5" data-page-previous-text = "prev" data-filter-text-only = "true" data-page-next-text = "next">
                        <thead><tr><th ><?php echo get_option( 'rs_my_rewards_sno_label' ) ; ?></th>                   
                                <th data-sortable="false"><?php echo get_option( 'rs_my_rewards_userid_label' ) ; ?></th>                  
                                <th data-type="numeric"><?php echo get_option( 'rs_my_rewards_points_earned_label' ) ; ?></th>

                        <tbody>
                            <?php
                            $getusermeta       = $wpdb->get_results( "SELECT userid ,(earnedpoints-usedpoints) as availablepoints FROM $table_name WHERE earnedpoints-usedpoints NOT IN(0) and expiredpoints IN(0) ORDER BY availablepoints DESC" , ARRAY_A ) ;
                            $i                 = 1 ;
                            foreach ( $getusermeta as $user ) {
                                $author_obj   = get_user_by( 'id' , $user[ 'userid' ] ) ;
                                $roundofftype = get_option( 'rs_round_off_type' ) == '1' ? '2' : '0' ;
                                $points       = round_off_type( $user[ 'availablepoints' ] ) ;
                                ?>
                                <tr>
                                    <td data-value="<?php echo $i ; ?>"><?php echo $i ; ?></td>                                     
                                    <td><?php echo is_object( $author_obj ) ? $author_obj->user_login : 'Guest' ; ?> </td>                                     
                                    <td><?php echo $points ; ?></td>
                                </tr>
                                <?php
                                $i ++ ;
                            }
                            ?>
                        </tbody>
                        <tfoot>
                            <tr style="clear:both;">
                                <td colspan="3">
                                    <div class="pagination pagination-centered"></div>
                                </td>
                            </tr>
                        </tfoot>
                    </table>
                    <?php ?>
                    <script type="text/javascript">
                        jQuery( document ).ready( function () {
                            jQuery( '.totaluser_current' ).footable() ;
                            jQuery( '#change-page-sizesss' ).change( function ( e ) {
                                e.preventDefault() ;
                                var pageSize = jQuery( this ).val() ;
                                jQuery( '.footable' ).data( 'page-size' , pageSize ) ;
                                jQuery( '.footable' ).trigger( 'footable_initialized' ) ;
                            } ) ;

                        } ) ;</script>
                    <?php
                } else {
                    ?>
                    <table class = "totaluser_current demo shop_table my_account_orders table-bordered" data-page-size="5" data-page-previous-text = "prev" data-filter-text-only = "true" data-page-next-text = "next">
                        <thead><tr><th ><?php echo get_option( 'rs_my_rewards_sno_label' ) ; ?></th>
                                <th data-sortable="false"><?php echo get_option( 'rs_my_rewards_userid_label' ) ; ?></th>
                                <th data-type="numeric"><?php echo get_option( 'rs_my_rewards_points_earned_label' ) ; ?></th>
                        <tbody>
                            <?php
                            $getusermeta          = $wpdb->get_results( "SELECT userid ,(earnedpoints-usedpoints) as availablepoints FROM $table_name WHERE earnedpoints-usedpoints NOT IN(0) and expiredpoints IN(0) ORDER BY availablepoints DESC" , ARRAY_A ) ;
                            $i                    = 1 ;
                            $value_for_pagination = get_option( 'rs_value_without_pagination_for_available_points' ) ;
                            foreach ( $getusermeta as $user ) {
                                $author_obj   = get_user_by( 'id' , $user[ 'userid' ] ) ;
                                $roundofftype = get_option( 'rs_round_off_type' ) == '1' ? '2' : '0' ;
                                $points       = round_off_type( $user[ 'availablepoints' ] ) ;
                                if ( $i <= $value_for_pagination ) {
                                    ?>
                                    <tr>
                                        <td data-value="<?php echo $i ; ?>"><?php echo $i ; ?></td>
                                        <td><?php echo is_object( $author_obj ) ? $author_obj->user_login : 'Guest' ; ?> </td>
                                        <td><?php echo $points ; ?></td>
                                    </tr>
                                    <?php
                                }
                                $i ++ ;
                            }
                            ?>
                        </tbody>
                        <tfoot>
                            <tr style="clear:both;">
                                <td colspan="3">
                                    <div class="pagination pagination-centered"></div>
                                </td>
                            </tr>
                        </tfoot>
                    </table>
                    <?php
                }
            } else {
                $myaccountlink  = get_permalink( get_option( 'woocommerce_myaccount_page_id' ) ) ;
                $myaccounttitle = get_the_title( get_option( 'woocommerce_myaccount_page_id' ) ) ;
                $linkforlogin   = add_query_arg( 'redirect_to' , get_permalink() , $myaccountlink ) ;
                $message        = get_option( 'rs_message_shortcode_guest_display' ) ;
                $login          = get_option( 'rs_message_shortcode_login_name' ) ;
                echo '<br>' . $message . ' <a href=' . $linkforlogin . '> ' . $login . '</a>' ;
            }
        }

        public static function view_total_user_points() {
            if ( is_user_logged_in() ) {
                global $wpdb ;
                $with_pagination    = get_option( 'rs_select_pagination_for_total_earned_points' ) ;
                $table_name         = $wpdb->prefix . 'rspointexpiry' ;
                $table_name2        = $wpdb->prefix . 'rsrecordpoints' ;
                echo '<p><b><big> Total Earned Points </big></b></p>' ;
                $outputtablefieldss = '<p> ' ;
                $outputtablefieldss .= __( 'Page Size:' , 'rewardsystem' ) . '<select id="change-page-sizess"><option value="5">5</option><option value="10">10</option><option value="50">50</option>
                    <option value="100">100</option>
                </select>' ;

                $outputtablefieldss .= '</p>' ;
                if ( $with_pagination == '1' ) {
                    echo $outputtablefieldss ;
                    ?>

                    <table class = "totaluser demo shop_table my_account_orders table-bordered" data-page-size="5" data-page-previous-text = "prev" data-filter-text-only = "true" data-page-next-text = "next">
                        <thead><tr><th ><?php echo get_option( 'rs_my_rewards_sno_label' ) ; ?></th>                   
                                <th data-sortable="false"><?php echo get_option( 'rs_my_rewards_userid_label' ) ; ?></th>                  
                                <th data-type="numeric"><?php echo get_option( 'rs_my_rewards_points_earned_label' ) ; ?></th>

                        <tbody>
                            <?php
                            $getusermeta = $wpdb->get_results( "SELECT userid ,earnedpoints  FROM $table_name WHERE earnedpoints NOT IN(0) and expiredpoints IN(0) ORDER BY earnedpoints DESC" , ARRAY_A ) ;
                            $i           = 1 ;
                            foreach ( $getusermeta as $user ) {
                                $author_obj          = get_user_by( 'id' , $user[ 'userid' ] ) ;
                                $roundofftype        = get_option( 'rs_round_off_type' ) == '1' ? '2' : '0' ;
                                $deletedearnedpoints = get_user_meta( $user[ 'userid' ] , 'rs_earned_points_before_delete' , true ) ;
                                $totalearned_points  = $user[ 'earnedpoints' ] + ( float ) $deletedearnedpoints ;
                                $points              = round_off_type( $totalearned_points ) ;
                                ?>
                                <tr>
                                    <td data-value="<?php echo $i ; ?>"><?php echo $i ; ?></td>                                     
                                    <td><?php echo is_object( $author_obj ) ? $author_obj->user_login : 'Guest' ; ?> </td>                                     
                                    <td><?php echo $points ; ?></td>
                                </tr>
                                <?php
                                $i ++ ;
                            }
                            ?>
                        </tbody>
                        <tfoot>
                            <tr style="clear:both;">
                                <td colspan="3">
                                    <div class="pagination pagination-centered"></div>
                                </td>
                            </tr>
                        </tfoot>
                    </table>
                    <?php ?>
                    <script type="text/javascript">
                        jQuery( document ).ready( function () {
                            jQuery( '.totaluser' ).footable() ;
                            jQuery( '#change-page-sizess' ).change( function ( e ) {
                                e.preventDefault() ;
                                var pageSize = jQuery( this ).val() ;
                                jQuery( '.footable' ).data( 'page-size' , pageSize ) ;
                                jQuery( '.footable' ).trigger( 'footable_initialized' ) ;
                            } ) ;

                        } ) ;</script>
                    <?php
                } else {
                    ?>
                    <table class = "totaluser demo shop_table my_account_orders table-bordered" data-page-size="5" data-page-previous-text = "prev" data-filter-text-only = "true" data-page-next-text = "next">
                        <thead><tr><th ><?php echo get_option( 'rs_my_rewards_sno_label' ) ; ?></th>                   
                                <th data-sortable="false"><?php echo get_option( 'rs_my_rewards_userid_label' ) ; ?></th>                  
                                <th data-type="numeric"><?php echo get_option( 'rs_my_rewards_points_earned_label' ) ; ?></th>

                        <tbody>
                            <?php
                            $getusermeta          = $wpdb->get_results( "SELECT userid ,earnedpoints  FROM $table_name WHERE earnedpoints NOT IN(0) and expiredpoints IN(0) ORDER BY earnedpoints DESC" , ARRAY_A ) ;
                            $i                    = 1 ;
                            $value_for_pagination = get_option( 'rs_value_without_pagination_for_total_earned_points' ) ;
                            foreach ( $getusermeta as $user ) {
                                $author_obj   = get_user_by( 'id' , $user[ 'userid' ] ) ;
                                $roundofftype = get_option( 'rs_round_off_type' ) == '1' ? '2' : '0' ;
                                $points       = round_off_type( $user[ 'earnedpoints' ] ) ;
                                if ( $i <= $value_for_pagination ) {
                                    ?>
                                    <tr>
                                        <td data-value="<?php echo $i ; ?>"><?php echo $i ; ?></td>                                     
                                        <td><?php echo is_object( $author_obj ) ? $author_obj->user_login : 'Guest' ; ?> </td>                                     
                                        <td><?php echo $points ; ?></td>
                                    </tr>
                                    <?php
                                }
                                $i ++ ;
                            }
                            ?>
                        </tbody>
                        <tfoot>
                            <tr style="clear:both;">
                                <td colspan="3">
                                    <div class="pagination pagination-centered"></div>
                                </td>
                            </tr>
                        </tfoot>
                    </table>
                    <?php
                }
            } else {
                $myaccountlink  = get_permalink( get_option( 'woocommerce_myaccount_page_id' ) ) ;
                $myaccounttitle = get_the_title( get_option( 'woocommerce_myaccount_page_id' ) ) ;
                $linkforlogin   = add_query_arg( 'redirect_to' , get_permalink() , $myaccountlink ) ;
                $message        = get_option( 'rs_message_shortcode_guest_display' ) ;
                $login          = get_option( 'rs_message_shortcode_login_name' ) ;
                echo '<br>' . $message . ' <a href=' . $linkforlogin . '> ' . $login . '</a>' ;
            }
        }

        public static function add_shortcode_to_display_user_total_points_in_value() {
            ob_start() ;
            if ( is_user_logged_in() ) {
                $getcurrentuserid = get_current_user_id() ;
                echo '<b>' . display_total_currency_value( $getcurrentuserid ) . '</b>' ;
            } else {
                $myaccountlink  = get_permalink( get_option( 'woocommerce_myaccount_page_id' ) ) ;
                $myaccounttitle = get_the_title( get_option( 'woocommerce_myaccount_page_id' ) ) ;
                $linkforlogin   = add_query_arg( 'redirect_to' , get_permalink() , $myaccountlink ) ;
                $message        = get_option( 'rs_message_shortcode_guest_display' ) ;
                $login          = get_option( 'rs_message_shortcode_login_name' ) ;
                echo '<br>' . $message . ' <a href=' . $linkforlogin . '> ' . $login . '</a>' ;
            }
            $newcontentss = ob_get_clean() ;
            return $newcontentss ;
        }

        public static function add_script_to_my_account() {
            if ( ! is_product() && ! is_checkout() && ! is_shop() ) {
                ?>
                <script type="text/javascript">
                    jQuery( document ).ready( function () {
                <?php
                if ( get_option( 'rs_facebook_application_id' ) != '' ) {
                    if ( get_option( 'rs_account_show_hide_facebook_like_button' ) == '1' ) {
                        ?>
                                window.fbAsyncInit = function () {
                                    FB.init( {
                                        appId : "<?php echo get_option( 'rs_facebook_application_id' ) ; ?>" ,
                                        xfbml : true ,
                                        version : 'v2.9'
                                    } ) ;
                                } ;
                                console.log( 'loaded script . . . . . ' ) ;
                                ( function ( d , s , id ) {
                                    var js , fjs = d.getElementsByTagName( s )[0] ;
                                    if ( d.getElementById( id ) )
                                        return ;
                                    js = d.createElement( s ) ;
                                    js.id = id ;
                        <?php if ( (get_option( 'rs_language_selection_for_button' ) == 1 ) ) { ?>
                                        js.src = "//connect.facebook.net/en_US/sdk.js#xfbml=1&version=v2.0" ;
                            <?php
                        } else {
                            if ( get_option( 'WPLANG' ) == '' ) {
                                ?>
                                            js.src = "//connect.facebook.net/en_US/sdk.js#xfbml=1&version=v2.0" ;
                            <?php } else { ?>
                                            js.src = "//connect.facebook.net/<?php echo get_option( 'WPLANG' ) ; ?>/sdk.js#xfbml=1&version=v2.0" ;
                            <?php } ?>
                        <?php } ?>
                                    fjs.parentNode.insertBefore( js , fjs ) ;
                                }( document , 'script' , 'facebook-jssdk' ) ) ;
                        <?php
                    }
                }
                ?>

                        function postToFeed( url , image , description , title ) {
                            if ( image == '' ) {
                                FB.ui( {
                                    method : 'share_open_graph' ,
                                    action_type : 'og.shares' ,
                                    action_properties : JSON.stringify( {
                                        object : {
                                            'og:url' : url ,
                                            'og:title' : title ,
                                            'og:description' : description ,
                                        }
                                    } )
                                } , function ( response ) {
                                    // Action after response
                                    if ( response != null ) {
                                        alert( 'sucessfully posted' ) ;
                                    } else {
                                        alert( 'cancel' ) ;
                                    }
                                } ) ;
                            } else {
                                FB.ui( {
                                    method : 'share_open_graph' ,
                                    action_type : 'og.shares' ,
                                    action_properties : JSON.stringify( {
                                        object : {
                                            'og:url' : url ,
                                            'og:title' : title ,
                                            'og:description' : description ,
                                            'og:image' : image
                                        }
                                    } )
                                } , function ( response ) {
                                    // Action after response
                                    if ( response != null ) {
                                        alert( 'sucessfully posted' ) ;
                                    } else {
                                        alert( 'cancel' ) ;
                                    }
                                } ) ;
                            }
                        }
                        jQuery( '.share_wrapper' ).click( function ( evt ) {
                            evt.preventDefault() ;
                            var a = document.getElementById( 'share_wrapper' )
                            var url = a.getAttribute( 'href' ) ;
                            var image = a.getAttribute( 'data-image' ) ;
                            var title = a.getAttribute( 'data-title' ) ;
                            var description = a.getAttribute( 'data-description' ) ;
                            postToFeed( url , image , description , title ) ;
                            return false ;
                        } ) ;
                        jQuery( '.examples' ).footable().bind( 'footable_filtering' , function ( e ) {
                            var selected = jQuery( '.filter-status' ).find( ':selected' ).text() ;
                            if ( selected && selected.length > 0 ) {
                                e.filter += ( e.filter && e.filter.length > 0 ) ? ' ' + selected : selected ;
                                e.clear = ! e.filter ;
                            }
                        } ) ;
                        jQuery( '.referrallog' ).footable().bind( 'footable_filtering' , function ( e ) {
                            var selected = jQuery( '.filter-status' ).find( ':selected' ).text() ;
                            if ( selected && selected.length > 0 ) {
                                e.filter += ( e.filter && e.filter.length > 0 ) ? ' ' + selected : selected ;
                                e.clear = ! e.filter ;
                            }
                        } ) ;
                        jQuery( '.referral_link' ).footable().bind( {
                            'footable_row_expanded' : function ( e ) {
                                jQuery( '.referralclick' ).click( function () {
                                    var getarraykey = jQuery( this ).attr( 'data-array' ) ;
                                    console.log( jQuery( this ).parent().parent().hide() ) ;
                                    var dataparam = ( {
                                        action : 'unset_referral' ,
                                        unsetarray : getarraykey ,
                                        userid : '<?php echo get_current_user_id() ; ?>'
                                    } ) ;
                                    jQuery.post( "<?php echo admin_url( 'admin-ajax.php' ) ; ?>" , dataparam ,
                                            function ( response ) {
                                                var newresponse = response.replace( /\s/g , '' ) ;
                                                if ( newresponse === "success" ) {
                                                    location.reload() ;
                                                }
                                            } ) ;
                                    return false ;
                                } ) ;
                                jQuery( '.share_wrapper' ).click( function ( evt ) {
                                    evt.preventDefault() ;
                                    var a = document.getElementById( 'share_wrapper' )
                                    var url = a.getAttribute( 'href' ) ;
                                    var image = a.getAttribute( 'data-image' ) ;
                                    var title = a.getAttribute( 'data-title' ) ;
                                    var description = a.getAttribute( 'data-description' ) ;
                                    postToFeed( url , image , description , title ) ;
                                    return false ;
                                } ) ;
                            } ,
                        } ) ;
                        jQuery( '#change-page-sizes' ).change( function ( e ) {
                            e.preventDefault() ;
                            var pageSize = jQuery( this ).val() ;
                            jQuery( '.footable' ).data( 'page-size' , pageSize ) ;
                            jQuery( '.footable' ).trigger( 'footable_initialized' ) ;
                        } ) ;
                    } ) ;
                </script>
                <?php
            }
        }

        /* Shortcode For Total Redeem Points */

        public static function add_shortcode_to_display_total_redeem_points() {
            if ( is_user_logged_in() ) {
                $getcurrentuserid     = get_current_user_id() ;
                $roundofftype         = get_option( 'rs_round_off_type' ) == '1' ? '2' : '0' ;
                $total_points_redemed = RSPointExpiry::get_sum_of_total_redeemed_points( $getcurrentuserid ) ;
                return round_off_type( $total_points_redemed ) ;
            } else {
                $myaccountlink  = get_permalink( get_option( 'woocommerce_myaccount_page_id' ) ) ;
                $myaccounttitle = get_the_title( get_option( 'woocommerce_myaccount_page_id' ) ) ;
                $message        = get_option( 'rs_message_shortcode_guest_display' ) ;
                $login          = get_option( 'rs_message_shortcode_login_name' ) ;
                $msg            = $message . ' <a href=' . $myaccountlink . '> ' . $login . '</a>' ;
                return '<br>' . $msg ;
            }
        }

        /* Shortcode For Total Earned Points */

        public static function add_shortcode_to_display_total_earned_points() {
            if ( is_user_logged_in() ) {
                $getcurrentuserid    = get_current_user_id() ;
                $roundofftype        = get_option( 'rs_round_off_type' ) == '1' ? '2' : '0' ;
                $total_points_earned = RSPointExpiry::total_points_earned_in_site( $getcurrentuserid ) ;
                return round_off_type( $total_points_earned ) ;
            } else {
                $myaccountlink  = get_permalink( get_option( 'woocommerce_myaccount_page_id' ) ) ;
                $myaccounttitle = get_the_title( get_option( 'woocommerce_myaccount_page_id' ) ) ;
                $linkforlogin   = add_query_arg( 'redirect_to' , get_permalink() , $myaccountlink ) ;
                $message        = get_option( 'rs_message_shortcode_guest_display' ) ;
                $login          = get_option( 'rs_message_shortcode_login_name' ) ;
                echo '<br>' . $message . ' <a href=' . $linkforlogin . '> ' . $login . '</a>' ;
            }
        }

        /* Shortcode For Total Expired Points */

        public static function add_shortcode_to_display_total_expired_points() {
            if ( is_user_logged_in() ) {
                $getcurrentuserid     = get_current_user_id() ;
                $roundofftype         = get_option( 'rs_round_off_type' ) == '1' ? '2' : '0' ;
                $total_points_expired = RSPointExpiry::get_sum_of_total_expired_points( $getcurrentuserid ) ;
                return round_off_type( $total_points_expired ) ;
            } else {
                $myaccountlink  = get_permalink( get_option( 'woocommerce_myaccount_page_id' ) ) ;
                $myaccounttitle = get_the_title( get_option( 'woocommerce_myaccount_page_id' ) ) ;
                $linkforlogin   = add_query_arg( 'redirect_to' , get_permalink() , $myaccountlink ) ;
                $message        = get_option( 'rs_message_shortcode_guest_display' ) ;
                $login          = get_option( 'rs_message_shortcode_login_name' ) ;
                echo '<br>' . $message . ' <a href=' . $linkforlogin . '> ' . $login . '</a>' ;
            }
        }

        public static function addshort_code_username() {
            if ( get_option( 'rs_generate_referral_link_based_on_user' ) == '1' ) {
                $user          = get_user_by( 'login' , $_GET[ 'ref' ] ) ;
                $currentuserid = is_object( $user ) ? $user->user_nicename : 'Guest' ;
                return $currentuserid ;
            } else {
                $user_info     = get_userdata( $_GET[ 'ref' ] ) ;
                $currentuserid = is_object( $user_info ) ? $user_info->user_login : 'Guest' ;
                return $currentuserid ;
            }
        }

        /**
         * Set our menus under My account menu items
         * @param array $items
         * @return array
         */
        public static function set_my_account_menu_items( $items ) {

            $reward_content_title = get_option( 'rs_my_reward_content_title' ) ;
            $url_title            = get_option( 'rs_my_reward_url_title' ) != '' ? get_option( 'rs_my_reward_url_title' ) : 'sumo-rewardpoints' ;
            $menu                 = array(
                $url_title => $reward_content_title ,
                    ) ;
            $position             = 2 ;
            $items                = array_slice( $items , 0 , $position ) + $menu + array_slice( $items , $position , count( $items ) - 1 ) ;
            return $items ;
        }

        public static function rs_account_my_reward_content() {
            RSFunctionForMessage::view_list_table_in_myaccount() ;
            if ( get_option( 'rs_cashback_activated' ) == 'yes' ) {
                self::view_cash_back_table_in_myaccount_page() ;
            }

            if ( get_option( 'rs_nominee_activated' ) == 'yes' && get_option( 'rs_show_hide_nominee_field_menu_page' ) == '1' ) {

                self::display_nominee_field_in_my_account_page() ;
            }
            if ( get_option( 'rs_gift_voucher_activated' ) == 'yes' && get_option( 'rs_show_hide_redeem_voucher_menu_page' ) == '1' ) {
                self::reward_system_my_account_voucher_redeem_page() ;
            }

            if ( get_option( 'rs_referral_activated' ) == 'yes' ) {
                if ( get_option( 'rs_show_hide_referal_table_menu_page' ) == '1' ) {
                    if ( RSFunctionForReferAFriend::check_if_referral_link_generation_is_restricted() )
                        self::view_list_referal_table_page() ;
                }
                if ( get_option( 'rs_show_hide_generate_referral_menu_page' ) == '1' ) {
                    if ( get_option( 'rs_show_hide_generate_referral_link_type' ) == '2' ) {
                        if ( RSFunctionForReferAFriend::check_if_referral_link_generation_is_restricted() )
                            self::static_referral_function_page() ;
                    } else {
                        if ( RSFunctionForReferAFriend::check_if_referral_link_generation_is_restricted() )
                            self::function_for_referal_link_page() ;
                    }
                }
            }
            if ( get_option( 'rs_email_activated' ) == 'yes' ) {
                self::function_for_unsubscribe_email_page() ;
            }
        }

        public static function function_for_unsubscribe_email_page() {
            $link_check = get_option( 'rs_show_hide_your_subscribe_link_menu_page' ) ;
            echo RSFunctionForEmailTemplate::sub_option_in_my_account_page_buffer( $link_check ) ;
        }

        public static function view_cash_back_table_in_myaccount_page() {
            $table_data = array(
                'rs_cash_back'                 => get_option( 'rs_cashback_activated' ) ,
                'rs_cash_back_table'           => get_option( 'rs_my_cashback_table_menu_page' ) ,
                'rs_cash_back_label'           => get_option( 'rs_my_cashback_title' ) ,
                'rs_cash_back_sno_label'       => get_option( 'rs_my_cashback_sno_label' ) ,
                'rs_cash_back_user_label'      => get_option( 'rs_my_cashback_userid_label' ) ,
                'rs_cash_back_requested_label' => get_option( 'rs_my_cashback_requested_label' ) ,
                'rs_cash_back_status_label'    => get_option( 'rs_my_cashback_status_label' ) ,
                'rs_cash_back_action_label'    => get_option( 'rs_my_cashback_action_label' )
                    ) ;
            echo RSFunctionForFormForCashBack::view_cash_back_table_in_myaccount_buffer( $table_data ) ;
        }

        public static function display_nominee_field_in_my_account_page() {
            $nominee_table_parameters = array(
                'rs_nominee_type_of_user'   => get_option( 'rs_select_type_of_user_for_nominee' ) ,
                'rs_nominee_user_selection' => get_option( 'rs_select_users_list_for_nominee' ) ,
                'rs_nominee_title'          => get_option( 'rs_my_nominee_title' ) ,
                'rs_nominee_name'           => get_option( 'rs_select_type_of_user_for_nominee_name' ) ,
                'rs_nominee_user_role'      => get_option( 'rs_select_users_role_for_nominee' ) ,
                    ) ;
            echo RSFunctionForNominee::display_nominee_field_in_my_account_buffer( $nominee_table_parameters ) ;
        }

        public static function reward_system_my_account_voucher_redeem_page() {
            echo RSFunctionForGiftVoucher::reward_system_my_account_voucher_redeem_buffer() ;
        }

        public static function view_list_referal_table_page() {
            $referral_reward_table = array(
                'show_table'           => get_option( 'rs_show_hide_referal_table_menu_page' ) ,
                'sno_lable'            => get_option( 'rs_my_referal_sno_label' ) ,
                'userid_lable'         => get_option( 'rs_my_referal_userid_label' ) ,
                'total_referral_lable' => get_option( 'rs_my_total_referal_points_label' ) ,
                'title_table'          => get_option( 'rs_referal_table_title' ) ,
                    ) ;
            echo RSFunctionForReferralSystem::view_list_referal_table_buffer( $referral_reward_table ) ;
        }

        public static function static_referral_function_page() {
            echo RSFunctionForReferAFriend::static_referral_function_buffer() ;
        }

        public static function function_for_referal_link_page() {
            echo RSFunctionForReferAFriend::function_for_referal_link_buffer() ;
        }

    }

    RSFunctionForMyAccount::init() ;
}