<?php
if (!defined('ABSPATH')) {
    exit; // Exit if accessed directly.
}
if (!class_exists('RSFunctionForFormForCashBack')) {

    class RSFunctionForFormForCashBack {

        public static function init() {
            $cashback_module = get_option('rs_cashback_activated');
            if ($cashback_module == 'yes') {
                add_shortcode('rsencashform', array(__CLASS__, 'encashing_front_end_form'));

                add_action('wp_ajax_rs_encash_form_value', array(__CLASS__, 'process_encashing_points_to_users'));
            }
            if (get_option('rs_cashback_activated') == 'yes') {
                if (get_option('rs_my_cashback_table') == '1' && get_option('rs_reward_content') == 'yes') {
                    add_action('woocommerce_after_my_account', array(__CLASS__, 'view_cash_back_table_in_myaccount'));
                }
                if (get_option('rs_my_cashback_table_shortcode') == '1' && get_option('rs_reward_content_shortcode') == 'yes') {
                    add_shortcode('rs_my_cashback_log', array(__CLASS__, 'view_cash_back_table_in_myaccount_shortcode'));
                }
                add_action('wp_ajax_nopriv_cancel_request_for_cash_back', array(__CLASS__, 'ajax_request_for_cash_back'));

                add_action('wp_ajax_cancel_request_for_cash_back', array(__CLASS__, 'ajax_request_for_cash_back'));
            }
        }

        public static function ajax_request_for_cash_back() {
            global $wpdb;
            $table_name = $wpdb->prefix . 'sumo_reward_encashing_submitted_data';
            $table_name1 = $wpdb->prefix . "rspointexpiry";
            $table_name2 = $wpdb->prefix . "rsrecordpoints";
            if ($_POST['status'] != 'Cancelled') {
                $ids = $_POST['id'];
                $wpdb->update($table_name, array('status' => 'Cancelled'), array('id' => $ids));
                $message = __($countids . ' Status Changed to Cancelled', 'rewardsystem');
                $user_id = $wpdb->get_results("SELECT userid FROM $table_name WHERE id = $ids", ARRAY_A);
                foreach ($user_id as $value) {
                    $user_idss = $value['userid'];
                }
                $returnedpoints = $wpdb->get_results("SELECT pointstoencash FROM $table_name WHERE id = $ids", ARRAY_A);
                foreach ($returnedpoints as $value) {
                    $returnedpointsss = $value['pointstoencash'];
                }
                $date = rs_function_to_get_expiry_date_in_unixtimestamp();
                $equearnamt = RSPointExpiry::earning_conversion_settings($returnedpointsss);
                RSPointExpiry::insert_earning_points($user_idss, $returnedpointsss, '0', $date, 'RCBRP', '0', $returnedpointsss, '0', '');
                $totalpoints = RSPointExpiry::total_available_points_in_site($user_idss);
                RSPointExpiry::record_the_points($user_idss, $returnedpointsss, '0', $date, 'RCBRP', '0', '0', $equearnamt, '0', '0', '0', '', $totalpoints, '', '0');
            }
        }

        public static function view_cash_back_table_in_myaccount() {
            $table_data = array(
                'rs_cash_back' => get_option('rs_cashback_activated'),
                'rs_cash_back_table' => get_option('rs_my_cashback_table'),
                'rs_cash_back_label' => get_option('rs_my_cashback_title'),
                'rs_cash_back_sno_label' => get_option('rs_my_cashback_sno_label'),
                'rs_cash_back_user_label' => get_option('rs_my_cashback_userid_label'),
                'rs_cash_back_requested_label' => get_option('rs_my_cashback_requested_label'),
                'rs_cash_back_status_label' => get_option('rs_my_cashback_status_label'),
                'rs_cash_back_action_label' => get_option('rs_my_cashback_action_label')
            );
            echo self::view_cash_back_table_in_myaccount_buffer($table_data);
        }

        public static function view_cash_back_table_in_myaccount_buffer($table_data) {
            $rs_cash_back_module_check = $table_data['rs_cash_back'];
            $rs_cash_back_table_check = $table_data['rs_cash_back_table'];
            if ($rs_cash_back_module_check == 'yes' && $rs_cash_back_table_check == '1') {
                global $wpdb;
                $table_name = $wpdb->prefix . 'rspointexpiry';
                $table_name2 = $wpdb->prefix . 'rsrecordpoints';
                $table_name3 = $wpdb->prefix . 'sumo_reward_encashing_submitted_data';
                ?>
                <style type="text/css">
                <?php echo get_option('rs_myaccount_custom_css'); ?>
                </style>
                <?php
                $userid = get_current_user_id();
                $fetcharray = $wpdb->get_results("SELECT * FROM $table_name3 WHERE userid = $userid", ARRAY_A);
                ob_start();
                if (!empty($fetcharray)) {
                    echo "<h2 class=rs_my_cashback_title>" . $table_data['rs_cash_back_label'] . "</h2>";
                    ?>
                    <script type="text/javascript">
                        jQuery(document).ready(function () {
                            jQuery('.cancelbutton').click(function () {
                                var status = jQuery(this).attr('data-status');
                                var current_user_id = '<?php echo get_current_user_id(); ?>';
                                var id = jQuery(this).attr('data-id');
                                var removed_key_param = {
                                    action: "cancel_request_for_cash_back",
                                    status: status,
                                    current_user_id: current_user_id,
                                    id: id,
                                };
                                jQuery.post("<?php echo admin_url('admin-ajax.php'); ?>", removed_key_param, function (response) {
                                    location.reload();
                                    console.log('Success');
                                });
                                return false;
                            });
                            return false;
                        });
                    </script>
                    <table class = "examples demo shop_table my_account_orders table-bordered" data-filter = "#filters" data-page-size="5" data-page-previous-text = "prev" data-filter-text-only = "true" data-page-next-text = "next">

                        <thead><tr><th data-toggle="true" data-sort-initial = "true"><?php echo $table_data['rs_cash_back_sno_label']; ?></th>
                                <th><?php echo $table_data['rs_cash_back_user_label']; ?></th>
                                <th><?php echo $table_data['rs_cash_back_requested_label']; ?></th>
                                <th><?php echo $table_data['rs_cash_back_status_label']; ?></th>
                                <th><?php echo $table_data['rs_cash_back_action_label']; ?></th>
                        <tbody>
                            <?php
                            $userid = get_current_user_id();
                            $fetcharray = $wpdb->get_results("SELECT * FROM $table_name3 WHERE userid = $userid", ARRAY_A);
                            if (is_array($fetcharray)) {
                                if (get_option('rs_points_log_sorting') == '1') {
                                    krsort($fetcharray, SORT_NUMERIC);
                                }
                            }
                            $i = 1;
                            if (is_array($fetcharray)) {
                                foreach ($fetcharray as $newarray) {
                                    if (is_array($newarray)) {
                                        $usernickname = RSFunctionForSavingMetaValues::rewardsystem_get_user_meta($newarray['userid'], 'nickname');
                                        $getoption = get_option('_rs_localize_points_to_cash_log_in_my_cashback_table');
                                        $pointstocashback = $newarray['pointstoencash'];
                                        $strreplace = str_replace('[pointstocashback]', $pointstocashback, $getoption);
                                        $cashbackamount = $newarray['pointsconvertedvalue'];
                                        $strreplace1 = str_replace('[cashbackamount]', get_woocommerce_currency_symbol() . $cashbackamount, $strreplace);
                                        $rewarderforfrontend = $strreplace1;
                                        $status = $newarray['status'];
                                        $id = $newarray['id'];
                                        $statuses = array(
                                            'Cancelled' => __('Cancelled', 'rewardsystem'),
                                            'Paid' => __('Paid', 'rewardsystem'),
                                            'Due' => __('Due', 'rewardsystem'),
                                        );
                                        $button_status = __('Cancel', 'rewardsystem');
                                        ?>
                                        <tr>
                                            <td data-value="<?php echo $i; ?>"><?php echo $i; ?></td>
                                            <td><?php echo $usernickname; ?> </td>
                                            <td><?php echo $rewarderforfrontend; ?></td>
                                            <td><?php echo $statuses[$status]; ?></td>
                                            <?php if ($status != 'Cancelled' && $status != 'Paid') { ?>
                                                <td><input type="button" class = "cancelbutton" value= "<?php echo $button_status; ?>" data-id="<?php echo $id; ?>" data-status="<?php echo $status; ?>"/></td>
                                            <?php } else { ?>
                                                <td><?php
                                                    if ($status == 'Paid') {
                                                        echo '-';
                                                    }
                                                    ?></td>
                                            <?php } ?>
                                        </tr>
                                        <?php
                                        $i ++;
                                        ?>
                                        <?php
                                    }
                                }
                            }
                            ?>
                        </tbody>
                        <tfoot>
                            <tr style="clear:both;">
                                <td colspan="7">
                                    <div class="pagination pagination-centered"></div>
                                </td>
                            </tr>
                        </tfoot>
                    </table>

                    <?php
                }
                $contents = ob_get_contents();
                ob_end_clean();
                return $contents;
            }
        }

        public static function view_cash_back_table_in_myaccount_shortcode() {
            wp_enqueue_script('encashform', false, array(), '', true);
            if (is_user_logged_in()) {
                $table_data = array(
                    'rs_cash_back' => get_option('rs_cashback_activated'),
                    'rs_cash_back_table' => get_option('rs_my_cashback_table_shortcode'),
                    'rs_cash_back_label' => get_option('rs_my_cashback_title_shortcode'),
                    'rs_cash_back_sno_label' => get_option('rs_my_cashback_sno_label_shortcode'),
                    'rs_cash_back_user_label' => get_option('rs_my_cashback_userid_label_shortcode'),
                    'rs_cash_back_requested_label' => get_option('rs_my_cashback_requested_label_shortcode'),
                    'rs_cash_back_status_label' => get_option('rs_my_cashback_status_label_shortcode'),
                    'rs_cash_back_action_label' => get_option('rs_my_cashback_action_label_shortcode')
                );
                echo self::view_cash_back_table_in_myaccount_buffer($table_data);
            } else {
                $myaccountlink = get_permalink(get_option('woocommerce_myaccount_page_id'));
                $myaccounttitle = get_the_title(get_option('woocommerce_myaccount_page_id'));
                $linkforlogin = add_query_arg('redirect_to', get_permalink(), $myaccountlink);
                $message = get_option('rs_message_shortcode_guest_display');
                $login = get_option('rs_message_shortcode_login_name');
                echo '<br>' . $message . ' <a href=' . $linkforlogin . '> ' . $login . '</a>';
            }
        }

        public static function encashing_front_end_form() {
            if (!self::rs_display_cashback_form()) {
                echo '<p><b>Cashback Form is currently restricted for your account</b></p>';
                return false;
            }

            if (is_user_logged_in()) {
                wp_enqueue_script('encashform', false, array(), '', true);
                if (get_option('rs_enable_disable_encashing') == '1') {
                    if (is_user_logged_in()) {
                        $user_ID = get_current_user_id();
                        if (RSPointExpiry::total_available_points_in_site($user_ID) > 0) {
                            $userid = get_current_user_id();
                            $banning_type = FPRewardSystem::check_banning_type($userid);
                            if ($banning_type != 'earningonly' && $banning_type != 'both') {
                                ob_start();
                                $encash_form_style_option = get_option('rs_encash_form_inbuilt_design');
                                ?>

                                <style type="text/css">
                                <?php
                                if ($encash_form_style_option == '1') {
                                    echo get_option('rs_encash_form_default_css');
                                } else {
                                    echo get_option('rs_encash_form_custom_css');
                                }
                                ?>

                                </style>
                                <?php
                                $rs_minimum_points_for_encash = get_option('rs_minimum_points_encashing_request');
                                $rs_maximum_points_for_encash = get_option('rs_maximum_points_encashing_request');
                                $minimum_encash_to_find = "[minimum_encash_points]";
                                $maximum_encash_to_find = "[maximum_encash_points]";
                                $rs_error_mesage_minimum_encash = get_option('rs_error_message_points_lesser_than_minimum_points');

                                $rs_current_points_less_than_minimum_points = get_option('rs_error_message_currentpoints_less_than_minimum_points');
                                $rs_current_points_less_than_minimum_points_replaced = str_replace($minimum_encash_to_find, $rs_minimum_points_for_encash, $rs_current_points_less_than_minimum_points);
                                $user_ID = get_current_user_id();
                                $currentuserpoints = RSPointExpiry::total_available_points_in_site($user_ID);
                                $roundofftype = get_option('rs_round_off_type') == '1' ? '2' : '0';
                                $currentuserpoints = round_off_type($currentuserpoints);
                                $redeempoint_for_cashback = get_option('rs_redeem_point_for_cash_back');
                                $redeempoint_value_for_cashback = get_option('rs_redeem_point_value_for_cash_back');
                                $pointconversion = $currentuserpoints / $redeempoint_for_cashback;
                                $pointconversionvalue = $pointconversion * $redeempoint_value_for_cashback;
                                $valueforcashback = $currentuserpoints . '(' . get_woocommerce_currency_symbol() . $pointconversionvalue . ')';
                                $rs_error_mesage_minimum_encash_replaced = str_replace($minimum_encash_to_find, $rs_minimum_points_for_encash != '' ? $rs_minimum_points_for_encash : '0', $rs_error_mesage_minimum_encash);
                                $rs_error_mesage_min_max_encash_replaced = str_replace($maximum_encash_to_find, $rs_maximum_points_for_encash != '' ? $rs_maximum_points_for_encash : $currentuserpoints, $rs_error_mesage_minimum_encash_replaced);
                                echo '<form id="encashing_form" method="post" enctype="multipart/form-data">';
                                echo '<div class ="rs_current_points_value"><p><label><b>' . get_option("rs_total_points_for_cashback_request") . '</b></label></p><p><input type = "text" id = "rs_available_points" name = "rs_available_points" value=' . $valueforcashback . ' readonly="readonly"></p></div>';
                                if (get_option('rs_allow_user_to_request_cashback') == '1') {
                                    echo '<div class ="rs_encash_points_value"><p><label><b>' . get_option("rs_encashing_points_label") . '</b></label></p><p><input type = "text" id = "rs_encash_points_value" name = "rs_encash_points_value" value=""></p></div>';
                                } else {
                                    echo '<div class ="rs_encash_points_value"><p><label><b>' . get_option("rs_encashing_points_label") . '</b></label></p><p><input type = "text" id = "rs_encash_points_value" name = "rs_encash_points_value" readonly="readonly" value=' . $currentuserpoints . '></p></div>';
                                }
                                echo '<div class = "error" for = "rs_encash_points_value" id ="points_empty_error">' . addslashes(get_option("rs_error_message_points_empty_encash")) . '</div>';
                                echo '<div class = "error" for = "rs_encash_points_value" id ="points_number_error">' . addslashes(get_option("rs_error_message_points_number_val_encash")) . '</div>';
                                echo '<div class = "error" for = "rs_encash_points_value" id ="points_greater_than_earnpoints_error">' . addslashes(get_option("rs_error_message_points_greater_than_earnpoints")) . '</div>';
                                echo '<div class = "error" for = "rs_encash_points_value" id ="currentpoints_lesser_than_minimumpoints_error">' . addslashes($rs_current_points_less_than_minimum_points_replaced) . '</div>';
                                echo '<div class = "error" for = "rs_encash_points_value" id ="points_lesser_than_minpoints_error">' . addslashes($rs_error_mesage_min_max_encash_replaced) . '</div>';
                                echo '<div class ="rs_encash_points_reason"><p><label><b>' . addslashes(get_option("rs_encashing_reason_label")) . '</b></label></p><p><textarea name ="rs_encash_points_reason" id="rs_encash_points_reason" rows= "3" cols= "50"></textarea></p></div>';
                                echo '<div class = "error" for = "rs_encash_points_reason" id ="reason_empty_error">' . addslashes(get_option("rs_error_message_reason_encash_empty")) . '</div>';
                                if (check_whether_hoicker_is_active()) {
                                    $walletia_label = get_option('rs_encashing_wallet_menu_label') != '' ? get_option('rs_encashing_wallet_menu_label') : 'Hoicker Wallet';
                                    if (get_option('rs_select_payment_method') == '4') {
                                        echo '<input type="hidden" value="' . $walletia_label . '" id="is_walletia_selected" class="is_walletia_selected" name="is_walletia_selected">';
                                    }
                                    echo '<div class ="rs_encash_payment_method"><p><label><b>' . addslashes(get_option("rs_encashing_payment_method_label")) . '</b></label></p><p><select id= "rs_encash_payment_method"><option value="encash_through_paypal_method">PayPal</option><option value="encash_through_custom_payment">Custom Payment</option><option value="' . $walletia_label . '">' . $walletia_label . '</option></select></p></div>';
                                    echo '<div class ="rs_encash_wallet"><p><label><b>' . addslashes(get_option("rs_encashing_wallet_label")) . '</b></label></p></div>';
                                } else {
                                    if (get_option('rs_select_payment_method') == '3' && get_option('rs_allow_admin_to_save_previous_payment_method') == 'yes') {
                                        if (get_user_meta($user_ID, 'rs_cashback_previous_payment_method', true) == 'encash_through_paypal_method') {
                                            echo '<div class ="rs_encash_payment_method"><p><label><b>' . addslashes(get_option("rs_encashing_payment_method_label")) . '</b></label></p><p><select id= "rs_encash_payment_method"><option value="encash_through_paypal_method" selected="selected">PayPal</option><option value="encash_through_custom_payment">Custom Payment</option></select></p></div>';
                                        } elseif (get_user_meta($user_ID, 'rs_cashback_previous_payment_method', true) == 'encash_through_custom_payment') {
                                            echo '<div class ="rs_encash_payment_method"><p><label><b>' . addslashes(get_option("rs_encashing_payment_method_label")) . '</b></label></p><p><select id= "rs_encash_payment_method"><option value="encash_through_paypal_method">PayPal</option><option value="encash_through_custom_payment" selected="selected">Custom Payment</option></select></p></div>';
                                        } else {
                                            echo '<div class ="rs_encash_payment_method"><p><label><b>' . addslashes(get_option("rs_encashing_payment_method_label")) . '</b></label></p><p><select id= "rs_encash_payment_method"><option value="encash_through_paypal_method">PayPal</option><option value="encash_through_custom_payment">Custom Payment</option></select></p></div>';
                                        }
                                    } else {
                                        echo '<div class ="rs_encash_payment_method"><p><label><b>' . addslashes(get_option("rs_encashing_payment_method_label")) . '</b></label></p><p><select id= "rs_encash_payment_method"><option value="encash_through_paypal_method">PayPal</option><option value="encash_through_custom_payment">Custom Payment</option></select></p></div>';
                                    }
                                }



                                if (get_option('rs_select_payment_method') == '3' && get_option('rs_allow_admin_to_save_previous_payment_method') == 'yes' && get_user_meta(get_current_user_id(), 'rs_paypal_payment_details', true) != '') {
                                    echo '<div class ="rs_encash_paypal_address"><p><label><b>' . addslashes(get_option("rs_encashing_payment_paypal_label")) . '</b></label></p><p><input type = "text" id = "rs_encash_paypal_address" name = "rs_encash_paypal_address" value=" ' . get_user_meta(get_current_user_id(), 'rs_paypal_payment_details', true) . ' "></p></div>';
                                } else {
                                    echo '<div class ="rs_encash_paypal_address"><p><label><b>' . addslashes(get_option("rs_encashing_payment_paypal_label")) . '</b></label></p><p><input type = "text" id = "rs_encash_paypal_address" name = "rs_encash_paypal_address" value=""></p></div>';
                                }



                                echo '<div class = "error" for = "rs_encash_paypal_address" id ="paypal_email_empty_error">' . addslashes(get_option("rs_error_message_paypal_email_empty")) . '</div>';
                                echo '<div class = "error" for = "rs_encash_paypal_address" id ="paypal_email_format_error">' . addslashes(get_option("rs_error_message_paypal_email_wrong")) . '</div>';





                                if (get_option('rs_select_payment_method') == '3' && get_option('rs_allow_admin_to_save_previous_payment_method') == 'yes' && get_user_meta(get_current_user_id(), 'rs_custom_payment_details', true) != '') {
                                    echo '<div class ="rs_encash_custom_payment_option_value"><p><label><b>' . addslashes(get_option("rs_encashing_payment_custom_label")) . '</b></label></p><p><textarea name ="rs_encash_custom_payment_option_value" id="rs_encash_custom_payment_option_value" rows= "3" cols= "50">' . get_user_meta(get_current_user_id(), 'rs_custom_payment_details', true) . ' </textarea></p></div>';
                                } else {
                                    echo '<div class ="rs_encash_custom_payment_option_value"><p><label><b>' . addslashes(get_option("rs_encashing_payment_custom_label")) . '</b></label></p><p><textarea name ="rs_encash_custom_payment_option_value" id="rs_encash_custom_payment_option_value" rows= "3" cols= "50"></textarea></p></div>';
                                }




                                echo '<div class = "error" for = "rs_encash_custom_payment_option_value" id ="paypal_custom_option_empty_error">' . addslashes(get_option("rs_error_custom_payment_field_empty")) . '</div>';
                                echo '<div class ="rs_encash_submit"><input type = "submit" name= "rs_encash_submit_button" value="' . addslashes(get_option("rs_encashing_submit_button_label")) . '" id="rs_encash_submit_button"></div>';
                                echo '<div class = "success_info" for = "rs_encash_submit_button" id ="encash_form_success_info"><b>' . addslashes(get_option("rs_message_encashing_request_submitted")) . '</b></div>';
                                echo '</form>';
                                $getcontent = ob_get_clean();
                                return $getcontent;
                            } else {
                                echo get_option("rs_message_for_banned_users_encashing");
                            }
                        } else {
                            echo get_option("rs_message_users_nopoints_encashing");
                        }
                    } else {
                        ?>
                        <p><?php ob_start(); ?> <a href="<?php echo wp_login_url(); ?>" title="__('Login', 'rewardsystem')"><?php echo get_option("rs_encashing_login_link_label"); ?></a>
                            <?php
                            $message_for_guest = get_option("rs_message_for_guest_encashing");
                            $guest_encash_string_to_find = "[rssitelogin]";
                            $guest_encash_string_to_replace = ob_get_clean();
                            $guest_encash_replaced_content = str_replace($guest_encash_string_to_find, $guest_encash_string_to_replace, $message_for_guest);
                            echo $guest_encash_replaced_content;
                        }
                    }
                } else {
                    $myaccountlink = get_permalink(get_option('woocommerce_myaccount_page_id'));
                    $myaccounttitle = get_the_title(get_option('woocommerce_myaccount_page_id'));
                    $linkforlogin = add_query_arg('redirect_to', get_permalink(), $myaccountlink);
                    $message = get_option('rs_message_shortcode_guest_display');
                    $login = get_option('rs_message_shortcode_login_name');
                    echo '<br>' . $message . ' <a href=' . $linkforlogin . '> ' . $login . '</a>';
                }
            }

            public static function rs_display_cashback_form() {
                $userids = array();
                if (is_user_logged_in()) {
                    $current_user_id = get_current_user_id();
                    $current_user_role = wp_get_current_user();
                    $user_role = $current_user_role->roles[0];
                } else {
                    $current_user_id = '';
                    $user_role = '';
                }

                $accessible_for = get_option('rs_user_selection_type_for_cashback');
                if ($accessible_for == '1') {
                    return true;
                } elseif ($accessible_for == '2') {
                    $inc_user = get_option('rs_select_inc_user_search');
                    if ($inc_user != "") {
                        if (!is_array($inc_user)) {
                            $userids = array_filter(array_map('absint', (array) explode(',', $inc_user)));
                        } else {
                            $userids = $inc_user;
                        }
                        if (in_array($current_user_id, $userids)) {
                            return true;
                        }
                    } else {
                        return true;
                    }
                } elseif ($accessible_for == '3') {
                    $exc_user = get_option('rs_select_exc_user_search');
                    if ($exc_user != "") {
                        if (!is_array($exc_user)) {
                            $userids = array_filter(array_map('absint', (array) explode(',', $exc_user)));
                        } else {
                            $userids = $exc_user;
                        }
                        if (!in_array($current_user_id, $userids)) {
                            return true;
                        }
                    } else {
                        return true;
                    }
                } elseif ($accessible_for == '4') {
                    return true;
                } elseif ($accessible_for == '5') {
                    $inc_user_role = get_option('rs_select_inc_userrole');
                    if (is_array($inc_user_role) && !empty($inc_user_role)) {
                        if (in_array($user_role, $inc_user_role)) {
                            return true;
                        }
                    } else {
                        return true;
                    }
                } else {
                    $exc_user_role = get_option('rs_select_exc_userrole');
                    if (is_array($exc_user_role) && !empty($exc_user_role)) {
                        if (!in_array($user_role, $exc_user_role)) {
                            return true;
                        }
                    } else {
                        return true;
                    }
                }
                return false;
            }

            public static function process_encashing_points_to_users() {
                global $wpdb;
                if (isset($_POST['points_to_encash']) && isset($_POST['reason_to_encash']) && isset($_POST['payment_method']) && isset($_POST['converted_value_of_points']) && isset($_POST['username_of_encash_request']) && isset($_POST['encash_default_status'])) {
                    $custom_option_details_for_encashing = '';
                    $encasher_userid = $_POST['userid_of_encash_request'];
                    $encasher_username = $_POST['username_of_encash_request'];
                    $points_to_be_encashed = $_POST['points_to_encash'];
                    $converted_value_of_encash_points = $_POST['converted_value_of_points'];
                    $current_points_for_user = $_POST['encasher_current_points'];
                    $reason_for_encashing = $_POST['reason_to_encash'];
                    $payment_method_for_encashing = $_POST['payment_method'];
                    $paypal_email_for_encashing = $_POST['paypal_email_id'];
                    if (isset($_POST['custom_payment_details'])) {
                        $custom_option_details_for_encashing = $_POST['custom_payment_details'];
                    }
                    if (isset($_POST['is_walletia_selected'])) {
                        $is_walletia_selected = $_POST['is_walletia_selected'];
                        $custom_option_details_for_encashing = $is_walletia_selected;
                    } else {
                        $custom_option_details_for_encashing = $payment_method_for_encashing;
                    }
//Send mail for admin- cashback
                    $Email_notification_message = '' ;
                    $Email_subject              = '' ;
                    if ( get_option( 'rs_email_notification_for_Admin_cashback' ) == 'yes' ) {
                        $Email_subject   = get_option( 'rs_email_subject_message_for_cashback' ) ;
                        $Message         = get_option( 'rs_email_message_for_cashback' ) ;
                        $replace_message = str_replace( '[username]' , $encasher_username , str_replace( '[_rs_point_for_cashback]' , $points_to_be_encashed , $Message ) ) ;
                        if ( $custom_option_details_for_encashing == "encash_through_paypal_method" ) {
                            $custom_option_details_for_encashing = "Paypal_payment" ;
                            $Email_message                       = str_replace( '[rs_payment_gateway]' , $custom_option_details_for_encashing , str_replace( '[rs_current_user_point]' , $current_points_for_user , $replace_message ) ) ;
                            $Email_notification_message          = str_replace( '[payment_details]' , $paypal_email_for_encashing , $Email_message ) ;
                        } else if ( $payment_method_for_encashing == "encash_through_custom_payment" ) {
                            $payment_method_for_encashing = "Custom_payment" ;
                            $Email_message                = str_replace( '[rs_payment_gateway]' , $payment_method_for_encashing , str_replace( '[rs_current_user_point]' , $current_points_for_user , $replace_message ) ) ;
                            $Email_notification_message   = str_replace( '[payment_details]' , $custom_option_details_for_encashing , $Email_message ) ;
                        } else {
                            $custom_option_details_for_encashing = "wallet_payment" ;
                            $Email_notification_message          = str_replace( '[rs_payment_gateway]' , $custom_option_details_for_encashing , str_replace( '[rs_current_user_point]' , $current_points_for_user , $replace_message ) ) ;
                        }
                        self::rs_send_mail_for_admin_cashback( $Email_subject , $Email_notification_message ) ;
                    }
                    $table_name = $wpdb->prefix . "sumo_reward_encashing_submitted_data";
                    $user_id = get_current_user_id();
                    update_user_meta($user_id, 'rs_cashback_previous_payment_method', $custom_option_details_for_encashing);
                    update_user_meta($user_id, 'rs_paypal_payment_details', $paypal_email_for_encashing);
                    update_user_meta($user_id, 'rs_custom_payment_details', $_POST['custom_payment_details']);
                    $date = rs_function_to_get_expiry_date_in_unixtimestamp();
                    $default_status_of_encash_request = $_POST['encash_default_status'];
                    $wpdb->insert($table_name, array('userid' => $encasher_userid, 'userloginname' => $encasher_username, 'pointstoencash' => $points_to_be_encashed, 'encashercurrentpoints' => $current_points_for_user, 'reasonforencash' => $reason_for_encashing, 'encashpaymentmethod' => $payment_method_for_encashing, 'paypalemailid' => $paypal_email_for_encashing, 'otherpaymentdetails' => $_POST['custom_payment_details'], 'status' => $default_status_of_encash_request, 'pointsconvertedvalue' => $converted_value_of_encash_points, 'date' => date('Y-m-d H:i:s')));
                    $redeempoints = RSPointExpiry::perform_calculation_with_expiry($points_to_be_encashed, $user_id);
                    $totalpoints = RSPointExpiry::total_available_points_in_site($user_id);
                    $equredeemamt = RSPointExpiry::redeeming_conversion_settings($redeempoints);
                    RSPointExpiry::record_the_points($user_id, '0', $points_to_be_encashed, $date, 'CBRP', '0', $equredeemamt, '0', '0', '0', '0', '', $totalpoints, '', '0');
                    echo "success";
                }
                exit() ;
            }

            public static function rs_send_mail_for_admin_cashback( $Email_subject , $Email_notification_message ) {
                $admin_email = '' ;
                $admin_name  = '' ;
                global $woocommerce ;
                if ( get_option( 'rs_mail_sender_for_admin_for_cashback' ) == 'woocommerce' ) {
                    $admin_email = get_option( 'admin_email' ) ;
                    $admin_name  = get_bloginfo( 'name' , 'display' ) ;
                } else {
                    $admin_email = get_option( 'rs_from_email_for_sendpoints_for_admin_cashback' ) ;
                    $admin_name  = get_option( 'rs_from_name_for_sendpoints_for_admin_cashback' ) ;
                }
                if ( $admin_name != '' && $admin_email != '' ) {
                    $headers .= "MIME-Version: 1.0\r\n" ;
                    $headers .= "Content-Type: text/html; charset=UTF-8\r\n" ;
                    $headers .= "Reply-To: " . $admin_name . " <" . $admin_email . ">\r\n" ;

                    $Email_message_for_Admin = do_shortcode( $Email_notification_message ) ;
                    ob_start() ;
                    wc_get_template( 'emails/email-header.php' , array ( 'email_heading' => $Email_subject ) ) ;
                    echo $Email_message_for_Admin ;
                    wc_get_template( 'emails/email-footer.php' ) ;
                    $woo_temp_msg            = ob_get_clean() ;
                    if ( ( float ) $woocommerce->version <= ( float ) ('2.2.0') ) {
                        if ( wp_mail( $admin_email , $Email_subject , $Email_message_for_Admin , $headers ) ) {
                            
                        }
                    } else {
                        $mailer = WC()->mailer() ;
                        $mailer->send( $admin_email , $Email_subject , $woo_temp_msg , $headers ) ;
                    }
                }
            }

        }

        RSFunctionForFormForCashBack::init();
    }