<?php
if ( ! defined( 'ABSPATH' ) ) {
    exit ; // Exit if accessed directly.
}

if ( ! class_exists( 'RSFunctionForCart' ) ) {

    class RSFunctionForCart {

        public static function init() {

            add_action( 'woocommerce_cart_totals_before_order_total' , array( __CLASS__ , 'display_total_earned_points' ) ) ;

            add_action( 'wp_head' , array( __CLASS__ , 'show_hide_coupon_code' ) , 1 ) ;

            if ( get_option( 'rs_reward_point_troubleshoot_after_cart' ) == '1' ) {
                add_action( 'woocommerce_after_cart_table' , array( __CLASS__ , 'reward_system_add_redeem_message_after_cart_table' ) ) ;
            } else {
                add_action( 'woocommerce_cart_coupon' , array( __CLASS__ , 'reward_system_add_redeem_message_after_cart_table' ) ) ;
            }

            if ( get_option( 'rs_reward_point_troubleshoot_before_cart' ) == '1' ) {
                if ( get_option( 'rs_message_before_after_cart_table' ) == '1' ) {
                    add_action( 'woocommerce_before_cart' , array( __CLASS__ , 'get_reward_points_to_display_msg_in_cart_and_checkout' ) ) ;
                } else {
                    add_action( 'woocommerce_after_cart_table' , array( __CLASS__ , 'get_reward_points_to_display_msg_in_cart_and_checkout' ) ) ;
                }
            } else {
                if ( get_option( 'rs_message_before_after_cart_table' ) == '1' ) {
                    add_action( 'woocommerce_before_cart_table' , array( __CLASS__ , 'get_reward_points_to_display_msg_in_cart_and_checkout' ) ) ;
                } else {
                    add_action( 'woocommerce_after_cart_table' , array( __CLASS__ , 'get_reward_points_to_display_msg_in_cart_and_checkout' ) ) ;
                }
            }
            add_action( 'woocommerce_before_checkout_form' , array( __CLASS__ , 'get_reward_points_to_display_msg_in_cart_and_checkout' ) ) ;

            if ( get_option( 'rs_reward_point_troubleshoot_before_cart' ) == '1' ) {
                if ( get_option( 'rs_message_before_after_cart_table' ) == '1' ) {
                    add_action( 'woocommerce_before_cart' , array( __CLASS__ , 'display_msg_in_cart_page' ) ) ;
                } else {
                    add_action( 'woocommerce_after_cart_table' , array( __CLASS__ , 'display_msg_in_cart_page' ) ) ;
                }
            } else {
                if ( get_option( 'rs_message_before_after_cart_table' ) == '1' ) {
                    add_action( 'woocommerce_before_cart_table' , array( __CLASS__ , 'display_msg_in_cart_page' ) ) ;
                } else {
                    add_action( 'woocommerce_after_cart_table' , array( __CLASS__ , 'display_msg_in_cart_page' ) ) ;
                }
            }
            add_action( 'woocommerce_before_checkout_form' , array( __CLASS__ , 'display_msg_in_checkout_page' ) ) ;

            add_shortcode( 'rs_list_of_orders_with_pending_points' , array( __CLASS__ , 'rs_list_orders_with_pending_points' ) ) ;

            if ( get_option( 'rs_reward_point_troubleshoot_before_cart' ) == '1' ) {
                if ( get_option( 'rs_message_before_after_cart_table' ) == '1' ) {
                    add_action( 'woocommerce_before_cart' , array( __CLASS__ , 'display_msg_in_cart_page_for_balance_reward_points' ) ) ;
                } else {
                    add_action( 'woocommerce_after_cart_table' , array( __CLASS__ , 'display_msg_in_cart_page_for_balance_reward_points' ) ) ;
                }
            } else {
                if ( get_option( 'rs_message_before_after_cart_table' ) == '1' ) {
                    add_action( 'woocommerce_before_cart_table' , array( __CLASS__ , 'display_msg_in_cart_page_for_balance_reward_points' ) ) ;
                } else {
                    add_action( 'woocommerce_after_cart_table' , array( __CLASS__ , 'display_msg_in_cart_page_for_balance_reward_points' ) ) ;
                }
            }
            add_action( 'woocommerce_before_checkout_form' , array( __CLASS__ , 'display_msg_in_checkout_page_for_balance_reward_points' ) ) ;

            add_shortcode( 'redeempoints' , array( __CLASS__ , 'get_redeem_point_to_display_in_msg' ) ) ;

            add_shortcode( 'rspoint' , array( __CLASS__ , 'get_each_product_price_in_cart' ) ) ;

            add_shortcode( 'buypoint' , array( __CLASS__ , 'get_each_buy_point_in_cart' ) ) ;

            add_shortcode( 'referralpoints' , array( __CLASS__ , 'get_each_referral_point_in_cart' ) ) ;

            add_shortcode( 'rs_referral_payment_plan' , array( __CLASS__ , 'get_each_referral_point_for_payment_plan_in_cart' ) ) ;

            add_shortcode( 'titleofproduct' , array( __CLASS__ , 'get_each_producttitle_in_cart' ) ) ;

            add_shortcode( 'carteachvalue' , array( __CLASS__ , 'get_each_product_points_value_in_cart' ) ) ;

            add_shortcode( 'redeemeduserpoints' , array( __CLASS__ , 'get_balance_redeem_points_to_display_in_msg' ) ) ;

            if ( get_option( 'rs_message_before_after_cart_table' ) == '1' ) {
                add_action( 'woocommerce_before_cart' , array( __CLASS__ , 'display_button_type_redeem_on_cart_page' ) ) ;
            } else {
                add_action( 'woocommerce_after_cart_table' , array( __CLASS__ , 'display_button_type_redeem_on_cart_page' ) ) ;
            }

            add_shortcode( 'rsminimumpoints' , array( __CLASS__ , 'get_minimum_redeeming_points_value' ) ) ;

            add_shortcode( 'rsmaximumpoints' , array( __CLASS__ , 'get_maximum_redeeming_points_value' ) ) ;

            add_shortcode( 'rsequalpoints' , array( __CLASS__ , 'get_minimum_and_maximum_redeeming_points_value' ) ) ;

            add_shortcode( 'rs_user_name' , array( __CLASS__ , 'get_current_user_name' ) ) ;

            add_filter( 'woocommerce_cart_totals_coupon_label' , array( __CLASS__ , 'change_coupon_label' ) , 1 , 2 ) ;

            add_filter( 'woocommerce_add_to_cart_validation' , array( __CLASS__ , 'sell_individually_functionality' ) , 9 , 5 ) ;

            add_filter( 'vartable_add_to_cart_validation' , array( __CLASS__ , 'sell_individually_functionality' ) , 10 , 5 ) ; //compatability with woo-variations-table plugin

            add_filter( 'woocommerce_cart_item_price' , array( __CLASS__ , 'display_point_price_for_product_in_cart_item_price' ) , 999 , 3 ) ;

            add_filter( 'woocommerce_cart_item_subtotal' , array( __CLASS__ , 'display_point_price_for_product_in_cart_item_total' ) , 10 , 3 ) ;

            add_filter( 'woocommerce_cart_total' , array( __CLASS__ , 'display_point_price_in_cart_total' ) ) ;

            add_action( 'woocommerce_add_to_cart' , array( __CLASS__ , 'set_point_price_for_products_in_session' ) , 1 , 5 ) ;

            add_action( 'woocommerce_checkout_update_order_meta' , array( __CLASS__ , 'save_point_price_info_in_order' ) ) ;

            add_action( 'woocommerce_checkout_update_order_meta' , array( __CLASS__ , 'remove_session' ) ) ;

            add_action( 'woocommerce_removed_coupon' , array( __CLASS__ , 'unset_session' ) ) ;

            add_action( 'wp_head' , array( __CLASS__ , 'rs_apply_coupon_automatically' ) , 10 ) ;

            add_action( 'woocommerce_checkout_update_order_meta' , array( __CLASS__ , 'save_points_info_in_order' ) , 10 , 2 ) ;

            add_filter( 'woocommerce_is_purchasable' , array( __CLASS__ , 'is_purchasable_product' ) , 10 , 2 ) ;

            add_filter( 'woocommerce_get_variation_price_html' , array( __CLASS__ , 'check_variation_points' ) , 10 , 2 ) ;

            add_filter( 'woocommerce_show_variation_price' , array( __CLASS__ , 'change_variation_point_price_display' ) , 10 , 3 ) ;

            add_filter( 'woocommerce_variable_free_price_html' , array( __CLASS__ , 'hide_free_product_msg' ) , 10 , 3 ) ;

            add_filter( 'woocommerce_calculated_total' , array( __CLASS__ , 'alter_free_product_price' ) , 10 , 2 ) ;

            add_filter( 'woocommerce_cart_subtotal' , array( __CLASS__ , 'display_cart_subtotal' ) , 10 , 3 ) ;

            add_filter( 'woocommerce_checkout_coupon_message' , array( __CLASS__ , 'hide_coupon' ) , 1 ) ;

            add_action( 'woocommerce_before_add_to_cart_button' , array( __CLASS__ , 'point_price_booking_alter_prie' ) , 10 ) ;

            add_action( 'save_post' , array( __CLASS__ , 'save_meta_boxes' ) , 1 , 2 ) ;

            add_filter( 'woocommerce_cart_item_removed_title' , array( __CLASS__ , 'update_cart_coupon' ) , 10 , 2 ) ;

            add_filter( 'woocommerce_update_cart_action_cart_updated' , array( __CLASS__ , 'update_coupon_in_cart' ) , 10 , 1 ) ;

            add_action( 'bbp_new_topic_post_extras' , array( __CLASS__ , 'award_points_for_bbpress' ) , 10 , 1 ) ;

            add_action( 'bbp_new_reply_post_extras' , array( __CLASS__ , 'award_points_for_bbpress' ) , 10 , 1 ) ;

            add_action( 'woocommerce_after_cart_totals' , array( __CLASS__ , 'hide_coupon_and_redeem' ) ) ;

            add_action( 'woocommerce_after_checkout_form' , array( __CLASS__ , 'hide_redeem_field_checkout' ) , 10 , 1 ) ;

            add_action( 'woocommerce_removed_coupon' , array( __CLASS__ , 'display_message_in_cart' ) , 10 , 1 ) ;

            add_filter( 'woocommerce_add_message' , array( __CLASS__ , 'clear_notices' ) , 10 , 1 ) ;

            if ( get_option( 'rs_reward_point_troubleshoot_before_cart' ) == '1' ) {
                if ( get_option( 'rs_message_before_after_cart_table' ) == '1' ) {
                    add_action( 'woocommerce_before_cart' , array( __CLASS__ , 'display_complete_message_cart_page' ) ) ;
                    add_action( 'woocommerce_before_cart' , array( __CLASS__ , 'display_msg_for_cart_total_based_points_in_cart' ) ) ;
                } else {
                    add_action( 'woocommerce_after_cart_table' , array( __CLASS__ , 'display_complete_message_cart_page' ) ) ;
                    add_action( 'woocommerce_after_cart_table' , array( __CLASS__ , 'display_msg_for_cart_total_based_points_in_cart' ) ) ;
                }
            } else {
                if ( get_option( 'rs_message_before_after_cart_table' ) == '1' ) {
                    add_action( 'woocommerce_before_cart_table' , array( __CLASS__ , 'display_complete_message_cart_page' ) ) ;
                    add_action( 'woocommerce_before_cart_table' , array( __CLASS__ , 'display_msg_for_cart_total_based_points_in_cart' ) ) ;
                } else {
                    add_action( 'woocommerce_after_cart_table' , array( __CLASS__ , 'display_complete_message_cart_page' ) ) ;
                    add_action( 'woocommerce_after_cart_table' , array( __CLASS__ , 'display_msg_for_cart_total_based_points_in_cart' ) ) ;
                }
            }
            add_action( 'woocommerce_before_customer_login_form' , array( __CLASS__ , 'rs_msg_for_login_in_my_account_page' ) ) ;
            add_action( 'woocommerce_before_customer_login_form' , array( __CLASS__ , 'rs_msg_for_reg_in_my_account_page' ) ) ;
            add_shortcode( 'rs_list_enable_options' , array( __CLASS__ , 'shortcode_for_list_enable_option' ) ) ;
            //For newer version of Woocommerce (i.e) Version > 2.3.0;
            add_action( 'woocommerce_cart_item_removed' , array( __CLASS__ , 'rs_coupon_delete_cart_empty' ) , 10 , 2 ) ;
            //For older version of Woocommerce (i.e) Version < 2.3.0;
            add_action( 'woocommerce_before_cart_item_quantity_zero' , array( __CLASS__ , 'rs_coupon_delete_cart_empty' ) , 10 , 2 ) ;
            add_action( 'woocommerce_after_calculate_totals' , array( __CLASS__ , 'rs_check_cart_subtotal_restriction' ) , 10 , 1 ) ;
            add_action( 'woocommerce_before_cart_table' , array( __CLASS__ , 'display_minimum_maximum_redeeming_error' ) ) ;
        }

        public static function shortcode_for_list_enable_option() {
            global $wpdb ;
            $table_name = $wpdb->prefix . 'postmeta' ;
            $subdatas   = $wpdb->get_results( "SELECT meta_value FROM $table_name WHERE meta_key='_rewardsystemcheckboxvalue' AND meta_value='yes' " , ARRAY_A ) ;
            $referral   = $wpdb->get_results( "SELECT meta_value FROM $table_name WHERE meta_key='_rewardsystemreferralcheckboxvalue' AND meta_value='yes' " , ARRAY_A ) ;
            $buypoints  = $wpdb->get_results( "SELECT meta_value FROM $table_name WHERE meta_key='_rewardsystem_buying_reward_points' AND meta_value='yes' " , ARRAY_A ) ;
            $social     = $wpdb->get_results( "SELECT meta_value FROM $table_name WHERE meta_key='_socialrewardsystemcheckboxvalue' AND meta_value='yes' " , ARRAY_A ) ;

            if ( get_option( 'rs_product_purchase_activated' ) == 'yes' ) {
                if ( ! empty( $subdatas ) ) {
                    echo '<br>' . get_option( 'rs_msg_for_product_puchase' ) . '<br>' ;
                }
                if ( ! empty( $buypoints ) ) {
                    echo '<br>' . get_option( 'rs_msg_for_buing_reward_points' ) . '<br>' ;
                }
            }
            if ( get_option( 'rs_referral_activated' ) == 'yes' ) {
                if ( ! empty( $referral ) ) {
                    echo '<br>' . get_option( 'rs_msg_for_referral_system_product_purcase' ) . '<br>' ;
                    echo '<br>' . get_option( 'rs_msg_for_getting_refer_product_purchase' ) . '<br>' ;
                }
            }
            if ( get_option( 'rs_social_reward_activated' ) == 'yes' ) {
                if ( ! empty( $social ) ) {
                    echo '<br>' . get_option( 'rs_msg_for_social_promotion' ) . '<br>' ;
                }
                if ( get_option( 'rs_global_social_enable_disable_reward_post' ) == '1' ) {
                    echo '<br>' . get_option( 'rs_msg_for_social_promotion_for_post' ) . '<br>' ;
                }
            }
            if ( get_option( 'rs_reward_action_activated' ) == 'yes' ) {
                if ( get_option( '_rs_enable_signup' ) == 'yes' && get_option( 'rs_reward_signup' ) != '' ) {
                    $replace = str_replace( '[rssignuppoints]' , round_off_type( get_option( 'rs_reward_signup' ) ) , get_option( 'rs_msg_for_account_signup' ) ) ;
                    echo '<br>' . $replace . '<br>' ;
                }
                if ( get_option( 'rs_enable_product_review_points' ) == 'yes' && get_option( 'rs_reward_product_review' ) != '' ) {
                    $replace = str_replace( '[rsreviewpoints]' , round_off_type( get_option( 'rs_reward_product_review' ) ) , get_option( 'rs_msg_for_product_review' ) ) ;
                    echo '<br>' . $replace . '<br>' ;
                }
                if ( get_option( 'rs_reward_for_comment_Post' ) == 'yes' && get_option( 'rs_reward_post_review' ) != '' ) {
                    $replace = str_replace( '[rspostpoints]' , round_off_type( get_option( 'rs_reward_post_review' ) ) , get_option( 'rs_msg_for_post_review' ) ) ;
                    echo '<br>' . $replace . '<br>' ;
                }
                if ( get_option( 'rs_reward_for_Creating_Post' ) == 'yes' && get_option( 'rs_reward_post' ) != '' ) {
                    $replace = str_replace( '[rspostcreationpoints]' , round_off_type( get_option( 'rs_reward_post' ) ) , get_option( 'rs_msg_for_post_creation' ) ) ;
                    echo '<br>' . $replace . '<br>' ;
                }
                if ( get_option( 'rs_reward_for_comment_Page' ) == 'yes' && get_option( 'rs_reward_page_review' ) != '' ) {
                    $replace = str_replace( '[rspagecommentpoints]' , round_off_type( get_option( 'rs_reward_page_review' ) ) , get_option( 'rs_msg_for_page_comment' ) ) ;
                    echo '<br>' . $replace . '<br>' ;
                }
                if ( get_option( 'rs_reward_for_enable_product_create' ) == 'yes' && get_option( 'rs_reward_Product_create' ) != '' ) {
                    $replace = str_replace( '[rsproductcreatepoints]' , round_off_type( get_option( 'rs_reward_Product_create' ) ) , get_option( 'rs_msg_for_create_product' ) ) ;
                    echo '<br>' . $replace . '<br>' ;
                }
                if ( get_option( 'rs_enable_reward_points_for_login' ) == 'yes' && get_option( 'rs_enable_reward_points_for_login' ) != '' ) {
                    $replace = str_replace( '[rsloginpoints]' , round_off_type( get_option( 'rs_reward_points_for_login' ) ) , get_option( 'rs_msg_for_daily_login' ) ) ;
                    echo '<br>' . $replace . '<br>' ;
                }

                if ( get_option( 'rs_referral_reward_signup' ) != '' ) {
                    $replace = str_replace( '[rsreferralpoints]' , round_off_type( get_option( 'rs_referral_reward_signup' ) ) , get_option( 'rs_msg_for_referral_system_login' ) ) ;
                    echo '<br>' . $replace . '<br>' ;
                }
            }
        }

        public static function rs_msg_for_reg_in_my_account_page() {
            if ( ! is_account_page() )
                return ;

            if ( is_user_logged_in() )
                return ;

            if ( get_option( 'rs_reward_action_activated' ) != 'yes' )
                return ;

            if ( get_option( '_rs_enable_signup' ) != 'yes' )
                return ;

            if ( get_option( 'rs_show_hide_message_for_sign_up' ) == '2' )
                return ;

            $SignUpPoints = get_option( 'rs_reward_signup' ) ;
            if ( $SignUpPoints == '' )
                return ;

            $SignUpMessage   = get_option( 'rs_message_user_points_for_sign_up' ) ;
            $ReplacedMessage = str_replace( '[rsloginpoints]' , round_off_type( $SignUpPoints ) , $SignUpMessage ) ;
            if ( get_option( 'rs_select_account_signup_points_award' ) == '1' ) {
                ?>
                <div class="woocommerce-info">
                    <?php
                    echo $ReplacedMessage ;
                    ?>
                </div>
                <?php
            } else {
                if ( isset( $_COOKIE[ 'rsreferredusername' ] ) ) {
                    ?>
                    <div class="woocommerce-info">
                        <?php
                        echo $ReplacedMessage ;
                        ?>
                    </div>
                    <?php
                }
            }
        }

        public static function rs_msg_for_login_in_my_account_page() {
            if ( ! is_account_page() )
                return ;

            if ( is_user_logged_in() )
                return ;

            if ( get_option( 'rs_reward_action_activated' ) != 'yes' )
                return ;

            if ( get_option( 'rs_enable_reward_points_for_login' ) != 'yes' )
                return ;

            if ( get_option( 'rs_show_hide_message_for_daily_login' ) == '2' )
                return ;

            $LoginPoints = get_option( 'rs_reward_points_for_login' ) ;
            if ( $LoginPoints == '' )
                return ;

            $LoginMessage    = get_option( 'rs_message_user_points_for_daily_login' ) ;
            $ReplacedMessage = str_replace( '[rsdailyloginpoints]' , round_off_type( $LoginPoints ) , $LoginMessage ) ;
            ?>
            <div class="woocommerce-info">
                <?php
                echo $ReplacedMessage ;
                ?>
            </div>
            <?php
        }

        public static function rs_coupon_delete_cart_empty( $cart_item_key , $cart_object ) {
            $current_user_id = get_current_user_id() ;
            $oldcouponid     = RSFunctionForSavingMetaValues::rewardsystem_get_user_meta( $current_user_id , 'auto_redeemcoupon_ids' , true ) ;
            if ( WC()->cart->is_empty() ) {
                $getcouponid = RSFunctionForSavingMetaValues::rewardsystem_get_user_meta( $current_user_id , 'redeemcouponids' , true ) ;
                if ( $getcouponid != '' ) {
                    wp_trash_post( $getcouponid ) ;
                }
                $getcouponid = RSFunctionForSavingMetaValues::rewardsystem_get_user_meta( $current_user_id , 'auto_redeemcoupon_ids' , true ) ;
                if ( $getcouponid != '' ) {
                    wp_trash_post( $getcouponid ) ;
                }
            }
        }

        public static function rs_check_cart_subtotal_restriction( $cart_object ) {
            $cart_subtotal = self::rs_line_subtotal_for_redeeming_restriction() ;
            $minimun_total = get_option( 'rs_minimum_cart_total_points' ) != '' ? get_option( 'rs_minimum_cart_total_points' ) : 0 ;
            $maximum_total = get_option( 'rs_maximum_cart_total_points' ) != '' ? get_option( 'rs_maximum_cart_total_points' ) : 0 ;
            if ( $minimun_total == 0 && $maximum_total == 0 )
                return ;

            if ( $minimun_total != 0 )
                if ( $cart_subtotal < $minimun_total )
                    rs_check_sumo_points_remove( $cart_object ) ;

            if ( $maximum_total != 0 )
                if ( $cart_subtotal > $maximum_total )
                    rs_check_sumo_points_remove( $cart_object ) ;
        }

        public static function display_minimum_maximum_redeeming_error() {
            $memebershiprestrict = 'no' ;
            $arr                 = array() ;
            if ( get_option( 'rs_restrict_redeem_when_no_membership_plan' ) == 'yes' && function_exists( 'sumo_get_membership_levels' ) ) {
                $memebershiprestrict = 'yes' ;
                $arr                 = sumo_get_membership_levels() ;
                if ( ! empty( $arr ) ) {
                    $memebershiprestrict = 'no' ;
                }
            }
            if ( $memebershiprestrict == 'no' ) {
                if ( is_user_logged_in() ) {
                    if ( get_option( 'rs_redeem_field_type_option' ) == '1' && get_option( 'rs_redeeming_activated' ) == 'yes' ) {
                        global $woocommerce ;
                        $minimum_cart_total_redeem            = get_option( 'rs_minimum_cart_total_points' ) ;
                        $maximum_cart_total_redeem            = get_option( 'rs_maximum_cart_total_points' ) ;
                        $current_carttotal_amount             = self::rs_line_subtotal_for_redeeming_restriction() ;
                        $hide_message_for_point_price_product = self::rs_hide_restrict_message_for_redeeming_on_point_price() ;
                        if ( $hide_message_for_point_price_product == true ) {
                            return ;
                        }
                        if ( $minimum_cart_total_redeem != '' && $maximum_cart_total_redeem != '' ) {
                            if ( $current_carttotal_amount < $minimum_cart_total_redeem && $current_carttotal_amount > $maximum_cart_total_redeem ) {
                                if ( get_option( 'rs_show_hide_maximum_cart_total_error_message' ) == '1' ) {
                                    $userid       = get_current_user_id() ;
                                    $banning_type = FPRewardSystem::check_banning_type( $userid ) ;
                                    if ( $banning_type != 'redeemingonly' && $banning_type != 'both' ) {
                                        $max_cart_total_redeeming           = get_option( 'rs_min_cart_total_redeem_error' ) ;
                                        $max_cart_amount_to_find            = "[carttotal]" ;
                                        $max_cart_total_currency_to_find    = "[currencysymbol]" ;
                                        $max_cart_amount_to_replace         = get_option( 'rs_minimum_cart_total_points' ) ;
                                        $max_cart_total_currency_to_replace = get_woocommerce_formatted_price( round_off_type_for_currency( $max_cart_amount_to_replace ) ) ;
                                        $max_cart_total_msg1                = str_replace( $max_cart_amount_to_find , $max_cart_total_currency_to_replace , $max_cart_total_redeeming ) ;
                                        $max_cart_total_replaced            = str_replace( $max_cart_total_currency_to_find , "" , $max_cart_total_msg1 ) ;
                                        ?>
                                        <div class="woocommerce-error"><?php echo $max_cart_total_replaced ; ?></div>
                                        <?php
                                    }
                                }
                            }
                        } else if ( $minimum_cart_total_redeem != '' && $maximum_cart_total_redeem == '' ) {
                            if ( $current_carttotal_amount < $minimum_cart_total_redeem ) {
                                if ( get_option( 'rs_show_hide_minimum_cart_total_error_message' ) == '1' ) {
                                    $userid       = get_current_user_id() ;
                                    $banning_type = FPRewardSystem::check_banning_type( $userid ) ;
                                    if ( $banning_type != 'redeemingonly' && $banning_type != 'both' ) {
                                        $min_cart_total_redeeming           = get_option( 'rs_min_cart_total_redeem_error' ) ;
                                        $min_cart_amount_to_find            = "[carttotal]" ;
                                        $min_cart_total_currency_to_find    = "[currencysymbol]" ;
                                        $min_cart_amount_to_replace         = get_option( 'rs_minimum_cart_total_points' ) ;
                                        $min_cart_total_currency_to_replace = get_woocommerce_formatted_price( round_off_type_for_currency( $min_cart_amount_to_replace ) ) ;
                                        $min_cart_total_msg1                = str_replace( $min_cart_amount_to_find , $min_cart_total_currency_to_replace , $min_cart_total_redeeming ) ;
                                        $min_cart_total_replaced            = str_replace( $min_cart_total_currency_to_find , "" , $min_cart_total_msg1 ) ;
                                        ?>
                                        <div class="woocommerce-error"><?php echo $min_cart_total_replaced ; ?></div>
                                        <?php
                                    }
                                }
                            }
                        } else if ( $minimum_cart_total_redeem == '' && $maximum_cart_total_redeem != '' ) {
                            if ( $current_carttotal_amount > $maximum_cart_total_redeem ) {
                                if ( get_option( 'rs_show_hide_maximum_cart_total_error_message' ) == '1' ) {
                                    $userid       = get_current_user_id() ;
                                    $banning_type = FPRewardSystem::check_banning_type( $userid ) ;
                                    if ( $banning_type != 'redeemingonly' && $banning_type != 'both' ) {
                                        $max_cart_total_redeeming           = get_option( 'rs_max_cart_total_redeem_error' ) ;
                                        $max_cart_amount_to_find            = "[carttotal]" ;
                                        $max_cart_total_currency_to_find    = "[currencysymbol]" ;
                                        $max_cart_amount_to_replace         = get_option( 'rs_maximum_cart_total_points' ) ;
                                        $max_cart_total_currency_to_replace = get_woocommerce_formatted_price( round_off_type_for_currency( $max_cart_amount_to_replace ) ) ;
                                        $max_cart_total_msg1                = str_replace( $max_cart_amount_to_find , $max_cart_total_currency_to_replace , $max_cart_total_redeeming ) ;
                                        $max_cart_total_replaced            = str_replace( $max_cart_total_currency_to_find , "" , $max_cart_total_msg1 ) ;
                                        ?>
                                        <div class="woocommerce-error"><?php echo $max_cart_total_replaced ; ?></div>
                                        <?php
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }

        public static function display_message_in_cart( $coupon_code ) {
            $coupon = new WC_Coupon( $coupon_code ) ;
            if ( is_object( $coupon ) && $coupon->is_valid() ) {
                update_option( 'couponn' , $coupon_code ) ;
                if ( is_cart() ) {
                    if ( defined( 'WC_VERSION' ) && version_compare( WC_VERSION , '2.6.14' , '<=' ) ) {
                        RSFunctionForCart::get_reward_points_to_display_msg_in_cart_and_checkout() ;
                        RSFunctionForCart::display_complete_message_cart_page() ;
                        RSFunctionForCart::display_msg_for_cart_total_based_points_in_cart() ;
                        RSFunctionForCheckout::your_current_points_cart_page() ;
                    }
                    RSFunctionForCart::display_msg_in_cart_page() ;
                    RSFunctionForCart::display_msg_in_cart_page_for_balance_reward_points() ;
                    RSFunctionForCart::display_redeem_points_buttons_on_cart_page() ;
                }
                if ( is_checkout() ) {
                    if ( get_option( 'rs_enable_redeem_for_order' ) == 'yes' ) {
                        RSFunctionForCart::get_reward_points_to_display_msg_in_cart_and_checkout() ;
                        RSFunctionForCart::display_msg_in_cart_page() ;
                        RSFunctionForCart::display_complete_message_cart_page() ;
                        RSFunctionForCart::display_msg_for_cart_total_based_points_in_cart() ;
                        RSFunctionForCart::display_msg_in_cart_page_for_balance_reward_points() ;
                        RSFunctionForCart::display_redeem_points_buttons_on_cart_page() ;
                    }
                }
            }
        }

        public static function display_msg_for_cart_total_based_points_in_cart() {
            if ( get_option( 'rs_product_purchase_activated' ) == 'no' )
                return ;

            if ( get_option( 'rs_enable_product_category_level_for_product_purchase' ) == 'yes' )
                return ;

            if ( get_option( 'rs_award_points_for_cart_or_product_total' ) == '1' )
                return ;

            if ( get_option( 'rs_enable_cart_total_reward_points' ) == '2' )
                return ;

            if ( get_option( 'rs_enable_msg_for_cart_total_based_points' ) == '2' )
                return ;

            $OrderTotal        = WC()->cart->total ;
            $PointForCartTotal = get_reward_points_based_on_cart_total( $OrderTotal ) ;
            $PointToReturn     = round_off_type( $PointForCartTotal ) ;
            $PointToReturn     = RSMemberFunction::user_role_based_reward_points( get_current_user_id() , $PointToReturn ) ;

            if ( $PointToReturn == 0 )
                return ;

            $MsgForCartTotal         = get_option( 'rs_msg_for_cart_total_based_points' ) ;
            $MsgToDisplay            = str_replace( '[carttotalbasedrewardpoints]' , $PointToReturn , $MsgForCartTotal ) ;
            $PointValue              = $PointToReturn / wc_format_decimal( get_option( 'rs_redeem_point' ) ) ;
            $PointAmount             = RSMemberFunction::user_role_based_redeem_points( get_current_user_id() ) ;
            $EquivalentCurrencyValue = $PointValue * $PointAmount ;
            $CurrencyValue           = round_off_type_for_currency( $EquivalentCurrencyValue ) ;
            $CurrencyReplacedMsg     = str_replace( '[equalvalueforcarttotal]' , wc_price( $CurrencyValue ) , $MsgToDisplay )
            ?>
            <div class="woocommerce-info rs_msg_for_cart_total_based_points">
                <?php
                echo $CurrencyReplacedMsg ;
                ?>
            </div>
            <?php
        }

        public static function display_complete_message_cart_page() {
            if ( get_option( 'rs_product_purchase_activated' ) == 'no' )
                return ;

            if ( ! is_user_logged_in() )
                return ;

            if ( get_option( 'rs_enable_product_category_level_for_product_purchase' ) == 'no' && get_option( 'rs_award_points_for_cart_or_product_total' ) == '2' )
                return ;

            if ( get_option( 'rs_show_hide_message_for_total_points' ) == '2' )
                return ;

            $checkenableoption = RSFunctionForCart::check_the_applied_coupons() ;
            if ( $checkenableoption != false )
                return ;

            $totalrewardpoints = rs_getshortcodetotal_rewards() ;
            if ( $totalrewardpoints == 0 )
                return ;

            global $totalrewardpoints_payment_plan ;
            global $buying_pts_payment_plan ;
            $payment_plan = 0 ;
            if ( is_array( $totalrewardpoints_payment_plan ) )
                $payment_plan = round_off_type( array_sum( $totalrewardpoints_payment_plan ) ) ;

            if ( is_array( $buying_pts_payment_plan ) )
                $payment_plan = round_off_type( array_sum( $buying_pts_payment_plan ) ) ;

            if ( $payment_plan != 0 && $payment_plan != '' ) {
                if ( get_option( 'rs_show_hide_message_for_total_payment_plan_points' ) == '1' ) {
                    ?>
                    <div class="woocommerce-info sumo_reward_points_payment_plan_complete_message rs_cart_message">
                        <?php
                        echo do_shortcode( get_option( 'rs_message_payment_plan_total_price_in_cart' ) ) ;
                        ?>
                    </div>
                    <?php
                }
            } else {
                ?>
                <div class="woocommerce-info sumo_reward_points_complete_message rs_cart_message">
                    <?php
                    echo do_shortcode( get_option( 'rs_message_total_price_in_cart' ) ) ;
                    ?>
                </div>
                <?php
            }
        }

        public static function clear_notices( $message ) {
            $couponcode          = get_option( 'couponn' ) ;
            $user_ID             = get_current_user_id() ;
            $getinfousernickname = get_user_by( 'id' , $user_ID ) ;
            $couponcodeuserlogin = is_object( $getinfousernickname ) ? $getinfousernickname->user_login : 'Guest' ;
            $usernickname        = 'sumo_' . strtolower( "$couponcodeuserlogin" ) ;
            $auto                = 'auto_redeem_' . strtolower( "$couponcodeuserlogin" ) ;
            $woo_msg             = __( 'Coupon has been removed.' , 'woocommerce' ) ;
            if ( $message == $woo_msg ) {
                if ( $usernickname == $couponcode || $auto == $couponcode ) {
                    $message = __( get_option( 'rs_remove_redeem_points_message' ) , 'rewardsystem' ) ;
                }
            }
            return $message ;
        }

        public static function award_points_for_bbpress( $topic_id ) {
            if ( ! is_user_logged_in() )
                return ;

            $topic_ids   = '' ;
            $post        = get_post( $topic_id ) ;
            $post_parent = $post->post_parent ;
            $post_type   = $post->post_type ;
            $user_id     = get_current_user_id() ;
            if ( $post_type == 'topic' ) {
                $event_slug                = 'RPCT' ;
                $productlevelrewardpointss = get_option( 'rs_reward_points_for_creatic_topic' ) ;
            }
            if ( $post_type == 'reply' ) {
                $event_slug                = 'RPRT' ;
                $topic_ids                 = $post->post_parent ;
                $reply_id                  = $topic_id ;
                $productlevelrewardpointss = get_option( 'rs_reward_points_for_reply_topic' ) ;
            }
            $checktopic = RSFunctionForSavingMetaValues::rewardsystem_get_user_meta( $user_id , 'userreplytopic' . $post_parent , true ) ;
            if ( $checktopic == '1' )
                return ;

            $enabletopic = get_option( 'rs_enable_reward_points_for_create_topic' ) ;
            $enablereply = get_option( 'rs_enable_reward_points_for_reply_topic' ) ;
            if ( $enabletopic == 'yes' || $enablereply == 'yes' ) {
                if ( $productlevelrewardpointss != '' ) {
                    $new_obj                     = new RewardPointsOrder( $order_id                    = 0 , $apply_previous_order_points = 'no' ) ;
                    $restrictuserpoints          = get_option( 'rs_max_earning_points_for_user' ) ;
                    $enabledisablemaxpoints      = get_option( 'rs_enable_disable_max_earning_points_for_user' ) ;
                    if ( $enabledisablemaxpoints == 'yes' ) {
                        $new_obj->check_point_restriction( $restrictuserpoints , $productlevelrewardpointss , $pointsredeemed = 0 , $event_slug , $user_id , $nomineeid      = '' , $referrer_id    = '' , $productid      = '' , $variationid    = '' , $reasonindetail ) ;
                    } else {
                        $equearnamt     = RSPointExpiry::earning_conversion_settings( $productlevelrewardpointss ) ;
                        $valuestoinsert = array( 'pointstoinsert' => $productlevelrewardpointss , 'pointsredeemed' => 0 , 'event_slug' => $event_slug , 'equalearnamnt' => $equearnamt , 'equalredeemamnt' => 0 , 'user_id' => $user_id , 'referred_id' => '' , 'product_id' => '' , 'variation_id' => '' , 'reasonindetail' => '' , 'nominee_id' => '' , 'nominee_points' => '' , 'totalearnedpoints' => $productlevelrewardpointss , 'totalredeempoints' => 0 ) ;
                        $new_obj->total_points_management( $valuestoinsert ) ;
                    }
                    if ( $topic_ids != '' ) {
                        RSFunctionForSavingMetaValues::rewardsystem_update_user_meta( $user_id , 'userreplytopic' . $topic_ids , '1' ) ;
                    }
                }
            }
        }

        public static function hide_redeem_field_checkout( $id ) {
            global $woocommerce ;
            $user_ID             = get_current_user_id() ;
            $getinfousernickname = get_user_by( 'id' , $user_ID ) ;
            $couponcodeuserlogin = is_object( $getinfousernickname ) ? $getinfousernickname->user_login : 'Guest' ;
            $usernickname        = 'sumo_' . strtolower( "$couponcodeuserlogin" ) ;
            $array               = $woocommerce->cart->get_applied_coupons() ;
            if ( get_option( '_rs_not_allow_earn_points_if_sumo_coupon' ) == 'yes' ) {
                if ( is_array( $woocommerce->cart->get_applied_coupons() ) ) {
                    $getappliedcoupon = $woocommerce->cart->get_applied_coupons() ;
                    if ( ! empty( $getappliedcoupon ) ) {
                        foreach ( $woocommerce->cart->get_applied_coupons() as $coupons ) {
                            $coupon_id_array   = new WC_Coupon( $coupons ) ;
                            $coupon_id         = rs_get_coupon_obj( $coupon_id_array ) ;
                            $coupon_id         = $coupon_id[ 'coupon_id' ] ;
                            $check_sumo_coupon = get_post_meta( $coupon_id , 'sumo_coupon_check' , true ) ;
                            if ( $check_sumo_coupon == 'yes' ) {
                                ?>
                                <script type="text/javascript">
                                    jQuery( document ).ready( function () {
                                        jQuery( "#mainsubmi" ).parent().hide() ;
                                    } ) ;
                                </script>
                                <?php
                            }
                        }
                    }
                }
            }
            if ( in_array( $usernickname , $array ) ) {
                ?>                            
                <style type="text/css">
                    .redeeemit {
                        display:none;
                    }
                </style>                 
                <?php
            } else {
                ?>                            
                <style type="text/css">
                    .redeeemit {
                        display:block;
                    }
                </style>                 
                <?php
            }
        }

        public static function hide_coupon_and_redeem() {
            global $woocommerce ;
            $user_ID             = get_current_user_id() ;
            $getinfousernickname = get_user_by( 'id' , $user_ID ) ;
            $couponcodeuserlogin = is_object( $getinfousernickname ) ? $getinfousernickname->user_login : 'Guest' ;
            $usernickname        = 'sumo_' . strtolower( "$couponcodeuserlogin" ) ;
            $autoredeem          = 'auto_redeem_' . strtolower( "$couponcodeuserlogin" ) ;
            $array               = $woocommerce->cart->get_applied_coupons() ;
            if ( get_option( 'rs_show_hide_redeem_field' ) == '5' || get_option( 'rs_show_hide_redeem_field' ) == '1' || get_option( 'rs_show_hide_redeem_field' ) == '2' ) {
                if ( empty( $array ) ) {
                    ?>     
                    <script type="text/javascript">
                        jQuery( document ).ready( function () {
                            jQuery( "#mainsubmi" ).parent().show() ;
                        } ) ;
                    </script>

                    <?php
                }
            } elseif ( get_option( 'rs_show_hide_redeem_field' ) == '3' ) {
                ?>     
                <style type="text/css">
                    .fp_apply_reward{
                        display : none !important;
                    }
                    .coupon{
                        display : block !important;
                    }
                </style>  <?php
            }
            if ( in_array( $usernickname , $array ) || in_array( $autoredeem , $array ) ) {
                if ( get_option( 'rs_show_hide_redeem_field' ) != '1' ) {
                    echo RSFunctionForCheckout::rs_script_and_style_to_hide_coupon_field() ;
                }
            } else {
                $array = $woocommerce->cart->get_applied_coupons() ;
                if ( ! empty( $array ) ) {
                    if ( get_option( 'rs_show_hide_redeem_field' ) != '5' ) {
                        echo RSFunctionForCheckout::rs_script_and_style_to_hide_coupon_field() ;
                    }
                    if ( get_option( 'rs_show_hide_redeem_field' ) != '1' ) {
                        echo RSFunctionForCheckout::rs_style_to_hide_redeem_field_in_checkout() ;
                        echo RSFunctionForCheckout::rs_script_to_hide_redeem_field_in_cart() ;
                    }
                }
            }

            if ( get_option( 'rs_dont_allow_redeem_if_sumo_coupon' ) == 'yes' ) {
                $array = $woocommerce->cart->get_applied_coupons() ;
                if ( is_array( $woocommerce->cart->get_applied_coupons() ) ) {
                    $getappliedcoupon = $woocommerce->cart->get_applied_coupons() ;
                    if ( ! empty( $getappliedcoupon ) ) {
                        foreach ( $woocommerce->cart->get_applied_coupons() as $coupons ) {
                            $coupon_id_array = new WC_Coupon( $coupons ) ;
                            $coupon_id       = rs_get_coupon_obj( $coupon_id_array ) ;
                            $coupon_id       = $coupon_id[ 'coupon_id' ] ;
                            $getd            = get_post_meta( $coupon_id , 'sumo_coupon_check' , true ) ;
                            if ( $getd == 'yes' ) {
                                ?>
                                <script type="text/javascript">
                                    jQuery( document ).ready( function () {
                                        jQuery( "#mainsubmi" ).parent().hide() ;
                                    } ) ;
                                </script>

                                <?php
                            }
                        }
                    }
                }
            }
        }

        public static function update_coupon_in_cart( $coupon ) {
            self::update_cart_coupon( $coupon , $item = '' ) ;
            return $coupon ;
        }

        public static function update_cart_coupon( $product , $item ) {
            global $woocommerce ;
            WC()->cart->calculate_totals() ;
            foreach ( $woocommerce->cart->applied_coupons as $code ) {
                if ( get_option( 'woocommerce_prices_include_tax' ) == 'yes' ) {
                    if ( get_option( 'woocommerce_tax_display_cart' ) == 'incl' ) {
                        $get_cart_total_for_redeem = $woocommerce->cart->subtotal ;
                    } else {
                        $get_cart_total_for_redeem = $woocommerce->cart->subtotal ;
                    }
                } else {
                    if ( get_option( 'woocommerce_tax_display_cart' ) == 'incl' ) {
                        $get_cart_total_for_redeem = $woocommerce->cart->subtotal_ex_tax ;
                    } else {
                        $get_cart_total_for_redeem = $woocommerce->cart->subtotal_ex_tax ;
                    }
                }
                $coupon              = new WC_Coupon( $code ) ;
                $coupon_obj          = rs_get_coupon_obj( $coupon ) ;
                $couponamount        = $coupon_obj[ 'coupon_amount' ] ;
                $coupon_code         = $coupon_obj[ 'coupon_code' ] ;
                $coupon_id           = $coupon_obj[ 'coupon_id' ] ;
                $user_ID             = get_current_user_id() ;
                $getinfousernickname = get_user_by( 'id' , $user_ID ) ;
                $couponcodeuserlogin = is_object( $getinfousernickname ) ? $getinfousernickname->user_login : 'Guest' ;
                if ( $coupon_code == 'sumo_' . strtolower( $couponcodeuserlogin ) ) {
                    $getmaxruleoption    = get_option( 'rs_max_redeem_discount' ) ;
                    $getpercentmaxoption = get_option( 'rs_percent_max_redeem_discount' ) ;
                    if ( get_option( 'rs_apply_redeem_basedon_cart_or_product_total' ) == '1' ) {
                        if ( $getmaxruleoption == '2' ) {
                            if ( $getpercentmaxoption != '' ) {
                                $percentageproduct = $getpercentmaxoption / 100 ;
                                $getpricepercent   = $percentageproduct * $get_cart_total_for_redeem ;
                                if ( $couponamount > $getpricepercent ) {
                                    RSFunctionForSavingMetaValues::rewardsystem_update_post_meta( $coupon_id , 'coupon_amount' , $getpricepercent ) ;
                                    if ( get_option( 'rs_redeem_field_type_option' ) == '2' ) {
                                        $limitation_percentage_for_redeeming_for_button = get_option( 'rs_percentage_cart_total_redeem' ) ;
                                        if ( $limitation_percentage_for_redeeming_for_button != '' ) {
                                            $reddem_value_in_amount_percent = $limitation_percentage_for_redeeming_for_button / 100 ;
                                            $reddem_points_for_total        = $reddem_value_in_amount_percent * $get_cart_total_for_redeem ;
                                            if ( $getpricepercent > $reddem_points_for_total ) {
                                                RSFunctionForSavingMetaValues::rewardsystem_update_post_meta( $coupon_id , 'coupon_amount' , $reddem_points_for_total ) ;
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    } else {
                        $getsumofselectedproduct = RSFunctionToApplyCoupon::get_sum_of_selected_products( 'sumo' , '' , '' ) ;
                        if ( $getmaxruleoption == '2' ) {
                            if ( $getpercentmaxoption != '' ) {
                                $percentageproduct = $getpercentmaxoption / 100 ;
                                $getpricepercent   = $percentageproduct * $getsumofselectedproduct ;
                                if ( $couponamount > $getpricepercent ) {
                                    RSFunctionForSavingMetaValues::rewardsystem_update_post_meta( $coupon_id , 'coupon_amount' , $getpricepercent ) ;
                                    if ( get_option( 'rs_redeem_field_type_option' ) == '2' ) {
                                        $limitation_percentage_for_redeeming_for_button = get_option( 'rs_percentage_cart_total_redeem' ) ;
                                        if ( $limitation_percentage_for_redeeming_for_button != '' ) {
                                            $reddem_value_in_amount_percent = $limitation_percentage_for_redeeming_for_button / 100 ;
                                            $reddem_points_for_total        = $reddem_value_in_amount_percent * $getsumofselectedproduct ;
                                            if ( $getpricepercent > $reddem_points_for_total ) {
                                                RSFunctionForSavingMetaValues::rewardsystem_update_post_meta( $coupon_id , 'coupon_amount' , $reddem_points_for_total ) ;
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
            return $product ;
        }

        public static function save_meta_boxes( $post_id , $post ) {
            if ( 'product' == $post->post_type ) {
                if ( get_option( 'rs_reward_for_enable_product_create' ) == 'yes' && get_option( 'rs_reward_action_activated' ) == 'yes' ) {
                    $currentregistrationpoints = get_option( 'rs_reward_Product_create' ) ;
                    $get_option                = get_post_meta( $post->ID , 'productcretion_points' , true ) ;
                    $date                      = rs_function_to_get_expiry_date_in_unixtimestamp() ;
                    if ( $get_option != '1' ) {
                        $new_obj                     = new RewardPointsOrder( $order_id                    = 0 , $apply_previous_order_points = 'no' ) ;
                        $user_id                     = $post->post_author ;
                        $equearnamt                  = RSPointExpiry::earning_conversion_settings( $currentregistrationpoints ) ;
                        $valuestoinsert              = array( 'pointstoinsert' => $currentregistrationpoints , 'pointsredeemed' => 0 , 'event_slug' => 'RPCPRO' , 'equalearnamnt' => $equearnamt , 'equalredeemamnt' => 0 , 'user_id' => $user_id , 'referred_id' => '' , 'product_id' => $productid , 'variation_id' => '' , 'reasonindetail' => '' , 'nominee_id' => '' , 'nominee_points' => '' , 'totalearnedpoints' => $currentregistrationpoints , 'totalredeempoints' => 0 ) ;
                        $new_obj->total_points_management( $valuestoinsert ) ;
                        RSFunctionForSavingMetaValues::rewardsystem_update_post_meta( $post->ID , 'productcretion_points' , '1' ) ;
                    }
                }
            }
        }

        public static function point_price_booking_alter_prie() {
            if ( class_exists( 'WC_Bookings' ) ) {
                ?>
                <div class="wc-bookings-booking-cost1"></div> 

                <?php
            }
        }

        public static function hide_coupon( $message ) {
            $type = array() ;
            global $woocommerce ;
            foreach ( $woocommerce->cart->cart_contents as $item ) {
                $product_id = $item[ 'variation_id' ] != 0 ? $item[ 'variation_id' ] : $item[ 'product_id' ] ;
                $type[]     = check_display_price_type( $product_id ) ;
                $enable     = calculate_point_price_for_products( $product_id ) ;
                if ( $enable[ $product_id ] != '' ) {
                    $cart_object[] = $enable[ $product_id ] ;
                }
            }

            if ( in_array( 2 , $type ) ) {
                if ( get_option( 'rs_show_hide_message_errmsg_for_point_price_coupon' ) == '1' ) {
                    $message = get_option( 'rs_errmsg_for_redeem_in_point_price_prt' ) ;
                } else {
                    return "<span class='displaymessage' ></span>" ;
                }
                return $message ;
            }
            if ( ! empty( $cart_object ) ) {
                if ( get_option( 'rs_show_hide_message_errmsg_for_point_price_coupon' ) == '1' ) {
                    $message = get_option( 'rs_errmsg_for_redeem_in_point_price_prt' ) ;
                } else {
                    return "<span class='displaymessage' ></span>" ;
                }

                return $message ;
            } else {
                return $message ;
            }
        }

        public static function display_cart_subtotal( $cart_object , $compond , $product ) {
            if ( get_option( 'rs_enable_disable_point_priceing' ) == '1' && get_option( 'rs_point_price_activated' ) == 'yes' ) {
                $array = array() ;
                foreach ( $product->cart_contents as $key => $value ) {
                    $productid = $value[ 'variation_id' ] != '' ? $value[ 'variation_id' ] : $value[ 'product_id' ] ;
                    if ( check_display_price_type( $productid ) == '2' ) {
                        $enable = calculate_point_price_for_products( $productid ) ;
                        if ( $enable[ $productid ] != '' ) {
                            if ( get_option( 'rs_point_price_visibility' ) == '2' && ! is_user_logged_in() ) {
                                return $cart_object ;
                            } else {
                                $cart_object = $enable[ $productid ] * $value[ 'quantity' ] ;
                                $array[]     = $cart_object ;
                            }
                        }
                    } else {
                        return $cart_object ;
                    }
                }
                $amount  = array_sum( $array ) ;
                $label   = get_option( 'rs_label_for_point_value' ) ;
                $replace = str_replace( "/" , "" , $label ) ;
                if ( $amount != '' || $amount != '0' ) {
                    $labelposition = get_option( 'rs_sufix_prefix_point_price_label' ) ;
                    $pixel         = get_option( 'rs_pixel_val' ) ;
                    if ( $labelposition == '1' ) {
                        $totalamount = "{$replace}<span style='margin-left:{$pixel}px;'>{$amount}</span>" ;
                    } else {
                        $totalamount = "{$amount}<span style='margin-left:{$pixel}px;'>{$replace}</span>" ;
                    }
                    return $totalamount ;
                } else {
                    return $cart_object ;
                }
            } else {
                return $cart_object ;
            }
        }

        public static function alter_free_product_price( $cart_object , $product ) {
            if ( get_option( 'rs_enable_disable_point_priceing' ) == '1' && get_option( 'rs_point_price_activated' ) == 'yes' ) {
                foreach ( $product->cart_contents as $key => $value ) {
                    $productid = $value[ 'variation_id' ] != '' ? $value[ 'variation_id' ] : $value[ 'product_id' ] ;
                    if ( check_display_price_type( $productid ) == '2' ) {
                        $enable = calculate_point_price_for_products( $productid ) ;
                        if ( $enable[ $productid ] != '' ) {
                            if ( get_option( 'rs_point_price_visibility' ) == '2' && ! is_user_logged_in() ) {
                                return $cart_object ;
                            } else {
                                $cart_object = '1' ;
                            }
                        }
                    }
                }
                return $cart_object ;
            } else {
                return $cart_object ;
            }
        }

        public static function is_purchasable_product( $purchaseable , $product ) {
            $id = rs_get_id( $product ) ;
            if ( get_option( 'rs_enable_disable_point_priceing' ) == '1' && get_option( 'rs_point_price_activated' ) == 'yes' ) {
                if ( check_display_price_type( $id ) == '2' ) {
                    $enable = calculate_point_price_for_products( $id ) ;
                    if ( $enable[ $id ] != '' ) {
                        $purchaseable = true ;
                        return $purchaseable ;
                    } else {
                        return $purchaseable ;
                    }
                } else {
                    return $purchaseable ;
                }
            } else {
                return $purchaseable ;
            }
        }

        public static function check_variation_points( $product , $id ) {
            if ( get_option( 'rs_enable_disable_point_priceing' ) == '1' && get_option( 'rs_point_price_activated' ) == 'yes' ) {
                $var_id = rs_get_id( $id ) ;
                if ( check_display_price_type( $var_id ) == '2' ) {
                    $label   = get_option( 'rs_label_for_point_value' ) ;
                    $replace = str_replace( "/" , "" , $label ) ;
                    $enable  = calculate_point_price_for_products( $var_id ) ;
                    if ( $enable[ $var_id ] != '' ) {
                        $product       = $enable[ $var_id ] ;
                        $labelposition = get_option( 'rs_sufix_prefix_point_price_label' ) ;
                        $pixel         = get_option( 'rs_pixel_val' ) ;
                        if ( $labelposition == '1' ) {
                            $totalamount = "{$replace}<span style='margin-left:{$pixel}px;'>{$product}</span>" ;
                        } else {
                            $totalamount = "{$product}<span style='margin-left:{$pixel}px;'>{$replace}</span>" ;
                        }
                        return $totalamount ;
                    } else {
                        return $product ;
                    }
                } else {
                    return $product ;
                }
            } else {
                return $product ;
            }
        }

        public static function change_variation_point_price_display( $product , $obj , $id ) {
            if ( get_option( 'rs_enable_disable_point_priceing' ) == '1' && get_option( 'rs_point_price_activated' ) == 'yes' ) {
                $var_id = rs_get_id( $id ) ;
                if ( check_display_price_type( $var_id ) == '2' ) {
                    $enable = calculate_point_price_for_products( $var_id ) ;
                    if ( $enable[ $var_id ] != '' ) {
                        $product = true ;
                        return $product ;
                    } else {
                        return $product ;
                    }
                } else {
                    return $product ;
                }
            } else {
                return $product ;
            }
        }

        public static function hide_free_product_msg( $product , $obj ) {
            if ( get_option( 'rs_enable_disable_point_priceing' ) == '1' && get_option( 'rs_point_price_activated' ) == 'yes' ) {
                $product = '' ;
                return $product ;
            } else {
                return $product ;
            }
        }

        public static function save_points_info_in_order( $order_id , $orderuserid ) {
            if ( get_option( 'rs_product_purchase_activated' ) != 'yes' )
                return ;

            $Order                  = new WC_Order( $order_id ) ;
            $points_info            = array() ;
            $RewardPointsBasedOn    = get_option( 'rs_award_points_for_cart_or_product_total' ) ;
            $OrderTotal             = $Order->get_total() ;
            $PointsBasedonCartTotal = get_reward_points_based_on_cart_total( $OrderTotal ) ;
            if ( get_option( 'rs_enable_disable_reward_point_based_coupon_amount' ) == 'yes' ) {
                if ( $RewardPointsBasedOn == '1' ) {
                    $points_info = self::moified_points_for_products_in_cart() ;
                    update_post_meta( $order_id , 'points_for_current_order' , $points_info ) ;
                    if ( ! empty( $points_info ) ) {
                        $points_for_current_order_in_value = array_sum( $points_info ) ;
                        update_post_meta( $order_id , 'rs_points_for_current_order_as_value' , $points_for_current_order_in_value ) ;
                    }
                } else {
                    if ( $PointsBasedonCartTotal != 0 )
                        update_post_meta( $order_id , 'points_for_current_order_based_on_cart_total' , $PointsBasedonCartTotal ) ;
                }
                update_post_meta( $order_id , 'frontendorder' , 1 ) ;
            } else {
                if ( $RewardPointsBasedOn == '1' ) {
                    $points_info = self::original_points_for_product_in_cart() ;
                    update_post_meta( $order_id , 'points_for_current_order' , $points_info ) ;
                    if ( ! empty( $points_info ) ) {
                        $points_for_current_order_in_value = array_sum( $points_info ) ;
                        update_post_meta( $order_id , 'rs_points_for_current_order_as_value' , $points_for_current_order_in_value ) ;
                    }
                } else {
                    if ( $PointsBasedonCartTotal != 0 )
                        update_post_meta( $order_id , 'points_for_current_order_based_on_cart_total' , $PointsBasedonCartTotal ) ;
                }
                update_post_meta( $order_id , 'frontendorder' , 1 ) ;
            }
        }

        public static function moified_points_for_products_in_cart() {
            global $woocommerce ;
            $modified_points_updated = array() ;
            $original_points_array   = self::original_points_for_product_in_cart() ;
            if ( is_array( $original_points_array ) && ! empty( $original_points_array ) ) {
                foreach ( $original_points_array as $product_id => $points ) {
                    $modified_points = self::coupon_points_conversion( $product_id , $points ) ;
                    if ( $modified_points != 0 ) {
                        $modified_points_updated[ $product_id ] = $modified_points ;
                    }
                }
            }
            return $modified_points_updated ;
        }

        public static function coupon_included_products( $product_ids , $coupon_code ) {
            global $woocommerce ;
            $coupon_product_ids = array() ;
            foreach ( $woocommerce->cart->cart_contents as $cart_details ) {
                $product_id = $cart_details[ 'variation_id' ] != '' ? $cart_details[ 'variation_id' ] : $cart_details[ 'product_id' ] ;
                if ( in_array( $product_id , $product_ids ) ) {
                    $coupon_product_ids[] = $cart_details[ 'line_subtotal' ] ;
                }
            }
            $coupon_product_ids = array_sum( $coupon_product_ids ) ;

            return $coupon_product_ids ;
        }

        public static function coupon_validator( $product_id , $points ) {
            global $woocommerce ;
            $selected_products   = array() ;
            $discount_coupon     = $woocommerce->cart->coupon_discount_amounts ;
            $newdiscount_amounts = $woocommerce->cart->coupon_discount_amounts ;
            if ( $newdiscount_amounts ) {
                $discountss = array_sum( array_values( $newdiscount_amounts ) ) ;
                $c_amount   = $discountss ;
            }

            foreach ( $woocommerce->cart->applied_coupons as $code ) {
                $coupon              = new WC_Coupon( $code ) ;
                $coupon_obj          = rs_get_coupon_obj( $coupon ) ;
                $selectedproduct     = $coupon_obj[ 'product_ids' ] ;
                $coupon_code         = $coupon_obj[ 'coupon_code' ] ;
                $coupon_amount       = $coupon_obj[ 'coupon_amount' ] ;
                $selectedcategories  = $coupon_obj[ 'product_categories' ] ;
                $discount_type       = $coupon_obj[ 'discount_type' ] ;
                $user_ID             = get_current_user_id() ;
                $getinfousernickname = get_user_by( 'id' , $user_ID ) ;
                $couponcodeuserlogin = is_object( $getinfousernickname ) ? $getinfousernickname->user_login : 'Guest' ;
                if ( $coupon_code == 'sumo_' . strtolower( $couponcodeuserlogin ) ) {
                    if ( $discount_type == 'fixed_cart' ) {
                        $selectedproduct = $coupon_obj[ 'product_ids' ] ;
                        if ( ! empty( $selectedproduct ) ) {
                            if ( in_array( $product_id , $selectedproduct ) ) {
                                $coupon_product_ids[ "$code" ][]             = $product_id ;
                                $count_of_products                           = 1 ;
                                $selected_products[ "$code" ][ $product_id ] = $count_of_products > 1 ? $discount_coupon[ "$code" ] / $count_of_products : $discount_coupon[ "$code" ] ;
                            }
                        } else {
                            $coupon_product_ids[ "$code" ][]             = $product_id ;
                            $count_of_products                           = 1 ;
                            $selected_products[ "$code" ][ $product_id ] = $c_amount ;
                        }
                    }
                } else {
                    if ( $discount_type == 'fixed_cart' ) {
                        if ( ! empty( $selectedproduct ) ) {
                            if ( in_array( $product_id , $selectedproduct ) ) {
                                $coupon_product_ids[ "$code" ][]             = $product_id ;
                                $count_of_products                           = 1 ;
                                $selected_products[ "$code" ][ $product_id ] = $count_of_products > 1 ? $discount_coupon[ "$code" ] / $count_of_products : $discount_coupon[ "$code" ] ;
                            }
                        } else {
                            $coupon_product_ids[ "$code" ][]             = $product_id ;
                            $count_of_products                           = 1 ;
                            $selected_products[ "$code" ][ $product_id ] = $c_amount ;
                        }
                    } else if ( $discount_type == 'percent_product' ) {
                        if ( ! empty( $selectedproduct ) ) {
                            if ( in_array( $product_id , $selectedproduct ) ) {
                                $coupon_product_ids[ "$code" ][]             = $product_id ;
                                $count_of_products                           = 1 ;
                                $selected_products[ "$code" ][ $product_id ] = $count_of_products > 1 ? $discount_coupon[ "$code" ] / $count_of_products : $discount_coupon[ "$code" ] ;
                            }
                        } else {
                            $coupon_product_ids[ "$code" ][] = $product_id ;
                            $count_of_products               = 1 ;

                            $selected_products[ "$code" ][ $product_id ] = $c_amount ;
                        }
                    } else if ( $discount_type == 'fixed_product' ) {
                        if ( ! empty( $selectedproduct ) ) {
                            if ( in_array( $product_id , $selectedproduct ) ) {
                                $coupon_product_ids[ "$code" ][]             = $product_id ;
                                $count_of_products                           = 1 ;
                                $selected_products[ "$code" ][ $product_id ] = $count_of_products > 1 ? $discount_coupon[ "$code" ] / $count_of_products : $discount_coupon[ "$code" ] ;
                            }
                        } else {
                            $coupon_product_ids[ "$code" ][] = $product_id ;
                            $count_of_products               = 1 ;

                            $selected_products[ "$code" ][ $product_id ] = $c_amount ;
                        }
                    } else if ( $discount_type = 'percent' ) {
                        if ( ! empty( $selectedproduct ) ) {
                            if ( in_array( $product_id , $selectedproduct ) ) {
                                $coupon_product_ids[ "$code" ][] = $product_id ;
                                $count_of_products               = 1 ;

                                $selected_products[ "$code" ][ $product_id ] = $count_of_products > 1 ? $discount_coupon[ "$code" ] / $count_of_products : $discount_coupon[ "$code" ] ;
                            }
                        } else {
                            $coupon_product_ids[ "$code" ][] = $product_id ;
                            $count_of_products               = 1 ;

                            $selected_products[ "$code" ][ $product_id ] = $c_amount ;
                        }
                    }
                }
            }

            return $selected_products ;
        }

        public static function get_product_price_in_cart() {
            $price = array() ;
            foreach ( WC()->cart->cart_contents as $key => $value ) {
                $checklevel        = 'no' ;
                $points            = check_level_of_enable_reward_point( $value[ 'product_id' ] , $value[ 'variation_id' ] , $value , $checklevel , $referred_user     = '' , $getting_referrer  = 'no' , $socialreward      = 'no' , $rewardfor         = '' , $payment_price     = 0 ) ;
                update_post_meta( $value[ 'product_id' ] , 'linetotal1' , $value[ 'line_subtotal' ] ) ;
                $totalrewardpoints = RSMemberFunction::user_role_based_reward_points( get_current_user_id() , $points ) ;
                if ( $totalrewardpoints == 0 )
                    continue ;

                $price[] = $value[ 'line_subtotal' ] ;
            }
            $totalprice = array_sum( $price ) ;
            return $totalprice ;
        }

        public static function coupon_points_conversion( $product_id , $points ) {
            global $woocommerce ;
            $coupon_amounts = self::coupon_validator( $product_id , $points ) ;
            $newpoints      = $points ;
            $conversions    = array() ;
            if ( ! empty( $coupon_amounts ) && is_array( $coupon_amounts ) ) {
                foreach ( $coupon_amounts as $key1 => $value ) {
                    
                }
                if ( $newpoints > 0 ) {
                    $c_amount1           = $value[ $product_id ] ;
                    $newdiscount_amounts = $woocommerce->cart->coupon_discount_amounts ;
                    if ( $newdiscount_amounts ) {
                        $discountss = array_sum( array_values( $newdiscount_amounts ) ) ;
                        $c_amount   = $discountss ;
                    }
                    foreach ( $woocommerce->cart->applied_coupons as $key1 ) {
                        $coupon          = new WC_Coupon( $key1 ) ;
                        $coupon_obj      = rs_get_coupon_obj( $coupon ) ;
                        $selectedproduct = $coupon_obj[ 'product_ids' ] ;
                        $rp              = self::coupon_included_products( $selectedproduct , $coupon_obj[ 'coupon_code' ] ) ;
                        if ( ! empty( $selectedproduct ) ) {
                            $conversion = $c_amount1 / $rp ;
                        } else {
                            $conversion = $c_amount / self::get_product_price_in_cart() ;
                        }
                    }
                    $newpoints1 = $newpoints ;
                    $conversion = $conversion * $newpoints1 ;
                    if ( $newpoints1 > $conversion ) {
                        $conversions[] = $newpoints1 - $conversion ;
                    }
                    $newpoints = $newpoints1 - $conversion ;
                }
                return end( $conversions ) ;
            }
            return $newpoints ;
        }

        public static function coupon( $key , $product_id ) {
            global $woocommerce ;
            $discount_coupon = $woocommerce->cart->applied_coupons ;
            $coupon          = new WC_Coupon( $key ) ;
            $coupon_obj      = rs_get_coupon_obj( $coupon ) ;
            if ( count( $discount_coupon ) > 1 ) {
                $couponcode = get_post_meta( $product_id , 'couponcode' ) ;
                if ( $couponcode != $coupon_obj[ 'coupon_code' ] ) {
                    $linetotal = get_post_meta( $product_id , 'linetotal' ) ;
                    $vd        = $linetotal[ 0 ] ;
                }
            } else {
                $vd  = self::get_product_price_in_cart() ;
                $vd1 = self::get_product_price_in_cart() - $coupon_obj[ 'coupon_amount' ] ;
                update_post_meta( $product_id , 'linetotal' , $vd1 ) ;
                update_post_meta( $product_id , 'couponcode' , $coupon_obj[ 'coupon_code' ] ) ;
            }

            return $vd ;
        }

        public static function get_reward_points_to_display_msg_in_cart_and_checkout() {
            if ( get_option( 'rs_enable_product_category_level_for_product_purchase' ) == 'no' && get_option( 'rs_award_points_for_cart_or_product_total' ) == '2' )
                return ;

            global $woocommerce ;
            global $messageglobal ;
            global $totalrewardpoints ;
            global $checkproduct ;
            global $value ;
            global $totalrewardpointsnew ;
            $totalrewardpoints_payment_plan = array() ;
            global $totalrewardpoints_payment_plan ;
            ?>
            <style>
                .cart_total_minimum:before{
                    font-family:WooCommerce;content:"\e028";display:inline-block;position:absolute;top:1em;left:1.5em;color:#1e85be
                }
                .cart_total_minimum{
                    font-size: 10pt;font-family:WooCommerce;padding:1em 2em 1em 3.5em!important;margin:0 0 2em!important;position:relative;background-color:#f7f6f7;color:#515151;border-top:3px solid #a46497;list-style:none!important;width:auto;word-wrap:break-word;border-top-color:#1e85be
                }
            </style>
            <?php
            $minimum_cart_total             = get_option( 'rs_minimum_cart_total_for_earning' ) ;
            $maximum_cart_total             = get_option( 'rs_maximum_cart_total_for_earning' ) ;
            $cart_total                     = $woocommerce->cart->total ;
            $error_message                  = get_option( 'rs_min_cart_total_for_earning_error_message' ) ;
            $error_message                  = str_replace( '[carttotal]' , $minimum_cart_total , $error_message ) ;

            $error_message_max = get_option( 'rs_max_cart_total_for_earning_error_message' ) ;
            $error_message_max = str_replace( '[carttotal]' , $maximum_cart_total , $error_message_max ) ;

            if ( get_option( 'rs_enable_disable_reward_point_based_coupon_amount' ) == 'yes' ) {
                $points_info    = self::moified_points_for_products_in_cart() ;
                $buying_point   = self::buying_points_for_product_in_cart() ;
                $referral_point = self::referrel_points_for_product_in_cart() ;
                if ( ! empty( $points_info ) ) {
                    if ( $minimum_cart_total != '' && $maximum_cart_total != '' ) {
                        if ( $cart_total >= $minimum_cart_total && $cart_total <= $maximum_cart_total ) {
                            $totalrewardpointsnew = $points_info ;
                        } elseif ( $cart_total <= $minimum_cart_total ) {
                            $totalrewardpointsnew = '' ;
                            if ( $cart_total != '' ) {
                                if ( get_option( 'rs_show_hide_minimum_cart_total_earn_error_message' ) == '1' ) {
                                    ?>
                                    <div class="woocommerce-error" >  <?php echo $error_message ; ?>  </div>
                                    <?php
                                }
                            }
                        } elseif ( $cart_total >= $maximum_cart_total ) {
                            $totalrewardpointsnew = '' ;
                            if ( $cart_total != '' ) {
                                if ( get_option( 'rs_show_hide_maximum_cart_total_earn_error_message' ) == '1' ) {
                                    ?>
                                    <div class="woocommerce-error" >  <?php echo $error_message_max ; ?>  </div>
                                    <?php
                                }
                            }
                        }
                    } else if ( $minimum_cart_total != '' && $maximum_cart_total == '' ) {
                        if ( $cart_total >= $minimum_cart_total ) {
                            $totalrewardpointsnew = $points_info ;
                        } else {
                            $totalrewardpointsnew = '' ;
                            if ( $cart_total != '' ) {
                                if ( get_option( 'rs_show_hide_minimum_cart_total_earn_error_message' ) == '1' ) {
                                    ?>
                                    <div class="woocommerce-error" >  <?php echo $error_message ; ?>  </div>
                                    <?php
                                }
                            }
                        }
                    } else if ( $minimum_cart_total == '' && $maximum_cart_total != '' ) {
                        if ( $cart_total <= $maximum_cart_total ) {
                            $totalrewardpointsnew = $points_info ;
                        } else {
                            $totalrewardpointsnew = '' ;
                            if ( $cart_total != '' ) {
                                if ( get_option( 'rs_show_hide_maximum_cart_total_earn_error_message' ) == '1' ) {
                                    ?>
                                    <div class="woocommerce-error" >  <?php echo $error_message_max ; ?>  </div>
                                    <?php
                                }
                            }
                        }
                    } else if ( $minimum_cart_total == '' && $maximum_cart_total == '' ) {
                        $totalrewardpointsnew = $points_info ;
                    }
                }
            } else {
                $points_info    = self::original_points_for_product_in_cart() ;
                $buying_point   = self::buying_points_for_product_in_cart() ;
                $referral_point = self::referrel_points_for_product_in_cart() ;
                if ( ! empty( $points_info ) ) {
                    if ( $minimum_cart_total != '' && $maximum_cart_total != '' ) {
                        if ( $cart_total >= $minimum_cart_total && $cart_total <= $maximum_cart_total ) {
                            $totalrewardpointsnew = $points_info ;
                        } elseif ( $cart_total <= $minimum_cart_total ) {
                            $totalrewardpointsnew = '' ;
                            if ( $cart_total != '' ) {
                                if ( get_option( 'rs_show_hide_minimum_cart_total_earn_error_message' ) == '1' ) {
                                    ?>
                                    <div class="woocommerce-error" >  <?php echo $error_message ; ?>  </div>
                                    <?php
                                }
                            }
                        } elseif ( $cart_total >= $maximum_cart_total ) {
                            $totalrewardpointsnew = '' ;
                            if ( $cart_total != '' ) {
                                if ( get_option( 'rs_show_hide_maximum_cart_total_earn_error_message' ) == '1' ) {
                                    ?>
                                    <div class="woocommerce-error" >  <?php echo $error_message_max ; ?>  </div>
                                    <?php
                                }
                            }
                        }
                    } else if ( $minimum_cart_total != '' && $maximum_cart_total == '' ) {
                        if ( $cart_total >= $minimum_cart_total ) {
                            $totalrewardpointsnew = $points_info ;
                        } else {
                            $totalrewardpointsnew = '' ;
                            if ( $cart_total != '' ) {
                                if ( get_option( 'rs_show_hide_minimum_cart_total_earn_error_message' ) == '1' ) {
                                    ?>
                                    <div class="woocommerce-error" >  <?php echo $error_message ; ?>  </div>
                                    <?php
                                }
                            }
                        }
                    } else if ( $minimum_cart_total == '' && $maximum_cart_total != '' ) {
                        if ( $cart_total <= $maximum_cart_total ) {
                            $totalrewardpointsnew = $points_info ;
                        } else {
                            $totalrewardpointsnew = '' ;
                            if ( $cart_total != '' ) {
                                if ( get_option( 'rs_show_hide_maximum_cart_total_earn_error_message' ) == '1' ) {
                                    ?>
                                    <div class="woocommerce-error" >  <?php echo $error_message_max ; ?>  </div>
                                    <?php
                                }
                            }
                        }
                    } else if ( $minimum_cart_total == '' && $maximum_cart_total == '' ) {
                        $totalrewardpointsnew = $points_info ;
                    }
                }
            }
            if ( ! empty( $points_info ) && get_option( 'rs_product_purchase_activated' ) == 'yes' ) {
                foreach ( $points_info as $product_id => $points ) {
                    if ( $points != 0 ) {
                        $checkproduct      = rs_get_product_object( $product_id ) ;
                        $initial_check     = check_initial_payment_pdt( $product_id ) ;
                        $value             = $product_id ;
                        $totalrewardpoints = $points ;
                        if ( is_object( $checkproduct ) && ( ! $checkproduct->is_type( 'booking' )) ) {
                            if ( is_cart() ) {
                                if ( $initial_check == false ) {
                                    if ( get_option( 'rs_enable_product_category_level_for_product_purchase' ) == 'no' && get_option( 'rs_award_points_for_cart_or_product_total' ) == '2' )
                                        return ;

                                    $messageglobal[ $product_id ] = do_shortcode( get_option( 'rs_message_product_in_cart' ) ) . "<br>" ;
                                } else {
                                    $totalrewardpoints_payment_plan = array( $points ) ;
                                    if ( get_option( 'rs_show_hide_message_for_each_payment_plan_products' ) == '1' ) {
                                        ?>
                                        <div class="woocommerce-info rs_payment_plan_message_cart rs_cart_message" >  <?php echo do_shortcode( get_option( 'rs_message_payment_plan_product_in_cart' ) ) ; ?>  </div>
                                        <?php
                                    }
                                }
                            } elseif ( is_checkout() ) {
                                if ( $initial_check == false ) {
                                    if ( get_option( 'rs_enable_product_category_level_for_product_purchase' ) == 'no' && get_option( 'rs_award_points_for_cart_or_product_total' ) == '2' )
                                        return ;

                                    $messageglobal[ $product_id ] = do_shortcode( get_option( 'rs_message_product_in_checkout' ) ) . "<br>" ;
                                } else {
                                    $totalrewardpoints_payment_plan = array( $points ) ;
                                    if ( get_option( 'rs_show_hide_message_for_each_payment_plan_products_checkout_page' ) == '1' ) {
                                        ?>
                                        <div class="woocommerce-info rs_payment_plan_message_checkout rs_checkout_message" >  <?php echo do_shortcode( get_option( 'rs_message_payment_plan_product_in_checkout' ) ) ; ?>  </div> 
                                        <?php
                                    }
                                }
                            }
                        }
                    }
                }
            } else {
                $totalrewardpointsnew = '' ;
            }
            global $buying_pointsnew ;
            global $buyingmsg_global ;
            $buying_pointsnew        = $buying_point ;
            $buying_pts_payment_plan = array() ;
            global $buying_pts_payment_plan ;

            if ( ! empty( $buying_point ) ) {
                foreach ( $buying_point as $product_id => $points ) {
                    if ( $points != 0 ) {
                        $checkproduct     = rs_get_product_object( $product_id ) ;
                        $value            = $product_id ;
                        $initial_check    = check_initial_payment_pdt( $product_id ) ;
                        $buying_pointsnew = $points ;
                        if ( is_object( $checkproduct ) && ( ! $checkproduct->is_type( 'booking' )) ) {
                            $buying_point_enable = get_post_meta( $product_id , '_rewardsystem_buying_reward_points' , true ) ;
                            $buying_point_pdt    = get_post_meta( $product_id , '_rewardsystem_assign_buying_points' , true ) ;
                            if ( $buying_point_enable == 'yes' && $buying_point_pdt != '' ) {
                                if ( is_cart() ) {
                                    if ( $initial_check == false ) {
                                        $buyingmsg_global[ $product_id ] = do_shortcode( get_option( 'rs_buy_point_message_product_in_cart' ) ) . "<br>" ;
                                    } else {
                                        $buying_pts_payment_plan = array( $points ) ;
                                        if ( get_option( 'rs_show_hide_buy_point_message_for_each_payment_plan_products' ) == '1' ) {
                                            ?>
                                            <div class="woocommerce-info rs_buying_points_payment_plan_message_cart rs_cart_message" >  <?php echo do_shortcode( get_option( 'rs_buy_point_message_payment_plan_product_in_cart' ) ) ; ?>  </div>
                                            <?php
                                        }
                                    }
                                } elseif ( is_checkout() ) {
                                    if ( $initial_check == false ) {
                                        $buyingmsg_global[ $product_id ] = do_shortcode( get_option( 'rs_buy_point_message_product_in_checkout' ) ) . "<br>" ;
                                    } else {
                                        $buying_pts_payment_plan = array( $points ) ;
                                        if ( get_option( 'rs_show_hide_buy_point_message_for_each_payment_plan_products_checkout_page' ) == '1' ) {
                                            ?>
                                            <div class="woocommerce-info rs_buying_points_payment_plan_message_checkout rs_checkout_message" >  <?php echo do_shortcode( get_option( 'rs_buy_point_message_payment_plan_product_in_checkout' ) ) ; ?>  </div>      
                                            <?php
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
            if ( isset( $_COOKIE[ 'rsreferredusername' ] ) ) {
                global $referralmsg_global ;
                global $referral_pointsnew ;
                $ref_pdt_plan       = array() ;
                global $ref_pdt_plan ;
                $referral_pointsnew = $referral_point ;
                if ( ! empty( $referral_point ) && get_option( 'rs_product_purchase_activated' ) == 'yes' ) {
                    foreach ( $referral_point as $product_id => $points ) {
                        if ( $points != 0 ) {
                            $checkproduct       = rs_get_product_object( $product_id ) ;
                            $value              = $product_id ;
                            $referral_pointsnew = $points ;
                            $initial_check      = check_initial_payment_pdt( $product_id ) ;
                            if ( is_object( $checkproduct ) && ( ! $checkproduct->is_type( 'booking' )) ) {
                                if ( is_cart() ) {
                                    if ( $initial_check == false ) {
                                        $msg                               = get_option( 'rs_referral_point_message_product_in_cart' ) ;
                                        $strplc                            = str_replace( '[rsreferredusername]' , $_COOKIE[ 'rsreferredusername' ] , $msg ) ;
                                        $referralmsg_global[ $product_id ] = do_shortcode( $strplc ) . "<br>" ;
                                    } else {
                                        $ref_pdt_plan = array( $points ) ;
                                        if ( get_option( 'rs_show_hide_message_for_total_payment_plan_points_referral' ) == '1' ) {
                                            $msg    = get_option( 'rs_referral_point_message_payment_plan_product_in_cart' ) ;
                                            $strplc = str_replace( '[rsreferredusername]' , $_COOKIE[ 'rsreferredusername' ] , $msg ) ;
                                            ?>
                                            <div class="woocommerce-info rs_referral_payment_plan_message_cart rs_cart_message" >  <?php echo do_shortcode( $strplc ) ; ?>  </div>
                                            <?php
                                        }
                                    }
                                } elseif ( is_checkout() ) {
                                    if ( $initial_check == false ) {
                                        $msg                               = get_option( 'rs_referral_point_message_product_in_checkout' ) ;
                                        $strplc                            = str_replace( '[rsreferredusername]' , $_COOKIE[ 'rsreferredusername' ] , $msg ) ;
                                        $referralmsg_global[ $product_id ] = do_shortcode( $strplc ) . "<br>" ;
                                    } else {
                                        $ref_pdt_plan = array( $points ) ;
                                        if ( get_option( 'rs_show_hide_message_for_total_payment_plan_points_referrel_checkout' ) == '1' ) {
                                            $msg    = get_option( 'rs_referral_point_message_payment_plan_product_in_checkout' ) ;
                                            $strplc = str_replace( '[rsreferredusername]' , $_COOKIE[ 'rsreferredusername' ] , $msg ) ;
                                            ?>
                                            <div class="woocommerce-info rs_referral_payment_plan_message_checkout rs_checkout_message" >  <?php echo do_shortcode( $strplc ) ; ?>  </div>
                                            <?php
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
                $referral_pointsnew = $referral_point ;
            }
            $buying_pointsnew  = $buying_point ;
            $totalrewardpoints = rs_getshortcodetotal_rewards() ;
            WC()->session->set( 'rewardpoints' , $totalrewardpoints ) ;
        }

        public static function test_coupon() {
            ?>
            <script type='text/javascript'>
                jQuery( document ).ready( function () {
                    jQuery( '.displaymessage' ).parent().hide() ;
                } ) ;
            </script>
            <?php
            if ( is_cart() ) {
                if ( isset( $_GET[ 'remove_coupon' ] ) ) {
                    wp_redirect( wc_get_page_permalink( 'cart' ) ) ;
                }
            }
        }

        public static function remove_session() {
            WC()->session->set( 'auto_redeemcoupon' , 'yes' ) ;
        }

        public static function unset_session() {
            global $woocommerce ;
            WC()->session->set( 'auto_redeemcoupon' , 'no' ) ;
        }

        public static function rs_apply_coupon_automatically() {
            if ( is_cart() || is_checkout() ) {
                global $woocommerce ;
                if ( is_checkout() ) {
                    if ( isset( $_GET[ 'remove_coupon' ] ) ) {
                        WC()->session->set( 'auto_redeemcoupon' , 'no' ) ;
                    }
                }
                $autoredeemenable = get_option( 'rs_enable_disable_auto_redeem_points' ) ;
                if ( $autoredeemenable == 'yes' && get_option( 'rs_redeeming_activated' ) == 'yes' ) {
                    global $woocommerce ;
                    $user_ID = get_current_user_id() ;
                    if ( is_user_logged_in() ) {
                        $current_carttotal_amount             = self::rs_line_subtotal_for_redeeming_restriction() ;
                        $maximum_cart_total_redeem            = get_option( 'rs_maximum_cart_total_points' ) ;
                        $minimum_cart_total_redeem            = get_option( 'rs_minimum_cart_total_points' ) ;
                        $hide_message_for_point_price_product = self::rs_hide_restrict_message_for_redeeming_on_point_price() ;
                        if ( $hide_message_for_point_price_product == true ) {
                            return ;
                        }
                        if ( $minimum_cart_total_redeem != '' && $maximum_cart_total_redeem != '' ) {
                            if ( $current_carttotal_amount >= $minimum_cart_total_redeem && $current_carttotal_amount <= $maximum_cart_total_redeem ) {
                                if ( is_cart() ) {
                                    self::auto_redeeming() ;
                                }
                                if ( is_checkout() ) {
                                    if ( get_option( 'rs_enable_disable_auto_redeem_checkout' ) == 'yes' ) {
                                        self::auto_redeeming() ;
                                    }
                                }
                            }
                        } else if ( $minimum_cart_total_redeem != '' && $maximum_cart_total_redeem == '' ) {
                            if ( $current_carttotal_amount >= $minimum_cart_total_redeem ) {
                                if ( is_cart() ) {
                                    self::auto_redeeming() ;
                                }
                                if ( is_checkout() ) {
                                    if ( get_option( 'rs_enable_disable_auto_redeem_checkout' ) == 'yes' ) {
                                        self::auto_redeeming() ;
                                    }
                                }
                            }
                        } else if ( $minimum_cart_total_redeem == '' && $maximum_cart_total_redeem != '' ) {
                            if ( $current_carttotal_amount <= $maximum_cart_total_redeem ) {
                                if ( is_cart() ) {
                                    self::auto_redeeming() ;
                                }
                                if ( is_checkout() ) {
                                    if ( get_option( 'rs_enable_disable_auto_redeem_checkout' ) == 'yes' ) {
                                        self::auto_redeeming() ;
                                    }
                                }
                            }
                        } else if ( $minimum_cart_total_redeem == '' && $maximum_cart_total_redeem == '' ) {
                            if ( is_cart() ) {
                                self::auto_redeeming() ;
                            }
                            if ( is_checkout() ) {
                                if ( get_option( 'rs_enable_disable_auto_redeem_checkout' ) == 'yes' ) {
                                    self::auto_redeeming() ;
                                }
                            }
                        }
                    }
                }
            }
        }

        public static function auto_redeeming() {
            $type                = array() ;
            global $woocommerce ;
            $user_ID             = get_current_user_id() ;
            $getinfousernickname = get_user_by( 'id' , $user_ID ) ;
            $couponcodeuserlogin = is_object( $getinfousernickname ) ? $getinfousernickname->user_login : 'Guest' ;
            $autoredeemenable    = get_option( 'rs_enable_disable_auto_redeem_points' ) ;
            $checkfirstimeredeem = RSFunctionForSavingMetaValues::rewardsystem_get_user_meta( $user_ID , 'rsfirsttime_redeemed' ) ;
            if ( $woocommerce->cart->get_cart_contents_count() == 0 ) {
                WC()->session->set( 'auto_redeemcoupon' , 'yes' ) ;
            }
            if ( $woocommerce->cart->get_cart_contents_count() == 0 ) {
                foreach ( $woocommerce->cart->applied_coupons as $code ) {
                    $coupon     = new WC_Coupon( $code ) ;
                    $coupon_obj = rs_get_coupon_obj( $coupon ) ;
                    $couponcode = $coupon_obj[ 'coupon_code' ] ;
                    $woocommerce->cart->remove_coupon( $couponcode ) ;
                }
            }
            foreach ( $woocommerce->cart->cart_contents as $item ) {
                $product_id = $item[ 'variation_id' ] != 0 ? $item[ 'variation_id' ] : $item[ 'product_id' ] ;
                $type[]     = check_display_price_type( $product_id ) ;
                $enable     = calculate_point_price_for_products( $product_id ) ;
                if ( $enable[ $product_id ] != '' ) {
                    $cart_object[] = $enable[ $product_id ] ;
                }
            }
            if ( empty( $cart_object ) ) {
                if ( ! in_array( 2 , $type ) ) {
                    if ( $woocommerce->cart->get_cart_contents_count() != 0 ) {
                        if ( $autoredeemenable == 'yes' ) {
                            if ( WC()->session->get( 'auto_redeemcoupon' ) != 'no' ) {
                                global $woocommerce ;
                                $getuserid           = get_current_user_id() ;
                                $user_current_points = RSPointExpiry::total_available_points_in_site( $getuserid ) ;
                                if ( $user_current_points > 0 ) {
                                    if ( $user_current_points >= get_option( "rs_first_time_minimum_user_points" ) ) {
                                        $redeem_conversion = get_option( 'rs_redeem_point' ) ;
                                        if ( get_option( 'woocommerce_prices_include_tax' ) == 'yes' ) {
                                            if ( get_option( 'woocommerce_tax_display_cart' ) == 'incl' ) {
                                                $get_cart_total_for_redeem = $woocommerce->cart->subtotal ;
                                            } else {
                                                $get_cart_total_for_redeem = $woocommerce->cart->subtotal ;
                                            }
                                        } else {
                                            if ( get_option( 'woocommerce_tax_display_cart' ) == 'incl' ) {
                                                $get_cart_total_for_redeem = $woocommerce->cart->subtotal_ex_tax ;
                                            } else {
                                                $get_cart_total_for_redeem = $woocommerce->cart->subtotal_ex_tax ;
                                            }
                                        }
                                        $point_control                  = wc_format_decimal( get_option( 'rs_redeem_point' ) ) ;
                                        $cartpoints_string_to_replace   = "[cartredeempoints]" ;
                                        $currency_symbol_string_to_find = "[currencysymbol]" ;
                                        $currency_value_string_to_find  = "[pointsvalue]" ;
                                        $getmaxruleoption               = get_option( 'rs_max_redeem_discount' ) ;
                                        $getfixedmaxoption              = get_option( 'rs_fixed_max_redeem_discount' ) ;
                                        $getpercentmaxoption            = get_option( 'rs_percent_max_redeem_discount' ) ;
                                        $errpercentagemsg               = get_option( 'rs_errmsg_for_max_discount_type' ) ;
                                        $point_control                  = wc_format_decimal( get_option( 'rs_redeem_point' ) ) ;
                                        $point_amount                   = RSMemberFunction::user_role_based_redeem_points( get_current_user_id() ) ;
                                        $point_control_price            = $point_amount ;
                                        $minimum_cart_total_redeem      = get_option( 'rs_minimum_cart_total_points' ) ;
                                        if ( $user_current_points >= get_option( "rs_minimum_user_points_to_redeem" ) ) {
                                            if ( $get_cart_total_for_redeem >= $minimum_cart_total_redeem ) {
                                                if ( ! is_array( get_option( 'rs_select_products_to_enable_redeeming' ) ) ) {
                                                    $allowproducts = explode( ',' , get_option( 'rs_select_products_to_enable_redeeming' ) ) ;
                                                } else {
                                                    $allowproducts = get_option( 'rs_select_products_to_enable_redeeming' ) ;
                                                }

                                                if ( ! is_array( get_option( 'rs_exclude_products_to_enable_redeeming' ) ) ) {
                                                    $excludeproducts = explode( ',' , get_option( 'rs_exclude_products_to_enable_redeeming' ) ) ;
                                                } else {
                                                    $excludeproducts = get_option( 'rs_exclude_products_to_enable_redeeming' ) ;
                                                }
                                                $allowcategory   = get_option( 'rs_select_category_to_enable_redeeming' ) ;
                                                $excludecategory = get_option( 'rs_exclude_category_to_enable_redeeming' ) ;
                                                $coupon          = array(
                                                    'post_title'   => 'auto_redeem_' . strtolower( $couponcodeuserlogin ) ,
                                                    'post_content' => '' ,
                                                    'post_status'  => 'publish' ,
                                                    'post_author'  => get_current_user_id() ,
                                                    'post_type'    => 'shop_coupon' ,
                                                        ) ;
                                                $oldcouponid     = RSFunctionForSavingMetaValues::rewardsystem_get_user_meta( $user_ID , 'auto_redeemcoupon_ids' , true ) ;
                                                wp_delete_post( $oldcouponid , true ) ;
                                                if ( class_exists( 'WC_Cache_Helper' ) ) {
                                                    wp_cache_delete( WC_Cache_Helper::get_cache_prefix( 'coupons' ) . 'coupon_id_from_code_auto_redeem_' . strtolower( $couponcodeuserlogin ) , 'coupons' ) ;
                                                }
                                                if ( get_option( 'rs_restrict_sale_price_for_redeeming' ) == 'yes' ) {
                                                    $restrict_sale_price_for_redeeming = RSFunctionToApplyCoupon::restrict_sale_price_product_for_redeeming() ;
                                                    if ( $restrict_sale_price_for_redeeming == false ) {
                                                        wc_add_notice( __( get_option( 'rs_redeeming_message_restrict_for_sale_price_product' ) ) , 'error' ) ;
                                                        return ;
                                                    }
                                                }
                                                $new_coupon_id = wp_insert_post( $coupon ) ;
                                                update_user_meta( $user_ID , 'auto_redeemcoupon_ids' , $new_coupon_id ) ;
                                                RSFunctionForSavingMetaValues::rewardsystem_update_post_meta( $new_coupon_id , 'carttotal' , $woocommerce->cart->cart_contents_total ) ;
                                                RSFunctionForSavingMetaValues::rewardsystem_update_post_meta( $new_coupon_id , 'cartcontenttotal' , $woocommerce->cart->cart_contents_count ) ;

                                                //Redeeming only for Selected Products option start
                                                $enableproductredeeming = get_option( 'rs_enable_redeem_for_selected_products' ) ;
                                                if ( $enableproductredeeming == 'yes' ) {
                                                    RSFunctionForSavingMetaValues::rewardsystem_update_post_meta( $new_coupon_id , 'product_ids' , implode( ',' , array_filter( array_map( 'intval' , $allowproducts ) ) ) ) ;
                                                }
                                                $excludeproductredeeming = get_option( 'rs_exclude_products_for_redeeming' ) ;
                                                if ( $excludeproductredeeming == 'yes' ) {
                                                    RSFunctionForSavingMetaValues::rewardsystem_update_post_meta( $new_coupon_id , 'exclude_product_ids' , implode( ',' , array_filter( array_map( 'intval' , $excludeproducts ) ) ) ) ;
                                                    $product = RSFunctionForSavingMetaValues::rewardsystem_get_post_meta( $new_coupon_id , 'exclude_product_ids' ) ;

                                                    foreach ( $woocommerce->cart->cart_contents as $key => $value ) {
                                                        $product_idsss = $value[ 'product_id' ] ;
                                                        if ( $product_idsss == $product ) {
                                                            WC()->session->set( 'auto_redeemcoupon' , 'no' ) ;
                                                        }
                                                    }
                                                }
                                                $enablecategoryredeeming = get_option( 'rs_enable_redeem_for_selected_category' ) ;
                                                if ( $enablecategoryredeeming == 'yes' ) {
                                                    RSFunctionForSavingMetaValues::rewardsystem_update_post_meta( $new_coupon_id , 'product_categories' , array_filter( array_map( 'intval' , $allowcategory ) ) ) ;
                                                }
                                                $excludecategoryredeeming = get_option( 'rs_exclude_category_for_redeeming' ) ;
                                                if ( $excludecategoryredeeming == 'yes' ) {
                                                    RSFunctionForSavingMetaValues::rewardsystem_update_post_meta( $new_coupon_id , 'exclude_product_categories' , array_filter( array_map( 'intval' , $excludecategory ) ) ) ;
                                                }

                                                //Redeeming only for Selected Products option End
                                                if ( get_option( 'rs_apply_redeem_basedon_cart_or_product_total' ) == '1' ) {
                                                    RSFunctionForSavingMetaValues::rewardsystem_update_post_meta( $new_coupon_id , 'carttotal' , $woocommerce->cart->cart_contents_total ) ;
                                                    RSFunctionForSavingMetaValues::rewardsystem_update_post_meta( $new_coupon_id , 'cartcontenttotal' , $woocommerce->cart->cart_contents_count ) ;
                                                    $limitation_percentage_for_redeeming_for_button = get_option( 'rs_percentage_cart_total_auto_redeem' ) != '' ? get_option( 'rs_percentage_cart_total_auto_redeem' ) : 100 ;
                                                    $reddem_value_in_amount_percent                 = $limitation_percentage_for_redeeming_for_button / 100 ;
                                                    $reddem_points_for_total                        = $reddem_value_in_amount_percent * $get_cart_total_for_redeem ;
                                                    $coupon_value_in_amount                         = $reddem_points_for_total ;
                                                    if ( $getmaxruleoption == '1' ) {
                                                        if ( $getfixedmaxoption != '' ) {
                                                            if ( $reddem_points_for_total > $getfixedmaxoption ) {
                                                                $coupon_value_in_amount = $getfixedmaxoption ;
                                                                $errpercentagemsg1      = str_replace( '[percentage] %' , $getfixedmaxoption , $errpercentagemsg ) ;
                                                                wc_add_notice( __( $errpercentagemsg1 ) , 'error' ) ;
                                                            } else {
                                                                $coupon_value_in_amount = $reddem_points_for_total ;
                                                            }
                                                        }
                                                    } else {
                                                        if ( $getmaxruleoption == '2' ) {
                                                            if ( $getpercentmaxoption != '' ) {
                                                                $percentageproduct = $getpercentmaxoption / 100 ;
                                                                $getpricepercent   = $percentageproduct * $get_cart_total_for_redeem ;

                                                                if ( $getpricepercent > $reddem_points_for_total ) {
                                                                    $coupon_value_in_amount = $reddem_points_for_total ;
                                                                } else {
                                                                    $coupon_value_in_amount = $getpricepercent ;
                                                                    $errpercentagemsg1      = str_replace( '[percentage] ' , $getpercentmaxoption , $errpercentagemsg ) ;
                                                                    wc_add_notice( __( $errpercentagemsg1 ) , 'error' ) ;
                                                                }
                                                            }
                                                        }
                                                    }
                                                    $getuserid                    = get_current_user_id() ;
                                                    $user_current_points          = RSPointExpiry::total_available_points_in_site( $getuserid ) ;
                                                    $point_control                = wc_format_decimal( get_option( 'rs_redeem_point' ) ) ;
                                                    $point_amount                 = RSMemberFunction::user_role_based_redeem_points( get_current_user_id() ) ;
                                                    $point_control_price          = $point_amount ; //i.e., 100 Points is equal to $1
                                                    $revised_amount               = $coupon_value_in_amount * $point_control ;
                                                    $coupon_value_in_points       = $revised_amount / $point_control_price ;
                                                    $user_current_points_in_value = $user_current_points / $point_control ;
                                                    $user_current_points1         = $user_current_points_in_value * $point_control_price ;
                                                    if ( $coupon_value_in_points > $user_current_points ) {
                                                        RSFunctionForSavingMetaValues::rewardsystem_update_post_meta( $new_coupon_id , 'coupon_amount' , $user_current_points1 ) ;
                                                    } else {
                                                        RSFunctionForSavingMetaValues::rewardsystem_update_post_meta( $new_coupon_id , 'coupon_amount' , $coupon_value_in_amount ) ;
                                                    }
                                                } else {
                                                    $getsumofselectedproduct                        = RSFunctionToApplyCoupon::get_sum_of_selected_products( 'auto' , '' , $user_current_points ) ;
                                                    RSFunctionForSavingMetaValues::rewardsystem_update_post_meta( $new_coupon_id , 'carttotal' , $getsumofselectedproduct ) ;
                                                    RSFunctionForSavingMetaValues::rewardsystem_update_post_meta( $new_coupon_id , 'cartcontenttotal' , $getsumofselectedproduct ) ;
                                                    $limitation_percentage_for_redeeming_for_button = get_option( 'rs_percentage_cart_total_auto_redeem' ) != '' ? get_option( 'rs_percentage_cart_total_auto_redeem' ) : 100 ;
                                                    $reddem_value_in_amount_percent                 = $limitation_percentage_for_redeeming_for_button / 100 ;
                                                    $reddem_points_for_total                        = $reddem_value_in_amount_percent * $getsumofselectedproduct ;
                                                    $coupon_value_in_amount                         = $reddem_points_for_total ;
                                                    if ( $reddem_points_for_total > $getsumofselectedproduct ) {
                                                        $reddem_points_for_total = $getsumofselectedproduct ;
                                                        $coupon_value_in_amount  = $reddem_points_for_total ;
                                                    }
                                                    if ( $getmaxruleoption == '1' ) {
                                                        if ( $getfixedmaxoption != '' ) {
                                                            if ( $reddem_points_for_total > $getfixedmaxoption ) {
                                                                $coupon_value_in_amount = $getfixedmaxoption ;
                                                                $errpercentagemsg1      = str_replace( '[percentage] %' , $getfixedmaxoption , $errpercentagemsg ) ;
                                                                wc_add_notice( __( $errpercentagemsg1 ) , 'error' ) ;
                                                            } else {
                                                                $coupon_value_in_amount = $reddem_points_for_total ;
                                                            }
                                                        }
                                                    } else {
                                                        if ( $getmaxruleoption == '2' ) {
                                                            if ( $getpercentmaxoption != '' ) {
                                                                $percentageproduct = $getpercentmaxoption / 100 ;
                                                                $getpricepercent   = $percentageproduct * $coupon_value_in_amount ;

                                                                if ( $getpricepercent > $reddem_points_for_total ) {
                                                                    $coupon_value_in_amount = $reddem_points_for_total ;
                                                                } else {
                                                                    $coupon_value_in_amount = $getpricepercent ;
                                                                    $errpercentagemsg1      = str_replace( '[percentage] ' , $getpercentmaxoption , $errpercentagemsg ) ;
                                                                    wc_add_notice( __( $errpercentagemsg1 ) , 'error' ) ;
                                                                }
                                                            }
                                                        }
                                                    }

                                                    $getuserid                    = get_current_user_id() ;
                                                    $user_current_points          = RSPointExpiry::total_available_points_in_site( $getuserid ) ;
                                                    $point_control                = wc_format_decimal( get_option( 'rs_redeem_point' ) ) ;
                                                    $point_amount                 = RSMemberFunction::user_role_based_redeem_points( get_current_user_id() ) ;
                                                    $point_control_price          = $point_amount ; //i.e., 100 Points is equal to $1
                                                    $revised_amount               = $coupon_value_in_amount * $point_control ;
                                                    $coupon_value_in_points       = $revised_amount / $point_control_price ;
                                                    $user_current_points_in_value = $user_current_points / $point_control ;
                                                    $user_current_points1         = $user_current_points_in_value * $point_control_price ;
                                                    if ( $coupon_value_in_points > $user_current_points ) {
                                                        RSFunctionForSavingMetaValues::rewardsystem_update_post_meta( $new_coupon_id , 'coupon_amount' , $user_current_points1 ) ;
                                                    } else {
                                                        RSFunctionForSavingMetaValues::rewardsystem_update_post_meta( $new_coupon_id , 'coupon_amount' , $coupon_value_in_amount ) ;
                                                    }
                                                }

                                                if ( $woocommerce->cart->has_discount( 'auto_redeem_' . strtolower( $couponcodeuserlogin ) ) )
                                                    return ;

                                                if ( get_post_meta( $new_coupon_id , 'coupon_amount' , true ) != 0 ) {
                                                    if ( get_option( 'rs_minimum_redeeming_points' ) != '' && get_option( 'rs_maximum_redeeming_points' ) == '' ) {
                                                        if ( $coupon_value_in_points > get_option( 'rs_minimum_redeeming_points' ) ) {
                                                            $woocommerce->cart->add_discount( 'auto_redeem_' . strtolower( $couponcodeuserlogin ) ) ;
                                                        }
                                                    }

                                                    if ( get_option( 'rs_maximum_redeeming_points' ) != '' && get_option( 'rs_minimum_redeeming_points' ) == '' ) {
                                                        if ( $coupon_value_in_points < get_option( 'rs_maximum_redeeming_points' ) ) {
                                                            $woocommerce->cart->add_discount( 'auto_redeem_' . strtolower( $couponcodeuserlogin ) ) ;
                                                        }
                                                    }

                                                    if ( get_option( 'rs_minimum_redeeming_points' ) == get_option( 'rs_maximum_redeeming_points' ) ) {
                                                        if ( ($coupon_value_in_points == get_option( 'rs_minimum_redeeming_points' )) && ($coupon_value_in_points == get_option( 'rs_maximum_redeeming_points' )) ) {
                                                            $woocommerce->cart->add_discount( 'auto_redeem_' . strtolower( $couponcodeuserlogin ) ) ;
                                                        }
                                                    }

                                                    if ( get_option( 'rs_minimum_redeeming_points' ) == '' && get_option( 'rs_maximum_redeeming_points' ) == '' ) {
                                                        $woocommerce->cart->add_discount( 'auto_redeem_' . strtolower( $couponcodeuserlogin ) ) ;
                                                    }

                                                    if ( get_option( 'rs_minimum_redeeming_points' ) != '' && get_option( 'rs_maximum_redeeming_points' ) != '' ) {
                                                        if ( ($coupon_value_in_points >= get_option( 'rs_minimum_redeeming_points' )) && ($coupon_value_in_points <= get_option( 'rs_maximum_redeeming_points' )) ) {
                                                            $woocommerce->cart->add_discount( 'auto_redeem_' . strtolower( $couponcodeuserlogin ) ) ;
                                                        }
                                                    }
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }

        public static function set_point_price_for_products_in_session( $cart_item_key , $product_id = null , $quantity = null , $variation_id = null , $variation = null ) {
            $product_id              = $variation_id != null ? $variation_id : $product_id ;
            $point_price_for_product = calculate_point_price_for_products( $product_id ) ;
            WC()->session->set( $cart_item_key . 'point_price_for_product' , $point_price_for_product ) ;
        }

        public static function save_point_price_info_in_order( $orderid ) {
            global $woocommerce ;
            $current_cart_contents = $woocommerce->cart->cart_contents ;
            foreach ( $current_cart_contents as $key => $value ) {
                if ( WC()->session->get( $key . 'point_price_for_product' ) ) {
                    $point_price_info[] = WC()->session->get( $key . 'point_price_for_product' ) ;
                    update_post_meta( $orderid , 'point_price_for_product_in_order' , $point_price_info ) ;
                }
            }
        }

        public static function display_point_price_in_cart_total( $price ) {
            if ( ! is_user_logged_in() )
                return $price ;

            if ( get_option( 'rs_point_price_activated' ) != 'yes' )
                return $price ;

            if ( get_option( 'rs_enable_disable_point_priceing' ) == '2' )
                return $price ;


            global $woocommerce ;
            $EnablePointPriceValue       = $LineTotal                   = $PointPriceTax               = $ItemPointsTotal             = $EnablePointPriceForVariable = $EnablePointPriceforSimple   = array() ;
            $ShippingTotal               = $woocommerce->shipping->shipping_total ;
            $ShippingTax                 = $woocommerce->shipping->shipping_taxes ;
            $ShippingTaxTotal            = array_sum( $ShippingTax ) ;
            $CouponAmount                = $woocommerce->cart->get_cart_discount_total() ;
            $ShippingCost                = $ShippingTotal + $ShippingTaxTotal ;
            foreach ( $woocommerce->cart->cart_contents as $key ) {
                $ProductId        = $key[ 'variation_id' ] != 0 ? $key[ 'variation_id' ] : $key[ 'product_id' ] ;
                $Points           = calculate_point_price_for_products( $ProductId ) ;
                $PointPriceType[] = check_display_price_type( $ProductId ) ;
                if ( $Points[ $ProductId ] == '' ) {
                    $PriceforRegularProduct = get_sale_and_regular_price( $ProductId ) ;
                } else {
                    $PriceforRegularProduct = $Points[ $ProductId ] ;
                }
                if ( get_option( 'rs_enable_product_category_level_for_points_price' ) == 'no' ) {  //Quick Setup
                    $EnablePointPriceValue[] = get_option( 'rs_local_enable_disable_point_price_for_product' ) ;
                } else {  //Advance Setup
                    $EnablePointPriceForVariable[] = RSFunctionForSavingMetaValues::rewardsystem_get_post_meta( $ProductId , '_enable_reward_points_price' ) ;
                    $EnablePointPriceforSimple[]   = RSFunctionForSavingMetaValues::rewardsystem_get_post_meta( $ProductId , '_rewardsystem_enable_point_price' ) ;
                }
                $CheckIfBundledProduct = isset( $key[ 'bundled_by' ] ) ? $key[ 'bundled_by' ] : 0 ;
                if ( $CheckIfBundledProduct == 0 ) {
                    $ItemPointsTotal[] = $PriceforRegularProduct * $key[ 'quantity' ] ;
                    if ( get_option( 'woocommerce_prices_include_tax' ) == 'no' )
                        $PointPriceTax[]   = $key[ 'line_subtotal_tax' ] ;
                } else {
                    $LineTotal[]     = $key[ 'line_subtotal' ] ;
                    $PointPriceTax[] = $key[ 'line_subtotal_tax' ] ;
                }
            }
            $RedeemPointConversion             = wc_format_decimal( get_option( 'rs_redeem_point' ) ) ;
            $RedeemPointConversionValue        = RSMemberFunction::user_role_based_redeem_points( get_current_user_id() ) ;
            $ShippingConversion                = $ShippingCost * $RedeemPointConversion ;
            $ShippingConversionValue           = $ShippingConversion / $RedeemPointConversionValue ;
            $SubTotal                          = array_sum( $LineTotal ) ;
            $TaxForSubTotal                    = array_sum( $PointPriceTax ) ;
            $TotalPointAmount                  = $SubTotal + $TaxForSubTotal ;
            $TotalPointConversionValue         = $TotalPointAmount / $RedeemPointConversionValue ;
            $TotalPointConversion              = $TotalPointConversionValue * $RedeemPointConversion ;
            $TotalPoint                        = (array_sum( $ItemPointsTotal ) + $TotalPointConversion) - $CouponAmount ;
            $TotalPointsWithTax                = $TotalPoint + $ShippingConversionValue ;
            $TotalPointAfterRoundOff           = round_off_type( $TotalPointsWithTax ) ;
            $PointPriceLabelPosition           = get_option( 'rs_sufix_prefix_point_price_label' ) ;
            $SpaceBetweenLabelAndPointsinPixel = get_option( 'rs_pixel_val' ) != '' ? get_option( 'rs_pixel_val' ) : 1 ;
            $PointPriceLabel                   = get_option( 'rs_label_for_point_value' ) ;
            if ( $PointPriceLabelPosition == '1' ) {
                $CartTotalToDisplay = "{$PointPriceLabel}<span style='margin-left:{$SpaceBetweenLabelAndPointsinPixel}px;'>{$TotalPointAfterRoundOff}</span>" ;
            } else {
                $RemoveSlashIfExist = str_replace( "/" , "" , $PointPriceLabel ) ;
                $CartTotalToDisplay = '/' . "{$TotalPointAfterRoundOff}<span style='margin-left:{$SpaceBetweenLabelAndPointsinPixel}px;'>{$RemoveSlashIfExist}</span>" ;
            }

            if ( in_array( "yes" , $EnablePointPriceforSimple ) || in_array( "1" , $EnablePointPriceForVariable ) || in_array( "1" , $EnablePointPriceValue ) ) {
                if ( in_array( '2' , $PointPriceType ) ) {
                    $DisplayTotal = str_replace( "/" , "" , $CartTotalToDisplay ) ;
                    return $DisplayTotal ;
                } else {
                    if ( array_sum( $ItemPointsTotal ) > 0 || $CheckIfBundledProduct != 0 ) {
                        if ( $TotalPointAfterRoundOff == 0 )
                            return $price ;

                        return $price . $CartTotalToDisplay ;
                    } else {
                        return $price ;
                    }
                }
            } else {
                return $price ;
            }
        }

        /* Display the Point Price Label in Cart Item Price */

        public static function display_point_price_for_product_in_cart_item_price( $product_price , $item , $item_key ) {
            $product_price = self::get_point_price_with_label( $product_price , $item , $item_key , 'item_price' ) ;
            return $product_price ;
        }

        /* Display the Point Price Label in Cart Item Total */

        public static function display_point_price_for_product_in_cart_item_total( $product_price , $item , $item_key ) {
            $product_price = self::get_point_price_with_label( $product_price , $item , $item_key , 'item_total' ) ;
            return $product_price ;
        }

        public static function get_point_price_with_label( $product_price , $item , $item_key , $position ) {
            if ( get_option( 'rs_point_price_activated' ) != 'yes' )
                return $product_price ;

            if ( get_option( 'rs_enable_disable_point_priceing' ) == '2' )
                return $product_price ;

            $Points                            = array() ;
            $product_id                        = $item[ 'variation_id' ] != 0 ? $item[ 'variation_id' ] : $item[ 'product_id' ] ;
            $Quantity                          = $item[ 'quantity' ] ;
            $PointPriceLabel                   = get_option( 'rs_label_for_point_value' ) ;
            $PointPriceLabelPosition           = get_option( 'rs_sufix_prefix_point_price_label' ) ;
            $SpaceBetweenLabelAndPointsinPixel = get_option( 'rs_pixel_val' ) != '' ? get_option( 'rs_pixel_val' ) : 1 ;
            $Points                            = calculate_point_price_for_products( $product_id ) ;
            $PointPriceType                    = check_display_price_type( $product_id ) ;
            $IndividualPointsForProduct        = implode( "," , $Points ) ;
            if ( $IndividualPointsForProduct == '' )
                return $product_price ;

            if ( get_option( 'rs_point_price_visibility' ) == '2' && ! is_user_logged_in() )
                return $product_price ;

            $IndividualPointsForProduct = ($position == 'item_price') ? $IndividualPointsForProduct : $IndividualPointsForProduct * $Quantity ;
            if ( get_option( 'rs_enable_product_category_level_for_points_price' ) == 'no' ) {  //Quick Setup
                $EnablePointPrice = get_option( 'rs_local_enable_disable_point_price_for_product' ) ;
                if ( $EnablePointPrice == '2' )
                    return $product_price ;

                $product_price = self::get_point_price_for_product( $item , $PointPriceType , $IndividualPointsForProduct , $PointPriceLabel , $SpaceBetweenLabelAndPointsinPixel , $PointPriceLabelPosition ) ;
                return $product_price ;
            } else {    //Advance Setup
                $EnablePointPriceForVariableinProductLevel = RSFunctionForSavingMetaValues::rewardsystem_get_post_meta( $product_id , '_enable_reward_points_price' ) ;
                $EnablePointPriceForSimpleinProductLevel   = RSFunctionForSavingMetaValues::rewardsystem_get_post_meta( $product_id , '_rewardsystem_enable_point_price' ) ;
                if ( $EnablePointPriceForVariableinProductLevel == '1' || $EnablePointPriceForSimpleinProductLevel == 'yes' ) {
                    $product_price = self::get_point_price_for_product( $item , $PointPriceType , $IndividualPointsForProduct , $PointPriceLabel , $SpaceBetweenLabelAndPointsinPixel , $PointPriceLabelPosition ) ;
                    return $product_price ;
                }
            }
            return $product_price ;
        }

        public static function get_point_price_for_product( $item , $PointPriceType , $IndividualPointsForProduct , $PointPriceLabel , $SpaceBetweenLabelAndPointsinPixel , $PointPriceLabelPosition ) {
            if ( $PointPriceType == '1' ) { //Currency & Point Pricing
                $PointsAfterRoundOff = round_off_type( $IndividualPointsForProduct ) ;

                if ( $PointPriceLabelPosition == '1' ) {
                    $ProductPriceToDisplay = "{$PointPriceLabel}<span style='margin-left:{$SpaceBetweenLabelAndPointsinPixel}px;'>{$IndividualPointsForProduct}</span>" ;
                } else {
                    $RemoveSlashIfExist    = str_replace( "/" , "" , $PointPriceLabel ) ;
                    $ProductPriceToDisplay = '/' . "{$IndividualPointsForProduct}<span style='margin-left:{$SpaceBetweenLabelAndPointsinPixel}px;'>{$RemoveSlashIfExist}</span>" ;
                }
                $product_price = wc_price( rs_get_price( $item[ 'data' ] ) ) . $ProductPriceToDisplay ;
                return $product_price ;
            } else {  //Only Point Price
                $RemoveSlashIfExist  = str_replace( "/" , "" , $PointPriceLabel ) ;
                $PointsAfterRoundOff = round_off_type( $IndividualPointsForProduct ) ;
                if ( $PointPriceLabelPosition == '1' ) {
                    $product_price = "{$RemoveSlashIfExist}<span style='margin-left:{$SpaceBetweenLabelAndPointsinPixel}px;'>{$IndividualPointsForProduct}</span>" ;
                } else {
                    $product_price = "{$IndividualPointsForProduct}<span style='margin-left:{$SpaceBetweenLabelAndPointsinPixel}px;'>{$RemoveSlashIfExist}</span>" ;
                }
                return $product_price ;
            }
        }

        public static function sell_individually_functionality( $valid , $product_id , $quantity , $variation_id = NULL , $variations = NULL ) {
            if ( $product_id != '' ) {
                if ( ! is_user_logged_in() ) {
                    if ( get_option( 'rs_enable_disable_point_priceing' ) == '1' && get_option( 'rs_point_price_activated' ) == 'yes' ) {
                        $typeofprice = check_display_price_type( $product_id ) ;
                        if ( $typeofprice != '' ) {
                            wc_add_notice( "Please signup to purchase this product" , 'error' ) ;
                            return ;
                        }
                    }
                }
            } else if ( get_option( 'rs_point_price_visibility' ) == '2' && ! is_user_logged_in() ) {
                wc_add_notice( 'Please signup to purchase this product' , 'error' ) ;
                return ;
            } else {
                if ( get_option( 'rs_enable_disable_point_priceing' ) == '1' && get_option( 'rs_point_price_activated' ) == 'yes' ) {
                    if ( function_exists( 'WC' ) ) {
                        global $woocommerce ;
                        $cart_content = WC()->cart->get_cart() ;

                        if ( ! empty( $cart_content ) ) {
                            $cart_contents_count = WC()->cart->cart_contents_count ;
                            foreach ( $cart_content as $key => $content ) {
                                if ( $cart_contents_count > 0 && 1 <= $cart_contents_count ) {

                                    global $woocommerce ;
                                    if ( ( float ) $woocommerce->version >= ( float ) '3.0' ) {
                                        if ( isset( $content[ 'data' ]->post_type ) && $content[ 'data' ]->post_type == 'product_variation' ) {
                                            $productid = $content[ 'data' ]->get_parent_id() ;
                                            $parent_id = $content[ 'data' ]->get_parent_id() ;
                                        } else {
                                            $productid   = $content[ 'data' ]->get_id() ;
                                            $product_ids = $content[ 'data' ]->get_id() ;
                                        }
                                    } else {
                                        if ( isset( $content[ 'data' ]->variation_id ) ) {
                                            $productid = $content[ 'data' ]->variation_id ;
                                            $parent_id = $content[ 'data' ]->variation_id ;
                                        } else {
                                            $productid   = $content[ 'data' ]->id ;
                                            $product_ids = $content[ 'data' ]->id ;
                                        }
                                    }
                                    if ( self::check_is_point_pricing_enable( $productid ) ) {

                                        if ( isset( $variation_id ) ) {
                                            $get_product_productid = $variation_id ;
                                        } else {
                                            $get_product_productid = $product_id ;
                                        }

                                        if ( self::check_is_point_pricing_enable( $get_product_productid ) ) {
                                            if ( isset( $variation_id ) ) {
                                                $var_id = rs_get_id( $content[ 'data' ] ) ;
                                                if ( $variation_id == $var_id ) {
                                                    $valid = false ;
                                                    wc_add_notice( get_option( 'rs_errmsg_for_point_price_product_with_same' ) , 'error' ) ;
                                                    return $valid ;
                                                }
                                            } else {
                                                $pdt_id = rs_get_id( $content[ 'data' ] ) ;
                                                if ( $product_id == $pdt_id ) {
                                                    $valid = false ;
                                                    wc_add_notice( get_option( 'rs_errmsg_for_point_price_product_with_same' ) , 'error' ) ;
                                                    return $valid ;
                                                }
                                            }
                                        } else {
                                            $valid = false ;
                                            wc_add_notice( get_option( 'rs_errmsg_for_normal_product_with_point_price' ) , 'error' ) ;
                                            return $valid ;
                                        }
                                    } else {
                                        if ( isset( $variation_id ) ) {
                                            $get_product_productid = $variation_id ;
                                        } else {
                                            $get_product_productid = $product_id ;
                                        }
                                        if ( self::check_is_point_pricing_enable( $get_product_productid ) ) {
                                            $valid = false ;
                                            wc_add_notice( get_option( 'rs_errmsg_for_point_price_product_with_normal' ) , 'error' ) ;
                                            return $valid ;
                                        } else {
                                            $valid = true ;
                                            return $valid ;
                                        }
                                    }
                                } else {
                                    if ( isset( $variation_id ) ) {
                                        $get_product_productid = $variation_id ;
                                    } else {
                                        $get_product_productid = $product_id ;
                                    }
                                    if ( self::check_is_point_pricing_enable( $get_product_productid ) ) {
                                        if ( self::check_cart_contain_subscription() ) {
                                            $valid = false ;
                                            wc_add_notice( "You cannot add more than one product" , 'error' ) ;
                                            return $valid ;
                                        } else {
                                            WC()->cart->empty_cart() ;
                                            $valid = true ;
                                            wc_add_notice( "Cannot add normal product with point pricing product" , 'error' ) ;
                                            return $valid ;
                                        }
                                    } else {

                                        $valid = true ;
                                        return $valid ;
                                    }
                                }
                            }
                        }
                        if ( ! is_user_logged_in() ) {
                            if ( self::check_is_point_pricing_enable( $product_id ) ) {
                                $valid = false ;
                                wc_add_notice( "Please signup to purchase this product" , 'error' ) ;
                                return $valid ;
                            }
                        }
                    }
                }
            }
            return $valid ;
        }

        public static function check_is_point_pricing_enable( $product_id ) {
            if ( get_option( 'rs_enable_disable_point_priceing' ) == '1' && get_option( 'rs_point_price_activated' ) == 'yes' ) {

                $termid                    = '' ;
                //Product Level
                $points                    = RSFunctionForSavingMetaValues::rewardsystem_get_post_meta( $product_id , '_rewardsystem__points' ) ;
                $enable                    = RSFunctionForSavingMetaValues::rewardsystem_get_post_meta( $product_id , '_rewardsystem_enable_point_price' ) ;
                $checkenablevariation      = RSFunctionForSavingMetaValues::rewardsystem_get_post_meta( $product_id , '_enable_reward_points_price' ) ;
                $variablerewardpoints      = RSFunctionForSavingMetaValues::rewardsystem_get_post_meta( $product_id , 'price_points' ) ;
                $point_price_type          = RSFunctionForSavingMetaValues::rewardsystem_get_post_meta( $product_id , '_enable_reward_points_price_type' ) ;
                $point_based_on_conversion = RSFunctionForSavingMetaValues::rewardsystem_get_post_meta( $product_id , '_price_points_based_on_conversion' ) ;
                $simple_product_type       = RSFunctionForSavingMetaValues::rewardsystem_get_post_meta( $product_id , '_rewardsystem_point_price_type' ) ;
                $simple_product_price      = RSFunctionForSavingMetaValues::rewardsystem_get_post_meta( $product_id , '_rewardsystem__points_based_on_conversion' ) ;
                $typeofprice               = RSFunctionForSavingMetaValues::rewardsystem_get_post_meta( $product_id , '_rewardsystem_enable_point_price_type' ) ;
                RSFunctionForSavingMetaValues::rewardsystem_get_post_meta( $product_id , '_rewardsystem_enable_point_price_type' ) ;
                $productlevel              = RSFunctionForSavingMetaValues::rewardsystem_get_post_meta( $product_id , '_rewardsystem_enable_point_price' ) != '' ? RSFunctionForSavingMetaValues::rewardsystem_get_post_meta( $product_id , '_rewardsystem_enable_point_price' ) : RSFunctionForSavingMetaValues::rewardsystem_get_post_meta( $product_id , '_enable_reward_points_price' ) ;
                $productlevelrewardtype    = RSFunctionForSavingMetaValues::rewardsystem_get_post_meta( $product_id , '_rewardsystem_point_price_type' ) != '' ? RSFunctionForSavingMetaValues::rewardsystem_get_post_meta( $product_id , '_rewardsystem_point_price_type' ) : RSFunctionForSavingMetaValues::rewardsystem_get_post_meta( $product_id , '_enable_reward_points_price_type' ) ;
                $productlevelrewardpoints  = RSFunctionForSavingMetaValues::rewardsystem_get_post_meta( $product_id , '_rewardsystem__points' ) != '' ? RSFunctionForSavingMetaValues::rewardsystem_get_post_meta( $product_id , '_rewardsystem__points' ) : RSFunctionForSavingMetaValues::rewardsystem_get_post_meta( $product_id , 'price_points' ) ;
                $productdispalytype        = RSFunctionForSavingMetaValues::rewardsystem_get_post_meta( $product_id , '_rewardsystem_enable_point_price_type' ) != '' ? RSFunctionForSavingMetaValues::rewardsystem_get_post_meta( $product_id , '_rewardsystem_enable_point_price_type' ) : RSFunctionForSavingMetaValues::rewardsystem_get_post_meta( $product_id , '_enable_reward_points_pricing_type' ) ;
                if ( ($productlevel == 'yes') || ($productlevel == '1') ) {
                    if ( $productdispalytype == '2' ) {
                        if ( $productlevelrewardpoints != '' ) {
                            return true ;
                        } else {
                            return false ;
                        }
                    }
                } else {
                    return false ;
                }
            }
        }

        /* Function for hiding the couon field */

        public static function show_hide_coupon_code() {
            if ( is_cart() || is_checkout() ) {
                global $woocommerce ;
                $type = array() ;
                if ( ! is_user_logged_in() ) {
                    if ( is_array( $woocommerce->cart->get_applied_coupons() ) ) {
                        foreach ( $woocommerce->cart->get_applied_coupons() as $coupons ) {
                            if ( strpos( $coupons , 'sumo_' ) !== false ) {
                                WC()->cart->remove_coupon( $coupons ) ;
                            }
                            if ( strpos( $coupons , 'auto_redeem_' ) !== false ) {
                                WC()->cart->remove_coupon( $coupons ) ;
                            }
                        }
                    }
                }
                $type = array() ;
                foreach ( $woocommerce->cart->cart_contents as $item ) {
                    $product_id = $item[ 'variation_id' ] != 0 ? $item[ 'variation_id' ] : $item[ 'product_id' ] ;
                    $type[]     = check_display_price_type( $product_id ) ;
                    $enable     = calculate_point_price_for_products( $product_id ) ;
                    if ( $enable[ $product_id ] != '' ) {
                        $cart_object[] = $enable[ $product_id ] ;
                    }
                }
                if ( ! empty( $cart_object ) ) {
                    ?>
                    <style type="text/css">
                        .coupon{
                            display: none;
                        }
                        .showcoupon {
                            display: none;
                        }

                    </style>
                    <?php
                }

                if ( in_array( 2 , $type ) ) {
                    ?>
                    <style type="text/css">
                        .coupon{
                            display: none;
                        }
                        .showcoupon {
                            display: none;
                        }

                    </style>
                    <?php
                }
            }
        }

        public static function display_total_earned_points( $param ) {
            if ( ! is_user_logged_in() )
                return ;

            if ( get_option( 'rs_product_purchase_activated' ) == 'no' )
                return ;

            if ( get_option( 'rs_show_hide_total_points_cart_field' ) == '2' )
                return ;

            global $buying_pointsnew ;
            global $totalrewardpoints_payment_plan ;
            global $buying_pts_payment_plan ;
            $points_info         = array() ;
            $OrderTotal          = 0 ;
            $pdt_plan_pts        = 0 ;
            $buying_pdt_plan_pts = 0 ;
            $payment_plan_pts    = 0 ;
            $total               = WC()->cart->discount_cart ;
            $Setup               = get_option( 'rs_enable_product_category_level_for_product_purchase' ) ;
            $RewardPointsBasedOn = get_option( 'rs_award_points_for_cart_or_product_total' ) ;
            if ( $Setup == 'no' && $RewardPointsBasedOn == '2' ) {
                $OrderTotal = WC()->cart->total ;
                $OrderTotal = get_reward_points_based_on_cart_total( $OrderTotal ) ;
                $OrderTotal = RSMemberFunction::user_role_based_reward_points( get_current_user_id() , $OrderTotal ) ;
                if ( $OrderTotal == 0 )
                    return ;

                $getcals      = $OrderTotal / wc_format_decimal( get_option( 'rs_redeem_point' ) ) ;
                $point_amount = RSMemberFunction::user_role_based_redeem_points( get_current_user_id() ) ;
                $updatedvalue = $getcals * $point_amount ;
            } else {
                $TotalPoints = WC()->session->get( 'rewardpoints' ) ;
                if ( $TotalPoints == 0 )
                    return ;

                if ( get_option( 'rs_enable_disable_reward_point_based_coupon_amount' ) == 'yes' ) {
                    $points_info = self::moified_points_for_products_in_cart() ;
                } else {
                    $points_info = self::original_points_for_product_in_cart() ;
                }
                if ( is_array( $totalrewardpoints_payment_plan ) ) {
                    $pdt_plan_pts = round_off_type( array_sum( $totalrewardpoints_payment_plan ) ) ;
                }
                if ( is_array( $buying_pts_payment_plan ) ) {
                    $buying_pdt_plan_pts = round_off_type( array_sum( $buying_pts_payment_plan ) ) ;
                }
                $payment_plan_pts = $pdt_plan_pts + $buying_pdt_plan_pts ;
                if ( is_array( $buying_pointsnew ) && is_array( $points_info ) ) {
                    foreach ( $points_info as $pdtid => $points ) {
                        if ( array_key_exists( $pdtid , $buying_pointsnew ) ) {
                            $points_info[ $pdtid ] = floatval( ($buying_pointsnew[ $pdtid ] + $points_info[ $pdtid ] ) ) ;
                        }
                    }
                }
                $replaced_points_info = is_array( $points_info ) ? $points_info : array() ;
                $total_points         = array_sum( $replaced_points_info ) - $payment_plan_pts ;
                $getcals              = $total_points / wc_format_decimal( get_option( 'rs_redeem_point' ) ) ;
                $point_amount         = RSMemberFunction::user_role_based_redeem_points( get_current_user_id() ) ;
                $updatedvalue         = $getcals * $point_amount ;
            }
            $reward_1                    = round_off_type_for_currency( $updatedvalue ) ;
            $reward_value                = get_woocommerce_formatted_price( $reward_1 ) ;
            $message                     = '' ;
            $eq_price_enable             = 'rs_show_hide_equivalent_price_for_points_cart' ;
            $custom_msg_enable           = 'rs_show_hide_custom_msg_for_points_cart' ;
            $custom_msg                  = 'rs_custom_message_for_points_cart' ;
            $points_to_be_earned_message = get_option( 'rs_total_earned_point_caption' ) ;
            if ( $total != 0 ) {
                if ( get_option( 'rs_enable_redeem_for_order' ) == 'no' && get_option( 'rs_disable_point_if_coupon' ) == 'no' ) {
                    ?>
                    <div class="points_total" >
                        <tr class="points-totalvalue">
                            <th><?php echo $points_to_be_earned_message ; ?></th>
                            <td data-title="<?php esc_attr_e( $points_to_be_earned_message , 'rewardsystem' ) ; ?>"><?php echo display_custom_message_in_point_can_earned( $OrderTotal , $points_info , $message , $reward_value , $eq_price_enable , $custom_msg_enable , $custom_msg , $payment_plan_pts ) ; ?> </td>
                        </tr>
                    </div>
                    <?php
                }
            } else {
                ?>
                <div class="points_total" >
                    <tr class="points-totalvalue">
                        <th><?php echo $points_to_be_earned_message ; ?></th>
                        <td data-title="<?php esc_attr_e( $points_to_be_earned_message , 'rewardsystem' ) ; ?>"><?php echo display_custom_message_in_point_can_earned( $OrderTotal , $points_info , $message , $reward_value , $eq_price_enable , $custom_msg_enable , $custom_msg , $payment_plan_pts ) ; ?> </td>
                    </tr>
                </div>
                <?php
            }
        }

        public static function reward_system_add_redeem_message_after_cart_table() {
            $memebershiprestrict = 'no' ;
            $arr                 = array() ;
            if ( get_option( 'rs_restrict_redeem_when_no_membership_plan' ) == 'yes' && function_exists( 'sumo_get_membership_levels' ) ) {
                $memebershiprestrict = 'yes' ;
                $arr                 = sumo_get_membership_levels() ;
                if ( ! empty( $arr ) ) {
                    $memebershiprestrict = 'no' ;
                }
            }
            if ( $memebershiprestrict == 'no' ) {
                if ( is_user_logged_in() ) {
                    if ( get_option( 'rs_redeem_field_type_option' ) == '1' && get_option( 'rs_redeeming_activated' ) == 'yes' ) {
                        global $woocommerce ;
                        $minimum_cart_total_redeem = get_option( 'rs_minimum_cart_total_points' ) ;
                        $maximum_cart_total_redeem = get_option( 'rs_maximum_cart_total_points' ) ;
                        $current_carttotal_amount  = self::rs_line_subtotal_for_redeeming_restriction() ;
                        if ( $minimum_cart_total_redeem != '' && $maximum_cart_total_redeem != '' ) {
                            if ( $current_carttotal_amount >= $minimum_cart_total_redeem && $current_carttotal_amount <= $maximum_cart_total_redeem ) {
                                self::reward_system_add_message_after_cart_table() ;
                            }
                        } else if ( $minimum_cart_total_redeem != '' && $maximum_cart_total_redeem == '' ) {
                            if ( $current_carttotal_amount >= $minimum_cart_total_redeem ) {
                                self::reward_system_add_message_after_cart_table() ;
                            }
                        } else if ( $minimum_cart_total_redeem == '' && $maximum_cart_total_redeem != '' ) {
                            if ( $current_carttotal_amount <= $maximum_cart_total_redeem ) {
                                self::reward_system_add_message_after_cart_table() ;
                            }
                        } else if ( $minimum_cart_total_redeem == '' && $maximum_cart_total_redeem == '' ) {
                            self::reward_system_add_message_after_cart_table() ;
                        }
                    }
                }
            }
        }

        public static function rs_check_whether_to_display_redeem_field() {
            $HideRedeemField = get_option( 'rs_hide_redeeming_field' ) ;
            if ( $HideRedeemField == '1' )
                return true ;

            global $woocommerce ;
            $ProductIds                      = array() ;
            $return                          = true ;
            $EnableRedeemForIncludedProduct  = get_option( 'rs_enable_redeem_for_selected_products' ) ;
            $EnableRedeemForExcludedProduct  = get_option( 'rs_exclude_products_for_redeeming' ) ;
            $EnableRedeemForInlcudedCategory = get_option( 'rs_enable_redeem_for_selected_category' ) ;
            $EnableRedeemForExcludedCategory = get_option( 'rs_exclude_category_for_redeeming' ) ;
            foreach ( $woocommerce->cart->cart_contents as $item ) {
                if ( $EnableRedeemForExcludedProduct == 'yes' ) {
                    if ( ! self::check_exc_products( $item ) )
                        return false ;
                }

                if ( $EnableRedeemForExcludedCategory == 'yes' ) {
                    if ( ! self::check_exc_categories( $item ) )
                        return false ;
                }

                if ( $EnableRedeemForIncludedProduct == 'yes' ) {
                    $return = self::check_inc_products( $item ) ;
                    if ( $return )
                        return true ;
                }

                if ( $EnableRedeemForInlcudedCategory == 'yes' ) {
                    $return = self::check_inc_categories( $item ) ;
                    if ( $return )
                        return true ;
                }
            }
            return $return ;
        }

        public static function check_inc_products( $item ) {
            $ProductId = ($item[ 'variation_id' ] != 0 || $item[ 'variation_id' ] != '') ? $item[ 'variation_id' ] : $item[ 'product_id' ] ;

            if ( ! is_array( get_option( 'rs_select_products_to_enable_redeeming' ) ) ) {
                $IncludeProducts = get_option( 'rs_select_products_to_enable_redeeming' ) != '' ? explode( ',' , get_option( 'rs_select_products_to_enable_redeeming' ) ) : array() ;
            } else {
                $IncludeProducts = get_option( 'rs_select_products_to_enable_redeeming' ) ;
            }

            if ( ! is_array( $IncludeProducts ) || empty( $IncludeProducts ) )
                return true ;

            if ( in_array( $ProductId , $IncludeProducts ) )
                return true ;

            return false ;
        }

        public static function check_exc_products( $item ) {
            $ProductId = ($item[ 'variation_id' ] != 0 || $item[ 'variation_id' ] != '') ? $item[ 'variation_id' ] : $item[ 'product_id' ] ;

            if ( ! is_array( get_option( 'rs_exclude_products_to_enable_redeeming' ) ) ) {
                $ExcludeProducts = get_option( 'rs_exclude_products_to_enable_redeeming' ) != '' ? explode( ',' , get_option( 'rs_exclude_products_to_enable_redeeming' ) ) : array() ;
            } else {
                $ExcludeProducts = get_option( 'rs_exclude_products_to_enable_redeeming' ) ;
            }

            if ( ! is_array( $ExcludeProducts ) || empty( $ExcludeProducts ) )
                return true ;

            if ( in_array( $ProductId , $ExcludeProducts ) )
                return false ;

            return true ;
        }

        public static function check_inc_categories( $item ) {
            $ProductId = $item[ 'product_id' ] ;

            if ( ! is_array( get_option( 'rs_select_category_to_enable_redeeming' ) ) ) {
                $IncludedCategory = get_option( 'rs_select_category_to_enable_redeeming' ) != '' ? explode( ',' , get_option( 'rs_select_category_to_enable_redeeming' ) ) : array() ;
            } else {
                $IncludedCategory = get_option( 'rs_select_category_to_enable_redeeming' ) ;
            }

            if ( is_array( $IncludedCategory ) && empty( $IncludedCategory ) )
                return true ;

            $ProductCat = get_the_terms( $ProductId , 'product_cat' ) ;
            if ( ! is_array( $ProductCat ) || empty( $ProductCat ) )
                return true ;

            foreach ( $ProductCat as $Cat ) {
                $CategoryId = $Cat->term_id ;
                if ( in_array( $CategoryId , $IncludedCategory ) )
                    return true ;
            }

            return false ;
        }

        public static function check_exc_categories( $item ) {
            $ProductId = $item[ 'product_id' ] ;

            if ( ! is_array( get_option( 'rs_exclude_category_to_enable_redeeming' ) ) ) {
                $ExcludedCategory = get_option( 'rs_exclude_category_to_enable_redeeming' ) != '' ? explode( ',' , get_option( 'rs_exclude_category_to_enable_redeeming' ) ) : array() ;
            } else {
                $ExcludedCategory = get_option( 'rs_exclude_category_to_enable_redeeming' ) ;
            }

            if ( is_array( $ExcludedCategory ) && empty( $ExcludedCategory ) )
                return true ;

            $ProductCat = get_the_terms( $ProductId , 'product_cat' ) ;
            if ( ! is_array( $ProductCat ) || empty( $ProductCat ) )
                return true ;

            foreach ( $ProductCat as $Cat ) {
                $CategoryId = $Cat->term_id ;
                if ( in_array( $CategoryId , $ExcludedCategory ) )
                    return false ;
            }

            return true ;
        }

        public static function reward_system_add_message_after_cart_table() {
            $type         = array() ;
            $userid       = get_current_user_id() ;
            $banning_type = FPRewardSystem::check_banning_type( $userid ) ;
            if ( $banning_type != 'redeemingonly' && $banning_type != 'both' ) {
                ?>
                <style type="text/css">
                <?php echo get_option( 'rs_cart_page_custom_css' ) ; ?>
                </style>
                <?php
                global $woocommerce ;
                global $coupon_code ;
                if ( is_user_logged_in() ) {
                    $user_ID                              = get_current_user_id() ;
                    $getinfousernickname                  = get_user_by( 'id' , $user_ID ) ;
                    $couponcodeuserlogin                  = is_object( $getinfousernickname ) ? $getinfousernickname->user_login : 'Guest' ;
                    $minimum_cart_total_redeem            = get_option( 'rs_minimum_cart_total_points' ) ;
                    $cart_subtotal_redeem_amount          = self::rs_line_subtotal_for_redeeming_restriction() ;
                    $get_old_points                       = RSPointExpiry::total_available_points_in_site( $user_ID ) ;
                    $hide_message_for_point_price_product = self::rs_hide_restrict_message_for_redeeming_on_point_price() ;
                    if ( $hide_message_for_point_price_product == true ) {
                        return ;
                    }
                    if ( $get_old_points > 0 ) {
                        $coupon_code         = 'sumo_' . strtolower( $couponcodeuserlogin ) ; // Code
//Invalid Coupon fatal error                      
//$coupon = new WC_Coupon($coupon_code);
                        $checkfirstimeredeem = RSFunctionForSavingMetaValues::rewardsystem_get_user_meta( $user_ID , 'rsfirsttime_redeemed' ) ;
                        if ( $checkfirstimeredeem != '1' ) {
                            if ( $get_old_points >= get_option( "rs_first_time_minimum_user_points" ) ) {
                                if ( $cart_subtotal_redeem_amount >= $minimum_cart_total_redeem ) {
                                    $auto_redeem_name = 'auto_redeem_' . strtolower( $couponcodeuserlogin ) ;
                                    $array            = $woocommerce->cart->get_applied_coupons() ;
                                    if ( ! in_array( $auto_redeem_name , $array ) ) {
                                        foreach ( $woocommerce->cart->cart_contents as $item ) {
                                            $product_id = $item[ 'variation_id' ] != 0 ? $item[ 'variation_id' ] : $item[ 'product_id' ] ;
                                            $type[]     = check_display_price_type( $product_id ) ;
                                            $enable     = calculate_point_price_for_products( $product_id ) ;
                                            if ( $enable[ $product_id ] != '' ) {
                                                $cart_object[] = $enable[ $product_id ] ;
                                            }
                                        }
                                        if ( empty( $cart_object ) ) {
                                            if ( ! in_array( '2' , $type ) ) {
                                                if ( get_option( 'rs_redeem_field_type_option' ) == '1' ) {
                                                    if ( is_cart() && ! is_checkout() && self::rs_check_whether_to_display_redeem_field() ) {
                                                        ?>
                                                        <div class="fp_apply_reward">
                                                            <?php if ( get_option( "rs_show_hide_redeem_caption" ) == '1' ) { ?>
                                                                <label for="rs_apply_coupon_code_field"><?php echo get_option( 'rs_redeem_field_caption' ) ; ?></label>
                                                            <?php } ?>
                                                            <?php
                                                            $placeholder = '' ;
                                                            if ( get_option( 'rs_show_hide_redeem_placeholder' ) == '1' ) {
                                                                $placeholder = get_option( 'rs_redeem_field_placeholder' ) ;
                                                            }
                                                            ?>
                                                            <input id="rs_apply_coupon_code_field" class="input-text" type="text" placeholder="<?php echo $placeholder ; ?>" value="" name="rs_apply_coupon_code_field">
                                                            <input class="button <?php echo get_option( 'rs_extra_class_name_apply_reward_points' ) ; ?>" type="submit" id='mainsubmi' value="<?php echo get_option( 'rs_redeem_field_submit_button_caption' ) ; ?>" name="rs_apply_coupon_code">
                                                        </div>
                                                        <div class='rs_warning_message' style='display:inline-block;color:red'></div>
                                                        <?php
                                                    }
                                                }
                                                if ( get_option( 'rs_redeem_field_type_option_checkout' ) == '1' ) {
                                                    if ( is_checkout() ) {
                                                        ?>
                                                        <div class="fp_apply_reward">
                                                            <?php if ( get_option( "rs_show_hide_redeem_caption" ) == '1' ) { ?>
                                                                <label for="rs_apply_coupon_code_field"><?php echo get_option( 'rs_redeem_field_caption' ) ; ?></label>
                                                            <?php } ?>
                                                            <?php
                                                            $placeholder = '' ;
                                                            if ( get_option( 'rs_show_hide_redeem_placeholder' ) == '1' ) {
                                                                $placeholder = get_option( 'rs_redeem_field_placeholder' ) ;
                                                            }
                                                            ?>
                                                            <input id="rs_apply_coupon_code_field" class="input-text" type="text" placeholder="<?php echo $placeholder ; ?>" value="" name="rs_apply_coupon_code_field">
                                                            <input class="button <?php echo get_option( 'rs_extra_class_name_apply_reward_points' ) ; ?>" type="submit" id='mainsubmi' value="<?php echo get_option( 'rs_redeem_field_submit_button_caption' ) ; ?>" name="rs_apply_coupon_code">
                                                        </div>
                                                        <div class='rs_warning_message' style='display:inline-block;color:red'></div>
                                                        <?php
                                                    }
                                                }
                                            }
                                        }
                                    }
                                } else {
                                    if ( get_option( 'rs_show_hide_minimum_cart_total_error_message' ) == '1' ) {
                                        $userid       = get_current_user_id() ;
                                        $banning_type = FPRewardSystem::check_banning_type( $userid ) ;
                                        if ( $banning_type != 'redeemingonly' && $banning_type != 'both' ) {
                                            $min_cart_total_redeeming           = get_option( 'rs_min_cart_total_redeem_error' ) ;
                                            $min_cart_amount_to_find            = "[carttotal]" ;
                                            $min_cart_total_currency_to_find    = "[currencysymbol]" ;
                                            $min_cart_amount_to_replace         = get_option( 'rs_minimum_cart_total_points' ) ;
                                            $min_cart_total_currency_to_replace = get_woocommerce_formatted_price( round_off_type_for_currency( $min_cart_amount_to_replace ) ) ;
                                            $min_cart_total_msg1                = str_replace( $min_cart_amount_to_find , $min_cart_total_currency_to_replace , $min_cart_total_redeeming ) ;
                                            $min_cart_total_replaced            = str_replace( $min_cart_total_currency_to_find , "" , $min_cart_total_msg1 ) ;
                                            ?>
                                            <div class="woocommerce-info"><?php echo $min_cart_total_replaced ; ?></div>
                                            <?php
                                        }
                                    }
                                }
                            } else {
                                if ( get_option( 'rs_show_hide_first_redeem_error_message' ) == '1' ) {
                                    $userid       = get_current_user_id() ;
                                    $banning_type = FPRewardSystem::check_banning_type( $userid ) ;
                                    if ( $banning_type != 'redeemingonly' && $banning_type != 'both' ) {
                                        $rs_first_redeem_message    = get_option( 'rs_min_points_first_redeem_error_message' ) ;
                                        $rs_first_redeem_to_find    = "[firstredeempoints]" ;
                                        $rs_first_redeem_to_replace = get_option( 'rs_first_time_minimum_user_points' ) ;
                                        $rs_first_redeem_replaced   = str_replace( $rs_first_redeem_to_find , $rs_first_redeem_to_replace , $rs_first_redeem_message ) ;
                                        ?>
                                        <div class="woocommerce-info"><?php echo $rs_first_redeem_replaced ; ?></div>
                                        <?php
                                    }
                                }
                            }
                        } else {
                            if ( $get_old_points >= get_option( "rs_minimum_user_points_to_redeem" ) ) {
                                if ( $cart_subtotal_redeem_amount >= $minimum_cart_total_redeem ) {
                                    $auto_redeem_name = 'auto_redeem_' . strtolower( $couponcodeuserlogin ) ;
                                    $array            = $woocommerce->cart->get_applied_coupons() ;
                                    if ( ! in_array( $auto_redeem_name , $array ) ) {
                                        foreach ( $woocommerce->cart->cart_contents as $item ) {
                                            $product_id = $item[ 'variation_id' ] != 0 ? $item[ 'variation_id' ] : $item[ 'product_id' ] ;
                                            $type[]     = check_display_price_type( $product_id ) ;
                                            $enable     = calculate_point_price_for_products( $product_id ) ;
                                            if ( $enable[ $product_id ] != '' ) {
                                                $cart_object[] = $enable[ $product_id ] ;
                                            }
                                        }
                                        if ( empty( $cart_object ) ) {
                                            if ( ! in_array( 2 , $type ) ) {
                                                if ( get_option( 'rs_redeem_field_type_option' ) == '1' ) {
                                                    if ( is_cart() && ! is_checkout() && self::rs_check_whether_to_display_redeem_field() ) {
                                                        ?>
                                                        <div class="fp_apply_reward">
                                                            <?php if ( get_option( "rs_show_hide_redeem_caption" ) == '1' ) { ?>
                                                                <label for="rs_apply_coupon_code_field"><?php echo get_option( 'rs_redeem_field_caption' ) ; ?></label>
                                                            <?php } ?>
                                                            <?php
                                                            $placeholder = '' ;
                                                            if ( get_option( 'rs_show_hide_redeem_placeholder' ) == '1' ) {
                                                                $placeholder = get_option( 'rs_redeem_field_placeholder' ) ;
                                                            }
                                                            ?>
                                                            <input id="rs_apply_coupon_code_field" class="input-text" type="text" placeholder="<?php echo $placeholder ; ?>" value="" name="rs_apply_coupon_code_field">
                                                            <input class="button <?php echo get_option( 'rs_extra_class_name_apply_reward_points' ) ; ?>" type="submit" id='mainsubmi' value="<?php echo get_option( 'rs_redeem_field_submit_button_caption' ) ; ?>" name="rs_apply_coupon_code">
                                                        </div>
                                                        <div class='rs_warning_message' style='display:inline-block;color:red'></div>
                                                        <?php
                                                    }
                                                }
                                                if ( get_option( 'rs_redeem_field_type_option_checkout' ) == '1' ) {
                                                    if ( is_checkout() ) {
                                                        ?>
                                                        <div class="fp_apply_reward">
                                                            <?php if ( get_option( "rs_show_hide_redeem_caption" ) == '1' ) { ?>
                                                                <label for="rs_apply_coupon_code_field"><?php echo get_option( 'rs_redeem_field_caption' ) ; ?></label>
                                                            <?php } ?>
                                                            <?php
                                                            $placeholder = '' ;
                                                            if ( get_option( 'rs_show_hide_redeem_placeholder' ) == '1' ) {
                                                                $placeholder = get_option( 'rs_redeem_field_placeholder' ) ;
                                                            }
                                                            ?>
                                                            <input id="rs_apply_coupon_code_field" class="input-text" type="text" placeholder="<?php echo $placeholder ; ?>" value="" name="rs_apply_coupon_code_field">
                                                            <input class="button <?php echo get_option( 'rs_extra_class_name_apply_reward_points' ) ; ?>" type="submit" id='mainsubmi' value="<?php echo get_option( 'rs_redeem_field_submit_button_caption' ) ; ?>" name="rs_apply_coupon_code">
                                                        </div>
                                                        <div class='rs_warning_message' style='display:inline-block;color:red'></div>
                                                        <?php
                                                    }
                                                }
                                            }
                                        }
                                    }
                                } else {
                                    if ( get_option( 'rs_show_hide_minimum_cart_total_error_message' ) == '1' ) {
                                        $userid       = get_current_user_id() ;
                                        $banning_type = FPRewardSystem::check_banning_type( $userid ) ;
                                        if ( $banning_type != 'redeemingonly' && $banning_type != 'both' ) {
                                            $min_cart_total_redeeming           = get_option( 'rs_min_cart_total_redeem_error' ) ;
                                            $min_cart_amount_to_find            = "[carttotal]" ;
                                            $min_cart_total_currency_to_find    = "[currencysymbol]" ;
                                            $min_cart_amount_to_replace         = get_option( 'rs_minimum_cart_total_points' ) ;
                                            $min_cart_total_currency_to_replace = get_woocommerce_formatted_price( round_off_type_for_currency( $min_cart_amount_to_replace ) ) ;
                                            $min_cart_total_msg1                = str_replace( $min_cart_amount_to_find , $min_cart_total_currency_to_replace , $min_cart_total_redeeming ) ;
                                            $min_cart_total_replaced            = str_replace( $min_cart_total_currency_to_find , "" , $min_cart_total_msg1 ) ;
                                            ?>
                                            <div class="woocommerce-info"><?php echo $min_cart_total_replaced ; ?></div>
                                            <?php
                                        }
                                    }
                                }
                            } else {
                                if ( get_option( 'rs_show_hide_after_first_redeem_error_message' ) == '1' ) {
                                    $userid       = get_current_user_id() ;
                                    $banning_type = FPRewardSystem::check_banning_type( $userid ) ;
                                    if ( $banning_type != 'redeemingonly' && $banning_type != 'both' ) {
                                        $rs_minpoints_after_first_redeem = get_option( 'rs_min_points_after_first_error' ) ;
                                        $min_points_to_replace           = get_option( 'rs_minimum_user_points_to_redeem' ) ;
                                        $min_points_to_find              = "[points_after_first_redeem]" ;
                                        $min_points_after_first_replaced = str_replace( $min_points_to_find , $min_points_to_replace , $rs_minpoints_after_first_redeem ) ;
                                        ?>
                                        <div class="woocommerce-info"><?php echo $min_points_after_first_replaced ; ?></div>
                                        <?php
                                    }
                                }
                            }
                            ?>

                            <?php
                        }
                    } else {
                        $bool = self::hide_redeem_error_message_for_pointprice_products() ;
                        if ( get_option( 'rs_show_hide_points_empty_error_message' ) == '1' && get_option( 'rs_redeeming_activated' ) == 'yes' && $bool == true ) {
                            $userid       = get_current_user_id() ;
                            $banning_type = FPRewardSystem::check_banning_type( $userid ) ;
                            if ( $banning_type != 'redeemingonly' && $banning_type != 'both' ) {
                                $user_points_empty_message = get_option( 'rs_current_points_empty_error_message' ) ;
                                ?>
                                <div class="woocommerce-info"><?php echo $user_points_empty_message ; ?></div>
                                <?php
                            }
                        }
                    }
                }
            }
        }

        /* Function to get the reward points to be displayed in message in cart and checkout */

        public static function hide_redeem_error_message_for_pointprice_products() {
            global $woocommerce ;
            if ( get_option( 'rs_point_price_activated' ) == 'yes' ) {
                if ( is_array( $woocommerce->cart->cart_contents ) && ! empty( $woocommerce->cart->cart_contents ) ) {
                    foreach ( $woocommerce->cart->cart_contents as $value ) {
                        $product_id        = $value[ 'variation_id' ] != 0 ? $value[ 'variation_id' ] : $value[ 'product_id' ] ;
                        $point_price_value = calculate_point_price_for_products( $product_id ) ;
                        $point_price_value = implode( '' , $point_price_value ) ;
                        if ( $point_price_value != '' )
                            return false ;
                    }
                }
            }
            return true ;
        }

        public static function original_points_for_product_in_cart() {
            global $checkproduct ;
            $userid       = get_current_user_id() ;
            $banning_type = FPRewardSystem::check_banning_type( $userid ) ;
            if ( $banning_type != 'earningonly' && $banning_type != 'both' ) {
                global $totalrewardpointsnew ;
                global $totalrewardpoints ;
                global $woocommerce ;
                global $value ;
                foreach ( $woocommerce->cart->cart_contents as $key => $value ) {
                    $restrictpoints = rs_function_to_restrict_points_for_product_which_has_saleprice( $value[ 'product_id' ] , $value[ 'variation_id' ] ) ;
                    if ( $restrictpoints == 'no' ) {
                        $checklevel                          = 'no' ;
                        $points                              = check_level_of_enable_reward_point( $value[ 'product_id' ] , $value[ 'variation_id' ] , $value , $checklevel , $referred_user                       = '' , $getting_referrer                    = 'no' , $socialreward                        = 'no' , $rewardfor                           = '' , $payment_price                       = 0 ) ;
                        $totalrewardpoints                   = RSMemberFunction::user_role_based_reward_points( $userid , $points ) ;
                        $product_id                          = $value[ 'variation_id' ] != (0 || '') ? $value[ 'variation_id' ] : $value[ 'product_id' ] ;
                        if ( $totalrewardpoints != 0 )
                            $totalrewardpointsnew[ $product_id ] = $totalrewardpoints ;
                    }
                }
                return $totalrewardpointsnew ;
            }
        }

        /* Function to get the buying points to be displayed in message in cart and checkout */

        public static function buying_points_for_product_in_cart() {
            global $checkproduct ;
            $userid       = get_current_user_id() ;
            $banning_type = FPRewardSystem::check_banning_type( $userid ) ;
            if ( $banning_type != 'earningonly' && $banning_type != 'both' ) {
                global $buyingmsg_global ;
                global $buying_pointsnew ;
                $rewardpoints = array( '0' ) ;
                global $woocommerce ;
                global $value ;
                foreach ( $woocommerce->cart->cart_contents as $key => $value ) {
                    $restrictpoints = rs_function_to_restrict_points_for_product_which_has_saleprice( $value[ 'product_id' ] , $value[ 'variation_id' ] ) ;
                    if ( $restrictpoints == 'no' ) {
                        $product_id          = $value[ 'product_id' ] != (0 || '') ? $value[ 'product_id' ] : $value[ 'product_id' ] ;
                        $buying_points       = get_post_meta( $product_id , '_rewardsystem_assign_buying_points' , true ) ;
                        $buying_point_enable = get_post_meta( $product_id , '_rewardsystem_buying_reward_points' , true ) ;
                        $buying_point_pdt    = get_post_meta( $product_id , '_rewardsystem_assign_buying_points' , true ) ;
                        if ( $buying_point_enable == 'yes' && $buying_point_pdt != '' ) {
                            $buying_pointsnew[ $product_id ] = $buying_points * $value[ 'quantity' ] ;
                        }
                    }
                }
                return $buying_pointsnew ;
            }
        }

        public static function referrel_points_for_product_in_cart() {
            global $checkproduct ;
            $user_id   = isset( $_COOKIE[ 'rsreferredusername' ] ) ? $_COOKIE[ 'rsreferredusername' ] : 0 ;
            $user_info = get_user_by( 'login' , $user_id ) ;
            if ( $user_info != false ) {
                $userid = $user_info->ID ;
            } else {
                $userid = $user_id ;
            }
            $referral_pointsnew = array() ;
            $banning_type       = FPRewardSystem::check_banning_type( $userid ) ;
            if ( $banning_type != 'earningonly' && $banning_type != 'both' ) {
                global $referralmsg_global ;
                global $referral_pointsnew ;
                $rewardpoints = array( '0' ) ;
                global $woocommerce ;
                global $value ;
                foreach ( $woocommerce->cart->cart_contents as $key => $value ) {
                    $restrictpoints = rs_function_to_restrict_points_for_product_which_has_saleprice( $value[ 'product_id' ] , $value[ 'variation_id' ] ) ;
                    if ( $restrictpoints == 'no' ) {
                        $checklevel                        = 'no' ;
                        $points                            = check_level_of_enable_reward_point( $value[ 'product_id' ] , $value[ 'variation_id' ] , $value , $checklevel , $referred_user                     = 'yes' , $getting_referrer                  = 'no' , $socialreward                      = 'no' , $rewardfor                         = '' , $payment_price                     = 0 ) ;
                        $referralrewardpoints              = RSMemberFunction::user_role_based_reward_points( $userid , $points ) ;
                        $product_id                        = $value[ 'variation_id' ] != (0 || '') ? $value[ 'variation_id' ] : $value[ 'product_id' ] ;
                        $referral_pointsnew[ $product_id ] = $referralrewardpoints ;
                    }
                }
            }
            return $referral_pointsnew ;
        }

        public static function check_the_applied_coupons() {
            global $woocommerce ;
            if ( get_option( '_rs_not_allow_earn_points_if_sumo_coupon' ) == 'yes' ) {
                if ( is_array( $woocommerce->cart->get_applied_coupons() ) ) {
                    $getappliedcoupon = $woocommerce->cart->get_applied_coupons() ;
                    if ( ! empty( $getappliedcoupon ) ) {
                        foreach ( $woocommerce->cart->get_applied_coupons() as $coupons ) {
                            $coupon_id_array = new WC_Coupon( $coupons ) ;
                            $coupon_obj      = rs_get_coupon_obj( $coupon_id_array ) ;
                            $coupon_id       = $coupon_obj[ 'coupon_id' ] ;
                            $getd            = get_post_meta( $coupon_id , 'sumo_coupon_check' , true ) ;
                            if ( $getd == 'yes' ) {
                                return true ;
                            }
                        }
                    } else {
                        return false ;
                    }
                }
            }
            if ( get_option( 'rs_enable_redeem_for_order' ) == 'yes' ) {
                if ( is_array( $woocommerce->cart->get_applied_coupons() ) ) {
                    $getappliedcoupon = $woocommerce->cart->get_applied_coupons() ;
                    if ( ! empty( $getappliedcoupon ) ) {
                        $currentuserid       = get_current_user_id() ;
                        $user_ID             = get_current_user_id() ;
                        $getinfousernickname = get_user_by( 'id' , $user_ID ) ;
                        $couponcodeuserlogin = is_object( $getinfousernickname ) ? $getinfousernickname->user_login : 'Guest' ;
                        $usernickname        = 'sumo_' . strtolower( "$couponcodeuserlogin" ) ;
                        $auto_redeem_name    = 'auto_redeem_' . strtolower( $couponcodeuserlogin ) ;
                        foreach ( $woocommerce->cart->get_applied_coupons() as $coupons ) {
                            if ( strtolower( $coupons ) == $usernickname || strtolower( $coupons ) == $auto_redeem_name ) {
                                return true ;
                            } else {
                                if ( get_option( 'rs_disable_point_if_coupon' ) == 'yes' ) {
                                    if ( ! empty( $getappliedcoupon ) ) {
                                        return true ;
                                    }
                                }
                                return false ;
                            }
                        }
                    } else {
                        return false ;
                    }
                }
            } else {
                if ( get_option( 'rs_disable_point_if_coupon' ) == 'yes' ) {
                    if ( is_array( $woocommerce->cart->get_applied_coupons() ) ) {
                        $getappliedcoupon = $woocommerce->cart->get_applied_coupons() ;
                        if ( ! empty( $getappliedcoupon ) ) {
                            $currentuserid       = get_current_user_id() ;
                            $user_ID             = get_current_user_id() ;
                            $getinfousernickname = get_user_by( 'id' , $user_ID ) ;
                            $couponcodeuserlogin = is_object( $getinfousernickname ) ? $getinfousernickname->user_login : 'Guest' ;
                            $usernickname        = 'sumo_' . strtolower( "$couponcodeuserlogin" ) ;
                            $auto_redeem_name    = 'auto_redeem_' . strtolower( $couponcodeuserlogin ) ;
                            foreach ( $woocommerce->cart->get_applied_coupons() as $coupons ) {
                                if ( $coupons == $usernickname ) {
                                    return false ;
                                }
                                if ( $coupons == $auto_redeem_name ) {
                                    return false ;
                                }
                                return true ;
                            }
                        } else {
                            return false ;
                        }
                    }
                }

                return false ;
            }
        }

        public static function display_msg_in_cart_page() {
            global $woocommerce ;
            global $value ;
            global $totalrewardpointsnew ;
            global $messageglobal ;
            global $buyingmsg_global ;
            global $referralmsg_global ;
            global $totalrewardpoints_payment_plan ;
            $condition_for_showing_msgs = false ;
            if ( (is_array( $totalrewardpointsnew ) && ! empty( $totalrewardpointsnew ) && array_sum( $totalrewardpointsnew ) > 0 && get_option( 'rs_show_hide_message_for_each_products' ) == '1') || (is_array( $buyingmsg_global ) && $buyingmsg_global != NULL && get_option( 'rs_show_hide_buy_point_message_for_each_products' ) == '1') ) {
                $condition_for_showing_msgs = true ;
            }
            if ( get_option( 'rs_show_hide_message_for_total_points_referrel' ) == '1' && get_option( 'rs_referral_activated' ) == 'yes' ) {
                if ( is_array( $referralmsg_global ) && $referralmsg_global != NULL ) {
                    foreach ( $referralmsg_global as $globalcommerces ) {
                        ?>
                        <div class="woocommerce-info">
                            <?php
                            echo $globalcommerces ;
                            ?>
                        </div>
                        <?php
                    }
                }
            }
            if ( is_user_logged_in() ) {
                $checkenableoption = self::check_the_applied_coupons() ;
                if ( $condition_for_showing_msgs && $checkenableoption == false ) {
                    if ( $messageglobal != null || $buyingmsg_global != null ) {
                        ?>
                        <div class="woocommerce-info sumo_reward_points_info_message rs_cart_message">
                            <?php
                            if ( get_option( 'rs_show_hide_message_for_each_products' ) == '1' ) {
                                if ( is_array( $totalrewardpointsnew ) ) {
                                    if ( ! empty( $totalrewardpointsnew ) ) {
                                        if ( array_sum( $totalrewardpointsnew ) > 0 ) {
                                            if ( is_array( $messageglobal ) && $messageglobal != NULL ) {
                                                foreach ( $messageglobal as $globalcommerce ) {
                                                    echo $globalcommerce ;
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                            if ( get_option( 'rs_show_hide_buy_point_message_for_each_products' ) == '1' ) {
                                if ( is_array( $buyingmsg_global ) && $buyingmsg_global != NULL ) {
                                    foreach ( $buyingmsg_global as $globalcommerces ) {
                                        echo $globalcommerces ;
                                    }
                                }
                            }
                            ?></div>
                        <?php
                    }
                }
            } else {
                $checkenableoption = self::check_the_applied_coupons() ;
                if ( $condition_for_showing_msgs && $checkenableoption == false ) {
                    if ( get_option( 'rs_enable_acc_creation_for_guest_checkout_page' ) == 'yes' && get_option( 'rs_show_hide_message_for_each_products' ) == '1' ) {
                        ?>
                        <div class="woocommerce-info sumo_reward_points_info_message rs_cart_message">
                            <?php
                            if ( is_array( $messageglobal ) && $messageglobal != NULL ) {

                                foreach ( $messageglobal as $globalcommerce ) {
                                    echo $globalcommerce ;
                                }
                            }
                            if ( is_array( $buyingmsg_global ) && $buyingmsg_global != NULL ) {
                                foreach ( $buyingmsg_global as $globalcommerces ) {
                                    ?>
                                    <div class="woocommerce-info">
                                        <?php
                                        echo $globalcommerces ;
                                        ?>
                                    </div>
                                    <?php
                                }
                            }
                            ?>

                        </div>
                        <?php
                    }
                }
            }
        }

        public static function display_msg_in_cart_page_for_balance_reward_points() {
            global $woocommerce ;
            if ( is_user_logged_in() ) {
                if ( get_option( 'rs_disable_point_if_coupon' ) == 'yes' ) {
                    foreach ( $woocommerce->cart->get_applied_coupons() as $coupons ) {

                        $user_ID             = get_current_user_id() ;
                        $getinfousernickname = get_user_by( 'id' , $user_ID ) ;
                        $couponcodeuserlogin = $getinfousernickname->user_login ;
                        $usernickname        = 'sumo_' . strtolower( "$couponcodeuserlogin" ) ;
                        $auto_redeem_name    = 'auto_redeem_' . strtolower( "$couponcodeuserlogin" ) ;
                        if ( strtolower( $coupons ) != $auto_redeem_name && strtolower( $coupons ) != $usernickname ) {
                            ?>
                            <div class="woocommerce-info sumo_reward_points_auto_redeem_message">
                                <?php echo get_option( 'rs_errmsg_for_coupon_in_order' ) ; ?>
                            </div>
                            <?php
                        }
                    }
                }
                if ( get_option( 'rs_show_hide_message_for_redeem_points' ) == '1' ) {
                    if ( is_array( $woocommerce->cart->get_applied_coupons() ) ) {
                        $user_ID             = get_current_user_id() ;
                        $getinfousernickname = get_user_by( 'id' , $user_ID ) ;
                        $couponcodeuserlogin = is_object( $getinfousernickname ) ? $getinfousernickname->user_login : 'Guest' ;
                        $usernickname        = 'sumo_' . strtolower( "$couponcodeuserlogin" ) ;
                        $auto_redeem_name    = 'auto_redeem_' . strtolower( "$couponcodeuserlogin" ) ;

                        if ( isset( $woocommerce->cart->coupon_discount_amounts[ "$auto_redeem_name" ] ) ) {
                            $total = $woocommerce->cart->coupon_discount_amounts[ "$auto_redeem_name" ] ;

                            if ( $total != 0 ) {
                                foreach ( $woocommerce->cart->get_applied_coupons() as $coupons ) {
                                    if ( strtolower( $coupons ) == $auto_redeem_name ) {
                                        ?>
                                        <div class="woocommerce-message sumo_reward_points_auto_redeem_message rs_cart_message">
                                            <?php echo do_shortcode( get_option( 'rs_message_user_points_redeemed_in_cart' ) ) ; ?>
                                        </div>
                                        <?php
                                        if ( get_option( 'rs_enable_redeem_for_order' ) == 'yes' ) {
                                            ?>
                                            <div class="woocommerce-info sumo_reward_points_auto_redeem_error_message">
                                                <?php echo get_option( 'rs_errmsg_for_redeeming_in_order' ) ; ?>
                                            </div>
                                            <?php
                                        }
                                    }
                                }
                            }
                        }

                        if ( isset( $woocommerce->cart->coupon_discount_amounts[ "$usernickname" ] ) ) {
                            $total = $woocommerce->cart->coupon_discount_amounts[ "$usernickname" ] ;
                            if ( $total != 0 ) {

                                foreach ( $woocommerce->cart->get_applied_coupons() as $coupons ) {
                                    if ( strtolower( $coupons ) == $usernickname || strtolower( $coupons ) == $auto_redeem_name ) {
                                        $userid       = get_current_user_id() ;
                                        $banning_type = FPRewardSystem::check_banning_type( $userid ) ;
                                        if ( $banning_type != 'redeemingonly' && $banning_type != 'both' ) {
                                            ?>
                                            <div class="woocommerce-message sumo_reward_points_manual_redeem_message rs_cart_message">
                                                <?php echo do_shortcode( get_option( 'rs_message_user_points_redeemed_in_cart' ) ) ; ?>
                                            </div>
                                            <?php
                                            /* Error Message to be Displayed When the order contain only redeeming */
                                            if ( get_option( 'rs_enable_redeem_for_order' ) == 'yes' ) {
                                                ?>
                                                <div class="woocommerce-info sumo_reward_points_manual_redeem_error_message">
                                                    <?php echo get_option( 'rs_errmsg_for_redeeming_in_order' ) ; ?>
                                                </div>
                                                <?php
                                            }
                                            if ( get_option( 'rs_redeem_field_type_option' ) == '2' ) {
                                                ?>
                                                <div class="sumo_reward_point_hide_field_script" data-sumo_coupon="yes">
                                                    <script type="text/javascript">
                                                        jQuery( document ).ready( function () {
                                                            jQuery( ".rs_button_redeem_cart" ).hide() ;
                                                        } ) ;
                                                    </script>
                                                </div>
                                                <?php
                                            } else {
                                                ?>
                                                <div class="sumo_reward_point_hide_field_script" data-sumo_coupon="yes">
                                                    <script type="text/javascript">
                                                        jQuery( document ).ready( function () {
                                                            jQuery( "#mainsubmi" ).parent().hide() ;
                                                        } ) ;
                                                    </script>
                                                </div>
                                                <?php
                                            }

                                            if ( get_option( 'rs_redeem_field_type_option_checkout' ) == '2' ) {
                                                ?>
                                                <div class="sumo_reward_point_hide_field_script" data-sumo_coupon="yes">
                                                    <script type="text/javascript">
                                                        jQuery( document ).ready( function () {
                                                            jQuery( ".rs_button_redeem_checkout" ).hide() ;
                                                        } ) ;
                                                    </script>
                                                </div>
                                                <?php
                                            }
                                        }
                                        ?>
                                        <?php
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }

        public static function display_msg_in_checkout_page() {
            global $woocommerce ;
            global $value ;
            global $totalrewardpointsnew ;
            global $messageglobal ;
            global $buyingmsg_global ;
            global $referralmsg_global ;
            $condition_for_showing_msgs_checkout = false ;
            if ( (is_array( $totalrewardpointsnew ) && ! empty( $totalrewardpointsnew ) && array_sum( $totalrewardpointsnew ) > 0 && get_option( 'rs_show_hide_message_for_each_products_checkout_page' ) == '1') || (is_array( $buyingmsg_global ) && $buyingmsg_global != NULL && get_option( 'rs_show_hide_buy_point_message_for_each_products_checkout_page' ) == '1') ) {
                $condition_for_showing_msgs_checkout = true ;
            }
            if ( get_option( 'rs_show_hide_message_for_total_points_referrel_checkout' ) == '1' && get_option( 'rs_referral_activated' ) == 'yes' ) {
                if ( is_array( $referralmsg_global ) && $referralmsg_global != NULL ) {
                    foreach ( $referralmsg_global as $globalcommerces ) {
                        ?>
                        <div class="woocommerce-info rs_checkout_message rs_checkout_each_prod_message">
                            <?php
                            echo $globalcommerces ;
                            ?>
                        </div>
                        <?php
                    }
                }
            }
            if ( is_user_logged_in() ) {
                $checkenableoption = self::check_the_applied_coupons() ;
                if ( $messageglobal != null || $buyingmsg_global != null ) {
                    if ( $condition_for_showing_msgs_checkout && $checkenableoption == false ) {
                        ?>
                        <div class="woocommerce-info rs_checkout_message rs_checkout_each_prod_message">
                            <?php
                            if ( get_option( 'rs_show_hide_message_for_each_products_checkout_page' ) == '1' ) {
                                if ( is_array( $totalrewardpointsnew ) ) {
                                    if ( array_sum( $totalrewardpointsnew ) > 0 ) {
                                        if ( is_array( $messageglobal ) && $messageglobal != NULL ) {
                                            if ( is_array( $messageglobal ) ) {
                                                foreach ( $messageglobal as $globalcommerce ) {
                                                    echo $globalcommerce ;
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                            if ( get_option( 'rs_show_hide_buy_point_message_for_each_products_checkout_page' ) == '1' ) {

                                if ( is_array( $buyingmsg_global ) && $buyingmsg_global != NULL ) {
                                    foreach ( $buyingmsg_global as $globalcommerces ) {
                                        echo $globalcommerces ;
                                    }
                                }
                            }
                            ?></div>
                        <?php
                    }
                }
            } else {
                $checkenableoption = self::check_the_applied_coupons() ;
                if ( $condition_for_showing_msgs_checkout && $checkenableoption == false ) {
                    if ( get_option( 'rs_enable_acc_creation_for_guest_checkout_page' ) == 'yes' && get_option( 'rs_show_hide_message_for_each_products_checkout_page' ) == '1' ) {
                        ?>
                        <div class="woocommerce-info rs_checkout_message rs_checkout_each_prod_message">
                            <?php
                            if ( is_array( $totalrewardpointsnew ) ) {
                                if ( array_sum( $totalrewardpointsnew ) > 0 ) {
                                    if ( is_array( $messageglobal ) && $messageglobal != NULL ) {

                                        if ( is_array( $messageglobal ) ) {
                                            foreach ( $messageglobal as $globalcommerce ) {
                                                echo $globalcommerce ;
                                            }
                                        }
                                    }
                                }
                            }
                            if ( get_option( 'rs_show_hide_buy_point_message_for_each_products' ) == '1' ) {
                                if ( is_array( $buyingmsg_global ) && $buyingmsg_global != NULL ) {
                                    foreach ( $buyingmsg_global as $globalcommerces ) {
                                        echo $globalcommerces ;
                                    }
                                }
                            }
                            ?></div>
                        <?php
                    }
                }
            }
        }

        public static function get_redeem_point_to_display_in_msg() {
            global $woocommerce ;
            global $value ;
            $user_ID             = get_current_user_id() ;
            $getinfousernickname = get_user_by( 'id' , $user_ID ) ;
            $couponcodeuserlogin = is_object( $getinfousernickname ) ? $getinfousernickname->user_login : 'Guest' ;
            $user_current_points = RSPointExpiry::total_available_points_in_site( $user_ID ) ;
            $auto_redeem_name    = 'auto_redeem_' . strtolower( $couponcodeuserlogin ) ;
            $usernickname        = 'sumo_' . strtolower( "$couponcodeuserlogin" ) ;
            $tax                 = 0 ;
            if ( isset( $woocommerce->cart->coupon_discount_tax_amounts[ "$usernickname" ] ) ) {
                $tax = $woocommerce->cart->coupon_discount_tax_amounts[ "$usernickname" ] ;
            }
            if ( isset( $woocommerce->cart->coupon_discount_amounts[ "$usernickname" ] ) ) {
                $total = $woocommerce->cart->coupon_discount_amounts[ "$usernickname" ] ;
                if ( get_option( 'woocommerce_tax_display_cart' ) == 'incl' && get_option( 'woocommerce_prices_include_tax' ) == 'no' ) {
                    $total = $total + $tax ;
                } elseif ( get_option( 'woocommerce_tax_display_cart' ) == 'incl' && get_option( 'woocommerce_prices_include_tax' ) == 'yes' ) {
                    $total = $total + $tax ;
                }
                $current_conversion = wc_format_decimal( get_option( 'rs_redeem_point' ) ) ;
                $point_amount       = RSMemberFunction::user_role_based_redeem_points( get_current_user_id() ) ;
                $newtotal           = $total * $current_conversion ;
                $newtotal           = $newtotal / $point_amount ;
                if ( $newtotal > $user_current_points ) {
                    $newtotal = $user_current_points ;
                }

                return get_option( 'rs_enable_round_off_type_for_calculation' ) == 'yes' ? $newtotal : round_off_type( $newtotal ) ;
            }
            if ( isset( $woocommerce->cart->coupon_discount_tax_amounts[ "$auto_redeem_name" ] ) ) {
                $tax = $woocommerce->cart->coupon_discount_tax_amounts[ "$auto_redeem_name" ] ;
            }
            if ( isset( $woocommerce->cart->coupon_discount_amounts[ "$auto_redeem_name" ] ) ) {
                $total = $woocommerce->cart->coupon_discount_amounts[ "$auto_redeem_name" ] ;
                if ( get_option( 'woocommerce_tax_display_cart' ) == 'incl' && get_option( 'woocommerce_prices_include_tax' ) == 'no' ) {
                    $total = $total + $tax ;
                } elseif ( get_option( 'woocommerce_tax_display_cart' ) == 'incl' && get_option( 'woocommerce_prices_include_tax' ) == 'yes' ) {
                    $total = $total + $tax ;
                }
                $current_conversion = wc_format_decimal( get_option( 'rs_redeem_point' ) ) ;
                $point_amount       = RSMemberFunction::user_role_based_redeem_points( get_current_user_id() ) ;
                $newtotal           = $total * $current_conversion ;
                $newtotal           = $newtotal / $point_amount ;

                if ( $newtotal > $user_current_points ) {
                    $newtotal = $user_current_points ;
                }
                return get_option( 'rs_enable_round_off_type_for_calculation' ) == 'yes' ? $newtotal : round_off_type( $newtotal ) ;
            }
        }

        public static function display_msg_in_checkout_page_for_balance_reward_points() {
            global $woocommerce ;
            if ( get_option( 'rs_show_hide_message_for_redeem_points_checkout_page' ) == '1' ) {
                if ( is_user_logged_in() ) {
                    if ( is_array( $woocommerce->cart->get_applied_coupons() ) ) {
                        $user_ID             = get_current_user_id() ;
                        $getinfousernickname = get_user_by( 'id' , $user_ID ) ;
                        $couponcodeuserlogin = is_object( $getinfousernickname ) ? $getinfousernickname->user_login : 'Guest' ;

                        $usernickname     = 'sumo_' . strtolower( "$couponcodeuserlogin" ) ;
                        $auto_redeem_name = 'auto_redeem_' . strtolower( $couponcodeuserlogin ) ;
                        if ( isset( $woocommerce->cart->coupon_discount_amounts[ "$auto_redeem_name" ] ) ) {
                            $total = $woocommerce->cart->coupon_discount_amounts[ "$auto_redeem_name" ] ;
                            if ( $total != 0 ) {
                                foreach ( $woocommerce->cart->get_applied_coupons() as $coupons ) {
                                    if ( strtolower( $coupons ) == $auto_redeem_name ) {
                                        ?>
                                        <div class="woocommerce-message sumo_redeemed_points rs_checkout_message">
                                            <?php echo do_shortcode( get_option( 'rs_message_user_points_redeemed_in_checkout' ) ) ; ?>
                                        </div>
                                        <?php
                                        if ( get_option( 'rs_enable_redeem_for_order' ) == 'yes' ) {
                                            ?>
                                            <div class="woocommerce-info sumo_reward_points_manual_redeem_error_message">
                                                <?php echo get_option( 'rs_errmsg_for_redeeming_in_order' ) ; ?>
                                            </div>
                                            <?php
                                        }
                                    }
                                }
                            }
                        }
                        if ( isset( $woocommerce->cart->coupon_discount_amounts[ "$usernickname" ] ) ) {
                            $total = $woocommerce->cart->coupon_discount_amounts[ "$usernickname" ] ;
                            if ( $total != 0 ) {
                                foreach ( $woocommerce->cart->get_applied_coupons() as $coupons ) {
                                    if ( strtolower( $coupons ) == $usernickname || strtolower( $coupons ) == $auto_redeem_name ) {

                                        $userid       = get_current_user_id() ;
                                        $banning_type = FPRewardSystem::check_banning_type( $userid ) ;
                                        if ( $banning_type != 'redeemingonly' && $banning_type != 'both' ) {
                                            ?>
                                            <div class="woocommerce-message sumo_redeemed_points rs_checkout_message">
                                                <?php echo do_shortcode( get_option( 'rs_message_user_points_redeemed_in_checkout' ) ) ; ?>
                                            </div>
                                            <?php
                                            /* Error Message to be Displayed When the order contain only redeeming */
                                            if ( get_option( 'rs_enable_redeem_for_order' ) == 'yes' ) {
                                                ?>
                                                <div class="woocommerce-info sumo_reward_points_manual_redeem_error_message">
                                                    <?php echo get_option( 'rs_errmsg_for_redeeming_in_order' ) ; ?>
                                                </div>
                                                <?php
                                            }

                                            // if (get_option('rs_redeem_field_type_option') == '2') {
                                            ?>
                                            <script type="text/javascript">
                                                jQuery( document ).ready( function () {
                                                    jQuery( "#mainsubmi" ).parent().hide() ;
                                                } ) ;</script>
                                            <?php
                                            // }

                                            if ( get_option( 'rs_redeem_field_type_option_checkout' ) == '2' ) {
                                                ?>
                                                <div class="sumo_reward_point_hide_field_script" data-sumo_coupon="yes">
                                                    <script type="text/javascript">
                                                        jQuery( document ).ready( function () {
                                                            jQuery( "#mainsubmi" ).parent().hide() ;
                                                        } ) ;
                                                    </script>
                                                </div>
                                                <?php
                                            }
                                        }
                                        ?>
                                        <?php
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }

        public static function get_each_buy_point_in_cart() {
            global $buying_pointsnew ;
            return round_off_type( $buying_pointsnew ) ;
        }

        public static function get_each_referral_point_for_payment_plan_in_cart() {
            global $ref_pdt_plan ;
            $referral_points_payment_plan = 0 ;
            if ( is_array( $ref_pdt_plan ) ) {
                $referral_points_payment_plan = round_off_type( array_sum( $ref_pdt_plan ) ) ;
            }
            return $referral_points_payment_plan ;
        }

        public static function get_each_referral_point_in_cart() {
            global $referral_pointsnew ;
            return round_off_type( $referral_pointsnew ) ;
        }

        public static function get_each_product_price_in_cart() {
            global $totalrewardpoints ;
            return round_off_type( $totalrewardpoints ) ;
        }

        public static function get_each_producttitle_in_cart() {
            global $checkproduct ;
            global $value ;
            $product_buy_points = get_post_meta( $value , '_rewardsystem_assign_buying_points' , true ) ;
            $variation          = rs_get_product_object( $value ) ;
            if ( is_object( $variation ) && ($variation->is_type( 'simple' ) || ($variation->is_type( 'subscription' ))) ) {
                return "<strong>" . get_the_title( $value ) . "</strong>" ;
            } else {
                if ( is_object( $variation ) && (rs_check_variable_product_type( $variation )) ) {
                    $variation = $variation->get_variation_attributes() ;
                    foreach ( $variation as $key ) {
                        if ( $product_buy_points == '' ) {
                            return "<strong>" . $checkproduct->get_title() . "\r" . $key . "</strong>" ;
                        } else {
                            return "<strong>" . $checkproduct->get_title() . "\r" . "</strong>" ;
                        }
                    }
                }
            }
        }

        public static function get_each_product_points_value_in_cart() {
            global $totalrewardpoints ;
            $getpoints    = $totalrewardpoints ;
            $getpoints    = str_replace( wc_get_price_thousand_separator() , '' , $getpoints ) ;
            $redeemconver = $getpoints / wc_format_decimal( get_option( 'rs_redeem_point' ) ) ;
            $point_amount = RSMemberFunction::user_role_based_redeem_points( get_current_user_id() ) ;
            $updatedvalue = $redeemconver * $point_amount ;
            return get_woocommerce_formatted_price( round_off_type_for_currency( $updatedvalue ) ) ;
        }

        public static function get_balance_redeem_points_to_display_in_msg() {
            global $woocommerce ;
            $user_ID             = get_current_user_id() ;
            $getinfousernickname = get_user_by( 'id' , $user_ID ) ;
            $couponcodeuserlogin = is_object( $getinfousernickname ) ? $getinfousernickname->user_login : 'Guest' ;
            $usernickname        = 'sumo_' . strtolower( "$couponcodeuserlogin" ) ;
            $auto_redeem_name    = 'auto_redeem_' . strtolower( $couponcodeuserlogin ) ;
            $tax                 = '0' ;
            if ( isset( $woocommerce->cart->coupon_discount_tax_amounts[ "$usernickname" ] ) ) {
                $tax = $woocommerce->cart->coupon_discount_tax_amounts[ $usernickname ] ;
            }
            if ( isset( $woocommerce->cart->coupon_discount_amounts[ "$usernickname" ] ) ) {
                $total = $woocommerce->cart->coupon_discount_amounts[ $usernickname ] ;
                if ( get_option( 'woocommerce_tax_display_cart' ) == 'incl' && get_option( 'woocommerce_prices_include_tax' ) == 'no' ) {
                    $total = $total + $tax ;
                } elseif ( get_option( 'woocommerce_tax_display_cart' ) == 'incl' && get_option( 'woocommerce_prices_include_tax' ) == 'yes' ) {
                    $total = $total + $tax ;
                }
                $current_conversion = wc_format_decimal( get_option( 'rs_redeem_point' ) ) ;
                $point_amount       = RSMemberFunction::user_role_based_redeem_points( get_current_user_id() ) ;
                $total              = $total * $current_conversion ;
                $total              = $total / $point_amount ;
                $myrewardpoint      = RSPointExpiry::total_available_points_in_site( $user_ID ) ;
                $majorpoint         = $myrewardpoint - $total ;
                if ( $majorpoint < 0 ) {
                    $majorpoint = '0' ;
                }
                $roundofftype = get_option( 'rs_round_off_type' ) == '1' ? '2' : '0' ;
                return round_off_type( $majorpoint ) ;
            }
            if ( isset( $woocommerce->cart->coupon_discount_tax_amounts[ "$auto_redeem_name" ] ) ) {
                $tax = $woocommerce->cart->coupon_discount_tax_amounts[ $auto_redeem_name ] ;
            }
            if ( isset( $woocommerce->cart->coupon_discount_amounts[ "$auto_redeem_name" ] ) ) {
                $total = $woocommerce->cart->coupon_discount_amounts[ $auto_redeem_name ] ;
                if ( get_option( 'woocommerce_tax_display_cart' ) == 'incl' && get_option( 'woocommerce_prices_include_tax' ) == 'no' ) {
                    $total = $total + $tax ;
                } elseif ( get_option( 'woocommerce_tax_display_cart' ) == 'incl' && get_option( 'woocommerce_prices_include_tax' ) == 'yes' ) {
                    $total = $total + $tax ;
                }
                $current_conversion = wc_format_decimal( get_option( 'rs_redeem_point' ) ) ;
                $point_amount       = RSMemberFunction::user_role_based_redeem_points( get_current_user_id() ) ;
                $total              = $total * $current_conversion ;
                $total              = $total / $point_amount ;
                $myrewardpoint      = RSPointExpiry::total_available_points_in_site( $user_ID ) ;
                $majorpoint         = $myrewardpoint - $total ;
                if ( $majorpoint < 0 ) {
                    $majorpoint = '0' ;
                }
                $roundofftype = get_option( 'rs_round_off_type' ) == '1' ? '2' : '0' ;
                return round_off_type( $majorpoint ) ;
            }
        }

        public static function validation_in_my_cart() {
            ?>
            <script type='text/javascript'>
                jQuery( document ).ready( function () {
                    jQuery( '#mainsubmi' ).click( function () {
                        var float_value_current_points = parseFloat( '<?php
            $currentuserpoints = RSPointExpiry::total_available_points_in_site( get_current_user_id() ) ;
            echo $currentuserpoints ;
            ?>' ) ;
                        float_value_current_points = Math.round( float_value_current_points * 100 ) / 100 ;
                        var float_value_minimum_redeeming_points = parseFloat( '<?php echo get_option( "rs_minimum_redeeming_points" ) ; ?>' ) ;
                        float_value_minimum_redeeming_points = Math.round( float_value_minimum_redeeming_points * 100 ) / 100 ;
                        var float_value_maximum_redeeming_points = parseFloat( '<?php echo get_option( "rs_maximum_redeeming_points" ) ; ?>' ) ;
                        float_value_maximum_redeeming_points = Math.round( float_value_maximum_redeeming_points * 100 ) / 100 ;
            <?php if ( get_option( 'rs_redeem_field_type_option' ) == '1' || get_option( 'rs_redeem_field_type_option_checkout' ) == '1' ) { ?>
                            var getvalue = jQuery( '#rs_apply_coupon_code_field' ).val() ;
                            if ( getvalue === '' ) {
                                jQuery( '.rs_warning_message' ).html( '<?php echo addslashes( get_option( 'rs_redeem_empty_error_message' ) ) ; ?>' ) ;
                                return false ;
                            } else if ( jQuery.isNumeric( getvalue ) == false ) {
                                jQuery( '.rs_warning_message' ).html( '<?php echo addslashes( get_option( 'rs_redeem_character_error_message' ) ) ; ?>' ) ;
                                return false ;
                            } else if ( getvalue > float_value_current_points ) {
                                jQuery( '.rs_warning_message' ).html( '<?php echo addslashes( get_option( 'rs_redeem_max_error_message' ) ) ; ?>' ) ;
                                return false ;
                            } else if ( jQuery.isNumeric( getvalue ) == true ) {
                                if ( getvalue < 0 ) {
                                    jQuery( '.rs_warning_message' ).html( '<?php echo addslashes( get_option( 'rs_redeem_character_error_message' ) ) ; ?>' ) ;
                                    return false ;
                                }
                            }
                <?php if ( get_option( 'rs_minimum_redeeming_points' ) == (get_option( 'rs_maximum_redeeming_points' )) ) { ?>
                                if ( getvalue < float_value_minimum_redeeming_points ) {
                                    jQuery( '.rs_warning_message' ).html( '<?php echo do_shortcode( addslashes( get_option( "rs_minimum_and_maximum_redeem_point_error_message" ) ) ) ; ?>' ) ;
                                    return false ;
                                } else if ( getvalue > float_value_maximum_redeeming_points ) {
                                    jQuery( '.rs_warning_message' ).html( '<?php echo do_shortcode( addslashes( get_option( "rs_minimum_and_maximum_redeem_point_error_message" ) ) ) ; ?>' ) ;
                                    return false ;
                                }
                <?php } ?>
                <?php if ( get_option( 'rs_minimum_redeeming_points' ) != '' ) { ?>
                                if ( getvalue < float_value_minimum_redeeming_points ) {
                                    jQuery( '.rs_warning_message' ).html( '<?php echo do_shortcode( addslashes( get_option( "rs_minimum_redeem_point_error_message" ) ) ) ; ?>' ) ;
                                    return false ;
                                }
                <?php } ?>

                <?php if ( get_option( 'rs_maximum_redeeming_points' ) != '' ) { ?>
                                if ( getvalue > float_value_maximum_redeeming_points ) {
                                    jQuery( '.rs_warning_message' ).html( '<?php echo do_shortcode( addslashes( get_option( "rs_maximum_redeem_point_error_message" ) ) ) ; ?>' ) ;
                                    return false ;
                                }
                <?php } ?>

            <?php } else { ?>
                            var getvalue = jQuery( '#rs_apply_coupon_code_field' ).val() ;
                <?php if ( get_option( 'rs_minimum_redeeming_points' ) == (get_option( 'rs_maximum_redeeming_points' )) ) { ?>
                                if ( getvalue < float_value_minimum_redeeming_points ) {
                                    jQuery( '.rs_warning_message' ).html( '<?php echo do_shortcode( addslashes( get_option( "rs_minimum_and_maximum_redeem_point_error_message_for_buttontype" ) ) ) ; ?>' ) ;
                                    return false ;
                                } else if ( getvalue > float_value_maximum_redeeming_points ) {
                                    jQuery( '.rs_warning_message' ).html( '<?php echo do_shortcode( addslashes( get_option( "rs_minimum_and_maximum_redeem_point_error_message_for_buttontype" ) ) ) ; ?>' ) ;
                                    return false ;
                                }
                <?php } ?>
                <?php if ( get_option( 'rs_minimum_redeeming_points' ) != '' ) { ?>
                                if ( getvalue < float_value_minimum_redeeming_points ) {
                                    jQuery( '.rs_warning_message' ).html( '<?php echo do_shortcode( addslashes( get_option( "rs_minimum_redeem_point_error_message_for_button_type" ) ) ) ; ?>' ) ;
                                    return false ;
                                }
                <?php } ?>

                <?php if ( get_option( 'rs_maximum_redeeming_points' ) != '' ) { ?>
                                if ( getvalue > float_value_maximum_redeeming_points ) {
                                    jQuery( '.rs_warning_message' ).html( '<?php echo do_shortcode( addslashes( get_option( "rs_maximum_redeem_point_error_message_for_button_type" ) ) ) ; ?>' ) ;
                                    return false ;
                                }
                <?php } ?>

            <?php } ?>
                    } ) ;
                } ) ;
            </script>
            <?php
        }

        public static function get_minimum_redeeming_points_value() {
            return get_option( 'rs_minimum_redeeming_points' ) ;
        }

        public static function get_maximum_redeeming_points_value() {
            return get_option( 'rs_maximum_redeeming_points' ) ;
        }

        public static function get_current_user_name() {
            $current_user_id = get_current_user_id() ;
            $user_name       = get_user_by( 'id' , $current_user_id )->display_name ;
            return $user_name ;
        }

        public static function get_minimum_and_maximum_redeeming_points_value() {
            return get_option( 'rs_minimum_redeeming_points' ) ;
        }

        public static function display_button_type_redeem_on_cart_page() {
            if ( ! is_user_logged_in() )
                return ;

            if ( get_option( 'rs_redeeming_activated' ) != 'yes' )
                return ;

            if ( get_option( 'rs_redeem_field_type_option' ) == '1' )
                return ;

            $MemberShipPlan         = array() ;
            $MemeberShipRestriction = 'no' ;
            if ( get_option( 'rs_restrict_redeem_when_no_membership_plan' ) == 'yes' ) {
                if ( function_exists( 'sumo_get_membership_levels' ) ) {
                    $MemberShipPlan         = sumo_get_membership_levels() ;
                    if ( empty( $MemberShipPlan ) )
                        $MemeberShipRestriction = 'yes' ;
                }
            }
            if ( $MemeberShipRestriction == 'yes' )
                return ;

            $EnabledProductList = array() ;
            foreach ( WC()->cart->cart_contents as $item ) {
                $ProductId                     = $item[ 'variation_id' ] != 0 ? $item[ 'variation_id' ] : $item[ 'product_id' ] ;
                $CheckWhetherPointPriceEnabled = calculate_point_price_for_products( $ProductId ) ;
                if ( $CheckWhetherPointPriceEnabled[ $ProductId ] == '' )
                    continue ;

                $EnabledProductList[] = $CheckWhetherPointPriceEnabled[ $ProductId ] ;
            }

            if ( ! empty( $EnabledProductList ) ) {
                if ( get_option( 'rs_show_hide_message_errmsg_for_point_price_coupon' ) == '1' ) {
                    $ErrMsg = get_option( 'rs_errmsg_for_redeem_in_point_price_prt' ) ;
                    ?>
                    <div class="woocommerce-info"><?php echo $ErrMsg ; ?></div>
                    <?php
                }
            }
            $hide_message_for_point_price_product = self::rs_hide_restrict_message_for_redeeming_on_point_price() ;
            if ( $hide_message_for_point_price_product == true ) {
                return ;
            }
            $MinCartTotalToRedeem          = get_option( 'rs_minimum_cart_total_points' ) ;
            $MaxCartTotalToRedeem          = get_option( 'rs_maximum_cart_total_points' ) ;
            $ErrMsgForMaxCartTotalToRedeem = get_option( 'rs_max_cart_total_redeem_error' ) ;
            $ErrMsgForMinCartTotalToRedeem = get_option( 'rs_min_cart_total_redeem_error' ) ;
            $CartTotal                     = self::rs_line_subtotal_for_redeeming_restriction() ;
            if ( $MinCartTotalToRedeem != '' && $MaxCartTotalToRedeem != '' ) {
                if ( $CartTotal >= $MinCartTotalToRedeem && $CartTotal <= $MaxCartTotalToRedeem ) {
                    self::display_redeem_points_buttons_on_cart_page() ;
                } else {
                    if ( get_option( 'rs_show_hide_maximum_cart_total_error_message' ) == '1' ) {
                        $CartTotalToReplace         = get_woocommerce_formatted_price( round_off_type_for_currency( $MaxCartTotalToRedeem ) ) ;
                        $CartTotalShortcodeReplaced = str_replace( "[carttotal]" , $CartTotalToReplace , $ErrMsgForMaxCartTotalToRedeem ) ;
                        $FinalErrmsg                = str_replace( "[currencysymbol]" , "" , $CartTotalShortcodeReplaced ) ;
                        ?>
                        <div class="woocommerce-error"><?php echo $FinalErrmsg ; ?></div>
                        <?php
                    }
                }
            } else if ( $MinCartTotalToRedeem != '' && $MaxCartTotalToRedeem == '' ) {
                if ( $CartTotal >= $MinCartTotalToRedeem ) {
                    self::display_redeem_points_buttons_on_cart_page() ;
                } else {
                    if ( get_option( 'rs_show_hide_minimum_cart_total_error_message' ) == '1' ) {
                        $CartTotalToReplace         = get_woocommerce_formatted_price( round_off_type_for_currency( $MinCartTotalToRedeem ) ) ;
                        $CartTotalShortcodeReplaced = str_replace( "[carttotal]" , $CartTotalToReplace , $ErrMsgForMinCartTotalToRedeem ) ;
                        $FinalErrmsg                = str_replace( "[currencysymbol]" , "" , $CartTotalShortcodeReplaced ) ;
                        ?>
                        <div class="woocommerce-error"><?php echo $FinalErrmsg ; ?></div>
                        <?php
                    }
                }
            } else if ( $MinCartTotalToRedeem == '' && $MaxCartTotalToRedeem != '' ) {
                if ( $CartTotal <= $MaxCartTotalToRedeem ) {
                    self::display_redeem_points_buttons_on_cart_page() ;
                } else {
                    if ( get_option( 'rs_show_hide_maximum_cart_total_error_message' ) == '1' ) {
                        $CartTotalToReplace         = get_woocommerce_formatted_price( round_off_type_for_currency( $MaxCartTotalToRedeem ) ) ;
                        $CartTotalShortcodeReplaced = str_replace( "[carttotal]" , $CartTotalToReplace , $ErrMsgForMaxCartTotalToRedeem ) ;
                        $FinalErrmsg                = str_replace( "[currencysymbol]" , "" , $CartTotalShortcodeReplaced ) ;
                        ?>
                        <div class="woocommerce-error"><?php echo $FinalErrmsg ; ?></div>
                        <?php
                    }
                }
            } else if ( $MinCartTotalToRedeem == '' && $MaxCartTotalToRedeem == '' ) {
                self::display_redeem_points_buttons_on_cart_page() ;
            }
        }

        public static function display_redeem_points_buttons_on_cart_page() {
            if ( get_option( 'rs_percentage_cart_total_redeem' ) == '' )
                return ;

            global $woocommerce ;
            $totalselectedvalue = array() ;
            $cart_object        = array() ;
            if ( is_user_logged_in() ) {
                $type                       = array() ;
                $points_for_include_product = '' ;
                $userid                     = get_current_user_id() ;
                $banning_type               = FPRewardSystem::check_banning_type( $userid ) ;
                if ( $banning_type != 'redeemingonly' && $banning_type != 'both' ) {
                    $getuserid               = get_current_user_id() ;
                    $user_current_points     = RSPointExpiry::total_available_points_in_site( $getuserid ) ;
                    $points_conversion_value = RSMemberFunction::user_role_based_redeem_points( $getuserid ) ;
                    $redeem_conversion       = wc_format_decimal( get_option( 'rs_redeem_point' ) ) ;
                    if ( get_option( 'rs_apply_redeem_basedon_cart_or_product_total' ) == '2' ) {
                        $getsumofselectedproduct = RSFunctionToApplyCoupon::get_sum_of_selected_products( 'auto' , '' , $user_current_points ) ;
                        foreach ( $woocommerce->cart->cart_contents as $item ) {
                            $productid        = $item[ 'variation_id' ] != 0 ? $item[ 'variation_id' ] : $item[ 'product_id' ] ;
                            $includeproductid = get_option( 'rs_select_products_to_enable_redeeming' ) ;
                            if ( is_array( $includeproductid ) ) {
                                $include_productid = ( array ) $includeproductid ;
                            } else {
                                $include_productid = ( array ) explode( ',' , $includeproductid ) ;
                            }
                            if ( get_option( 'rs_enable_redeem_for_selected_products' ) == 'yes' ) {
                                if ( get_option( 'rs_select_products_to_enable_redeeming' ) != '' ) {
                                    if ( in_array( $productid , $include_productid ) ) {
                                        if ( $item[ 'line_subtotal_tax' ] ) {
                                            if ( get_option( 'woocommerce_prices_include_tax' ) == 'yes' && get_option( 'woocommerce_tax_display_cart' ) == 'incl' ) {
                                                $totalselectedvalue[] = $item[ 'line_subtotal' ] + $item[ 'line_subtotal_tax' ] ;
                                            } elseif ( get_option( 'woocommerce_prices_include_tax' ) == 'no' && get_option( 'woocommerce_tax_display_cart' ) == 'incl' ) {
                                                $totalselectedvalue[] = $item[ 'line_subtotal' ] + $item[ 'line_subtotal_tax' ] ;
                                            } else {
                                                $totalselectedvalue[] = $item[ 'line_subtotal' ] ;
                                            }
                                        } else {
                                            $totalselectedvalue[] = $item[ 'line_subtotal' ] ;
                                        }
                                    }
                                }
                            }
                            $includecategory = get_option( 'rs_select_category_to_enable_redeeming' ) ;
                            if ( is_array( $includecategory ) ) {
                                $include_category = ( array ) $includecategory ; // Compatible for Old WooCommerce Version            
                            } else {
                                $include_category = ( array ) explode( ',' , $includecategory ) ; // Compatible with Latest Version            
                            }
                            $productcategorys = get_the_terms( $productid , 'product_cat' ) ;
                            if ( $productcategorys != false ) {
                                $getcount = count( $productcategorys ) ;
                                if ( $getcount >= '1' ) {
                                    foreach ( $productcategorys as $productcategory ) {
                                        $termid = $productcategory->term_id ;
                                        if ( get_option( 'rs_enable_redeem_for_selected_category' ) == 'yes' ) {
                                            if ( get_option( 'rs_select_category_to_enable_redeeming' ) != '' ) {
                                                if ( in_array( $termid , $include_category ) ) {
                                                    if ( $item[ 'line_subtotal_tax' ] ) {
                                                        if ( get_option( 'woocommerce_prices_include_tax' ) == 'yes' && get_option( 'woocommerce_tax_display_cart' ) == 'incl' ) {
                                                            $totalselectedvalue[ $productid ] = $item[ 'line_subtotal' ] + $item[ 'line_subtotal_tax' ] ;
                                                        } elseif ( get_option( 'woocommerce_prices_include_tax' ) == 'no' && get_option( 'woocommerce_tax_display_cart' ) == 'incl' ) {
                                                            $totalselectedvalue[ $productid ] = $item[ 'line_subtotal' ] + $item[ 'line_subtotal_tax' ] ;
                                                        }
                                                    } else {
                                                        $totalselectedvalue[ $productid ] = $item[ 'line_subtotal' ] ;
                                                    }
                                                }
                                            } else {
                                                $totalselectedvalue[] = $woocommerce->cart->subtotal ;
                                            }
                                        }
                                    }
                                } else {
                                    @$termid = $productcategorys[ 0 ]->term_id ;
                                    if ( get_option( 'rs_enable_redeem_for_selected_category' ) == 'yes' ) {
                                        if ( get_option( 'rs_select_category_to_enable_redeeming' ) != '' ) {
                                            if ( in_array( $termid , $include_category ) ) {
                                                if ( $item[ 'line_subtotal_tax' ] ) {
                                                    if ( get_option( 'woocommerce_prices_include_tax' ) == 'yes' && get_option( 'woocommerce_tax_display_cart' ) == 'incl' ) {
                                                        $totalselectedvalue[ $productid ] = $item[ 'line_subtotal' ] + $item[ 'line_subtotal_tax' ] ;
                                                    } elseif ( get_option( 'woocommerce_prices_include_tax' ) == 'no' && get_option( 'woocommerce_tax_display_cart' ) == 'incl' ) {
                                                        $totalselectedvalue[ $productid ] = $item[ 'line_subtotal' ] + $item[ 'line_subtotal_tax' ] ;
                                                    }
                                                } else {
                                                    $totalselectedvalue[ $productid ] = $item[ 'line_subtotal' ] ;
                                                }
                                            }
                                        } else {
                                            $totalselectedvalue[] = $woocommerce->cart->subtotal ;
                                        }
                                    }
                                }
                            }
                        }
                        $points_for_include_product_sum = array_sum( $totalselectedvalue ) ;
                        $points_for_include_product     = $redeem_conversion * $points_for_include_product_sum ;
                        $points_for_redeeming           = $points_for_include_product / $points_conversion_value ;
                    }
                    if ( $user_current_points > 0 ) {
                        if ( get_user_meta( $getuserid , 'rsfirsttime_redeemed' , true ) != '1' ) {
                            if ( $user_current_points >= get_option( "rs_first_time_minimum_user_points" ) ) {
                                if ( get_option( 'rs_redeem_field_type_option' ) == '2' ) {
                                    $getuserid           = get_current_user_id() ;
                                    $user_current_points = RSPointExpiry::total_available_points_in_site( $getuserid ) ;

                                    if ( get_option( 'woocommerce_prices_include_tax' ) == 'yes' ) {
                                        if ( get_option( 'woocommerce_tax_display_cart' ) == 'incl' ) {
                                            $current_carttotal_amount = $woocommerce->cart->subtotal ;
                                        } else {
                                            $current_carttotal_amount = $woocommerce->cart->subtotal ;
                                        }
                                    } else {
                                        if ( get_option( 'woocommerce_tax_display_cart' ) == 'incl' ) {
                                            $current_carttotal_amount = $woocommerce->cart->subtotal_ex_tax ;
                                        } else {
                                            $current_carttotal_amount = $woocommerce->cart->subtotal_ex_tax ;
                                        }
                                    }
                                    $limitation_percentage_for_redeeming = get_option( 'rs_percentage_cart_total_redeem' ) ;
                                    $cart_total_in_amount                = $limitation_percentage_for_redeeming / 100 ;
                                    $updated_cart_total_in_amount        = $cart_total_in_amount * $current_carttotal_amount ;
                                    $redeem_conversion                   = wc_format_decimal( get_option( 'rs_redeem_point' ) ) ;
                                    $points_conversion_value             = RSMemberFunction::user_role_based_redeem_points( get_current_user_id() ) ;
                                    $points_for_redeem_in_points         = $updated_cart_total_in_amount * $redeem_conversion ;
                                    $updated_points_for_redeeming        = $points_for_redeem_in_points / $points_conversion_value ;
                                    $cartpoints_string_to_replace        = "[cartredeempoints]" ;
                                    $currency_symbol_string_to_find      = "[currencysymbol]" ;
                                    $currency_value_string_to_find       = "[pointsvalue]" ;
                                    if ( $user_current_points >= $updated_points_for_redeeming ) {
                                        $redeem_button_message_more        = get_option( 'rs_redeeming_button_option_message' ) ;
                                        $percentage_string_to_replace      = "[redeempercent]" ;
                                        $currency_value_string_to_find     = "[pointsvalue]" ;
                                        $points_conversion_value           = RSMemberFunction::user_role_based_redeem_points( get_current_user_id() ) ;
                                        $points_currency_value             = $updated_cart_total_in_amount ;
                                        $points_currency_amount_to_replace = $updated_points_for_redeeming ;
                                        $points_for_redeeming              = $updated_points_for_redeeming ;
                                        if ( get_option( 'rs_apply_redeem_basedon_cart_or_product_total' ) == '2' ) {
                                            if ( $points_for_include_product != '' ) {
                                                $limitation_percentage_for_redeeming = get_option( 'rs_percentage_cart_total_redeem' ) ;
                                                $cart_total_in_amount                = $limitation_percentage_for_redeeming / 100 ;
                                                $updated_cart_total_in_amount        = $cart_total_in_amount * $points_for_include_product_sum ;
                                                $points_for_include_product          = $redeem_conversion * $updated_cart_total_in_amount ;
                                                $points_for_redeeming                = $points_for_include_product / $points_conversion_value ;
                                                $points_currency_value               = $updated_cart_total_in_amount ;
                                            }
                                        }
                                        $roundofftype         = get_option( 'rs_round_off_type' ) == '1' ? '2' : '0' ;
                                        $points_for_redeeming = round_off_type( $points_for_redeeming ) ;

                                        $currency_symbol_string_to_replace     = get_woocommerce_formatted_price( round_off_type_for_currency( $points_currency_value ) ) ;
                                        $redeem_button_message_replaced_first  = str_replace( $currency_value_string_to_find , $currency_symbol_string_to_replace , $redeem_button_message_more ) ;
                                        $redeem_button_message_replaced_second = str_replace( $currency_symbol_string_to_find , "" , $redeem_button_message_replaced_first ) ;
                                        $redeem_button_message_replaced_third  = str_replace( $cartpoints_string_to_replace , $points_for_redeeming , $redeem_button_message_replaced_second ) ;
                                    } else {

                                        $points_for_redeeming = $user_current_points ;

                                        $redeem_button_message_more        = get_option( 'rs_redeeming_button_option_message' ) ;
                                        $points_conversion_value           = RSMemberFunction::user_role_based_redeem_points( get_current_user_id() ) ;
                                        $points_currency_value             = $points_for_redeeming / $redeem_conversion ;
                                        $points_currency_amount_to_replace = $points_currency_value * $points_conversion_value ;
                                        if ( get_option( 'rs_apply_redeem_basedon_cart_or_product_total' ) == '2' ) {
                                            if ( $points_for_include_product != '' ) {
                                                $points_for_redeeming1 = $points_for_include_product / $points_conversion_value ;
                                                if ( $user_current_points > $points_for_redeeming1 ) {
                                                    $points_for_redeeming                = $points_for_redeeming1 ;
                                                    $points_currency_value               = $getsumofselectedproduct ;
                                                    $limitation_percentage_for_redeeming = get_option( 'rs_percentage_cart_total_redeem' ) ;
                                                    $cart_total_in_amount                = $limitation_percentage_for_redeeming / 100 ;
                                                    $updated_cart_total_in_amount        = $cart_total_in_amount * $points_for_include_product_sum ;
                                                    $points_for_include_product          = $redeem_conversion * $updated_cart_total_in_amount ;
                                                    $points_for_redeeming                = $points_for_include_product / $points_conversion_value ;
                                                    $points_currency_value               = $updated_cart_total_in_amount ;
                                                }
                                            }
                                        }
                                        $roundofftype                          = get_option( 'rs_round_off_type' ) == '1' ? '2' : '0' ;
                                        $points_for_redeeming                  = round_off_type( $points_for_redeeming ) ;
                                        $points_conversion_value               = RSMemberFunction::user_role_based_redeem_points( get_current_user_id() ) ;
                                        $points_currency_value                 = $points_for_redeeming / $redeem_conversion ;
                                        $points_currency_amount_to_replace     = $points_currency_value * $points_conversion_value ;
                                        $currency_symbol_string_to_replace     = get_woocommerce_formatted_price( round_off_type_for_currency( $points_currency_amount_to_replace ) ) ;
                                        $redeem_button_message_replaced_first  = str_replace( $currency_symbol_string_to_find , "" , $redeem_button_message_more ) ;
                                        $redeem_button_message_replaced_second = str_replace( $currency_value_string_to_find , $currency_symbol_string_to_replace , $redeem_button_message_replaced_first ) ;
                                        $redeem_button_message_replaced_third  = str_replace( $cartpoints_string_to_replace , $points_for_redeeming , $redeem_button_message_replaced_second ) ;
                                    }
                                    $minimum_cart_total_redeem = get_option( 'rs_minimum_cart_total_points' ) ;

                                    if ( get_option( 'woocommerce_prices_include_tax' ) === 'yes' ) {
                                        $cart_subtotal_redeem_amount = $woocommerce->cart->subtotal_ex_tax ;
                                    } else {
                                        $cart_subtotal_redeem_amount = $woocommerce->cart->subtotal ;
                                    }

                                    if ( $cart_subtotal_redeem_amount >= $minimum_cart_total_redeem ) {
                                        $user_ID             = get_current_user_id() ;
                                        $getinfousernickname = get_user_by( 'id' , $user_ID ) ;
                                        $couponcodeuserlogin = is_object( $getinfousernickname ) ? $getinfousernickname->user_login : 'Guest' ;
                                        $array               = $woocommerce->cart->get_applied_coupons() ;
                                        $auto_redeem_name    = 'auto_redeem_' . strtolower( $couponcodeuserlogin ) ;
                                        foreach ( $woocommerce->cart->cart_contents as $item ) {
                                            $product_id = $item[ 'variation_id' ] != 0 ? $item[ 'variation_id' ] : $item[ 'product_id' ] ;
                                            $type[]     = check_display_price_type( $product_id ) ;
                                            $enable     = calculate_point_price_for_products( $product_id ) ;
                                            if ( $enable[ $product_id ] != '' ) {
                                                $cart_object[] = $enable[ $product_id ] ;
                                            }
                                        }
                                        if ( empty( $cart_object ) ) {
                                            if ( ! in_array( 2 , $type ) ) {
                                                if ( ! in_array( $auto_redeem_name , $array ) && self::rs_check_whether_to_display_redeem_field() ) {
                                                    ?>
                                                    <form method="post" class="rs_button_redeem_cart woocommerce-info">
                                                        <div class="sumo_reward_points_cart_apply_discount"><?php echo $redeem_button_message_replaced_third ; ?>
                                                            <input id="rs_apply_coupon_code_field" class="input-text" type="hidden"  value="<?php echo $points_for_redeeming ; ?> " name="rs_apply_coupon_code_field">
                                                            <input class="<?php echo get_option( 'rs_extra_class_name_apply_reward_points' ) ; ?>" type="submit" id='mainsubmi' value="<?php echo get_option( 'rs_redeem_field_submit_button_caption' ) ; ?>" name="rs_apply_coupon_code1" />
                                                        </div>
                                                    </form>
                                                    <?php
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                        } else {
                            if ( $user_current_points >= get_option( "rs_minimum_user_points_to_redeem" ) ) {
                                if ( get_option( 'rs_redeem_field_type_option' ) == '2' ) {
                                    $getuserid           = get_current_user_id() ;
                                    $user_current_points = RSPointExpiry::total_available_points_in_site( $getuserid ) ;
                                    if ( get_option( 'woocommerce_prices_include_tax' ) == 'yes' ) {
                                        if ( get_option( 'woocommerce_tax_display_cart' ) == 'incl' ) {
                                            $current_carttotal_amount = $woocommerce->cart->subtotal ;
                                        } else {
                                            $current_carttotal_amount = $woocommerce->cart->subtotal ;
                                        }
                                    } else {
                                        if ( get_option( 'woocommerce_tax_display_cart' ) == 'incl' ) {
                                            $current_carttotal_amount = $woocommerce->cart->subtotal_ex_tax ;
                                        } else {
                                            $current_carttotal_amount = $woocommerce->cart->subtotal_ex_tax ;
                                        }
                                    }
                                    $limitation_percentage_for_redeeming = get_option( 'rs_percentage_cart_total_redeem' ) ;
                                    $cart_total_in_amount                = $limitation_percentage_for_redeeming / 100 ;
                                    $updated_cart_total_in_amount        = $cart_total_in_amount * $current_carttotal_amount ;
                                    $redeem_conversion                   = wc_format_decimal( get_option( 'rs_redeem_point' ) ) ;
                                    $points_conversion_value             = RSMemberFunction::user_role_based_redeem_points( get_current_user_id() ) ;
                                    $points_for_redeem_in_points         = $updated_cart_total_in_amount * $redeem_conversion ;
                                    $updated_points_for_redeeming        = $points_for_redeem_in_points / $points_conversion_value ;
                                    $cartpoints_string_to_replace        = "[cartredeempoints]" ;
                                    $currency_symbol_string_to_find      = "[currencysymbol]" ;
                                    $currency_value_string_to_find       = "[pointsvalue]" ;
                                    if ( $user_current_points >= $updated_points_for_redeeming ) {
                                        $redeem_button_message_more        = get_option( 'rs_redeeming_button_option_message' ) ;
                                        $currency_value_string_to_find     = "[pointsvalue]" ;
                                        $points_conversion_value           = RSMemberFunction::user_role_based_redeem_points( get_current_user_id() ) ;
                                        $points_currency_value             = $updated_cart_total_in_amount ;
                                        $points_currency_amount_to_replace = $updated_points_for_redeeming ;
                                        $points_for_redeeming              = $updated_points_for_redeeming ;
                                        if ( get_option( 'rs_apply_redeem_basedon_cart_or_product_total' ) == '2' ) {
                                            if ( $points_for_include_product != '' ) {
                                                $limitation_percentage_for_redeeming = get_option( 'rs_percentage_cart_total_redeem' ) ;
                                                $cart_total_in_amount                = $limitation_percentage_for_redeeming / 100 ;
                                                $updated_cart_total_in_amount        = $cart_total_in_amount * $points_for_include_product_sum ;
                                                $points_for_include_product          = $redeem_conversion * $updated_cart_total_in_amount ;
                                                $points_for_redeeming                = $points_for_include_product / $points_conversion_value ;
                                                $points_currency_value               = $updated_cart_total_in_amount ;
                                            }
                                        }
                                        $roundofftype                      = get_option( 'rs_round_off_type' ) == '1' ? '2' : '0' ;
                                        $points_for_redeeming              = round( $points_for_redeeming , $roundofftype ) ;
                                        $redeem_button_message_more        = get_option( 'rs_redeeming_button_option_message' ) ;
                                        $currency_symbol_string_to_replace = get_woocommerce_formatted_price( round_off_type_for_currency( $points_currency_value ) ) ;

                                        $redeem_button_message_replaced_first  = str_replace( $currency_value_string_to_find , $currency_symbol_string_to_replace , $redeem_button_message_more ) ;
                                        $redeem_button_message_replaced_second = str_replace( $currency_symbol_string_to_find , "" , $redeem_button_message_replaced_first ) ;
                                        $redeem_button_message_replaced_third  = str_replace( $cartpoints_string_to_replace , $points_for_redeeming , $redeem_button_message_replaced_second ) ;
                                    } else {
                                        $points_for_redeeming = $user_current_points ;
                                        if ( get_option( 'rs_apply_redeem_basedon_cart_or_product_total' ) == '2' ) {
                                            if ( $points_for_include_product != '' ) {
                                                $points_for_redeeming1 = $points_for_include_product / $points_conversion_value ;
                                                if ( $user_current_points > $points_for_redeeming1 ) {
                                                    $points_for_redeeming                = $points_for_redeeming1 ;
                                                    $points_currency_value               = $getsumofselectedproduct ;
                                                    $limitation_percentage_for_redeeming = get_option( 'rs_percentage_cart_total_redeem' ) ;
                                                    $cart_total_in_amount                = $limitation_percentage_for_redeeming / 100 ;
                                                    $updated_cart_total_in_amount        = $cart_total_in_amount * $points_for_include_product_sum ;

                                                    $points_for_include_product = $redeem_conversion * $updated_cart_total_in_amount ;
                                                    $points_for_redeeming       = $points_for_include_product / $points_conversion_value ;
                                                    $points_currency_value      = $updated_cart_total_in_amount ;
                                                }
                                            }
                                        }
                                        $points_for_redeeming = round_off_type( $points_for_redeeming ) ;

                                        $redeem_button_message_more            = get_option( 'rs_redeeming_button_option_message_checkout' ) ;
                                        $points_conversion_value               = RSMemberFunction::user_role_based_redeem_points( get_current_user_id() ) ;
                                        $points_currency_value                 = $points_for_redeeming / $redeem_conversion ;
                                        $points_currency_amount_to_replace     = $points_currency_value * $points_conversion_value ;
                                        $currency_symbol_string_to_replace     = get_woocommerce_formatted_price( round_off_type_for_currency( $points_currency_amount_to_replace ) ) ;
                                        $redeem_button_message_replaced_first  = str_replace( $currency_symbol_string_to_find , "" , $redeem_button_message_more ) ;
                                        $redeem_button_message_replaced_second = str_replace( $currency_value_string_to_find , $currency_symbol_string_to_replace , $redeem_button_message_replaced_first ) ;
                                        $redeem_button_message_replaced_third  = str_replace( $cartpoints_string_to_replace , $points_for_redeeming , $redeem_button_message_replaced_second ) ;
                                    }
                                    $minimum_cart_total_redeem = get_option( 'rs_minimum_cart_total_points' ) ;
                                    if ( get_option( 'woocommerce_prices_include_tax' ) === 'yes' ) {
                                        $cart_subtotal_redeem_amount = $woocommerce->cart->subtotal_ex_tax ;
                                    } else {
                                        $cart_subtotal_redeem_amount = $woocommerce->cart->subtotal ;
                                    }
                                    if ( $cart_subtotal_redeem_amount >= $minimum_cart_total_redeem ) {
                                        $user_ID             = get_current_user_id() ;
                                        $getinfousernickname = get_user_by( 'id' , $user_ID ) ;
                                        $couponcodeuserlogin = is_object( $getinfousernickname ) ? $getinfousernickname->user_login : 'Guest' ;
                                        $auto_redeem_name    = 'auto_redeem_' . strtolower( $couponcodeuserlogin ) ;
                                        $array               = $woocommerce->cart->get_applied_coupons() ;
                                        foreach ( $woocommerce->cart->cart_contents as $item ) {
                                            $product_id = $item[ 'variation_id' ] != 0 ? $item[ 'variation_id' ] : $item[ 'product_id' ] ;
                                            $type[]     = check_display_price_type( $product_id ) ;
                                            $enable     = calculate_point_price_for_products( $product_id ) ;
                                            if ( $enable[ $product_id ] != '' ) {
                                                $cart_object[] = $enable[ $product_id ] ;
                                            }
                                        }
                                        if ( empty( $cart_object ) ) {
                                            if ( ! in_array( 2 , $type ) ) {
                                                if ( ! in_array( $auto_redeem_name , $array ) & self::rs_check_whether_to_display_redeem_field() ) {
                                                    ?>
                                                    <form method="post" class="rs_button_redeem_cart woocommerce-info">                                                     
                                                        <div class="sumo_reward_points_cart_apply_discount"><?php echo $redeem_button_message_replaced_third ; ?>
                                                            <input id="rs_apply_coupon_code_field" class="input-text" type="hidden"  value="<?php echo $points_for_redeeming ; ?> " name="rs_apply_coupon_code_field">
                                                            <input class="<?php echo get_option( 'rs_extra_class_name_apply_reward_points' ) ; ?>" type="submit" id='mainsubmi' value="<?php echo get_option( 'rs_redeem_field_submit_button_caption' ) ; ?>" name="rs_apply_coupon_code1" />
                                                            <div class='rs_warning_message' style='display:inline-block;color:red'></div>
                                                        </div>
                                                    </form>
                                                    <?php
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }

        public static function change_coupon_label( $link , $coupon ) {
            $userid       = get_current_user_id() ;
            $banning_type = FPRewardSystem::check_banning_type( $userid ) ;
            if ( $banning_type != 'earningonly' && $banning_type != 'both' ) {
                $coupon_obj          = rs_get_coupon_obj( $coupon ) ;
                $couponcode          = $coupon_obj[ 'coupon_code' ] ;
                if ( is_string( $coupon ) )
                    $coupon              = new WC_Coupon( $coupon ) ;
                $user_ID             = get_current_user_id() ;
                $getinfousernickname = get_user_by( 'id' , $user_ID ) ;
                $couponcodeuserlogin = is_object( $getinfousernickname ) ? $getinfousernickname->user_login : 'Guest' ;
                if ( strtolower( $couponcode ) == ('sumo_' . strtolower( $couponcodeuserlogin )) || strtolower( $couponcode ) == 'auto_redeem_' . strtolower( $couponcodeuserlogin ) ) {
                    $newcoupon = get_option( 'rs_coupon_label_message' ) ;
                    $link      = ' ' . $newcoupon ;
                }
            }
            return $link ;
        }

        public static function rs_list_orders_with_pending_points() {
            $outputtablefields = '<p> ' ;
            $outputtablefields .= __( 'Page Size:' , 'rewardsystem' ) . '<select id="change-page-sizesss"><option value="5">5</option><option value="10">10</option><option value="50">50</option>
                    <option value="100">100</option>
                </select>' ;
            $outputtablefields .= '</p>' ;
            echo $outputtablefields ;
            ?>
            <table class = "list_of_orders demo shop_table my_account_orders table-bordered" data-page-size="5" data-page-previous-text = "prev" data-filter-text-only = "true" data-page-next-text = "next">
                <thead><tr><th data-type="Numeric"><?php echo '<br>S.No</br>' ; ?></th> 
                        <th data-type="Numeric"><?php echo '<br>User name</br>' ; ?></th>
                        <th data-type="Numeric"><?php echo '<br>Status</br>' ; ?></th>
                        <th data-type="Numeric"><?php echo '<br>Description</br>' ; ?></th></tr></thead>
                <tbody>
                    <?php
                    $order_statuses    = wc_get_order_statuses() ;
                    $order_statuses    = array_keys( $order_statuses ) ;
                    $i                 = 1 ;
                    $list_of_status    = get_option( 'rs_order_status_control' ) ;
                    $list_of_status    = (is_array( $list_of_status ) && ! empty( $list_of_status )) ? $list_of_status : array() ;
                    $status_to_check   = array() ;
                    foreach ( $order_statuses as $status ) {
                        $replaced_status = str_replace( 'wc-' , '' , $status ) ;
                        if ( ! in_array( $replaced_status , $list_of_status ) ) {
                            $status_to_check[] = 'wc-' . $replaced_status ;
                        }
                    }
                    $user_id        = get_current_user_id() ;
                    $args           = array(
                        'post_type'     => 'shop_order' ,
                        'numberposts'   => '-1' ,
                        'meta_query'    => array(
                            array(
                                'key'     => 'reward_points_awarded' ,
                                'compare' => 'NOT EXISTS'
                            ) ,
                            array(
                                'key'     => 'rs_points_for_current_order_as_value' ,
                                'value'   => 0 ,
                                'compare' => '>'
                            ) ,
                            array(
                                'key'     => '_customer_user' ,
                                'value'   => $user_id ,
                                'compare' => '='
                            ) ,
                        ) ,
                        'post_status'   => $status_to_check ,
                        'fields'        => 'ids' ,
                        'cache_results' => false
                            ) ;
                    $list_of_orders = get_posts( $args ) ;
                    foreach ( $list_of_orders as $order_id ) {
                        $order                 = new WC_Order( $order_id ) ;
                        $order_data            = rs_get_order_obj( $order ) ;
                        $order_status          = $order_data[ 'order_status' ] ;
                        $first_name            = $order_data[ 'first_name' ] ;
                        $current_earned_points = ( float ) get_post_meta( $order_id , 'rs_points_for_current_order_as_value' , true ) ;
                        if ( $current_earned_points > 0 ) {
                            self::order_status_settings( $order_id , $order_status , $first_name , $i , $current_earned_points , $list_of_status ) ;
                            $i ++ ;
                        }
                    }
                    ?>
                </tbody>
                <tfoot>
                    <tr style = "clear:both;">
                        <td colspan = "4">
                            <div class = "pagination pagination-centered"></div>
                        </td>
                    </tr>
                </tfoot>
            </table>
            <?php ?>
            <script type="text/javascript">
                jQuery( document ).ready( function () {
                    jQuery( '.list_of_orders' ).footable() ;
                    jQuery( '#change-page-sizesss' ).change( function ( e ) {
                        e.preventDefault() ;
                        var pageSize = jQuery( this ).val() ;
                        jQuery( '.footable' ).data( 'page-size' , pageSize ) ;
                        jQuery( '.footable' ).trigger( 'footable_initialized' ) ;
                    } ) ;

                } ) ;</script>
            <?php
        }

        public static function order_status_settings( $order_id , $order_status , $first_name , $i , $current_earned_points , $list_of_status ) {
            $post_url               = admin_url( 'post.php?post=' . $order_id ) . '&action=edit' ;
            $myaccountlink          = get_permalink( get_option( 'woocommerce_myaccount_page_id' ) ) ;
            $vieworderlink          = esc_url_raw( add_query_arg( 'view-order' , $order_id , $myaccountlink ) ) ;
            $vieworderlinkforfront  = '<a href="' . $vieworderlink . '">#' . $order_id . '</a>' ;
            $order_status_to_reach  = ucfirst( implode( ',' , $list_of_status ) ) ;
            $points_to_earn_message = "Currently, the order status is in [status]. Once the order status reached to the [order_status_to_reach], [reward_points] Points for purchasing the product(s) in this order([order_id]) will be added to your account" ;
            if ( $current_earned_points > 0 ) {
                $status_points_to_earn_message = str_replace( '[reward_points]' , $current_earned_points , str_replace( '[order_id]' , $vieworderlinkforfront , str_replace( '[status]' , ucfirst( $order_status ) , $points_to_earn_message ) ) ) ;
                $status_points_to_earn_message = str_replace( '[order_status_to_reach]' , $order_status_to_reach , $status_points_to_earn_message ) ;
                ?>
                <tr>
                    <td data-value="<?php echo $i ; ?>"><?php echo $i ; ?></td>  
                    <td><?php echo $first_name ?> </td> 
                    <td><?php echo ucfirst( $order_status ) ; ?></td>
                    <td><?php echo $status_points_to_earn_message ; ?></td> <?php ?>
                </tr>
                <?php
            }
        }

        public static function rs_line_subtotal_for_redeeming_restriction() {
            if ( get_option( 'woocommerce_prices_include_tax' ) == 'yes' && get_option( 'woocommerce_tax_display_cart' ) == 'incl' ) {
                $cart_subtotal = WC()->cart->subtotal ;
            } elseif ( get_option( 'woocommerce_prices_include_tax' ) == 'yes' && get_option( 'woocommerce_tax_display_cart' ) == 'excl' ) {
                $cart_subtotal = WC()->cart->subtotal_ex_tax ;
            } elseif ( get_option( 'woocommerce_prices_include_tax' ) == 'no' && get_option( 'woocommerce_tax_display_cart' ) == 'incl' ) {
                $cart_subtotal = WC()->cart->subtotal ;
            } else {
                $cart_subtotal = WC()->cart->subtotal_ex_tax ;
            }
            return $cart_subtotal ;
        }

        // hide Redeeming Restriction Message for Point price product
        public static function rs_hide_restrict_message_for_redeeming_on_point_price() {
            if ( get_option( 'rs_point_price_activated' ) == 'no' )
                return false ;

            global $woocommerce ;
            $typeofprice = '' ;
            if ( ! empty( $woocommerce->cart->cart_contents ) ) {
                foreach ( $woocommerce->cart->cart_contents as $key => $values ) {
                    $productid   = $values[ 'variation_id' ] != 0 ? $values[ 'variation_id' ] : $values[ 'product_id' ] ;
                    $typeofprice = check_display_price_type( $productid ) ;
                    if ( $typeofprice != '' ) {
                        return true ;
                    }
                }
            }
        }

    }

    RSFunctionForCart::init() ;
}