<?php

/*
 * Advanced Tab
 */

if ( ! defined ( 'ABSPATH' ) ) {
    exit ; // Exit if accessed directly.
}
if ( ! class_exists ( 'RSBuddypress_compatibility' ) ) {

    class RSBuddypress_compatibility {

        public static function init() {
            //Buddypress group create 
            add_action ( 'groups_group_create_complete' , array ( __CLASS__ , 'rs_Buddypress_group_create' ) , 10 , 4 ) ;
            //Buddypress post create  
            add_action ( 'bp_activity_comment_posted' , array ( __CLASS__ , 'rs_Buddypress_post_comment' ) , 10 , 3 ) ;
            //Buddypress post comment  
            add_action ( 'bp_activity_posted_update' , array ( __CLASS__ , 'rs_Buddypress_post_create' ) , 10 , 3 ) ;
        }

        public static function rs_Buddypress_group_create_restriction( $action_flag , $rs_action_points ) {

            if ( $action_flag == 'rs_bp_group_creation' ) {
                $current_user_id             = get_current_user_id () ;
                $rs_action_enable            = get_option ( 'rs_enable_points_for_bp_group_create' ) ;
                $rs_action_limit             = get_option ( 'rs_points_for_bp_group_create_limit' ) ;
                $rs_bp_each_user_group_count = ( int ) bp_get_total_group_count_for_user ( $current_user_id ) ;
            }

            if ( $action_flag == 'rs_bp_post_comment' ) {
                $rs_action_enable = get_option ( 'rs_enable_points_for_bp_postcomment' ) ;
            }

            if ( $action_flag == 'rs_bp_post_creation' ) {
                $rs_action_enable = get_option ( 'rs_enable_points_for_bp_post_create' ) ;
            }
            
            if ( $rs_action_enable == 'yes' && $rs_action_points != '' && is_numeric ( $rs_action_points ) ) {
                if ( $action_flag == 'rs_bp_group_creation' ) {
                    if ( is_numeric ( $rs_action_limit ) && $rs_bp_each_user_group_count <= $rs_action_limit ) {
                        return true ;
                    } else {
                        return false ;
                    }
                }
                return true ;
            }
            
            return false ;
        }

        public static function rs_Buddypress_group_create() {
            $new_obj                   = new RewardPointsOrder ( $order_id                  = 0 , 'no' ) ;
            $current_user_id           = get_current_user_id () ;
            $rs_bp_group_create_points = get_option ( 'rs_points_for_bp_group_create' ) ;
            if ( self::rs_Buddypress_group_create_restriction ( 'rs_bp_group_creation' , $rs_bp_group_create_points ) ) {
                $points_to_award = RSMemberFunction::user_role_based_reward_points ( $current_user_id , $rs_bp_group_create_points ) ;
                $event_slug      = 'RPFBPG' ;
                $eq_amt          = RSPointExpiry::earning_conversion_settings ( $points_to_award ) ;
                $valuestoinsert  = array ( 'pointstoinsert' => $points_to_award , 'pointsredeemed' => 0 , 'event_slug' => $event_slug , 'equalearnamnt' => $eq_amt , 'equalredeemamnt' => 0 , 'user_id' => $current_user_id , 'referred_id' => '' , 'product_id' => '' , 'variation_id' => '0' , 'reasonindetail' => '' , 'nominee_id' => '' , 'nominee_points' => '' , 'totalearnedpoints' => $points_to_award , 'totalredeempoints' => 0 ) ;
                $new_obj->total_points_management ( $valuestoinsert ) ;
            }
        }

        public static function rs_Buddypress_post_comment( $comment_id , $params , $parent_activity ) {
            $post_id = '' ;
            if ( is_object ( $parent_activity ) ) {
                $post_id = $parent_activity->id ;
            }
            $current_user_id           = get_current_user_id () ;
            $rs_bp_post_comment_points = get_option ( 'rs_points_for_bp_postcomment' ) ;
            if ( $post_id != '' && self::rs_Buddypress_group_create_restriction ( 'rs_bp_post_comment' , $rs_bp_post_comment_points ) ) {
                $rs_bp_groupcomment_check = RSFunctionForSavingMetaValues::rewardsystem_get_user_meta ( $current_user_id , 'rs_bp_groupcomment_check' . $post_id , true ) ;
                if ( $rs_bp_groupcomment_check == '' ) {
                    $new_obj         = new RewardPointsOrder ( $order_id        = 0 , 'no' ) ;
                    $points_to_award = RSMemberFunction::user_role_based_reward_points ( $current_user_id , $rs_bp_post_comment_points ) ;
                    $event_slug      = 'RPFBPC' ;
                    $equearnamt      = RSPointExpiry::earning_conversion_settings ( $points_to_award ) ;
                    $valuestoinsert  = array ( 'pointstoinsert' => $points_to_award , 'pointsredeemed' => 0 , 'event_slug' => $event_slug , 'equalearnamnt' => $equearnamt , 'equalredeemamnt' => 0 , 'user_id' => $current_user_id , 'referred_id' => '' , 'product_id' => $post_id , 'variation_id' => '0' , 'reasonindetail' => '' , 'nominee_id' => '' , 'nominee_points' => '' , 'totalearnedpoints' => $points_to_award , 'totalredeempoints' => 0 ) ;
                    $new_obj->total_points_management ( $valuestoinsert ) ;
                    RSFunctionForSavingMetaValues::rewardsystem_update_user_meta ( $current_user_id , 'rs_bp_groupcomment_check' . $post_id , '1' ) ;
                }
            }
        }

        public static function rs_Buddypress_post_create( $content , $userid , $activity_id ) {
            $new_obj                  = new RewardPointsOrder ( $order_id                 = 0 , 'no' ) ;
            $current_user_id          = get_current_user_id () ;
            $rs_bp_post_create_points = get_option ( 'rs_points_for_bp_post_create' ) ;
            if ( self::rs_Buddypress_group_create_restriction ( 'rs_bp_post_creation' , $rs_bp_post_create_points ) ) {
                $points_to_award = RSMemberFunction::user_role_based_reward_points ( $current_user_id , $rs_bp_post_create_points ) ;
                $event_slug      = 'RPFBP' ;
                $equearnamt      = RSPointExpiry::earning_conversion_settings ( $points_to_award ) ;
                $valuestoinsert  = array ( 'pointstoinsert' => $points_to_award , 'pointsredeemed' => 0 , 'event_slug' => $event_slug , 'equalearnamnt' => $equearnamt , 'equalredeemamnt' => 0 , 'user_id' => $current_user_id , 'referred_id' => '' , 'product_id' => '' , 'variation_id' => '0' , 'reasonindetail' => '' , 'nominee_id' => '' , 'nominee_points' => '' , 'totalearnedpoints' => $points_to_award , 'totalredeempoints' => 0 ) ;
                $new_obj->total_points_management ( $valuestoinsert ) ;
            }
        }

    }

    RSBuddypress_compatibility::init () ;
}
?>